/*****************************************************************************/

/*
 *      lex.l  --  Lexer for STP router configuration file.
 *
 *      Copyright (C) 2000
 *        Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*****************************************************************************/

%{

#include <stdio.h>

#include "stp.h"
#include "parse.h"

%}

label							[[:alpha:]_][[:alnum:]_]*

%%

\".*\"							{ return TOK_STRING; }

{label}							{ return find_token(); }

([0-9])+						{ return TOK_INTVAL; }

[ \t]+							{ /*return ' ';*/ }
\n							{ BEGIN(INITIAL); stpconf_lineno++; }
(#|\/\/).*$							{ }
.							{ return yytext[0]; }

%%

static int yywrap(void)
{
        return 1;
}

