/*
 * phase3c.c
 *
 * Copyright (C) 1994 Klaus Kudielka
 *
 * This program reads the AO-13 512-byte blocks from stdin
 * and displays the formatted output on stdout.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <stdio.h>
#include <math.h>


/* Display block */

#define C(n)  ((unsigned char)block[384+n])
#define Cs(n) ((signed char)block[384+n])
#define Cx(n) (Cs(n)>=64?Cs(n)-256:Cs(n))
#define T(n)  ((C(n)-120)/1.71)
#define I1(n) ((C(n)-15)*4.854)
#define I2(n) ((C(n)-15)*12.135)
#define I3(n) ((C(n)-15)*24.27)


void display_block(char *block)
{
  int row;

  putchar('\n');
  switch (block[0])
  {
    case 'K':
      fwrite(block, 64, 1, stdout); putchar('\n');
      fwrite(block+7*64, 64, 1, stdout); putchar('\n');
      break;
    case 'Q':
      for (row = 0; row < 3; row++)
      {
	fwrite(block+row*64, 64, 1, stdout); putchar('\n');
      }
      printf("** Ts ARM 1 ** PANEL-1  %5.1f RX-U     %5.1f RX-L     %5.1f WALL-1   %5.1f\n",
	     T(0x22), T(0x02), T(0x29), T(0x35));
      printf("TOP      %5.1f BOTTOM   %5.1f TX-U     %5.1f TX-L     %5.1f TX-S     %5.1f\n",
	     T(0x2e), T(0x32), T(0x06), T(0x25), T(0x39));
      printf("** Ts ARM 2 ** PANEL-3  %5.1f SEU      %5.1f LSENSOR  %5.1f WALL-2   %5.1f\n",
	     T(0x26), T(0x12), T(0x3a), T(0x31));
      printf("BCR      %5.1f AUXBAT-1 %5.1f AUXBAT-2 %5.1f\n",
	     T(0x0e), T(0x16), T(0x1a));
      printf("** Ts ARM 3 ** PANEL-5  %5.1f HELIUM   %5.1f IHU      %5.1f RUDAK    %5.1f\n",
	     T(0x2a), T(0x21), T(0x0a), T(0x2d));
      printf("MAINBAT  %5.1f NUTNDAMP %5.1f ** Ts CENTR ** N2O4     %5.1f AZ50     %5.1f\n",
	     T(0x1e), T(0x3e), T(0x36), T(0x3d));
      printf("** VOLTAGES ** BCR-SIN  %5.1f BCR-IN   %5.1f BCR-SOUT %5.1f BCR-OUT  %5.1f\n",
	     29.1+Cs(0x44)*0.1, (C(0x00)-10)*0.167, 14.98+Cx(0x45)*0.02,
	     (C(0x04)-10)*0.0795);
      printf("14V-ST   %5.1f AUXBAT   %5.1f 10V-COMP %5.1f 9V-U     %5.1f 9V-L     %5.1f\n",
	     (C(0x2c)-10)*0.0668, (C(0x38)-10)*0.0785, (C(0x08)-10)*0.0532,
	     (C(0x30)-10)*0.054, (C(0x3c)-10)*0.0454);
      printf("** CURRENTS ** BCR-IN   %5.0f BATCHARG %5.0f BCR-OUT  %5.0f 14V-ST   %5.0f\n",
	     I2(0x1b), I2(0x13), I3(0x17), I3(0x07));
      printf("14V-S    %5.0f 10V-C    %5.0f PANEL-1  %5.0f PANEL-2  %5.0f PANEL-3  %5.0f\n",
	     I1(0x0b), I1(0x0f), I1(0x33), I1(0x2f), I1(0x2b));
      printf("PANEL-4  %5.0f PANEL-5  %5.0f PANEL-6  %5.0f\n",
	     I1(0x27), I1(0x23), I1(0x1f));
      printf("**  POWERS  ** TX-OUT-U %5.1f TX-OUT-L %5.1f\n",
	     pow(287-C(0x20),2)/1796, pow(261-C(0x01),2)/724);
      printf("**  AGC-dB  ** RX-U-AGC %5.1f RX-L-AGC %5.1f\n",
	     pow(C(0x24)-71,2)/2465, pow(C(0x1d)-75,2)/1125);
   break;
    default:
      for (row = 0; row < 8; row++)
      {
	fwrite(block+row*64, 64, 1, stdout); putchar('\n');
      }
  }
}


/* Main program */

int main(int argc, char **argv)
{
  char block[512];

  if (argc != 1)
  {
    fprintf(stderr, "Usage: [z]cat file | %s\n", argv[0]);
    return 1;
  }

  while (!feof(stdin))
    if (fread(block, 512, 1, stdin) == 1)
      display_block(block);

   return 0;
}

