#include "AddMessageBase.h"
#include "AddMessage.moc"

#include <qtooltip.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlistbox.h>

#include <kapplication.h>
#include <klocale.h>
#include <kurlrequester.h>

#include <stdlib.h>

AddMessage::AddMessage(ftpaccess *f, bool rdm, 
		       QWidget * parent, char * wname)
 : KDialogBase(parent, wname, true, QString::null,
                KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true)
{
	mWidget = new AddMessageBase(this);
	setMainWidget(mWidget);
	ftpxs=f;
	readme=rdm;
	if(rdm)
		setCaption(i18n("Add Readme"));
	else
		setCaption(i18n("Add Message"));

	QToolTip::add(mWidget->atLogin,i18n("Message will be displayed after a user logs in.\nThe file has to be relative to the chrooted directory for anonymous/guest users."));
	QToolTip::add(mWidget->atCwd,i18n("Message will be displayed when a user enters the specified directory.\nPath has to be relative to chroot for anonymous/guest users."));
	QToolTip::add(mWidget->filename,i18n("Filename of the message file - remember to make this relative to chroot!"));
	QToolTip::add(mWidget->dir,i18n("Directory in which the message will be displayed.\nMay be globbed: For example * means show in every directory.\nThis is especially useful if you're using ratios."));
	QToolTip::add(mWidget->selClasses,i18n("The message will be displayed only to members of the classes below."));

	mWidget->classes->setMultiSelection(true);
	mWidget->filename->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::File);
	mWidget->dir->setMode(KFile::ExistingOnly | KFile::LocalOnly | KFile::Directory);
	mWidget->atLogin->setChecked(true);

	ftpclass *c=0;
	mWidget->classes->clear();
	while((c=ftpxs->getNextClass(c)))
		mWidget->classes->insertItem(c->getName());
	QToolTip::add(mWidget->classes,i18n("The message will be displayed to members of the classes selected here."));
}

AddMessage::~AddMessage()
{
}

void AddMessage::slotOk()
{
	QString cls;
	if(mWidget->selClasses->isChecked()) {
		QListBox *classes = mWidget->classes;
		for(unsigned int i=0;i<classes->count();i++)
			if(classes->isSelected(i)) {
				cls = classes->text(i) + ' ';
			}
		if(!cls.isEmpty())
			cls.truncate(cls.length() -1); // remove last space
	}
	message=new ftpmessage(readme,mWidget->atLogin->isChecked(),mWidget->filename->url(),mWidget->dir->url(),cls);
	emit MessageAdded(readme,message);
	accept();
}
