/***************************************************************************
                            KMenuBar.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KMENUBAR_H
#define KMENUBAR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QMenuBar.h>

/**

 KDE Style-able menubar.

 This is required since @ref QMenuBar is currently not handled by
 @ref QStyle.

 @author Daniel "Mosfet" Duley.

 @version $Id: KMenuBar.h,v 1.3 2002/03/15 02:12:21 rdale Exp $

 @short 
 KDE Style-able menubar.
*/
@interface KMenuBar : QMenuBar 
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;
- (void) dealloc;

/** 
 This controls whether or not this menubar will be a top-level
 bar similar to the way Macintosh handles menubars.  This
 overrides any global config settings.

 Keep in mind that it is probably a really bad idea to use this
 unless you really know what you're doing.  A feature like a
 top-level menubar is one that should really be shared by all
 applications.  If your app is the only one with a top-level
 bar, then things might look very... odd.

 This is included only for those people that @p do know that
 they need to use it.

*/
- setTopLevelMenu: (BOOL)top_level;
- setTopLevelMenu;

/** 
 Is our menubar a top-level (Macintosh style) menubar?

*/
- (BOOL) isTopLevelMenu;
- show;
- (BOOL) eventFilter: (QObject *)arg1 event: (QEvent *)arg2;
- slotReadConfig;
@end

/** Override these methods in subclasses of KMenuBar to customise event handling behaviour */
@protocol KMenuBarEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
