/***************************************************************************
                            KSocket.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSOCKET_H
#define KSOCKET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**
 
 You can connect this socket to any Internet address. 

 The socket gives you three signals: When ready for reading, 
 ready for writing or if the connection is broken.  
 Using @ref -socket you get a file descriptor
 which you can use with the usual UNIX function like @ref -write or
  @ref -read. 
 If you have already such a socket identifier you can construct a KSocket
 on this identifier. 

 If @ref -socket delivers a value of -1 or less, the connection 
 was not successful.

 @author Torben Weis <weis@uni-frankfurt.de>

 @version $Id: KSocket.h,v 1.4 2002/03/23 10:57:57 rdale Exp $

 @short A TCP/IP client socket.
 
*/
@interface KSocket : QObject 

/**  
 Constructs a KSocket with the provided file descriptor.

*/
- initWithInt: (int)_sock;

/**  
 Creates a socket and connects to a host.

*/
- initWithText: (NSString *)_host _port: (unsigned short)_port timeOut: (int)timeOut;
- initWithText: (NSString *)_host _port: (unsigned short)_port ;

/**  
 Connects to a UNIX domain socket.

*/
- initWithText: (NSString *)_path;

/**  
 Destructor. Closes the socket if it is still open.
     
*/
- (void) dealloc;

/**  
 Returns a file descriptor for this socket.
 Returns -1 when an error occured.
     
*/
- (int) socket;

/**  
 Enables the socket for reading.

 If you enable read mode, the socket will emit the signal
 @ref -readEvent whenever there is something to read out of this
 socket.
     
*/
- enableRead: (BOOL)arg1;

/**  
 Enables the socket for writing.

 If you enable write mode, the socket will emit the signal
 @ref -writeEvent whenever the socket is ready for writing.

 Warning: If you forget to call enableWrite(false) when you are
 not ready to send data, you will get lots of -writeEvent signals,
 in the order of thousands a second !
     
*/
- enableWrite: (BOOL)arg1;

/** 
 Return address.
 This function is dumb. Don't ever use it
 if you need the peer address of this socket, use @ref -[KExtendedSocket peerAddress]
 instead

     
*/
- (unsigned long) ipv4_addr;

/**  
 Connected to the writeNotifier.

 Called when
  the socket is ready for writing.
     
*/
- slotWrite: (int)arg1;

/**  
 Connected to the readNotifier.

 Called when
  the socket is ready for reading.
     
*/
- slotRead: (int)arg1;

/** 
  A small wrapper around @ref -gethostbyname and such.
  Don't use this in new programs. Use @ref -[KExtendedSocket lookup]
      
*/
+ (BOOL) initSockaddr: (void*)server_name hostname: (NSString *)hostname port: (unsigned short)port domain: (int)domain;
+ (BOOL) initSockaddr: (void*)server_name hostname: (NSString *)hostname port: (unsigned short)port ;
- (BOOL) connect: (NSString *)_host _port: (unsigned short)_port timeout: (int)timeout;
- (BOOL) connect: (NSString *)_host _port: (unsigned short)_port ;
- (BOOL) connect: (NSString *)_path;
@end

/** Override these methods in subclasses of KSocket to customise event handling behaviour */
@protocol KSocketEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
