namespace Binge.Bits
{
	using System;
	using System.Collections;

	public enum PassingConvention
	{
		Default,
		Value,
		Pointer,
		PointerToPointer,
		Reference
	}

	public class Parameter: Binge.Bits.Object, ICloneable
	{
		public ArrayList Attributes;
		public PassingConvention PassBy;
		public string NativeName, TargetName, MarshallName;
		public string NativeType, TargetType, MarshallType;
		public bool IsConst;
		public string Default;

		public Parameter (): this (true) {}

		public Parameter (bool init)
		{
			if (! init) return;

			Attributes = new ArrayList ();
			PassBy = PassingConvention.Default;
			NativeName = TargetName = MarshallName = String.Empty;
			NativeType = TargetType = MarshallType = String.Empty;
			IsConst = false;
			Default = String.Empty;
		}

		public override string ToString ()
		{
			return "Parameter";
		}

		public object Clone ()
		{
			Parameter p = MemberwiseClone () as Parameter;
			p.Attributes = Attributes.Clone () as ArrayList;
			return p as object;
		}
	}
}
