/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmclippedby.h"
#include "pmclippedbyedit.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"

#include <klocale.h>

#include <kdebug.h>
#include "pmglobals.h"

PMClippedBy::PMClippedBy( )
      : Base( )
{
}

PMClippedBy::~PMClippedBy( )
{
}

bool PMClippedBy::isA( PMObjectType t ) const
{
   if( t == PMTClippedBy )
      return true;
   return Base::isA( t );
}

QString PMClippedBy::description( ) const
{
   return i18n( "clipped by" );
}

bool PMClippedBy::canInsert( PMObjectType t, const PMObject* /*after*/,
                             const PMObjectList* /*objectsBetween*/ ) const
{
   switch( t )
   {
      case PMTComment:
      case PMTBox:
      case PMTBlob:
      case PMTCone:
      case PMTCylinder:
      case PMTHeightField:
      case PMTJuliaFractal:
      case PMTLathe:
      case PMTPrism:         
      case PMTSphere:
      case PMTSuperquadricEllipsoid:
      case PMTSurfaceOfRevolution:
      case PMTText:
      case PMTTorus:
      case PMTPlane:
      case PMTPolynom:
      case PMTRaw:
      case PMTObjectLink:
         return true;
      default:
         break;
   }
   return false;
}

bool PMClippedBy::boundedBy( ) const
{
   bool cb = true;
   PMObject* o = firstChild( );
   
   for( ; o && cb; o = o->nextSibling( ) )
      if( o->type( ) != PMTComment )
         cb = false;
   
   return cb;
}

void PMClippedBy::serialize( PMOutputDevice& dev ) const
{
   dev.objectBegin( "clipped_by" );
   if( boundedBy( ) )
      dev.writeLine( "bounded_by" );
   Base::serialize( dev );
   dev.objectEnd( );
}

void PMClippedBy::serialize( QDomElement& e, QDomDocument& doc ) const
{
   // no extra data at the moment
   Base::serialize( e, doc );
}

void PMClippedBy::readAttributes( const PMXMLHelper& h )
{
   // no extra data at the moment
   Base::readAttributes( h );
}

PMDialogEditBase* PMClippedBy::editWidget( QWidget* parent ) const
{
   return new PMClippedByEdit( parent );
}

void PMClippedBy::childRemoved( PMObject* o )
{
   Base::childRemoved( o );

   // add a dummy change
   if( m_pMemento )
      m_pMemento->addData( PMTClippedBy, PMBoundedByID, true );
}

void PMClippedBy::childAdded( PMObject* o )
{
   Base::childAdded( o );

   if( m_pMemento )
      m_pMemento->addData( PMTClippedBy, PMBoundedByID, true );
}
