/***************************************************************************
                          vumeter.h  -  description
                             -------------------
    begin                : Mon Jul 22 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VUMETER_H
#define VUMETER_H

#include <qframe.h>
class KToolBar;
class QColor;

/// VU-Meter
/**
		A beautiful VU-Meter which is used in the ToolBar for the
		Main-Recordinglevel after all effects.

		@author Arnold Krille
  */

class VUMeter : public QFrame  {
   Q_OBJECT
public:
	/// Constructor
	VUMeter(KToolBar *parent, const char *name=0);
	/// Destructor
	~VUMeter();
public slots:
	/// Draws the VU-Meter inside its frame.
	void drawContents( QPainter *p );
	//void drawFrame( QPainter *p ) {}
	/// Sets the new Values for the VU-Meter.
	void newSValue( float left, float right );
private:
	float i_left, i_right;
	QColor color( float value );
};

#endif
