/*
 *   kaphorism - aphorisms to be read from file
 *   $Id: kaphorism.cpp,v 1.5 2001/11/03 07:57:57 mlaurent Exp $
 *   Copyright (C) 1998,2000  Hans Dijkema
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <kdebug.h>

#include <stdio.h>
#include <stdlib.h>

#include "kaphorism.h"
#include <qpopupmenu.h>
#include <qdatetime.h>

kaphorism::kaphorism(KConfigBase *cnf,QWidget *parent)
  : kaphorism_widget(parent)
{
QString file,path;
  conf=cnf;
  conf->setGroup("aphorisms");
  file=conf->readEntry("file","Seelenkalender");
  file="kaphorism/aphorisms/"+file;
  path=locate("data",file);
  if (path.isNull()) {
    kdFatal() << "couldn't find " << file <<". Exiting.\n";
  }

  {QString path="kaphorism/kaphorism.rc";
   path=locate("data",path);
    if (path.isNull()) {
      kdFatal() << "couldn't find " << path <<". Exiting.\n";
    }
    KSimpleConfig  c(path);
    int            N,i;
      c.setGroup("files");
      N=c.readNumEntry("n",0);
      for(i=0;i<N;i++) {QString grp;
        grp.sprintf("%d",i+1);
        c.setGroup(grp);
        choices[i]=c.readEntry("file","");
      }
  }

  setChoices();

  pic=NULL;
  aphorisms=NULL;
  current=path;
  loaded=false;
  load();
}

void kaphorism::load(void)
{
  if (!loaded) {
    load(current);
    loaded=true;
  }
}

void kaphorism::load(QString path)
{
QString rc=path+".rc",png=path+".png";

  if (aphorisms!=NULL) { delete aphorisms; }
  aphorisms=new KSimpleConfig(rc,true);

  aphorisms->setGroup("aphorism");
  author=aphorisms->readEntry("author","");
  title=aphorisms->readEntry("title","");

  if (pic!=NULL) { delete pic; }
  printf("%s\n",png.latin1());
  pic = new QPixmap(png);

  {FILE   *f;
   bool    goOn=true;
   int     i;

    printf("%s\n",path.latin1());
    f=fopen(path.latin1(),"rb");

    for (i=0;goOn;i++) {QString strofe;
                         int     k;
                         char    line[1024];
       fgets(line,1023,f);
       spreuken[i].from=atoi(line);
       fgets(line,1023,f);
       spreuken[i].to=atoi(line);
       k=0;
       spreuken[i]._spreuk="";
       while((goOn=fgets(line,1023,f)!=NULL) && line[0]!='#') {
         strofe=line;
         strofe=strofe.stripWhiteSpace();
         if (k!=0) { spreuken[i]._spreuk+="\n"; }
         spreuken[i]._spreuk+=strofe;
         k+=1;
       }
    }
    printf("%d\n",i);
    spreuken[i].from=0;spreuken[i].to=0;

    fclose(f);
  }
}

kaphorism::~kaphorism()
{
  delete aphorisms;
}

void kaphorism::choose(QString s)
{
  conf->setGroup("aphorisms");
  conf->writeEntry("file",s);
}

QString kaphorism::choice(int i)
{
  if (i>=choices.len()) { QString s=""; return s; }
  else { return choices[i]; }
}

void kaphorism::loadNew(QString file)
{
QString path;
  file="kaphorism/aphorisms/"+file;
  path=locate("data",file);
  if (path.isNull()) {
    kdFatal() << "couldn't find " << file <<". Exiting.\n";
  }
  load(path);
  current=path;
}

QPixmap *kaphorism::pixmap(void)
{
return pic;
}

QString kaphorism::gebeAuteur(void)
{
return author;
}

QString kaphorism::gebeSpruch(void)
{
QString s;

  load();

  datum=QDate::currentDate();
  int cmp=(datum.month()*100)+datum.day();

  int i;
  for(i=0;spreuken[i].from!=0 && spreuken[i].to!=0 &&
         (cmp<spreuken[i].from || cmp>spreuken[i].to);
      i++
     );

  if (spreuken[i].from==0 || spreuken[i].to==0) {
     s="Geen spreuk!";
  }
  else {
     s=spreuken[i]._spreuk;
  }

return s;
}


#include "kaphorism.moc"
