/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Transforms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class SelectTx
extends AnimatingControlsSurface {
    protected static final int RIGHT = 0;
    private static final int LEFT = 1;
    private static final int XMIDDLE = 2;
    private static final int DOWN = 3;
    private static final int UP = 4;
    private static final int YMIDDLE = 5;
    private static final int XupYup = 6;
    private static final int XdownYdown = 7;
    private static final String[] title = new String[]{"Scale", "Shear", "Rotate"};
    private Image img;
    private Image original;
    private int iw;
    private int ih;
    protected static final int SCALE = 0;
    protected static final int SHEAR = 1;
    protected static final int ROTATE = 2;
    protected int transformType = 1;
    protected double sx;
    protected double sy;
    protected double angdeg;
    protected int direction = 0;
    protected int transformToggle;

    public SelectTx() {
        this.setBackground(Color.white);
        this.original = this.getImage("painting.gif");
        this.iw = this.original.getWidth(this);
        this.ih = this.original.getHeight(this);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void reset(int n, int n2) {
        this.iw = n / 3;
        this.ih = n2 / 3;
        this.img = this.createImage(this.iw, this.ih);
        Graphics graphics = this.img.getGraphics();
        graphics.drawImage(this.original, 0, 0, this.iw, this.ih, Color.orange, null);
        if (this.transformType == 0) {
            this.direction = 0;
            this.sy = 1.0;
            this.sx = 1.0;
        } else if (this.transformType == 1) {
            this.direction = 0;
            this.sy = 0.0;
            this.sx = 0.0;
        } else {
            this.angdeg = 0.0;
        }
    }

    public void step(int n, int n2) {
        int n3 = this.iw + 10;
        int n4 = this.ih + 10;
        if (this.transformType == 0 && this.direction == 0) {
            this.sx += 0.05;
            if ((double)n * 0.5 - (double)this.iw * 0.5 + (double)n3 * this.sx + 10.0 > (double)n) {
                this.direction = 3;
            }
        } else if (this.transformType == 0 && this.direction == 3) {
            this.sy += 0.05;
            if ((double)n2 * 0.5 - (double)this.ih * 0.5 + (double)n4 * this.sy + 20.0 > (double)n2) {
                this.direction = 1;
            }
        } else if (this.transformType == 0 && this.direction == 1) {
            this.sx -= 0.05;
            if ((double)n3 * this.sx - 10.0 <= -((double)n * 0.5 - (double)this.iw * 0.5)) {
                this.direction = 4;
            }
        } else if (this.transformType == 0 && this.direction == 4) {
            this.sy -= 0.05;
            if ((double)n4 * this.sy - 20.0 <= -((double)n2 * 0.5 - (double)this.ih * 0.5)) {
                this.direction = 0;
                this.transformToggle = 1;
            }
        }
        if (this.transformType == 1 && this.direction == 0) {
            this.sx += 0.05;
            if ((double)n3 + (double)(2 * n4) * this.sx + 20.0 > (double)n) {
                this.direction = 1;
                this.sx -= 0.1;
            }
        } else if (this.transformType == 1 && this.direction == 1) {
            this.sx -= 0.05;
            if ((double)n3 - (double)(2 * n4) * this.sx + 20.0 > (double)n) {
                this.direction = 2;
            }
        } else if (this.transformType == 1 && this.direction == 2) {
            this.sx += 0.05;
            if (this.sx > 0.0) {
                this.direction = 3;
                this.sx = 0.0;
            }
        } else if (this.transformType == 1 && this.direction == 3) {
            this.sy -= 0.05;
            if ((double)n4 - (double)(2 * n3) * this.sy + 20.0 > (double)n2) {
                this.direction = 4;
                this.sy += 0.1;
            }
        } else if (this.transformType == 1 && this.direction == 4) {
            this.sy += 0.05;
            if ((double)n4 + (double)(2 * n3) * this.sy + 20.0 > (double)n2) {
                this.direction = 5;
            }
        } else if (this.transformType == 1 && this.direction == 5) {
            this.sy -= 0.05;
            if (this.sy < 0.0) {
                this.direction = 6;
                this.sy = 0.0;
            }
        } else if (this.transformType == 1 && this.direction == 6) {
            this.sx += 0.05;
            this.sy += 0.05;
            if ((double)n3 + (double)(2 * n4) * this.sx + 30.0 > (double)n || (double)n4 + (double)(2 * n3) * this.sy + 30.0 > (double)n2) {
                this.direction = 7;
            }
        } else if (this.transformType == 1 && this.direction == 7) {
            this.sy -= 0.05;
            this.sx -= 0.05;
            if (this.sy < 0.0) {
                this.direction = 0;
                this.sy = 0.0;
                this.sx = 0.0;
                this.transformToggle = 2;
            }
        }
        if (this.transformType == 2) {
            this.angdeg += 5.0;
            if (this.angdeg == 360.0) {
                this.angdeg = 0.0;
                this.transformToggle = 0;
            }
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(title[this.transformType], font, fontRenderContext);
        graphics2D.setColor(Color.black);
        textLayout.draw(graphics2D, (float)((double)(n / 2) - textLayout.getBounds().getWidth() / 2.0), textLayout.getAscent() + textLayout.getDescent());
        if (this.transformType == 2) {
            String string = Double.toString(this.angdeg);
            graphics2D.drawString("angdeg=" + string, 2, n2 - 4);
        } else {
            String string = Double.toString(this.sx);
            string = string.length() < 5 ? string : string.substring(0, 5);
            TextLayout textLayout2 = new TextLayout("sx=" + string, font, fontRenderContext);
            textLayout2.draw(graphics2D, 2.0f, n2 - 4);
            string = Double.toString(this.sy);
            string = string.length() < 5 ? string : string.substring(0, 5);
            graphics2D.drawString("sy=" + string, (int)(textLayout2.getBounds().getWidth() + 4.0), n2 - 4);
        }
        if (this.transformType == 0) {
            graphics2D.translate(n / 2 - this.iw / 2, n2 / 2 - this.ih / 2);
            graphics2D.scale(this.sx, this.sy);
        } else if (this.transformType == 1) {
            graphics2D.translate(n / 2 - this.iw / 2, n2 / 2 - this.ih / 2);
            graphics2D.shear(this.sx, this.sy);
        } else {
            graphics2D.rotate(Math.toRadians(this.angdeg), n / 2, n2 / 2);
            graphics2D.translate(n / 2 - this.iw / 2, n2 / 2 - this.ih / 2);
        }
        graphics2D.setColor(Color.orange);
        graphics2D.fillRect(0, 0, this.iw + 10, this.ih + 10);
        graphics2D.drawImage(this.img, 5, 5, this);
    }

    public static void main(String[] stringArray) {
        SelectTx.createDemoFrame(new SelectTx());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        SelectTx demo;
        JToolBar toolbar;

        public DemoControls(SelectTx selectTx) {
            super(selectTx.name);
            this.demo = selectTx;
            this.setBackground(Color.gray);
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Scale", false);
            this.addTool("Shear", true);
            this.addTool("Rotate", false);
        }

        public void addTool(String string, boolean bl) {
            JButton jButton = (JButton)this.toolbar.add(new JButton(string));
            jButton.setBackground(bl ? Color.green : Color.lightGray);
            jButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < this.toolbar.getComponentCount(); ++i) {
                JButton jButton = (JButton)this.toolbar.getComponentAtIndex(i);
                jButton.setBackground(Color.lightGray);
            }
            JButton jButton = (JButton)actionEvent.getSource();
            jButton.setBackground(Color.green);
            if (jButton.getText().equals("Scale")) {
                this.demo.transformType = 0;
                this.demo.direction = 0;
                this.demo.sy = 1.0;
                this.demo.sx = 1.0;
            } else if (jButton.getText().equals("Shear")) {
                this.demo.transformType = 1;
                this.demo.direction = 0;
                this.demo.sy = 0.0;
                this.demo.sx = 0.0;
            } else if (jButton.getText().equals("Rotate")) {
                this.demo.transformType = 2;
                this.demo.angdeg = 0.0;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 36);
        }

        public void run() {
            Thread thread = Thread.currentThread();
            this.demo.transformToggle = this.demo.transformType;
            while (this.thread == thread) {
                try {
                    Thread.sleep(222L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (this.demo.transformToggle == this.demo.transformType) continue;
                ((JButton)this.toolbar.getComponentAtIndex(this.demo.transformToggle)).doClick();
            }
            this.thread = null;
        }
    }
}

