/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12PropertyAction;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

class Platform {
    private static final String libNameMain = "jsound";
    private static final String libNameALSA = "jsoundalsa";
    private static final String libNameDSound = "jsoundds";
    private static final String libNameSolMIDI = "jsoundsolmidi";
    public static final int LIB_MAIN = 1;
    public static final int LIB_ALSA = 2;
    public static final int LIB_DSOUND = 4;
    public static final int LIB_SOLMIDI = 8;
    private static int loadedLibs = 0;
    public static final int FEATURE_MIDIIO = 1;
    public static final int FEATURE_PORTS = 2;
    public static final int FEATURE_DIRECT_AUDIO = 3;
    private static boolean signed8;
    private static boolean bigEndian;
    private static String javahome;
    private static String classpath;
    private static JSSecurity jsSecurity;
    private static boolean securityPrivilege;

    static {
        jsSecurity = null;
        securityPrivilege = false;
        Method[] methodArray = new Method[1];
        Class[] classArray = new Class[1];
        Object[][] objectArray = new Object[1][0];
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
            securityPrivilege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (securityPrivilege && jsSecurity != null) {
            if (!(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity.getName().startsWith("JDK12")) {
                    Platform.loadLibraries();
                    Platform.readProperties();
                } else {
                    try {
                        jsSecurity.requestPermission(methodArray, classArray, objectArray, 1);
                        methodArray[0].invoke(classArray[0], objectArray[0]);
                        jsSecurity.requestPermission(methodArray, classArray, objectArray, 64);
                        methodArray[0].invoke(classArray[0], objectArray[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Platform.loadLibraries();
                    Platform.readProperties();
                }
            }
        } else {
            Platform.loadLibraries();
            Platform.readProperties();
        }
    }

    private Platform() {
    }

    static void initialize() {
    }

    private static void loadLibraries() {
        Platform.loadLibrary(libNameMain);
        loadedLibs |= 1;
        String string = Platform.nGetExtraLibraries();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                Platform.loadLibrary(string2);
                if (string2.equals(libNameALSA)) {
                    loadedLibs |= 2;
                    continue;
                }
                if (string2.equals(libNameDSound)) {
                    loadedLibs |= 4;
                    continue;
                }
                if (!string2.equals(libNameSolMIDI)) continue;
                loadedLibs |= 8;
            }
            catch (Throwable throwable) {}
        }
    }

    private static void readProperties() {
        bigEndian = Platform.nIsBigEndian();
        signed8 = Platform.nIsSigned8();
        if (securityPrivilege && jsSecurity != null) {
            if (jsSecurity.getName().startsWith("JDK12")) {
                try {
                    Constructor constructor = JDK12PropertyAction.cons;
                    javahome = (String)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[]{"java.home"})});
                    classpath = (String)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[]{"java.class.path"})});
                }
                catch (Exception exception) {
                    javahome = System.getProperty("java.home");
                    classpath = System.getProperty("java.class.path");
                }
            } else {
                javahome = jsSecurity.readProperty("java.home");
                classpath = jsSecurity.readProperty("java.class.path");
            }
        } else {
            javahome = System.getProperty("java.home");
            classpath = System.getProperty("java.class.path");
        }
    }

    static boolean isBigEndian() {
        return bigEndian;
    }

    static boolean isDirectAudioEnabled() {
        return Platform.isFeatureLibLoaded(3);
    }

    static boolean isMidiIOEnabled() {
        return Platform.isFeatureLibLoaded(1);
    }

    static boolean isPortsEnabled() {
        return Platform.isFeatureLibLoaded(2);
    }

    static boolean isSigned8() {
        return signed8;
    }

    private static native boolean nIsBigEndian();

    private static native boolean nIsSigned8();

    private static native int nGetLibraryForFeature(int var0);

    private static boolean isFeatureLibLoaded(int n2) {
        int n3 = Platform.nGetLibraryForFeature(n2);
        boolean bl2 = n3 != 0 && (loadedLibs & n3) == n3;
        return bl2;
    }

    static String getClasspath() {
        return classpath;
    }

    static String getJavahome() {
        return javahome;
    }

    private static native String nGetExtraLibraries();

    private static void loadLibrary(String string) {
        if (securityPrivilege) {
            if (jsSecurity != null) {
                jsSecurity.loadLibrary(string);
            } else {
                System.loadLibrary(string);
            }
        }
    }
}

