/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunFileReader;
import com.sun.media.sound.WaveFileFormat;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveFileReader
extends SunFileReader {
    private static final int MAX_READ_LENGTH = 12;
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            audioFileFormat = this.getFMT(fileInputStream, false);
        }
        finally {
            fileInputStream.close();
        }
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getFMT(inputStream, true);
        inputStream.reset();
        return audioFileFormat;
    }

    private AudioFileFormat getFMT(InputStream inputStream, boolean bl2) throws UnsupportedAudioFileException, IOException {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        short s2 = 0;
        AudioFormat.Encoding encoding = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (bl2) {
            dataInputStream.mark(12);
        }
        int n6 = dataInputStream.readInt();
        int n7 = this.rllong(dataInputStream);
        int n8 = dataInputStream.readInt();
        if (n7 <= 0) {
            n7 = -1;
            n3 = -1;
        } else {
            n3 = n7 + 8;
        }
        if (n6 != 1380533830 || n8 != 1463899717) {
            if (bl2) {
                dataInputStream.reset();
            }
            throw new UnsupportedAudioFileException("not a WAVE file");
        }
        try {
            while (true) {
                int n9 = dataInputStream.readInt();
                n4 += 4;
                if (n9 != 1718449184) {
                    n5 = this.rllong(dataInputStream);
                    n4 += 4;
                    if (n5 % 2 > 0) {
                        ++n5;
                    }
                    n4 += dataInputStream.skipBytes(n5);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        n5 = this.rllong(dataInputStream);
        int n10 = (n4 += 4) + n5;
        s2 = this.rlshort(dataInputStream);
        n4 += 2;
        if (s2 == 1) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if (s2 == 6) {
            encoding = AudioFormat.Encoding.ALAW;
        } else if (s2 == 7) {
            encoding = AudioFormat.Encoding.ULAW;
        } else {
            throw new UnsupportedAudioFileException("Not a supported WAV file");
        }
        short s3 = this.rlshort(dataInputStream);
        n4 += 2;
        long l2 = this.rllong(dataInputStream);
        n4 += 4;
        long l3 = this.rllong(dataInputStream);
        n4 += 4;
        short s4 = this.rlshort(dataInputStream);
        n4 += 2;
        short s5 = this.rlshort(dataInputStream);
        n4 += 2;
        if (s5 == 8 && encoding == AudioFormat.Encoding.PCM_SIGNED) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (n5 % 2 != 0) {
            ++n5;
        }
        if (n10 > n4) {
            n4 += dataInputStream.skipBytes(n10 - n4);
        }
        n4 = 0;
        try {
            while (true) {
                n2 = dataInputStream.readInt();
                n4 += 4;
                if (n2 != 1684108385) {
                    int n11 = this.rllong(dataInputStream);
                    n4 += 4;
                    if (n11 % 2 > 0) {
                        ++n11;
                    }
                    n4 += dataInputStream.skipBytes(n11);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        n2 = this.rllong(dataInputStream);
        n4 += 4;
        AudioFormat audioFormat = new AudioFormat(encoding, l2, s5, s3, s5 * s3 / 8, l2, false);
        return new WaveFileFormat(AudioFileFormat.Type.WAVE, n3, audioFormat, n2 / audioFormat.getFrameSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = uRL.openStream();
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getFMT(inputStream, false);
        }
        finally {
            inputStream.close();
        }
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getFMT(fileInputStream, false);
        }
        finally {
            if (audioFileFormat == null) {
                fileInputStream.close();
            }
        }
        return new AudioInputStream(fileInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getFMT(inputStream, true);
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = uRL.openStream();
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getFMT(inputStream, false);
        }
        finally {
            if (audioFileFormat == null) {
                inputStream.close();
            }
        }
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }
}

