/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.math.BigInteger;
import java.util.Arrays;
import sun.awt.image.BufImgSurfaceData;

public class IndexColorModel
extends ColorModel {
    private int[] rgb;
    private int map_size;
    private int transparent_index = -1;
    private boolean allgrayopaque;
    private BigInteger validBits;
    private static int[] opaqueBits = new int[]{8, 8, 8};
    private static int[] alphaBits = new int[]{8, 8, 8, 8};
    private static final int CACHESIZE = 40;
    private int[] lookupcache = new int[40];

    public final int getMapSize() {
        return this.map_size;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public final int getTransparentPixel() {
        return this.transparent_index;
    }

    static {
        ColorModel.loadLibraries();
        IndexColorModel.initIDs();
    }

    public void finalize() {
        BufImgSurfaceData.freeNativeICMData(this);
    }

    private static native void initIDs();

    public boolean isValid() {
        return this.validBits == null;
    }

    public int[] getComponentSize() {
        if (this.nBits == null) {
            if (this.supportsAlpha) {
                this.nBits = new int[4];
                this.nBits[3] = 8;
            } else {
                this.nBits = new int[3];
            }
            this.nBits[2] = 8;
            this.nBits[1] = 8;
            this.nBits[0] = 8;
        }
        return this.nBits;
    }

    public final int getAlpha(int n2) {
        return this.rgb[n2] >> 24 & 0xFF;
    }

    public final int getBlue(int n2) {
        return this.rgb[n2] & 0xFF;
    }

    public final int getGreen(int n2) {
        return this.rgb[n2] >> 8 & 0xFF;
    }

    public final int getRGB(int n2) {
        return this.rgb[n2];
    }

    public final int getRed(int n2) {
        return this.rgb[n2] >> 16 & 0xFF;
    }

    private void setTransparency(int n2) {
        if (this.transparency != n2) {
            this.transparency = n2;
            if (n2 == 1) {
                this.supportsAlpha = false;
                this.numComponents = 3;
                this.nBits = opaqueBits;
            } else {
                this.supportsAlpha = true;
                this.numComponents = 4;
                this.nBits = alphaBits;
            }
        }
    }

    private void setTransparentPixel(int n2) {
        if (n2 >= 0 && n2 < this.map_size) {
            int n3 = n2;
            this.rgb[n3] = this.rgb[n3] & 0xFFFFFF;
            this.transparent_index = n2;
            this.allgrayopaque = false;
            if (this.transparency == 1) {
                this.setTransparency(2);
            }
        }
    }

    public boolean isValid(int n2) {
        return n2 >= 0 && n2 < this.map_size && (this.validBits == null || this.validBits.testBit(n2));
    }

    private int calcRealMapSize(int n2, int n3) {
        int n4 = Math.max(1 << n2, n3);
        return Math.max(n4, 256);
    }

    public IndexColorModel(int n2, int n3, byte[] byArray, int n4, boolean bl2) {
        this(n2, n3, byArray, n4, bl2, -1);
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
    }

    public IndexColorModel(int n2, int n3, byte[] byArray, int n4, boolean bl2, int n5) {
        super(n2, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n2));
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Map size (" + n3 + ") must be >= 1");
        }
        this.map_size = n3;
        this.rgb = new int[this.calcRealMapSize(n2, n3)];
        int n6 = n4;
        int n7 = 255;
        boolean bl3 = true;
        int n8 = 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n9 = byArray[n6++] & 0xFF;
            int n10 = byArray[n6++] & 0xFF;
            int n11 = byArray[n6++] & 0xFF;
            boolean bl4 = bl3 = bl3 && n9 == n10 && n10 == n11;
            if (bl2 && (n7 = byArray[n6++] & 0xFF) != 255) {
                if (n7 == 0) {
                    if (n8 == 1) {
                        n8 = 2;
                    }
                    if (this.transparent_index < 0) {
                        this.transparent_index = i2;
                    }
                } else {
                    n8 = 3;
                }
                bl3 = false;
            }
            this.rgb[i2] = n7 << 24 | n9 << 16 | n10 << 8 | n11;
        }
        this.allgrayopaque = bl3;
        this.setTransparency(n8);
        this.setTransparentPixel(n5);
    }

    public IndexColorModel(int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n2, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n2));
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n3, byArray, byArray2, byArray3, null);
    }

    public IndexColorModel(int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, int n4) {
        super(n2, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n2));
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n3, byArray, byArray2, byArray3, null);
        this.setTransparentPixel(n4);
    }

    public IndexColorModel(int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n2, alphaBits, ColorSpace.getInstance(1000), true, false, 3, ColorModel.getDefaultTransferType(n2));
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n3, byArray, byArray2, byArray3, byArray4);
    }

    public IndexColorModel(int n2, int n3, int[] nArray, int n4, boolean bl2, int n5, int n6) {
        super(n2, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, n6);
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Map size (" + n3 + ") must be >= 1");
        }
        if (n6 != 0 && n6 != 1) {
            throw new IllegalArgumentException("transferType must be eitherDataBuffer.TYPE_BYTE or DataBuffer.TYPE_USHORT");
        }
        this.setRGBs(n3, nArray, n4, bl2);
        this.setTransparentPixel(n5);
    }

    private void setRGBs(int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        this.map_size = n2;
        this.rgb = new int[this.calcRealMapSize(this.pixel_bits, n2)];
        int n3 = 255;
        int n4 = 1;
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = byArray[i2] & 0xFF;
            int n6 = byArray2[i2] & 0xFF;
            int n7 = byArray3[i2] & 0xFF;
            boolean bl3 = bl2 = bl2 && n5 == n6 && n6 == n7;
            if (byArray4 != null && (n3 = byArray4[i2] & 0xFF) != 255) {
                if (n3 == 0) {
                    if (n4 == 1) {
                        n4 = 2;
                    }
                    if (this.transparent_index < 0) {
                        this.transparent_index = i2;
                    }
                } else {
                    n4 = 3;
                }
                bl2 = false;
            }
            this.rgb[i2] = n3 << 24 | n5 << 16 | n6 << 8 | n7;
        }
        this.allgrayopaque = bl2;
        this.setTransparency(n4);
    }

    public int[] getComponents(int n2, int[] nArray, int n3) {
        if (nArray == null) {
            nArray = new int[n3 + this.numComponents];
        }
        nArray[n3 + 0] = this.getRed(n2);
        nArray[n3 + 1] = this.getGreen(n2);
        nArray[n3 + 2] = this.getBlue(n2);
        if (this.supportsAlpha && nArray.length - n3 > 3) {
            nArray[n3 + 3] = this.getAlpha(n2);
        }
        return nArray;
    }

    private void setRGBs(int n2, int[] nArray, int n3, boolean bl2) {
        this.map_size = n2;
        this.rgb = new int[this.calcRealMapSize(this.pixel_bits, n2)];
        int n4 = n3;
        int n5 = 1;
        boolean bl3 = true;
        BigInteger bigInteger = this.validBits;
        int n6 = 0;
        while (n6 < n2) {
            if (bigInteger == null || bigInteger.testBit(n6)) {
                int n7 = nArray[n4];
                int n8 = n7 >> 16 & 0xFF;
                int n9 = n7 >> 8 & 0xFF;
                int n10 = n7 & 0xFF;
                boolean bl4 = bl3 = bl3 && n8 == n9 && n9 == n10;
                if (bl2) {
                    int n11 = n7 >>> 24;
                    if (n11 != 255) {
                        if (n11 == 0) {
                            if (n5 == 1) {
                                n5 = 2;
                            }
                            if (this.transparent_index < 0) {
                                this.transparent_index = n6;
                            }
                        } else {
                            n5 = 3;
                        }
                        bl3 = false;
                    }
                } else {
                    n7 |= 0xFF000000;
                }
                this.rgb[n6] = n7;
            }
            ++n6;
            ++n4;
        }
        this.allgrayopaque = bl3;
        this.setTransparency(n5);
    }

    public final void getAlphas(byte[] byArray) {
        for (int i2 = 0; i2 < this.map_size; ++i2) {
            byArray[i2] = (byte)(this.rgb[i2] >> 24);
        }
    }

    public final void getBlues(byte[] byArray) {
        for (int i2 = 0; i2 < this.map_size; ++i2) {
            byArray[i2] = (byte)this.rgb[i2];
        }
    }

    public final void getGreens(byte[] byArray) {
        for (int i2 = 0; i2 < this.map_size; ++i2) {
            byArray[i2] = (byte)(this.rgb[i2] >> 8);
        }
    }

    public final void getReds(byte[] byArray) {
        for (int i2 = 0; i2 < this.map_size; ++i2) {
            byArray[i2] = (byte)(this.rgb[i2] >> 16);
        }
    }

    public final void getRGBs(int[] nArray) {
        System.arraycopy(this.rgb, 0, nArray, 0, this.map_size);
    }

    public int getDataElement(int[] nArray, int n2) {
        int n3;
        int n4 = nArray[n2 + 0] << 16 | nArray[n2 + 1] << 8 | nArray[n2 + 2];
        n4 = this.supportsAlpha ? (n4 |= nArray[n2 + 3] << 24) : (n4 |= 0xFF000000);
        Object object = this.getDataElements(n4, null);
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n3 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n3 = sArray[0];
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n3 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return n3;
    }

    public boolean isCompatibleRaster(Raster raster) {
        int n2 = raster.getSampleModel().getSampleSize(0);
        return raster.getTransferType() == this.transferType && raster.getNumBands() == 1 && 1 << n2 >= this.map_size;
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        int[] nArray = new int[]{0};
        if (this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4) {
            return new MultiPixelPackedSampleModel(this.transferType, n2, n3, this.pixel_bits);
        }
        return new ComponentSampleModel(this.transferType, n2, n3, 1, n2, nArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel) && !(sampleModel instanceof MultiPixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getTransferType() != this.transferType) {
            return false;
        }
        return sampleModel.getNumBands() == 1;
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        WritableRaster writableRaster;
        if (this.pixel_bits == 1 || this.pixel_bits == 2 || this.pixel_bits == 4) {
            writableRaster = Raster.createPackedRaster(0, n2, n3, 1, this.pixel_bits, null);
        } else if (this.pixel_bits <= 8) {
            writableRaster = Raster.createInterleavedRaster(0, n2, n3, 1, null);
        } else if (this.pixel_bits <= 16) {
            writableRaster = Raster.createInterleavedRaster(1, n2, n3, 1, null);
        } else {
            throw new UnsupportedOperationException("This method is not supported  for pixel bits > 16.");
        }
        return writableRaster;
    }

    public int[] getComponents(Object object, int[] nArray, int n2) {
        int n3;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n3 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n3 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n3 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getComponents(n3, nArray, n2);
    }

    public String toString() {
        return new String("IndexColorModel: #pixelBits = " + this.pixel_bits + " numComponents = " + this.numComponents + " color space = " + this.colorSpace + " transparency = " + this.transparency + " transIndex   = " + this.transparent_index + " has alpha = " + this.supportsAlpha + " isAlphaPre = " + this.isAlphaPremultiplied);
    }

    private BigInteger getAllValid() {
        int n2 = (this.map_size + 7) / 8;
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, (byte)-1);
        byArray[0] = (byte)(255 >>> n2 * 8 - this.map_size);
        return new BigInteger(1, byArray);
    }

    public BigInteger getValidPixels() {
        if (this.validBits == null) {
            return this.getAllValid();
        }
        return this.validBits;
    }

    public IndexColorModel(int n2, int n3, int[] nArray, int n4, int n5, BigInteger bigInteger) {
        super(n2, alphaBits, ColorSpace.getInstance(1000), true, false, 3, n5);
        if (n2 < 1 || n2 > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Map size (" + n3 + ") must be >= 1");
        }
        if (n5 != 0 && n5 != 1) {
            throw new IllegalArgumentException("transferType must be eitherDataBuffer.TYPE_BYTE or DataBuffer.TYPE_USHORT");
        }
        if (bigInteger != null) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (bigInteger.testBit(i2)) continue;
                this.validBits = bigInteger;
                break;
            }
        }
        this.setRGBs(n3, nArray, n4, true);
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean bl2) {
        if (!this.isCompatibleRaster(raster)) {
            throw new IllegalArgumentException("This raster is not compatiblewith this IndexColorModel.");
        }
        ColorModel colorModel = bl2 || this.transparency == 3 ? ColorModel.getRGBdefault() : (this.transparency == 2 ? new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000) : new DirectColorModel(24, 0xFF0000, 65280, 255));
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        Object object = null;
        int[] nArray = null;
        int n4 = raster.getMinX();
        int n5 = raster.getMinY();
        int n6 = 0;
        while (n6 < n3) {
            nArray = (object = raster.getDataElements(n4, n5, n2, 1, object)) instanceof int[] ? (int[])object : DataBuffer.toIntArray(object);
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.rgb[nArray[i2]];
            }
            writableRaster.setDataElements(0, n6, n2, 1, nArray);
            ++n6;
            ++n5;
        }
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    public synchronized Object getDataElements(int n2, Object object) {
        int n3;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        int n7 = n2 >>> 24;
        int n8 = 0;
        for (n3 = 38; n3 >= 0 && (n8 = this.lookupcache[n3]) != 0; n3 -= 2) {
            if (n2 != this.lookupcache[n3 + 1]) continue;
            return this.installpixel(object, ~n8);
        }
        if (this.allgrayopaque) {
            n3 = 256;
            int n9 = (n4 * 77 + n5 * 150 + n6 * 29 + 128) / 256;
            for (int i2 = 0; i2 < this.map_size; ++i2) {
                if (this.rgb[i2] == 0) continue;
                int n10 = (this.rgb[i2] & 0xFF) - n9;
                if (n10 < 0) {
                    n10 = -n10;
                }
                if (n10 >= n3) continue;
                n8 = i2;
                if (n10 != 0) {
                    n3 = n10;
                    continue;
                }
                break;
            }
        } else if (n7 == 0) {
            if (this.transparent_index >= 0) {
                n8 = this.transparent_index;
            } else {
                n3 = 256;
                for (int i3 = 0; i3 < this.map_size; ++i3) {
                    int n11 = this.rgb[i3] >>> 24;
                    if (n3 <= n7 || this.validBits != null && !this.validBits.testBit(i3)) continue;
                    n3 = n7;
                    n8 = i3;
                }
            }
        } else {
            n3 = 16581375;
            int n12 = 255;
            for (int i4 = 0; i4 < this.map_size; ++i4) {
                int n13 = this.rgb[i4];
                if (n13 == n2) {
                    n8 = i4;
                    break;
                }
                int n14 = (n13 >>> 24) - n7;
                if (n14 < 0) {
                    n14 = -n14;
                }
                if (n14 > n12) continue;
                n12 = n14;
                n14 = (n13 >> 16 & 0xFF) - n4;
                int n15 = n14 * n14;
                if (n15 >= n3 || (n15 += (n14 = (n13 >> 8 & 0xFF) - n5) * n14) >= n3 || (n15 += (n14 = (n13 & 0xFF) - n6) * n14) >= n3 || this.validBits != null && !this.validBits.testBit(i4)) continue;
                n8 = i4;
                n3 = n15;
            }
        }
        System.arraycopy(this.lookupcache, 2, this.lookupcache, 0, 38);
        this.lookupcache[39] = n2;
        this.lookupcache[38] = ~n8;
        return this.installpixel(object, n8);
    }

    private Object installpixel(Object object, int n2) {
        switch (this.transferType) {
            case 3: {
                int[] nArray;
                if (object == null) {
                    nArray = new int[1];
                    object = nArray;
                } else {
                    nArray = (int[])object;
                }
                nArray[0] = n2;
                break;
            }
            case 0: {
                byte[] byArray;
                if (object == null) {
                    byArray = new byte[1];
                    object = byArray;
                } else {
                    byArray = (byte[])object;
                }
                byArray[0] = (byte)n2;
                break;
            }
            case 1: {
                short[] sArray;
                if (object == null) {
                    sArray = new short[1];
                    object = sArray;
                } else {
                    sArray = (short[])object;
                }
                sArray[0] = (short)n2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return object;
    }

    public Object getDataElements(int[] nArray, int n2, Object object) {
        int n3 = nArray[n2 + 0] << 16 | nArray[n2 + 1] << 8 | nArray[n2 + 2];
        n3 = this.supportsAlpha ? (n3 |= nArray[n2 + 3] << 24) : (n3 &= 0xFF000000);
        return this.getDataElements(n3, object);
    }
}

