/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.peer.PopupMenuPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MToolkit;

public class MPopupMenuPeer
extends MMenuPeer
implements PopupMenuPeer {
    static {
        MPopupMenuPeer.initIDs();
    }

    void createPopupMenu() {
        MComponentPeer mComponentPeer;
        if (MMenuItemPeer.getParent_NoClientCode(this.target) instanceof Component) {
            Component component = (Component)MPopupMenuPeer.getParent_NoClientCode(this.target);
            mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
            if (mComponentPeer == null) {
                component = MToolkit.getNativeContainer(component);
                mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
            }
        } else {
            throw new IllegalArgumentException("illegal popup menu container class");
        }
        this.createMenu(mComponentPeer);
        this.nativeCreated = true;
        this.createItems((Menu)this.target);
    }

    private void destroyNativeWidgetAfterGettingTreeLock() {
        MToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                Object object2 = object = new Button().getTreeLock();
                synchronized (object2) {
                    MPopupMenuPeer.this.destroyNativeWidget();
                }
            }
        });
    }

    private static native void initIDs();

    native void pDispose();

    public void show(Event event) {
        if (!this.nativeCreated) {
            this.createPopupMenu();
        }
        Component component = (Component)event.target;
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
        int n2 = event.x;
        int n3 = event.y;
        if (mComponentPeer == null) {
            Container container = MToolkit.getNativeContainer(component);
            mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
            Component component2 = component;
            while (component2 != container) {
                Point point = component2.getLocation();
                n2 += point.x;
                n3 += point.y;
                component2 = MComponentPeer.getParent_NoClientCode(component2);
            }
        }
        this.pShow(event, n2, n3, mComponentPeer);
    }

    void createItems(Menu menu) {
        int n2 = menu.getItemCount();
        MMenuPeer mMenuPeer = (MMenuPeer)MToolkit.targetToPeer(menu);
        for (int i2 = 0; i2 < n2; ++i2) {
            MenuItem menuItem = menu.getItem(i2);
            MMenuItemPeer mMenuItemPeer = (MMenuItemPeer)MToolkit.targetToPeer(menuItem);
            mMenuItemPeer.create(mMenuPeer);
            if (!(menuItem instanceof Menu)) continue;
            this.createItems((Menu)menuItem);
        }
    }

    public MPopupMenuPeer(PopupMenu popupMenu) {
        this.target = popupMenu;
    }

    native void createMenu(MComponentPeer var1);

    native void pShow(Event var1, int var2, int var3, MComponentPeer var4);
}

