/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseWheelEvent;
import java.awt.event.TextEvent;
import java.awt.peer.TextAreaPeer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.TextLine;

public class MTextAreaPeer
extends MComponentPeer
implements TextAreaPeer {
    static final int MARGIN = 2;
    static final int BORDER = 1;
    static final int SCROLLBAR = 16;
    int fontHeight;
    int fontAscent;
    int fontLeading;
    int topLine = 0;
    int numLines = 0;
    int textLength = 0;
    Vector lines;
    int selStart = 0;
    int selEnd = 0;
    int movedRight = 0;
    transient boolean hscrollbar;
    transient boolean vscrollbar;

    public native int getCaretPosition();

    native int getExtraHeight();

    native int getExtraWidth();

    public native int getSelectionEnd();

    public native int getSelectionStart();

    void initialize() {
        TextArea textArea = (TextArea)this.target;
        String string = textArea.getText();
        if (string != null) {
            this.setText(string);
        }
        int n2 = textArea.getSelectionStart();
        int n3 = textArea.getSelectionEnd();
        if (n3 > n2) {
            this.select(n2, n3);
        }
        super.pSetScrollbarBackground(MTextAreaPeer.getParent_NoClientCode(this.target).getBackground());
        if (!this.target.isBackgroundSet()) {
            this.setTargetBackground(SystemColor.text);
        }
        if (!this.target.isForegroundSet()) {
            this.target.setForeground(SystemColor.textText);
        }
        this.setEditable(textArea.isEditable());
        super.initialize();
    }

    void pDispose() {
        this.notifyTextComponentChange(false);
        super.pDispose();
    }

    void pHide() {
        this.notifyTextComponentChange(false);
        super.pHide();
    }

    native void pMakeCursorVisible();

    void pShow() {
        this.pShow2();
        this.notifyTextComponentChange(true);
    }

    native void pShow2();

    public void pasteFromClipboard() {
        Clipboard clipboard = this.target.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                string = string == null ? "" : string;
                this.replaceRange(string, this.getSelectionStart(), this.getSelectionEnd());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void valueChanged() {
        this.postEvent(new TextEvent(this.target, 900));
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    public boolean isFocusable() {
        return true;
    }

    int pos2x(int n2) {
        int n3;
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        int[] nArray = fontMetrics.getWidths();
        TextLine textLine = (TextLine)this.lines.elementAt(0);
        int n4 = 0;
        for (n3 = 0; n3 < this.lines.size() - 1; ++n3) {
            TextLine textLine2 = (TextLine)this.lines.elementAt(n3 + 1);
            if (n2 >= textLine.pos && n2 < textLine2.pos) {
                n4 = n3;
                break;
            }
            textLine = textLine2;
        }
        n3 = 2;
        for (int i2 = 0; i2 < n2 - textLine.pos - 1; ++i2) {
            n3 += nArray[textLine.text.charAt(i2)];
        }
        return n3;
    }

    public native void setCaretPosition(int var1);

    public int getIndexAtPoint(int n2, int n3) {
        return -1;
    }

    public native void select(int var1, int var2);

    native void nativeHandleMouseWheel(int var1, int var2, int var3);

    public long filterEvents(long l2) {
        return 0L;
    }

    int linesInWindow(boolean bl2) {
        Dimension dimension = this.target.size();
        int n2 = dimension.height - (4 + (bl2 ? 16 : 0));
        return n2 / this.fontHeight;
    }

    public native void pSetEditable(boolean var1);

    public void setEditable(boolean bl2) {
        this.pSetEditable(bl2);
        this.setBackground(this.target.getBackground());
    }

    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 507) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
            this.nativeHandleMouseWheel(mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        } else {
            super.handleEvent(aWTEvent);
        }
    }

    public void setBackground(Color color) {
        this.setTextBackground(color);
    }

    public void setForeground(Color color) {
        this.pSetInnerForeground(color);
    }

    public native void setTextBackground(Color var1);

    public native void pSetCursor(Cursor var1);

    public Dimension getMinimumSize() {
        return this.getMinimumSize(10, 60);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize(int n2, int n3) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        int n4 = fontMetrics.charWidth('0');
        int n5 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        return new Dimension(n3 * n4 + this.getExtraWidth(), n2 * n5 + this.getExtraHeight());
    }

    public Dimension getPreferredSize(int n2, int n3) {
        return this.getMinimumSize(n2, n3);
    }

    public Dimension minimumSize(int n2, int n3) {
        return this.getMinimumSize(n2, n3);
    }

    public Dimension preferredSize(int n2, int n3) {
        return this.getPreferredSize(n2, n3);
    }

    public native void setFont(Font var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        TextArea textArea = (TextArea)this.target;
        Dimension dimension = textArea.size();
        Color color = textArea.getBackground();
        Color color2 = textArea.getForeground();
        FontMetrics fontMetrics = this.getFontMetrics(textArea.getFont());
        int n2 = 0;
        String string = textArea.getText();
        this.textLength = string.length();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n3 = 0;
        this.lines = new Vector();
        int n4 = ((TextArea)this.target).getScrollbarVisibility();
        this.vscrollbar = n4 == 0 || n4 == 1;
        this.hscrollbar = n4 == 0 || n4 == 2;
        boolean bl2 = !this.hscrollbar;
        int n5 = dimension.width - (this.vscrollbar ? 16 : 0);
        int n6 = dimension.height - (this.hscrollbar ? 16 : 0);
        try {
            String string2;
            this.numLines = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n7 = fontMetrics.stringWidth(string2);
                if (n7 > n5 && bl2) {
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = string2.length();
                    do {
                        char c2;
                        int n11;
                        int n12 = 0;
                        for (n9 = n8 + 1; n9 < n10 && n12 + (n11 = fontMetrics.charWidth(c2 = string2.charAt(n9))) + 10 <= n5; ++n9) {
                            n12 += n11;
                        }
                        String string3 = string2.substring(n8, n9);
                        TextLine textLine = new TextLine();
                        textLine.text = string3;
                        textLine.pos = n3 + n8;
                        this.lines.addElement(textLine);
                        n8 = n9;
                        n2 = Math.max(n2, n7);
                        ++this.numLines;
                    } while (n9 != n10);
                    n3 += string2.length() + 1;
                    continue;
                }
                TextLine textLine = new TextLine();
                textLine.text = string2;
                textLine.pos = n3;
                this.lines.addElement(textLine);
                n3 += string2.length() + 1;
                n2 = Math.max(n2, n7);
                ++this.numLines;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fontHeight = fontMetrics.getHeight();
        this.fontAscent = fontMetrics.getAscent();
        this.fontLeading = fontMetrics.getLeading();
        int n13 = 0;
        int n14 = 0;
        int n15 = this.linesInWindow(true);
        int n16 = Math.max(this.numLines - n15, 0);
        int n17 = 0;
        int n18 = n5 - 4;
        int n19 = Math.max(n2 - n18, 0);
        int n20 = 0;
        graphics.setColor(color);
        graphics.fillRect(1, 1, n5, n6);
        if (this.vscrollbar) {
            int n21 = dimension.height - (this.hscrollbar ? 16 : 0);
            graphics.fillRect(dimension.width - 16 - 3, 1, 13, n21 - 1);
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(dimension.width - 14, 0);
                this.drawScrollbar(graphics2, color, 14, n21, n13, n16, n17, n15, false);
            }
            finally {
                graphics2.dispose();
            }
        }
        if (this.hscrollbar) {
            int n22 = dimension.width - (this.vscrollbar ? 16 : 0);
            graphics.fillRect(1, dimension.height - 16 - 3, n22 - 1, 13);
            Graphics graphics3 = graphics.create();
            try {
                graphics3.translate(0, dimension.height - 14);
                this.drawScrollbar(graphics3, color, 14, n22, n14, n19, n20, n18, true);
            }
            finally {
                graphics3.dispose();
            }
        }
        this.draw3DRect(graphics, color, 0, 0, n5 - 1, n6 - 1, false);
        if (string != null) {
            int n23 = this.linesInWindow(true);
            n6 = dimension.height - 20;
            int n24 = Math.min(this.numLines - 1, this.topLine + n23 - 1);
            this.paintLines(graphics, color, color2, this.topLine, n24);
        }
        this.target.print(graphics);
    }

    public Rectangle getCharacterBounds(int n2) {
        return null;
    }

    public MTextAreaPeer(TextArea textArea) {
        super(textArea);
    }

    public native String getText();

    public native void setText(String var1);

    public native void insert(String var1, int var2);

    public void insertText(String string, int n2) {
        this.insert(string, n2);
    }

    public native void replaceRange(String var1, int var2, int var3);

    public void replaceText(String string, int n2, int n3) {
        this.replaceRange(string, n2, n3);
    }

    native void create(MComponentPeer var1);

    void paintLine(Graphics graphics, Color color, Color color2, int n2) {
        Dimension dimension = this.target.size();
        int n3 = this.linesInWindow(true);
        if (n2 < this.topLine || n2 >= n3 + this.topLine) {
            return;
        }
        int n4 = dimension.width - (2 + (this.hscrollbar ? 16 : 0));
        int n5 = 2 + this.fontLeading + (n2 - this.topLine) * this.fontHeight;
        String string = ((TextLine)this.lines.elementAt((int)n2)).text;
        int n6 = string.length();
        if (n2 > this.numLines - 1) {
            graphics.setColor(color);
            graphics.fillRect(1, n5 - this.fontLeading, n4, this.fontHeight);
            return;
        }
        int n7 = 0;
        int n8 = n2 < this.numLines - 1 ? n6 : this.textLength;
        int n9 = this.pos2x(this.selStart) - this.movedRight;
        int n10 = this.pos2x(this.selEnd) - this.movedRight;
        Color color3 = color.brighter();
        if (this.selStart < n7 && this.selEnd > n8) {
            graphics.setColor(color3);
            graphics.fillRect(1, n5 - this.fontLeading, n4, this.fontHeight);
        } else {
            graphics.setColor(color);
            graphics.fillRect(1, n5 - this.fontLeading, n4, this.fontHeight);
            if (this.selStart >= n7 && this.selStart <= n8) {
                graphics.setColor(color3);
                if (this.selEnd > n8) {
                    graphics.fillRect(n9, n5 - this.fontLeading, n4 + 1 - n9, this.fontHeight);
                } else if (this.selStart != this.selEnd) {
                    graphics.fillRect(n9, n5 - this.fontLeading, n10 - n9, this.fontHeight);
                }
            } else if (this.selEnd >= n7 && this.selEnd <= n8) {
                graphics.setColor(color3);
                graphics.fillRect(1, n5 - this.fontLeading, n10 - 1, this.fontHeight);
            }
        }
        graphics.setColor(color2);
        graphics.drawString(string, 2 - this.movedRight, n5 + this.fontAscent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintLines(Graphics graphics, Color color, Color color2, int n2, int n3) {
        Dimension dimension = this.target.size();
        int n4 = dimension.width - (2 + (this.vscrollbar ? 16 : 0));
        int n5 = dimension.height - (2 + (this.hscrollbar ? 16 : 0));
        int n6 = this.linesInWindow(true) + this.topLine;
        n2 = Math.max(this.topLine, n2);
        n3 = Math.min(n3, n6 - 1);
        Graphics graphics2 = graphics.create();
        try {
            graphics2.clipRect(3, 3, n4 - 4, n5 - 4);
            graphics2.setFont(this.target.getFont());
            for (int i2 = n2; i2 <= n3; ++i2) {
                this.paintLine(graphics2, color, color2, i2);
            }
        }
        finally {
            graphics2.dispose();
        }
    }
}

