/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.util.Arrays;
import sun.security.util.MemoryCache;
import sun.security.util.NullCache;

public abstract class Cache {
    public abstract int size();

    protected Cache() {
    }

    public abstract void clear();

    public abstract void remove(Object var1);

    public static Cache newNullCache() {
        return NullCache.INSTANCE;
    }

    public static Cache newHardMemoryCache(int n2) {
        return new MemoryCache(false, n2);
    }

    public static Cache newSoftMemoryCache(int n2) {
        return new MemoryCache(true, n2);
    }

    public static Cache newHardMemoryCache(int n2, int n3) {
        return new MemoryCache(false, n2, n3);
    }

    public static Cache newSoftMemoryCache(int n2, int n3) {
        return new MemoryCache(true, n2, n3);
    }

    public abstract Object get(Object var1);

    public abstract void put(Object var1, Object var2);

    public static class EqualByteArray {
        private final byte[] b;
        private volatile int hash;

        public int hashCode() {
            int n2 = this.hash;
            if (n2 == 0) {
                n2 = this.b.length + 1;
                for (int i2 = 0; i2 < this.b.length; ++i2) {
                    n2 += (this.b[i2] & 0xFF) * 37;
                }
                this.hash = n2;
            }
            return n2;
        }

        public EqualByteArray(byte[] byArray) {
            this.b = byArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof EqualByteArray)) {
                return false;
            }
            EqualByteArray equalByteArray = (EqualByteArray)object;
            return Arrays.equals(this.b, equalByteArray.b);
        }
    }
}

