/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.DNSName;
import sun.security.x509.EDIPartyName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralSubtree;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.OtherName;
import sun.security.x509.RFC822Name;
import sun.security.x509.URIName;
import sun.security.x509.X400Address;
import sun.security.x509.X500Name;

public class GeneralSubtrees
implements Cloneable {
    private final List trees;
    private static final int NAME_DIFF_TYPE = -1;
    private static final int NAME_MATCH = 0;
    private static final int NAME_NARROWS = 1;
    private static final int NAME_WIDENS = 2;
    private static final int NAME_SAME_TYPE = 3;

    public int hashCode() {
        return ((Object)this.trees).hashCode();
    }

    public int size() {
        return this.trees.size();
    }

    public GeneralSubtrees() {
        this.trees = new ArrayList();
    }

    private void minimize() {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            boolean bl2;
            block9: {
                GeneralNameInterface generalNameInterface = this.getGeneralNameInterface(i2);
                bl2 = false;
                block8: for (int i3 = i2 + 1; i3 < this.size(); ++i3) {
                    GeneralNameInterface generalNameInterface2 = this.getGeneralNameInterface(i3);
                    switch (generalNameInterface.constrains(generalNameInterface2)) {
                        case -1: {
                            continue block8;
                        }
                        case 0: {
                            bl2 = true;
                            break block9;
                        }
                        case 1: {
                            this.remove(i3);
                            --i3;
                            continue block8;
                        }
                        case 2: {
                            bl2 = true;
                            break block9;
                        }
                        case 3: {
                            continue block8;
                        }
                    }
                }
            }
            if (!bl2) continue;
            this.remove(i2);
            --i2;
        }
    }

    public void remove(int n2) {
        this.trees.remove(n2);
    }

    public Object clone() {
        return new GeneralSubtrees(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeneralSubtrees)) {
            return false;
        }
        GeneralSubtrees generalSubtrees = (GeneralSubtrees)object;
        return ((Object)this.trees).equals(generalSubtrees.trees);
    }

    public String toString() {
        String string = "   GeneralSubtrees:\n" + this.trees.toString() + "\n";
        return string;
    }

    public Iterator iterator() {
        return this.trees.iterator();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.get(i2).encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public GeneralSubtrees(DerValue derValue) throws IOException {
        this();
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding of GeneralSubtrees.");
        }
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            GeneralSubtree generalSubtree = new GeneralSubtree(derValue2);
            this.add(generalSubtree);
        }
    }

    private GeneralNameInterface getGeneralNameInterface(int n2) {
        return GeneralSubtrees.getGeneralNameInterface(this.get(n2));
    }

    public GeneralSubtree get(int n2) {
        return (GeneralSubtree)this.trees.get(n2);
    }

    public void add(GeneralSubtree generalSubtree) {
        if (generalSubtree == null) {
            throw new NullPointerException();
        }
        this.trees.add(generalSubtree);
    }

    public boolean contains(GeneralSubtree generalSubtree) {
        if (generalSubtree == null) {
            throw new NullPointerException();
        }
        return this.trees.contains(generalSubtree);
    }

    private GeneralSubtrees(GeneralSubtrees generalSubtrees) {
        ArrayList arrayList = (ArrayList)generalSubtrees.trees;
        this.trees = (List)arrayList.clone();
    }

    public void reduce(GeneralSubtrees generalSubtrees) {
        if (generalSubtrees == null) {
            return;
        }
        int n2 = generalSubtrees.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            GeneralNameInterface generalNameInterface = generalSubtrees.getGeneralNameInterface(i2);
            block7: for (int i3 = 0; i3 < this.size(); ++i3) {
                GeneralNameInterface generalNameInterface2 = this.getGeneralNameInterface(i3);
                switch (generalNameInterface.constrains(generalNameInterface2)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        this.remove(i3);
                        --i3;
                        continue block7;
                    }
                    case 1: {
                        this.remove(i3);
                        --i3;
                        continue block7;
                    }
                    case 2: {
                        continue block7;
                    }
                }
            }
        }
    }

    public void union(GeneralSubtrees generalSubtrees) {
        if (generalSubtrees != null) {
            int n2 = generalSubtrees.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.add(generalSubtrees.get(i2));
            }
            this.minimize();
        }
    }

    private static GeneralNameInterface getGeneralNameInterface(GeneralSubtree generalSubtree) {
        GeneralName generalName = generalSubtree.getName();
        GeneralNameInterface generalNameInterface = generalName.getName();
        return generalNameInterface;
    }

    private GeneralSubtree createWidestSubtree(GeneralNameInterface generalNameInterface) {
        try {
            GeneralName generalName;
            switch (generalNameInterface.getType()) {
                case 0: {
                    ObjectIdentifier objectIdentifier = ((OtherName)generalNameInterface).getOID();
                    generalName = new GeneralName(new OtherName(objectIdentifier, null));
                    break;
                }
                case 1: {
                    generalName = new GeneralName(new RFC822Name(""));
                    break;
                }
                case 2: {
                    generalName = new GeneralName(new DNSName(""));
                    break;
                }
                case 3: {
                    generalName = new GeneralName(new X400Address((byte[])null));
                    break;
                }
                case 4: {
                    generalName = new GeneralName(new X500Name(""));
                    break;
                }
                case 5: {
                    generalName = new GeneralName(new EDIPartyName(""));
                    break;
                }
                case 6: {
                    generalName = new GeneralName(new URIName(""));
                    break;
                }
                case 7: {
                    generalName = new GeneralName(new IPAddressName((byte[])null));
                    break;
                }
                case 8: {
                    generalName = new GeneralName(new OIDName(new ObjectIdentifier((int[])null)));
                    break;
                }
                default: {
                    throw new IOException("Unsupported GeneralNameInterface type: " + generalNameInterface.getType());
                }
            }
            return new GeneralSubtree(generalName, 0, -1);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected error: " + iOException, iOException);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public GeneralSubtrees intersect(GeneralSubtrees generalSubtrees) {
        Object object;
        int n2;
        boolean bl2;
        Object object2;
        if (generalSubtrees == null) {
            throw new NullPointerException("other GeneralSubtrees must not be null");
        }
        GeneralSubtrees generalSubtrees2 = new GeneralSubtrees();
        GeneralSubtrees generalSubtrees3 = null;
        if (this.size() == 0) {
            this.union(generalSubtrees);
            return null;
        }
        this.minimize();
        generalSubtrees.minimize();
        int n3 = 0;
        block9: while (true) {
            GeneralNameInterface generalNameInterface;
            if (n3 >= this.size()) {
                if (generalSubtrees2.size() > 0) {
                    this.union(generalSubtrees2);
                }
                break;
            }
            object2 = this.getGeneralNameInterface(n3);
            boolean bl3 = false;
            bl2 = false;
            block10: for (n2 = 0; n2 < generalSubtrees.size(); ++n2) {
                object = generalSubtrees.get(n2);
                generalNameInterface = GeneralSubtrees.getGeneralNameInterface((GeneralSubtree)object);
                switch (object2.constrains(generalNameInterface)) {
                    case 1: {
                        this.remove(n3);
                        --n3;
                        generalSubtrees2.add((GeneralSubtree)object);
                        bl2 = false;
                        break block10;
                    }
                    case 3: {
                        bl2 = true;
                        break;
                    }
                    case 0: 
                    case 2: {
                        bl2 = false;
                        break block10;
                    }
                }
            }
            boolean bl4 = true;
            while (true) {
                int n4;
                block27: {
                    block28: {
                        block25: {
                            block26: {
                                block24: {
                                    if (!bl4 || (bl4 = false)) break block24;
                                    if (!bl2) break block25;
                                    n2 = 0;
                                    n4 = 0;
                                }
                                if (n4 >= this.size()) break block26;
                                generalNameInterface = this.getGeneralNameInterface(n4);
                                if (generalNameInterface.getType() != object2.getType()) break block27;
                                break block28;
                            }
                            if (n2 == 0) {
                                GeneralSubtree generalSubtree;
                                if (generalSubtrees3 == null) {
                                    generalSubtrees3 = new GeneralSubtrees();
                                }
                                if (!generalSubtrees3.contains(generalSubtree = this.createWidestSubtree((GeneralNameInterface)object2))) {
                                    generalSubtrees3.add(generalSubtree);
                                }
                            }
                            this.remove(n3);
                            --n3;
                        }
                        ++n3;
                        continue block9;
                    }
                    for (int i2 = 0; i2 < generalSubtrees.size(); ++i2) {
                        GeneralNameInterface generalNameInterface2 = generalSubtrees.getGeneralNameInterface(i2);
                        int n5 = generalNameInterface.constrains(generalNameInterface2);
                        if (n5 != 0 && n5 != 2 && n5 != 1) continue;
                        n2 = 1;
                        break;
                    }
                }
                ++n4;
            }
            break;
        }
        n3 = 0;
        while (n3 < generalSubtrees.size()) {
            object2 = generalSubtrees.get(n3);
            GeneralNameInterface generalNameInterface = GeneralSubtrees.getGeneralNameInterface((GeneralSubtree)object2);
            bl2 = false;
            block14: for (n2 = 0; n2 < this.size(); ++n2) {
                object = this.getGeneralNameInterface(n2);
                switch (object.constrains(generalNameInterface)) {
                    case -1: {
                        bl2 = true;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        bl2 = false;
                        break block14;
                    }
                }
            }
            if (bl2) {
                this.add((GeneralSubtree)object2);
            }
            ++n3;
        }
        return generalSubtrees3;
    }
}

