/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javac.v8.JavaCompiler;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.util.Abort;
import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.JavadocClassReader;
import com.sun.tools.javadoc.JavadocEnter;
import com.sun.tools.javadoc.Messager;
import com.sun.tools.javadoc.ModifierFilter;
import com.sun.tools.javadoc.RootDocImpl;
import java.io.File;

public class JavadocTool
extends JavaCompiler {
    DocEnv docenv;
    private final Context context;
    private final Messager messager;
    private final JavadocClassReader reader;
    private final JavadocEnter enter;
    private static final char pathSep = File.pathSeparatorChar;

    protected boolean keepComments() {
        return true;
    }

    private JavadocTool(Context context) {
        super(context);
        this.context = context;
        this.messager = Messager.instance0(context);
        this.reader = JavadocClassReader.instance0(context);
        this.enter = JavadocEnter.instance0(context);
    }

    private static boolean isValidClassName(String string) {
        if (string.length() < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidJavaClassFile(String string) {
        if (!string.endsWith(".class")) {
            return false;
        }
        String string2 = string.substring(0, string.length() - ".class".length());
        return JavadocTool.isValidClassName(string2);
    }

    private static boolean isValidJavaSourceFile(String string) {
        if (!string.endsWith(".java")) {
            return false;
        }
        String string2 = string.substring(0, string.length() - ".java".length());
        return JavadocTool.isValidClassName(string2);
    }

    boolean isValidPackageName(String string) {
        int n;
        while ((n = string.indexOf(46)) != -1) {
            if (!JavadocTool.isValidClassName(string.substring(0, n))) {
                return false;
            }
            string = string.substring(n + 1);
        }
        return JavadocTool.isValidClassName(string);
    }

    List listClasses(List list) {
        ListBuffer listBuffer = new ListBuffer();
        List list2 = list;
        while (list2.nonEmpty()) {
            Tree tree = (Tree)list2.head;
            if (tree.tag == 1) {
                List list3 = ((Tree.TopLevel)tree).defs;
                while (list3.nonEmpty()) {
                    Tree tree2 = (Tree)list3.head;
                    if (tree2.tag == 3) {
                        listBuffer.append((Tree.ClassDef)tree2);
                    }
                    list3 = list3.tail;
                }
            }
            list2 = list2.tail;
        }
        return listBuffer.toList();
    }

    public static JavadocTool make0(Context context) {
        Messager messager = null;
        try {
            messager = Messager.instance0(context);
            JavadocClassReader javadocClassReader = JavadocClassReader.instance0(context);
            JavadocEnter javadocEnter = JavadocEnter.instance0(context);
            return new JavadocTool(context);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            messager.error(0, completionFailure.getMessage());
            return null;
        }
    }

    private void searchSubPackages(List list, ListBuffer listBuffer, List list2) {
        List list3 = list;
        while (list3.nonEmpty()) {
            this.searchSubPackages((String)list3.head, listBuffer, list2);
            list3 = list3.tail;
        }
    }

    private void parsePackageClasses(String string, ListBuffer listBuffer, List list) {
        if (list.contains(string)) {
            return;
        }
        boolean bl = false;
        String string2 = this.reader.sourceClassPath;
        if (string2 == null) {
            string2 = this.reader.classPath;
        }
        int n = string2.length();
        int n2 = 0;
        this.messager.notice("main.Loading_source_files_for_package", string);
        string = string.replace('.', File.separatorChar);
        while (n2 < n) {
            int n3 = string2.indexOf(pathSep, n2);
            String string3 = string2.substring(n2, n3);
            File file = new File(string3, string);
            String[] stringArray = file.list();
            if (stringArray != null) {
                String string4 = file.getAbsolutePath();
                if (!string4.endsWith(File.separator)) {
                    string4 = string4 + File.separator;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!JavadocTool.isValidJavaSourceFile(stringArray[i])) continue;
                    String string5 = string4 + stringArray[i];
                    listBuffer.append(this.parse(string5));
                    bl = true;
                }
            }
            n2 = n3 + 1;
        }
        if (!bl) {
            this.messager.warning(null, "main.no_source_files_for_package", string.replace(File.separatorChar, '.'));
        }
    }

    private void searchSubPackages(String string, ListBuffer listBuffer, List list) {
        if (list.contains(string)) {
            return;
        }
        String string2 = this.reader.sourceClassPath + pathSep + this.reader.classPath;
        int n = string2.length();
        int n2 = 0;
        String string3 = string.replace('.', File.separatorChar);
        boolean bl = false;
        while (n2 < n) {
            int n3 = string2.indexOf(pathSep, n2);
            String string4 = string2.substring(n2, n3);
            File file = new File(string4, string3);
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!bl && (JavadocTool.isValidJavaSourceFile(stringArray[i]) || JavadocTool.isValidJavaClassFile(stringArray[i])) && !listBuffer.contains(string)) {
                        listBuffer.append(string);
                        bl = true;
                        continue;
                    }
                    if (!new File(file.getPath(), stringArray[i]).isDirectory()) continue;
                    this.searchSubPackages(string + "." + stringArray[i], listBuffer, list);
                }
            }
            n2 = n3 + 1;
        }
    }

    public RootDocImpl getRootDocImpl(String string, String string2, ModifierFilter modifierFilter, List list, List list2, boolean bl, List list3, List list4, boolean bl2) {
        this.docenv = DocEnv.instance(this.context);
        this.docenv.showAccess = modifierFilter;
        this.docenv.breakiterator = bl;
        this.docenv.setLocale(string);
        this.docenv.setEncoding(string2);
        this.docenv.docClasses = bl2;
        this.reader.sourceCompleter = bl2 ? null : this;
        ListBuffer listBuffer = new ListBuffer();
        ListBuffer listBuffer2 = new ListBuffer();
        ListBuffer listBuffer3 = new ListBuffer();
        try {
            List list5 = list;
            while (list5.nonEmpty()) {
                String string3 = (String)list5.head;
                if (!bl2 && string3.endsWith(".java") && new File(string3).exists()) {
                    this.messager.notice("main.Loading_source_file", string3);
                    Tree.TopLevel topLevel = this.parse(string3);
                    listBuffer2.append(topLevel);
                } else if (this.isValidPackageName(string3)) {
                    listBuffer = listBuffer.append(string3);
                } else if (string3.endsWith(".java")) {
                    this.messager.error(null, "main.file_not_found", string3);
                } else {
                    this.messager.error(null, "main.illegal_package_name", string3);
                }
                list5 = list5.tail;
            }
            if (!bl2) {
                this.searchSubPackages(list3, listBuffer, list4);
                list5 = listBuffer.toList();
                while (list5.nonEmpty()) {
                    this.parsePackageClasses((String)list5.head, listBuffer3, list4);
                    list5 = list5.tail;
                }
                if (this.messager.nerrors() != 0) {
                    return null;
                }
                this.messager.notice("main.Building_tree");
                this.enter.main(listBuffer2.toList().appendList(listBuffer3.toList()));
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        if (this.messager.nerrors() != 0) {
            return null;
        }
        if (bl2) {
            return new RootDocImpl(this.docenv, list, list2);
        }
        return new RootDocImpl(this.docenv, this.listClasses(listBuffer2.toList()), listBuffer.toList(), list2);
    }
}

