/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class IntegerValueImpl
extends PrimitiveValueImpl
implements IntegerValue {
    private int value;

    public byte byteValue() {
        return (byte)this.value;
    }

    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127 || this.value < -128) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    byte typeValueKey() {
        return 73;
    }

    public char charValue() {
        return (char)this.value;
    }

    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int intValue() {
        return this.value;
    }

    public int value() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    short checkedShortValue() throws InvalidTypeException {
        if (this.value > Short.MAX_VALUE || this.value < Short.MIN_VALUE) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    public short shortValue() {
        return (short)this.value;
    }

    public boolean booleanValue() {
        return this.value != 0;
    }

    public Type type() {
        return this.vm.theIntegerType();
    }

    IntegerValueImpl(VirtualMachine virtualMachine, int n) {
        super(virtualMachine);
        this.value = n;
    }

    public int compareTo(Object object) {
        int n = ((IntegerValue)object).value();
        return this.value() - n;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerValue) {
            return this.value == ((IntegerValue)object).value() && super.equals(object);
        }
        return false;
    }

    public String toString() {
        return "" + this.value;
    }
}

