/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.IOException;
import sun.tools.java.AmbiguousClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Imports;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Package;
import sun.tools.java.Type;

public class Environment
implements Constants {
    Environment env;
    String encoding;
    Object source;
    private static boolean debugging = System.getProperty("javac.debug") != null;
    private static boolean dependtrace = System.getProperty("javac.trace.depend") != null;
    private static boolean dumpmodifiers = System.getProperty("javac.dump.modifiers") != null;

    public int getFlags() {
        return this.env.getFlags();
    }

    public short getMajorVersion() {
        if (this.env == null) {
            return 45;
        }
        return this.env.getMajorVersion();
    }

    public short getMinorVersion() {
        if (this.env == null) {
            return 3;
        }
        return this.env.getMinorVersion();
    }

    public Environment() {
        this(null, null);
    }

    public void shutdown() {
        if (this.env != null) {
            this.env.shutdown();
        }
    }

    public final boolean covdata() {
        return (this.getFlags() & 0x80) != 0;
    }

    public final boolean coverage() {
        return (this.getFlags() & 0x40) != 0;
    }

    public final boolean debug_lines() {
        return (this.getFlags() & 0x1000) != 0;
    }

    public final boolean debug_source() {
        return (this.getFlags() & 0x40000) != 0;
    }

    public final boolean debug_vars() {
        return (this.getFlags() & 0x2000) != 0;
    }

    public final boolean dependencies() {
        return (this.getFlags() & 0x20) != 0;
    }

    public final boolean deprecation() {
        return (this.getFlags() & 0x200) != 0;
    }

    public final boolean dump() {
        return (this.getFlags() & 2) != 0;
    }

    public boolean dumpModifiers() {
        return dumpmodifiers;
    }

    public final boolean opt() {
        return (this.getFlags() & 0x4000) != 0;
    }

    public final boolean opt_interclass() {
        return (this.getFlags() & 0x8000) != 0;
    }

    public final boolean print_dependencies() {
        return (this.getFlags() & 0x400) != 0;
    }

    public final boolean strictdefault() {
        return (this.getFlags() & 0x20000) != 0;
    }

    public final boolean verbose() {
        return (this.getFlags() & 1) != 0;
    }

    public final boolean version12() {
        return (this.getFlags() & 0x800) != 0;
    }

    public final boolean warnings() {
        return (this.getFlags() & 4) != 0;
    }

    public File getcovFile() {
        return this.env.getcovFile();
    }

    public final Object getSource() {
        return this.source;
    }

    public static void debugOutput(Object object) {
        if (debugging) {
            System.out.println(object.toString());
        }
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public final void error(long l, String string) {
        this.error(this.source, l, string, null, null, null);
    }

    public void dtEnter(String string) {
        if (dependtrace) {
            System.out.println(">>> " + string);
        }
    }

    public void dtEvent(String string) {
        if (dependtrace) {
            System.out.println(string);
        }
    }

    public void dtExit(String string) {
        if (dependtrace) {
            System.out.println("<<< " + string);
        }
    }

    public void output(String string) {
        this.env.output(string);
    }

    public void setCharacterEncoding(String string) {
        this.encoding = string;
    }

    public void loadDefinition(ClassDeclaration classDeclaration) {
        this.env.loadDefinition(classDeclaration);
    }

    public boolean classExists(Identifier identifier) {
        return this.env.classExists(identifier);
    }

    public boolean isExemptPackage(Identifier identifier) {
        return this.env.isExemptPackage(identifier);
    }

    public Imports getImports() {
        if (this.env == null) {
            return null;
        }
        return this.env.getImports();
    }

    public final boolean classExists(Type type) {
        return !type.isType(10) || this.classExists(type.getClassName());
    }

    public final void error(long l, String string, Object object) {
        this.error(this.source, l, string, object, null, null);
    }

    public Environment(Environment environment, Object object) {
        if (environment != null && environment.env != null && environment.getClass() == this.getClass()) {
            environment = environment.env;
        }
        this.env = environment;
        this.source = object;
    }

    public ClassDeclaration getClassDeclaration(Identifier identifier) {
        return this.env.getClassDeclaration(identifier);
    }

    public ClassDeclaration getClassDeclaration(Type type) {
        return this.getClassDeclaration(type.getClassName());
    }

    public final ClassDefinition getClassDefinition(Identifier identifier) throws ClassNotFound {
        if (identifier.isInner()) {
            Constants constants = this.getClassDefinition(identifier.getTopName());
            Identifier identifier2 = identifier.getFlatName();
            block0: while (identifier2.isQualified()) {
                Constants constants2;
                Identifier identifier3 = (identifier2 = identifier2.getTail()).getHead();
                String string = identifier3.toString();
                if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
                    constants2 = constants.getLocalClass(string);
                    if (constants2 != null) {
                        constants = constants2;
                        continue;
                    }
                } else {
                    for (constants2 = constants.getFirstMatch(identifier3); constants2 != null; constants2 = ((MemberDefinition)constants2).getNextMatch()) {
                        if (!((MemberDefinition)constants2).isInnerClass()) continue;
                        constants = ((MemberDefinition)constants2).getInnerClass();
                        continue block0;
                    }
                }
                throw new ClassNotFound(Identifier.lookupInner(constants.getName(), identifier3));
            }
            return constants;
        }
        return this.getClassDeclaration(identifier).getClassDefinition(this);
    }

    public final ClassDefinition getClassDefinition(Type type) throws ClassNotFound {
        return this.getClassDefinition(type.getClassName());
    }

    public boolean resolveByName(long l, ClassDefinition classDefinition, Identifier identifier) {
        return this.resolveByName(l, classDefinition, identifier, false);
    }

    public boolean resolveExtendsByName(long l, ClassDefinition classDefinition, Identifier identifier) {
        return this.resolveByName(l, classDefinition, identifier, true);
    }

    private boolean resolveByName(long l, ClassDefinition classDefinition, Identifier identifier, boolean bl) {
        try {
            if (!(identifier.isQualified() || identifier.isInner() || this.classExists(identifier))) {
                this.resolve(identifier);
            }
            ClassDefinition classDefinition2 = this.getQualifiedClassDefinition(l, identifier, classDefinition, bl);
            ClassDeclaration classDeclaration = classDefinition2.getClassDeclaration();
            if (!(!bl && classDefinition.canAccess(this, classDeclaration) || bl && classDefinition.extendsCanAccess(this, classDeclaration))) {
                this.error(l, "cant.access.class", classDefinition2);
                return true;
            }
        }
        catch (AmbiguousClass ambiguousClass) {
            this.error(l, "ambig.class", ambiguousClass.name1, ambiguousClass.name2);
            return false;
        }
        catch (ClassNotFound classNotFound) {
            try {
                if (classNotFound.name.isInner() && this.getPackage(classNotFound.name.getTopName()).exists()) {
                    this.env.error(l, "class.and.package", classNotFound.name.getTopName());
                }
            }
            catch (IOException iOException) {
                this.env.error(l, "io.exception", "package check");
            }
            this.error(l, "class.not.found", classNotFound.name, "type name");
            return false;
        }
        return true;
    }

    public Identifier resolve(Identifier identifier) throws ClassNotFound {
        if (this.env == null) {
            return identifier;
        }
        return this.env.resolve(identifier);
    }

    public Identifier resolveName(Identifier identifier) {
        if (identifier.isQualified()) {
            Identifier identifier2 = this.resolveName(identifier.getHead());
            if (identifier2.hasAmbigPrefix()) {
                return identifier2;
            }
            if (!this.classExists(identifier2)) {
                return this.resolvePackageQualifiedName(identifier);
            }
            try {
                return this.getClassDefinition(identifier2).resolveInnerClass(this, identifier.getTail());
            }
            catch (ClassNotFound classNotFound) {
                return Identifier.lookupInner(identifier2, identifier.getTail());
            }
        }
        try {
            return this.resolve(identifier);
        }
        catch (AmbiguousClass ambiguousClass) {
            if (identifier.hasAmbigPrefix()) {
                return identifier;
            }
            return identifier.addAmbigPrefix();
        }
        catch (ClassNotFound classNotFound) {
            Imports imports = this.getImports();
            if (imports != null) {
                return imports.forceResolve(this, identifier);
            }
            return identifier;
        }
    }

    public final Identifier resolvePackageQualifiedName(Identifier identifier) {
        Identifier identifier2 = null;
        while (!this.classExists(identifier)) {
            if (!identifier.isQualified()) {
                identifier = identifier2 == null ? identifier : Identifier.lookup(identifier, identifier2);
                identifier2 = null;
                break;
            }
            Identifier identifier3 = identifier.getName();
            identifier2 = identifier2 == null ? identifier3 : Identifier.lookup(identifier3, identifier2);
            identifier = identifier.getQualifier();
        }
        if (identifier2 != null) {
            identifier = Identifier.lookupInner(identifier, identifier2);
        }
        return identifier;
    }

    public boolean isMoreSpecific(MemberDefinition memberDefinition, MemberDefinition memberDefinition2) throws ClassNotFound {
        Type type;
        Type type2 = memberDefinition.getClassDeclaration().getType();
        boolean bl = this.isMoreSpecific(type2, type = memberDefinition2.getClassDeclaration().getType()) && this.isApplicable(memberDefinition2, memberDefinition.getType().getArgumentTypes());
        return bl;
    }

    public Package getPackage(Identifier identifier) throws IOException {
        return this.env.getPackage(identifier);
    }

    public boolean resolve(long l, ClassDefinition classDefinition, Type type) {
        switch (type.getTypeCode()) {
            case 10: {
                try {
                    ClassDefinition classDefinition2;
                    Identifier identifier = type.getClassName();
                    if (!(identifier.isQualified() || identifier.isInner() || this.classExists(identifier))) {
                        this.resolve(identifier);
                    }
                    if (!classDefinition.canAccess(this, (classDefinition2 = this.getQualifiedClassDefinition(l, identifier, classDefinition, false)).getClassDeclaration())) {
                        this.error(l, "cant.access.class", classDefinition2);
                        return true;
                    }
                    classDefinition2.noteUsedBy(classDefinition, l, this.env);
                }
                catch (AmbiguousClass ambiguousClass) {
                    this.error(l, "ambig.class", ambiguousClass.name1, ambiguousClass.name2);
                    return false;
                }
                catch (ClassNotFound classNotFound) {
                    try {
                        if (classNotFound.name.isInner() && this.getPackage(classNotFound.name.getTopName()).exists()) {
                            this.env.error(l, "class.and.package", classNotFound.name.getTopName());
                        }
                    }
                    catch (IOException iOException) {
                        this.env.error(l, "io.exception", "package check");
                    }
                    this.error(l, "class.not.found.no.context", classNotFound.name);
                    return false;
                }
                return true;
            }
            case 9: {
                return this.resolve(l, classDefinition, type.getElementType());
            }
            case 12: {
                boolean bl = this.resolve(l, classDefinition, type.getReturnType());
                Type[] typeArray = type.getArgumentTypes();
                int n = typeArray.length;
                while (n-- > 0) {
                    bl &= this.resolve(l, classDefinition, typeArray[n]);
                }
                return bl;
            }
        }
        return true;
    }

    public boolean isApplicable(MemberDefinition memberDefinition, Type[] typeArray) throws ClassNotFound {
        Type type = memberDefinition.getType();
        if (!type.isType(12)) {
            return false;
        }
        Type[] typeArray2 = type.getArgumentTypes();
        if (typeArray.length != typeArray2.length) {
            return false;
        }
        int n = typeArray.length;
        while (--n >= 0) {
            if (this.isMoreSpecific(typeArray[n], typeArray2[n])) continue;
            return false;
        }
        return true;
    }

    public boolean explicitCast(Type type, Type type2) throws ClassNotFound {
        if (this.implicitCast(type, type2)) {
            return true;
        }
        if (type.inMask(254)) {
            return type2.inMask(254);
        }
        if (type.isType(10) && type2.isType(10)) {
            ClassDefinition classDefinition = this.getClassDefinition(type);
            ClassDefinition classDefinition2 = this.getClassDefinition(type2);
            if (classDefinition2.isFinal()) {
                return classDefinition.implementedBy(this, classDefinition2.getClassDeclaration());
            }
            if (classDefinition.isFinal()) {
                return classDefinition2.implementedBy(this, classDefinition.getClassDeclaration());
            }
            if (classDefinition2.isInterface() && classDefinition.isInterface()) {
                return classDefinition2.couldImplement(classDefinition);
            }
            return classDefinition2.isInterface() || classDefinition.isInterface() || classDefinition.superClassOf(this, classDefinition2.getClassDeclaration());
        }
        if (type2.isType(9)) {
            if (type.isType(9)) {
                Type type3 = type.getElementType();
                Type type4 = type2.getElementType();
                while (type3.getTypeCode() == 9 && type4.getTypeCode() == 9) {
                    type3 = type3.getElementType();
                    type4 = type4.getElementType();
                }
                if (type3.inMask(1536) && type4.inMask(1536)) {
                    return this.explicitCast(type3, type4);
                }
            } else if (type == Type.tObject || type == Type.tCloneable || type == Type.tSerializable) {
                return true;
            }
        }
        return false;
    }

    public boolean implicitCast(Type type, Type type2) throws ClassNotFound {
        if (type == type2) {
            return true;
        }
        int n = type2.getTypeCode();
        switch (type.getTypeCode()) {
            case 1: {
                if (n == 3) {
                    return true;
                }
            }
            case 2: 
            case 3: {
                if (n == 4) {
                    return true;
                }
            }
            case 4: {
                if (n == 5) {
                    return true;
                }
            }
            case 5: {
                if (n == 6) {
                    return true;
                }
            }
            case 6: {
                if (n == 7) {
                    return true;
                }
            }
            default: {
                return false;
            }
            case 8: {
                return type2.inMask(1792);
            }
            case 9: {
                if (!type2.isType(9)) {
                    return type2 == Type.tObject || type2 == Type.tCloneable || type2 == Type.tSerializable;
                }
                do {
                    type = type.getElementType();
                    type2 = type2.getElementType();
                } while (type.isType(9) && type2.isType(9));
                if (type.inMask(1536) && type2.inMask(1536)) {
                    return this.isMoreSpecific(type, type2);
                }
                return type.getTypeCode() == type2.getTypeCode();
            }
            case 10: 
        }
        if (n == 10) {
            ClassDefinition classDefinition = this.getClassDefinition(type);
            ClassDefinition classDefinition2 = this.getClassDefinition(type2);
            return classDefinition2.implementedBy(this, classDefinition.getClassDeclaration());
        }
        return false;
    }

    public boolean isMoreSpecific(Type type, Type type2) throws ClassNotFound {
        return this.implicitCast(type, type2);
    }

    public final void error(long l, String string, Object object, Object object2) {
        this.error(this.source, l, string, object, object2, null);
    }

    public final ClassDefinition getQualifiedClassDefinition(long l, Identifier identifier, ClassDefinition classDefinition, boolean bl) throws ClassNotFound {
        if (identifier.isInner()) {
            Constants constants = this.getClassDefinition(identifier.getTopName());
            Identifier identifier2 = identifier.getFlatName();
            block0: while (identifier2.isQualified()) {
                Constants constants2;
                Identifier identifier3 = (identifier2 = identifier2.getTail()).getHead();
                String string = identifier3.toString();
                if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
                    constants2 = ((ClassDefinition)constants).getLocalClass(string);
                    if (constants2 != null) {
                        constants = constants2;
                        continue;
                    }
                } else {
                    for (constants2 = ((ClassDefinition)constants).getFirstMatch(identifier3); constants2 != null; constants2 = ((MemberDefinition)constants2).getNextMatch()) {
                        if (!((MemberDefinition)constants2).isInnerClass()) continue;
                        ClassDeclaration classDeclaration = ((ClassDefinition)constants).getClassDeclaration();
                        constants = ((MemberDefinition)constants2).getInnerClass();
                        ClassDeclaration classDeclaration2 = ((ClassDefinition)constants).getClassDeclaration();
                        if ((bl || classDefinition.canAccess(this.env, classDeclaration2)) && (!bl || classDefinition.extendsCanAccess(this.env, classDeclaration2))) continue block0;
                        this.env.error(l, "no.type.access", identifier3, classDeclaration, classDefinition);
                        continue block0;
                    }
                }
                throw new ClassNotFound(Identifier.lookupInner(((ClassDefinition)constants).getName(), identifier3));
            }
            return constants;
        }
        return this.getClassDeclaration(identifier).getClassDefinition(this);
    }

    public Type resolveNames(ClassDefinition classDefinition, Type type, boolean bl) {
        this.dtEvent("Environment.resolveNames: " + classDefinition + ", " + type);
        switch (type.getTypeCode()) {
            case 10: {
                Identifier identifier = type.getClassName();
                Identifier identifier2 = bl ? this.resolvePackageQualifiedName(identifier) : classDefinition.resolveName(this, identifier);
                if (identifier == identifier2) break;
                type = Type.tClass(identifier2);
                break;
            }
            case 9: {
                type = Type.tArray(this.resolveNames(classDefinition, type.getElementType(), bl));
                break;
            }
            case 12: {
                Type type2 = type.getReturnType();
                Type type3 = this.resolveNames(classDefinition, type2, bl);
                Type[] typeArray = type.getArgumentTypes();
                Type[] typeArray2 = new Type[typeArray.length];
                boolean bl2 = type2 != type3;
                int n = typeArray.length;
                while (n-- > 0) {
                    Type type4;
                    Type type5 = typeArray[n];
                    typeArray2[n] = type4 = this.resolveNames(classDefinition, type5, bl);
                    if (type5 == type4) continue;
                    bl2 = true;
                }
                if (!bl2) break;
                type = Type.tMethod(type3, typeArray2);
            }
        }
        return type;
    }

    public final void error(long l, String string, Object object, Object object2, Object object3) {
        this.error(this.source, l, string, object, object2, object3);
    }

    public void error(Object object, long l, String string, Object object2, Object object3, Object object4) {
        this.env.error(object, l, string, object2, object3, object4);
    }

    public ClassDefinition makeClassDefinition(Environment environment, long l, IdentifierToken identifierToken, String string, int n, IdentifierToken identifierToken2, IdentifierToken[] identifierTokenArray, ClassDefinition classDefinition) {
        if (this.env == null) {
            return null;
        }
        return this.env.makeClassDefinition(environment, l, identifierToken, string, n, identifierToken2, identifierTokenArray, classDefinition);
    }

    public MemberDefinition makeMemberDefinition(Environment environment, long l, ClassDefinition classDefinition, String string, int n, Type type, Identifier identifier, IdentifierToken[] identifierTokenArray, IdentifierToken[] identifierTokenArray2, Object object) {
        if (this.env == null) {
            return null;
        }
        return this.env.makeMemberDefinition(environment, l, classDefinition, string, n, type, identifier, identifierTokenArray, identifierTokenArray2, object);
    }
}

