/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import sun.tools.javap.AttrData;
import sun.tools.javap.ClassData;
import sun.tools.javap.RuntimeConstants;
import sun.tools.javap.TypeSignature;

public class FieldData
implements RuntimeConstants {
    ClassData cls;
    int access;
    int name_index;
    int descriptor_index;
    int attributes_count;
    int value_cpx = 0;
    boolean isSynthetic = false;
    boolean isDeprecated = false;
    Vector attrs;

    public int getConstantValueIndex() {
        return this.value_cpx;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.access = dataInputStream.readUnsignedShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.descriptor_index = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        this.attrs = new Vector(n);
        for (int i = 0; i < n; ++i) {
            AttrData attrData;
            int n2 = dataInputStream.readUnsignedShort();
            if (this.cls.getTag(n2) != 1) continue;
            String string = this.cls.getString(n2);
            if (string.equals("ConstantValue")) {
                if (dataInputStream.readInt() != 2) {
                    throw new ClassFormatError("invalid ConstantValue attr length");
                }
                this.value_cpx = dataInputStream.readUnsignedShort();
                attrData = new AttrData(this.cls);
                attrData.read(n2);
                this.attrs.addElement(attrData);
                continue;
            }
            if (string.equals("Synthetic")) {
                if (dataInputStream.readInt() != 0) {
                    throw new ClassFormatError("invalid Synthetic attr length");
                }
                this.isSynthetic = true;
                attrData = new AttrData(this.cls);
                attrData.read(n2);
                this.attrs.addElement(attrData);
                continue;
            }
            if (string.equals("Deprecated")) {
                if (dataInputStream.readInt() != 0) {
                    throw new ClassFormatError("invalid Synthetic attr length");
                }
                this.isDeprecated = true;
                attrData = new AttrData(this.cls);
                attrData.read(n2);
                this.attrs.addElement(attrData);
                continue;
            }
            attrData = new AttrData(this.cls);
            attrData.read(n2, dataInputStream);
            this.attrs.addElement(attrData);
        }
    }

    public String getInternalSig() {
        return this.cls.getStringValue(this.descriptor_index);
    }

    public String getName() {
        return this.cls.getStringValue(this.name_index);
    }

    public String getType() {
        return new TypeSignature(this.getInternalSig()).getFieldType();
    }

    public String[] getAccess() {
        Vector<String> vector = new Vector<String>();
        if ((this.access & 1) != 0) {
            vector.addElement("public");
        }
        if ((this.access & 2) != 0) {
            vector.addElement("private");
        }
        if ((this.access & 4) != 0) {
            vector.addElement("protected");
        }
        if ((this.access & 8) != 0) {
            vector.addElement("static");
        }
        if ((this.access & 0x10) != 0) {
            vector.addElement("final");
        }
        if ((this.access & 0x40) != 0) {
            vector.addElement("volatile");
        }
        if ((this.access & 0x80) != 0) {
            vector.addElement("transient");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Vector getAttributes() {
        return this.attrs;
    }

    public FieldData(ClassData classData) {
        this.cls = classData;
    }
}

