/** \ingroup BC_m
 * \file blockpad.c
 *
 * Blockcipher padding, code.
 */

/*
 * Copyright (c) 2000, 2001 Virtual Unlimited B.V.
 *
 * Author: Bob Deblier <bob@virtualunlimited.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "system.h"
#include "blockpad.h"
#include "debug.h"

/*@-boundswrite@*/
memchunk* pkcs5Pad(int blockbytes, memchunk* tmp)
{
	if (tmp)
	{
		byte padvalue = blockbytes - (tmp->size % blockbytes);

		tmp = memchunkResize(tmp, tmp->size + padvalue);

		if (tmp)
			memset(tmp->data - padvalue, padvalue, padvalue);
	}

	return tmp;
}
/*@=boundswrite@*/

/*@-boundsread@*/
memchunk* pkcs5Unpad(int blockbytes, memchunk* tmp)
{
	if (tmp)
	{
		byte padvalue;
		int i;

		if (tmp->data == (byte*) 0)
			return (memchunk*) 0;
		padvalue = tmp->data[tmp->size - 1];
		if (padvalue > blockbytes)
			return (memchunk*) 0;

		for (i = (tmp->size - padvalue); i < (tmp->size - 1); i++)
		{
			if (tmp->data[i] != padvalue)
				return (memchunk*) 0;
		}

		tmp->size -= padvalue;
/*		tmp->data = (byte*) realloc(tmp->data, tmp->size; */
	}

	/*@-temptrans -compdef @*/
	return tmp;
	/*@=temptrans =compdef @*/
}
/*@=boundsread@*/

/*@-boundswrite@*/
memchunk* pkcs5PadCopy(int blockbytes, const memchunk* src)
{
	memchunk* tmp;
	byte padvalue = blockbytes - (src->size % blockbytes);

	if (src == (memchunk*) 0)
		return (memchunk*) 0;

	tmp = memchunkAlloc(src->size + padvalue);

	if (tmp)
	{
		memcpy(tmp->data, src->data, src->size);
		memset(tmp->data+src->size, padvalue, padvalue);
	}

	return tmp;
}
/*@=boundswrite@*/

/*@-boundswrite@*/
memchunk* pkcs5UnpadCopy(/*@unused@*/ int blockbytes, const memchunk* src)
{
	memchunk* tmp;
	byte padvalue;
	int i;

	if (src == (memchunk*) 0)
		return (memchunk*) 0;
	if (src->data == (byte*) 0)
		return (memchunk*) 0;

	padvalue = src->data[src->size - 1];

	for (i = (src->size - padvalue); i < (src->size - 1); i++)
	{
		if (src->data[i] != padvalue)
			return (memchunk*) 0;
	}

	tmp = memchunkAlloc(src->size - padvalue);

	if (tmp)
		memcpy(tmp->data, src->data, tmp->size);

	return tmp;
}
/*@=boundswrite@*/
