#
#  fmt_info.pl
#
#  $Id: fmt_info.pl,v 1.3 1997/09/11 22:27:30 cg Exp $
#
#  GNU Info-specific driver stuff
#
#   Copyright 1996, Cees de Groot
#
package SGMLTools::fmt_info;
use strict;

use SGMLTools::Vars;

use File::Copy;

my $info = {};
$info->{NAME} = "info";
$info->{HELP} = "";
$info->{OPTIONS} = [
];
$info->{preNSGMLS} = sub {
  $global->{NsgmlsOpts} .= " -ifmtinfo ";
  $global->{NsgmlsPrePipe} = "sed 's/\@/\@\@/g' $global->{file}";
};

$Formats{$info->{NAME}} = $info;

#
#  Take the sgmlsasp output, and make something
#  useful from it.
#
$info->{postASP} = sub
{
  my $infile = shift;
  my $outfile = new FileHandle ">$global->{tmpbase}.info.1";

  copy ($infile, $outfile); 
  $outfile->close;
  system ("gawk -v INFO=$global->{filename}.info -f $main::LibDir/info.awk $global->{tmpbase}.info.1 >$global->{tmpbase}.info.2");
  system ("makeinfo $global->{tmpbase}.info.2 -o $global->{filename}.info");

  return 0;
};

1;
