/* A Bison parser, made by Lrama 0.7.1.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* First part of user prologue.  */
#line 12 "parse.y"


#if !YYPURE
# error needs pure parser
#endif
#define YYDEBUG 1
#define YYERROR_VERBOSE 1
#define YYSTACK_USE_ALLOCA 0

/* For Ripper */
#ifdef RUBY_EXTCONF_H
# include RUBY_EXTCONF_H
#endif

#include "ruby/internal/config.h"

#include <errno.h>

#ifdef UNIVERSAL_PARSER

#include "internal/ruby_parser.h"
#include "parser_node.h"
#include "universal_parser.c"

#ifdef RIPPER
#define STATIC_ID2SYM p->config->static_id2sym
#define rb_str_coderange_scan_restartable p->config->str_coderange_scan_restartable
#endif

#else

#include "internal.h"
#include "internal/compile.h"
#include "internal/compilers.h"
#include "internal/complex.h"
#include "internal/encoding.h"
#include "internal/error.h"
#include "internal/hash.h"
#include "internal/io.h"
#include "internal/numeric.h"
#include "internal/parse.h"
#include "internal/rational.h"
#include "internal/re.h"
#include "internal/ruby_parser.h"
#include "internal/symbol.h"
#include "internal/thread.h"
#include "internal/variable.h"
#include "node.h"
#include "parser_node.h"
#include "probes.h"
#include "regenc.h"
#include "ruby/encoding.h"
#include "ruby/regex.h"
#include "ruby/ruby.h"
#include "ruby/st.h"
#include "ruby/util.h"
#include "ruby/ractor.h"
#include "symbol.h"

#ifndef RIPPER
static VALUE
syntax_error_new(void)
{
    return rb_class_new_instance(0, 0, rb_eSyntaxError);
}
#endif

static NODE *reg_named_capture_assign(struct parser_params* p, VALUE regexp, const YYLTYPE *loc, rb_parser_assignable_func assignable);

#define compile_callback rb_suppress_tracing
#endif /* !UNIVERSAL_PARSER */

#define NODE_SPECIAL_EMPTY_ARGS ((NODE *)-1)
#define NODE_EMPTY_ARGS_P(node) ((node) == NODE_SPECIAL_EMPTY_ARGS)

static int rb_parser_string_hash_cmp(rb_parser_string_t *str1, rb_parser_string_t *str2);

#ifndef RIPPER
static rb_parser_string_t *rb_parser_string_deep_copy(struct parser_params *p, const rb_parser_string_t *original);
#endif

static int
node_integer_cmp(rb_node_integer_t *n1, rb_node_integer_t *n2)
{
    return (n1->minus != n2->minus ||
            n1->base != n2->base ||
            strcmp(n1->val, n2->val));
}

static int
node_float_cmp(rb_node_float_t *n1, rb_node_float_t *n2)
{
    return (n1->minus != n2->minus ||
            strcmp(n1->val, n2->val));
}

static int
node_rational_cmp(rb_node_rational_t *n1, rb_node_rational_t *n2)
{
    return (n1->minus != n2->minus ||
            n1->base != n2->base ||
            n1->seen_point != n2->seen_point ||
            strcmp(n1->val, n2->val));
}

static int
node_imaginary_cmp(rb_node_imaginary_t *n1, rb_node_imaginary_t *n2)
{
    return (n1->minus != n2->minus ||
            n1->base != n2->base ||
            n1->seen_point != n2->seen_point ||
            n1->type != n2->type ||
            strcmp(n1->val, n2->val));
}

static int
rb_parser_regx_hash_cmp(rb_node_regx_t *n1, rb_node_regx_t *n2)
{
    return (n1->options != n2->options ||
            rb_parser_string_hash_cmp(n1->string, n2->string));
}

static st_index_t rb_parser_str_hash(rb_parser_string_t *str);
static st_index_t rb_char_p_hash(const char *c);

static int
literal_cmp(st_data_t val, st_data_t lit)
{
    if (val == lit) return 0;

    NODE *node_val = RNODE(val);
    NODE *node_lit = RNODE(lit);
    enum node_type type_val = nd_type(node_val);
    enum node_type type_lit = nd_type(node_lit);

    if (type_val != type_lit) {
        return -1;
    }

    switch (type_lit) {
      case NODE_INTEGER:
        return node_integer_cmp(RNODE_INTEGER(node_val), RNODE_INTEGER(node_lit));
      case NODE_FLOAT:
        return node_float_cmp(RNODE_FLOAT(node_val), RNODE_FLOAT(node_lit));
      case NODE_RATIONAL:
        return node_rational_cmp(RNODE_RATIONAL(node_val), RNODE_RATIONAL(node_lit));
      case NODE_IMAGINARY:
        return node_imaginary_cmp(RNODE_IMAGINARY(node_val), RNODE_IMAGINARY(node_lit));
      case NODE_STR:
        return rb_parser_string_hash_cmp(RNODE_STR(node_val)->string, RNODE_STR(node_lit)->string);
      case NODE_SYM:
        return rb_parser_string_hash_cmp(RNODE_SYM(node_val)->string, RNODE_SYM(node_lit)->string);
      case NODE_REGX:
        return rb_parser_regx_hash_cmp(RNODE_REGX(node_val), RNODE_REGX(node_lit));
      case NODE_LINE:
        return node_val->nd_loc.beg_pos.lineno != node_lit->nd_loc.beg_pos.lineno;
      case NODE_FILE:
        return rb_parser_string_hash_cmp(RNODE_FILE(node_val)->path, RNODE_FILE(node_lit)->path);
      case NODE_ENCODING:
        return RNODE_ENCODING(node_val)->enc != RNODE_ENCODING(node_lit)->enc;
      default:
#ifdef UNIVERSAL_PARSER
        abort();
#else
        rb_bug("unexpected node: %s, %s", ruby_node_name(type_val), ruby_node_name(type_lit));
#endif
    }
}

static st_index_t
literal_hash(st_data_t a)
{
    NODE *node = (NODE *)a;
    enum node_type type = nd_type(node);

    switch (type) {
      case NODE_INTEGER:
        return rb_char_p_hash(RNODE_INTEGER(node)->val);
      case NODE_FLOAT:
        return rb_char_p_hash(RNODE_FLOAT(node)->val);
      case NODE_RATIONAL:
        return rb_char_p_hash(RNODE_RATIONAL(node)->val);
      case NODE_IMAGINARY:
        return rb_char_p_hash(RNODE_IMAGINARY(node)->val);
      case NODE_STR:
        return rb_parser_str_hash(RNODE_STR(node)->string);
      case NODE_SYM:
        return rb_parser_str_hash(RNODE_SYM(node)->string);
      case NODE_REGX:
        return rb_parser_str_hash(RNODE_REGX(node)->string);
      case NODE_LINE:
        return (st_index_t)node->nd_loc.beg_pos.lineno;
      case NODE_FILE:
        return rb_parser_str_hash(RNODE_FILE(node)->path);
      case NODE_ENCODING:
        return (st_index_t)RNODE_ENCODING(node)->enc;
      default:
#ifdef UNIVERSAL_PARSER
        abort();
#else
        rb_bug("unexpected node: %s", ruby_node_name(type));
#endif
    }
}

static inline int
parse_isascii(int c)
{
    return '\0' <= c && c <= '\x7f';
}

#undef ISASCII
#define ISASCII parse_isascii

static inline int
parse_isspace(int c)
{
    return c == ' ' || ('\t' <= c && c <= '\r');
}

#undef ISSPACE
#define ISSPACE parse_isspace

static inline int
parse_iscntrl(int c)
{
    return ('\0' <= c && c < ' ') || c == '\x7f';
}

#undef ISCNTRL
#define ISCNTRL(c) parse_iscntrl(c)

static inline int
parse_isupper(int c)
{
    return 'A' <= c && c <= 'Z';
}

static inline int
parse_islower(int c)
{
    return 'a' <= c && c <= 'z';
}

static inline int
parse_isalpha(int c)
{
    return parse_isupper(c) || parse_islower(c);
}

#undef ISALPHA
#define ISALPHA(c) parse_isalpha(c)

static inline int
parse_isdigit(int c)
{
    return '0' <= c && c <= '9';
}

#undef ISDIGIT
#define ISDIGIT(c) parse_isdigit(c)

static inline int
parse_isalnum(int c)
{
    return ISALPHA(c) || ISDIGIT(c);
}

#undef ISALNUM
#define ISALNUM(c) parse_isalnum(c)

static inline int
parse_isxdigit(int c)
{
    return ISDIGIT(c) || ('A' <= c && c <= 'F') || ('a' <= c && c <= 'f');
}

#undef ISXDIGIT
#define ISXDIGIT(c) parse_isxdigit(c)

#include "parser_st.h"

#undef STRCASECMP
#define STRCASECMP rb_parser_st_locale_insensitive_strcasecmp

#undef STRNCASECMP
#define STRNCASECMP rb_parser_st_locale_insensitive_strncasecmp

#ifdef RIPPER
#include "ripper_init.h"
#endif

enum rescue_context {
    before_rescue,
    after_rescue,
    after_else,
    after_ensure,
};

struct lex_context {
    unsigned int in_defined: 1;
    unsigned int in_kwarg: 1;
    unsigned int in_argdef: 1;
    unsigned int in_def: 1;
    unsigned int in_class: 1;
    unsigned int has_trailing_semicolon: 1;
    BITFIELD(enum rb_parser_shareability, shareable_constant_value, 2);
    BITFIELD(enum rescue_context, in_rescue, 2);
    unsigned int cant_return: 1;
    unsigned int in_alt_pattern: 1;
    unsigned int capture_in_pattern: 1;
};

typedef struct RNode_DEF_TEMP rb_node_def_temp_t;

#if defined(__GNUC__) && !defined(__clang__)
// Suppress "parameter passing for argument of type 'struct
// lex_context' changed" notes.  `struct lex_context` is file scope,
// and has no ABI compatibility issue.
RBIMPL_WARNING_PUSH()
RBIMPL_WARNING_IGNORED(-Wpsabi)
RBIMPL_WARNING_POP()
// Not sure why effective even after popped.
#endif

#include "parse.h"

#define NO_LEX_CTXT (struct lex_context){0}

#ifndef WARN_PAST_SCOPE
# define WARN_PAST_SCOPE 0
#endif

#define TAB_WIDTH 8

#define yydebug (p->debug)	/* disable the global variable definition */

#define YYFPRINTF(out, ...)	rb_parser_printf(p, __VA_ARGS__)
#define YY_LOCATION_PRINT(File, loc, p) \
     rb_parser_printf(p, "%d.%d-%d.%d", \
                      (loc).beg_pos.lineno, (loc).beg_pos.column,\
                      (loc).end_pos.lineno, (loc).end_pos.column)
#define YYLLOC_DEFAULT(Current, Rhs, N)					\
    do									\
      if (N)								\
        {								\
          (Current).beg_pos = YYRHSLOC(Rhs, 1).beg_pos;			\
          (Current).end_pos = YYRHSLOC(Rhs, N).end_pos;			\
        }								\
      else								\
        {                                                               \
          (Current).beg_pos = YYRHSLOC(Rhs, 0).end_pos;                 \
          (Current).end_pos = YYRHSLOC(Rhs, 0).end_pos;                 \
        }                                                               \
    while (0)
#define YY_(Msgid) \
    (((Msgid)[0] == 'm') && (strcmp((Msgid), "memory exhausted") == 0) ? \
     "nesting too deep" : (Msgid))

#define RUBY_SET_YYLLOC_FROM_STRTERM_HEREDOC(Current)			\
    rb_parser_set_location_from_strterm_heredoc(p, &p->lex.strterm->u.heredoc, &(Current))
#define RUBY_SET_YYLLOC_OF_DELAYED_TOKEN(Current)			\
    rb_parser_set_location_of_delayed_token(p, &(Current))
#define RUBY_SET_YYLLOC_OF_HEREDOC_END(Current)				\
    rb_parser_set_location_of_heredoc_end(p, &(Current))
#define RUBY_SET_YYLLOC_OF_DUMMY_END(Current)				\
    rb_parser_set_location_of_dummy_end(p, &(Current))
#define RUBY_SET_YYLLOC_OF_NONE(Current)				\
    rb_parser_set_location_of_none(p, &(Current))
#define RUBY_SET_YYLLOC(Current)					\
    rb_parser_set_location(p, &(Current))
#define RUBY_INIT_YYLLOC() \
    { \
        {p->ruby_sourceline, (int)(p->lex.ptok - p->lex.pbeg)}, \
        {p->ruby_sourceline, (int)(p->lex.pcur - p->lex.pbeg)}, \
    }

#define IS_lex_state_for(x, ls)	((x) & (ls))
#define IS_lex_state_all_for(x, ls) (((x) & (ls)) == (ls))
#define IS_lex_state(ls)	IS_lex_state_for(p->lex.state, (ls))
#define IS_lex_state_all(ls)	IS_lex_state_all_for(p->lex.state, (ls))

# define SET_LEX_STATE(ls) \
    parser_set_lex_state(p, ls, __LINE__)
static inline enum lex_state_e parser_set_lex_state(struct parser_params *p, enum lex_state_e ls, int line);

typedef VALUE stack_type;

static const rb_code_location_t NULL_LOC = { {0, -1}, {0, -1} };

# define SHOW_BITSTACK(stack, name) (p->debug ? rb_parser_show_bitstack(p, stack, name, __LINE__) : (void)0)
# define BITSTACK_PUSH(stack, n) (((p->stack) = ((p->stack)<<1)|((n)&1)), SHOW_BITSTACK(p->stack, #stack"(push)"))
# define BITSTACK_POP(stack)	 (((p->stack) = (p->stack) >> 1), SHOW_BITSTACK(p->stack, #stack"(pop)"))
# define BITSTACK_SET_P(stack)	 (SHOW_BITSTACK(p->stack, #stack), (p->stack)&1)
# define BITSTACK_SET(stack, n)	 ((p->stack)=(n), SHOW_BITSTACK(p->stack, #stack"(set)"))

/* A flag to identify keyword_do_cond, "do" keyword after condition expression.
   Examples: `while ... do`, `until ... do`, and `for ... in ... do` */
#define COND_PUSH(n)	BITSTACK_PUSH(cond_stack, (n))
#define COND_POP()	BITSTACK_POP(cond_stack)
#define COND_P()	BITSTACK_SET_P(cond_stack)
#define COND_SET(n)	BITSTACK_SET(cond_stack, (n))

/* A flag to identify keyword_do_block; "do" keyword after command_call.
   Example: `foo 1, 2 do`. */
#define CMDARG_PUSH(n)	BITSTACK_PUSH(cmdarg_stack, (n))
#define CMDARG_POP()	BITSTACK_POP(cmdarg_stack)
#define CMDARG_P()	BITSTACK_SET_P(cmdarg_stack)
#define CMDARG_SET(n)	BITSTACK_SET(cmdarg_stack, (n))

struct vtable {
    ID *tbl;
    int pos;
    int capa;
    struct vtable *prev;
};

struct local_vars {
    struct vtable *args;
    struct vtable *vars;
    struct vtable *used;
# if WARN_PAST_SCOPE
    struct vtable *past;
# endif
    struct local_vars *prev;
    struct {
        NODE *outer, *inner, *current;
    } numparam;
    NODE *it;
};

typedef struct rb_locations_lambda_body_t {
    NODE *node;
    YYLTYPE opening_loc;
    YYLTYPE closing_loc;
} rb_locations_lambda_body_t;

enum {
    ORDINAL_PARAM = -1,
    NO_PARAM = 0,
    NUMPARAM_MAX = 9,
};

#define DVARS_INHERIT ((void*)1)
#define DVARS_TOPSCOPE NULL
#define DVARS_TERMINAL_P(tbl) ((tbl) == DVARS_INHERIT || (tbl) == DVARS_TOPSCOPE)

typedef struct token_info {
    const char *token;
    rb_code_position_t beg;
    int indent;
    int nonspc;
    struct token_info *next;
} token_info;

typedef struct end_expect_token_locations {
    const rb_code_position_t *pos;
    struct end_expect_token_locations *prev;
} end_expect_token_locations_t;

typedef struct parser_string_buffer_elem {
    struct parser_string_buffer_elem *next;
    long len;  /* Total length of allocated buf */
    long used; /* Current usage of buf */
    rb_parser_string_t *buf[FLEX_ARY_LEN];
} parser_string_buffer_elem_t;

typedef struct parser_string_buffer {
    parser_string_buffer_elem_t *head;
    parser_string_buffer_elem_t *last;
} parser_string_buffer_t;

#define AFTER_HEREDOC_WITHOUT_TERMINATOR ((rb_parser_string_t *)1)

/*
    Structure of Lexer Buffer:

 lex.pbeg     lex.ptok     lex.pcur     lex.pend
    |            |            |            |
    |------------+------------+------------|
                 |<---------->|
                     token
*/
struct parser_params {
    YYSTYPE *lval;
    YYLTYPE *yylloc;

    struct {
        rb_strterm_t *strterm;
        rb_parser_lex_gets_func *gets;
        rb_parser_input_data input;
        parser_string_buffer_t string_buffer;
        rb_parser_string_t *lastline;
        rb_parser_string_t *nextline;
        const char *pbeg;
        const char *pcur;
        const char *pend;
        const char *ptok;
        enum lex_state_e state;
        /* track the nest level of any parens "()[]{}" */
        int paren_nest;
        /* keep p->lex.paren_nest at the beginning of lambda "->" to detect tLAMBEG and keyword_do_LAMBDA */
        int lpar_beg;
        /* track the nest level of only braces "{}" */
        int brace_nest;
    } lex;
    stack_type cond_stack;
    stack_type cmdarg_stack;
    int tokidx;
    int toksiz;
    int heredoc_end;
    int heredoc_indent;
    int heredoc_line_indent;
    char *tokenbuf;
    struct local_vars *lvtbl;
    st_table *pvtbl;
    st_table *pktbl;
    int line_count;
    int ruby_sourceline;	/* current line no. */
    const char *ruby_sourcefile; /* current source file */
    VALUE ruby_sourcefile_string;
    rb_encoding *enc;
    token_info *token_info;
    st_table *case_labels;
    rb_node_exits_t *exits;

    VALUE debug_buffer;
    VALUE debug_output;

    struct {
        rb_parser_string_t *token;
        int beg_line;
        int beg_col;
        int end_line;
        int end_col;
    } delayed;

    rb_ast_t *ast;
    int node_id;

    st_table *warn_duplicate_keys_table;

    int max_numparam;
    ID it_id;

    struct lex_context ctxt;

    NODE *eval_tree_begin;
    NODE *eval_tree;
    const struct rb_iseq_struct *parent_iseq;

#ifdef UNIVERSAL_PARSER
    const rb_parser_config_t *config;
#endif
    /* compile_option */
    signed int frozen_string_literal:2; /* -1: not specified, 0: false, 1: true */

    unsigned int command_start:1;
    unsigned int eofp: 1;
    unsigned int ruby__end__seen: 1;
    unsigned int debug: 1;
    unsigned int has_shebang: 1;
    unsigned int token_seen: 1;
    unsigned int token_info_enabled: 1;
# if WARN_PAST_SCOPE
    unsigned int past_scope_enabled: 1;
# endif
    unsigned int error_p: 1;
    unsigned int cr_seen: 1;

#ifndef RIPPER
    /* Ruby core only */

    unsigned int do_print: 1;
    unsigned int do_loop: 1;
    unsigned int do_chomp: 1;
    unsigned int do_split: 1;
    unsigned int error_tolerant: 1;
    unsigned int keep_tokens: 1;

    VALUE error_buffer;
    rb_parser_ary_t *debug_lines;
    /*
     * Store specific keyword locations to generate dummy end token.
     * Refer to the tail of list element.
     */
    end_expect_token_locations_t *end_expect_token_locations;
    /* id for terms */
    int token_id;
    /* Array for term tokens */
    rb_parser_ary_t *tokens;
#else
    /* Ripper only */

    VALUE value;
    VALUE result;
    VALUE parsing_thread;
    VALUE s_value; /* Token VALUE */
    VALUE s_lvalue; /* VALUE generated by rule action (reduce) */
    VALUE s_value_stack;
#endif
};

#define NUMPARAM_ID_P(id) numparam_id_p(p, id)
#define NUMPARAM_ID_TO_IDX(id) (unsigned int)(((id) >> ID_SCOPE_SHIFT) - (tNUMPARAM_1 - 1))
#define NUMPARAM_IDX_TO_ID(idx) TOKEN2LOCALID((tNUMPARAM_1 - 1 + (idx)))
static int
numparam_id_p(struct parser_params *p, ID id)
{
    if (!is_local_id(id) || id < (tNUMPARAM_1 << ID_SCOPE_SHIFT)) return 0;
    unsigned int idx = NUMPARAM_ID_TO_IDX(id);
    return idx > 0 && idx <= NUMPARAM_MAX;
}
static void numparam_name(struct parser_params *p, ID id);

#ifdef RIPPER
static void
after_shift(struct parser_params *p)
{
    if (p->debug) {
        rb_parser_printf(p, "after-shift: %+"PRIsVALUE"\n", p->s_value);
    }
    rb_ary_push(p->s_value_stack, p->s_value);
    p->s_value = Qnil;
}

static void
before_reduce(int len, struct parser_params *p)
{
    // Initialize $$ with $1.
    if (len) p->s_lvalue = rb_ary_entry(p->s_value_stack, -len);
}

static void
after_reduce(int len, struct parser_params *p)
{
    for (int i = 0; i < len; i++) {
        VALUE tos = rb_ary_pop(p->s_value_stack);
        if (p->debug) {
            rb_parser_printf(p, "after-reduce pop: %+"PRIsVALUE"\n", tos);
        }
    }
    if (p->debug) {
        rb_parser_printf(p, "after-reduce push: %+"PRIsVALUE"\n", p->s_lvalue);
    }
    rb_ary_push(p->s_value_stack, p->s_lvalue);
    p->s_lvalue = Qnil;
}

static void
after_shift_error_token(struct parser_params *p)
{
    if (p->debug) {
        rb_parser_printf(p, "after-shift-error-token:\n");
    }
    rb_ary_push(p->s_value_stack, Qnil);
}

static void
after_pop_stack(int len, struct parser_params *p)
{
    for (int i = 0; i < len; i++) {
        VALUE tos = rb_ary_pop(p->s_value_stack);
        if (p->debug) {
            rb_parser_printf(p, "after-pop-stack pop: %+"PRIsVALUE"\n", tos);
        }
    }
}
#else
static void
after_shift(struct parser_params *p)
{
}

static void
before_reduce(int len, struct parser_params *p)
{
}

static void
after_reduce(int len, struct parser_params *p)
{
}

static void
after_shift_error_token(struct parser_params *p)
{
}

static void
after_pop_stack(int len, struct parser_params *p)
{
}
#endif

#define intern_cstr(n,l,en) rb_intern3(n,l,en)

#define STRING_NEW0() rb_parser_encoding_string_new(p,0,0,p->enc)

#define STR_NEW(ptr,len) rb_enc_str_new((ptr),(len),p->enc)
#define STR_NEW0() rb_enc_str_new(0,0,p->enc)
#define STR_NEW2(ptr) rb_enc_str_new((ptr),strlen(ptr),p->enc)
#define STR_NEW3(ptr,len,e,func) parser_str_new(p, (ptr),(len),(e),(func),p->enc)
#define TOK_INTERN() intern_cstr(tok(p), toklen(p), p->enc)
#define VALID_SYMNAME_P(s, l, enc, type) (rb_enc_symname_type(s, l, enc, (1U<<(type))) == (int)(type))

#ifndef RIPPER
static inline int
char_at_end(struct parser_params *p, VALUE str, int when_empty)
{
    long len = RSTRING_LEN(str);
    return len > 0 ? (unsigned char)RSTRING_PTR(str)[len-1] : when_empty;
}
#endif

static void
pop_pvtbl(struct parser_params *p, st_table *tbl)
{
    st_free_table(p->pvtbl);
    p->pvtbl = tbl;
}

static void
pop_pktbl(struct parser_params *p, st_table *tbl)
{
    if (p->pktbl) st_free_table(p->pktbl);
    p->pktbl = tbl;
}

#define STRING_BUF_DEFAULT_LEN 16

static void
string_buffer_init(struct parser_params *p)
{
    parser_string_buffer_t *buf = &p->lex.string_buffer;
    const size_t size = offsetof(parser_string_buffer_elem_t, buf) + sizeof(rb_parser_string_t *) * STRING_BUF_DEFAULT_LEN;

    buf->head = buf->last = xmalloc(size);
    buf->head->len = STRING_BUF_DEFAULT_LEN;
    buf->head->used = 0;
    buf->head->next = NULL;
}

static void
string_buffer_append(struct parser_params *p, rb_parser_string_t *str)
{
    parser_string_buffer_t *buf = &p->lex.string_buffer;

    if (buf->head->used >= buf->head->len) {
        parser_string_buffer_elem_t *elem;
        long n = buf->head->len * 2;
        const size_t size = offsetof(parser_string_buffer_elem_t, buf) + sizeof(rb_parser_string_t *) * n;

        elem = xmalloc(size);
        elem->len = n;
        elem->used = 0;
        elem->next = NULL;
        buf->last->next = elem;
        buf->last = elem;
    }
    buf->last->buf[buf->last->used++] = str;
}

static void
string_buffer_free(struct parser_params *p)
{
    parser_string_buffer_elem_t *elem = p->lex.string_buffer.head;

    while (elem) {
        parser_string_buffer_elem_t *next_elem = elem->next;

        for (long i = 0; i < elem->used; i++) {
            rb_parser_string_free(p, elem->buf[i]);
        }

        xfree(elem);
        elem = next_elem;
    }
}

#ifndef RIPPER
static void flush_debug_buffer(struct parser_params *p, VALUE out, VALUE str);

static void
debug_end_expect_token_locations(struct parser_params *p, const char *name)
{
    if(p->debug) {
        VALUE mesg = rb_sprintf("%s: [", name);
        int i = 0;
        for (end_expect_token_locations_t *loc = p->end_expect_token_locations; loc; loc = loc->prev) {
            if (i > 0)
                rb_str_cat_cstr(mesg, ", ");
            rb_str_catf(mesg, "[%d, %d]", loc->pos->lineno, loc->pos->column);
            i++;
        }
        rb_str_cat_cstr(mesg, "]\n");
        flush_debug_buffer(p, p->debug_output, mesg);
    }
}

static void
push_end_expect_token_locations(struct parser_params *p, const rb_code_position_t *pos)
{
    if(!p->error_tolerant) return;

    end_expect_token_locations_t *locations;
    locations = ALLOC(end_expect_token_locations_t);
    locations->pos = pos;
    locations->prev = p->end_expect_token_locations;
    p->end_expect_token_locations = locations;

    debug_end_expect_token_locations(p, "push_end_expect_token_locations");
}

static void
pop_end_expect_token_locations(struct parser_params *p)
{
    if(!p->end_expect_token_locations) return;

    end_expect_token_locations_t *locations = p->end_expect_token_locations->prev;
    ruby_sized_xfree(p->end_expect_token_locations, sizeof(end_expect_token_locations_t));
    p->end_expect_token_locations = locations;

    debug_end_expect_token_locations(p, "pop_end_expect_token_locations");
}

static end_expect_token_locations_t *
peek_end_expect_token_locations(struct parser_params *p)
{
    return p->end_expect_token_locations;
}

static const char *
parser_token2char(struct parser_params *p, enum yytokentype tok)
{
    switch ((int) tok) {
#define TOKEN2CHAR(tok) case tok: return (#tok);
#define TOKEN2CHAR2(tok, name) case tok: return (name);
      TOKEN2CHAR2(' ', "word_sep");
      TOKEN2CHAR2('!', "!")
      TOKEN2CHAR2('%', "%");
      TOKEN2CHAR2('&', "&");
      TOKEN2CHAR2('*', "*");
      TOKEN2CHAR2('+', "+");
      TOKEN2CHAR2('-', "-");
      TOKEN2CHAR2('/', "/");
      TOKEN2CHAR2('<', "<");
      TOKEN2CHAR2('=', "=");
      TOKEN2CHAR2('>', ">");
      TOKEN2CHAR2('?', "?");
      TOKEN2CHAR2('^', "^");
      TOKEN2CHAR2('|', "|");
      TOKEN2CHAR2('~', "~");
      TOKEN2CHAR2(':', ":");
      TOKEN2CHAR2(',', ",");
      TOKEN2CHAR2('.', ".");
      TOKEN2CHAR2(';', ";");
      TOKEN2CHAR2('`', "`");
      TOKEN2CHAR2('\n', "nl");
      TOKEN2CHAR2('{', "\"{\"");
      TOKEN2CHAR2('}', "\"}\"");
      TOKEN2CHAR2('[', "\"[\"");
      TOKEN2CHAR2(']', "\"]\"");
      TOKEN2CHAR2('(', "\"(\"");
      TOKEN2CHAR2(')', "\")\"");
      TOKEN2CHAR2('\\', "backslash");
      TOKEN2CHAR(keyword_class);
      TOKEN2CHAR(keyword_module);
      TOKEN2CHAR(keyword_def);
      TOKEN2CHAR(keyword_undef);
      TOKEN2CHAR(keyword_begin);
      TOKEN2CHAR(keyword_rescue);
      TOKEN2CHAR(keyword_ensure);
      TOKEN2CHAR(keyword_end);
      TOKEN2CHAR(keyword_if);
      TOKEN2CHAR(keyword_unless);
      TOKEN2CHAR(keyword_then);
      TOKEN2CHAR(keyword_elsif);
      TOKEN2CHAR(keyword_else);
      TOKEN2CHAR(keyword_case);
      TOKEN2CHAR(keyword_when);
      TOKEN2CHAR(keyword_while);
      TOKEN2CHAR(keyword_until);
      TOKEN2CHAR(keyword_for);
      TOKEN2CHAR(keyword_break);
      TOKEN2CHAR(keyword_next);
      TOKEN2CHAR(keyword_redo);
      TOKEN2CHAR(keyword_retry);
      TOKEN2CHAR(keyword_in);
      TOKEN2CHAR(keyword_do);
      TOKEN2CHAR(keyword_do_cond);
      TOKEN2CHAR(keyword_do_block);
      TOKEN2CHAR(keyword_do_LAMBDA);
      TOKEN2CHAR(keyword_return);
      TOKEN2CHAR(keyword_yield);
      TOKEN2CHAR(keyword_super);
      TOKEN2CHAR(keyword_self);
      TOKEN2CHAR(keyword_nil);
      TOKEN2CHAR(keyword_true);
      TOKEN2CHAR(keyword_false);
      TOKEN2CHAR(keyword_and);
      TOKEN2CHAR(keyword_or);
      TOKEN2CHAR(keyword_not);
      TOKEN2CHAR(modifier_if);
      TOKEN2CHAR(modifier_unless);
      TOKEN2CHAR(modifier_while);
      TOKEN2CHAR(modifier_until);
      TOKEN2CHAR(modifier_rescue);
      TOKEN2CHAR(keyword_alias);
      TOKEN2CHAR(keyword_defined);
      TOKEN2CHAR(keyword_BEGIN);
      TOKEN2CHAR(keyword_END);
      TOKEN2CHAR(keyword__LINE__);
      TOKEN2CHAR(keyword__FILE__);
      TOKEN2CHAR(keyword__ENCODING__);
      TOKEN2CHAR(tIDENTIFIER);
      TOKEN2CHAR(tFID);
      TOKEN2CHAR(tGVAR);
      TOKEN2CHAR(tIVAR);
      TOKEN2CHAR(tCONSTANT);
      TOKEN2CHAR(tCVAR);
      TOKEN2CHAR(tLABEL);
      TOKEN2CHAR(tINTEGER);
      TOKEN2CHAR(tFLOAT);
      TOKEN2CHAR(tRATIONAL);
      TOKEN2CHAR(tIMAGINARY);
      TOKEN2CHAR(tCHAR);
      TOKEN2CHAR(tNTH_REF);
      TOKEN2CHAR(tBACK_REF);
      TOKEN2CHAR(tSTRING_CONTENT);
      TOKEN2CHAR(tREGEXP_END);
      TOKEN2CHAR(tDUMNY_END);
      TOKEN2CHAR(tSP);
      TOKEN2CHAR(tUPLUS);
      TOKEN2CHAR(tUMINUS);
      TOKEN2CHAR(tPOW);
      TOKEN2CHAR(tCMP);
      TOKEN2CHAR(tEQ);
      TOKEN2CHAR(tEQQ);
      TOKEN2CHAR(tNEQ);
      TOKEN2CHAR(tGEQ);
      TOKEN2CHAR(tLEQ);
      TOKEN2CHAR(tANDOP);
      TOKEN2CHAR(tOROP);
      TOKEN2CHAR(tMATCH);
      TOKEN2CHAR(tNMATCH);
      TOKEN2CHAR(tDOT2);
      TOKEN2CHAR(tDOT3);
      TOKEN2CHAR(tBDOT2);
      TOKEN2CHAR(tBDOT3);
      TOKEN2CHAR(tAREF);
      TOKEN2CHAR(tASET);
      TOKEN2CHAR(tLSHFT);
      TOKEN2CHAR(tRSHFT);
      TOKEN2CHAR(tANDDOT);
      TOKEN2CHAR(tCOLON2);
      TOKEN2CHAR(tCOLON3);
      TOKEN2CHAR(tOP_ASGN);
      TOKEN2CHAR(tASSOC);
      TOKEN2CHAR(tLPAREN);
      TOKEN2CHAR(tLPAREN_ARG);
      TOKEN2CHAR(tLBRACK);
      TOKEN2CHAR(tLBRACE);
      TOKEN2CHAR(tLBRACE_ARG);
      TOKEN2CHAR(tSTAR);
      TOKEN2CHAR(tDSTAR);
      TOKEN2CHAR(tAMPER);
      TOKEN2CHAR(tLAMBDA);
      TOKEN2CHAR(tSYMBEG);
      TOKEN2CHAR(tSTRING_BEG);
      TOKEN2CHAR(tXSTRING_BEG);
      TOKEN2CHAR(tREGEXP_BEG);
      TOKEN2CHAR(tWORDS_BEG);
      TOKEN2CHAR(tQWORDS_BEG);
      TOKEN2CHAR(tSYMBOLS_BEG);
      TOKEN2CHAR(tQSYMBOLS_BEG);
      TOKEN2CHAR(tSTRING_END);
      TOKEN2CHAR(tSTRING_DEND);
      TOKEN2CHAR(tSTRING_DBEG);
      TOKEN2CHAR(tSTRING_DVAR);
      TOKEN2CHAR(tLAMBEG);
      TOKEN2CHAR(tLABEL_END);
      TOKEN2CHAR(tIGNORED_NL);
      TOKEN2CHAR(tCOMMENT);
      TOKEN2CHAR(tEMBDOC_BEG);
      TOKEN2CHAR(tEMBDOC);
      TOKEN2CHAR(tEMBDOC_END);
      TOKEN2CHAR(tHEREDOC_BEG);
      TOKEN2CHAR(tHEREDOC_END);
      TOKEN2CHAR(k__END__);
      TOKEN2CHAR(tLOWEST);
      TOKEN2CHAR(tUMINUS_NUM);
      TOKEN2CHAR(tLAST_TOKEN);
#undef TOKEN2CHAR
#undef TOKEN2CHAR2
    }

    rb_bug("parser_token2id: unknown token %d", tok);

    UNREACHABLE_RETURN(0);
}
#else
static void
push_end_expect_token_locations(struct parser_params *p, const rb_code_position_t *pos)
{
}

static void
pop_end_expect_token_locations(struct parser_params *p)
{
}
#endif

RBIMPL_ATTR_NONNULL((1, 2, 3))
static int parser_yyerror(struct parser_params*, const YYLTYPE *yylloc, const char*);
RBIMPL_ATTR_NONNULL((1, 2))
static int parser_yyerror0(struct parser_params*, const char*);
#define yyerror0(msg) parser_yyerror0(p, (msg))
#define yyerror1(loc, msg) parser_yyerror(p, (loc), (msg))
#define yyerror(yylloc, p, msg) parser_yyerror(p, yylloc, msg)
#define token_flush(ptr) ((ptr)->lex.ptok = (ptr)->lex.pcur)
#define lex_goto_eol(p) ((p)->lex.pcur = (p)->lex.pend)
#define lex_eol_p(p) lex_eol_n_p(p, 0)
#define lex_eol_n_p(p,n) lex_eol_ptr_n_p(p, (p)->lex.pcur, n)
#define lex_eol_ptr_p(p,ptr) lex_eol_ptr_n_p(p,ptr,0)
#define lex_eol_ptr_n_p(p,ptr,n) ((ptr)+(n) >= (p)->lex.pend)

static void token_info_setup(token_info *ptinfo, const char *ptr, const rb_code_location_t *loc);
static void token_info_push(struct parser_params*, const char *token, const rb_code_location_t *loc);
static void token_info_pop(struct parser_params*, const char *token, const rb_code_location_t *loc);
static void token_info_warn(struct parser_params *p, const char *token, token_info *ptinfo_beg, int same, const rb_code_location_t *loc);
static void token_info_drop(struct parser_params *p, const char *token, rb_code_position_t beg_pos);

#ifdef RIPPER
#define compile_for_eval	(0)
#else
#define compile_for_eval	(p->parent_iseq != 0)
#endif

#define token_column		((int)(p->lex.ptok - p->lex.pbeg))

#define CALL_Q_P(q) ((q) == tANDDOT)
#define NEW_QCALL(q,r,m,a,loc) (CALL_Q_P(q) ? NEW_QCALL0(r,m,a,loc) : NEW_CALL(r,m,a,loc))

#define lambda_beginning_p() (p->lex.lpar_beg == p->lex.paren_nest)

static enum yytokentype yylex(YYSTYPE*, YYLTYPE*, struct parser_params*);

static inline void
rb_discard_node(struct parser_params *p, NODE *n)
{
    rb_ast_delete_node(p->ast, n);
}

static rb_node_scope_t *rb_node_scope_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, NODE *nd_parent, const YYLTYPE *loc);
static rb_node_scope_t *rb_node_scope_new2(struct parser_params *p, rb_ast_id_table_t *nd_tbl, rb_node_args_t *nd_args, NODE *nd_body, NODE *nd_parent, const YYLTYPE *loc);
static rb_node_block_t *rb_node_block_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc);
static rb_node_if_t *rb_node_if_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, NODE *nd_else, const YYLTYPE *loc, const YYLTYPE* if_keyword_loc, const YYLTYPE* then_keyword_loc, const YYLTYPE* end_keyword_loc);
static rb_node_unless_t *rb_node_unless_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, NODE *nd_else, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *then_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_case_t *rb_node_case_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_case2_t *rb_node_case2_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_case3_t *rb_node_case3_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_when_t *rb_node_when_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *then_keyword_loc);
static rb_node_in_t *rb_node_in_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc, const YYLTYPE *in_keyword_loc, const YYLTYPE *then_keyword_loc, const YYLTYPE *operator_loc);
static rb_node_while_t *rb_node_while_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, long nd_state, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *closing_loc);
static rb_node_until_t *rb_node_until_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, long nd_state, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *closing_loc);
static rb_node_iter_t *rb_node_iter_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc);
static rb_node_for_t *rb_node_for_new(struct parser_params *p, NODE *nd_iter, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *for_keyword_loc, const YYLTYPE *in_keyword_loc, const YYLTYPE *do_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_for_masgn_t *rb_node_for_masgn_new(struct parser_params *p, NODE *nd_var, const YYLTYPE *loc);
static rb_node_retry_t *rb_node_retry_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_begin_t *rb_node_begin_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_rescue_t *rb_node_rescue_new(struct parser_params *p, NODE *nd_head, NODE *nd_resq, NODE *nd_else, const YYLTYPE *loc);
static rb_node_resbody_t *rb_node_resbody_new(struct parser_params *p, NODE *nd_args, NODE *nd_exc_var, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc);
static rb_node_ensure_t *rb_node_ensure_new(struct parser_params *p, NODE *nd_head, NODE *nd_ensr, const YYLTYPE *loc);
static rb_node_and_t *rb_node_and_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_or_t *rb_node_or_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_masgn_t *rb_node_masgn_new(struct parser_params *p, NODE *nd_head, NODE *nd_args, const YYLTYPE *loc);
static rb_node_lasgn_t *rb_node_lasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_dasgn_t *rb_node_dasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_gasgn_t *rb_node_gasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_iasgn_t *rb_node_iasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_cdecl_t *rb_node_cdecl_new(struct parser_params *p, ID nd_vid, NODE *nd_value, NODE *nd_else, enum rb_parser_shareability shareability, const YYLTYPE *loc);
static rb_node_cvasgn_t *rb_node_cvasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc);
static rb_node_op_asgn1_t *rb_node_op_asgn1_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *index, NODE *rvalue, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc, const YYLTYPE *binary_operator_loc);
static rb_node_op_asgn2_t *rb_node_op_asgn2_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, ID nd_vid, ID nd_mid, bool nd_aid, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *message_loc, const YYLTYPE *binary_operator_loc);
static rb_node_op_asgn_or_t *rb_node_op_asgn_or_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, const YYLTYPE *loc);
static rb_node_op_asgn_and_t *rb_node_op_asgn_and_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, const YYLTYPE *loc);
static rb_node_op_cdecl_t *rb_node_op_cdecl_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, ID nd_aid, enum rb_parser_shareability shareability, const YYLTYPE *loc);
static rb_node_call_t *rb_node_call_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_opcall_t *rb_node_opcall_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_fcall_t *rb_node_fcall_new(struct parser_params *p, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_vcall_t *rb_node_vcall_new(struct parser_params *p, ID nd_mid, const YYLTYPE *loc);
static rb_node_qcall_t *rb_node_qcall_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_super_t *rb_node_super_new(struct parser_params *p, NODE *nd_args, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *lparen_loc, const YYLTYPE *rparen_loc);
static rb_node_zsuper_t * rb_node_zsuper_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_list_t *rb_node_list_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc);
static rb_node_list_t *rb_node_list_new2(struct parser_params *p, NODE *nd_head, long nd_alen, NODE *nd_next, const YYLTYPE *loc);
static rb_node_zlist_t *rb_node_zlist_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_hash_t *rb_node_hash_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc);
static rb_node_return_t *rb_node_return_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_yield_t *rb_node_yield_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *lparen_loc, const YYLTYPE *rparen_loc);
static rb_node_lvar_t *rb_node_lvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_dvar_t *rb_node_dvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_gvar_t *rb_node_gvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_ivar_t *rb_node_ivar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_const_t *rb_node_const_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_cvar_t *rb_node_cvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc);
static rb_node_nth_ref_t *rb_node_nth_ref_new(struct parser_params *p, long nd_nth, const YYLTYPE *loc);
static rb_node_back_ref_t *rb_node_back_ref_new(struct parser_params *p, long nd_nth, const YYLTYPE *loc);
static rb_node_match2_t *rb_node_match2_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, const YYLTYPE *loc);
static rb_node_match3_t *rb_node_match3_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, const YYLTYPE *loc);
static rb_node_integer_t * rb_node_integer_new(struct parser_params *p, char* val, int base, const YYLTYPE *loc);
static rb_node_float_t * rb_node_float_new(struct parser_params *p, char* val, const YYLTYPE *loc);
static rb_node_rational_t * rb_node_rational_new(struct parser_params *p, char* val, int base, int seen_point, const YYLTYPE *loc);
static rb_node_imaginary_t * rb_node_imaginary_new(struct parser_params *p, char* val, int base, int seen_point, enum rb_numeric_type, const YYLTYPE *loc);
static rb_node_str_t *rb_node_str_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc);
static rb_node_dstr_t *rb_node_dstr_new0(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc);
static rb_node_dstr_t *rb_node_dstr_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc);
static rb_node_xstr_t *rb_node_xstr_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc);
static rb_node_dxstr_t *rb_node_dxstr_new(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc);
static rb_node_evstr_t *rb_node_evstr_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc);
static rb_node_regx_t *rb_node_regx_new(struct parser_params *p, rb_parser_string_t *string, int options, const YYLTYPE *loc, const YYLTYPE *opening_loc, const YYLTYPE *content_loc, const YYLTYPE *closing_loc);
static rb_node_once_t *rb_node_once_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_args_t *rb_node_args_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_args_aux_t *rb_node_args_aux_new(struct parser_params *p, ID nd_pid, int nd_plen, const YYLTYPE *loc);
static rb_node_opt_arg_t *rb_node_opt_arg_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_kw_arg_t *rb_node_kw_arg_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc);
static rb_node_postarg_t *rb_node_postarg_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc);
static rb_node_argscat_t *rb_node_argscat_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc);
static rb_node_argspush_t *rb_node_argspush_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc);
static rb_node_splat_t *rb_node_splat_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_block_pass_t *rb_node_block_pass_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_defn_t *rb_node_defn_new(struct parser_params *p, ID nd_mid, NODE *nd_defn, const YYLTYPE *loc);
static rb_node_defs_t *rb_node_defs_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_defn, const YYLTYPE *loc);
static rb_node_alias_t *rb_node_alias_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_valias_t *rb_node_valias_new(struct parser_params *p, ID nd_alias, ID nd_orig, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_undef_t *rb_node_undef_new(struct parser_params *p, NODE *nd_undef, const YYLTYPE *loc);
static rb_node_class_t *rb_node_class_new(struct parser_params *p, NODE *nd_cpath, NODE *nd_body, NODE *nd_super, const YYLTYPE *loc, const YYLTYPE *class_keyword_loc, const YYLTYPE *inheritance_operator_loc, const YYLTYPE *end_keyword_loc);
static rb_node_module_t *rb_node_module_new(struct parser_params *p, NODE *nd_cpath, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *module_keyword_loc, const YYLTYPE *end_keyword_loc);
static rb_node_sclass_t *rb_node_sclass_new(struct parser_params *p, NODE *nd_recv, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *class_keyword_loc, const YYLTYPE *operator_loc, const YYLTYPE *end_keyword_loc);
static rb_node_colon2_t *rb_node_colon2_new(struct parser_params *p, NODE *nd_head, ID nd_mid, const YYLTYPE *loc, const YYLTYPE *delimiter_loc, const YYLTYPE *name_loc);
static rb_node_colon3_t *rb_node_colon3_new(struct parser_params *p, ID nd_mid, const YYLTYPE *loc, const YYLTYPE *delimiter_loc, const YYLTYPE *name_loc);
static rb_node_dot2_t *rb_node_dot2_new(struct parser_params *p, NODE *nd_beg, NODE *nd_end, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_dot3_t *rb_node_dot3_new(struct parser_params *p, NODE *nd_beg, NODE *nd_end, const YYLTYPE *loc, const YYLTYPE *operator_loc);
static rb_node_self_t *rb_node_self_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_nil_t *rb_node_nil_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_true_t *rb_node_true_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_false_t *rb_node_false_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_errinfo_t *rb_node_errinfo_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_defined_t *rb_node_defined_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_postexe_t *rb_node_postexe_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc);
static rb_node_sym_t *rb_node_sym_new(struct parser_params *p, VALUE str, const YYLTYPE *loc);
static rb_node_dsym_t *rb_node_dsym_new(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc);
static rb_node_attrasgn_t *rb_node_attrasgn_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc);
static rb_node_lambda_t *rb_node_lambda_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *operator_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc);
static rb_node_aryptn_t *rb_node_aryptn_new(struct parser_params *p, NODE *pre_args, NODE *rest_arg, NODE *post_args, const YYLTYPE *loc);
static rb_node_hshptn_t *rb_node_hshptn_new(struct parser_params *p, NODE *nd_pconst, NODE *nd_pkwargs, NODE *nd_pkwrestarg, const YYLTYPE *loc);
static rb_node_fndptn_t *rb_node_fndptn_new(struct parser_params *p, NODE *pre_rest_arg, NODE *args, NODE *post_rest_arg, const YYLTYPE *loc);
static rb_node_line_t *rb_node_line_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_file_t *rb_node_file_new(struct parser_params *p, VALUE str, const YYLTYPE *loc);
static rb_node_error_t *rb_node_error_new(struct parser_params *p, const YYLTYPE *loc);

#define NEW_SCOPE(a,b,c,loc) (NODE *)rb_node_scope_new(p,a,b,c,loc)
#define NEW_SCOPE2(t,a,b,c,loc) (NODE *)rb_node_scope_new2(p,t,a,b,c,loc)
#define NEW_BLOCK(a,loc) (NODE *)rb_node_block_new(p,a,loc)
#define NEW_IF(c,t,e,loc,ik_loc,tk_loc,ek_loc) (NODE *)rb_node_if_new(p,c,t,e,loc,ik_loc,tk_loc,ek_loc)
#define NEW_UNLESS(c,t,e,loc,k_loc,t_loc,e_loc) (NODE *)rb_node_unless_new(p,c,t,e,loc,k_loc,t_loc,e_loc)
#define NEW_CASE(h,b,loc,ck_loc,ek_loc) (NODE *)rb_node_case_new(p,h,b,loc,ck_loc,ek_loc)
#define NEW_CASE2(b,loc,ck_loc,ek_loc) (NODE *)rb_node_case2_new(p,b,loc,ck_loc,ek_loc)
#define NEW_CASE3(h,b,loc,ck_loc,ek_loc) (NODE *)rb_node_case3_new(p,h,b,loc,ck_loc,ek_loc)
#define NEW_WHEN(c,t,e,loc,k_loc,t_loc) (NODE *)rb_node_when_new(p,c,t,e,loc,k_loc,t_loc)
#define NEW_IN(c,t,e,loc,ik_loc,tk_loc,o_loc) (NODE *)rb_node_in_new(p,c,t,e,loc,ik_loc,tk_loc,o_loc)
#define NEW_WHILE(c,b,n,loc,k_loc,c_loc) (NODE *)rb_node_while_new(p,c,b,n,loc,k_loc,c_loc)
#define NEW_UNTIL(c,b,n,loc,k_loc,c_loc) (NODE *)rb_node_until_new(p,c,b,n,loc,k_loc,c_loc)
#define NEW_ITER(a,b,loc) (NODE *)rb_node_iter_new(p,a,b,loc)
#define NEW_FOR(i,b,loc,f_loc,i_loc,d_loc,e_loc) (NODE *)rb_node_for_new(p,i,b,loc,f_loc,i_loc,d_loc,e_loc)
#define NEW_FOR_MASGN(v,loc) (NODE *)rb_node_for_masgn_new(p,v,loc)
#define NEW_RETRY(loc) (NODE *)rb_node_retry_new(p,loc)
#define NEW_BEGIN(b,loc) (NODE *)rb_node_begin_new(p,b,loc)
#define NEW_RESCUE(b,res,e,loc) (NODE *)rb_node_rescue_new(p,b,res,e,loc)
#define NEW_RESBODY(a,v,ex,n,loc) (NODE *)rb_node_resbody_new(p,a,v,ex,n,loc)
#define NEW_ENSURE(b,en,loc) (NODE *)rb_node_ensure_new(p,b,en,loc)
#define NEW_AND(f,s,loc,op_loc) (NODE *)rb_node_and_new(p,f,s,loc,op_loc)
#define NEW_OR(f,s,loc,op_loc) (NODE *)rb_node_or_new(p,f,s,loc,op_loc)
#define NEW_MASGN(l,r,loc)   rb_node_masgn_new(p,l,r,loc)
#define NEW_LASGN(v,val,loc) (NODE *)rb_node_lasgn_new(p,v,val,loc)
#define NEW_DASGN(v,val,loc) (NODE *)rb_node_dasgn_new(p,v,val,loc)
#define NEW_GASGN(v,val,loc) (NODE *)rb_node_gasgn_new(p,v,val,loc)
#define NEW_IASGN(v,val,loc) (NODE *)rb_node_iasgn_new(p,v,val,loc)
#define NEW_CDECL(v,val,path,share,loc) (NODE *)rb_node_cdecl_new(p,v,val,path,share,loc)
#define NEW_CVASGN(v,val,loc) (NODE *)rb_node_cvasgn_new(p,v,val,loc)
#define NEW_OP_ASGN1(r,id,idx,rval,loc,c_op_loc,o_loc,c_loc,b_op_loc) (NODE *)rb_node_op_asgn1_new(p,r,id,idx,rval,loc,c_op_loc,o_loc,c_loc,b_op_loc)
#define NEW_OP_ASGN2(r,t,i,o,val,loc,c_op_loc,m_loc,b_op_loc) (NODE *)rb_node_op_asgn2_new(p,r,val,i,o,t,loc,c_op_loc,m_loc,b_op_loc)
#define NEW_OP_ASGN_OR(i,val,loc) (NODE *)rb_node_op_asgn_or_new(p,i,val,loc)
#define NEW_OP_ASGN_AND(i,val,loc) (NODE *)rb_node_op_asgn_and_new(p,i,val,loc)
#define NEW_OP_CDECL(v,op,val,share,loc) (NODE *)rb_node_op_cdecl_new(p,v,val,op,share,loc)
#define NEW_CALL(r,m,a,loc) (NODE *)rb_node_call_new(p,r,m,a,loc)
#define NEW_OPCALL(r,m,a,loc) (NODE *)rb_node_opcall_new(p,r,m,a,loc)
#define NEW_FCALL(m,a,loc) rb_node_fcall_new(p,m,a,loc)
#define NEW_VCALL(m,loc) (NODE *)rb_node_vcall_new(p,m,loc)
#define NEW_QCALL0(r,m,a,loc) (NODE *)rb_node_qcall_new(p,r,m,a,loc)
#define NEW_SUPER(a,loc,k_loc,l_loc,r_loc) (NODE *)rb_node_super_new(p,a,loc,k_loc,l_loc,r_loc)
#define NEW_ZSUPER(loc) (NODE *)rb_node_zsuper_new(p,loc)
#define NEW_LIST(a,loc) (NODE *)rb_node_list_new(p,a,loc)
#define NEW_LIST2(h,l,n,loc) (NODE *)rb_node_list_new2(p,h,l,n,loc)
#define NEW_ZLIST(loc) (NODE *)rb_node_zlist_new(p,loc)
#define NEW_HASH(a,loc) (NODE *)rb_node_hash_new(p,a,loc)
#define NEW_RETURN(s,loc,k_loc) (NODE *)rb_node_return_new(p,s,loc,k_loc)
#define NEW_YIELD(a,loc,k_loc,l_loc,r_loc) (NODE *)rb_node_yield_new(p,a,loc,k_loc,l_loc,r_loc)
#define NEW_LVAR(v,loc) (NODE *)rb_node_lvar_new(p,v,loc)
#define NEW_DVAR(v,loc) (NODE *)rb_node_dvar_new(p,v,loc)
#define NEW_GVAR(v,loc) (NODE *)rb_node_gvar_new(p,v,loc)
#define NEW_IVAR(v,loc) (NODE *)rb_node_ivar_new(p,v,loc)
#define NEW_CONST(v,loc) (NODE *)rb_node_const_new(p,v,loc)
#define NEW_CVAR(v,loc) (NODE *)rb_node_cvar_new(p,v,loc)
#define NEW_NTH_REF(n,loc)  (NODE *)rb_node_nth_ref_new(p,n,loc)
#define NEW_BACK_REF(n,loc) (NODE *)rb_node_back_ref_new(p,n,loc)
#define NEW_MATCH2(n1,n2,loc) (NODE *)rb_node_match2_new(p,n1,n2,loc)
#define NEW_MATCH3(r,n2,loc) (NODE *)rb_node_match3_new(p,r,n2,loc)
#define NEW_INTEGER(val, base,loc) (NODE *)rb_node_integer_new(p,val,base,loc)
#define NEW_FLOAT(val,loc) (NODE *)rb_node_float_new(p,val,loc)
#define NEW_RATIONAL(val,base,seen_point,loc) (NODE *)rb_node_rational_new(p,val,base,seen_point,loc)
#define NEW_IMAGINARY(val,base,seen_point,numeric_type,loc) (NODE *)rb_node_imaginary_new(p,val,base,seen_point,numeric_type,loc)
#define NEW_STR(s,loc) (NODE *)rb_node_str_new(p,s,loc)
#define NEW_DSTR0(s,l,n,loc) (NODE *)rb_node_dstr_new0(p,s,l,n,loc)
#define NEW_DSTR(s,loc) (NODE *)rb_node_dstr_new(p,s,loc)
#define NEW_XSTR(s,loc) (NODE *)rb_node_xstr_new(p,s,loc)
#define NEW_DXSTR(s,l,n,loc) (NODE *)rb_node_dxstr_new(p,s,l,n,loc)
#define NEW_EVSTR(n,loc,o_loc,c_loc) (NODE *)rb_node_evstr_new(p,n,loc,o_loc,c_loc)
#define NEW_REGX(str,opts,loc,o_loc,ct_loc,c_loc) (NODE *)rb_node_regx_new(p,str,opts,loc,o_loc,ct_loc,c_loc)
#define NEW_ONCE(b,loc) (NODE *)rb_node_once_new(p,b,loc)
#define NEW_ARGS(loc) rb_node_args_new(p,loc)
#define NEW_ARGS_AUX(r,b,loc) rb_node_args_aux_new(p,r,b,loc)
#define NEW_OPT_ARG(v,loc) rb_node_opt_arg_new(p,v,loc)
#define NEW_KW_ARG(v,loc) rb_node_kw_arg_new(p,v,loc)
#define NEW_POSTARG(i,v,loc) (NODE *)rb_node_postarg_new(p,i,v,loc)
#define NEW_ARGSCAT(a,b,loc) (NODE *)rb_node_argscat_new(p,a,b,loc)
#define NEW_ARGSPUSH(a,b,loc) (NODE *)rb_node_argspush_new(p,a,b,loc)
#define NEW_SPLAT(a,loc,op_loc) (NODE *)rb_node_splat_new(p,a,loc,op_loc)
#define NEW_BLOCK_PASS(b,loc,o_loc) rb_node_block_pass_new(p,b,loc,o_loc)
#define NEW_DEFN(i,s,loc) (NODE *)rb_node_defn_new(p,i,s,loc)
#define NEW_DEFS(r,i,s,loc) (NODE *)rb_node_defs_new(p,r,i,s,loc)
#define NEW_ALIAS(n,o,loc,k_loc) (NODE *)rb_node_alias_new(p,n,o,loc,k_loc)
#define NEW_VALIAS(n,o,loc,k_loc) (NODE *)rb_node_valias_new(p,n,o,loc,k_loc)
#define NEW_UNDEF(i,loc) (NODE *)rb_node_undef_new(p,i,loc)
#define NEW_CLASS(n,b,s,loc,ck_loc,io_loc,ek_loc) (NODE *)rb_node_class_new(p,n,b,s,loc,ck_loc,io_loc,ek_loc)
#define NEW_MODULE(n,b,loc,mk_loc,ek_loc) (NODE *)rb_node_module_new(p,n,b,loc,mk_loc,ek_loc)
#define NEW_SCLASS(r,b,loc,ck_loc,op_loc,ek_loc) (NODE *)rb_node_sclass_new(p,r,b,loc,ck_loc,op_loc,ek_loc)
#define NEW_COLON2(c,i,loc,d_loc,n_loc) (NODE *)rb_node_colon2_new(p,c,i,loc,d_loc,n_loc)
#define NEW_COLON3(i,loc,d_loc,n_loc) (NODE *)rb_node_colon3_new(p,i,loc,d_loc,n_loc)
#define NEW_DOT2(b,e,loc,op_loc) (NODE *)rb_node_dot2_new(p,b,e,loc,op_loc)
#define NEW_DOT3(b,e,loc,op_loc) (NODE *)rb_node_dot3_new(p,b,e,loc,op_loc)
#define NEW_SELF(loc) (NODE *)rb_node_self_new(p,loc)
#define NEW_NIL(loc) (NODE *)rb_node_nil_new(p,loc)
#define NEW_TRUE(loc) (NODE *)rb_node_true_new(p,loc)
#define NEW_FALSE(loc) (NODE *)rb_node_false_new(p,loc)
#define NEW_ERRINFO(loc) (NODE *)rb_node_errinfo_new(p,loc)
#define NEW_DEFINED(e,loc,k_loc) (NODE *)rb_node_defined_new(p,e,loc, k_loc)
#define NEW_POSTEXE(b,loc,k_loc,o_loc,c_loc) (NODE *)rb_node_postexe_new(p,b,loc,k_loc,o_loc,c_loc)
#define NEW_SYM(str,loc) (NODE *)rb_node_sym_new(p,str,loc)
#define NEW_DSYM(s,l,n,loc) (NODE *)rb_node_dsym_new(p,s,l,n,loc)
#define NEW_ATTRASGN(r,m,a,loc) (NODE *)rb_node_attrasgn_new(p,r,m,a,loc)
#define NEW_LAMBDA(a,b,loc,op_loc,o_loc,c_loc) (NODE *)rb_node_lambda_new(p,a,b,loc,op_loc,o_loc,c_loc)
#define NEW_ARYPTN(pre,r,post,loc) (NODE *)rb_node_aryptn_new(p,pre,r,post,loc)
#define NEW_HSHPTN(c,kw,kwrest,loc) (NODE *)rb_node_hshptn_new(p,c,kw,kwrest,loc)
#define NEW_FNDPTN(pre,a,post,loc) (NODE *)rb_node_fndptn_new(p,pre,a,post,loc)
#define NEW_LINE(loc) (NODE *)rb_node_line_new(p,loc)
#define NEW_FILE(str,loc) (NODE *)rb_node_file_new(p,str,loc)
#define NEW_ENCODING(loc) (NODE *)rb_node_encoding_new(p,loc)
#define NEW_ERROR(loc) (NODE *)rb_node_error_new(p,loc)

enum internal_node_type {
    NODE_INTERNAL_ONLY = NODE_LAST,
    NODE_DEF_TEMP,
    NODE_EXITS,
    NODE_INTERNAL_LAST
};

static const char *
parser_node_name(int node)
{
    switch (node) {
      case NODE_DEF_TEMP:
        return "NODE_DEF_TEMP";
      case NODE_EXITS:
        return "NODE_EXITS";
      default:
        return ruby_node_name(node);
    }
}

/* This node is parse.y internal */
struct RNode_DEF_TEMP {
    NODE node;

    /* for NODE_DEFN/NODE_DEFS */

    struct RNode *nd_def;
    ID nd_mid;

    struct {
        int max_numparam;
        NODE *numparam_save;
        struct lex_context ctxt;
    } save;
};

#define RNODE_DEF_TEMP(node) ((struct RNode_DEF_TEMP *)(node))

static rb_node_break_t *rb_node_break_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_next_t *rb_node_next_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_redo_t *rb_node_redo_new(struct parser_params *p, const YYLTYPE *loc, const YYLTYPE *keyword_loc);
static rb_node_def_temp_t *rb_node_def_temp_new(struct parser_params *p, const YYLTYPE *loc);
static rb_node_def_temp_t *def_head_save(struct parser_params *p, rb_node_def_temp_t *n);

#define NEW_BREAK(s,loc,k_loc) (NODE *)rb_node_break_new(p,s,loc,k_loc)
#define NEW_NEXT(s,loc,k_loc) (NODE *)rb_node_next_new(p,s,loc,k_loc)
#define NEW_REDO(loc,k_loc) (NODE *)rb_node_redo_new(p,loc,k_loc)
#define NEW_DEF_TEMP(loc) rb_node_def_temp_new(p,loc)

/* Make a new internal node, which should not be appeared in the
 * result AST and does not have node_id and location. */
static NODE* node_new_internal(struct parser_params *p, enum node_type type, size_t size, size_t alignment);
#define NODE_NEW_INTERNAL(ndtype, type) (type *)node_new_internal(p, (enum node_type)(ndtype), sizeof(type), RUBY_ALIGNOF(type))

static NODE *nd_set_loc(NODE *nd, const YYLTYPE *loc);

static int
parser_get_node_id(struct parser_params *p)
{
    int node_id = p->node_id;
    p->node_id++;
    return node_id;
}

static void
anddot_multiple_assignment_check(struct parser_params* p, const YYLTYPE *loc, ID id)
{
    if (id == tANDDOT) {
        yyerror1(loc, "&. inside multiple assignment destination");
    }
}

static inline void
set_line_body(NODE *body, int line)
{
    if (!body) return;
    switch (nd_type(body)) {
      case NODE_RESCUE:
      case NODE_ENSURE:
        nd_set_line(body, line);
    }
}

static void
set_embraced_location(NODE *node, const rb_code_location_t *beg, const rb_code_location_t *end)
{
    RNODE_ITER(node)->nd_body->nd_loc = code_loc_gen(beg, end);
    nd_set_line(node, beg->end_pos.lineno);
}

static NODE *
last_expr_node(NODE *expr)
{
    while (expr) {
        if (nd_type_p(expr, NODE_BLOCK)) {
            expr = RNODE_BLOCK(RNODE_BLOCK(expr)->nd_end)->nd_head;
        }
        else if (nd_type_p(expr, NODE_BEGIN) && RNODE_BEGIN(expr)->nd_body) {
            expr = RNODE_BEGIN(expr)->nd_body;
        }
        else {
            break;
        }
    }
    return expr;
}

#ifndef RIPPER
#define yyparse ruby_yyparse
#endif

static NODE* cond(struct parser_params *p, NODE *node, const YYLTYPE *loc);
static NODE* method_cond(struct parser_params *p, NODE *node, const YYLTYPE *loc);
static NODE *new_nil_at(struct parser_params *p, const rb_code_position_t *pos);
static NODE *new_if(struct parser_params*,NODE*,NODE*,NODE*,const YYLTYPE*,const YYLTYPE*,const YYLTYPE*,const YYLTYPE*);
static NODE *new_unless(struct parser_params*,NODE*,NODE*,NODE*,const YYLTYPE*,const YYLTYPE*,const YYLTYPE*,const YYLTYPE*);
static NODE *logop(struct parser_params*,ID,NODE*,NODE*,const YYLTYPE*,const YYLTYPE*);

static NODE *newline_node(NODE*);
static void fixpos(NODE*,NODE*);

static int value_expr(struct parser_params*,NODE*);
static void void_expr(struct parser_params*,NODE*);
static NODE *remove_begin(NODE*);
static NODE *void_stmts(struct parser_params*,NODE*);
static void reduce_nodes(struct parser_params*,NODE**);
static void block_dup_check(struct parser_params*,NODE*,NODE*);

static NODE *block_append(struct parser_params*,NODE*,NODE*);
static NODE *list_append(struct parser_params*,NODE*,NODE*);
static NODE *list_concat(NODE*,NODE*);
static NODE *arg_append(struct parser_params*,NODE*,NODE*,const YYLTYPE*);
static NODE *last_arg_append(struct parser_params *p, NODE *args, NODE *last_arg, const YYLTYPE *loc);
static NODE *rest_arg_append(struct parser_params *p, NODE *args, NODE *rest_arg, const YYLTYPE *loc);
static NODE *literal_concat(struct parser_params*,NODE*,NODE*,const YYLTYPE*);
static NODE *new_evstr(struct parser_params*,NODE*,const YYLTYPE*,const YYLTYPE*,const YYLTYPE*);
static NODE *new_dstr(struct parser_params*,NODE*,const YYLTYPE*);
static NODE *str2dstr(struct parser_params*,NODE*);
static NODE *evstr2dstr(struct parser_params*,NODE*);
static NODE *splat_array(NODE*);
static void mark_lvar_used(struct parser_params *p, NODE *rhs);

static NODE *call_bin_op(struct parser_params*,NODE*,ID,NODE*,const YYLTYPE*,const YYLTYPE*);
static NODE *call_uni_op(struct parser_params*,NODE*,ID,const YYLTYPE*,const YYLTYPE*);
static NODE *new_qcall(struct parser_params* p, ID atype, NODE *recv, ID mid, NODE *args, const YYLTYPE *op_loc, const YYLTYPE *loc);
static NODE *new_command_qcall(struct parser_params* p, ID atype, NODE *recv, ID mid, NODE *args, NODE *block, const YYLTYPE *op_loc, const YYLTYPE *loc);
static NODE *method_add_block(struct parser_params*p, NODE *m, NODE *b, const YYLTYPE *loc) {RNODE_ITER(b)->nd_iter = m; b->nd_loc = *loc; return b;}

static bool args_info_empty_p(struct rb_args_info *args);
static rb_node_args_t *new_args(struct parser_params*,rb_node_args_aux_t*,rb_node_opt_arg_t*,ID,rb_node_args_aux_t*,rb_node_args_t*,const YYLTYPE*);
static rb_node_args_t *new_args_tail(struct parser_params*,rb_node_kw_arg_t*,ID,ID,const YYLTYPE*);
static NODE *new_array_pattern(struct parser_params *p, NODE *constant, NODE *pre_arg, NODE *aryptn, const YYLTYPE *loc);
static NODE *new_array_pattern_tail(struct parser_params *p, NODE *pre_args, int has_rest, NODE *rest_arg, NODE *post_args, const YYLTYPE *loc);
static NODE *new_find_pattern(struct parser_params *p, NODE *constant, NODE *fndptn, const YYLTYPE *loc);
static NODE *new_find_pattern_tail(struct parser_params *p, NODE *pre_rest_arg, NODE *args, NODE *post_rest_arg, const YYLTYPE *loc);
static NODE *new_hash_pattern(struct parser_params *p, NODE *constant, NODE *hshptn, const YYLTYPE *loc);
static NODE *new_hash_pattern_tail(struct parser_params *p, NODE *kw_args, ID kw_rest_arg, const YYLTYPE *loc);

static rb_node_kw_arg_t *new_kw_arg(struct parser_params *p, NODE *k, const YYLTYPE *loc);
static rb_node_args_t *args_with_numbered(struct parser_params*,rb_node_args_t*,int,ID);

static NODE* negate_lit(struct parser_params*, NODE*);
static void no_blockarg(struct parser_params*,NODE*);
static NODE *ret_args(struct parser_params*,NODE*);
static NODE *arg_blk_pass(NODE*,rb_node_block_pass_t*);
static NODE *dsym_node(struct parser_params*,NODE*,const YYLTYPE*);

static NODE *gettable(struct parser_params*,ID,const YYLTYPE*);
static NODE *assignable(struct parser_params*,ID,NODE*,const YYLTYPE*);

static NODE *aryset(struct parser_params*,NODE*,NODE*,const YYLTYPE*);
static NODE *attrset(struct parser_params*,NODE*,ID,ID,const YYLTYPE*);

static VALUE rb_backref_error(struct parser_params*,NODE*);
static NODE *node_assign(struct parser_params*,NODE*,NODE*,struct lex_context,const YYLTYPE*);

static NODE *new_op_assign(struct parser_params *p, NODE *lhs, ID op, NODE *rhs, struct lex_context, const YYLTYPE *loc);
static NODE *new_ary_op_assign(struct parser_params *p, NODE *ary, NODE *args, ID op, NODE *rhs, const YYLTYPE *args_loc, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc, const YYLTYPE *binary_operator_loc);
static NODE *new_attr_op_assign(struct parser_params *p, NODE *lhs, ID atype, ID attr, ID op, NODE *rhs, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *message_loc, const YYLTYPE *binary_operator_loc);
static NODE *new_const_op_assign(struct parser_params *p, NODE *lhs, ID op, NODE *rhs, struct lex_context, const YYLTYPE *loc);
static NODE *new_bodystmt(struct parser_params *p, NODE *head, NODE *rescue, NODE *rescue_else, NODE *ensure, const YYLTYPE *loc);

static NODE *const_decl(struct parser_params *p, NODE* path, const YYLTYPE *loc);

static rb_node_opt_arg_t *opt_arg_append(rb_node_opt_arg_t*, rb_node_opt_arg_t*);
static rb_node_kw_arg_t *kwd_append(rb_node_kw_arg_t*, rb_node_kw_arg_t*);

static NODE *new_hash(struct parser_params *p, NODE *hash, const YYLTYPE *loc);
static NODE *new_unique_key_hash(struct parser_params *p, NODE *hash, const YYLTYPE *loc);

static NODE *new_defined(struct parser_params *p, NODE *expr, const YYLTYPE *loc, const YYLTYPE *keyword_loc);

static NODE *new_regexp(struct parser_params *, NODE *, int, const YYLTYPE *, const YYLTYPE *, const YYLTYPE *, const YYLTYPE *);

#define make_list(list, loc) ((list) ? (nd_set_loc(list, loc), list) : NEW_ZLIST(loc))

static NODE *new_xstring(struct parser_params *, NODE *, const YYLTYPE *loc);

static NODE *symbol_append(struct parser_params *p, NODE *symbols, NODE *symbol);

static NODE *match_op(struct parser_params*,NODE*,NODE*,const YYLTYPE*,const YYLTYPE*);

static rb_ast_id_table_t *local_tbl(struct parser_params*);

static VALUE reg_compile(struct parser_params*, rb_parser_string_t*, int);
static void reg_fragment_setenc(struct parser_params*, rb_parser_string_t*, int);

static int literal_concat0(struct parser_params *p, rb_parser_string_t *head, rb_parser_string_t *tail);
static NODE *heredoc_dedent(struct parser_params*,NODE*);

static void check_literal_when(struct parser_params *p, NODE *args, const YYLTYPE *loc);

static rb_locations_lambda_body_t* new_locations_lambda_body(struct parser_params *p, NODE *node, const YYLTYPE *loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc);

#ifdef RIPPER
#define get_value(idx) (rb_ary_entry(p->s_value_stack, idx))
#define set_value(val) (p->s_lvalue = val)
static VALUE assign_error(struct parser_params *p, const char *mesg, VALUE a);
static int id_is_var(struct parser_params *p, ID id);
#endif

RUBY_SYMBOL_EXPORT_BEGIN
VALUE rb_parser_reg_compile(struct parser_params* p, VALUE str, int options);
int rb_reg_fragment_setenc(struct parser_params*, rb_parser_string_t *, int);
enum lex_state_e rb_parser_trace_lex_state(struct parser_params *, enum lex_state_e, enum lex_state_e, int);
VALUE rb_parser_lex_state_name(struct parser_params *p, enum lex_state_e state);
void rb_parser_show_bitstack(struct parser_params *, stack_type, const char *, int);
PRINTF_ARGS(void rb_parser_fatal(struct parser_params *p, const char *fmt, ...), 2, 3);
YYLTYPE *rb_parser_set_location_from_strterm_heredoc(struct parser_params *p, rb_strterm_heredoc_t *here, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location_of_delayed_token(struct parser_params *p, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location_of_heredoc_end(struct parser_params *p, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location_of_dummy_end(struct parser_params *p, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location_of_none(struct parser_params *p, YYLTYPE *yylloc);
YYLTYPE *rb_parser_set_location(struct parser_params *p, YYLTYPE *yylloc);
void ruby_show_error_line(struct parser_params *p, VALUE errbuf, const YYLTYPE *yylloc, int lineno, rb_parser_string_t *str);
RUBY_SYMBOL_EXPORT_END

static void flush_string_content(struct parser_params *p, rb_encoding *enc, size_t back);
static void error_duplicate_pattern_variable(struct parser_params *p, ID id, const YYLTYPE *loc);
static void error_duplicate_pattern_key(struct parser_params *p, ID id, const YYLTYPE *loc);
static VALUE formal_argument_error(struct parser_params*, ID);
static ID shadowing_lvar(struct parser_params*,ID);
static void new_bv(struct parser_params*,ID);

static void local_push(struct parser_params*,int);
static void local_pop(struct parser_params*);
static void local_var(struct parser_params*, ID);
static void arg_var(struct parser_params*, ID);
static int  local_id(struct parser_params *p, ID id);
static int  local_id_ref(struct parser_params*, ID, ID **);
#define internal_id rb_parser_internal_id
ID internal_id(struct parser_params*);
static NODE *new_args_forward_call(struct parser_params*, NODE*, const YYLTYPE*, const YYLTYPE*);
static int check_forwarding_args(struct parser_params*);
static void add_forwarding_args(struct parser_params *p);
static void forwarding_arg_check(struct parser_params *p, ID arg, ID all, const char *var);

static const struct vtable *dyna_push(struct parser_params *);
static void dyna_pop(struct parser_params*, const struct vtable *);
static int dyna_in_block(struct parser_params*);
#define dyna_var(p, id) local_var(p, id)
static int dvar_defined(struct parser_params*, ID);
#define dvar_defined_ref rb_parser_dvar_defined_ref
int dvar_defined_ref(struct parser_params*, ID, ID**);
static int dvar_curr(struct parser_params*,ID);

static int lvar_defined(struct parser_params*, ID);

static NODE *numparam_push(struct parser_params *p);
static void numparam_pop(struct parser_params *p, NODE *prev_inner);

#define METHOD_NOT '!'

#define idFWD_REST   '*'
#define idFWD_KWREST idPow /* Use simple "**", as tDSTAR is "**arg" */
#define idFWD_BLOCK  '&'
#define idFWD_ALL    idDot3
#define arg_FWD_BLOCK idFWD_BLOCK

#define RE_ONIG_OPTION_IGNORECASE 1
#define RE_ONIG_OPTION_EXTEND     (RE_ONIG_OPTION_IGNORECASE<<1)
#define RE_ONIG_OPTION_MULTILINE  (RE_ONIG_OPTION_EXTEND<<1)
#define RE_OPTION_ONCE (1<<16)
#define RE_OPTION_ENCODING_SHIFT 8
#define RE_OPTION_ENCODING(e) (((e)&0xff)<<RE_OPTION_ENCODING_SHIFT)
#define RE_OPTION_ENCODING_IDX(o) (((o)>>RE_OPTION_ENCODING_SHIFT)&0xff)
#define RE_OPTION_ENCODING_NONE(o) ((o)&RE_OPTION_ARG_ENCODING_NONE)
#define RE_OPTION_MASK  0xff
#define RE_OPTION_ARG_ENCODING_NONE 32

#define CHECK_LITERAL_WHEN (st_table *)1
#define CASE_LABELS_ENABLED_P(case_labels) (case_labels && case_labels != CHECK_LITERAL_WHEN)

#define yytnamerr(yyres, yystr) (YYSIZE_T)rb_yytnamerr(p, yyres, yystr)
RUBY_FUNC_EXPORTED size_t rb_yytnamerr(struct parser_params *p, char *yyres, const char *yystr);

#define TOKEN2ID(tok) ( \
    tTOKEN_LOCAL_BEGIN<(tok)&&(tok)<tTOKEN_LOCAL_END ? TOKEN2LOCALID(tok) : \
    tTOKEN_INSTANCE_BEGIN<(tok)&&(tok)<tTOKEN_INSTANCE_END ? TOKEN2INSTANCEID(tok) : \
    tTOKEN_GLOBAL_BEGIN<(tok)&&(tok)<tTOKEN_GLOBAL_END ? TOKEN2GLOBALID(tok) : \
    tTOKEN_CONST_BEGIN<(tok)&&(tok)<tTOKEN_CONST_END ? TOKEN2CONSTID(tok) : \
    tTOKEN_CLASS_BEGIN<(tok)&&(tok)<tTOKEN_CLASS_END ? TOKEN2CLASSID(tok) : \
    tTOKEN_ATTRSET_BEGIN<(tok)&&(tok)<tTOKEN_ATTRSET_END ? TOKEN2ATTRSETID(tok) : \
    ((tok) / ((tok)<tPRESERVED_ID_END && ((tok)>=128 || rb_ispunct(tok)))))

/****** Ripper *******/

#ifdef RIPPER

#include "eventids1.h"
#include "eventids2.h"

extern const struct ripper_parser_ids ripper_parser_ids;

static VALUE ripper_dispatch0(struct parser_params*,ID);
static VALUE ripper_dispatch1(struct parser_params*,ID,VALUE);
static VALUE ripper_dispatch2(struct parser_params*,ID,VALUE,VALUE);
static VALUE ripper_dispatch3(struct parser_params*,ID,VALUE,VALUE,VALUE);
static VALUE ripper_dispatch4(struct parser_params*,ID,VALUE,VALUE,VALUE,VALUE);
static VALUE ripper_dispatch5(struct parser_params*,ID,VALUE,VALUE,VALUE,VALUE,VALUE);
static VALUE ripper_dispatch7(struct parser_params*,ID,VALUE,VALUE,VALUE,VALUE,VALUE,VALUE,VALUE);
void ripper_error(struct parser_params *p);

#define dispatch0(n)            ripper_dispatch0(p, RIPPER_ID(n))
#define dispatch1(n,a)          ripper_dispatch1(p, RIPPER_ID(n), (a))
#define dispatch2(n,a,b)        ripper_dispatch2(p, RIPPER_ID(n), (a), (b))
#define dispatch3(n,a,b,c)      ripper_dispatch3(p, RIPPER_ID(n), (a), (b), (c))
#define dispatch4(n,a,b,c,d)    ripper_dispatch4(p, RIPPER_ID(n), (a), (b), (c), (d))
#define dispatch5(n,a,b,c,d,e)  ripper_dispatch5(p, RIPPER_ID(n), (a), (b), (c), (d), (e))
#define dispatch7(n,a,b,c,d,e,f,g) ripper_dispatch7(p, RIPPER_ID(n), (a), (b), (c), (d), (e), (f), (g))

#define yyparse ripper_yyparse

static VALUE
aryptn_pre_args(struct parser_params *p, VALUE pre_arg, VALUE pre_args)
{
    if (!NIL_P(pre_arg)) {
        if (!NIL_P(pre_args)) {
            rb_ary_unshift(pre_args, pre_arg);
        }
        else {
            pre_args = rb_ary_new_from_args(1, pre_arg);
        }
    }
    return pre_args;
}

#define ID2VAL(id) STATIC_ID2SYM(id)
#define TOKEN2VAL(t) ID2VAL(TOKEN2ID(t))
#endif /* RIPPER */

#define KWD2EID(t, v) keyword_##t

static NODE *
new_scope_body(struct parser_params *p, rb_node_args_t *args, NODE *body, NODE *parent, const YYLTYPE *loc)
{
    body = remove_begin(body);
    reduce_nodes(p, &body);
    NODE *n = NEW_SCOPE(args, body, parent, loc);
    nd_set_line(n, loc->end_pos.lineno);
    set_line_body(body, loc->beg_pos.lineno);
    return n;
}

static NODE *
rescued_expr(struct parser_params *p, NODE *arg, NODE *rescue,
             const YYLTYPE *arg_loc, const YYLTYPE *mod_loc, const YYLTYPE *res_loc)
{
    YYLTYPE loc = code_loc_gen(mod_loc, res_loc);
    rescue = NEW_RESBODY(0, 0, remove_begin(rescue), 0, &loc);
    loc.beg_pos = arg_loc->beg_pos;
    return NEW_RESCUE(arg, rescue, 0, &loc);
}

static NODE *add_block_exit(struct parser_params *p, NODE *node);
static rb_node_exits_t *init_block_exit(struct parser_params *p);
static rb_node_exits_t *allow_block_exit(struct parser_params *p);
static void restore_block_exit(struct parser_params *p, rb_node_exits_t *exits);
static void clear_block_exit(struct parser_params *p, bool error);

static void
next_rescue_context(struct lex_context *next, const struct lex_context *outer, enum rescue_context def)
{
    next->in_rescue = outer->in_rescue == after_rescue ? after_rescue : def;
}

static void
restore_defun(struct parser_params *p, rb_node_def_temp_t *temp)
{
    /* See: def_name action */
    struct lex_context ctxt = temp->save.ctxt;
    p->ctxt.in_def = ctxt.in_def;
    p->ctxt.shareable_constant_value = ctxt.shareable_constant_value;
    p->ctxt.in_rescue = ctxt.in_rescue;
    p->max_numparam = temp->save.max_numparam;
    numparam_pop(p, temp->save.numparam_save);
    clear_block_exit(p, true);
}

static void
endless_method_name(struct parser_params *p, ID mid, const YYLTYPE *loc)
{
    if (is_attrset_id(mid)) {
        yyerror1(loc, "setter method cannot be defined in an endless method definition");
    }
    token_info_drop(p, "def", loc->beg_pos);
}

#define debug_token_line(p, name, line) do { \
        if (p->debug) { \
            const char *const pcur = p->lex.pcur; \
            const char *const ptok = p->lex.ptok; \
            rb_parser_printf(p, name ":%d (%d: %"PRIdPTRDIFF"|%"PRIdPTRDIFF"|%"PRIdPTRDIFF")\n", \
                             line, p->ruby_sourceline, \
                             ptok - p->lex.pbeg, pcur - ptok, p->lex.pend - pcur); \
        } \
    } while (0)

#define begin_definition(k, loc_beg, loc_end) \
    do { \
        if (!(p->ctxt.in_class = (k)[0] != 0)) { \
            /* singleton class */ \
            p->ctxt.cant_return = !p->ctxt.in_def; \
            p->ctxt.in_def = 0; \
        } \
        else if (p->ctxt.in_def) { \
            YYLTYPE loc = code_loc_gen(loc_beg, loc_end); \
            yyerror1(&loc, k " definition in method body"); \
        } \
        else { \
            p->ctxt.cant_return = 1; \
        } \
        local_push(p, 0); \
    } while (0)

#ifndef RIPPER
# define ifndef_ripper(x) (x)
# define ifdef_ripper(r,x) (x)
#else
# define ifndef_ripper(x)
# define ifdef_ripper(r,x) (r)
#endif

# define rb_warn0(fmt)         WARN_CALL(WARN_ARGS(fmt, 1))
# define rb_warn1(fmt,a)       WARN_CALL(WARN_ARGS(fmt, 2), (a))
# define rb_warn2(fmt,a,b)     WARN_CALL(WARN_ARGS(fmt, 3), (a), (b))
# define rb_warn3(fmt,a,b,c)   WARN_CALL(WARN_ARGS(fmt, 4), (a), (b), (c))
# define rb_warn4(fmt,a,b,c,d) WARN_CALL(WARN_ARGS(fmt, 5), (a), (b), (c), (d))
# define rb_warning0(fmt)         WARNING_CALL(WARNING_ARGS(fmt, 1))
# define rb_warning1(fmt,a)       WARNING_CALL(WARNING_ARGS(fmt, 2), (a))
# define rb_warning2(fmt,a,b)     WARNING_CALL(WARNING_ARGS(fmt, 3), (a), (b))
# define rb_warning3(fmt,a,b,c)   WARNING_CALL(WARNING_ARGS(fmt, 4), (a), (b), (c))
# define rb_warning4(fmt,a,b,c,d) WARNING_CALL(WARNING_ARGS(fmt, 5), (a), (b), (c), (d))
# define rb_warn0L(l,fmt)         WARN_CALL(WARN_ARGS_L(l, fmt, 1))
# define rb_warn1L(l,fmt,a)       WARN_CALL(WARN_ARGS_L(l, fmt, 2), (a))
# define rb_warn2L(l,fmt,a,b)     WARN_CALL(WARN_ARGS_L(l, fmt, 3), (a), (b))
# define rb_warn3L(l,fmt,a,b,c)   WARN_CALL(WARN_ARGS_L(l, fmt, 4), (a), (b), (c))
# define rb_warn4L(l,fmt,a,b,c,d) WARN_CALL(WARN_ARGS_L(l, fmt, 5), (a), (b), (c), (d))
# define rb_warning0L(l,fmt)         WARNING_CALL(WARNING_ARGS_L(l, fmt, 1))
# define rb_warning1L(l,fmt,a)       WARNING_CALL(WARNING_ARGS_L(l, fmt, 2), (a))
# define rb_warning2L(l,fmt,a,b)     WARNING_CALL(WARNING_ARGS_L(l, fmt, 3), (a), (b))
# define rb_warning3L(l,fmt,a,b,c)   WARNING_CALL(WARNING_ARGS_L(l, fmt, 4), (a), (b), (c))
# define rb_warning4L(l,fmt,a,b,c,d) WARNING_CALL(WARNING_ARGS_L(l, fmt, 5), (a), (b), (c), (d))
#ifdef RIPPER
extern const ID id_warn, id_warning, id_gets, id_assoc;
# define ERR_MESG() STR_NEW2(mesg) /* to bypass Ripper DSL */
# define WARN_S_L(s,l) STR_NEW(s,l)
# define WARN_S(s) STR_NEW2(s)
# define WARN_I(i) INT2NUM(i)
# define WARN_ID(i) rb_id2str(i)
# define PRIsWARN PRIsVALUE
# define WARN_ARGS(fmt,n) p->value, id_warn, n, rb_usascii_str_new_lit(fmt)
# define WARN_ARGS_L(l,fmt,n) WARN_ARGS(fmt,n)
# ifdef HAVE_VA_ARGS_MACRO
# define WARN_CALL(...) rb_funcall(__VA_ARGS__)
# else
# define WARN_CALL rb_funcall
# endif
# define WARNING_ARGS(fmt,n) p->value, id_warning, n, rb_usascii_str_new_lit(fmt)
# define WARNING_ARGS_L(l, fmt,n) WARNING_ARGS(fmt,n)
# ifdef HAVE_VA_ARGS_MACRO
# define WARNING_CALL(...) rb_funcall(__VA_ARGS__)
# else
# define WARNING_CALL rb_funcall
# endif
# define compile_error ripper_compile_error
#else
# define WARN_S_L(s,l) s
# define WARN_S(s) s
# define WARN_I(i) i
# define WARN_ID(i) rb_id2name(i)
# define PRIsWARN PRIsVALUE
# define WARN_ARGS(fmt,n) WARN_ARGS_L(p->ruby_sourceline,fmt,n)
# define WARN_ARGS_L(l,fmt,n) p->ruby_sourcefile, (l), (fmt)
# define WARN_CALL rb_compile_warn
# define WARNING_ARGS(fmt,n) WARN_ARGS(fmt,n)
# define WARNING_ARGS_L(l,fmt,n) WARN_ARGS_L(l,fmt,n)
# define WARNING_CALL rb_compile_warning
PRINTF_ARGS(static void parser_compile_error(struct parser_params*, const rb_code_location_t *loc, const char *fmt, ...), 3, 4);
# define compile_error(p, ...) parser_compile_error(p, NULL, __VA_ARGS__)
#endif

#define RNODE_EXITS(node) ((rb_node_exits_t*)(node))

static NODE *
add_block_exit(struct parser_params *p, NODE *node)
{
    if (!node) {
        compile_error(p, "unexpected null node");
        return 0;
    }
    switch (nd_type(node)) {
      case NODE_BREAK: case NODE_NEXT: case NODE_REDO: break;
      default:
        compile_error(p, "add_block_exit: unexpected node: %s", parser_node_name(nd_type(node)));
        return node;
    }
    if (!p->ctxt.in_defined) {
        rb_node_exits_t *exits = p->exits;
        if (exits) {
            RNODE_EXITS(exits->nd_stts)->nd_chain = node;
            exits->nd_stts = node;
        }
    }
    return node;
}

static rb_node_exits_t *
init_block_exit(struct parser_params *p)
{
    rb_node_exits_t *old = p->exits;
    rb_node_exits_t *exits = NODE_NEW_INTERNAL(NODE_EXITS, rb_node_exits_t);
    exits->nd_chain = 0;
    exits->nd_stts = RNODE(exits);
    p->exits = exits;
    return old;
}

static rb_node_exits_t *
allow_block_exit(struct parser_params *p)
{
    rb_node_exits_t *exits = p->exits;
    p->exits = 0;
    return exits;
}

static void
restore_block_exit(struct parser_params *p, rb_node_exits_t *exits)
{
    p->exits = exits;
}

static void
clear_block_exit(struct parser_params *p, bool error)
{
    rb_node_exits_t *exits = p->exits;
    if (!exits) return;
    if (error) {
        for (NODE *e = RNODE(exits); (e = RNODE_EXITS(e)->nd_chain) != 0; ) {
            switch (nd_type(e)) {
              case NODE_BREAK:
                yyerror1(&e->nd_loc, "Invalid break");
                break;
              case NODE_NEXT:
                yyerror1(&e->nd_loc, "Invalid next");
                break;
              case NODE_REDO:
                yyerror1(&e->nd_loc, "Invalid redo");
                break;
              default:
                yyerror1(&e->nd_loc, "unexpected node");
                goto end_checks; /* no nd_chain */
            }
        }
      end_checks:;
    }
    exits->nd_stts = RNODE(exits);
    exits->nd_chain = 0;
}

#define WARN_EOL(tok) \
    (looking_at_eol_p(p) ? \
     (void)rb_warning0("'" tok "' at the end of line without an expression") : \
     (void)0)
static int looking_at_eol_p(struct parser_params *p);

static NODE *
get_nd_value(struct parser_params *p, NODE *node)
{
    switch (nd_type(node)) {
      case NODE_GASGN:
        return RNODE_GASGN(node)->nd_value;
      case NODE_IASGN:
        return RNODE_IASGN(node)->nd_value;
      case NODE_LASGN:
        return RNODE_LASGN(node)->nd_value;
      case NODE_DASGN:
        return RNODE_DASGN(node)->nd_value;
      case NODE_MASGN:
        return RNODE_MASGN(node)->nd_value;
      case NODE_CVASGN:
        return RNODE_CVASGN(node)->nd_value;
      case NODE_CDECL:
        return RNODE_CDECL(node)->nd_value;
      default:
        compile_error(p, "get_nd_value: unexpected node: %s", parser_node_name(nd_type(node)));
        return 0;
    }
}

static void
set_nd_value(struct parser_params *p, NODE *node, NODE *rhs)
{
    switch (nd_type(node)) {
      case NODE_CDECL:
        RNODE_CDECL(node)->nd_value = rhs;
        break;
      case NODE_GASGN:
        RNODE_GASGN(node)->nd_value = rhs;
        break;
      case NODE_IASGN:
        RNODE_IASGN(node)->nd_value = rhs;
        break;
      case NODE_LASGN:
        RNODE_LASGN(node)->nd_value = rhs;
        break;
      case NODE_DASGN:
        RNODE_DASGN(node)->nd_value = rhs;
        break;
      case NODE_MASGN:
        RNODE_MASGN(node)->nd_value = rhs;
        break;
      case NODE_CVASGN:
        RNODE_CVASGN(node)->nd_value = rhs;
        break;
      default:
        compile_error(p, "set_nd_value: unexpected node: %s", parser_node_name(nd_type(node)));
        break;
    }
}

static ID
get_nd_vid(struct parser_params *p, NODE *node)
{
    switch (nd_type(node)) {
      case NODE_CDECL:
        return RNODE_CDECL(node)->nd_vid;
      case NODE_GASGN:
        return RNODE_GASGN(node)->nd_vid;
      case NODE_IASGN:
        return RNODE_IASGN(node)->nd_vid;
      case NODE_LASGN:
        return RNODE_LASGN(node)->nd_vid;
      case NODE_DASGN:
        return RNODE_DASGN(node)->nd_vid;
      case NODE_CVASGN:
        return RNODE_CVASGN(node)->nd_vid;
      default:
        compile_error(p, "get_nd_vid: unexpected node: %s", parser_node_name(nd_type(node)));
        return 0;
    }
}

static NODE *
get_nd_args(struct parser_params *p, NODE *node)
{
    switch (nd_type(node)) {
      case NODE_CALL:
        return RNODE_CALL(node)->nd_args;
      case NODE_OPCALL:
        return RNODE_OPCALL(node)->nd_args;
      case NODE_FCALL:
        return RNODE_FCALL(node)->nd_args;
      case NODE_QCALL:
        return RNODE_QCALL(node)->nd_args;
      case NODE_SUPER:
        return RNODE_SUPER(node)->nd_args;
      case NODE_VCALL:
      case NODE_ZSUPER:
      case NODE_YIELD:
      case NODE_RETURN:
      case NODE_BREAK:
      case NODE_NEXT:
        return 0;
      default:
        compile_error(p, "get_nd_args: unexpected node: %s", parser_node_name(nd_type(node)));
        return 0;
    }
}

static st_index_t
djb2(const uint8_t *str, size_t len)
{
    st_index_t hash = 5381;

    for (size_t i = 0; i < len; i++) {
        hash = ((hash << 5) + hash) + str[i];
    }

    return hash;
}

static st_index_t
parser_memhash(const void *ptr, long len)
{
    return djb2(ptr, len);
}

#define PARSER_STRING_PTR(str) (str->ptr)
#define PARSER_STRING_LEN(str) (str->len)
#define PARSER_STRING_END(str) (&str->ptr[str->len])
#define STRING_SIZE(str) ((size_t)str->len + 1)
#define STRING_TERM_LEN(str) (1)
#define STRING_TERM_FILL(str) (str->ptr[str->len] = '\0')
#define PARSER_STRING_RESIZE_CAPA_TERM(p,str,capacity,termlen) do {\
    SIZED_REALLOC_N(str->ptr, char, (size_t)total + termlen, STRING_SIZE(str)); \
    str->len = total; \
} while (0)
#define STRING_SET_LEN(str, n) do { \
    (str)->len = (n); \
} while (0)
#define PARSER_STRING_GETMEM(str, ptrvar, lenvar) \
    ((ptrvar) = str->ptr,                            \
     (lenvar) = str->len)

static inline int
parser_string_char_at_end(struct parser_params *p, rb_parser_string_t *str, int when_empty)
{
    return PARSER_STRING_LEN(str) > 0 ? (unsigned char)PARSER_STRING_END(str)[-1] : when_empty;
}

static rb_parser_string_t *
rb_parser_string_new(rb_parser_t *p, const char *ptr, long len)
{
    rb_parser_string_t *str;

    if (len < 0) {
        rb_bug("negative string size (or size too big): %ld", len);
    }

    str = xcalloc(1, sizeof(rb_parser_string_t));
    str->ptr = xcalloc(len + 1, sizeof(char));

    if (ptr) {
        memcpy(PARSER_STRING_PTR(str), ptr, len);
    }
    STRING_SET_LEN(str, len);
    STRING_TERM_FILL(str);
    return str;
}

static rb_parser_string_t *
rb_parser_encoding_string_new(rb_parser_t *p, const char *ptr, long len, rb_encoding *enc)
{
    rb_parser_string_t *str = rb_parser_string_new(p, ptr, len);
    str->coderange = RB_PARSER_ENC_CODERANGE_UNKNOWN;
    str->enc = enc;
    return str;
}

#ifndef RIPPER
rb_parser_string_t *
rb_str_to_parser_string(rb_parser_t *p, VALUE str)
{
    /* Type check */
    rb_parser_string_t *ret = rb_parser_encoding_string_new(p, RSTRING_PTR(str), RSTRING_LEN(str), rb_enc_get(str));
    RB_GC_GUARD(str);
    return ret;
}

void
rb_parser_string_free(rb_parser_t *p, rb_parser_string_t *str)
{
    if (!str) return;
    xfree(PARSER_STRING_PTR(str));
    xfree(str);
}
#endif

static st_index_t
rb_parser_str_hash(rb_parser_string_t *str)
{
    return parser_memhash((const void *)PARSER_STRING_PTR(str), PARSER_STRING_LEN(str));
}

static st_index_t
rb_char_p_hash(const char *c)
{
    return parser_memhash((const void *)c, strlen(c));
}

static size_t
rb_parser_str_capacity(rb_parser_string_t *str, const int termlen)
{
    return PARSER_STRING_LEN(str);
}

#ifndef RIPPER
static char *
rb_parser_string_end(rb_parser_string_t *str)
{
    return &str->ptr[str->len];
}
#endif

static void
rb_parser_string_set_encoding(rb_parser_string_t *str, rb_encoding *enc)
{
    str->enc = enc;
}

static rb_encoding *
rb_parser_str_get_encoding(rb_parser_string_t *str)
{
    return str->enc;
}

#ifndef RIPPER
static bool
PARSER_ENCODING_IS_ASCII8BIT(struct parser_params *p, rb_parser_string_t *str)
{
    return rb_parser_str_get_encoding(str) == rb_ascii8bit_encoding();
}
#endif

static int
PARSER_ENC_CODERANGE(rb_parser_string_t *str)
{
    return str->coderange;
}

static void
PARSER_ENC_CODERANGE_SET(rb_parser_string_t *str, int coderange)
{
    str->coderange = coderange;
}

static void
PARSER_ENCODING_CODERANGE_SET(rb_parser_string_t *str, rb_encoding *enc, enum rb_parser_string_coderange_type cr)
{
    rb_parser_string_set_encoding(str, enc);
    PARSER_ENC_CODERANGE_SET(str, cr);
}

static void
PARSER_ENC_CODERANGE_CLEAR(rb_parser_string_t *str)
{
    str->coderange = RB_PARSER_ENC_CODERANGE_UNKNOWN;
}

static bool
PARSER_ENC_CODERANGE_ASCIIONLY(rb_parser_string_t *str)
{
    return PARSER_ENC_CODERANGE(str) == RB_PARSER_ENC_CODERANGE_7BIT;
}

static bool
PARSER_ENC_CODERANGE_CLEAN_P(int cr)
{
    return cr == RB_PARSER_ENC_CODERANGE_7BIT || cr == RB_PARSER_ENC_CODERANGE_VALID;
}

static const char *
rb_parser_search_nonascii(const char *p, const char *e)
{
    const char *s = p;

    for (; s < e; s++) {
        if (*s & 0x80) return s;
    }

    return NULL;
}

static int
rb_parser_coderange_scan(struct parser_params *p, const char *ptr, long len, rb_encoding *enc)
{
    const char *e = ptr + len;

    if (enc == rb_ascii8bit_encoding()) {
        /* enc is ASCII-8BIT.  ASCII-8BIT string never be broken. */
        ptr = rb_parser_search_nonascii(ptr, e);
        return ptr ? RB_PARSER_ENC_CODERANGE_VALID : RB_PARSER_ENC_CODERANGE_7BIT;
    }

    /* parser string encoding is always asciicompat */
    ptr = rb_parser_search_nonascii(ptr, e);
    if (!ptr) return RB_PARSER_ENC_CODERANGE_7BIT;
    for (;;) {
        int ret = rb_enc_precise_mbclen(ptr, e, enc);
        if (!MBCLEN_CHARFOUND_P(ret)) return RB_PARSER_ENC_CODERANGE_BROKEN;
        ptr += MBCLEN_CHARFOUND_LEN(ret);
        if (ptr == e) break;
        ptr = rb_parser_search_nonascii(ptr, e);
        if (!ptr) break;
    }

    return RB_PARSER_ENC_CODERANGE_VALID;
}

static int
rb_parser_enc_coderange_scan(struct parser_params *p, rb_parser_string_t *str, rb_encoding *enc)
{
    return rb_parser_coderange_scan(p, PARSER_STRING_PTR(str), PARSER_STRING_LEN(str), enc);
}

static int
rb_parser_enc_str_coderange(struct parser_params *p, rb_parser_string_t *str)
{
    int cr = PARSER_ENC_CODERANGE(str);

    if (cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
        cr = rb_parser_enc_coderange_scan(p, str, rb_parser_str_get_encoding(str));
        PARSER_ENC_CODERANGE_SET(str, cr);
    }

    return cr;
}

static rb_parser_string_t *
rb_parser_enc_associate(struct parser_params *p, rb_parser_string_t *str, rb_encoding *enc)
{
    if (rb_parser_str_get_encoding(str) == enc)
        return str;
    if (!PARSER_ENC_CODERANGE_ASCIIONLY(str)) {
        PARSER_ENC_CODERANGE_CLEAR(str);
    }
    rb_parser_string_set_encoding(str, enc);
    return str;
}

static bool
rb_parser_is_ascii_string(struct parser_params *p, rb_parser_string_t *str)
{
    return rb_parser_enc_str_coderange(p, str) == RB_PARSER_ENC_CODERANGE_7BIT;
}

static rb_encoding *
rb_parser_enc_compatible(struct parser_params *p, rb_parser_string_t *str1, rb_parser_string_t *str2)
{
    rb_encoding *enc1 = rb_parser_str_get_encoding(str1);
    rb_encoding *enc2 = rb_parser_str_get_encoding(str2);

    if (enc1 == NULL || enc2 == NULL)
        return 0;

    if (enc1 == enc2) {
        return enc1;
    }

    if (PARSER_STRING_LEN(str2) == 0)
        return enc1;
    if (PARSER_STRING_LEN(str1) == 0)
        return rb_parser_is_ascii_string(p, str2) ? enc1 : enc2;

    int cr1, cr2;

    cr1 = rb_parser_enc_str_coderange(p, str1);
    cr2 = rb_parser_enc_str_coderange(p, str2);

    if (cr1 != cr2) {
        if (cr1 == RB_PARSER_ENC_CODERANGE_7BIT) return enc2;
        if (cr2 == RB_PARSER_ENC_CODERANGE_7BIT) return enc1;
    }

    if (cr2 == RB_PARSER_ENC_CODERANGE_7BIT) {
        return enc1;
    }

    if (cr1 == RB_PARSER_ENC_CODERANGE_7BIT) {
        return enc2;
    }

    return 0;
}

static void
rb_parser_str_modify(rb_parser_string_t *str)
{
    PARSER_ENC_CODERANGE_CLEAR(str);
}

static void
rb_parser_str_set_len(struct parser_params *p, rb_parser_string_t *str, long len)
{
    long capa;
    const int termlen = STRING_TERM_LEN(str);

    if (len > (capa = (long)(rb_parser_str_capacity(str, termlen))) || len < 0) {
        rb_bug("probable buffer overflow: %ld for %ld", len, capa);
    }

    int cr = PARSER_ENC_CODERANGE(str);
    if (cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
        /* Leave unknown. */
    }
    else if (len > PARSER_STRING_LEN(str)) {
        PARSER_ENC_CODERANGE_SET(str, RB_PARSER_ENC_CODERANGE_UNKNOWN);
    }
    else if (len < PARSER_STRING_LEN(str)) {
        if (cr != RB_PARSER_ENC_CODERANGE_7BIT) {
            /* ASCII-only string is keeping after truncated.  Valid
             * and broken may be invalid or valid, leave unknown. */
            PARSER_ENC_CODERANGE_SET(str, RB_PARSER_ENC_CODERANGE_UNKNOWN);
        }
    }

    STRING_SET_LEN(str, len);
    STRING_TERM_FILL(str);
}

static rb_parser_string_t *
rb_parser_str_buf_cat(struct parser_params *p, rb_parser_string_t *str, const char *ptr, long len)
{
    rb_parser_str_modify(str);
    if (len == 0) return 0;

    long total, olen, off = -1;
    char *sptr;
    const int termlen = STRING_TERM_LEN(str);

    PARSER_STRING_GETMEM(str, sptr, olen);
    if (ptr >= sptr && ptr <= sptr + olen) {
        off = ptr - sptr;
    }

    if (olen > LONG_MAX - len) {
        compile_error(p, "string sizes too big");
        return 0;
    }
    total = olen + len;
    PARSER_STRING_RESIZE_CAPA_TERM(p, str, total, termlen);
    sptr = PARSER_STRING_PTR(str);
    if (off != -1) {
        ptr = sptr + off;
    }
    memcpy(sptr + olen, ptr, len);
    STRING_SET_LEN(str, total);
    STRING_TERM_FILL(str);

    return str;
}

#define parser_str_cat(str, ptr, len) rb_parser_str_buf_cat(p, str, ptr, len)
#define parser_str_cat_cstr(str, lit) rb_parser_str_buf_cat(p, str, lit, strlen(lit))

static rb_parser_string_t *
rb_parser_enc_cr_str_buf_cat(struct parser_params *p, rb_parser_string_t *str, const char *ptr, long len,
    rb_encoding *ptr_enc, int ptr_cr, int *ptr_cr_ret)
{
    int str_cr, res_cr;
    rb_encoding *str_enc, *res_enc;

    str_enc = rb_parser_str_get_encoding(str);
    str_cr = PARSER_STRING_LEN(str) ? PARSER_ENC_CODERANGE(str) : RB_PARSER_ENC_CODERANGE_7BIT;

    if (str_enc == ptr_enc) {
        if (str_cr != RB_PARSER_ENC_CODERANGE_UNKNOWN && ptr_cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
            ptr_cr = rb_parser_coderange_scan(p, ptr, len, ptr_enc);
        }
    }
    else {
        /* parser string encoding is always asciicompat */
        if (ptr_cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
            ptr_cr = rb_parser_coderange_scan(p, ptr, len, ptr_enc);
        }
        if (str_cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
            if (str_enc == rb_ascii8bit_encoding() || ptr_cr != RB_PARSER_ENC_CODERANGE_7BIT) {
                str_cr = rb_parser_enc_str_coderange(p, str);
            }
        }
    }
    if (ptr_cr_ret)
        *ptr_cr_ret = ptr_cr;

    if (str_enc != ptr_enc &&
        str_cr != RB_PARSER_ENC_CODERANGE_7BIT &&
        ptr_cr != RB_PARSER_ENC_CODERANGE_7BIT) {
        goto incompatible;
    }

    if (str_cr == RB_PARSER_ENC_CODERANGE_UNKNOWN) {
        res_enc = str_enc;
        res_cr = RB_PARSER_ENC_CODERANGE_UNKNOWN;
    }
    else if (str_cr == RB_PARSER_ENC_CODERANGE_7BIT) {
        if (ptr_cr == RB_PARSER_ENC_CODERANGE_7BIT) {
            res_enc = str_enc;
            res_cr = RB_PARSER_ENC_CODERANGE_7BIT;
        }
        else {
            res_enc = ptr_enc;
            res_cr = ptr_cr;
        }
    }
    else if (str_cr == RB_PARSER_ENC_CODERANGE_VALID) {
        res_enc = str_enc;
        if (PARSER_ENC_CODERANGE_CLEAN_P(ptr_cr))
            res_cr = str_cr;
        else
            res_cr = ptr_cr;
    }
    else { /* str_cr == RB_PARSER_ENC_CODERANGE_BROKEN */
        res_enc = str_enc;
        res_cr = str_cr;
        if (0 < len) res_cr = RB_PARSER_ENC_CODERANGE_UNKNOWN;
    }

    if (len < 0) {
        compile_error(p, "negative string size (or size too big)");
    }
    parser_str_cat(str, ptr, len);
    PARSER_ENCODING_CODERANGE_SET(str, res_enc, res_cr);
    return str;

  incompatible:
    compile_error(p, "incompatible character encodings: %s and %s",
                  rb_enc_name(str_enc), rb_enc_name(ptr_enc));
    UNREACHABLE_RETURN(0);

}

static rb_parser_string_t *
rb_parser_enc_str_buf_cat(struct parser_params *p, rb_parser_string_t *str, const char *ptr, long len,
    rb_encoding *ptr_enc)
{
    return rb_parser_enc_cr_str_buf_cat(p, str, ptr, len, ptr_enc, RB_PARSER_ENC_CODERANGE_UNKNOWN, NULL);
}

static rb_parser_string_t *
rb_parser_str_buf_append(struct parser_params *p, rb_parser_string_t *str, rb_parser_string_t *str2)
{
    int str2_cr = rb_parser_enc_str_coderange(p, str2);

    rb_parser_enc_cr_str_buf_cat(p, str, PARSER_STRING_PTR(str2), PARSER_STRING_LEN(str2),
        rb_parser_str_get_encoding(str2), str2_cr, &str2_cr);

    PARSER_ENC_CODERANGE_SET(str2, str2_cr);

    return str;
}

static rb_parser_string_t *
rb_parser_str_resize(struct parser_params *p, rb_parser_string_t *str, long len)
{
    if (len < 0) {
        rb_bug("negative string size (or size too big)");
    }

    long slen = PARSER_STRING_LEN(str);

    if (slen > len && PARSER_ENC_CODERANGE(str) != RB_PARSER_ENC_CODERANGE_7BIT) {
        PARSER_ENC_CODERANGE_CLEAR(str);
    }

    {
        long capa;
        const int termlen = STRING_TERM_LEN(str);

        if ((capa = slen) < len) {
            SIZED_REALLOC_N(str->ptr, char, (size_t)len + termlen, STRING_SIZE(str));
        }
        else if (len == slen) return str;
        STRING_SET_LEN(str, len);
        STRING_TERM_FILL(str);
    }
    return str;
}

# define PARSER_ENC_STRING_GETMEM(str, ptrvar, lenvar, encvar) \
    ((ptrvar) = str->ptr,                            \
     (lenvar) = str->len,                            \
     (encvar) = str->enc)

static int
rb_parser_string_hash_cmp(rb_parser_string_t *str1, rb_parser_string_t *str2)
{
    long len1, len2;
    const char *ptr1, *ptr2;
    rb_encoding *enc1, *enc2;

    PARSER_ENC_STRING_GETMEM(str1, ptr1, len1, enc1);
    PARSER_ENC_STRING_GETMEM(str2, ptr2, len2, enc2);

    return (len1 != len2 ||
            enc1 != enc2 ||
            memcmp(ptr1, ptr2, len1) != 0);
}

static void
rb_parser_ary_extend(rb_parser_t *p, rb_parser_ary_t *ary, long len)
{
    long i;
    if (ary->capa < len) {
        ary->capa = len;
        ary->data = (rb_parser_ary_data *)xrealloc(ary->data, sizeof(rb_parser_ary_data) * len);
        for (i = ary->len; i < len; i++) {
            ary->data[i] = 0;
        }
    }
}

/*
 * Do not call this directly.
 * Use rb_parser_ary_new_capa_for_XXX() instead.
 */
static rb_parser_ary_t *
parser_ary_new_capa(rb_parser_t *p, long len)
{
    if (len < 0) {
        rb_bug("negative array size (or size too big): %ld", len);
    }
    rb_parser_ary_t *ary = xcalloc(1, sizeof(rb_parser_ary_t));
    ary->data_type = 0;
    ary->len = 0;
    ary->capa = len;
    if (0 < len) {
        ary->data = (rb_parser_ary_data *)xcalloc(len, sizeof(rb_parser_ary_data));
    }
    else {
        ary->data = NULL;
    }
    return ary;
}

#ifndef RIPPER
static rb_parser_ary_t *
rb_parser_ary_new_capa_for_script_line(rb_parser_t *p, long len)
{
    rb_parser_ary_t *ary = parser_ary_new_capa(p, len);
    ary->data_type = PARSER_ARY_DATA_SCRIPT_LINE;
    return ary;
}

static rb_parser_ary_t *
rb_parser_ary_new_capa_for_ast_token(rb_parser_t *p, long len)
{
    rb_parser_ary_t *ary = parser_ary_new_capa(p, len);
    ary->data_type = PARSER_ARY_DATA_AST_TOKEN;
    return ary;
}
#endif

static rb_parser_ary_t *
rb_parser_ary_new_capa_for_node(rb_parser_t *p, long len)
{
    rb_parser_ary_t *ary = parser_ary_new_capa(p, len);
    ary->data_type = PARSER_ARY_DATA_NODE;
    return ary;
}

/*
 * Do not call this directly.
 * Use rb_parser_ary_push_XXX() instead.
 */
static rb_parser_ary_t *
parser_ary_push(rb_parser_t *p, rb_parser_ary_t *ary, rb_parser_ary_data val)
{
    if (ary->len == ary->capa) {
        rb_parser_ary_extend(p, ary, ary->len == 0 ? 1 : ary->len * 2);
    }
    ary->data[ary->len++] = val;
    return ary;
}

#ifndef RIPPER
static rb_parser_ary_t *
rb_parser_ary_push_ast_token(rb_parser_t *p, rb_parser_ary_t *ary, rb_parser_ast_token_t *val)
{
    if (ary->data_type != PARSER_ARY_DATA_AST_TOKEN) {
        rb_bug("unexpected rb_parser_ary_data_type: %d", ary->data_type);
    }
    return parser_ary_push(p, ary, val);
}

static rb_parser_ary_t *
rb_parser_ary_push_script_line(rb_parser_t *p, rb_parser_ary_t *ary, rb_parser_string_t *val)
{
    if (ary->data_type != PARSER_ARY_DATA_SCRIPT_LINE) {
        rb_bug("unexpected rb_parser_ary_data_type: %d", ary->data_type);
    }
    return parser_ary_push(p, ary, val);
}
#endif

static rb_parser_ary_t *
rb_parser_ary_push_node(rb_parser_t *p, rb_parser_ary_t *ary, NODE *val)
{
    if (ary->data_type != PARSER_ARY_DATA_NODE) {
        rb_bug("unexpected rb_parser_ary_data_type: %d", ary->data_type);
    }
    return parser_ary_push(p, ary, val);
}

#ifndef RIPPER
static void
rb_parser_ast_token_free(rb_parser_t *p, rb_parser_ast_token_t *token)
{
    if (!token) return;
    rb_parser_string_free(p, token->str);
    xfree(token);
}

static void
rb_parser_ary_free(rb_parser_t *p, rb_parser_ary_t *ary)
{
# define foreach_ary(ptr) \
    for (rb_parser_ary_data *ptr = ary->data, *const end_ary_data = ptr + ary->len; \
         ptr < end_ary_data; ptr++)
    switch (ary->data_type) {
      case PARSER_ARY_DATA_AST_TOKEN:
        foreach_ary(data) {rb_parser_ast_token_free(p, *data);}
        break;
      case PARSER_ARY_DATA_SCRIPT_LINE:
        foreach_ary(data) {rb_parser_string_free(p, *data);}
        break;
      case PARSER_ARY_DATA_NODE:
        /* Do nothing because nodes are freed when rb_ast_t is freed */
        break;
      default:
        rb_bug("unexpected rb_parser_ary_data_type: %d", ary->data_type);
        break;
    }
# undef foreach_ary
    xfree(ary->data);
    xfree(ary);
}

#endif /* !RIPPER */

#line 2671 "parse.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parse.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end-of-input"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_keyword_class = 3,              /* "'class'"  */
  YYSYMBOL_keyword_module = 4,             /* "'module'"  */
  YYSYMBOL_keyword_def = 5,                /* "'def'"  */
  YYSYMBOL_keyword_undef = 6,              /* "'undef'"  */
  YYSYMBOL_keyword_begin = 7,              /* "'begin'"  */
  YYSYMBOL_keyword_rescue = 8,             /* "'rescue'"  */
  YYSYMBOL_keyword_ensure = 9,             /* "'ensure'"  */
  YYSYMBOL_keyword_end = 10,               /* "'end'"  */
  YYSYMBOL_keyword_if = 11,                /* "'if'"  */
  YYSYMBOL_keyword_unless = 12,            /* "'unless'"  */
  YYSYMBOL_keyword_then = 13,              /* "'then'"  */
  YYSYMBOL_keyword_elsif = 14,             /* "'elsif'"  */
  YYSYMBOL_keyword_else = 15,              /* "'else'"  */
  YYSYMBOL_keyword_case = 16,              /* "'case'"  */
  YYSYMBOL_keyword_when = 17,              /* "'when'"  */
  YYSYMBOL_keyword_while = 18,             /* "'while'"  */
  YYSYMBOL_keyword_until = 19,             /* "'until'"  */
  YYSYMBOL_keyword_for = 20,               /* "'for'"  */
  YYSYMBOL_keyword_break = 21,             /* "'break'"  */
  YYSYMBOL_keyword_next = 22,              /* "'next'"  */
  YYSYMBOL_keyword_redo = 23,              /* "'redo'"  */
  YYSYMBOL_keyword_retry = 24,             /* "'retry'"  */
  YYSYMBOL_keyword_in = 25,                /* "'in'"  */
  YYSYMBOL_keyword_do = 26,                /* "'do'"  */
  YYSYMBOL_keyword_do_cond = 27,           /* "'do' for condition"  */
  YYSYMBOL_keyword_do_block = 28,          /* "'do' for block"  */
  YYSYMBOL_keyword_do_LAMBDA = 29,         /* "'do' for lambda"  */
  YYSYMBOL_keyword_return = 30,            /* "'return'"  */
  YYSYMBOL_keyword_yield = 31,             /* "'yield'"  */
  YYSYMBOL_keyword_super = 32,             /* "'super'"  */
  YYSYMBOL_keyword_self = 33,              /* "'self'"  */
  YYSYMBOL_keyword_nil = 34,               /* "'nil'"  */
  YYSYMBOL_keyword_true = 35,              /* "'true'"  */
  YYSYMBOL_keyword_false = 36,             /* "'false'"  */
  YYSYMBOL_keyword_and = 37,               /* "'and'"  */
  YYSYMBOL_keyword_or = 38,                /* "'or'"  */
  YYSYMBOL_keyword_not = 39,               /* "'not'"  */
  YYSYMBOL_modifier_if = 40,               /* "'if' modifier"  */
  YYSYMBOL_modifier_unless = 41,           /* "'unless' modifier"  */
  YYSYMBOL_modifier_while = 42,            /* "'while' modifier"  */
  YYSYMBOL_modifier_until = 43,            /* "'until' modifier"  */
  YYSYMBOL_modifier_rescue = 44,           /* "'rescue' modifier"  */
  YYSYMBOL_keyword_alias = 45,             /* "'alias'"  */
  YYSYMBOL_keyword_defined = 46,           /* "'defined?'"  */
  YYSYMBOL_keyword_BEGIN = 47,             /* "'BEGIN'"  */
  YYSYMBOL_keyword_END = 48,               /* "'END'"  */
  YYSYMBOL_keyword__LINE__ = 49,           /* "'__LINE__'"  */
  YYSYMBOL_keyword__FILE__ = 50,           /* "'__FILE__'"  */
  YYSYMBOL_keyword__ENCODING__ = 51,       /* "'__ENCODING__'"  */
  YYSYMBOL_tIDENTIFIER = 52,               /* "local variable or method"  */
  YYSYMBOL_tFID = 53,                      /* "method"  */
  YYSYMBOL_tGVAR = 54,                     /* "global variable"  */
  YYSYMBOL_tIVAR = 55,                     /* "instance variable"  */
  YYSYMBOL_tCONSTANT = 56,                 /* "constant"  */
  YYSYMBOL_tCVAR = 57,                     /* "class variable"  */
  YYSYMBOL_tLABEL = 58,                    /* "label"  */
  YYSYMBOL_tINTEGER = 59,                  /* "integer literal"  */
  YYSYMBOL_tFLOAT = 60,                    /* "float literal"  */
  YYSYMBOL_tRATIONAL = 61,                 /* "rational literal"  */
  YYSYMBOL_tIMAGINARY = 62,                /* "imaginary literal"  */
  YYSYMBOL_tCHAR = 63,                     /* "char literal"  */
  YYSYMBOL_tNTH_REF = 64,                  /* "numbered reference"  */
  YYSYMBOL_tBACK_REF = 65,                 /* "back reference"  */
  YYSYMBOL_tSTRING_CONTENT = 66,           /* "literal content"  */
  YYSYMBOL_tREGEXP_END = 67,               /* tREGEXP_END  */
  YYSYMBOL_tDUMNY_END = 68,                /* "dummy end"  */
  YYSYMBOL_69_ = 69,                       /* '.'  */
  YYSYMBOL_70_backslash_ = 70,             /* "backslash"  */
  YYSYMBOL_tSP = 71,                       /* "escaped space"  */
  YYSYMBOL_72_escaped_horizontal_tab_ = 72, /* "escaped horizontal tab"  */
  YYSYMBOL_73_escaped_form_feed_ = 73,     /* "escaped form feed"  */
  YYSYMBOL_74_escaped_carriage_return_ = 74, /* "escaped carriage return"  */
  YYSYMBOL_75_escaped_vertical_tab_ = 75,  /* "escaped vertical tab"  */
  YYSYMBOL_tUPLUS = 76,                    /* "unary+"  */
  YYSYMBOL_tUMINUS = 77,                   /* "unary-"  */
  YYSYMBOL_tPOW = 78,                      /* "**"  */
  YYSYMBOL_tCMP = 79,                      /* "<=>"  */
  YYSYMBOL_tEQ = 80,                       /* "=="  */
  YYSYMBOL_tEQQ = 81,                      /* "==="  */
  YYSYMBOL_tNEQ = 82,                      /* "!="  */
  YYSYMBOL_tGEQ = 83,                      /* ">="  */
  YYSYMBOL_tLEQ = 84,                      /* "<="  */
  YYSYMBOL_tANDOP = 85,                    /* "&&"  */
  YYSYMBOL_tOROP = 86,                     /* "||"  */
  YYSYMBOL_tMATCH = 87,                    /* "=~"  */
  YYSYMBOL_tNMATCH = 88,                   /* "!~"  */
  YYSYMBOL_tDOT2 = 89,                     /* ".."  */
  YYSYMBOL_tDOT3 = 90,                     /* "..."  */
  YYSYMBOL_tBDOT2 = 91,                    /* "(.."  */
  YYSYMBOL_tBDOT3 = 92,                    /* "(..."  */
  YYSYMBOL_tAREF = 93,                     /* "[]"  */
  YYSYMBOL_tASET = 94,                     /* "[]="  */
  YYSYMBOL_tLSHFT = 95,                    /* "<<"  */
  YYSYMBOL_tRSHFT = 96,                    /* ">>"  */
  YYSYMBOL_tANDDOT = 97,                   /* "&."  */
  YYSYMBOL_tCOLON2 = 98,                   /* "::"  */
  YYSYMBOL_tCOLON3 = 99,                   /* ":: at EXPR_BEG"  */
  YYSYMBOL_tOP_ASGN = 100,                 /* "operator-assignment"  */
  YYSYMBOL_tASSOC = 101,                   /* "=>"  */
  YYSYMBOL_tLPAREN = 102,                  /* "("  */
  YYSYMBOL_tLPAREN_ARG = 103,              /* "( arg"  */
  YYSYMBOL_tLBRACK = 104,                  /* "["  */
  YYSYMBOL_tLBRACE = 105,                  /* "{"  */
  YYSYMBOL_tLBRACE_ARG = 106,              /* "{ arg"  */
  YYSYMBOL_tSTAR = 107,                    /* "*"  */
  YYSYMBOL_tDSTAR = 108,                   /* "**arg"  */
  YYSYMBOL_tAMPER = 109,                   /* "&"  */
  YYSYMBOL_tLAMBDA = 110,                  /* "->"  */
  YYSYMBOL_tSYMBEG = 111,                  /* "symbol literal"  */
  YYSYMBOL_tSTRING_BEG = 112,              /* "string literal"  */
  YYSYMBOL_tXSTRING_BEG = 113,             /* "backtick literal"  */
  YYSYMBOL_tREGEXP_BEG = 114,              /* "regexp literal"  */
  YYSYMBOL_tWORDS_BEG = 115,               /* "word list"  */
  YYSYMBOL_tQWORDS_BEG = 116,              /* "verbatim word list"  */
  YYSYMBOL_tSYMBOLS_BEG = 117,             /* "symbol list"  */
  YYSYMBOL_tQSYMBOLS_BEG = 118,            /* "verbatim symbol list"  */
  YYSYMBOL_tSTRING_END = 119,              /* "terminator"  */
  YYSYMBOL_tSTRING_DEND = 120,             /* "'}'"  */
  YYSYMBOL_tSTRING_DBEG = 121,             /* "'#{'"  */
  YYSYMBOL_tSTRING_DVAR = 122,             /* tSTRING_DVAR  */
  YYSYMBOL_tLAMBEG = 123,                  /* tLAMBEG  */
  YYSYMBOL_tLABEL_END = 124,               /* tLABEL_END  */
  YYSYMBOL_tIGNORED_NL = 125,              /* tIGNORED_NL  */
  YYSYMBOL_tCOMMENT = 126,                 /* tCOMMENT  */
  YYSYMBOL_tEMBDOC_BEG = 127,              /* tEMBDOC_BEG  */
  YYSYMBOL_tEMBDOC = 128,                  /* tEMBDOC  */
  YYSYMBOL_tEMBDOC_END = 129,              /* tEMBDOC_END  */
  YYSYMBOL_tHEREDOC_BEG = 130,             /* tHEREDOC_BEG  */
  YYSYMBOL_tHEREDOC_END = 131,             /* tHEREDOC_END  */
  YYSYMBOL_k__END__ = 132,                 /* k__END__  */
  YYSYMBOL_tLOWEST = 133,                  /* tLOWEST  */
  YYSYMBOL_134_ = 134,                     /* '='  */
  YYSYMBOL_135_ = 135,                     /* '?'  */
  YYSYMBOL_136_ = 136,                     /* ':'  */
  YYSYMBOL_137_ = 137,                     /* '>'  */
  YYSYMBOL_138_ = 138,                     /* '<'  */
  YYSYMBOL_139_ = 139,                     /* '|'  */
  YYSYMBOL_140_ = 140,                     /* '^'  */
  YYSYMBOL_141_ = 141,                     /* '&'  */
  YYSYMBOL_142_ = 142,                     /* '+'  */
  YYSYMBOL_143_ = 143,                     /* '-'  */
  YYSYMBOL_144_ = 144,                     /* '*'  */
  YYSYMBOL_145_ = 145,                     /* '/'  */
  YYSYMBOL_146_ = 146,                     /* '%'  */
  YYSYMBOL_tUMINUS_NUM = 147,              /* tUMINUS_NUM  */
  YYSYMBOL_148_ = 148,                     /* '!'  */
  YYSYMBOL_149_ = 149,                     /* '~'  */
  YYSYMBOL_tLAST_TOKEN = 150,              /* tLAST_TOKEN  */
  YYSYMBOL_151_ = 151,                     /* '{'  */
  YYSYMBOL_152_ = 152,                     /* '}'  */
  YYSYMBOL_153_ = 153,                     /* '['  */
  YYSYMBOL_154_n_ = 154,                   /* '\n'  */
  YYSYMBOL_155_ = 155,                     /* ','  */
  YYSYMBOL_156_ = 156,                     /* '`'  */
  YYSYMBOL_157_ = 157,                     /* '('  */
  YYSYMBOL_158_ = 158,                     /* ')'  */
  YYSYMBOL_159_ = 159,                     /* ']'  */
  YYSYMBOL_160_ = 160,                     /* ';'  */
  YYSYMBOL_161_ = 161,                     /* ' '  */
  YYSYMBOL_YYACCEPT = 162,                 /* $accept  */
  YYSYMBOL_option_terms = 163,             /* option_terms  */
  YYSYMBOL_compstmt_top_stmts = 164,       /* compstmt_top_stmts  */
  YYSYMBOL_165_1 = 165,                    /* $@1  */
  YYSYMBOL_program = 166,                  /* program  */
  YYSYMBOL_top_stmts = 167,                /* top_stmts  */
  YYSYMBOL_top_stmt = 168,                 /* top_stmt  */
  YYSYMBOL_block_open = 169,               /* block_open  */
  YYSYMBOL_begin_block = 170,              /* begin_block  */
  YYSYMBOL_compstmt_stmts = 171,           /* compstmt_stmts  */
  YYSYMBOL_172_2 = 172,                    /* $@2  */
  YYSYMBOL_173_3 = 173,                    /* $@3  */
  YYSYMBOL_bodystmt = 174,                 /* bodystmt  */
  YYSYMBOL_175_4 = 175,                    /* $@4  */
  YYSYMBOL_stmts = 176,                    /* stmts  */
  YYSYMBOL_stmt_or_begin = 177,            /* stmt_or_begin  */
  YYSYMBOL_178_5 = 178,                    /* $@5  */
  YYSYMBOL_allow_exits = 179,              /* allow_exits  */
  YYSYMBOL_k_END = 180,                    /* k_END  */
  YYSYMBOL_181_6 = 181,                    /* $@6  */
  YYSYMBOL_stmt = 182,                     /* stmt  */
  YYSYMBOL_asgn_mrhs = 183,                /* asgn_mrhs  */
  YYSYMBOL_asgn_command_rhs = 184,         /* asgn_command_rhs  */
  YYSYMBOL_command_asgn = 185,             /* command_asgn  */
  YYSYMBOL_op_asgn_command_rhs = 186,      /* op_asgn_command_rhs  */
  YYSYMBOL_def_endless_method_endless_command = 187, /* def_endless_method_endless_command  */
  YYSYMBOL_endless_command = 188,          /* endless_command  */
  YYSYMBOL_option__n_ = 189,               /* option_'\n'  */
  YYSYMBOL_command_rhs = 190,              /* command_rhs  */
  YYSYMBOL_expr = 191,                     /* expr  */
  YYSYMBOL_192_7 = 192,                    /* $@7  */
  YYSYMBOL_193_8 = 193,                    /* $@8  */
  YYSYMBOL_def_name = 194,                 /* def_name  */
  YYSYMBOL_defn_head = 195,                /* defn_head  */
  YYSYMBOL_196_9 = 196,                    /* $@9  */
  YYSYMBOL_defs_head = 197,                /* defs_head  */
  YYSYMBOL_value_expr_expr = 198,          /* value_expr_expr  */
  YYSYMBOL_expr_value = 199,               /* expr_value  */
  YYSYMBOL_200_10 = 200,                   /* $@10  */
  YYSYMBOL_201_11 = 201,                   /* $@11  */
  YYSYMBOL_expr_value_do = 202,            /* expr_value_do  */
  YYSYMBOL_command_call = 203,             /* command_call  */
  YYSYMBOL_value_expr_command_call = 204,  /* value_expr_command_call  */
  YYSYMBOL_command_call_value = 205,       /* command_call_value  */
  YYSYMBOL_block_command = 206,            /* block_command  */
  YYSYMBOL_cmd_brace_block = 207,          /* cmd_brace_block  */
  YYSYMBOL_fcall = 208,                    /* fcall  */
  YYSYMBOL_command = 209,                  /* command  */
  YYSYMBOL_mlhs = 210,                     /* mlhs  */
  YYSYMBOL_mlhs_inner = 211,               /* mlhs_inner  */
  YYSYMBOL_mlhs_basic = 212,               /* mlhs_basic  */
  YYSYMBOL_mlhs_items_mlhs_item = 213,     /* mlhs_items_mlhs_item  */
  YYSYMBOL_mlhs_item = 214,                /* mlhs_item  */
  YYSYMBOL_mlhs_head = 215,                /* mlhs_head  */
  YYSYMBOL_mlhs_node = 216,                /* mlhs_node  */
  YYSYMBOL_lhs = 217,                      /* lhs  */
  YYSYMBOL_cname = 218,                    /* cname  */
  YYSYMBOL_cpath = 219,                    /* cpath  */
  YYSYMBOL_fname = 220,                    /* fname  */
  YYSYMBOL_fitem = 221,                    /* fitem  */
  YYSYMBOL_undef_list = 222,               /* undef_list  */
  YYSYMBOL_223_12 = 223,                   /* $@12  */
  YYSYMBOL_op = 224,                       /* op  */
  YYSYMBOL_reswords = 225,                 /* reswords  */
  YYSYMBOL_asgn_arg_rhs = 226,             /* asgn_arg_rhs  */
  YYSYMBOL_arg = 227,                      /* arg  */
  YYSYMBOL_op_asgn_arg_rhs = 228,          /* op_asgn_arg_rhs  */
  YYSYMBOL_range_expr_arg = 229,           /* range_expr_arg  */
  YYSYMBOL_def_endless_method_endless_arg = 230, /* def_endless_method_endless_arg  */
  YYSYMBOL_ternary = 231,                  /* ternary  */
  YYSYMBOL_endless_arg = 232,              /* endless_arg  */
  YYSYMBOL_relop = 233,                    /* relop  */
  YYSYMBOL_rel_expr = 234,                 /* rel_expr  */
  YYSYMBOL_lex_ctxt = 235,                 /* lex_ctxt  */
  YYSYMBOL_begin_defined = 236,            /* begin_defined  */
  YYSYMBOL_after_rescue = 237,             /* after_rescue  */
  YYSYMBOL_value_expr_arg = 238,           /* value_expr_arg  */
  YYSYMBOL_arg_value = 239,                /* arg_value  */
  YYSYMBOL_aref_args = 240,                /* aref_args  */
  YYSYMBOL_arg_rhs = 241,                  /* arg_rhs  */
  YYSYMBOL_paren_args = 242,               /* paren_args  */
  YYSYMBOL_opt_paren_args = 243,           /* opt_paren_args  */
  YYSYMBOL_opt_call_args = 244,            /* opt_call_args  */
  YYSYMBOL_value_expr_command = 245,       /* value_expr_command  */
  YYSYMBOL_call_args = 246,                /* call_args  */
  YYSYMBOL_247_13 = 247,                   /* $@13  */
  YYSYMBOL_command_args = 248,             /* command_args  */
  YYSYMBOL_block_arg = 249,                /* block_arg  */
  YYSYMBOL_opt_block_arg = 250,            /* opt_block_arg  */
  YYSYMBOL_args = 251,                     /* args  */
  YYSYMBOL_arg_splat = 252,                /* arg_splat  */
  YYSYMBOL_mrhs_arg = 253,                 /* mrhs_arg  */
  YYSYMBOL_mrhs = 254,                     /* mrhs  */
  YYSYMBOL_primary = 255,                  /* primary  */
  YYSYMBOL_256_14 = 256,                   /* $@14  */
  YYSYMBOL_257_15 = 257,                   /* $@15  */
  YYSYMBOL_258_16 = 258,                   /* @16  */
  YYSYMBOL_259_17 = 259,                   /* @17  */
  YYSYMBOL_260_18 = 260,                   /* $@18  */
  YYSYMBOL_261_19 = 261,                   /* $@19  */
  YYSYMBOL_262_20 = 262,                   /* $@20  */
  YYSYMBOL_263_21 = 263,                   /* $@21  */
  YYSYMBOL_264_22 = 264,                   /* $@22  */
  YYSYMBOL_265_23 = 265,                   /* $@23  */
  YYSYMBOL_266_24 = 266,                   /* $@24  */
  YYSYMBOL_value_expr_primary = 267,       /* value_expr_primary  */
  YYSYMBOL_primary_value = 268,            /* primary_value  */
  YYSYMBOL_k_begin = 269,                  /* k_begin  */
  YYSYMBOL_k_if = 270,                     /* k_if  */
  YYSYMBOL_k_unless = 271,                 /* k_unless  */
  YYSYMBOL_k_while = 272,                  /* k_while  */
  YYSYMBOL_k_until = 273,                  /* k_until  */
  YYSYMBOL_k_case = 274,                   /* k_case  */
  YYSYMBOL_k_for = 275,                    /* k_for  */
  YYSYMBOL_k_class = 276,                  /* k_class  */
  YYSYMBOL_k_module = 277,                 /* k_module  */
  YYSYMBOL_k_def = 278,                    /* k_def  */
  YYSYMBOL_k_do = 279,                     /* k_do  */
  YYSYMBOL_k_do_block = 280,               /* k_do_block  */
  YYSYMBOL_k_rescue = 281,                 /* k_rescue  */
  YYSYMBOL_k_ensure = 282,                 /* k_ensure  */
  YYSYMBOL_k_when = 283,                   /* k_when  */
  YYSYMBOL_k_else = 284,                   /* k_else  */
  YYSYMBOL_k_elsif = 285,                  /* k_elsif  */
  YYSYMBOL_k_end = 286,                    /* k_end  */
  YYSYMBOL_k_return = 287,                 /* k_return  */
  YYSYMBOL_k_yield = 288,                  /* k_yield  */
  YYSYMBOL_then = 289,                     /* then  */
  YYSYMBOL_do = 290,                       /* do  */
  YYSYMBOL_if_tail = 291,                  /* if_tail  */
  YYSYMBOL_opt_else = 292,                 /* opt_else  */
  YYSYMBOL_for_var = 293,                  /* for_var  */
  YYSYMBOL_f_marg = 294,                   /* f_marg  */
  YYSYMBOL_mlhs_items_f_marg = 295,        /* mlhs_items_f_marg  */
  YYSYMBOL_f_margs = 296,                  /* f_margs  */
  YYSYMBOL_f_rest_marg = 297,              /* f_rest_marg  */
  YYSYMBOL_f_any_kwrest = 298,             /* f_any_kwrest  */
  YYSYMBOL_299_25 = 299,                   /* $@25  */
  YYSYMBOL_f_eq = 300,                     /* f_eq  */
  YYSYMBOL_f_kw_primary_value = 301,       /* f_kw_primary_value  */
  YYSYMBOL_f_kwarg_primary_value = 302,    /* f_kwarg_primary_value  */
  YYSYMBOL_args_tail_basic_primary_value = 303, /* args_tail_basic_primary_value  */
  YYSYMBOL_block_args_tail = 304,          /* block_args_tail  */
  YYSYMBOL_excessed_comma = 305,           /* excessed_comma  */
  YYSYMBOL_f_opt_primary_value = 306,      /* f_opt_primary_value  */
  YYSYMBOL_f_opt_arg_primary_value = 307,  /* f_opt_arg_primary_value  */
  YYSYMBOL_opt_args_tail_block_args_tail = 308, /* opt_args_tail_block_args_tail  */
  YYSYMBOL_block_param = 309,              /* block_param  */
  YYSYMBOL_opt_block_param_def = 310,      /* opt_block_param_def  */
  YYSYMBOL_block_param_def = 311,          /* block_param_def  */
  YYSYMBOL_opt_block_param = 312,          /* opt_block_param  */
  YYSYMBOL_opt_bv_decl = 313,              /* opt_bv_decl  */
  YYSYMBOL_bv_decls = 314,                 /* bv_decls  */
  YYSYMBOL_bvar = 315,                     /* bvar  */
  YYSYMBOL_max_numparam = 316,             /* max_numparam  */
  YYSYMBOL_numparam = 317,                 /* numparam  */
  YYSYMBOL_it_id = 318,                    /* it_id  */
  YYSYMBOL_319_26 = 319,                   /* @26  */
  YYSYMBOL_320_27 = 320,                   /* $@27  */
  YYSYMBOL_lambda = 321,                   /* lambda  */
  YYSYMBOL_f_larglist = 322,               /* f_larglist  */
  YYSYMBOL_lambda_body = 323,              /* lambda_body  */
  YYSYMBOL_324_28 = 324,                   /* $@28  */
  YYSYMBOL_do_block = 325,                 /* do_block  */
  YYSYMBOL_block_call = 326,               /* block_call  */
  YYSYMBOL_method_call = 327,              /* method_call  */
  YYSYMBOL_brace_block = 328,              /* brace_block  */
  YYSYMBOL_329_29 = 329,                   /* @29  */
  YYSYMBOL_brace_body = 330,               /* brace_body  */
  YYSYMBOL_331_30 = 331,                   /* @30  */
  YYSYMBOL_do_body = 332,                  /* do_body  */
  YYSYMBOL_case_args = 333,                /* case_args  */
  YYSYMBOL_case_body = 334,                /* case_body  */
  YYSYMBOL_cases = 335,                    /* cases  */
  YYSYMBOL_p_pvtbl = 336,                  /* p_pvtbl  */
  YYSYMBOL_p_pktbl = 337,                  /* p_pktbl  */
  YYSYMBOL_p_in_kwarg = 338,               /* p_in_kwarg  */
  YYSYMBOL_339_31 = 339,                   /* $@31  */
  YYSYMBOL_p_case_body = 340,              /* p_case_body  */
  YYSYMBOL_p_cases = 341,                  /* p_cases  */
  YYSYMBOL_p_top_expr = 342,               /* p_top_expr  */
  YYSYMBOL_p_top_expr_body = 343,          /* p_top_expr_body  */
  YYSYMBOL_p_expr = 344,                   /* p_expr  */
  YYSYMBOL_p_as = 345,                     /* p_as  */
  YYSYMBOL_346_32 = 346,                   /* $@32  */
  YYSYMBOL_p_alt = 347,                    /* p_alt  */
  YYSYMBOL_p_lparen = 348,                 /* p_lparen  */
  YYSYMBOL_p_lbracket = 349,               /* p_lbracket  */
  YYSYMBOL_p_expr_basic = 350,             /* p_expr_basic  */
  YYSYMBOL_351_33 = 351,                   /* $@33  */
  YYSYMBOL_p_args = 352,                   /* p_args  */
  YYSYMBOL_p_args_head = 353,              /* p_args_head  */
  YYSYMBOL_p_args_tail = 354,              /* p_args_tail  */
  YYSYMBOL_p_find = 355,                   /* p_find  */
  YYSYMBOL_p_rest = 356,                   /* p_rest  */
  YYSYMBOL_p_args_post = 357,              /* p_args_post  */
  YYSYMBOL_p_arg = 358,                    /* p_arg  */
  YYSYMBOL_p_kwargs = 359,                 /* p_kwargs  */
  YYSYMBOL_p_kwarg = 360,                  /* p_kwarg  */
  YYSYMBOL_p_kw = 361,                     /* p_kw  */
  YYSYMBOL_p_kw_label = 362,               /* p_kw_label  */
  YYSYMBOL_p_kwrest = 363,                 /* p_kwrest  */
  YYSYMBOL_p_kwnorest = 364,               /* p_kwnorest  */
  YYSYMBOL_p_any_kwrest = 365,             /* p_any_kwrest  */
  YYSYMBOL_p_value = 366,                  /* p_value  */
  YYSYMBOL_range_expr_p_primitive = 367,   /* range_expr_p_primitive  */
  YYSYMBOL_p_primitive = 368,              /* p_primitive  */
  YYSYMBOL_p_variable = 369,               /* p_variable  */
  YYSYMBOL_p_var_ref = 370,                /* p_var_ref  */
  YYSYMBOL_p_expr_ref = 371,               /* p_expr_ref  */
  YYSYMBOL_p_const = 372,                  /* p_const  */
  YYSYMBOL_opt_rescue = 373,               /* opt_rescue  */
  YYSYMBOL_exc_list = 374,                 /* exc_list  */
  YYSYMBOL_exc_var = 375,                  /* exc_var  */
  YYSYMBOL_opt_ensure = 376,               /* opt_ensure  */
  YYSYMBOL_literal = 377,                  /* literal  */
  YYSYMBOL_strings = 378,                  /* strings  */
  YYSYMBOL_string = 379,                   /* string  */
  YYSYMBOL_string1 = 380,                  /* string1  */
  YYSYMBOL_xstring = 381,                  /* xstring  */
  YYSYMBOL_regexp = 382,                   /* regexp  */
  YYSYMBOL_nonempty_list__ = 383,          /* nonempty_list_' '  */
  YYSYMBOL_words_tWORDS_BEG_word_list = 384, /* words_tWORDS_BEG_word_list  */
  YYSYMBOL_words = 385,                    /* words  */
  YYSYMBOL_word_list = 386,                /* word_list  */
  YYSYMBOL_word = 387,                     /* word  */
  YYSYMBOL_words_tSYMBOLS_BEG_symbol_list = 388, /* words_tSYMBOLS_BEG_symbol_list  */
  YYSYMBOL_symbols = 389,                  /* symbols  */
  YYSYMBOL_symbol_list = 390,              /* symbol_list  */
  YYSYMBOL_words_tQWORDS_BEG_qword_list = 391, /* words_tQWORDS_BEG_qword_list  */
  YYSYMBOL_qwords = 392,                   /* qwords  */
  YYSYMBOL_words_tQSYMBOLS_BEG_qsym_list = 393, /* words_tQSYMBOLS_BEG_qsym_list  */
  YYSYMBOL_qsymbols = 394,                 /* qsymbols  */
  YYSYMBOL_qword_list = 395,               /* qword_list  */
  YYSYMBOL_qsym_list = 396,                /* qsym_list  */
  YYSYMBOL_string_contents = 397,          /* string_contents  */
  YYSYMBOL_xstring_contents = 398,         /* xstring_contents  */
  YYSYMBOL_regexp_contents = 399,          /* regexp_contents  */
  YYSYMBOL_string_content = 400,           /* string_content  */
  YYSYMBOL_401_34 = 401,                   /* @34  */
  YYSYMBOL_402_35 = 402,                   /* @35  */
  YYSYMBOL_403_36 = 403,                   /* @36  */
  YYSYMBOL_404_37 = 404,                   /* @37  */
  YYSYMBOL_string_dend = 405,              /* string_dend  */
  YYSYMBOL_string_dvar = 406,              /* string_dvar  */
  YYSYMBOL_symbol = 407,                   /* symbol  */
  YYSYMBOL_ssym = 408,                     /* ssym  */
  YYSYMBOL_sym = 409,                      /* sym  */
  YYSYMBOL_dsym = 410,                     /* dsym  */
  YYSYMBOL_numeric = 411,                  /* numeric  */
  YYSYMBOL_simple_numeric = 412,           /* simple_numeric  */
  YYSYMBOL_nonlocal_var = 413,             /* nonlocal_var  */
  YYSYMBOL_user_variable = 414,            /* user_variable  */
  YYSYMBOL_keyword_variable = 415,         /* keyword_variable  */
  YYSYMBOL_var_ref = 416,                  /* var_ref  */
  YYSYMBOL_var_lhs = 417,                  /* var_lhs  */
  YYSYMBOL_backref = 418,                  /* backref  */
  YYSYMBOL_419_38 = 419,                   /* $@38  */
  YYSYMBOL_superclass = 420,               /* superclass  */
  YYSYMBOL_f_opt_paren_args = 421,         /* f_opt_paren_args  */
  YYSYMBOL_f_paren_args = 422,             /* f_paren_args  */
  YYSYMBOL_f_arglist = 423,                /* f_arglist  */
  YYSYMBOL_424_39 = 424,                   /* @39  */
  YYSYMBOL_f_kw_arg_value = 425,           /* f_kw_arg_value  */
  YYSYMBOL_f_kwarg_arg_value = 426,        /* f_kwarg_arg_value  */
  YYSYMBOL_args_tail_basic_arg_value = 427, /* args_tail_basic_arg_value  */
  YYSYMBOL_args_tail = 428,                /* args_tail  */
  YYSYMBOL_f_opt_arg_value = 429,          /* f_opt_arg_value  */
  YYSYMBOL_f_opt_arg_arg_value = 430,      /* f_opt_arg_arg_value  */
  YYSYMBOL_opt_args_tail_args_tail = 431,  /* opt_args_tail_args_tail  */
  YYSYMBOL_f_args = 432,                   /* f_args  */
  YYSYMBOL_args_forward = 433,             /* args_forward  */
  YYSYMBOL_f_bad_arg = 434,                /* f_bad_arg  */
  YYSYMBOL_f_norm_arg = 435,               /* f_norm_arg  */
  YYSYMBOL_f_arg_asgn = 436,               /* f_arg_asgn  */
  YYSYMBOL_f_arg_item = 437,               /* f_arg_item  */
  YYSYMBOL_f_arg = 438,                    /* f_arg  */
  YYSYMBOL_f_label = 439,                  /* f_label  */
  YYSYMBOL_kwrest_mark = 440,              /* kwrest_mark  */
  YYSYMBOL_f_no_kwarg = 441,               /* f_no_kwarg  */
  YYSYMBOL_f_kwrest = 442,                 /* f_kwrest  */
  YYSYMBOL_restarg_mark = 443,             /* restarg_mark  */
  YYSYMBOL_f_rest_arg = 444,               /* f_rest_arg  */
  YYSYMBOL_blkarg_mark = 445,              /* blkarg_mark  */
  YYSYMBOL_f_block_arg = 446,              /* f_block_arg  */
  YYSYMBOL_opt_f_block_arg = 447,          /* opt_f_block_arg  */
  YYSYMBOL_value_expr_singleton_expr = 448, /* value_expr_singleton_expr  */
  YYSYMBOL_singleton = 449,                /* singleton  */
  YYSYMBOL_singleton_expr = 450,           /* singleton_expr  */
  YYSYMBOL_451_40 = 451,                   /* $@40  */
  YYSYMBOL_assoc_list = 452,               /* assoc_list  */
  YYSYMBOL_assocs = 453,                   /* assocs  */
  YYSYMBOL_assoc = 454,                    /* assoc  */
  YYSYMBOL_operation2 = 455,               /* operation2  */
  YYSYMBOL_operation3 = 456,               /* operation3  */
  YYSYMBOL_dot_or_colon = 457,             /* dot_or_colon  */
  YYSYMBOL_call_op = 458,                  /* call_op  */
  YYSYMBOL_call_op2 = 459,                 /* call_op2  */
  YYSYMBOL_rparen = 460,                   /* rparen  */
  YYSYMBOL_rbracket = 461,                 /* rbracket  */
  YYSYMBOL_rbrace = 462,                   /* rbrace  */
  YYSYMBOL_trailer = 463,                  /* trailer  */
  YYSYMBOL_term = 464,                     /* term  */
  YYSYMBOL_terms = 465,                    /* terms  */
  YYSYMBOL_none = 466                      /* none  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  143
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   16092

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  162
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  305
/* YYNRULES -- Number of rules.  */
#define YYNRULES  815
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1378

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   361


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,    72,
     154,    75,    73,    74,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,   161,   148,     2,     2,     2,   146,   141,     2,
     157,   158,   144,   142,   155,   143,    69,   145,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   136,   160,
     138,   134,   137,   135,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   153,    70,   159,   140,     2,   156,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   151,   139,   152,   149,     2,    89,    90,
      91,    92,    76,    77,    78,    79,    95,    96,    84,    83,
      80,    81,    82,    87,    88,    93,    94,    98,    85,    86,
      97,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    71,    99,   100,   101,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     147,   150
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  3166,  3160,  3166,  3166,  3166,  3166,  3186,  3191,  3196,
    3203,  3208,  3215,  3217,  3235,  3231,  3236,  3235,  3247,  3244,
    3257,  3262,  3267,  3274,  3276,  3275,  3285,  3287,  3294,  3294,
    3299,  3304,  3312,  3321,  3328,  3334,  3340,  3351,  3362,  3371,
    3385,  3386,  3391,  3391,  3392,  3403,  3408,  3409,  3416,  3416,
    3417,  3417,  3417,  3417,  3417,  3417,  3417,  3417,  3417,  3418,
    3418,  3418,  3421,  3422,  3428,  3428,  3428,  3435,  3436,  3443,
    3446,  3447,  3452,  3457,  3462,  3468,  3467,  3483,  3482,  3497,
    3500,  3511,  3521,  3520,  3534,  3534,  3535,  3541,  3541,  3541,
    3548,  3549,  3552,  3552,  3555,  3556,  3563,  3571,  3571,  3571,
    3578,  3585,  3594,  3599,  3604,  3609,  3614,  3620,  3626,  3632,
    3637,  3644,  3653,  3654,  3661,  3662,  3669,  3674,  3679,  3684,
    3684,  3684,  3689,  3694,  3699,  3704,  3709,  3714,  3721,  3722,
    3729,  3734,  3742,  3742,  3747,  3752,  3752,  3758,  3763,  3768,
    3773,  3781,  3781,  3786,  3791,  3791,  3796,  3801,  3806,  3811,
    3819,  3827,  3830,  3835,  3840,  3847,  3847,  3847,  3848,  3853,
    3856,  3861,  3864,  3869,  3869,  3877,  3878,  3879,  3880,  3881,
    3882,  3883,  3884,  3885,  3886,  3887,  3888,  3889,  3890,  3891,
    3892,  3893,  3894,  3895,  3896,  3897,  3898,  3899,  3900,  3901,
    3902,  3903,  3904,  3905,  3906,  3909,  3909,  3909,  3910,  3910,
    3911,  3911,  3911,  3912,  3912,  3912,  3912,  3913,  3913,  3913,
    3913,  3914,  3914,  3914,  3915,  3915,  3915,  3915,  3916,  3916,
    3916,  3916,  3917,  3917,  3917,  3917,  3918,  3918,  3918,  3918,
    3919,  3919,  3919,  3919,  3920,  3920,  3923,  3923,  3924,  3924,
    3924,  3924,  3924,  3924,  3924,  3924,  3924,  3925,  3925,  3925,
    3925,  3925,  3925,  3925,  3926,  3931,  3936,  3941,  3946,  3951,
    3956,  3961,  3966,  3971,  3976,  3981,  3986,  3991,  3992,  3997,
    4002,  4007,  4012,  4017,  4022,  4027,  4032,  4037,  4042,  4047,
    4054,  4054,  4054,  4055,  4056,  4059,  4068,  4069,  4075,  4082,
    4083,  4084,  4085,  4088,  4093,  4101,  4107,  4114,  4121,  4121,
    4124,  4125,  4126,  4131,  4138,  4143,  4152,  4157,  4167,  4179,
    4180,  4186,  4187,  4188,  4189,  4194,  4201,  4201,  4206,  4211,
    4216,  4222,  4228,  4232,  4232,  4270,  4275,  4283,  4288,  4296,
    4301,  4306,  4311,  4319,  4324,  4333,  4334,  4338,  4343,  4348,
    4366,  4366,  4366,  4366,  4366,  4366,  4366,  4366,  4367,  4368,
    4369,  4375,  4374,  4387,  4387,  4393,  4399,  4404,  4409,  4414,
    4420,  4425,  4430,  4435,  4440,  4447,  4452,  4457,  4462,  4463,
    4469,  4471,  4483,  4492,  4501,  4510,  4509,  4524,  4523,  4536,
    4544,  4544,  4545,  4589,  4588,  4611,  4610,  4630,  4629,  4648,
    4646,  4663,  4661,  4676,  4681,  4686,  4691,  4706,  4706,  4709,
    4716,  4734,  4741,  4749,  4757,  4764,  4772,  4781,  4790,  4798,
    4805,  4812,  4820,  4827,  4833,  4848,  4855,  4860,  4866,  4873,
    4880,  4881,  4882,  4885,  4886,  4889,  4891,  4900,  4901,  4908,
    4909,  4912,  4917,  4925,  4925,  4925,  4930,  4935,  4940,  4945,
    4952,  4958,  4965,  4966,  4973,  4973,  4975,  4975,  4975,  4975,
    4975,  4975,  4975,  4975,  4975,  4978,  4986,  4986,  4986,  4986,
    4986,  4986,  4991,  4996,  5001,  5006,  5011,  5017,  5022,  5027,
    5032,  5037,  5042,  5047,  5052,  5057,  5064,  5065,  5071,  5081,
    5085,  5088,  5093,  5100,  5102,  5106,  5111,  5114,  5120,  5125,
    5132,  5138,  5131,  5165,  5172,  5181,  5188,  5187,  5198,  5206,
    5218,  5228,  5234,  5239,  5247,  5254,  5265,  5271,  5276,  5282,
    5292,  5297,  5305,  5311,  5319,  5321,  5336,  5336,  5357,  5363,
    5368,  5374,  5382,  5391,  5392,  5395,  5396,  5398,  5411,  5418,
    5426,  5427,  5430,  5431,  5437,  5445,  5446,  5452,  5458,  5463,
    5468,  5475,  5478,  5485,  5489,  5488,  5501,  5504,  5511,  5518,
    5519,  5520,  5527,  5534,  5541,  5547,  5554,  5561,  5568,  5574,
    5579,  5584,  5591,  5590,  5601,  5607,  5615,  5621,  5626,  5631,
    5636,  5641,  5644,  5645,  5652,  5657,  5664,  5672,  5678,  5685,
    5686,  5693,  5700,  5705,  5710,  5715,  5722,  5724,  5731,  5737,
    5749,  5750,  5765,  5770,  5777,  5783,  5784,  5791,  5792,  5792,
    5792,  5792,  5792,  5792,  5792,  5793,  5794,  5795,  5798,  5798,
    5798,  5798,  5798,  5798,  5798,  5798,  5799,  5804,  5807,  5815,
    5827,  5834,  5841,  5846,  5851,  5859,  5879,  5882,  5887,  5891,
    5894,  5899,  5902,  5909,  5912,  5913,  5916,  5928,  5929,  5930,
    5937,  5950,  5962,  5969,  5969,  5969,  5969,  5973,  5977,  5984,
    5986,  5993,  5993,  5997,  6001,  6008,  6008,  6011,  6011,  6015,
    6019,  6027,  6031,  6039,  6043,  6051,  6055,  6063,  6067,  6093,
    6096,  6095,  6110,  6118,  6122,  6126,  6141,  6142,  6145,  6150,
    6153,  6154,  6157,  6173,  6174,  6177,  6185,  6186,  6194,  6195,
    6196,  6197,  6200,  6201,  6202,  6205,  6205,  6206,  6209,  6210,
    6211,  6212,  6213,  6214,  6215,  6218,  6228,  6235,  6235,  6242,
    6243,  6247,  6246,  6256,  6259,  6260,  6269,  6279,  6280,  6280,
    6297,  6297,  6297,  6297,  6297,  6297,  6297,  6297,  6297,  6298,
    6315,  6315,  6315,  6315,  6315,  6315,  6320,  6325,  6330,  6335,
    6340,  6345,  6350,  6355,  6360,  6365,  6370,  6375,  6380,  6386,
    6393,  6400,  6409,  6418,  6427,  6438,  6439,  6449,  6456,  6461,
    6480,  6482,  6493,  6513,  6514,  6517,  6523,  6529,  6537,  6538,
    6541,  6547,  6555,  6556,  6559,  6565,  6573,  6578,  6582,  6582,
    6612,  6614,  6613,  6626,  6627,  6634,  6636,  6661,  6666,  6671,
    6678,  6684,  6689,  6702,  6702,  6702,  6703,  6706,  6707,  6708,
    6711,  6712,  6715,  6716,  6719,  6720,  6723,  6726,  6729,  6732,
    6733,  6736,  6744,  6751,  6752,  6756
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end-of-input\"", "error", "\"invalid token\"", "\"'class'\"",
  "\"'module'\"", "\"'def'\"", "\"'undef'\"", "\"'begin'\"",
  "\"'rescue'\"", "\"'ensure'\"", "\"'end'\"", "\"'if'\"", "\"'unless'\"",
  "\"'then'\"", "\"'elsif'\"", "\"'else'\"", "\"'case'\"", "\"'when'\"",
  "\"'while'\"", "\"'until'\"", "\"'for'\"", "\"'break'\"", "\"'next'\"",
  "\"'redo'\"", "\"'retry'\"", "\"'in'\"", "\"'do'\"",
  "\"'do' for condition\"", "\"'do' for block\"", "\"'do' for lambda\"",
  "\"'return'\"", "\"'yield'\"", "\"'super'\"", "\"'self'\"", "\"'nil'\"",
  "\"'true'\"", "\"'false'\"", "\"'and'\"", "\"'or'\"", "\"'not'\"",
  "\"'if' modifier\"", "\"'unless' modifier\"", "\"'while' modifier\"",
  "\"'until' modifier\"", "\"'rescue' modifier\"", "\"'alias'\"",
  "\"'defined?'\"", "\"'BEGIN'\"", "\"'END'\"", "\"'__LINE__'\"",
  "\"'__FILE__'\"", "\"'__ENCODING__'\"", "\"local variable or method\"",
  "\"method\"", "\"global variable\"", "\"instance variable\"",
  "\"constant\"", "\"class variable\"", "\"label\"", "\"integer literal\"",
  "\"float literal\"", "\"rational literal\"", "\"imaginary literal\"",
  "\"char literal\"", "\"numbered reference\"", "\"back reference\"",
  "\"literal content\"", "tREGEXP_END", "\"dummy end\"", "'.'",
  "\"backslash\"", "\"escaped space\"", "\"escaped horizontal tab\"",
  "\"escaped form feed\"", "\"escaped carriage return\"",
  "\"escaped vertical tab\"", "\"unary+\"", "\"unary-\"", "\"**\"",
  "\"<=>\"", "\"==\"", "\"===\"", "\"!=\"", "\">=\"", "\"<=\"", "\"&&\"",
  "\"||\"", "\"=~\"", "\"!~\"", "\"..\"", "\"...\"", "\"(..\"", "\"(...\"",
  "\"[]\"", "\"[]=\"", "\"<<\"", "\">>\"", "\"&.\"", "\"::\"",
  "\":: at EXPR_BEG\"", "\"operator-assignment\"", "\"=>\"", "\"(\"",
  "\"( arg\"", "\"[\"", "\"{\"", "\"{ arg\"", "\"*\"", "\"**arg\"",
  "\"&\"", "\"->\"", "\"symbol literal\"", "\"string literal\"",
  "\"backtick literal\"", "\"regexp literal\"", "\"word list\"",
  "\"verbatim word list\"", "\"symbol list\"", "\"verbatim symbol list\"",
  "\"terminator\"", "\"'}'\"", "\"'#{'\"", "tSTRING_DVAR", "tLAMBEG",
  "tLABEL_END", "tIGNORED_NL", "tCOMMENT", "tEMBDOC_BEG", "tEMBDOC",
  "tEMBDOC_END", "tHEREDOC_BEG", "tHEREDOC_END", "k__END__", "tLOWEST",
  "'='", "'?'", "':'", "'>'", "'<'", "'|'", "'^'", "'&'", "'+'", "'-'",
  "'*'", "'/'", "'%'", "tUMINUS_NUM", "'!'", "'~'", "tLAST_TOKEN", "'{'",
  "'}'", "'['", "'\\n'", "','", "'`'", "'('", "')'", "']'", "';'", "' '",
  "$accept", "option_terms", "compstmt_top_stmts", "$@1", "program",
  "top_stmts", "top_stmt", "block_open", "begin_block", "compstmt_stmts",
  "$@2", "$@3", "bodystmt", "$@4", "stmts", "stmt_or_begin", "$@5",
  "allow_exits", "k_END", "$@6", "stmt", "asgn_mrhs", "asgn_command_rhs",
  "command_asgn", "op_asgn_command_rhs",
  "def_endless_method_endless_command", "endless_command", "option_'\\n'",
  "command_rhs", "expr", "$@7", "$@8", "def_name", "defn_head", "$@9",
  "defs_head", "value_expr_expr", "expr_value", "$@10", "$@11",
  "expr_value_do", "command_call", "value_expr_command_call",
  "command_call_value", "block_command", "cmd_brace_block", "fcall",
  "command", "mlhs", "mlhs_inner", "mlhs_basic", "mlhs_items_mlhs_item",
  "mlhs_item", "mlhs_head", "mlhs_node", "lhs", "cname", "cpath", "fname",
  "fitem", "undef_list", "$@12", "op", "reswords", "asgn_arg_rhs", "arg",
  "op_asgn_arg_rhs", "range_expr_arg", "def_endless_method_endless_arg",
  "ternary", "endless_arg", "relop", "rel_expr", "lex_ctxt",
  "begin_defined", "after_rescue", "value_expr_arg", "arg_value",
  "aref_args", "arg_rhs", "paren_args", "opt_paren_args", "opt_call_args",
  "value_expr_command", "call_args", "$@13", "command_args", "block_arg",
  "opt_block_arg", "args", "arg_splat", "mrhs_arg", "mrhs", "primary",
  "$@14", "$@15", "@16", "@17", "$@18", "$@19", "$@20", "$@21", "$@22",
  "$@23", "$@24", "value_expr_primary", "primary_value", "k_begin", "k_if",
  "k_unless", "k_while", "k_until", "k_case", "k_for", "k_class",
  "k_module", "k_def", "k_do", "k_do_block", "k_rescue", "k_ensure",
  "k_when", "k_else", "k_elsif", "k_end", "k_return", "k_yield", "then",
  "do", "if_tail", "opt_else", "for_var", "f_marg", "mlhs_items_f_marg",
  "f_margs", "f_rest_marg", "f_any_kwrest", "$@25", "f_eq",
  "f_kw_primary_value", "f_kwarg_primary_value",
  "args_tail_basic_primary_value", "block_args_tail", "excessed_comma",
  "f_opt_primary_value", "f_opt_arg_primary_value",
  "opt_args_tail_block_args_tail", "block_param", "opt_block_param_def",
  "block_param_def", "opt_block_param", "opt_bv_decl", "bv_decls", "bvar",
  "max_numparam", "numparam", "it_id", "@26", "$@27", "lambda",
  "f_larglist", "lambda_body", "$@28", "do_block", "block_call",
  "method_call", "brace_block", "@29", "brace_body", "@30", "do_body",
  "case_args", "case_body", "cases", "p_pvtbl", "p_pktbl", "p_in_kwarg",
  "$@31", "p_case_body", "p_cases", "p_top_expr", "p_top_expr_body",
  "p_expr", "p_as", "$@32", "p_alt", "p_lparen", "p_lbracket",
  "p_expr_basic", "$@33", "p_args", "p_args_head", "p_args_tail", "p_find",
  "p_rest", "p_args_post", "p_arg", "p_kwargs", "p_kwarg", "p_kw",
  "p_kw_label", "p_kwrest", "p_kwnorest", "p_any_kwrest", "p_value",
  "range_expr_p_primitive", "p_primitive", "p_variable", "p_var_ref",
  "p_expr_ref", "p_const", "opt_rescue", "exc_list", "exc_var",
  "opt_ensure", "literal", "strings", "string", "string1", "xstring",
  "regexp", "nonempty_list_' '", "words_tWORDS_BEG_word_list", "words",
  "word_list", "word", "words_tSYMBOLS_BEG_symbol_list", "symbols",
  "symbol_list", "words_tQWORDS_BEG_qword_list", "qwords",
  "words_tQSYMBOLS_BEG_qsym_list", "qsymbols", "qword_list", "qsym_list",
  "string_contents", "xstring_contents", "regexp_contents",
  "string_content", "@34", "@35", "@36", "@37", "string_dend",
  "string_dvar", "symbol", "ssym", "sym", "dsym", "numeric",
  "simple_numeric", "nonlocal_var", "user_variable", "keyword_variable",
  "var_ref", "var_lhs", "backref", "$@38", "superclass",
  "f_opt_paren_args", "f_paren_args", "f_arglist", "@39", "f_kw_arg_value",
  "f_kwarg_arg_value", "args_tail_basic_arg_value", "args_tail",
  "f_opt_arg_value", "f_opt_arg_arg_value", "opt_args_tail_args_tail",
  "f_args", "args_forward", "f_bad_arg", "f_norm_arg", "f_arg_asgn",
  "f_arg_item", "f_arg", "f_label", "kwrest_mark", "f_no_kwarg",
  "f_kwrest", "restarg_mark", "f_rest_arg", "blkarg_mark", "f_block_arg",
  "opt_f_block_arg", "value_expr_singleton_expr", "singleton",
  "singleton_expr", "$@40", "assoc_list", "assocs", "assoc", "operation2",
  "operation3", "dot_or_colon", "call_op", "call_op2", "rparen",
  "rbracket", "rbrace", "trailer", "term", "terms", "none", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-1154)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-816)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -1154,  5861,   140, -1154, -1154, -1154, -1154, 10474, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, 11529, 11529, -1154, -1154, -1154,
   -1154,  6763, -1154, -1154, -1154, -1154,   479, 10320,    -9,    31,
   -1154, -1154, -1154, -1154,  6139,  6919, -1154, -1154,  6295, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, 13089, 13089, 13089,
   13089,   133,  9233,  9391, 12009, 12249, 10775, -1154, 10166, -1154,
   -1154, -1154,    43,    43,    43,    43,  1177, 13209, 13089, -1154,
     236, -1154, -1154,  1304, -1154, -1154, -1154, -1154, -1154,   894,
     318,   318, -1154, -1154,   110,   181,   123, -1154,    79, 13809,
   -1154,   249, -1154,  1945, -1154, -1154, -1154, -1154,   896,   448,
   -1154,   598, -1154, 11409, 11409, -1154, -1154,  9853, 13927, 14045,
   14163, 10011, 11529,  7387, -1154,   737,    70, -1154, -1154,   324,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154,    81,   503, -1154,
     231,   528, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
     292, -1154, -1154, -1154, -1154, -1154, -1154,   315, 13089,   462,
    9391, 13089, 13089, 13089, -1154, 13089, -1154, -1154,   389,  4606,
   -1154,   480, -1154, -1154, -1154,   408, -1154,   607,    44,    80,
     500,   244,   469, -1154, -1154, 11649, -1154, 11529, -1154, -1154,
   11150, 13329,   779, -1154,   438, -1154,  9549, -1154, -1154, -1154,
   -1154, -1154,   460,   318,   318,   110, -1154,   665, -1154,   511,
     633,  4706,  4706,   703, -1154,  9233,   580,   236, -1154,  1304,
      -9,   613, -1154, -1154,   591,   818,   851, -1154,   480,   604,
     851, -1154,    -9,   715,  1177, 14281,   634,   634,   670, -1154,
     726,   777,   797,   807, -1154, -1154,   732, -1154, -1154,  1132,
    1147,   678, -1154,   686,   686,   686,   686,   761, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154,  6013,   734, 11409, 11409, 11409,
   11409, -1154, 13329, 13329,  1810,   753,   762, -1154,  1810, -1154,
     766, -1154, -1154, -1154, -1154,   806, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154,  9233, 10893,   764, -1154, -1154, 13089, 13089,
   13089, 13089, 13089, -1154, -1154, 13089, 13089, 13089, 13089, 13089,
   13089, 13089, 13089, -1154, 13089, -1154, -1154, 13089, 13089, 13089,
   13089, 13089, 13089, 13089, 13089, 13089, 13089, -1154, -1154,  3522,
   11529,  4301,   460,  8169, -1154,   894, -1154,   214,   214, 11409,
    9081,  9081, -1154,   236,   774,   868, -1154, -1154,   854,   916,
      93,    97,   121,   711,   758, 11409,   296, -1154,   809,   866,
   -1154, -1154, -1154, -1154,    73,   114,   461,   625,   637,   656,
     677,   738,   769, -1154, -1154, -1154, -1154, -1154,   772, -1154,
   -1154, 11011, -1154, -1154, -1154,  2213, -1154, -1154, -1154, -1154,
   -1154, -1154,   316, -1154, -1154, -1154,   707, -1154, 13089, 11769,
   -1154, -1154, 14662, 11529, 14760, -1154, -1154, 12129, -1154, 13089,
      -9, -1154,   801,    -9,   803, -1154, -1154,   823,   170, -1154,
   -1154, -1154, -1154, -1154, 10474, -1154, -1154, 13089,   813,   827,
     849, 14858, 14760, -1154,    31,    -9, -1154, -1154,  5468,   840,
     845, -1154, 12009, -1154, -1154, 12249, -1154, -1154, -1154,   438,
     870, -1154,   853, -1154, -1154, 14281, 14956, 11529, 15054, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154,  1153,   103,  1221,   293, 13089, -1154, -1154,  9701, -1154,
   -1154, -1154, -1154, -1154, 11289, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154,  1349, -1154, -1154, -1154, -1154,
   -1154,   855, -1154, -1154,   861, -1154, -1154, -1154,   865,    -9,
   -1154, -1154, -1154,   903, -1154,   873, 13089,   288, -1154, -1154,
     970,   875,   996, -1154, 13449,  8169,   236, 13449,  8169, -1154,
     898, -1154, -1154, -1154,   138,   138, 12369,    -9, 14281,   897,
   -1154, 12489, -1154,   633,  4788,  4788,  4788,  4788,  5010,  3762,
    4788,  4788,  4706,  4706,   572,   572, -1154,  4380,  1239,  1239,
    1283,   430,   430,   633,   633,   633,   965,   965,  7543,  6451,
    7855,  6607,   460, -1154,    -9,   904,   765, -1154,   783, -1154,
    7075, -1154, -1154,   138, -1154,  8321,  1051,  8777,   197,   138,
     138,  1050,  1044,   126, 15152, 11529, 15250, -1154, -1154, -1154,
     870, -1154, -1154, -1154, -1154, 15348, 11529, 15446,  8169, 13329,
   -1154, -1154, -1154,    -9, -1154, -1154, -1154, -1154,  3914, 13569,
   13569, 10474, -1154, 13089, 13089, -1154,   480, -1154, -1154,   469,
    5159,  7231,    -9,   328,   351, 13089, 13089, -1154, -1154, 11889,
   -1154, 12129, -1154, -1154, -1154, 13329,  4606, -1154, 13689, 13689,
      84,   460,   460, 13569, -1154,   552, -1154, -1154,   851, 14281,
     853,   477,   436,    -9,    92,   322, -1154, -1154,  1067, -1154,
     360, -1154,    43, -1154, -1154,   360,    43, -1154,   633,   919,
   -1154,  1349,  1441, -1154,   929,    -9,   933, -1154,   429, -1154,
   -1154,   349, -1154,  1810, -1154, -1154,   966, 13089,  1810, -1154,
   -1154, -1154, -1154, -1154,  1360, -1154, -1154,   479,  1055, -1154,
    4606,  1057,   138, -1154,  1055,  1057,   138, -1154, -1154,   960,
   -1154, -1154, -1154, -1154, -1154, 13089, -1154, -1154, -1154,   958,
     961,  1075, -1154, -1154,   853, 14281,  1064, -1154, -1154,  1084,
     995,  1604, -1154, -1154, -1154,   888,   450, -1154, -1154,  1000,
   -1154, -1154, -1154, -1154,   806,   982,   837, 11769, -1154, -1154,
   -1154, -1154,   806, -1154,  1142, -1154,  1010, -1154,  1144, -1154,
   -1154, -1154, -1154, -1154, -1154, 12609,   138, -1154,  1050,   138,
     134,   151,    -9,   150,   166, 11409,   236, 11409,  8169,   791,
     436, -1154,    -9,   138,   170, 10628, -1154,    70,   181, -1154,
    3321, -1154, -1154, -1154, -1154, 13089, -1154, -1154, -1154, -1154,
     456, -1154, -1154,    -9,  1007,   170,   479, -1154, -1154, -1154,
   -1154,   647, -1154, -1154, -1154, -1154, -1154,   686, -1154,   686,
     686,   686, -1154,    -9, -1154,  1349, -1154,  1451, -1154, -1154,
    1105,   855, -1154, -1154,  1011,  1020, -1154, -1154,  1021, -1154,
    1022, -1154,  1011, 13449, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154,  1027, 12729, -1154,   853,   508, -1154, -1154, -1154, 15544,
   11529, 15642, -1154, -1154, 13089, 13569, 13569,  1013, -1154, -1154,
   -1154, 13569, 13569, -1154, -1154, 12849,  1144, -1154, -1154, -1154,
    9081, 11409,   138, -1154, -1154,   138, -1154, 13089, -1154,   100,
   -1154, -1154,   138, -1154,   168,   197,  8169,   236,   138, -1154,
   -1154, -1154, -1154, -1154, -1154, 13089, 13089, -1154, 13089, 13089,
   -1154, 12129, -1154, 13689,  1680,  5709, -1154, -1154,  1030,  1035,
   -1154,  1360, -1154,  1360, -1154,  1810, -1154,  1360, -1154, -1154,
    1055,  1057, 13089, 13089, -1154, -1154, 13089,  1037, 11289, 11289,
   13569, 13089,  7699,  8011,    -9,   526,   619,  4514,  4514,  4606,
   -1154, -1154, -1154, -1154, -1154, 13569, -1154, -1154, -1154, -1154,
     958, -1154,  1093, -1154,  1187, -1154, -1154,   214, -1154, -1154,
   -1154, 12969,  8473, -1154, -1154, -1154,   138, -1154, -1154, 13089,
    1810, -1154, -1154,   115,  1451,  1451,  1011,  1011,  1045,  1011,
    4606,  4606,  1060,  1060,  1027, -1154, -1154,  4606,   627, -1154,
   -1154, -1154,  2841,  2841,   571, -1154,  4211,   489,  1149, -1154,
    1423, -1154, -1154,    56, -1154,  1065, -1154, -1154, -1154,  1054,
   -1154,  1059, -1154, 14590, -1154, -1154, -1154, -1154, -1154,   973,
   -1154, -1154, -1154,   453, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154,   440, -1154, -1154, -1154, 14399,   214, -1154,
   -1154,  9081, -1154, -1154,  8929,  8321, 13089, -1154,   749,  4514,
    9081, -1154,    -9,   108, -1154, -1154, -1154,  1035, -1154, -1154,
    1360, -1154, -1154,  1993,  9701, -1154, -1154,  8169, -1154, -1154,
   -1154, -1154, 14590,    65,    -9,  5289, -1154,    -9,  1062, -1154,
    1058, -1154, -1154, -1154,  1048, -1154, 11409, -1154,  1154,  5289,
   -1154, 14590,   971,  1117,  2841,  2841,   571,   -16,   691,  4514,
    4514, -1154,  1167, -1154,   901,   219,   289,   294,  8169,   236,
   -1154,  1010, -1154, -1154, -1154, -1154,   214,  1033,   138,  1072,
    1066, -1154,  9701, -1154,  1011,   855, -1154,  1087, -1154, -1154,
   -1154,  1090, -1154,    -9,   903,  1095, 14517,  1102, -1154, -1154,
   -1154,   281, -1154,  1117,  1106,  1107, -1154, -1154, -1154, -1154,
   -1154,    -9, -1154, -1154,  1108, 14590,  1109, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,    -9,    -9,
      -9,    -9,    -9,    -9,   372, 15740, 11529, 15838,  1142, -1154,
    1187, -1154, -1154, 11409, 11409, -1154,  1481, -1154,  8169,  1115,
   -1154, -1154,   349, -1154,  1993, -1154,  1088, 14517,  1993, -1154,
   -1154,  1214,   915,  1518, -1154, -1154, 14590, -1154,   971, -1154,
   14590, -1154,  5289,   867, -1154, -1154, -1154, -1154, -1154, -1154,
     251,   284,    -9,   418,   432, -1154, -1154,  8625, -1154, -1154,
   -1154,   923, -1154, -1154,   138, -1154, -1154,   855, -1154, -1154,
    1121,  1123, -1154,   915,  1128,  1130, -1154, 15936,  1121,  1134,
      -9,  1134, -1154, -1154,   442,   495,  1481, -1154, -1154, -1154,
    1518, -1154,  1518, -1154,  1993, -1154,  1518, -1154,  1133,  1136,
   -1154, 14590, -1154, -1154, -1154, -1154, -1154,  1121,  1121,  1139,
    1121, -1154, -1154,  1518, -1154, -1154,  1121, -1154
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     0,    47,   406,   407,   408,     0,   399,   400,
     401,   404,    26,    26,    26,   393,   394,   395,   396,   418,
     419,   323,   699,   698,   700,   701,    64,     0,    64,     0,
     815,   703,   702,   704,    97,    99,   693,   692,    98,   694,
     688,   689,   690,   691,   637,   709,   710,     0,     0,     0,
       0,     0,     0,     0,   815,   815,   126,   490,   663,   663,
     665,   667,     0,     0,     0,     0,     0,     0,     0,     6,
       3,     8,    26,    10,    43,    49,    40,    58,    61,    46,
     718,   718,    70,    91,   323,    90,     0,   112,     0,   116,
     128,     0,   237,    79,   246,   253,   282,   283,   267,   284,
     398,     0,   351,     0,     0,    87,    87,     0,     0,     0,
       0,     0,   360,   323,   370,    94,   368,   340,   341,   636,
     638,   342,   343,   646,   344,   652,   346,   656,   345,   658,
     347,   635,   680,   681,   634,   686,   697,   705,   706,   348,
       0,   349,     7,     1,   205,   216,   206,   229,   202,   222,
     212,   211,   232,   233,   227,   210,   209,   204,   230,   234,
     235,   214,   203,   217,   221,   223,   215,   208,   224,   231,
     226,   225,   218,   228,   213,   201,   220,   219,   200,   207,
     198,   199,   195,   196,   197,   155,   157,   156,   190,   191,
     186,   168,   169,   170,   177,   174,   176,   171,   172,   192,
     193,   178,   179,   183,   187,   173,   175,   165,   166,   167,
     180,   181,   182,   184,   185,   188,   189,   194,   160,   162,
      33,   158,   159,   161,   402,   403,   405,     0,   789,     0,
       0,   334,   792,   326,   663,     0,   318,   316,     0,   298,
     299,   329,   317,   110,   322,   815,   330,     0,   705,   706,
       0,   349,   815,   785,   111,   815,   509,     0,   107,    65,
      64,     0,     0,    28,   815,    12,     0,    11,    27,   295,
     393,   394,   510,   718,   718,     0,   261,     0,   360,   363,
     262,   251,   252,   357,    24,     0,     0,     3,    21,    23,
      64,   114,    20,   353,     0,    64,    64,   300,     0,     0,
      64,   783,    64,     0,     0,     0,   718,   718,   124,   397,
       0,   132,   133,   140,   487,   683,     0,   682,   684,     0,
       0,     0,   643,   647,   659,   653,   661,   687,    74,   273,
     274,   812,   811,     5,   813,     0,     0,     0,     0,     0,
       0,   815,     0,     0,   749,     0,   717,   389,   749,   715,
       0,   391,   409,   514,   504,   100,   516,   367,   410,   516,
     499,   815,   130,     0,   122,   117,   815,    77,     0,     0,
       0,     0,     0,   291,   292,     0,     0,     0,     0,   249,
     250,     0,     0,    75,     0,   289,   290,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   802,   803,   805,
     815,   804,     0,     0,    86,    84,    85,     0,     0,     0,
       0,     0,   377,     3,     4,     0,   430,   429,     0,     0,
     705,   706,   349,   150,   151,     0,     0,   153,   815,     0,
     705,   706,   349,   387,   225,   218,   228,   213,   195,   196,
     197,   155,   156,   781,    81,    80,   780,   779,     0,   778,
     109,    64,   108,   805,   804,     0,   369,   639,   815,   815,
     163,   788,   357,   333,   791,   325,     0,   815,     0,     0,
     319,   328,   805,   815,   804,   815,   815,     0,   320,   750,
      64,   312,   815,    64,   815,   311,   324,     0,    64,   366,
      73,    30,    32,    31,     0,   815,   296,     0,     0,     0,
       0,   805,   804,   815,     0,    64,   355,    14,     0,   113,
       0,   358,   810,   809,   301,   810,   303,   359,   784,     0,
     139,   687,   127,   119,   717,     0,   805,   815,   804,   488,
     669,   685,   672,   670,   664,   640,   641,   666,   642,   668,
     644,     0,     0,     0,     0,     0,   814,     9,     0,    34,
      35,    36,    37,   297,     0,    71,    72,   756,   753,   752,
     751,   754,   762,   763,   750,     0,   769,   764,   773,   772,
     768,   815,   765,   722,   815,   728,   748,   731,   734,    64,
     729,   755,   757,   758,   760,   734,   721,   767,   443,   442,
     771,   734,   775,   727,     0,     0,     0,     0,     0,   487,
       0,   514,   101,   487,     0,     0,     0,    64,     0,   118,
     131,     0,   527,   259,   266,   268,   269,   270,   277,   278,
     271,   272,   247,   248,   275,   276,   527,    64,   263,   264,
     265,   254,   255,   256,   257,   258,   293,   294,   793,   795,
     794,   796,   323,   507,    64,   815,   793,   795,   794,   796,
     323,   508,   815,     0,   421,     0,   420,     0,     0,     0,
       0,     0,   375,   357,   805,   815,   804,   380,   385,   150,
     151,   152,   711,   383,   713,   805,   815,   804,     0,     0,
     800,   801,    82,    64,   362,   793,   794,   503,   323,     0,
       0,     0,   815,     0,     0,   787,   331,   327,   332,   815,
     793,   794,    64,   793,   794,     0,     0,   786,   306,   313,
     308,   315,   806,   365,    29,     0,   279,    13,     0,     0,
     356,     0,   815,     0,    25,   115,    22,   354,    64,     0,
     125,   797,   138,    64,   793,   794,   489,   673,     0,   645,
       0,   649,     0,   655,   651,     0,     0,   657,   260,     0,
      38,     0,   441,   433,   435,    64,   438,   431,     0,   726,
     777,     0,   725,     0,   744,   716,     0,     0,     0,   741,
     720,   594,   766,   770,     0,   746,   774,    64,    59,    62,
     286,   280,     0,   719,    60,   281,     0,   488,   512,     0,
     488,   416,   417,   513,   498,   334,    92,    93,    41,   336,
       0,    45,   335,   129,   123,     0,     0,    69,    48,    67,
       0,   304,   329,   236,    42,     0,   349,   525,   525,     0,
     815,   815,   514,   506,   104,     0,   511,   313,   815,   815,
     310,   505,   102,   309,   815,   352,   815,   422,   815,   424,
      88,   423,   373,   374,   413,     0,     0,   527,     0,     0,
     797,   356,    64,   793,   794,     0,     0,     0,     0,   150,
     151,   154,    64,     0,    64,     0,   361,   500,    95,    50,
     304,   238,    57,   245,   164,     0,   790,   321,   815,   815,
     511,   815,   815,    64,   815,    64,    64,    56,   244,   302,
     120,   511,    26,   674,   671,   678,   679,   648,   650,   660,
     654,   662,    39,    64,   440,     0,   759,     0,   776,   723,
     767,   815,   733,   732,   734,   734,   445,   730,   734,   761,
     734,   758,   734,     0,   815,   815,   390,   392,   489,    96,
     489,   339,     0,   815,   121,   357,   815,   815,   815,   805,
     815,   804,   526,   526,     0,     0,     0,     0,   105,   807,
     815,     0,     0,   103,   411,   815,    18,   626,   415,   414,
       0,     0,     0,   425,   427,     0,    89,     0,   518,     0,
     378,   525,     0,   379,   511,     0,     0,     0,     0,   511,
     388,   782,    83,   501,   502,     0,     0,   815,     0,     0,
     307,   314,   364,     0,   749,     0,   432,   434,   436,   439,
     724,     0,   745,     0,   742,     0,   737,     0,   739,   747,
      66,   288,     0,     0,    26,    26,   334,   337,     0,     0,
       0,     0,   793,   794,    64,   793,   794,     0,     0,   285,
      54,   242,    55,   243,   106,     0,    52,   240,    53,   241,
     627,   628,   815,   629,   815,    15,   428,     0,   371,   372,
     519,     0,     0,   526,   376,   381,     0,   712,   384,     0,
     749,   491,   494,     0,     0,     0,   734,   734,   734,   734,
      63,   287,   815,   815,   338,    44,    68,   305,   511,   618,
     624,   590,     0,     0,     0,   526,    64,   526,   578,   663,
       0,   617,    78,   535,   541,   543,   546,   539,   538,   574,
     540,   583,   586,   589,   595,   596,   585,   549,   604,   597,
     550,   605,   606,   607,   608,   609,   610,   611,   612,   614,
     613,   615,   616,   593,    76,    51,   239,     0,     0,   631,
     412,     0,    19,   633,     0,     0,     0,   520,   815,     0,
       0,   386,    64,     0,   677,   676,   675,   437,   743,   738,
       0,   735,   740,   479,     0,   477,   476,     0,   602,   603,
     151,   622,     0,   566,    64,   567,   571,    64,     0,   561,
       0,   815,   564,   577,     0,   619,     0,   620,     0,   536,
     544,     0,   584,   588,   600,   601,     0,   526,   526,     0,
       0,   592,     0,   630,     0,   705,   706,   349,     0,     3,
      16,   815,   521,   523,   524,   522,     0,   532,     0,   481,
       0,   496,     0,   492,   734,   815,   448,   815,   454,   475,
     457,   460,   480,    64,   758,   460,   447,   460,   453,   515,
     517,    64,   559,   581,   569,   568,   560,   572,   808,   562,
     591,    64,   542,   537,   574,     0,   575,   579,   663,   587,
     582,   598,   599,   623,   548,   558,   547,   554,    64,    64,
      64,    64,    64,    64,   357,   805,   815,   804,   815,   632,
     815,   426,   528,     0,     0,   382,     0,   493,     0,     0,
     736,   452,     0,   451,     0,   471,     0,     0,   455,   466,
     468,     0,   446,     0,   473,   565,     0,   573,     0,   621,
       0,   545,     0,     0,   551,   552,   553,   555,   556,   557,
     797,   356,    64,   793,   794,   625,    17,     0,   533,   534,
     485,    64,   483,   486,     0,   495,   449,   815,   459,   458,
     460,   460,   478,   456,   460,   460,   357,   805,   460,   570,
      64,   575,   576,   580,   511,   815,     0,   482,   497,   450,
       0,   472,     0,   469,     0,   463,     0,   465,   797,   356,
     474,     0,   563,   530,   531,   529,   484,   460,   460,   460,
     460,   470,   464,     0,   461,   467,   460,   462
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1154,  -102,  1031, -1154, -1154, -1154,   963, -1154,   792,   -17,
   -1154, -1154,  -539, -1154,   174,   798, -1154,     0, -1154, -1154,
      26, -1154, -1154,   -24, -1154,    15,  -552,   169,  -565,  -100,
   -1154, -1154,   443,  2573, -1154,  3086, -1154,   -25, -1154, -1154,
    1201,   -38, -1154,   706, -1154,  -659,  1206,    22,  1207,  -169,
      35,  -445,   -72, -1154,     2,  3822,  -400,  1204,   -46,     6,
   -1154, -1154,    12, -1154, -1154,  4667, -1154, -1154, -1154, -1154,
    -547,  1222, -1154,   899,   824,   222, -1154,  1002, -1154,   497,
      28,   639,  -375, -1154,    88, -1154,    13,  -393,  -231,    38,
    -423, -1154,  -567,   -47, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154,   986, -1154, -1154, -1154,
   -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154, -1154,
   -1154, -1154,   366, -1154,  -443,  1837,  2057,  -386,   355,   131,
    -797, -1154,  -794,  -801,   586,   433,  -955, -1154,   127,    57,
   -1154, -1154,   199, -1154, -1153,    66,   336, -1154,   282, -1154,
   -1154,   139, -1154,    17,   260,   -58,   -88, -1154, -1154,   337,
   -1154, -1154, -1154,   499, -1154, -1154,  -115, -1154,  -528, -1154,
    1009, -1154,  -773, -1154,  -698,  -755,  -521, -1154,    24, -1154,
   -1154,  -909,  -213, -1154, -1154, -1154, -1154, -1154,   125, -1154,
    -143, -1154,  -636,  -750, -1024,  -390, -1051, -1036, -1154,   189,
   -1154, -1154,  -568,   191, -1154, -1154,  -555,   198, -1154, -1154,
   -1154,   109, -1154, -1154,   117,  1029,  1459, -1154,  1269,  1564,
    1759,    37, -1154,  1883, -1154,   847, -1154,  1968, -1154, -1154,
    2174, -1154,  2208, -1154, -1154,   -57, -1154, -1154,  -188, -1154,
   -1154, -1154, -1154, -1154, -1154,    50, -1154, -1154, -1154, -1154,
      33,   -50,  3681,    -1,  1280,  3945,  3453, -1154, -1154,     9,
     785,    68, -1154,   632, -1154, -1154,  -301,  -677,   630,  -421,
    -320,  -184, -1141,  -549,  -284,  -745,  -584,  -472,  -678, -1154,
    -727, -1154,  -576, -1154,  -562,  -542, -1154, -1154, -1154, -1154,
   -1154,   113,  -437,  -381, -1154, -1154,   -91,  1284,  -116,    41,
      60,  -215,   -59,   -64,    14
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,   333,    69,     1,     2,    70,    71,   266,   267,   652,
    1134,  1270,   653,  1044,   287,   288,   504,   224,    72,   494,
     289,    74,    75,    76,    77,    78,   778,   487,   808,    79,
     626,   612,   444,   273,   865,   274,   406,   407,   409,   966,
     410,    82,   797,   809,    83,   602,   275,    85,    86,   290,
      87,   522,    88,    89,    90,   238,   427,   428,   218,   219,
     220,   691,   641,   222,    92,    93,    94,    95,    96,    97,
     781,   395,    98,   553,   497,   554,   240,   241,   294,   813,
     830,   831,   480,   242,   481,   257,   258,   244,   470,   645,
     246,   801,   802,    99,   403,   510,   848,   661,   855,  1140,
     858,   856,   678,   595,   598,   100,   277,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   356,   359,   955,
    1131,   845,   960,   961,   793,   278,   279,   655,   840,   962,
     963,   419,   753,   754,   755,   756,   571,   766,   767,  1216,
    1217,  1218,  1328,  1289,  1220,  1221,  1285,  1222,  1154,  1155,
    1223,  1210,  1321,  1322,   529,   736,   892,   314,  1143,   114,
    1061,  1213,  1278,   360,   115,   116,   357,   599,   600,   603,
     604,   969,   846,  1205,   942,  1027,   817,  1317,   849,  1365,
    1206,  1092,  1233,  1094,  1245,  1095,  1189,  1190,  1096,  1298,
    1164,  1165,  1166,  1098,  1099,  1246,  1168,  1100,  1101,  1102,
    1103,  1104,   572,  1106,  1107,  1108,  1109,  1110,  1111,  1112,
    1113,   956,  1042,  1128,  1132,   117,   118,   119,   120,   121,
     122,   323,   123,   124,   541,   740,   125,   126,   543,   127,
     128,   129,   130,   542,   544,   316,   320,   321,   534,   738,
     737,   893,   995,  1146,   894,   131,   132,   317,   133,   134,
     135,   136,   248,   249,   139,   250,   251,   857,   673,   345,
     346,   347,   348,   573,   574,   575,   912,   577,   578,   764,
     579,   580,   581,   582,   921,   584,   585,   586,   587,   588,
     589,   590,   591,   592,   593,   759,   447,   448,   449,   679,
     299,   484,   253,   721,   643,   682,   677,   402,   489,   826,
    1172,   514,   656,   414,   269
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     138,   456,   319,   405,   405,   412,   335,   405,   318,   309,
     401,   334,   315,   225,   226,   142,   757,   365,   642,   221,
     650,   478,   657,   919,   454,   644,   671,    73,   596,   328,
     236,   236,   762,   263,   911,   286,   293,   237,   237,   221,
     707,   965,   309,   576,   814,   784,   698,   576,   334,   256,
     785,   138,   138,   245,   245,   312,   782,   223,   308,   786,
     583,   309,   309,   309,   583,   445,   292,   292,   297,   301,
     221,   483,   336,   789,   688,   972,   697,   223,   707,   408,
     730,   516,   413,   910,   697,   518,   913,   291,   312,   698,
     350,   642,   295,   650,   349,   349,   352,   355,   702,   327,
     324,   325,   326,   243,   254,   818,   999,   421,   431,   431,
     431,   997,   354,   654,  1235,  1144,   505,  -135,  -141,  1124,
     943,   722,  -142,   221,   869,   872,   452,   236,   252,   252,
    1247,  1329,   537,   539,   237,  1323,   352,  1211,   259,   863,
     143,  1234,  -699,   -64,  -707,   259,  -149,   722,   791,   351,
     245,  -148,   733,  1260,  1263,  1244,   474,  1178,   887,  -146,
     488,   490,   794,   804,   769,   948,  1178,   296,   300,   742,
     775,  -699,   785,   953,   509,  -144,  -147,   466,  -141,   914,
    -708,  -707,   265,  -698,   879,   507,   502,   915,  1028,   283,
     922,  -145,   920,  -143,   607,   261,   908,   264,  1215,   908,
     450,  1329,   757,   904,   322,  1323,   792,   342,   343,   358,
     835,  1179,  -698,   286,  -142,  -141,   842,   843,  -147,   528,
    -581,   353,   743,   508,   839,   252,  -135,   654,   334,   138,
    1207,  1212,  -141,   523,   362,  1145,  -132,   405,   405,   405,
     405,  -794,   555,   556,   292,  1247,  -135,  -135,  -132,  1247,
    -135,  1343,  -133,   478,   331,  1051,   919,   361,   309,   471,
     332,   353,  1340,  1147,  -146,   138,   471,   255,   286,   485,
     236,   997,   236,  1053,   707,   861,  -140,   237,  1342,   237,
     142,  -139,   499,   500,   138,   722,   698,   349,   349,  -137,
     852,  -793,    73,   482,   947,   245,   722,  -147,  1139,   292,
     256,   862,  -142,   354,   312,  -135,  -138,  -149,  -794,   405,
    1343,   662,   549,   550,   551,   552,   697,   309,   697,   978,
     291,  -136,   771,  -134,   259,   405,   971,   666,   913,  1215,
    1162,   458,  1171,  1215,   138,   684,  1167,   521,  1215,   926,
     772,  1203,   351,   927,   476,   486,   286,  -136,   669,  1123,
    1123,   331,   670,   741,   334,   741,   757,   332,   757,   746,
     934,    73,   138,   312,   708,  1204,   609,   710,   331,  1000,
     252,  1010,   713,  -141,   332,   351,  1011,   292,  -149,  -141,
    1030,  1032,  1178,   366,   658,  -148,  1036,  1038,  1041,   725,
     331,  1097,  1097,   659,   660,  1215,   332,  1215,   291,  1215,
     668,  1215,   138,   970,   698,  -146,   973,   562,  -793,   138,
     138,  -146,   747,   649,   485,   236,   692,   292,  1215,  1066,
     980,  1067,   237,  1069,   292,   292,   530,   563,   881,  1068,
     651,  -144,  1254,  1256,   697,   259,    59,  1056,  -147,  1259,
    1262,  -794,   674,  -142,  -147,  -145,  1011,   460,  -149,  -142,
    -148,   882,  -815,   523,  -149,  -143,  -136,   567,   568,  1105,
    1105,  1123,  -144,   765,   513,   513,   236,   649,   877,   513,
    1125,   519,   260,   237,   771,   344,  -136,  -136,   309,   583,
    -136,   532,   533,   687,   583,  -145,   649,   485,   236,   245,
     569,   803,  1191,  1002,  1004,   237,   471,  1006,   471,  1008,
     714,  1009,  -137,  1097,  1123,  -356,   221,   138,   368,   698,
     959,  1123,  1123,   889,   649,   757,   757,  -397,   462,  1048,
     847,   322,  1049,   467,   312,   883,  -148,  1158,  1159,  1054,
    -700,   749,  -148,  -356,  -356,  1058,   523,   783,   568,   683,
     649,   485,   236,   919,   223,  -397,  -397,   138,  1363,   237,
     459,  1186,   898,   138,   707,  1327,   987,   898,   642,  -700,
     650,   309,   292,   469,   252,  1024,  1214,   866,   796,  1225,
     569,  1105,  -144,   796,   392,   393,   394,  1227,  -144,   864,
     750,   468,   699,  1052,  -149,   760,  -145,   807,   760,  -356,
    -143,  1228,  -145,  -794,   138,   495,  -143,   138,   697,   841,
     475,  -397,  -143,  -708,   910,   919,  1187,   312,   503,   292,
    1188,  -137,   292,  1141,  1105,   885,   779,   255,  1230,   779,
    1123,  1105,  1105,   669,   477,   728,   828,  1160,   459,  1251,
    1252,  -137,  -137,   259,  -793,  -137,   260,  -142,   836,   906,
     838,   -64,  -148,   259,   800,  1148,  1149,  1151,  1152,   800,
     368,   796,   796,   877,   138,   824,   138,   890,  -133,   471,
    -144,  1135,  -149,   832,   833,   807,   807,   397,   451,   292,
     823,   292,  -134,  1281,  1062,  1283,   397,   138,   649,   485,
     236,  1226,   309,  -140,  1161,   796,  -113,   237,   895,   649,
     485,   236,   292,   576,  -701,   398,   399,   874,   237,   807,
    1330,   868,   833,   221,   398,   472,  -703,  -129,  1331,  1338,
     583,   368,  1335,   471,   390,   391,   392,   393,   394,   829,
     908,   583,  1228,  -701,   941,  -702,  1228,   950,   312,   928,
    1105,  1228,   930,   523,   397,  -703,   833,   -97,   506,  1324,
    1142,   223,  1198,   880,   530,   538,  -704,  -112,   981,   823,
     511,   400,   983,  -145,  -702,   405,   517,   405,   309,   576,
     473,  -143,   398,   501,   959,  1275,   844,   990,  1367,   992,
    1368,   520,  1370,   530,   891,  -704,   583,   897,  1369,   899,
    -695,  -134,   900,   901,   -98,  1349,  1253,   996,  1228,  1376,
    1228,   344,  1228,  1280,  1228,   397,   819,   976,   530,   532,
     533,  -134,  -134,   503,   312,  -134,   397,  -695,  -695,  -695,
    1226,  1228,  1226,   825,  1093,  1093,  1226,  -797,   473,   445,
    1272,  1226,   884,   398,   526,   525,   535,  -696,   532,   533,
     975,   693,   977,   491,   398,   453,  -695,  -148,  -696,   545,
    1014,   680,  1015,   492,   493,   259,  -705,   540,   957,   -64,
     964,   531,   964,   532,   533,  -696,  -696,   138,  -139,   787,
    -797,   405,   -97,   790,  -695,   828,  -706,  -696,   -97,  1224,
     681,   825,   292,  1163,  -705,  -705,  -349,   221,  1226,   527,
    1226,  1348,  1226,   829,  1226,   548,   722,   594,  -797,  -797,
    1183,  1312,   994,   974,  -706,  -706,  -714,   513,   471,  -144,
     597,  1226,   825,   979,  -349,  -349,  1339,   796,   796,   -98,
    1341,  -696,   601,   796,   796,   -98,   841,  -145,  1057,   610,
    -135,   807,   807,   397,   663,   760,  1093,   807,   807,   268,
    -705,   342,   343,   530,   546,   397,  1047,   950,  -136,  -357,
     884,   667,  -797,  1046,  -797,   779,   923,   672,  -793,  1231,
    -706,   398,   664,   649,   485,   236,   709,   397,   711,   138,
    -349,   718,   237,   398,   675,   717,  1163,  -357,  -357,  1043,
     397,  -143,   259,   512,   292,   138,  1163,  1163,  1063,   373,
     374,   712,   796,   719,   397,   398,   939,   101,   532,   533,
     292,  1240,  -134,   800,   138,  -129,   807,   796,   398,  1265,
    1224,   247,   247,   727,  1224,   259,   515,   665,   729,   292,
     758,   807,   398,  1337,  1072,  1073,   761,   138,   138,   676,
     763,   825,   773,  -357,   958,   959,  1122,  1122,   768,  1081,
     774,   825,  1174,   385,   386,  1138,  1243,  -444,   101,   101,
    1177,   940,   310,   368,  1075,  1076,  1258,  1261,   776,   563,
     788,   138,   805,   247,  1266,   993,  1129,   298,  1133,   827,
     381,   382,  1184,  1185,   837,  1078,   292,   844,   676,   847,
    1224,   902,  1257,  1273,  1274,   310,   405,   259,  1346,   567,
     309,  1122,  1122,  1248,   905,  1122,  1156,  1156,   907,   247,
     247,   524,   524,   247,   418,   429,   429,  1269,   247,   924,
     916,   925,  1122,  1267,   387,   388,   389,   390,   391,   392,
     393,   394,   929,  -329,   530,  1295,   932,  1200,  1201,   933,
     935,    36,    37,  1208,    39,  1299,  1196,  1169,   936,   937,
     138,    45,    46,   138,   138,   508,   944,  1229,  1122,   138,
     334,   949,  1304,  1305,  1306,   292,  1012,  1013,   292,   292,
     954,  1241,   964,   138,   292,  1018,   138,   772,  1019,   959,
    1021,  1122,   991,   496,  1122,  1034,  1001,   535,   292,   532,
     533,   292,  1240,   405,   405,  1003,  1005,  1007,  1122,   309,
    1122,  1268,  -333,  1122,  1122,  1064,   871,   873,  1122,  1122,
    1065,  1303,  -331,   825,  1127,  1279,  1130,   138,   530,  1153,
    1150,  1173,   871,   873,  1180,  1232,  1079,    84,  1236,  1181,
    1238,   138,   292,   530,  1182,   964,   101,  1237,  1178,   530,
     888,    84,    84,  1264,  1277,   431,   292,  1332,  1255,   760,
     461,   760,  1276,   463,   464,   465,    40,    41,    42,    43,
     309,   247,  1282,   247,  1122,  1284,   247,   247,  1318,  1319,
    1288,   535,   101,   532,   533,   825,  1170,  1293,    84,    84,
     606,  1296,  1297,  1300,  1302,   611,   536,  1325,   532,   533,
    1336,   101,   739,    84,   532,   533,  1350,   138,  1352,   649,
     485,   236,   957,  1354,  1133,  1356,   431,   530,   237,  1361,
    -793,   310,   292,  -794,  1373,  1122,   724,   498,   547,  1122,
    1345,  1122,  1307,  1308,  1309,  1199,   726,   411,   982,    84,
      84,  1209,   798,    84,   433,   416,   138,   368,    84,   715,
     396,   101,  1045,   247,   247,   247,   247,   867,   247,   247,
    1055,   292,  1271,   825,   381,   382,   825,   903,   998,  1326,
     744,   760,   532,   533,   337,   338,   339,   340,   341,   101,
     310,  1287,  1219,  1344,  1334,  1157,   825,   689,   690,   964,
    1122,   368,  1286,  1366,  1091,  1091,   694,   984,   605,  1364,
    1301,  1249,   888,  1250,   705,   706,  1242,  1315,   381,   382,
     389,   390,   391,   392,   393,   394,   247,  1316,   457,   101,
     745,   446,  1209,   909,   496,   247,   101,   101,   918,   455,
    1362,   557,   723,   558,   559,   560,   561,     0,     0,     0,
       0,   247,   557,     0,   558,   559,   560,   561,   562,  1091,
    1091,     0,     0,  1091,     0,   390,   391,   392,   393,   394,
     825,   825,   825,     0,     0,     0,    84,   247,   563,     0,
    1091,     0,  1031,  1033,     0,     0,     0,     0,  1037,  1039,
       0,   751,   564,     0,     0,     0,   752,     0,     0,   247,
       0,    84,   565,    84,     0,     0,    84,    84,   567,   568,
     695,   696,    84,     0,     0,  1175,  1091,    36,    37,   298,
      39,   825,  1031,  1033,     0,  1037,  1039,     0,     0,     0,
    1347,    84,     0,   557,   101,   558,   559,   560,   561,  1091,
       0,   569,  1091,   557,     0,   558,   559,   560,   561,  1170,
       0,   310,     0,   247,   696,     0,  1091,   298,  1091,     0,
       0,  1091,  1091,     0,     0,  1176,  1091,  1091,     0,     0,
       0,     0,  1126,  1320,   101,   558,   559,   560,   561,     0,
     101,    84,     0,    84,    84,    84,    84,     0,    84,    84,
       0,   834,     0,   751,     0,     0,  1126,     0,     0,     0,
       0,  1290,     0,  1294,     0,     0,     0,     0,     0,    84,
     557,     0,   558,   559,   560,   561,   562,     0,     0,     0,
     247,   101,  1091,   247,   101,     0,     0,     0,   770,     0,
       0,   875,   247,     0,   310,     0,   563,   815,     0,     0,
       0,     0,     0,     0,     0,     0,    84,     0,   799,    84,
       0,     0,     0,   812,     0,    84,    84,    84,     0,     0,
     565,     0,     0,     0,     0,     0,   567,   568,     0,     0,
       0,    84,     0,  1091,     0,     0,     0,  1091,     0,  1091,
       0,   101,     0,   101,     0,     0,     0,     0,   938,     0,
       0,   247,     0,     0,     0,     0,     0,    84,     0,   569,
       0,     0,   247,     0,   101,   247,  1351,  1353,     0,     0,
    1355,  1357,     0,     0,  1360,   815,   815,     0,     0,    84,
       0,     0,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   876,     0,     0,  1091,   381,
     382,   247,     0,  1371,  1372,  1374,  1375,     0,     0,   815,
       0,   696,  1377,   298,    84,   310,     0,     0,     0,   945,
     946,     0,     0,     0,     0,     0,     0,   951,   952,     0,
       0,     0,   557,    84,   558,   559,   560,   561,   562,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,   393,
     394,     0,     0,     0,    84,     0,     0,     0,   563,  -298,
      84,     0,     0,     0,     0,     0,     0,     0,     0,   917,
       0,     0,   564,     0,     0,     0,     0,   985,   986,     0,
     988,   989,   565,     0,     0,     0,     0,   566,   567,   568,
       0,   310,     0,     0,     0,     0,     0,   931,     0,     0,
      84,    84,     0,    84,    84,     0,     0,     0,     0,     0,
       0,     0,    84,     0,     0,     0,     0,    84,     0,     0,
       0,   569,     0,     0,   570,     0,     0,     0,     0,   696,
       0,     0,     0,     0,     0,     0,  1020,  1060,   112,     0,
       0,   247,     0,   247,   101,     0,     0,   968,     0,  1035,
       0,     0,   112,   112,     0,     0,     0,     0,     0,     0,
       0,    84,   557,    84,   558,   559,   560,   561,   562,     0,
       0,    84,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    84,     0,    84,    84,  1059,     0,   563,   112,
     112,     0,     0,     0,     0,    84,    84,     0,     0,     0,
       0,     0,   564,     0,   112,     0,     0,     0,     0,   247,
       0,     0,   565,     0,     0,     0,     0,   566,   567,   568,
       0,    84,     0,     0,     0,     0,   247,     0,     0,    84,
       0,   815,   815,     0,  1017,     0,     0,   815,   815,     0,
     112,   112,     0,     0,   112,     0,   101,   247,     0,   112,
       0,   569,     0,     0,   570,     0,     0,  1040,     0,     0,
       0,     0,   101,     0,     0,     0,     0,     0,     0,  1050,
     367,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   101,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   298,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   101,   101,   815,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1074,     0,
       0,   815,     0,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,     0,     0,   101,     0,
     381,   382,     0,     0,     0,   557,   383,   558,   559,   560,
     561,   562,     0,  1137,     0,     0,  1114,  1114,   113,     0,
       0,    84,     0,    84,    84,     0,     0,   112,     0,     0,
    1239,   563,   113,   113,     0,     0,     0,     0,     0,     0,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   112,     0,   112,   565,     0,   112,   112,     0,
     566,   567,   568,   112,     0,     0,     0,     0,     0,   113,
     113,  1114,  1114,  1194,     0,  1114,     0,   101,     0,     0,
     101,   101,   112,     0,   113,     0,   101,     0,     0,    84,
       0,     0,  1114,     0,   569,     0,     0,   570,  1202,     0,
     101,     0,     0,   101,     0,     0,    84,     0,     0,     0,
       0,    84,    84,     0,     0,     0,     0,    84,    84,     0,
     113,   113,   247,     0,   113,     0,    84,    84,  1114,   113,
       0,     0,   112,     0,   112,   112,   112,   112,     0,   112,
     112,     0,    84,     0,   101,     0,     0,     0,     0,     0,
       0,  1114,     0,     0,  1114,     0,     0,     0,   101,     0,
     112,    84,     0,     0,     0,     0,     0,     0,  1114,     0,
    1114,     0,  1292,  1114,  1114,     0,     0,     0,  1114,  1114,
       0,     0,     0,     0,    84,    84,    84,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   112,     0,     0,
     112,    84,     0,     0,     0,     0,   112,   112,   112,     0,
       0,     0,   247,     0,     0,     0,     0,     0,    84,   247,
     247,     0,   112,     0,   101,   685,   647,     0,     0,   686,
       0,     0,     0,  1333,  1114,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   113,   112,   188,
     189,   190,   191,   192,   193,   194,   195,   196,     0,     0,
     197,   198,     0,   101,     0,     0,   199,   200,   201,   202,
     112,     0,   113,     0,   113,     0,     0,   113,   113,     0,
     203,   204,     0,   113,     0,  1114,     0,     0,     0,  1114,
       0,  1114,     0,     0,     0,     0,     0,    84,     0,     0,
      84,    84,   113,     0,     0,   112,    84,     0,     0,     0,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
      84,   215,   216,    84,   112,     0,     0,     0,     0,   217,
     255,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    84,     0,     0,   112,     0,     0,     0,     0,
    1114,   112,   113,     0,   113,   113,   113,   113,     0,   113,
     113,     0,     0,     0,    84,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    84,     0,
     113,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   112,   112,     0,   112,   112,     0,     0,     0,     0,
       0,     0,     0,   112,     0,     0,     0,     0,   112,     0,
       0,     0,     0,     0,     0,     0,     0,   113,     0,     0,
     113,     0,     0,     0,     0,     0,   113,   113,   113,     0,
       0,     0,    84,     0,     0,     0,     0,     0,     0,    84,
      84,     0,   113,     0,    84,     0,  1115,  1115,     0,     0,
       0,     0,   112,     0,   112,     0,     0,     0,     0,     0,
       0,     0,   112,     0,     0,     0,     0,     0,   113,     0,
       0,     0,     0,   112,     0,   112,   112,     0,     0,     0,
       0,     0,     0,    84,     0,     0,   112,   112,     0,     0,
     113,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1115,  1115,     0,     0,  1115,     0,     0,     0,     0,
       0,     0,   112,     0,     0,     0,     0,     0,     0,     0,
     112,     0,  1115,     0,     0,   113,     0,     0,     0,     0,
       0,     0,     0,     0,    80,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   113,     0,     0,     0,    80,    80,
       0,  1116,  1116,     0,     0,     0,     0,     0,  1115,     0,
       0,     0,     0,     0,     0,   113,     0,     0,     0,     0,
       0,   113,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1115,     0,     0,  1115,    80,    80,     0,     0,   306,
       0,     0,     0,     0,     0,     0,     0,     0,  1115,     0,
    1115,     0,     0,  1115,  1115,     0,  1116,  1116,  1115,  1115,
    1116,   113,   113,     0,   113,   113,     0,     0,     0,     0,
       0,     0,   306,   113,     0,     0,     0,  1116,   113,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   306,   306,   306,     0,    80,     0,     0,     0,     0,
       0,     0,   112,     0,   112,   112,     0,     0,     0,     0,
       0,     0,     0,  1116,  1115,     0,     0,     0,     0,     0,
       0,     0,   113,     0,   113,     0,     0,     0,     0,     0,
       0,     0,   113,     0,     0,     0,  1116,     0,     0,  1116,
       0,     0,     0,   113,     0,   113,   113,     0,     0,     0,
       0,     0,     0,  1116,     0,  1116,   113,   113,  1116,  1116,
       0,     0,     0,  1116,  1116,  1115,     0,     0,     0,  1115,
     112,  1115,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   113,     0,     0,     0,     0,   112,     0,     0,
     113,     0,   112,   112,     0,     0,  1117,  1117,   112,   112,
       0,     0,     0,     0,     0,     0,     0,   112,   112,     0,
       0,     0,     0,    80,     0,     0,     0,     0,     0,  1116,
       0,     0,     0,   112,     0,     0,     0,     0,     0,     0,
    1115,     0,     0,     0,     0,     0,     0,     0,    80,     0,
      80,     0,   112,     0,     0,     0,     0,     0,     0,    80,
       0,  1117,  1117,     0,     0,  1117,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   112,   112,   112,    80,     0,
    1116,     0,  1117,     0,  1116,     0,  1116,     0,     0,     0,
       0,     0,   112,     0,    22,    23,    24,    25,   306,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   112,
      31,    32,    33,     0,     0,     0,     0,     0,  1117,     0,
      40,    41,    42,    43,    44,     0,     0,     0,    80,     0,
    1118,  1118,   113,     0,   113,   113,     0,     0,     0,     0,
       0,  1117,     0,     0,  1117,  1116,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    80,   306,  1117,     0,
    1117,     0,     0,  1117,  1117,     0,     0,     0,  1117,  1117,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     0,  1118,  1118,     0,   112,  1118,
       0,   112,   112,    80,     0,     0,    80,   112,     0,     0,
     113,     0,     0,    80,    80,     0,  1118,     0,   304,     0,
       0,   112,     0,     0,   112,  1119,  1119,   113,     0,     0,
       0,     0,   113,   113,  1117,     0,     0,     0,   113,   113,
       0,     0,     0,   112,     0,     0,     0,   113,   113,     0,
       0,     0,  1118,     0,    80,     0,     0,     0,     0,     0,
       0,     0,     0,   113,     0,   112,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1118,    80,     0,  1118,   112,
    1119,  1119,   113,     0,  1119,  1117,     0,     0,     0,  1117,
       0,  1117,  1118,     0,  1118,     0,     0,  1118,  1118,     0,
       0,  1119,  1118,  1118,     0,   113,   113,   113,     0,     0,
       0,    80,     0,     0,     0,     0,     0,    81,     0,     0,
       0,     0,   113,     0,     0,     0,     0,     0,   306,     0,
      80,    81,    81,   112,     0,     0,     0,  1119,     0,   113,
     112,   112,     0,     0,     0,   112,     0,     0,     0,     0,
    1117,    80,     0,     0,     0,     0,     0,    80,  1118,     0,
    1119,     0,     0,  1119,     0,     0,     0,     0,    81,    81,
       0,     0,   307,     0,     0,     0,     0,  1119,     0,  1119,
       0,     0,  1119,  1119,   112,     0,     0,  1119,  1119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    80,     0,
       0,    80,     0,     0,     0,   307,     0,     0,     0,  1118,
       0,   306,     0,  1118,    80,  1118,     0,     0,   113,     0,
       0,   113,   113,     0,   307,   307,   307,   113,    81,     0,
       0,  1120,  1120,     0,     0,     0,     0,     0,     0,     0,
       0,   113,     0,  1119,   113,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    80,     0,
      80,     0,     0,   113,     0,  1121,  1121,     0,    80,     0,
       0,     0,     0,     0,  1118,     0,     0,     0,     0,    80,
       0,    80,     0,     0,     0,   113,  1120,  1120,     0,     0,
    1120,     0,    80,    80,  1119,     0,     0,     0,  1119,   113,
    1119,     0,     0,     0,     0,     0,     0,  1120,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1121,  1121,     0,     0,  1121,     0,    80,     0,     0,     0,
       0,     0,   306,     0,     0,     0,     0,     0,     0,     0,
       0,  1121,     0,  1120,     0,     0,    81,     0,     0,     0,
       0,     0,     0,   113,     0,     0,     0,     0,     0,  1119,
     113,   113,     0,     0,     0,   113,  1120,     0,     0,  1120,
       0,    81,     0,    81,     0,     0,     0,  1121,     0,     0,
       0,     0,    81,  1120,     0,  1120,     0,     0,  1120,  1120,
       0,     0,     0,  1120,  1120,   938,     0,     0,     0,     0,
    1121,    81,     0,  1121,   113,     0,     0,     0,   306,     0,
       0,     0,     0,     0,     0,     0,     0,  1121,     0,  1121,
       0,   307,  1121,  1121,     0,     0,     0,  1121,  1121,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,   380,     0,     0,     0,     0,   381,   382,     0,  1120,
       0,    81,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
     307,     0,     0,  1121,   141,     0,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,   393,   394,     0,     0,
    1120,     0,     0,     0,  1120,     0,  1120,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    81,     0,     0,    81,
       0,     0,     0,     0,     0,     0,    81,    81,     0,     0,
       0,     0,     0,     0,  1121,   141,   141,     0,  1121,   313,
    1121,     0,     0,    80,     0,     0,     0,     0,    80,    80,
       0,     0,     0,     0,    80,    80,     0,     0,     0,     0,
       0,     0,     0,    80,     0,  1120,     0,    81,     0,     0,
       0,     0,   313,     0,     0,     0,     0,     0,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
       0,   422,   432,   432,     0,     0,     0,     0,    80,  1121,
       0,     0,     0,     0,   638,   639,     0,     0,   640,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    80,    80,    80,    81,     0,     0,     0,   188,   189,
     190,   191,   192,   193,   194,   195,   196,     0,    80,   197,
     198,   307,     0,    81,     0,   199,   200,   201,   202,     0,
       0,     0,     0,     0,     0,    80,     0,     0,     0,   203,
     204,     0,     0,     0,    81,     0,     0,     0,     0,     0,
      81,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,     0,
     215,   216,     0,     0,     0,     0,     0,     0,   217,     0,
       0,    81,   137,   141,    81,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   307,     0,     0,    81,     0,     0,
     306,     0,     0,     0,    80,     0,     0,    80,    80,     0,
       0,     0,     0,    80,     0,     0,     0,     0,     0,   141,
       0,     0,     0,     0,     0,     0,     0,    80,     0,     0,
      80,     0,     0,   137,   137,     0,     0,   311,   141,     0,
       0,    81,     0,    81,     0,     0,     0,     0,     0,     0,
       0,    81,     0,     0,     0,     0,     0,     0,   313,     0,
       0,     0,    81,     0,    81,     0,     0,     0,     0,     0,
     311,    80,     0,     0,     0,    81,    81,     0,     0,     0,
       0,     0,     0,     0,     0,    80,     0,     0,   141,   420,
     430,   430,   430,     0,     0,     0,     0,     0,     0,   306,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    81,
       0,     0,     0,     0,     0,   307,   141,   313,     0,     0,
       0,     0,     0,    91,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    80,
     368,   369,   370,   371,   372,   373,   374,   375,     0,   377,
     378,    80,     0,     0,     0,     0,   141,   381,   382,     0,
     306,     0,     0,   141,   141,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    91,    91,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      80,   307,     0,     0,     0,     0,     0,     0,     0,   385,
     386,   387,   388,   389,   390,   391,   392,   393,   394,     0,
       0,   137,     0,     0,  -815,     0,     0,     0,     0,     0,
       0,     0,  -815,  -815,  -815,     0,     0,  -815,  -815,  -815,
     417,  -815,     0,     0,     0,     0,     0,     0,     0,  -815,
    -815,  -815,     0,     0,    81,     0,   140,   137,     0,     0,
       0,  -815,  -815,     0,  -815,  -815,  -815,  -815,  -815,     0,
       0,   141,     0,     0,     0,     0,   137,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   313,     0,
       0,     0,  -815,  -815,     0,     0,   311,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,   140,     0,
       0,   141,     0,     0,     0,     0,     0,   141,     0,     0,
       0,  -815,  -815,     0,     0,     0,   137,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    81,     0,     0,     0,
       0,    81,    81,     0,  -815,     0,     0,    81,    81,     0,
       0,     0,     0,     0,   137,   311,    81,     0,   141,     0,
       0,   141,    91,     0,     0,     0,     0,     0,     0,     0,
       0,   313,    81,     0,   816,  -815,  -815,     0,  -815,     0,
       0,   255,  -815,     0,  -815,     0,     0,     0,     0,     0,
       0,    81,     0,     0,   137,     0,     0,     0,    91,     0,
       0,   137,   137,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    81,    81,    81,    91,   141,     0,
     141,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    81,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   141,     0,     0,     0,     0,     0,     0,    81,     0,
       0,     0,   816,   816,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    91,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,   816,     0,     0,     0,
       0,     0,   313,     0,     0,    91,     0,     0,     0,   137,
       0,   896,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   311,     0,     0,     0,
       0,   140,     0,   307,     0,     0,     0,    81,     0,     0,
      81,    81,     0,     0,     0,    91,    81,     0,     0,   137,
     140,     0,    91,    91,     0,   137,     0,     0,     0,     0,
      81,     0,     0,    81,    22,    23,    24,    25,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   313,     0,
      31,    32,    33,  1079,     0,     0,     0,  1080,     0,     0,
      40,    41,    42,    43,    44,     0,   137,     0,     0,   137,
     140,     0,     0,     0,    81,     0,     0,     0,     0,   311,
       0,     0,     0,     0,     0,     0,     0,     0,    81,     0,
       0,     0,  1082,  1083,     0,     0,     0,     0,   140,     0,
    1084,   141,   307,  1085,     0,  1086,  1087,     0,  1088,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      91,     0,     0,     0,     0,     0,   137,     0,   137,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,  1090,    81,   646,   647,   140,   140,   648,   304,   137,
       0,     0,     0,     0,    81,   259,     0,     0,     0,     0,
      91,     0,     0,   307,     0,     0,    91,   188,   189,   190,
     191,   192,   193,   194,   195,   196,     0,     0,   197,   198,
       0,     0,     0,     0,   199,   200,   201,   202,   816,   816,
       0,     0,     0,    81,   816,   816,     0,     0,   203,   204,
     311,     0,     0,   141,     0,     0,     0,    91,     0,     0,
      91,     0,     0,     0,     0,     0,     0,     0,     0,   141,
       0,     0,     0,   810,     0,     0,     0,     0,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,   141,   215,
     216,     0,     0,   140,     0,     0,     0,   217,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   141,   141,   816,     0,   381,   382,    91,     0,    91,
       0,     0,     0,     0,     0,     0,   311,     0,   816,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,   140,
      91,     0,     0,     0,     0,   141,     0,     0,     0,     0,
       0,   810,   810,     0,     0,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   259,     0,     0,     0,     0,   137,
     140,     0,     0,   140,     0,   810,     0,    22,    23,    24,
      25,     0,     0,     0,     0,     0,   140,     0,     0,     0,
       0,     0,     0,    31,    32,    33,  1079,     0,     0,     0,
    1080,     0,  1081,    40,    41,    42,    43,    44,     0,     0,
    1197,     0,     0,     0,   141,     0,     0,   141,   141,     0,
       0,     0,   563,   141,     0,     0,     0,     0,     0,     0,
     140,     0,   140,     0,     0,  1082,  1083,   141,     0,     0,
     141,     0,     0,  1084,     0,     0,  1085,     0,  1086,  1087,
       0,  1088,   567,   140,    57,    58,  1089,    60,    61,    62,
      63,    64,    65,     0,   140,   140,     0,     0,     0,     0,
       0,   137,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   141,     0,     0,  1090,     0,     0,   137,     0,     0,
       0,   304,     0,     0,     0,   141,     0,     0,   140,     0,
       0,     0,     0,     0,     0,     0,   137,     0,     0,   432,
      91,     0,   239,   239,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,   380,     0,     0,   137,
     137,   381,   382,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   276,   280,   281,   282,     0,     0,
       0,   239,   239,     0,     0,     0,     0,     0,     0,     0,
       0,   141,     0,   137,   329,   330,     0,     0,     0,     0,
     432,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   810,   810,     0,
     141,     0,     0,   810,   810,     0,     0,     0,     0,   239,
       0,     0,    91,     0,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,  -816,  -816,     0,    91,     0,
       0,   381,   382,   140,     0,     0,     0,     0,  1195,     0,
       0,     0,   137,     0,     0,   137,   137,    91,     0,     0,
       0,   137,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   137,     0,     0,   137,     0,
      91,    91,   810,   385,   386,   387,   388,   389,   390,   391,
     392,   393,   394,     0,     0,     0,     0,   810,     0,     0,
       0,     0,     0,     0,     0,     0,   368,  -816,  -816,  -816,
    -816,   373,   374,     0,    91,  -816,  -816,     0,     0,   137,
       0,     0,     0,   381,   382,     0,     0,     0,     0,     0,
     140,   140,     0,   137,     0,   239,   140,   140,   239,   239,
     239,     0,   329,     0,     0,   140,     0,   430,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,   239,     0,   239,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,     0,     0,  1193,
       0,     0,     0,    91,     0,     0,    91,    91,     0,   137,
       0,     0,    91,   140,   140,   140,     0,     0,   430,     0,
       0,     0,     0,     0,     0,     0,    91,     0,     0,    91,
     140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,   137,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      91,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    91,   613,   614,   615,   616,   617,
       0,     0,   618,   619,   620,   621,   622,   623,   624,   625,
       0,   627,     0,     0,   628,   629,   630,   631,   632,   633,
     634,   635,   636,   637,     0,     0,     0,   239,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,   140,
     140,     0,     0,     0,     0,   140,     0,     0,   368,   369,
     370,   371,   372,   373,   374,     0,     0,   377,   378,   140,
      91,     0,   140,     0,     0,   381,   382,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   239,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   239,   239,     0,     0,    91,
     239,     0,     0,   140,   239,     0,   282,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   140,     0,  -797,
       0,     0,     0,     0,   716,     0,     0,  -797,  -797,  -797,
       0,     0,  -797,  -797,  -797,     0,  -797,     0,     0,   239,
       0,     0,   239,     0,  -797,  -797,  -797,  -797,  -797,     0,
       0,     0,     0,     0,   239,     0,  -797,  -797,     0,  -797,
    -797,  -797,  -797,  -797,     0,     0,     0,     0,     0,     0,
       0,     0,   748,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,  -797,  -797,     0,
       0,     0,     0,     0,     0,     0,     0,  -797,  -797,  -797,
    -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,
       0,     0,     0,   239,  -797,  -797,  -797,  -797,     0,   878,
    -797,   780,   140,     0,   780,  -797,     0,     0,     0,     0,
       0,     0,     0,   239,     0,     0,     0,     0,   811,  -797,
       0,     0,  -797,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -146,  -797,  -797,  -797,  -797,  -797,  -797,
    -797,  -797,  -797,  -797,  -797,  -797,     0,     0,     0,     0,
    -797,  -797,  -797,  -797,  -797,     0,     0,  -797,  -797,  -797,
       0,     0,    22,    23,    24,    25,     0,     0,     0,     0,
       0,     0,   239,     0,     0,     0,     0,     0,    31,    32,
      33,  1079,     0,   239,     0,  1080,     0,     0,    40,    41,
      42,    43,    44,     0,     0,     0,   870,   870,     0,     0,
     239,   870,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   870,   870,     0,     0,   239,     0,   239,     0,
    1082,  1083,     0,     0,     0,   780,   780,     0,  1084,     0,
     870,  1085,     0,  1086,  1087,     0,  1088,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1090,
       0,     0,     0,     0,   239,     0,   304,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   239,     0,     0,     0,     0,     0,    -4,     3,
       0,     4,     5,     6,     7,     8,    -4,    -4,    -4,     9,
      10,     0,    -4,    -4,    11,    -4,    12,    13,    14,    15,
      16,    17,    18,    -4,   239,     0,     0,     0,    19,    20,
      21,    22,    23,    24,    25,     0,     0,    26,     0,     0,
       0,     0,   239,    27,    28,   284,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,     0,    40,    41,    42,
      43,    44,    45,    46,     0,     0,    -4,     0,     0,     0,
       0,     0,   870,     0,    47,    48,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    49,
      50,     0,     0,     0,     0,     0,     0,    51,     0,     0,
      52,    53,    54,    55,     0,    56,     0,     0,    57,    58,
      59,    60,    61,    62,    63,    64,    65,     0,    -4,     0,
     780,     0,     0,     0,     0,     0,     0,     0,     0,   239,
       0,     0,     0,     0,     0,     0,     0,   239,     0,     0,
       0,  1029,   870,   870,     0,    66,    67,    68,   870,   870,
      -4,     0,   239,     0,     0,     0,    -4,     0,   546,     0,
       0,     0,     0,     0,   239,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   870,   870,     0,   870,   870,     0,   239,     0,
     780,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1070,
    1071,     0,     0,   239,     0,     0,     0,   870,  1077,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   870,     0,     0,     0,     0,     0,     0,  -815,
       3,     0,     4,     5,     6,     7,     8,     0,   239,     0,
       9,    10,     0,     0,     0,    11,   870,    12,    13,    14,
      15,    16,    17,    18,     0,     0,     0,     0,     0,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,    27,    28,   284,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,   239,     0,     0,     0,     0,    51,     0,
       0,    52,    53,    54,    55,     0,    56,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,  -815,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    66,    67,    68,     0,
       0,  -815,     3,  -815,     4,     5,     6,     7,     8,  -815,
       0,     0,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,    15,    16,    17,    18,     0,     0,     0,     0,
       0,    19,    20,    21,    22,    23,    24,    25,     0,     0,
      26,     0,     0,     0,     0,     0,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,   239,     0,     0,     0,    47,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,    50,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,    53,    54,    55,     0,    56,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    66,    67,
      68,     0,     0,    -4,     3,  -815,     4,     5,     6,     7,
       8,  -815,     0,     0,     9,    10,     0,     0,     0,    11,
       0,    12,    13,    14,    15,    16,    17,    18,     0,     0,
       0,     0,     0,    19,    20,    21,    22,    23,    24,    25,
       0,     0,    26,     0,     0,     0,     0,     0,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,    50,     0,     0,     0,     0,
       0,     0,    51,     0,     0,    52,    53,    54,    55,     0,
      56,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,    65,     0,     0,     0,     0,     0,     0,     0,  -695,
       0,     0,     0,     0,     0,     0,     0,  -695,  -695,  -695,
       0,     0,  -695,  -695,  -695,     0,  -695,     0,     0,     0,
      66,    67,    68,     0,  -695,    -4,  -695,  -695,  -695,     0,
       0,     0,     0,   546,     0,     0,  -695,  -695,     0,  -695,
    -695,  -695,  -695,  -695,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -695,  -695,     0,
       0,     0,     0,     0,     0,     0,     0,  -695,  -695,  -695,
    -695,  -695,  -695,  -695,  -695,  -695,  -695,  -695,  -695,  -695,
       0,     0,     0,     0,  -695,  -695,  -695,  -695,     0,  -695,
    -695,     0,     0,     0,     0,  -695,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -695,
       0,     0,  -695,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -695,  -695,  -695,  -695,  -695,  -695,  -695,
    -695,  -695,  -695,  -695,  -695,  -695,     0,     0,     0,     0,
       0,  -695,  -695,  -695,  -695,  -696,     0,  -695,  -695,  -695,
       0,     0,     0,  -696,  -696,  -696,     0,     0,  -696,  -696,
    -696,     0,  -696,     0,     0,     0,     0,     0,     0,     0,
    -696,     0,  -696,  -696,  -696,     0,     0,     0,     0,     0,
       0,     0,  -696,  -696,     0,  -696,  -696,  -696,  -696,  -696,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -696,  -696,     0,     0,     0,     0,     0,
       0,     0,     0,  -696,  -696,  -696,  -696,  -696,  -696,  -696,
    -696,  -696,  -696,  -696,  -696,  -696,     0,     0,     0,     0,
    -696,  -696,  -696,  -696,     0,  -696,  -696,     0,     0,     0,
       0,  -696,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -696,     0,     0,  -696,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -696,
    -696,  -696,  -696,  -696,  -696,  -696,  -696,  -696,  -696,  -696,
    -696,  -696,     0,     0,     0,     0,     0,  -696,  -696,  -696,
    -696,  -798,     0,  -696,  -696,  -696,     0,     0,     0,  -798,
    -798,  -798,     0,     0,  -798,  -798,  -798,     0,  -798,     0,
       0,     0,     0,     0,     0,     0,  -798,  -798,  -798,  -798,
    -798,     0,     0,     0,     0,     0,     0,     0,  -798,  -798,
       0,  -798,  -798,  -798,  -798,  -798,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -798,
    -798,     0,     0,     0,     0,     0,     0,     0,     0,  -798,
    -798,  -798,  -798,  -798,  -798,  -798,  -798,  -798,  -798,  -798,
    -798,  -798,     0,     0,     0,     0,  -798,  -798,  -798,  -798,
       0,     0,  -798,     0,     0,     0,     0,  -798,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -798,     0,     0,  -798,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -798,  -798,  -798,  -798,
    -798,  -798,  -798,  -798,  -798,  -798,  -798,  -798,     0,     0,
       0,     0,  -798,  -798,  -798,  -798,  -798,  -799,     0,  -798,
    -798,  -798,     0,     0,     0,  -799,  -799,  -799,     0,     0,
    -799,  -799,  -799,     0,  -799,     0,     0,     0,     0,     0,
       0,     0,  -799,  -799,  -799,  -799,  -799,     0,     0,     0,
       0,     0,     0,     0,  -799,  -799,     0,  -799,  -799,  -799,
    -799,  -799,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -799,  -799,     0,     0,     0,
       0,     0,     0,     0,     0,  -799,  -799,  -799,  -799,  -799,
    -799,  -799,  -799,  -799,  -799,  -799,  -799,  -799,     0,     0,
       0,     0,  -799,  -799,  -799,  -799,     0,     0,  -799,     0,
       0,     0,     0,  -799,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -799,     0,     0,
    -799,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -799,  -799,  -799,  -799,  -799,  -799,  -799,  -799,
    -799,  -799,  -799,  -799,     0,     0,     0,     0,  -799,  -799,
    -799,  -799,  -799,  -510,     0,  -799,  -799,  -799,     0,     0,
       0,  -510,  -510,  -510,     0,     0,  -510,  -510,  -510,     0,
    -510,     0,     0,     0,     0,     0,     0,     0,  -510,  -510,
    -510,  -510,     0,     0,     0,     0,     0,     0,     0,     0,
    -510,  -510,     0,  -510,  -510,  -510,  -510,  -510,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -510,  -510,     0,     0,     0,     0,     0,     0,     0,
       0,  -510,  -510,  -510,  -510,  -510,  -510,  -510,  -510,  -510,
    -510,  -510,  -510,  -510,     0,     0,     0,     0,  -510,  -510,
    -510,  -510,     0,     0,  -510,     0,     0,     0,     0,  -510,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -510,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -510,     0,
    -510,  -510,  -510,  -510,  -510,  -510,  -510,  -510,  -510,  -510,
       0,     0,     0,     0,  -510,  -510,  -510,  -510,  -510,  -350,
     255,  -510,  -510,  -510,     0,     0,     0,  -350,  -350,  -350,
       0,     0,  -350,  -350,  -350,     0,  -350,     0,     0,     0,
       0,     0,     0,     0,  -350,     0,  -350,  -350,  -350,     0,
       0,     0,     0,     0,     0,     0,  -350,  -350,     0,  -350,
    -350,  -350,  -350,  -350,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -350,  -350,     0,
       0,     0,     0,     0,     0,     0,     0,  -350,  -350,  -350,
    -350,  -350,  -350,  -350,  -350,  -350,  -350,  -350,  -350,  -350,
       0,     0,     0,     0,  -350,  -350,  -350,  -350,     0,     0,
    -350,     0,     0,     0,     0,  -350,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -350,
       0,     0,  -350,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -350,  -350,  -350,  -350,  -350,  -350,
    -350,  -350,  -350,  -350,  -350,  -350,     0,     0,     0,     0,
       0,  -350,  -350,  -350,  -350,  -815,     0,  -350,  -350,  -350,
       0,     0,     0,  -815,  -815,  -815,     0,     0,  -815,  -815,
    -815,     0,  -815,     0,     0,     0,     0,     0,     0,     0,
    -815,  -815,  -815,  -815,     0,     0,     0,     0,     0,     0,
       0,     0,  -815,  -815,     0,  -815,  -815,  -815,  -815,  -815,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -815,  -815,     0,     0,     0,     0,     0,
       0,     0,     0,  -815,  -815,  -815,  -815,  -815,  -815,  -815,
    -815,  -815,  -815,  -815,  -815,  -815,     0,     0,     0,     0,
    -815,  -815,  -815,  -815,     0,     0,  -815,     0,     0,     0,
       0,  -815,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -815,     0,  -815,  -815,  -815,  -815,  -815,  -815,  -815,  -815,
    -815,  -815,     0,     0,     0,     0,  -815,  -815,  -815,  -815,
    -815,  -356,   255,  -815,  -815,  -815,     0,     0,     0,  -356,
    -356,  -356,     0,     0,  -356,  -356,  -356,     0,  -356,     0,
       0,     0,     0,     0,     0,     0,  -356,     0,  -356,  -356,
       0,     0,     0,     0,     0,     0,     0,     0,  -356,  -356,
       0,  -356,  -356,  -356,  -356,  -356,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -356,
    -356,     0,     0,     0,     0,     0,     0,     0,     0,  -356,
    -356,  -356,  -356,  -356,  -356,  -356,  -356,  -356,  -356,  -356,
    -356,  -356,     0,     0,     0,     0,  -356,  -356,  -356,  -356,
       0,   879,  -356,     0,     0,     0,     0,  -356,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -356,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -147,  -356,     0,  -356,  -356,
    -356,  -356,  -356,  -356,  -356,  -356,  -356,  -356,     0,     0,
       0,     0,   822,  -356,  -356,  -356,  -356,  -363,     0,  -356,
    -356,  -356,     0,     0,     0,  -363,  -363,  -363,     0,     0,
    -363,  -363,  -363,     0,  -363,     0,     0,     0,     0,     0,
       0,     0,  -363,     0,  -363,  -363,     0,     0,     0,     0,
       0,     0,     0,     0,  -363,  -363,     0,  -363,  -363,  -363,
    -363,  -363,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -363,  -363,     0,     0,     0,
       0,     0,     0,     0,     0,  -363,  -363,  -363,  -363,  -363,
    -363,  -363,  -363,  -363,  -363,  -363,  -363,  -363,     0,     0,
       0,     0,  -363,  -363,  -363,  -363,     0,     0,  -363,     0,
       0,     0,     0,  -363,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -363,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -363,     0,  -363,  -363,  -363,  -363,  -363,  -363,
    -363,  -363,  -363,  -363,     0,     0,     0,     0,     0,  -363,
    -363,  -363,  -363,  -797,   451,  -363,  -363,  -363,     0,     0,
       0,  -797,  -797,  -797,     0,     0,     0,  -797,  -797,     0,
    -797,     0,     0,     0,     0,     0,     0,     0,  -797,  -797,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -797,  -797,     0,  -797,  -797,  -797,  -797,  -797,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -797,  -797,     0,     0,     0,     0,     0,     0,     0,
       0,  -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,
    -797,  -797,  -797,  -797,     0,     0,     0,     0,  -797,  -797,
    -797,  -797,     0,   820,  -797,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -797,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -146,  -797,     0,
    -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,
       0,     0,     0,     0,  -797,  -797,  -797,  -797,  -137,  -797,
       0,  -797,     0,  -797,     0,     0,     0,  -797,  -797,  -797,
       0,     0,     0,  -797,  -797,     0,  -797,     0,     0,     0,
       0,     0,     0,     0,  -797,  -797,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -797,  -797,     0,  -797,
    -797,  -797,  -797,  -797,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -797,  -797,     0,
       0,     0,     0,     0,     0,     0,     0,  -797,  -797,  -797,
    -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,  -797,
       0,     0,     0,     0,  -797,  -797,  -797,  -797,     0,   820,
    -797,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -797,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -146,  -797,     0,  -797,  -797,  -797,  -797,
    -797,  -797,  -797,  -797,  -797,  -797,     0,     0,     0,     0,
    -797,  -797,  -797,  -797,  -797,  -356,     0,  -797,     0,  -797,
       0,     0,     0,  -356,  -356,  -356,     0,     0,     0,  -356,
    -356,     0,  -356,     0,     0,     0,     0,     0,     0,     0,
    -356,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -356,  -356,     0,  -356,  -356,  -356,  -356,  -356,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -356,  -356,     0,     0,     0,     0,     0,
       0,     0,     0,  -356,  -356,  -356,  -356,  -356,  -356,  -356,
    -356,  -356,  -356,  -356,  -356,  -356,     0,     0,     0,     0,
    -356,  -356,  -356,  -356,     0,   821,  -356,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -356,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -147,
    -356,     0,  -356,  -356,  -356,  -356,  -356,  -356,  -356,  -356,
    -356,  -356,     0,     0,     0,     0,   822,  -356,  -356,  -356,
    -138,  -356,     0,  -356,     0,  -356,     0,     0,     0,  -356,
    -356,  -356,     0,     0,     0,  -356,  -356,     0,  -356,     0,
       0,     0,     0,     0,     0,     0,  -356,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -356,  -356,
       0,  -356,  -356,  -356,  -356,  -356,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -356,
    -356,     0,     0,     0,     0,     0,     0,     0,     0,  -356,
    -356,  -356,  -356,  -356,  -356,  -356,  -356,  -356,  -356,  -356,
    -356,  -356,     0,     0,     0,     0,  -356,  -356,  -356,  -356,
       0,   821,  -356,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -356,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -147,  -356,     0,  -356,  -356,
    -356,  -356,  -356,  -356,  -356,  -356,  -356,  -356,     0,     0,
       0,     0,   822,  -356,  -356,  -356,  -356,     0,     0,  -356,
       3,  -356,     4,     5,     6,     7,     8,  -815,  -815,  -815,
       9,    10,     0,     0,  -815,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,     0,     0,     0,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,    27,    28,   284,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,  -815,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,    51,     0,
       0,    52,    53,    54,    55,     0,    56,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    66,    67,    68,     0,
       0,     0,     3,  -815,     4,     5,     6,     7,     8,  -815,
       0,  -815,     9,    10,     0,  -815,  -815,    11,     0,    12,
      13,    14,    15,    16,    17,    18,     0,     0,     0,     0,
       0,    19,    20,    21,    22,    23,    24,    25,     0,     0,
      26,     0,     0,     0,     0,     0,    27,    28,   284,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,    43,    44,    45,    46,     0,     0,  -815,
       0,     0,     0,     0,     0,     0,     0,    47,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,    50,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,    53,    54,    55,     0,    56,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    66,    67,
      68,     0,     0,     0,     3,  -815,     4,     5,     6,     7,
       8,  -815,     0,  -815,     9,    10,     0,     0,  -815,    11,
    -815,    12,    13,    14,    15,    16,    17,    18,     0,     0,
       0,     0,     0,    19,    20,    21,    22,    23,    24,    25,
       0,     0,    26,     0,     0,     0,     0,     0,    27,    28,
     284,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,  -815,     0,     0,     0,     0,     0,     0,     0,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,    50,     0,     0,     0,     0,
       0,     0,    51,     0,     0,    52,    53,    54,    55,     0,
      56,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,    65,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      66,    67,    68,     0,     0,     0,     3,  -815,     4,     5,
       6,     7,     8,  -815,     0,  -815,     9,    10,     0,     0,
    -815,    11,     0,    12,    13,    14,    15,    16,    17,    18,
    -815,     0,     0,     0,     0,    19,    20,    21,    22,    23,
      24,    25,     0,     0,    26,     0,     0,     0,     0,     0,
      27,    28,   284,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,    43,    44,    45,
      46,     0,     0,  -815,     0,     0,     0,     0,     0,     0,
       0,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,    50,     0,     0,
       0,     0,     0,     0,    51,     0,     0,    52,    53,    54,
      55,     0,    56,     0,     0,    57,    58,    59,    60,    61,
      62,    63,    64,    65,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    66,    67,    68,     0,     0,     0,     3,  -815,
       4,     5,     6,     7,     8,  -815,     0,  -815,     9,    10,
       0,     0,  -815,    11,     0,    12,    13,    14,    15,    16,
      17,    18,     0,     0,     0,     0,     0,    19,    20,    21,
      22,    23,    24,    25,     0,     0,    26,     0,     0,     0,
       0,     0,    27,    28,   284,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,     0,    40,    41,    42,    43,
      44,    45,    46,     0,     0,  -815,     0,     0,     0,     0,
       0,     0,     0,    47,    48,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,    50,
       0,     0,     0,     0,     0,     0,    51,     0,     0,    52,
      53,    54,    55,     0,    56,     0,     0,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    66,    67,    68,     0,     0,     0,
       3,  -815,     4,     5,     6,     7,     8,  -815,  -815,  -815,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,     0,     0,     0,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,    27,    28,   284,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,  -815,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,    51,     0,
       0,    52,    53,    54,    55,     0,    56,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    66,    67,    68,     0,
       0,     0,     3,  -815,     4,     5,     6,     7,     8,  -815,
       0,  -815,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,    15,    16,    17,    18,     0,     0,     0,     0,
       0,    19,    20,    21,    22,    23,    24,    25,     0,     0,
      26,     0,     0,     0,     0,     0,    27,    28,   284,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,    43,    44,    45,    46,     0,     0,  -815,
       0,     0,     0,     0,     0,     0,     0,    47,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,    50,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,    53,    54,    55,     0,    56,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    66,    67,
      68,     0,     0,     0,     3,  -815,     4,     5,     6,     7,
       8,  -815,     0,     0,     9,    10,     0,     0,     0,    11,
       0,    12,    13,    14,    15,    16,    17,    18,     0,     0,
       0,     0,     0,    19,    20,    21,    22,    23,    24,    25,
       0,     0,    26,     0,     0,     0,     0,     0,    27,    28,
     284,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,    50,     0,     0,     0,     0,
       0,     0,    51,     0,     0,   285,    53,    54,    55,     0,
      56,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,    65,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      66,    67,    68,     0,     0,     0,     0,  -815,     0,     0,
       0,  -815,     3,  -815,     4,     5,     6,     7,     8,     0,
       0,     0,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,    15,    16,    17,    18,     0,     0,     0,     0,
       0,    19,    20,    21,    22,    23,    24,    25,     0,     0,
      26,     0,     0,     0,     0,     0,    27,    28,   284,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,    50,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,    53,    54,    55,     0,    56,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    66,    67,
      68,     0,     0,     0,     0,  -815,     0,     0,     0,  -815,
       3,  -815,     4,     5,     6,     7,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,     0,     0,     0,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,    51,     0,
       0,    52,    53,    54,    55,     0,    56,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    66,    67,    68,     0,
       0,  -815,     3,  -815,     4,     5,     6,     7,     8,  -815,
       0,     0,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,    15,    16,    17,    18,     0,     0,     0,     0,
       0,    19,    20,    21,    22,    23,    24,    25,     0,     0,
      26,     0,     0,     0,     0,     0,    27,    28,   284,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,    50,     0,     0,     0,     0,     0,     0,
      51,     0,     0,    52,    53,    54,    55,     0,    56,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    66,    67,
      68,     0,     0,  -815,   404,  -815,     4,     5,     6,     0,
       8,  -815,     0,     0,     9,    10,     0,     0,     0,    11,
      -3,    12,    13,    14,    15,    16,    17,    18,     0,     0,
       0,     0,     0,    19,    20,    21,    22,    23,    24,    25,
       0,     0,    26,     0,     0,     0,     0,     0,     0,    28,
       0,     0,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    49,    50,     0,     0,     0,     0,
       0,     0,   229,     0,     0,   230,    53,    54,    55,     0,
       0,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,    65,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      66,    67,    68,     0,     0,     0,     0,   331,     0,     0,
       0,     0,     0,   332,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,     0,     0,
       0,   168,   169,   170,   434,   435,   436,   437,   175,   176,
     177,     0,     0,     0,     0,     0,   178,   179,   180,   181,
     438,   439,   440,   441,   186,    36,    37,   442,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   188,   189,   190,
     191,   192,   193,   194,   195,   196,     0,     0,   197,   198,
       0,     0,     0,     0,   199,   200,   201,   202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   203,   204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,   206,
     207,   208,   209,   210,   211,   212,   213,   214,     0,   215,
     216,     0,     0,     0,     0,     0,     0,   217,   443,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,     0,     0,     0,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,     0,     0,     0,     0,
       0,   178,   179,   180,   181,   182,   183,   184,   185,   186,
      36,    37,   187,    39,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,   191,   192,   193,   194,   195,
     196,     0,     0,   197,   198,     0,     0,     0,     0,   199,
     200,   201,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,     0,   215,   216,     0,     0,     0,     0,
       0,     0,   217,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,     0,     0,     0,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
       0,     0,     0,     0,     0,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   262,     0,   187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,   190,   191,
     192,   193,   194,   195,   196,     0,     0,   197,   198,     0,
       0,     0,     0,   199,   200,   201,   202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,    58,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,   215,   216,
       0,     0,     0,     0,     0,     0,   217,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,     0,     0,     0,   168,   169,   170,   171,   172,   173,
     174,   175,   176,   177,     0,     0,     0,     0,     0,   178,
     179,   180,   181,   182,   183,   184,   185,   186,     0,     0,
     187,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,   191,   192,   193,   194,   195,   196,     0,
       0,   197,   198,     0,     0,     0,     0,   199,   200,   201,
     202,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,    58,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,     0,   215,   216,     0,     0,     0,     0,     0,     0,
     217,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,     0,     0,     0,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,     0,     0,
       0,     0,     0,   178,   179,   180,   181,   182,   183,   184,
     185,   186,     0,     0,   187,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,   191,   192,   193,
     194,   195,   196,     0,     0,   197,   198,     0,     0,     0,
       0,   199,   200,   201,   202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,   215,   216,     4,     5,
       6,     0,     8,     0,   217,     0,     9,    10,     0,     0,
       0,    11,     0,    12,    13,    14,   270,   271,    17,    18,
       0,     0,     0,     0,     0,    19,    20,   272,    22,    23,
      24,    25,     0,     0,   227,     0,     0,     0,     0,     0,
       0,   302,     0,     0,    31,    32,    33,    34,    35,    36,
      37,    38,    39,     0,    40,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   303,     0,     0,   230,    53,    54,
      55,     0,     0,     0,     0,    57,    58,    59,    60,    61,
      62,    63,    64,    65,     0,     0,     4,     5,     6,     0,
       8,     0,     0,     0,     9,    10,     0,     0,     0,    11,
       0,    12,    13,    14,   270,   271,    17,    18,     0,     0,
       0,     0,   304,    19,    20,   272,    22,    23,    24,    25,
     305,     0,   227,     0,     0,     0,     0,     0,     0,   302,
       0,     0,    31,    32,    33,    34,    35,    36,    37,    38,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   303,     0,     0,   230,    53,    54,    55,     0,
       0,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,    65,     0,     0,     4,     5,     6,     0,     8,     0,
       0,     0,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,    15,    16,    17,    18,     0,     0,     0,     0,
     304,    19,    20,    21,    22,    23,    24,    25,   608,     0,
     227,     0,     0,     0,     0,     0,     0,    28,     0,     0,
      31,    32,    33,    34,    35,    36,    37,    38,    39,   228,
      40,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,    50,     0,     0,     0,     0,     0,     0,
     229,     0,     0,   230,    53,    54,    55,     0,   231,   232,
     233,    57,    58,   234,    60,    61,    62,    63,    64,    65,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     4,     5,     6,     0,     8,    66,   235,
      68,     9,    10,     0,     0,   259,    11,     0,    12,    13,
      14,    15,    16,    17,    18,     0,     0,     0,     0,     0,
      19,    20,    21,    22,    23,    24,    25,     0,     0,    26,
       0,     0,     0,     0,     0,     0,    28,     0,     0,    31,
      32,    33,    34,    35,    36,    37,    38,    39,     0,    40,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,    48,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,    50,     0,     0,     0,     0,     0,     0,   229,
       0,     0,   230,    53,    54,    55,     0,     0,     0,     0,
      57,    58,    59,    60,    61,    62,    63,    64,    65,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       3,     0,     4,     5,     6,     7,     8,    66,    67,    68,
       9,    10,     0,     0,   259,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,     0,     0,     0,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,    27,    28,     0,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,    51,     0,
       0,    52,    53,    54,    55,     0,    56,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
     404,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,    66,    67,    68,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,     0,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,    66,    67,    68,    19,
      20,    21,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,   228,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,   231,   232,   233,    57,
      58,   234,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,    66,   235,    68,    19,
      20,    21,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,   228,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,   479,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,   231,   232,   233,    57,
      58,   234,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,   228,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,   231,   232,   233,    57,
      58,   234,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,   228,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,   479,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,   231,   232,   233,    57,
      58,   234,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,   228,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,   231,   232,     0,    57,
      58,   234,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,   228,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,     0,   232,   233,    57,
      58,   234,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,   228,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,     0,   232,     0,    57,
      58,   234,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,    66,   235,    68,    19,
      20,    21,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,   795,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,    66,   235,    68,    19,
      20,    21,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   806,     0,
       0,   230,    53,    54,    55,     0,   795,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,   967,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,  1016,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,   795,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,  1136,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,     0,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,    66,   235,    68,    19,
      20,    21,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,     0,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,    66,   235,    68,    19,
      20,    21,    22,    23,    24,    25,     0,     0,    26,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,     0,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,    66,    67,    68,    19,
      20,    21,    22,    23,    24,    25,     0,     0,   777,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,     0,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
      15,    16,    17,    18,     0,     0,    66,   235,    68,    19,
      20,    21,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   806,     0,
       0,   230,    53,    54,    55,     0,     0,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   886,     0,
       0,     0,     0,     0,     0,    28,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      49,    50,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230,    53,    54,    55,     0,     0,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,    66,   235,    68,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,   302,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   303,     0,
       0,   363,    53,    54,    55,     0,   364,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       4,     5,     6,     0,     8,     0,     0,     0,     9,    10,
       0,     0,     0,    11,     0,    12,    13,    14,   270,   271,
      17,    18,     0,     0,     0,     0,   304,    19,    20,   272,
      22,    23,    24,    25,     0,     0,   227,     0,     0,     0,
       0,     0,     0,   302,     0,     0,    31,    32,    33,    34,
      35,    36,    37,    38,    39,     0,    40,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   415,     0,     0,    52,
      53,    54,    55,     0,    56,     0,     0,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,     0,     4,     5,
       6,     0,     8,     0,     0,     0,     9,    10,     0,     0,
       0,    11,     0,    12,    13,    14,   270,   271,    17,    18,
       0,     0,     0,     0,   304,    19,    20,   272,    22,    23,
      24,    25,     0,     0,   227,     0,     0,     0,     0,     0,
       0,   302,     0,     0,    31,    32,    33,   423,    35,    36,
      37,   424,    39,     0,    40,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     425,     0,     0,     0,   426,     0,     0,   230,    53,    54,
      55,     0,     0,     0,     0,    57,    58,    59,    60,    61,
      62,    63,    64,    65,     0,     0,     4,     5,     6,     0,
       8,     0,     0,     0,     9,    10,     0,     0,     0,    11,
       0,    12,    13,    14,   270,   271,    17,    18,     0,     0,
       0,     0,   304,    19,    20,   272,    22,    23,    24,    25,
       0,     0,   227,     0,     0,     0,     0,     0,     0,   302,
       0,     0,    31,    32,    33,   423,    35,    36,    37,   424,
      39,     0,    40,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   426,     0,     0,   230,    53,    54,    55,     0,
       0,     0,     0,    57,    58,    59,    60,    61,    62,    63,
      64,    65,     0,     0,     4,     5,     6,     0,     8,     0,
       0,     0,     9,    10,     0,     0,     0,    11,     0,    12,
      13,    14,   270,   271,    17,    18,     0,     0,     0,     0,
     304,    19,    20,   272,    22,    23,    24,    25,     0,     0,
     227,     0,     0,     0,     0,     0,     0,   302,     0,     0,
      31,    32,    33,    34,    35,    36,    37,    38,    39,     0,
      40,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     303,     0,     0,   363,    53,    54,    55,     0,     0,     0,
       0,    57,    58,    59,    60,    61,    62,    63,    64,    65,
       0,     0,     4,     5,     6,     0,     8,     0,     0,     0,
       9,    10,     0,     0,     0,    11,     0,    12,    13,    14,
     270,   271,    17,    18,     0,     0,     0,     0,   304,    19,
      20,   272,    22,    23,    24,    25,     0,     0,   227,     0,
       0,     0,     0,     0,     0,   302,     0,     0,    31,    32,
      33,    34,    35,    36,    37,    38,    39,     0,    40,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1192,     0,
       0,   230,    53,    54,    55,     0,     0,     0,     0,    57,
      58,    59,    60,    61,    62,    63,    64,    65,     0,     0,
       4,     5,     6,     0,     8,     0,     0,     0,     9,    10,
       0,     0,     0,    11,     0,    12,    13,    14,   270,   271,
      17,    18,     0,     0,     0,     0,   304,    19,    20,   272,
      22,    23,    24,    25,     0,     0,   227,     0,     0,     0,
       0,     0,     0,   302,     0,     0,    31,    32,    33,    34,
      35,    36,    37,    38,    39,     0,    40,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1291,     0,     0,   230,
      53,    54,    55,    22,    23,    24,    25,    57,    58,    59,
      60,    61,    62,    63,    64,    65,     0,     0,     0,    31,
      32,    33,  1079,     0,     0,     0,  1080,     0,     0,    40,
      41,    42,    43,    44,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   304,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1082,  1083,     0,     0,     0,     0,     0,     0,  1084,
       0,     0,  1085,     0,  1086,  1087,     0,     0,     0,     0,
      57,    58,    59,    60,    61,    62,    63,    64,    65,     0,
       0,     0,     0,     0,   700,   639,     0,     0,   701,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1090,     0,     0,     0,     0,     0,     0,   304,   188,   189,
     190,   191,   192,   193,   194,   195,   196,     0,     0,   197,
     198,     0,     0,     0,     0,   199,   200,   201,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,     0,
     215,   216,   703,   647,     0,     0,   704,     0,   217,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,   190,   191,
     192,   193,   194,   195,   196,     0,     0,   197,   198,     0,
       0,     0,     0,   199,   200,   201,   202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,   215,   216,
     700,   639,     0,     0,   720,     0,   217,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,   191,   192,   193,
     194,   195,   196,     0,     0,   197,   198,     0,     0,     0,
       0,   199,   200,   201,   202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,   215,   216,   731,   639,
       0,     0,   732,     0,   217,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,   191,   192,   193,   194,   195,
     196,     0,     0,   197,   198,     0,     0,     0,     0,   199,
     200,   201,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,     0,   215,   216,   734,   647,     0,     0,
     735,     0,   217,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,   191,   192,   193,   194,   195,   196,     0,
       0,   197,   198,     0,     0,     0,     0,   199,   200,   201,
     202,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,     0,   215,   216,   850,   639,     0,     0,   851,     0,
     217,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
     190,   191,   192,   193,   194,   195,   196,     0,     0,   197,
     198,     0,     0,     0,     0,   199,   200,   201,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,     0,
     215,   216,   853,   647,     0,     0,   854,     0,   217,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,   190,   191,
     192,   193,   194,   195,   196,     0,     0,   197,   198,     0,
       0,     0,     0,   199,   200,   201,   202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,   215,   216,
     859,   639,     0,     0,   860,     0,   217,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,   191,   192,   193,
     194,   195,   196,     0,     0,   197,   198,     0,     0,     0,
       0,   199,   200,   201,   202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,   215,   216,   685,   647,
       0,     0,   686,     0,   217,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,   191,   192,   193,   194,   195,
     196,     0,     0,   197,   198,     0,     0,     0,     0,   199,
     200,   201,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,     0,   215,   216,  1022,   639,     0,     0,
    1023,     0,   217,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     188,   189,   190,   191,   192,   193,   194,   195,   196,     0,
       0,   197,   198,     0,     0,     0,     0,   199,   200,   201,
     202,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   203,   204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   205,   206,   207,   208,   209,   210,   211,   212,   213,
     214,     0,   215,   216,  1025,   647,     0,     0,  1026,     0,
     217,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
     190,   191,   192,   193,   194,   195,   196,     0,     0,   197,
     198,     0,     0,     0,     0,   199,   200,   201,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   203,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,     0,
     215,   216,  1310,   639,     0,     0,  1311,     0,   217,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,   190,   191,
     192,   193,   194,   195,   196,     0,     0,   197,   198,     0,
       0,     0,     0,   199,   200,   201,   202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,     0,   215,   216,
    1313,   647,     0,     0,  1314,     0,   217,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,   191,   192,   193,
     194,   195,   196,     0,     0,   197,   198,     0,     0,     0,
       0,   199,   200,   201,   202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   203,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,     0,   215,   216,  1358,   639,
       0,     0,  1359,     0,   217,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,   191,   192,   193,   194,   195,
     196,     0,     0,   197,   198,     0,     0,     0,     0,   199,
     200,   201,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   203,   204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,   206,   207,   208,   209,   210,   211,
     212,   213,   214,     0,   215,   216,     0,     0,     0,     0,
       0,     0,   217
};

static const yytype_int16 yycheck[] =
{
       1,   116,    59,   103,   104,   107,    70,   107,    58,    56,
     101,    70,    58,    13,    14,     1,   565,    89,   399,     7,
     401,   252,   408,   768,   115,   400,   426,     1,   348,    67,
      15,    16,   574,    27,   761,    52,    53,    15,    16,    27,
     477,   838,    89,   344,   611,   597,   469,   348,   107,    21,
     597,    52,    53,    15,    16,    56,   595,     7,    56,   598,
     344,   108,   109,   110,   348,   111,    52,    53,    54,    55,
      58,   255,    72,   601,   455,   848,   469,    27,   515,   104,
     525,   296,   107,   761,   477,   300,   763,    52,    89,   512,
      81,   472,    54,   474,    80,    81,    26,    84,   473,    66,
      63,    64,    65,    15,    16,   626,   907,   108,   109,   110,
     111,   905,    84,    13,  1165,     0,   285,    25,    25,  1028,
     818,   502,    25,   111,   689,   690,   113,   112,    15,    16,
    1181,  1284,   320,   321,   112,  1276,    26,    29,   154,   678,
       0,  1165,    69,   159,   100,   154,    25,   528,    10,    81,
     112,    25,   527,  1189,  1190,  1179,   247,   101,   723,    25,
     260,   261,   605,   608,   585,   824,   101,    54,    55,    66,
     591,    98,   719,   832,   290,    25,    25,   234,   134,   763,
     100,   100,   151,    69,   100,   287,   277,   763,   943,    56,
     774,    25,   768,    25,   363,    26,   758,    28,  1153,   761,
     112,  1354,   751,   752,   161,  1346,    68,    37,    38,    28,
     653,   155,    98,   230,   134,   134,   659,   660,   134,   310,
     155,   151,   119,   287,    27,   112,   134,    13,   287,   230,
    1139,   123,    13,   305,   155,   120,   155,   337,   338,   339,
     340,   157,   342,   343,   230,  1296,   154,   155,   155,  1300,
     158,  1302,   155,   484,   154,   155,  1001,   134,   305,   245,
     160,   151,  1298,  1064,    13,   266,   252,   157,   285,   255,
     255,  1065,   257,   971,   711,   675,   155,   255,  1302,   257,
     266,   155,   273,   274,   285,   666,   709,   273,   274,   155,
     665,   157,   266,   255,   822,   257,   677,    13,  1053,   285,
     272,   676,    13,   275,   305,   155,   155,    13,   157,   409,
    1361,   413,   337,   338,   339,   340,   709,   364,   711,   858,
     285,   155,    34,   155,   154,   425,   847,   418,  1005,  1284,
    1085,   100,  1087,  1288,   335,   451,  1086,   304,  1293,   782,
      52,  1138,   274,   786,   100,   257,   363,    25,    52,  1027,
    1028,   154,    56,   541,   413,   543,   905,   160,   907,    66,
     805,   335,   363,   364,   480,  1138,   364,   483,   154,   911,
     257,   923,   488,   154,   160,   307,   923,   363,   134,   160,
     945,   946,   101,   134,   409,    13,   951,   952,   955,   505,
     154,  1027,  1028,   410,   411,  1350,   160,  1352,   363,  1354,
     425,  1356,   403,   846,   827,   154,   849,    58,   157,   410,
     411,   160,   119,   401,   400,   400,   100,   403,  1373,  1003,
     863,  1005,   400,  1007,   410,   411,    66,    78,   100,  1005,
     402,    13,  1187,  1188,   827,   154,   112,   976,   154,  1189,
    1190,   157,   428,   154,   160,    13,   993,   155,   154,   160,
     134,   100,   134,   525,   160,    13,   134,   108,   109,  1027,
    1028,  1139,   134,   579,   295,   296,   451,   455,   699,   300,
    1035,   302,   157,   451,    34,   157,   154,   155,   525,   763,
     158,   121,   122,   455,   768,   134,   474,   473,   473,   451,
     141,   607,    52,   914,   915,   473,   482,   918,   484,   920,
     494,   922,    25,  1139,  1182,    69,   494,   508,    78,   932,
      15,  1189,  1190,   728,   502,  1064,  1065,    69,    56,   962,
      25,   161,   965,   134,   525,   709,   154,  1082,  1083,   972,
      69,   548,   160,    97,    98,   978,   608,   596,   109,   451,
     528,   527,   527,  1288,   494,    97,    98,   548,  1345,   527,
     100,    98,   740,   554,   991,  1282,   100,   745,   939,    98,
     941,   608,   548,   155,   451,   940,  1150,   683,   606,  1153,
     141,  1139,   154,   611,   144,   145,   146,  1153,   160,   679,
     554,   101,   469,   969,   134,   571,   154,   611,   574,   153,
     134,  1153,   160,   157,   595,   157,   154,   598,   991,   658,
     100,   153,   160,   100,  1282,  1350,   153,   608,   100,   595,
     157,   134,   598,  1056,  1182,   715,   594,   157,  1157,   597,
    1298,  1189,  1190,    52,   155,   512,   100,    56,   100,  1184,
    1185,   154,   155,   154,   157,   158,   157,   134,   655,   755,
     657,   152,   134,   154,   606,  1066,  1067,  1068,  1069,   611,
      78,   689,   690,   884,   655,   642,   657,   729,   155,   645,
     134,  1047,   134,   650,   650,   689,   690,    69,   157,   655,
     642,   657,    25,  1215,   994,  1217,    69,   678,   666,   665,
     665,  1153,   729,   155,  1084,   723,   134,   665,   738,   677,
     676,   676,   678,   994,    69,    97,    98,   691,   676,   723,
    1284,   688,   688,   691,    97,    98,    69,   155,  1284,  1293,
     994,    78,  1288,   699,   142,   143,   144,   145,   146,   100,
    1282,  1005,  1284,    98,   815,    69,  1288,   100,   729,   787,
    1298,  1293,   790,   805,    69,    98,   722,    26,   158,  1278,
    1060,   691,  1128,   702,    66,    67,    69,   134,   864,   721,
     159,   153,   867,   134,    98,   855,   152,   857,   805,  1060,
     153,   134,    97,    98,    15,  1208,    17,   883,  1352,   885,
    1354,    56,  1356,    66,   733,    98,  1060,   740,  1354,   742,
      69,   134,   745,   746,    26,  1327,  1186,   903,  1350,  1373,
    1352,   157,  1354,  1214,  1356,    69,   627,   856,    66,   121,
     122,   154,   155,   100,   805,   158,    69,    69,    97,    98,
    1282,  1373,  1284,   644,  1027,  1028,  1288,    26,   153,   865,
    1206,  1293,   709,    97,    98,   155,   119,    69,   121,   122,
     855,   124,   857,    54,    97,    98,    98,   134,    69,    78,
     928,    69,   930,    64,    65,   154,    69,   161,   834,   158,
     836,   119,   838,   121,   122,    97,    98,   858,   155,   599,
      69,   961,   151,   603,   153,   100,    69,    98,   157,  1153,
      98,   702,   858,  1086,    97,    98,    69,   865,  1350,   153,
    1352,  1324,  1354,   100,  1356,   151,  1267,   134,    97,    98,
    1103,  1266,   892,   852,    97,    98,   134,   728,   884,   134,
     134,  1373,   733,   862,    97,    98,  1296,   945,   946,   151,
    1300,   153,   106,   951,   952,   157,   975,   134,   977,   155,
     155,   945,   946,    69,    56,   911,  1139,   951,   952,    30,
     153,    37,    38,    66,   160,    69,   961,   100,   155,    69,
     827,    25,   151,   960,   153,   923,   777,   138,   157,  1162,
     153,    97,    98,   941,   940,   940,   155,    69,   155,   960,
     153,   134,   940,    97,    98,   152,  1179,    97,    98,   955,
      69,   134,   154,   155,   960,   976,  1189,  1190,   995,    83,
      84,   158,  1020,   134,    69,    97,    98,     1,   121,   122,
     976,   124,   155,   955,   995,   155,  1020,  1035,    97,    98,
    1284,    15,    16,   158,  1288,   154,   155,   153,   155,   995,
     155,  1035,    97,    98,  1014,  1015,   155,  1018,  1019,   153,
     155,   852,    52,   153,    14,    15,  1027,  1028,   155,    58,
     155,   862,  1089,   137,   138,  1052,  1179,   134,    52,    53,
    1090,   153,    56,    78,  1018,  1019,  1189,  1190,    52,    78,
     152,  1052,   155,    67,   153,   886,  1042,    55,  1044,   155,
      95,    96,    89,    90,    13,  1024,  1052,    17,   153,    25,
    1354,   152,  1188,    40,    41,    89,  1176,   154,   155,   108,
    1127,  1082,  1083,   112,   155,  1086,  1072,  1073,   155,   103,
     104,   306,   307,   107,   108,   109,   110,  1199,   112,    44,
     134,    44,  1103,  1194,   139,   140,   141,   142,   143,   144,
     145,   146,   152,   155,    66,  1231,   155,  1134,  1135,    44,
      56,    54,    55,  1140,    57,  1241,  1127,  1086,    44,   134,
    1131,    64,    65,  1134,  1135,  1199,   136,  1154,  1139,  1140,
    1199,   159,  1258,  1259,  1260,  1131,   924,   925,  1134,  1135,
       8,  1176,  1138,  1154,  1140,   933,  1157,    52,   936,    15,
     938,  1162,   155,   264,  1165,   152,   155,   119,  1154,   121,
     122,  1157,   124,  1273,  1274,   155,   155,   155,  1179,  1226,
    1181,  1198,   155,  1184,  1185,   155,   689,   690,  1189,  1190,
     155,  1248,   155,  1024,   101,  1212,     9,  1198,    66,   139,
     155,    52,   705,   706,   139,  1164,    52,     1,  1167,   155,
     152,  1212,  1198,    66,   155,  1201,   230,   155,   101,    66,
     723,    15,    16,    56,   158,  1226,  1212,   139,  1187,  1215,
     228,  1217,   160,   231,   232,   233,    59,    60,    61,    62,
    1287,   255,   155,   257,  1245,   155,   260,   261,  1273,  1274,
     155,   119,   266,   121,   122,  1086,  1087,   155,    52,    53,
     361,   155,   155,   155,   155,   366,   119,   152,   121,   122,
      56,   285,   119,    67,   121,   122,   155,  1278,   155,  1267,
    1266,  1266,  1268,   155,  1270,   155,  1287,    66,  1266,   155,
     157,   305,  1278,   157,   155,  1296,   504,   266,   335,  1300,
    1317,  1302,  1261,  1262,  1263,  1131,   508,   106,   865,   103,
     104,  1142,   606,   107,   110,   108,  1317,    78,   112,   495,
      98,   335,   956,   337,   338,   339,   340,   688,   342,   343,
     975,  1317,  1201,  1164,    95,    96,  1167,   751,   905,  1282,
     119,  1327,   121,   122,    40,    41,    42,    43,    44,   363,
     364,  1224,  1153,  1312,  1288,  1073,  1187,   458,   459,  1345,
    1361,    78,  1223,  1346,  1027,  1028,   467,   868,   359,  1345,
    1245,  1182,   875,  1182,   475,   476,  1178,  1268,    95,    96,
     141,   142,   143,   144,   145,   146,   400,  1270,   119,   403,
     543,   111,  1223,   761,   495,   409,   410,   411,   768,   115,
    1340,    52,   503,    54,    55,    56,    57,    -1,    -1,    -1,
      -1,   425,    52,    -1,    54,    55,    56,    57,    58,  1082,
    1083,    -1,    -1,  1086,    -1,   142,   143,   144,   145,   146,
    1261,  1262,  1263,    -1,    -1,    -1,   230,   451,    78,    -1,
    1103,    -1,   945,   946,    -1,    -1,    -1,    -1,   951,   952,
      -1,   102,    92,    -1,    -1,    -1,   107,    -1,    -1,   473,
      -1,   255,   102,   257,    -1,    -1,   260,   261,   108,   109,
     468,   469,   266,    -1,    -1,    52,  1139,    54,    55,   477,
      57,  1312,   985,   986,    -1,   988,   989,    -1,    -1,    -1,
    1321,   285,    -1,    52,   508,    54,    55,    56,    57,  1162,
      -1,   141,  1165,    52,    -1,    54,    55,    56,    57,  1340,
      -1,   525,    -1,   527,   512,    -1,  1179,   515,  1181,    -1,
      -1,  1184,  1185,    -1,    -1,   102,  1189,  1190,    -1,    -1,
      -1,    -1,  1035,    52,   548,    54,    55,    56,    57,    -1,
     554,   335,    -1,   337,   338,   339,   340,    -1,   342,   343,
      -1,   652,    -1,   102,    -1,    -1,  1059,    -1,    -1,    -1,
      -1,  1225,    -1,  1227,    -1,    -1,    -1,    -1,    -1,   363,
      52,    -1,    54,    55,    56,    57,    58,    -1,    -1,    -1,
     594,   595,  1245,   597,   598,    -1,    -1,    -1,   586,    -1,
      -1,   692,   606,    -1,   608,    -1,    78,   611,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,   606,   403,
      -1,    -1,    -1,   611,    -1,   409,   410,   411,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,   108,   109,    -1,    -1,
      -1,   425,    -1,  1296,    -1,    -1,    -1,  1300,    -1,  1302,
      -1,   655,    -1,   657,    -1,    -1,    -1,    -1,    44,    -1,
      -1,   665,    -1,    -1,    -1,    -1,    -1,   451,    -1,   141,
      -1,    -1,   676,    -1,   678,   679,  1330,  1331,    -1,    -1,
    1334,  1335,    -1,    -1,  1338,   689,   690,    -1,    -1,   473,
      -1,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,   693,    -1,    -1,  1361,    95,
      96,   715,    -1,  1367,  1368,  1369,  1370,    -1,    -1,   723,
      -1,   709,  1376,   711,   508,   729,    -1,    -1,    -1,   820,
     821,    -1,    -1,    -1,    -1,    -1,    -1,   828,   829,    -1,
      -1,    -1,    52,   527,    54,    55,    56,    57,    58,   135,
      -1,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,    -1,    -1,    -1,   548,    -1,    -1,    -1,    78,   155,
     554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   767,
      -1,    -1,    92,    -1,    -1,    -1,    -1,   878,   879,    -1,
     881,   882,   102,    -1,    -1,    -1,    -1,   107,   108,   109,
      -1,   805,    -1,    -1,    -1,    -1,    -1,   795,    -1,    -1,
     594,   595,    -1,   597,   598,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   606,    -1,    -1,    -1,    -1,   611,    -1,    -1,
      -1,   141,    -1,    -1,   144,    -1,    -1,    -1,    -1,   827,
      -1,    -1,    -1,    -1,    -1,    -1,   937,   157,     1,    -1,
      -1,   855,    -1,   857,   858,    -1,    -1,   845,    -1,   950,
      -1,    -1,    15,    16,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   655,    52,   657,    54,    55,    56,    57,    58,    -1,
      -1,   665,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   676,    -1,   678,   679,   987,    -1,    78,    52,
      53,    -1,    -1,    -1,    -1,   689,   690,    -1,    -1,    -1,
      -1,    -1,    92,    -1,    67,    -1,    -1,    -1,    -1,   923,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,   108,   109,
      -1,   715,    -1,    -1,    -1,    -1,   940,    -1,    -1,   723,
      -1,   945,   946,    -1,   932,    -1,    -1,   951,   952,    -1,
     103,   104,    -1,    -1,   107,    -1,   960,   961,    -1,   112,
      -1,   141,    -1,    -1,   144,    -1,    -1,   955,    -1,    -1,
      -1,    -1,   976,    -1,    -1,    -1,    -1,    -1,    -1,   967,
      25,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   995,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   991,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1018,  1019,  1020,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1016,    -1,
      -1,  1035,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    -1,    -1,  1052,    -1,
      95,    96,    -1,    -1,    -1,    52,   101,    54,    55,    56,
      57,    58,    -1,  1051,    -1,    -1,  1027,  1028,     1,    -1,
      -1,   855,    -1,   857,   858,    -1,    -1,   230,    -1,    -1,
    1171,    78,    15,    16,    -1,    -1,    -1,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   255,    -1,   257,   102,    -1,   260,   261,    -1,
     107,   108,   109,   266,    -1,    -1,    -1,    -1,    -1,    52,
      53,  1082,  1083,  1127,    -1,  1086,    -1,  1131,    -1,    -1,
    1134,  1135,   285,    -1,    67,    -1,  1140,    -1,    -1,   923,
      -1,    -1,  1103,    -1,   141,    -1,    -1,   144,  1136,    -1,
    1154,    -1,    -1,  1157,    -1,    -1,   940,    -1,    -1,    -1,
      -1,   945,   946,    -1,    -1,    -1,    -1,   951,   952,    -1,
     103,   104,  1176,    -1,   107,    -1,   960,   961,  1139,   112,
      -1,    -1,   335,    -1,   337,   338,   339,   340,    -1,   342,
     343,    -1,   976,    -1,  1198,    -1,    -1,    -1,    -1,    -1,
      -1,  1162,    -1,    -1,  1165,    -1,    -1,    -1,  1212,    -1,
     363,   995,    -1,    -1,    -1,    -1,    -1,    -1,  1179,    -1,
    1181,    -1,  1226,  1184,  1185,    -1,    -1,    -1,  1189,  1190,
      -1,    -1,    -1,    -1,  1018,  1019,  1020,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,
     403,  1035,    -1,    -1,    -1,    -1,   409,   410,   411,    -1,
      -1,    -1,  1266,    -1,    -1,    -1,    -1,    -1,  1052,  1273,
    1274,    -1,   425,    -1,  1278,    52,    53,    -1,    -1,    56,
      -1,    -1,    -1,  1287,  1245,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,   451,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    -1,
      87,    88,    -1,  1317,    -1,    -1,    93,    94,    95,    96,
     473,    -1,   255,    -1,   257,    -1,    -1,   260,   261,    -1,
     107,   108,    -1,   266,    -1,  1296,    -1,    -1,    -1,  1300,
      -1,  1302,    -1,    -1,    -1,    -1,    -1,  1131,    -1,    -1,
    1134,  1135,   285,    -1,    -1,   508,  1140,    -1,    -1,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
    1154,   148,   149,  1157,   527,    -1,    -1,    -1,    -1,   156,
     157,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1176,    -1,    -1,   548,    -1,    -1,    -1,    -1,
    1361,   554,   335,    -1,   337,   338,   339,   340,    -1,   342,
     343,    -1,    -1,    -1,  1198,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1212,    -1,
     363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   594,   595,    -1,   597,   598,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   606,    -1,    -1,    -1,    -1,   611,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,
     403,    -1,    -1,    -1,    -1,    -1,   409,   410,   411,    -1,
      -1,    -1,  1266,    -1,    -1,    -1,    -1,    -1,    -1,  1273,
    1274,    -1,   425,    -1,  1278,    -1,  1027,  1028,    -1,    -1,
      -1,    -1,   655,    -1,   657,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   665,    -1,    -1,    -1,    -1,    -1,   451,    -1,
      -1,    -1,    -1,   676,    -1,   678,   679,    -1,    -1,    -1,
      -1,    -1,    -1,  1317,    -1,    -1,   689,   690,    -1,    -1,
     473,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1082,  1083,    -1,    -1,  1086,    -1,    -1,    -1,    -1,
      -1,    -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     723,    -1,  1103,    -1,    -1,   508,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   527,    -1,    -1,    -1,    15,    16,
      -1,  1027,  1028,    -1,    -1,    -1,    -1,    -1,  1139,    -1,
      -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,    -1,
      -1,   554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1162,    -1,    -1,  1165,    52,    53,    -1,    -1,    56,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1179,    -1,
    1181,    -1,    -1,  1184,  1185,    -1,  1082,  1083,  1189,  1190,
    1086,   594,   595,    -1,   597,   598,    -1,    -1,    -1,    -1,
      -1,    -1,    89,   606,    -1,    -1,    -1,  1103,   611,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   108,   109,   110,    -1,   112,    -1,    -1,    -1,    -1,
      -1,    -1,   855,    -1,   857,   858,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1139,  1245,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   655,    -1,   657,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   665,    -1,    -1,    -1,  1162,    -1,    -1,  1165,
      -1,    -1,    -1,   676,    -1,   678,   679,    -1,    -1,    -1,
      -1,    -1,    -1,  1179,    -1,  1181,   689,   690,  1184,  1185,
      -1,    -1,    -1,  1189,  1190,  1296,    -1,    -1,    -1,  1300,
     923,  1302,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   715,    -1,    -1,    -1,    -1,   940,    -1,    -1,
     723,    -1,   945,   946,    -1,    -1,  1027,  1028,   951,   952,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   960,   961,    -1,
      -1,    -1,    -1,   230,    -1,    -1,    -1,    -1,    -1,  1245,
      -1,    -1,    -1,   976,    -1,    -1,    -1,    -1,    -1,    -1,
    1361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   255,    -1,
     257,    -1,   995,    -1,    -1,    -1,    -1,    -1,    -1,   266,
      -1,  1082,  1083,    -1,    -1,  1086,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1018,  1019,  1020,   285,    -1,
    1296,    -1,  1103,    -1,  1300,    -1,  1302,    -1,    -1,    -1,
      -1,    -1,  1035,    -1,    33,    34,    35,    36,   305,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1052,
      49,    50,    51,    -1,    -1,    -1,    -1,    -1,  1139,    -1,
      59,    60,    61,    62,    63,    -1,    -1,    -1,   335,    -1,
    1027,  1028,   855,    -1,   857,   858,    -1,    -1,    -1,    -1,
      -1,  1162,    -1,    -1,  1165,  1361,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   363,   364,  1179,    -1,
    1181,    -1,    -1,  1184,  1185,    -1,    -1,    -1,  1189,  1190,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,  1082,  1083,    -1,  1131,  1086,
      -1,  1134,  1135,   400,    -1,    -1,   403,  1140,    -1,    -1,
     923,    -1,    -1,   410,   411,    -1,  1103,    -1,   147,    -1,
      -1,  1154,    -1,    -1,  1157,  1027,  1028,   940,    -1,    -1,
      -1,    -1,   945,   946,  1245,    -1,    -1,    -1,   951,   952,
      -1,    -1,    -1,  1176,    -1,    -1,    -1,   960,   961,    -1,
      -1,    -1,  1139,    -1,   451,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   976,    -1,  1198,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1162,   473,    -1,  1165,  1212,
    1082,  1083,   995,    -1,  1086,  1296,    -1,    -1,    -1,  1300,
      -1,  1302,  1179,    -1,  1181,    -1,    -1,  1184,  1185,    -1,
      -1,  1103,  1189,  1190,    -1,  1018,  1019,  1020,    -1,    -1,
      -1,   508,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,
      -1,    -1,  1035,    -1,    -1,    -1,    -1,    -1,   525,    -1,
     527,    15,    16,  1266,    -1,    -1,    -1,  1139,    -1,  1052,
    1273,  1274,    -1,    -1,    -1,  1278,    -1,    -1,    -1,    -1,
    1361,   548,    -1,    -1,    -1,    -1,    -1,   554,  1245,    -1,
    1162,    -1,    -1,  1165,    -1,    -1,    -1,    -1,    52,    53,
      -1,    -1,    56,    -1,    -1,    -1,    -1,  1179,    -1,  1181,
      -1,    -1,  1184,  1185,  1317,    -1,    -1,  1189,  1190,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   595,    -1,
      -1,   598,    -1,    -1,    -1,    89,    -1,    -1,    -1,  1296,
      -1,   608,    -1,  1300,   611,  1302,    -1,    -1,  1131,    -1,
      -1,  1134,  1135,    -1,   108,   109,   110,  1140,   112,    -1,
      -1,  1027,  1028,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1154,    -1,  1245,  1157,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   655,    -1,
     657,    -1,    -1,  1176,    -1,  1027,  1028,    -1,   665,    -1,
      -1,    -1,    -1,    -1,  1361,    -1,    -1,    -1,    -1,   676,
      -1,   678,    -1,    -1,    -1,  1198,  1082,  1083,    -1,    -1,
    1086,    -1,   689,   690,  1296,    -1,    -1,    -1,  1300,  1212,
    1302,    -1,    -1,    -1,    -1,    -1,    -1,  1103,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1082,  1083,    -1,    -1,  1086,    -1,   723,    -1,    -1,    -1,
      -1,    -1,   729,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1103,    -1,  1139,    -1,    -1,   230,    -1,    -1,    -1,
      -1,    -1,    -1,  1266,    -1,    -1,    -1,    -1,    -1,  1361,
    1273,  1274,    -1,    -1,    -1,  1278,  1162,    -1,    -1,  1165,
      -1,   255,    -1,   257,    -1,    -1,    -1,  1139,    -1,    -1,
      -1,    -1,   266,  1179,    -1,  1181,    -1,    -1,  1184,  1185,
      -1,    -1,    -1,  1189,  1190,    44,    -1,    -1,    -1,    -1,
    1162,   285,    -1,  1165,  1317,    -1,    -1,    -1,   805,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1179,    -1,  1181,
      -1,   305,  1184,  1185,    -1,    -1,    -1,  1189,  1190,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    -1,    -1,    -1,    -1,    95,    96,    -1,  1245,
      -1,   335,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   858,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,    -1,    -1,  1245,     1,    -1,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
    1296,    -1,    -1,    -1,  1300,    -1,  1302,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,   403,
      -1,    -1,    -1,    -1,    -1,    -1,   410,   411,    -1,    -1,
      -1,    -1,    -1,    -1,  1296,    52,    53,    -1,  1300,    56,
    1302,    -1,    -1,   940,    -1,    -1,    -1,    -1,   945,   946,
      -1,    -1,    -1,    -1,   951,   952,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   960,    -1,  1361,    -1,   451,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,   976,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   473,
      -1,   108,   109,   110,    -1,    -1,    -1,    -1,   995,  1361,
      -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    56,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1018,  1019,  1020,   508,    -1,    -1,    -1,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,  1035,    87,
      88,   525,    -1,   527,    -1,    93,    94,    95,    96,    -1,
      -1,    -1,    -1,    -1,    -1,  1052,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,   548,    -1,    -1,    -1,    -1,    -1,
     554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
     148,   149,    -1,    -1,    -1,    -1,    -1,    -1,   156,    -1,
      -1,   595,     1,   230,   598,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   608,    -1,    -1,   611,    -1,    -1,
    1127,    -1,    -1,    -1,  1131,    -1,    -1,  1134,  1135,    -1,
      -1,    -1,    -1,  1140,    -1,    -1,    -1,    -1,    -1,   266,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1154,    -1,    -1,
    1157,    -1,    -1,    52,    53,    -1,    -1,    56,   285,    -1,
      -1,   655,    -1,   657,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   665,    -1,    -1,    -1,    -1,    -1,    -1,   305,    -1,
      -1,    -1,   676,    -1,   678,    -1,    -1,    -1,    -1,    -1,
      89,  1198,    -1,    -1,    -1,   689,   690,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1212,    -1,    -1,   335,   108,
     109,   110,   111,    -1,    -1,    -1,    -1,    -1,    -1,  1226,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   723,
      -1,    -1,    -1,    -1,    -1,   729,   363,   364,    -1,    -1,
      -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1266,
      78,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      88,  1278,    -1,    -1,    -1,    -1,   403,    95,    96,    -1,
    1287,    -1,    -1,   410,   411,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1317,   805,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
      -1,   230,    -1,    -1,     0,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     8,     9,    10,    -1,    -1,    13,    14,    15,
     108,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,
      26,    27,    -1,    -1,   858,    -1,     1,   266,    -1,    -1,
      -1,    37,    38,    -1,    40,    41,    42,    43,    44,    -1,
      -1,   508,    -1,    -1,    -1,    -1,   285,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   525,    -1,
      -1,    -1,    68,    69,    -1,    -1,   305,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    52,    53,    -1,
      -1,   548,    -1,    -1,    -1,    -1,    -1,   554,    -1,    -1,
      -1,    97,    98,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   940,    -1,    -1,    -1,
      -1,   945,   946,    -1,   120,    -1,    -1,   951,   952,    -1,
      -1,    -1,    -1,    -1,   363,   364,   960,    -1,   595,    -1,
      -1,   598,   230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   608,   976,    -1,   611,   151,   152,    -1,   154,    -1,
      -1,   157,   158,    -1,   160,    -1,    -1,    -1,    -1,    -1,
      -1,   995,    -1,    -1,   403,    -1,    -1,    -1,   266,    -1,
      -1,   410,   411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1018,  1019,  1020,   285,   655,    -1,
     657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1035,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   678,    -1,    -1,    -1,    -1,    -1,    -1,  1052,    -1,
      -1,    -1,   689,   690,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   335,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   230,   723,    -1,    -1,    -1,
      -1,    -1,   729,    -1,    -1,   363,    -1,    -1,    -1,   508,
      -1,   738,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   525,    -1,    -1,    -1,
      -1,   266,    -1,  1127,    -1,    -1,    -1,  1131,    -1,    -1,
    1134,  1135,    -1,    -1,    -1,   403,  1140,    -1,    -1,   548,
     285,    -1,   410,   411,    -1,   554,    -1,    -1,    -1,    -1,
    1154,    -1,    -1,  1157,    33,    34,    35,    36,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   805,    -1,
      49,    50,    51,    52,    -1,    -1,    -1,    56,    -1,    -1,
      59,    60,    61,    62,    63,    -1,   595,    -1,    -1,   598,
     335,    -1,    -1,    -1,  1198,    -1,    -1,    -1,    -1,   608,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1212,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,   363,    -1,
      99,   858,  1226,   102,    -1,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
     508,    -1,    -1,    -1,    -1,    -1,   655,    -1,   657,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,    -1,
      -1,   140,  1266,    52,    53,   410,   411,    56,   147,   678,
      -1,    -1,    -1,    -1,  1278,   154,    -1,    -1,    -1,    -1,
     548,    -1,    -1,  1287,    -1,    -1,   554,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    -1,    87,    88,
      -1,    -1,    -1,    -1,    93,    94,    95,    96,   945,   946,
      -1,    -1,    -1,  1317,   951,   952,    -1,    -1,   107,   108,
     729,    -1,    -1,   960,    -1,    -1,    -1,   595,    -1,    -1,
     598,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   976,
      -1,    -1,    -1,   611,    -1,    -1,    -1,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   995,   148,
     149,    -1,    -1,   508,    -1,    -1,    -1,   156,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,  1018,  1019,  1020,    -1,    95,    96,   655,    -1,   657,
      -1,    -1,    -1,    -1,    -1,    -1,   805,    -1,  1035,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,    -1,    -1,   554,
     678,    -1,    -1,    -1,    -1,  1052,    -1,    -1,    -1,    -1,
      -1,   689,   690,    -1,    -1,   135,    -1,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   154,    -1,    -1,    -1,    -1,   858,
     595,    -1,    -1,   598,    -1,   723,    -1,    33,    34,    35,
      36,    -1,    -1,    -1,    -1,    -1,   611,    -1,    -1,    -1,
      -1,    -1,    -1,    49,    50,    51,    52,    -1,    -1,    -1,
      56,    -1,    58,    59,    60,    61,    62,    63,    -1,    -1,
    1127,    -1,    -1,    -1,  1131,    -1,    -1,  1134,  1135,    -1,
      -1,    -1,    78,  1140,    -1,    -1,    -1,    -1,    -1,    -1,
     655,    -1,   657,    -1,    -1,    91,    92,  1154,    -1,    -1,
    1157,    -1,    -1,    99,    -1,    -1,   102,    -1,   104,   105,
      -1,   107,   108,   678,   110,   111,   112,   113,   114,   115,
     116,   117,   118,    -1,   689,   690,    -1,    -1,    -1,    -1,
      -1,   960,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1198,    -1,    -1,   140,    -1,    -1,   976,    -1,    -1,
      -1,   147,    -1,    -1,    -1,  1212,    -1,    -1,   723,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   995,    -1,    -1,  1226,
     858,    -1,    15,    16,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    -1,    -1,  1018,
    1019,    95,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    47,    48,    49,    50,    -1,    -1,
      -1,    54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1278,    -1,  1052,    67,    68,    -1,    -1,    -1,    -1,
    1287,   135,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   945,   946,    -1,
    1317,    -1,    -1,   951,   952,    -1,    -1,    -1,    -1,   112,
      -1,    -1,   960,    -1,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,    -1,   976,    -1,
      -1,    95,    96,   858,    -1,    -1,    -1,    -1,  1127,    -1,
      -1,    -1,  1131,    -1,    -1,  1134,  1135,   995,    -1,    -1,
      -1,  1140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1154,    -1,    -1,  1157,    -1,
    1018,  1019,  1020,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,    -1,    -1,    -1,    -1,  1035,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,
      82,    83,    84,    -1,  1052,    87,    88,    -1,    -1,  1198,
      -1,    -1,    -1,    95,    96,    -1,    -1,    -1,    -1,    -1,
     945,   946,    -1,  1212,    -1,   228,   951,   952,   231,   232,
     233,    -1,   235,    -1,    -1,   960,    -1,  1226,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   976,   255,    -1,   257,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,
     995,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1127,
      -1,    -1,    -1,  1131,    -1,    -1,  1134,  1135,    -1,  1278,
      -1,    -1,  1140,  1018,  1019,  1020,    -1,    -1,  1287,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1154,    -1,    -1,  1157,
    1035,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1052,  1317,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1212,   368,   369,   370,   371,   372,
      -1,    -1,   375,   376,   377,   378,   379,   380,   381,   382,
      -1,   384,    -1,    -1,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,    -1,    -1,   400,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1131,    -1,    -1,  1134,
    1135,    -1,    -1,    -1,    -1,  1140,    -1,    -1,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    87,    88,  1154,
    1278,    -1,  1157,    -1,    -1,    95,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   451,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   468,   469,    -1,    -1,  1317,
     473,    -1,    -1,  1198,   477,    -1,   479,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,  1212,    -1,     0,
      -1,    -1,    -1,    -1,   497,    -1,    -1,     8,     9,    10,
      -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,   512,
      -1,    -1,   515,    -1,    25,    26,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,   527,    -1,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   545,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1278,    -1,    -1,    -1,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      -1,    -1,    -1,   586,    95,    96,    97,    98,    -1,   100,
     101,   594,  1317,    -1,   597,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   606,    -1,    -1,    -1,    -1,   611,   120,
      -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
     151,   152,   153,   154,   155,    -1,    -1,   158,   159,   160,
      -1,    -1,    33,    34,    35,    36,    -1,    -1,    -1,    -1,
      -1,    -1,   665,    -1,    -1,    -1,    -1,    -1,    49,    50,
      51,    52,    -1,   676,    -1,    56,    -1,    -1,    59,    60,
      61,    62,    63,    -1,    -1,    -1,   689,   690,    -1,    -1,
     693,   694,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   705,   706,    -1,    -1,   709,    -1,   711,    -1,
      91,    92,    -1,    -1,    -1,   718,   719,    -1,    99,    -1,
     723,   102,    -1,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,
      -1,    -1,    -1,    -1,   767,    -1,   147,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   795,    -1,    -1,    -1,    -1,    -1,     0,     1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    -1,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,   827,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,
      -1,    -1,   845,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    -1,    59,    60,    61,
      62,    63,    64,    65,    -1,    -1,    68,    -1,    -1,    -1,
      -1,    -1,   875,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,
     102,   103,   104,   105,    -1,   107,    -1,    -1,   110,   111,
     112,   113,   114,   115,   116,   117,   118,    -1,   120,    -1,
     923,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   932,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   940,    -1,    -1,
      -1,   944,   945,   946,    -1,   147,   148,   149,   951,   952,
     152,    -1,   955,    -1,    -1,    -1,   158,    -1,   160,    -1,
      -1,    -1,    -1,    -1,   967,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   985,   986,    -1,   988,   989,    -1,   991,    -1,
     993,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1012,
    1013,    -1,    -1,  1016,    -1,    -1,    -1,  1020,  1021,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1035,    -1,    -1,    -1,    -1,    -1,    -1,     0,
       1,    -1,     3,     4,     5,     6,     7,    -1,  1051,    -1,
      11,    12,    -1,    -1,    -1,    16,  1059,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,  1136,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,    -1,
      -1,     0,     1,   154,     3,     4,     5,     6,     7,   160,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,  1266,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,    -1,    -1,     0,     1,   154,     3,     4,     5,     6,
       7,   160,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,   104,   105,    -1,
     107,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     0,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     8,     9,    10,
      -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,    -1,
     147,   148,   149,    -1,    25,   152,    27,    28,    29,    -1,
      -1,    -1,    -1,   160,    -1,    -1,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    -1,   100,
     101,    -1,    -1,    -1,    -1,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
      -1,   152,   153,   154,   155,     0,    -1,   158,   159,   160,
      -1,    -1,    -1,     8,     9,    10,    -1,    -1,    13,    14,
      15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    -1,    27,    28,    29,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,
      95,    96,    97,    98,    -1,   100,   101,    -1,    -1,    -1,
      -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,    -1,    -1,    -1,    -1,    -1,   152,   153,   154,
     155,     0,    -1,   158,   159,   160,    -1,    -1,    -1,     8,
       9,    10,    -1,    -1,    13,    14,    15,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,    28,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    -1,    -1,    -1,    -1,    95,    96,    97,    98,
      -1,    -1,   101,    -1,    -1,    -1,    -1,   106,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,   151,   152,   153,   154,   155,     0,    -1,   158,
     159,   160,    -1,    -1,    -1,     8,     9,    10,    -1,    -1,
      13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    26,    27,    28,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,
      43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    -1,    -1,
      -1,    -1,    95,    96,    97,    98,    -1,    -1,   101,    -1,
      -1,    -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,   151,   152,
     153,   154,   155,     0,    -1,   158,   159,   160,    -1,    -1,
      -1,     8,     9,    10,    -1,    -1,    13,    14,    15,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,
      27,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    -1,    40,    41,    42,    43,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    -1,    -1,    -1,    -1,    95,    96,
      97,    98,    -1,    -1,   101,    -1,    -1,    -1,    -1,   106,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,   151,   152,   153,   154,   155,     0,
     157,   158,   159,   160,    -1,    -1,    -1,     8,     9,    10,
      -1,    -1,    13,    14,    15,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    -1,    27,    28,    29,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    -1,    -1,
     101,    -1,    -1,    -1,    -1,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
      -1,   152,   153,   154,   155,     0,    -1,   158,   159,   160,
      -1,    -1,    -1,     8,     9,    10,    -1,    -1,    13,    14,
      15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    26,    27,    28,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,
      95,    96,    97,    98,    -1,    -1,   101,    -1,    -1,    -1,
      -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,    -1,    -1,    -1,    -1,   151,   152,   153,   154,
     155,     0,   157,   158,   159,   160,    -1,    -1,    -1,     8,
       9,    10,    -1,    -1,    13,    14,    15,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    -1,    27,    28,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    -1,    -1,    -1,    -1,    95,    96,    97,    98,
      -1,   100,   101,    -1,    -1,    -1,    -1,   106,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,   151,   152,   153,   154,   155,     0,    -1,   158,
     159,   160,    -1,    -1,    -1,     8,     9,    10,    -1,    -1,
      13,    14,    15,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    -1,    27,    28,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    37,    38,    -1,    40,    41,    42,
      43,    44,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    -1,    -1,
      -1,    -1,    95,    96,    97,    98,    -1,    -1,   101,    -1,
      -1,    -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,    -1,    -1,    -1,    -1,    -1,   152,
     153,   154,   155,     0,   157,   158,   159,   160,    -1,    -1,
      -1,     8,     9,    10,    -1,    -1,    -1,    14,    15,    -1,
      17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      37,    38,    -1,    40,    41,    42,    43,    44,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    -1,    -1,    -1,    -1,    95,    96,
      97,    98,    -1,   100,   101,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
      -1,    -1,    -1,    -1,   151,   152,   153,   154,   155,     0,
      -1,   158,    -1,   160,    -1,    -1,    -1,     8,     9,    10,
      -1,    -1,    -1,    14,    15,    -1,    17,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    37,    38,    -1,    40,
      41,    42,    43,    44,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    -1,   100,
     101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,    -1,    -1,    -1,    -1,
     151,   152,   153,   154,   155,     0,    -1,   158,    -1,   160,
      -1,    -1,    -1,     8,     9,    10,    -1,    -1,    -1,    14,
      15,    -1,    17,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    37,    38,    -1,    40,    41,    42,    43,    44,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    69,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    -1,    -1,    -1,    -1,
      95,    96,    97,    98,    -1,   100,   101,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,    -1,    -1,    -1,    -1,   151,   152,   153,   154,
     155,     0,    -1,   158,    -1,   160,    -1,    -1,    -1,     8,
       9,    10,    -1,    -1,    -1,    14,    15,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    37,    38,
      -1,    40,    41,    42,    43,    44,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    -1,    -1,    -1,    -1,    95,    96,    97,    98,
      -1,   100,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,    -1,
      -1,    -1,   151,   152,   153,   154,   155,    -1,    -1,   158,
       1,   160,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,    -1,
      -1,    -1,     1,   154,     3,     4,     5,     6,     7,   160,
      -1,    10,    11,    12,    -1,    14,    15,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,     1,   154,     3,     4,     5,     6,
       7,   160,    -1,    10,    11,    12,    -1,    -1,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,   104,   105,    -1,
     107,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,     1,   154,     3,     4,
       5,     6,     7,   160,    -1,    10,    11,    12,    -1,    -1,
      15,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      25,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,   104,
     105,    -1,   107,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,    -1,    -1,    -1,     1,   154,
       3,     4,     5,     6,     7,   160,    -1,    10,    11,    12,
      -1,    -1,    15,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    -1,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,
     103,   104,   105,    -1,   107,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,    -1,    -1,    -1,
       1,   154,     3,     4,     5,     6,     7,   160,     9,    10,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,    -1,
      -1,    -1,     1,   154,     3,     4,     5,     6,     7,   160,
      -1,    10,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,     1,   154,     3,     4,     5,     6,
       7,   160,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,   104,   105,    -1,
     107,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,    -1,   154,    -1,    -1,
      -1,   158,     1,   160,     3,     4,     5,     6,     7,    -1,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,    -1,    -1,    -1,    -1,   154,    -1,    -1,    -1,   158,
       1,   160,     3,     4,     5,     6,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,    -1,
      -1,   152,     1,   154,     3,     4,     5,     6,     7,   160,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,   104,   105,    -1,   107,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,    -1,    -1,   152,     1,   154,     3,     4,     5,    -1,
       7,   160,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    -1,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,
      77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,    -1,    -1,    -1,    -1,   154,    -1,    -1,
      -1,    -1,    -1,   160,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    -1,    -1,
      -1,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    -1,    87,    88,
      -1,    -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,    -1,   148,
     149,    -1,    -1,    -1,    -1,    -1,    -1,   156,   157,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    -1,    -1,    -1,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    39,    -1,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,
      94,    95,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,    -1,   148,   149,    -1,    -1,    -1,    -1,
      -1,    -1,   156,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      -1,    -1,    -1,    -1,    -1,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    -1,    56,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    87,    88,    -1,
      -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,   111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,    -1,   148,   149,
      -1,    -1,    -1,    -1,    -1,    -1,   156,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    -1,    -1,    -1,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    -1,    -1,    -1,    -1,    -1,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    -1,    -1,
      56,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      -1,    87,    88,    -1,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,   111,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,    -1,   148,   149,    -1,    -1,    -1,    -1,    -1,    -1,
     156,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    -1,    -1,    -1,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    -1,    -1,
      -1,    -1,    -1,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    -1,    -1,    56,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,   148,   149,     3,     4,
       5,    -1,     7,    -1,   156,    -1,    11,    12,    -1,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    -1,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,   147,    30,    31,    32,    33,    34,    35,    36,
     155,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,     3,     4,     5,    -1,     7,    -1,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
     147,    30,    31,    32,    33,    34,    35,    36,   155,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,   104,   105,    -1,   107,   108,
     109,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,    -1,     7,   147,   148,
     149,    11,    12,    -1,    -1,   154,    16,    -1,    18,    19,
      20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,
      30,    31,    32,    33,    34,    35,    36,    -1,    -1,    39,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    -1,    59,
      60,    61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    -1,     3,     4,     5,     6,     7,   147,   148,   149,
      11,    12,    -1,    -1,   154,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
       1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,   108,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,   108,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    77,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,   147,   148,   149,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,   107,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
       3,     4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,
      -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,   147,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,
     103,   104,   105,    -1,   107,    -1,    -1,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,     3,     4,
       5,    -1,     7,    -1,    -1,    -1,    11,    12,    -1,    -1,
      -1,    16,    -1,    18,    19,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,   147,    30,    31,    32,    33,    34,
      35,    36,    -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    -1,    59,    60,    61,    62,    63,    64,
      65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    -1,    99,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,   110,   111,   112,   113,   114,
     115,   116,   117,   118,    -1,    -1,     3,     4,     5,    -1,
       7,    -1,    -1,    -1,    11,    12,    -1,    -1,    -1,    16,
      -1,    18,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,   147,    30,    31,    32,    33,    34,    35,    36,
      -1,    -1,    39,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    60,    61,    62,    63,    64,    65,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,    -1,    -1,     3,     4,     5,    -1,     7,    -1,
      -1,    -1,    11,    12,    -1,    -1,    -1,    16,    -1,    18,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
     147,    30,    31,    32,    33,    34,    35,    36,    -1,    -1,
      39,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    60,    61,    62,    63,    64,    65,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      99,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,   110,   111,   112,   113,   114,   115,   116,   117,   118,
      -1,    -1,     3,     4,     5,    -1,     7,    -1,    -1,    -1,
      11,    12,    -1,    -1,    -1,    16,    -1,    18,    19,    20,
      21,    22,    23,    24,    -1,    -1,    -1,    -1,   147,    30,
      31,    32,    33,    34,    35,    36,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    -1,    59,    60,
      61,    62,    63,    64,    65,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,   102,   103,   104,   105,    -1,    -1,    -1,    -1,   110,
     111,   112,   113,   114,   115,   116,   117,   118,    -1,    -1,
       3,     4,     5,    -1,     7,    -1,    -1,    -1,    11,    12,
      -1,    -1,    -1,    16,    -1,    18,    19,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,   147,    30,    31,    32,
      33,    34,    35,    36,    -1,    -1,    39,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    -1,    59,    60,    61,    62,
      63,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,   102,
     103,   104,   105,    33,    34,    35,    36,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    49,
      50,    51,    52,    -1,    -1,    -1,    56,    -1,    -1,    59,
      60,    61,    62,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   147,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,   102,    -1,   104,   105,    -1,    -1,    -1,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    -1,
      -1,    -1,    -1,    -1,    52,    53,    -1,    -1,    56,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     140,    -1,    -1,    -1,    -1,    -1,    -1,   147,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    -1,    87,
      88,    -1,    -1,    -1,    -1,    93,    94,    95,    96,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
     148,   149,    52,    53,    -1,    -1,    56,    -1,   156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    87,    88,    -1,
      -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,    -1,   148,   149,
      52,    53,    -1,    -1,    56,    -1,   156,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,   148,   149,    52,    53,
      -1,    -1,    56,    -1,   156,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,
      94,    95,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,    -1,   148,   149,    52,    53,    -1,    -1,
      56,    -1,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      -1,    87,    88,    -1,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,    -1,   148,   149,    52,    53,    -1,    -1,    56,    -1,
     156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    -1,    87,
      88,    -1,    -1,    -1,    -1,    93,    94,    95,    96,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
     148,   149,    52,    53,    -1,    -1,    56,    -1,   156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    87,    88,    -1,
      -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,    -1,   148,   149,
      52,    53,    -1,    -1,    56,    -1,   156,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,   148,   149,    52,    53,
      -1,    -1,    56,    -1,   156,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,
      94,    95,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,    -1,   148,   149,    52,    53,    -1,    -1,
      56,    -1,   156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      -1,    87,    88,    -1,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,    -1,   148,   149,    52,    53,    -1,    -1,    56,    -1,
     156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    -1,    87,
      88,    -1,    -1,    -1,    -1,    93,    94,    95,    96,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,    -1,
     148,   149,    52,    53,    -1,    -1,    56,    -1,   156,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    -1,    87,    88,    -1,
      -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,    -1,   148,   149,
      52,    53,    -1,    -1,    56,    -1,   156,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    -1,    87,    88,    -1,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,    -1,   148,   149,    52,    53,
      -1,    -1,    56,    -1,   156,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,    93,
      94,    95,    96,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,    -1,   148,   149,    -1,    -1,    -1,    -1,
      -1,    -1,   156
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   165,   166,     1,     3,     4,     5,     6,     7,    11,
      12,    16,    18,    19,    20,    21,    22,    23,    24,    30,
      31,    32,    33,    34,    35,    36,    39,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      59,    60,    61,    62,    63,    64,    65,    76,    77,    91,
      92,    99,   102,   103,   104,   105,   107,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   147,   148,   149,   164,
     167,   168,   180,   182,   183,   184,   185,   186,   187,   191,
     195,   197,   203,   206,   208,   209,   210,   212,   214,   215,
     216,   217,   226,   227,   228,   229,   230,   231,   234,   255,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   287,   288,   321,   326,   327,   377,   378,   379,
     380,   381,   382,   384,   385,   388,   389,   391,   392,   393,
     394,   407,   408,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   466,     0,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    56,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    87,    88,    93,
      94,    95,    96,   107,   108,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   148,   149,   156,   220,   221,
     222,   224,   225,   407,   179,   179,   179,    39,    58,    99,
     102,   107,   108,   109,   112,   148,   187,   209,   217,   227,
     238,   239,   245,   246,   249,   251,   252,   268,   414,   415,
     417,   418,   453,   454,   246,   157,   242,   247,   248,   154,
     157,   189,    54,   221,   189,   151,   169,   170,   235,   466,
      21,    22,    32,   195,   197,   208,   227,   268,   287,   288,
     227,   227,   227,    56,    47,   102,   171,   176,   177,   182,
     211,   212,   466,   171,   240,   251,   453,   466,   239,   452,
     453,   466,    46,    99,   147,   155,   195,   197,   216,   255,
     268,   414,   415,   418,   319,   220,   397,   409,   413,   397,
     398,   399,   161,   383,   383,   383,   383,   412,   203,   227,
     227,   154,   160,   163,   464,   465,   179,    40,    41,    42,
      43,    44,    37,    38,   157,   421,   422,   423,   424,   466,
     421,   423,    26,   151,   242,   248,   279,   328,    28,   280,
     325,   134,   155,   102,   107,   214,   134,    25,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    95,    96,   101,   135,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   233,   233,    69,    97,    98,
     153,   458,   459,   256,     1,   191,   198,   199,   199,   200,
     202,   202,   163,   199,   465,    99,   210,   217,   268,   293,
     414,   415,   418,    52,    56,    95,    99,   218,   219,   268,
     414,   415,   418,   219,    33,    34,    35,    36,    49,    50,
      51,    52,    56,   157,   194,   220,   416,   448,   449,   450,
     246,   157,   248,    98,   458,   459,   328,   380,   100,   100,
     155,   239,    56,   239,   239,   239,   397,   134,   101,   155,
     250,   466,    98,   153,   458,   100,   100,   155,   250,    92,
     244,   246,   251,   433,   453,   466,   246,   189,   191,   460,
     191,    54,    64,    65,   181,   157,   235,   236,   164,   421,
     421,    98,   458,   100,   178,   211,   158,   163,   465,   460,
     257,   159,   155,   189,   463,   155,   463,   152,   463,   189,
      56,   412,   213,   214,   422,   155,    98,   153,   458,   316,
      66,   119,   121,   122,   400,   119,   119,   400,    67,   400,
     161,   386,   395,   390,   396,    78,   160,   168,   151,   199,
     199,   199,   199,   235,   237,   191,   191,    52,    54,    55,
      56,    57,    58,    78,    92,   102,   107,   108,   109,   141,
     144,   298,   364,   425,   426,   427,   428,   429,   430,   432,
     433,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,   444,   445,   446,   134,   265,   432,   134,   266,   329,
     330,   106,   207,   331,   332,   332,   235,   211,   155,   216,
     155,   235,   193,   227,   227,   227,   227,   227,   227,   227,
     227,   227,   227,   227,   227,   227,   192,   227,   227,   227,
     227,   227,   227,   227,   227,   227,   227,   227,    52,    53,
      56,   224,   455,   456,   244,   251,    52,    53,    56,   224,
     455,   242,   171,   174,    13,   289,   464,   289,   199,   171,
     171,   259,   163,    56,    98,   153,   458,    25,   199,    52,
      56,   218,   138,   420,   466,    98,   153,   458,   264,   451,
      69,    98,   457,   246,   460,    52,    56,   242,   455,   235,
     235,   223,   100,   124,   235,   239,   239,   249,   252,   453,
      52,    56,   244,    52,    56,   235,   235,   454,   460,   155,
     460,   155,   158,   460,   221,   236,   227,   152,   134,   134,
      56,   455,   455,   235,   170,   460,   177,   158,   453,   155,
     213,    52,    56,   244,    52,    56,   317,   402,   401,   119,
     387,   400,    66,   119,   119,   387,    66,   119,   227,   171,
     182,   102,   107,   294,   295,   296,   297,   435,   155,   447,
     466,   155,   447,   155,   431,   460,   299,   300,   155,   431,
     239,    34,    52,    52,   155,   431,    52,    39,   188,   209,
     227,   232,   174,   464,   188,   232,   174,   316,   152,   330,
     316,    10,    68,   286,   286,   107,   203,   204,   205,   239,
     251,   253,   254,   460,   213,   155,    99,   185,   190,   205,
     217,   227,   239,   241,   254,   268,   418,   338,   338,   189,
     100,   100,   151,   242,   248,   189,   461,   155,   100,   100,
     242,   243,   248,   466,   235,   286,   171,    13,   171,    27,
     290,   464,   286,   286,    17,   283,   334,    25,   258,   340,
      52,    56,   244,    52,    56,   260,   263,   419,   262,    52,
      56,   218,   244,   174,   191,   196,   460,   243,   248,   190,
     227,   241,   190,   241,   221,   235,   239,   250,   100,   100,
     461,   100,   100,   433,   453,   191,    39,   190,   241,   463,
     214,   461,   318,   403,   406,   413,   418,   383,   400,   383,
     383,   383,   152,   296,   435,   155,   460,   155,   446,   425,
     440,   442,   428,   429,   438,   444,   134,   239,   430,   437,
     444,   436,   438,   189,    44,    44,   286,   286,   317,   152,
     317,   239,   155,    44,   213,    56,    44,   134,    44,    98,
     153,   458,   336,   336,   136,   235,   235,   330,   207,   159,
     100,   235,   235,   207,     8,   281,   373,   466,    14,    15,
     284,   285,   291,   292,   466,   292,   201,   107,   239,   333,
     286,   338,   334,   286,   461,   199,   464,   199,   174,   461,
     286,   460,   194,   328,   325,   235,   235,   100,   235,   235,
     460,   155,   460,   189,   179,   404,   460,   294,   297,   295,
     447,   155,   431,   155,   431,   155,   431,   155,   431,   431,
     188,   232,   237,   237,   318,   318,   107,   239,   237,   237,
     235,   237,    52,    56,   244,    52,    56,   337,   337,   227,
     190,   241,   190,   241,   152,   235,   190,   241,   190,   241,
     239,   254,   374,   466,   175,   284,   171,   199,   286,   286,
     239,   155,   289,   336,   286,   290,   174,   464,   286,   235,
     157,   322,   432,   171,   155,   155,   438,   438,   444,   438,
     227,   227,   179,   179,   239,   182,   182,   227,   461,    52,
      56,    58,    91,    92,    99,   102,   104,   105,   107,   112,
     140,   321,   343,   344,   345,   347,   350,   354,   355,   356,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   377,   378,   381,   382,   385,   389,
     392,   394,   415,   440,   343,   190,   241,   101,   375,   466,
       9,   282,   376,   466,   172,   289,   107,   239,   171,   337,
     261,   286,   432,   320,     0,   120,   405,   295,   431,   431,
     155,   431,   431,   139,   310,   311,   466,   310,   368,   368,
      56,   218,   337,   344,   352,   353,   354,   355,   358,   461,
     189,   337,   462,    52,   397,    52,   102,   413,   101,   155,
     139,   155,   155,   344,    89,    90,    98,   153,   157,   348,
     349,    52,    99,   217,   268,   414,   415,   418,   289,   176,
     171,   171,   239,   292,   334,   335,   342,   343,   171,   189,
     313,    29,   123,   323,   438,   298,   301,   302,   303,   304,
     306,   307,   309,   312,   436,   438,   439,   444,   446,   171,
     174,   344,   461,   344,   356,   358,   461,   155,   152,   235,
     124,   199,   369,   352,   356,   346,   357,   358,   112,   361,
     365,   368,   368,   218,   337,   461,   337,   460,   352,   355,
     359,   352,   355,   359,    56,    98,   153,   458,   171,   163,
     173,   291,   289,    40,    41,   286,   160,   158,   324,   171,
     431,   447,   155,   447,   155,   308,   313,   300,   155,   305,
     308,    99,   268,   155,   308,   460,   155,   155,   351,   460,
     155,   350,   155,   397,   460,   460,   460,   461,   461,   461,
      52,    56,   244,    52,    56,   373,   376,   339,   199,   199,
      52,   314,   315,   434,   174,   152,   301,   442,   304,   306,
     438,   444,   139,   268,   307,   444,    56,    98,   438,   357,
     359,   357,   356,   358,   461,   171,   155,   189,   286,   447,
     155,   308,   155,   308,   155,   308,   155,   308,    52,    56,
     308,   155,   462,   292,   340,   341,   315,   438,   438,   444,
     438,   308,   308,   155,   308,   308,   438,   308
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   162,   165,   163,   163,   164,   166,   167,   167,   167,
     168,   168,   169,   170,   171,   172,   173,   174,   175,   174,
     176,   176,   176,   177,   178,   177,   179,   180,   181,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   183,   182,   182,   182,   182,   182,   184,   185,
     186,   186,   186,   186,   186,   186,   186,   186,   185,   187,
     187,   185,   188,   188,   189,   189,   188,   190,   190,   190,
     191,   191,   191,   191,   191,   192,   191,   193,   191,   191,
     194,   195,   196,   197,   198,   199,   199,   200,   201,   202,
     203,   203,   204,   205,   206,   206,   207,   208,   208,   208,
     209,   209,   209,   209,   209,   209,   209,   209,   209,   209,
     209,   209,   210,   210,   211,   211,   212,   212,   212,   213,
     213,   212,   212,   212,   212,   212,   212,   212,   214,   214,
     215,   215,   216,   216,   216,   216,   216,   216,   216,   216,
     216,   217,   217,   217,   217,   217,   217,   217,   217,   217,
     218,   218,   219,   219,   219,   220,   220,   220,   220,   220,
     221,   221,   222,   223,   222,   224,   224,   224,   224,   224,
     224,   224,   224,   224,   224,   224,   224,   224,   224,   224,
     224,   224,   224,   224,   224,   224,   224,   224,   224,   224,
     224,   224,   224,   224,   224,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   225,   225,   226,   227,   228,   228,
     228,   228,   228,   228,   228,   228,   227,   229,   229,   229,
     229,   229,   229,   227,   227,   227,   227,   227,   227,   227,
     227,   227,   227,   227,   227,   227,   227,   227,   227,   227,
     227,   227,   227,   227,   227,   227,   227,   227,   227,   227,
     230,   230,   227,   227,   227,   231,   232,   232,   232,   233,
     233,   233,   233,   234,   234,   235,   236,   237,   238,   239,
     240,   240,   240,   240,   241,   241,   242,   242,   242,   243,
     243,   244,   244,   244,   244,   244,   245,   246,   246,   246,
     246,   246,   246,   247,   248,   249,   249,   250,   250,   251,
     251,   251,   251,   252,   252,   253,   253,   254,   254,   254,
     255,   255,   255,   255,   255,   255,   255,   255,   255,   255,
     255,   256,   255,   257,   255,   255,   255,   255,   255,   255,
     255,   255,   255,   255,   255,   255,   255,   255,   255,   255,
     255,   255,   255,   255,   255,   258,   255,   259,   255,   255,
     260,   261,   255,   262,   255,   263,   255,   264,   255,   265,
     255,   266,   255,   255,   255,   255,   255,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   286,   287,   288,
     289,   289,   289,   290,   290,   291,   291,   292,   292,   293,
     293,   294,   294,   295,   295,   296,   296,   296,   296,   296,
     297,   297,   298,   298,   299,   300,   301,   301,   302,   302,
     303,   303,   303,   303,   304,   305,   306,   307,   307,   308,
     308,   309,   309,   309,   309,   309,   309,   309,   309,   309,
     309,   309,   309,   309,   309,   309,   310,   310,   311,   312,
     312,   313,   313,   314,   314,   315,   315,   316,   317,   318,
     319,   320,   321,   322,   322,   323,   324,   323,   325,   326,
     326,   326,   326,   326,   327,   327,   327,   327,   327,   327,
     327,   327,   328,   328,   329,   330,   331,   332,   333,   333,
     333,   333,   334,   335,   335,   336,   337,   338,   339,   340,
     341,   341,   342,   342,   342,   343,   343,   343,   343,   343,
     343,   344,   345,   345,   346,   347,   347,   348,   349,   350,
     350,   350,   350,   350,   350,   350,   350,   350,   350,   350,
     350,   350,   351,   350,   350,   350,   352,   352,   352,   352,
     352,   352,   353,   353,   354,   354,   355,   356,   356,   357,
     357,   358,   359,   359,   359,   359,   360,   360,   361,   361,
     362,   362,   363,   363,   364,   365,   365,   366,   367,   367,
     367,   367,   367,   367,   366,   366,   366,   366,   368,   368,
     368,   368,   368,   368,   368,   368,   368,   368,   369,   370,
     370,   371,   372,   372,   372,   373,   373,   374,   374,   374,
     375,   375,   376,   376,   377,   377,   378,   379,   379,   379,
     380,   381,   382,   383,   383,   384,   385,   386,   386,   387,
     387,   388,   389,   390,   390,   391,   392,   393,   394,   395,
     395,   396,   396,   397,   397,   398,   398,   399,   399,   400,
     401,   400,   402,   403,   404,   400,   405,   405,   406,   406,
     407,   407,   408,   409,   409,   410,   411,   411,   412,   412,
     412,   412,   413,   413,   413,   414,   414,   414,   415,   415,
     415,   415,   415,   415,   415,   416,   416,   417,   417,   418,
     418,   419,   420,   420,   421,   421,   422,   423,   424,   423,
     425,   425,   426,   426,   427,   427,   427,   427,   428,   428,
     429,   430,   430,   431,   431,   432,   432,   432,   432,   432,
     432,   432,   432,   432,   432,   432,   432,   432,   432,   432,
     433,   434,   434,   434,   434,   435,   435,   436,   437,   437,
     438,   438,   439,   440,   440,   441,   442,   442,   443,   443,
     444,   444,   445,   445,   446,   446,   447,   447,   448,   449,
     450,   451,   450,   452,   452,   453,   453,   454,   454,   454,
     454,   454,   454,   455,   455,   455,   455,   456,   456,   456,
     457,   457,   458,   458,   459,   459,   460,   461,   462,   463,
     463,   464,   464,   465,   465,   466
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     0,     1,     2,     2,     1,     1,     3,
       1,     2,     1,     3,     2,     0,     0,     8,     0,     5,
       1,     1,     3,     1,     0,     3,     0,     2,     0,     4,
       3,     3,     3,     2,     3,     3,     3,     3,     4,     5,
       1,     4,     4,     1,     7,     4,     1,     1,     4,     1,
       4,     7,     6,     6,     6,     6,     5,     4,     1,     4,
       4,     1,     1,     4,     0,     1,     3,     1,     4,     1,
       1,     3,     3,     3,     2,     0,     7,     0,     7,     1,
       1,     2,     0,     5,     1,     1,     1,     0,     0,     4,
       1,     1,     1,     1,     1,     4,     3,     1,     1,     1,
       2,     3,     4,     5,     4,     5,     6,     2,     2,     2,
       2,     2,     1,     3,     1,     3,     1,     2,     3,     1,
       3,     5,     2,     4,     2,     4,     1,     3,     1,     3,
       2,     3,     1,     1,     4,     3,     3,     3,     3,     2,
       1,     1,     1,     4,     3,     3,     3,     3,     2,     1,
       1,     1,     2,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     4,     1,     4,     7,
       6,     6,     6,     6,     5,     4,     1,     3,     3,     2,
       2,     2,     2,     1,     3,     3,     3,     3,     3,     3,
       4,     2,     2,     3,     3,     3,     3,     1,     3,     3,
       3,     3,     3,     2,     2,     3,     3,     3,     3,     4,
       4,     4,     1,     1,     1,     6,     1,     4,     3,     1,
       1,     1,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     2,     4,     2,     1,     4,     3,     5,     3,     1,
       1,     1,     1,     2,     4,     2,     1,     1,     1,     2,
       2,     4,     1,     0,     2,     2,     1,     2,     1,     1,
       1,     3,     3,     2,     1,     1,     1,     3,     4,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     4,     0,     4,     3,     3,     2,     3,     3,
       1,     4,     3,     1,     6,     4,     3,     2,     1,     2,
       1,     6,     6,     4,     4,     0,     6,     0,     5,     5,
       0,     0,     9,     0,     6,     0,     7,     0,     5,     0,
       5,     0,     5,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     5,     1,     2,     1,
       1,     1,     3,     1,     3,     1,     3,     5,     1,     3,
       2,     1,     1,     1,     0,     2,     2,     1,     1,     3,
       4,     2,     2,     1,     1,     1,     3,     1,     3,     2,
       0,     6,     8,     4,     6,     4,     2,     6,     2,     4,
       6,     2,     4,     2,     4,     1,     1,     1,     4,     0,
       1,     1,     4,     1,     3,     1,     1,     0,     0,     0,
       0,     0,     9,     4,     1,     3,     0,     4,     3,     2,
       4,     5,     5,     3,     2,     4,     4,     3,     3,     2,
       1,     4,     3,     3,     0,     7,     0,     7,     1,     2,
       3,     4,     5,     1,     1,     0,     0,     0,     0,     9,
       1,     1,     1,     3,     3,     1,     2,     3,     1,     1,
       1,     1,     3,     1,     0,     4,     1,     2,     2,     1,
       1,     4,     4,     4,     3,     4,     4,     4,     3,     3,
       3,     2,     0,     6,     2,     4,     1,     1,     2,     2,
       4,     1,     2,     3,     1,     3,     5,     2,     1,     1,
       3,     1,     3,     1,     2,     1,     1,     3,     2,     1,
       1,     3,     2,     1,     2,     1,     1,     1,     3,     3,
       2,     2,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     4,     2,     3,     1,     6,     1,     1,     1,     1,
       2,     1,     3,     1,     1,     1,     1,     1,     1,     2,
       3,     3,     3,     1,     2,     4,     1,     0,     3,     1,
       2,     4,     1,     0,     3,     4,     1,     4,     1,     0,
       3,     0,     3,     0,     2,     0,     2,     0,     2,     1,
       0,     3,     0,     0,     0,     6,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     3,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     4,     1,     1,     1,     3,     1,     0,     3,
       2,     1,     1,     3,     4,     2,     2,     1,     1,     1,
       3,     1,     3,     2,     0,     6,     8,     4,     6,     4,
       6,     2,     4,     6,     2,     4,     2,     4,     1,     0,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       1,     3,     1,     1,     1,     1,     2,     1,     1,     1,
       2,     1,     1,     1,     2,     1,     2,     1,     1,     1,
       1,     0,     4,     1,     2,     1,     3,     3,     2,     1,
       4,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     2,     1,
       1,     1,     1,     1,     2,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, p, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc, p)  YY_LOCATION_PRINT(File, *(Loc), p)

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc, p)  YYLOCATION_PRINT(File, &(Loc), p)

#  else

#   define YYLOCATION_PRINT(File, Loc, p) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location, p) \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, p);          \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct parser_params *p)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (p);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
switch (yykind)
    {
    case YYSYMBOL_keyword_class: /* "'class'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7858 "parse.c"
        break;

    case YYSYMBOL_keyword_module: /* "'module'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7866 "parse.c"
        break;

    case YYSYMBOL_keyword_def: /* "'def'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7874 "parse.c"
        break;

    case YYSYMBOL_keyword_undef: /* "'undef'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7882 "parse.c"
        break;

    case YYSYMBOL_keyword_begin: /* "'begin'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7890 "parse.c"
        break;

    case YYSYMBOL_keyword_rescue: /* "'rescue'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7898 "parse.c"
        break;

    case YYSYMBOL_keyword_ensure: /* "'ensure'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7906 "parse.c"
        break;

    case YYSYMBOL_keyword_end: /* "'end'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7914 "parse.c"
        break;

    case YYSYMBOL_keyword_if: /* "'if'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7922 "parse.c"
        break;

    case YYSYMBOL_keyword_unless: /* "'unless'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7930 "parse.c"
        break;

    case YYSYMBOL_keyword_then: /* "'then'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7938 "parse.c"
        break;

    case YYSYMBOL_keyword_elsif: /* "'elsif'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7946 "parse.c"
        break;

    case YYSYMBOL_keyword_else: /* "'else'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7954 "parse.c"
        break;

    case YYSYMBOL_keyword_case: /* "'case'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7962 "parse.c"
        break;

    case YYSYMBOL_keyword_when: /* "'when'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7970 "parse.c"
        break;

    case YYSYMBOL_keyword_while: /* "'while'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7978 "parse.c"
        break;

    case YYSYMBOL_keyword_until: /* "'until'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7986 "parse.c"
        break;

    case YYSYMBOL_keyword_for: /* "'for'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 7994 "parse.c"
        break;

    case YYSYMBOL_keyword_break: /* "'break'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8002 "parse.c"
        break;

    case YYSYMBOL_keyword_next: /* "'next'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8010 "parse.c"
        break;

    case YYSYMBOL_keyword_redo: /* "'redo'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8018 "parse.c"
        break;

    case YYSYMBOL_keyword_retry: /* "'retry'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8026 "parse.c"
        break;

    case YYSYMBOL_keyword_in: /* "'in'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8034 "parse.c"
        break;

    case YYSYMBOL_keyword_do: /* "'do'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8042 "parse.c"
        break;

    case YYSYMBOL_keyword_do_cond: /* "'do' for condition"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8050 "parse.c"
        break;

    case YYSYMBOL_keyword_do_block: /* "'do' for block"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8058 "parse.c"
        break;

    case YYSYMBOL_keyword_do_LAMBDA: /* "'do' for lambda"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8066 "parse.c"
        break;

    case YYSYMBOL_keyword_return: /* "'return'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8074 "parse.c"
        break;

    case YYSYMBOL_keyword_yield: /* "'yield'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8082 "parse.c"
        break;

    case YYSYMBOL_keyword_super: /* "'super'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8090 "parse.c"
        break;

    case YYSYMBOL_keyword_self: /* "'self'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8098 "parse.c"
        break;

    case YYSYMBOL_keyword_nil: /* "'nil'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8106 "parse.c"
        break;

    case YYSYMBOL_keyword_true: /* "'true'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8114 "parse.c"
        break;

    case YYSYMBOL_keyword_false: /* "'false'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8122 "parse.c"
        break;

    case YYSYMBOL_keyword_and: /* "'and'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8130 "parse.c"
        break;

    case YYSYMBOL_keyword_or: /* "'or'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8138 "parse.c"
        break;

    case YYSYMBOL_keyword_not: /* "'not'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8146 "parse.c"
        break;

    case YYSYMBOL_modifier_if: /* "'if' modifier"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8154 "parse.c"
        break;

    case YYSYMBOL_modifier_unless: /* "'unless' modifier"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8162 "parse.c"
        break;

    case YYSYMBOL_modifier_while: /* "'while' modifier"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8170 "parse.c"
        break;

    case YYSYMBOL_modifier_until: /* "'until' modifier"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8178 "parse.c"
        break;

    case YYSYMBOL_modifier_rescue: /* "'rescue' modifier"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8186 "parse.c"
        break;

    case YYSYMBOL_keyword_alias: /* "'alias'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8194 "parse.c"
        break;

    case YYSYMBOL_keyword_defined: /* "'defined?'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8202 "parse.c"
        break;

    case YYSYMBOL_keyword_BEGIN: /* "'BEGIN'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8210 "parse.c"
        break;

    case YYSYMBOL_keyword_END: /* "'END'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8218 "parse.c"
        break;

    case YYSYMBOL_keyword__LINE__: /* "'__LINE__'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8226 "parse.c"
        break;

    case YYSYMBOL_keyword__FILE__: /* "'__FILE__'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8234 "parse.c"
        break;

    case YYSYMBOL_keyword__ENCODING__: /* "'__ENCODING__'"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8242 "parse.c"
        break;

    case YYSYMBOL_tIDENTIFIER: /* "local variable or method"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8250 "parse.c"
        break;

    case YYSYMBOL_tFID: /* "method"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8258 "parse.c"
        break;

    case YYSYMBOL_tGVAR: /* "global variable"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8266 "parse.c"
        break;

    case YYSYMBOL_tIVAR: /* "instance variable"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8274 "parse.c"
        break;

    case YYSYMBOL_tCONSTANT: /* "constant"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8282 "parse.c"
        break;

    case YYSYMBOL_tCVAR: /* "class variable"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8290 "parse.c"
        break;

    case YYSYMBOL_tLABEL: /* "label"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8298 "parse.c"
        break;

    case YYSYMBOL_tINTEGER: /* "integer literal"  */
#line 2629 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8321 "parse.c"
        break;

    case YYSYMBOL_tFLOAT: /* "float literal"  */
#line 2629 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8344 "parse.c"
        break;

    case YYSYMBOL_tRATIONAL: /* "rational literal"  */
#line 2629 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8367 "parse.c"
        break;

    case YYSYMBOL_tIMAGINARY: /* "imaginary literal"  */
#line 2629 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8390 "parse.c"
        break;

    case YYSYMBOL_tCHAR: /* "char literal"  */
#line 2629 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8413 "parse.c"
        break;

    case YYSYMBOL_tNTH_REF: /* "numbered reference"  */
#line 2647 "parse.y"
         {
    rb_parser_printf(p, "$%ld", RNODE_NTH_REF(((*yyvaluep).node))->nd_nth);
}
#line 8421 "parse.c"
        break;

    case YYSYMBOL_tBACK_REF: /* "back reference"  */
#line 2650 "parse.y"
         {
    rb_parser_printf(p, "$%c", (int)RNODE_BACK_REF(((*yyvaluep).node))->nd_nth);
}
#line 8429 "parse.c"
        break;

    case YYSYMBOL_tSTRING_CONTENT: /* "literal content"  */
#line 2629 "parse.y"
         {
    switch (nd_type(RNODE(((*yyvaluep).node)))) {
      case NODE_INTEGER:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_integer_literal_val(((*yyvaluep).node)));
        break;
      case NODE_FLOAT:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_float_literal_val(((*yyvaluep).node)));
        break;
      case NODE_RATIONAL:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_rational_literal_val(((*yyvaluep).node)));
        break;
      case NODE_IMAGINARY:
        rb_parser_printf(p, "%+"PRIsVALUE, rb_node_imaginary_literal_val(((*yyvaluep).node)));
        break;
      default:
        break;
    }
}
#line 8452 "parse.c"
        break;

    case YYSYMBOL_69_: /* '.'  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8460 "parse.c"
        break;

    case YYSYMBOL_70_backslash_: /* "backslash"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8468 "parse.c"
        break;

    case YYSYMBOL_72_escaped_horizontal_tab_: /* "escaped horizontal tab"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8476 "parse.c"
        break;

    case YYSYMBOL_73_escaped_form_feed_: /* "escaped form feed"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8484 "parse.c"
        break;

    case YYSYMBOL_74_escaped_carriage_return_: /* "escaped carriage return"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8492 "parse.c"
        break;

    case YYSYMBOL_75_escaped_vertical_tab_: /* "escaped vertical tab"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8500 "parse.c"
        break;

    case YYSYMBOL_tANDDOT: /* "&."  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8508 "parse.c"
        break;

    case YYSYMBOL_tCOLON2: /* "::"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8516 "parse.c"
        break;

    case YYSYMBOL_tOP_ASGN: /* "operator-assignment"  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8524 "parse.c"
        break;

    case YYSYMBOL_compstmt_top_stmts: /* compstmt_top_stmts  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8537 "parse.c"
        break;

    case YYSYMBOL_top_stmts: /* top_stmts  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8550 "parse.c"
        break;

    case YYSYMBOL_top_stmt: /* top_stmt  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8563 "parse.c"
        break;

    case YYSYMBOL_block_open: /* block_open  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 8576 "parse.c"
        break;

    case YYSYMBOL_begin_block: /* begin_block  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8589 "parse.c"
        break;

    case YYSYMBOL_compstmt_stmts: /* compstmt_stmts  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8602 "parse.c"
        break;

    case YYSYMBOL_bodystmt: /* bodystmt  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8615 "parse.c"
        break;

    case YYSYMBOL_stmts: /* stmts  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8628 "parse.c"
        break;

    case YYSYMBOL_stmt_or_begin: /* stmt_or_begin  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8641 "parse.c"
        break;

    case YYSYMBOL_allow_exits: /* allow_exits  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 8654 "parse.c"
        break;

    case YYSYMBOL_stmt: /* stmt  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8667 "parse.c"
        break;

    case YYSYMBOL_asgn_mrhs: /* asgn_mrhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8680 "parse.c"
        break;

    case YYSYMBOL_asgn_command_rhs: /* asgn_command_rhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8693 "parse.c"
        break;

    case YYSYMBOL_command_asgn: /* command_asgn  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8706 "parse.c"
        break;

    case YYSYMBOL_op_asgn_command_rhs: /* op_asgn_command_rhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8719 "parse.c"
        break;

    case YYSYMBOL_def_endless_method_endless_command: /* def_endless_method_endless_command  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8732 "parse.c"
        break;

    case YYSYMBOL_endless_command: /* endless_command  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8745 "parse.c"
        break;

    case YYSYMBOL_command_rhs: /* command_rhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8758 "parse.c"
        break;

    case YYSYMBOL_expr: /* expr  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8771 "parse.c"
        break;

    case YYSYMBOL_def_name: /* def_name  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 8779 "parse.c"
        break;

    case YYSYMBOL_defn_head: /* defn_head  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_def_temp) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_def_temp)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_def_temp)))));
    }
}
#line 8792 "parse.c"
        break;

    case YYSYMBOL_defs_head: /* defs_head  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_def_temp) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_def_temp)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_def_temp)))));
    }
}
#line 8805 "parse.c"
        break;

    case YYSYMBOL_value_expr_expr: /* value_expr_expr  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8818 "parse.c"
        break;

    case YYSYMBOL_expr_value: /* expr_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8831 "parse.c"
        break;

    case YYSYMBOL_expr_value_do: /* expr_value_do  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8844 "parse.c"
        break;

    case YYSYMBOL_command_call: /* command_call  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8857 "parse.c"
        break;

    case YYSYMBOL_value_expr_command_call: /* value_expr_command_call  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8870 "parse.c"
        break;

    case YYSYMBOL_command_call_value: /* command_call_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8883 "parse.c"
        break;

    case YYSYMBOL_block_command: /* block_command  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8896 "parse.c"
        break;

    case YYSYMBOL_cmd_brace_block: /* cmd_brace_block  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8909 "parse.c"
        break;

    case YYSYMBOL_fcall: /* fcall  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_fcall) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_fcall)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_fcall)))));
    }
}
#line 8922 "parse.c"
        break;

    case YYSYMBOL_command: /* command  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8935 "parse.c"
        break;

    case YYSYMBOL_mlhs: /* mlhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_masgn) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_masgn)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_masgn)))));
    }
}
#line 8948 "parse.c"
        break;

    case YYSYMBOL_mlhs_inner: /* mlhs_inner  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_masgn) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_masgn)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_masgn)))));
    }
}
#line 8961 "parse.c"
        break;

    case YYSYMBOL_mlhs_basic: /* mlhs_basic  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_masgn) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_masgn)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_masgn)))));
    }
}
#line 8974 "parse.c"
        break;

    case YYSYMBOL_mlhs_items_mlhs_item: /* mlhs_items_mlhs_item  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 8987 "parse.c"
        break;

    case YYSYMBOL_mlhs_item: /* mlhs_item  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9000 "parse.c"
        break;

    case YYSYMBOL_mlhs_head: /* mlhs_head  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9013 "parse.c"
        break;

    case YYSYMBOL_mlhs_node: /* mlhs_node  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9026 "parse.c"
        break;

    case YYSYMBOL_lhs: /* lhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9039 "parse.c"
        break;

    case YYSYMBOL_cname: /* cname  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9047 "parse.c"
        break;

    case YYSYMBOL_cpath: /* cpath  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9060 "parse.c"
        break;

    case YYSYMBOL_fname: /* fname  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9068 "parse.c"
        break;

    case YYSYMBOL_fitem: /* fitem  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9081 "parse.c"
        break;

    case YYSYMBOL_undef_list: /* undef_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9094 "parse.c"
        break;

    case YYSYMBOL_op: /* op  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9102 "parse.c"
        break;

    case YYSYMBOL_reswords: /* reswords  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9110 "parse.c"
        break;

    case YYSYMBOL_asgn_arg_rhs: /* asgn_arg_rhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9123 "parse.c"
        break;

    case YYSYMBOL_arg: /* arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9136 "parse.c"
        break;

    case YYSYMBOL_op_asgn_arg_rhs: /* op_asgn_arg_rhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9149 "parse.c"
        break;

    case YYSYMBOL_range_expr_arg: /* range_expr_arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9162 "parse.c"
        break;

    case YYSYMBOL_def_endless_method_endless_arg: /* def_endless_method_endless_arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9175 "parse.c"
        break;

    case YYSYMBOL_ternary: /* ternary  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9188 "parse.c"
        break;

    case YYSYMBOL_endless_arg: /* endless_arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9201 "parse.c"
        break;

    case YYSYMBOL_relop: /* relop  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9209 "parse.c"
        break;

    case YYSYMBOL_rel_expr: /* rel_expr  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9222 "parse.c"
        break;

    case YYSYMBOL_value_expr_arg: /* value_expr_arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9235 "parse.c"
        break;

    case YYSYMBOL_arg_value: /* arg_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9248 "parse.c"
        break;

    case YYSYMBOL_aref_args: /* aref_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9261 "parse.c"
        break;

    case YYSYMBOL_arg_rhs: /* arg_rhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9274 "parse.c"
        break;

    case YYSYMBOL_paren_args: /* paren_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9287 "parse.c"
        break;

    case YYSYMBOL_opt_paren_args: /* opt_paren_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9300 "parse.c"
        break;

    case YYSYMBOL_opt_call_args: /* opt_call_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9313 "parse.c"
        break;

    case YYSYMBOL_value_expr_command: /* value_expr_command  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9326 "parse.c"
        break;

    case YYSYMBOL_call_args: /* call_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9339 "parse.c"
        break;

    case YYSYMBOL_command_args: /* command_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9352 "parse.c"
        break;

    case YYSYMBOL_block_arg: /* block_arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_block_pass) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_block_pass)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_block_pass)))));
    }
}
#line 9365 "parse.c"
        break;

    case YYSYMBOL_opt_block_arg: /* opt_block_arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_block_pass) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_block_pass)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_block_pass)))));
    }
}
#line 9378 "parse.c"
        break;

    case YYSYMBOL_args: /* args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9391 "parse.c"
        break;

    case YYSYMBOL_arg_splat: /* arg_splat  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9404 "parse.c"
        break;

    case YYSYMBOL_mrhs_arg: /* mrhs_arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9417 "parse.c"
        break;

    case YYSYMBOL_mrhs: /* mrhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9430 "parse.c"
        break;

    case YYSYMBOL_primary: /* primary  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9443 "parse.c"
        break;

    case YYSYMBOL_value_expr_primary: /* value_expr_primary  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9456 "parse.c"
        break;

    case YYSYMBOL_primary_value: /* primary_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9469 "parse.c"
        break;

    case YYSYMBOL_k_while: /* k_while  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 9482 "parse.c"
        break;

    case YYSYMBOL_k_until: /* k_until  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 9495 "parse.c"
        break;

    case YYSYMBOL_k_for: /* k_for  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_exits) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_exits)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_exits)))));
    }
}
#line 9508 "parse.c"
        break;

    case YYSYMBOL_k_def: /* k_def  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_def_temp) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_def_temp)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_def_temp)))));
    }
}
#line 9521 "parse.c"
        break;

    case YYSYMBOL_do: /* do  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9529 "parse.c"
        break;

    case YYSYMBOL_if_tail: /* if_tail  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9542 "parse.c"
        break;

    case YYSYMBOL_opt_else: /* opt_else  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9555 "parse.c"
        break;

    case YYSYMBOL_for_var: /* for_var  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9568 "parse.c"
        break;

    case YYSYMBOL_f_marg: /* f_marg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9581 "parse.c"
        break;

    case YYSYMBOL_mlhs_items_f_marg: /* mlhs_items_f_marg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9594 "parse.c"
        break;

    case YYSYMBOL_f_margs: /* f_margs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_masgn) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_masgn)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_masgn)))));
    }
}
#line 9607 "parse.c"
        break;

    case YYSYMBOL_f_rest_marg: /* f_rest_marg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9620 "parse.c"
        break;

    case YYSYMBOL_f_any_kwrest: /* f_any_kwrest  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9628 "parse.c"
        break;

    case YYSYMBOL_f_kw_primary_value: /* f_kw_primary_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_kw_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_kw_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_kw_arg)))));
    }
}
#line 9641 "parse.c"
        break;

    case YYSYMBOL_f_kwarg_primary_value: /* f_kwarg_primary_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_kw_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_kw_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_kw_arg)))));
    }
}
#line 9654 "parse.c"
        break;

    case YYSYMBOL_args_tail_basic_primary_value: /* args_tail_basic_primary_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9667 "parse.c"
        break;

    case YYSYMBOL_block_args_tail: /* block_args_tail  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9680 "parse.c"
        break;

    case YYSYMBOL_excessed_comma: /* excessed_comma  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9688 "parse.c"
        break;

    case YYSYMBOL_f_opt_primary_value: /* f_opt_primary_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_opt_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_opt_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_opt_arg)))));
    }
}
#line 9701 "parse.c"
        break;

    case YYSYMBOL_f_opt_arg_primary_value: /* f_opt_arg_primary_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_opt_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_opt_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_opt_arg)))));
    }
}
#line 9714 "parse.c"
        break;

    case YYSYMBOL_opt_args_tail_block_args_tail: /* opt_args_tail_block_args_tail  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9727 "parse.c"
        break;

    case YYSYMBOL_block_param: /* block_param  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9740 "parse.c"
        break;

    case YYSYMBOL_opt_block_param_def: /* opt_block_param_def  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9753 "parse.c"
        break;

    case YYSYMBOL_block_param_def: /* block_param_def  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9766 "parse.c"
        break;

    case YYSYMBOL_opt_block_param: /* opt_block_param  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9779 "parse.c"
        break;

    case YYSYMBOL_opt_bv_decl: /* opt_bv_decl  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9787 "parse.c"
        break;

    case YYSYMBOL_bv_decls: /* bv_decls  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9795 "parse.c"
        break;

    case YYSYMBOL_bvar: /* bvar  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9803 "parse.c"
        break;

    case YYSYMBOL_numparam: /* numparam  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9816 "parse.c"
        break;

    case YYSYMBOL_it_id: /* it_id  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 9824 "parse.c"
        break;

    case YYSYMBOL_lambda: /* lambda  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9837 "parse.c"
        break;

    case YYSYMBOL_f_larglist: /* f_larglist  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 9850 "parse.c"
        break;

    case YYSYMBOL_do_block: /* do_block  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9863 "parse.c"
        break;

    case YYSYMBOL_block_call: /* block_call  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9876 "parse.c"
        break;

    case YYSYMBOL_method_call: /* method_call  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9889 "parse.c"
        break;

    case YYSYMBOL_brace_block: /* brace_block  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9902 "parse.c"
        break;

    case YYSYMBOL_brace_body: /* brace_body  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9915 "parse.c"
        break;

    case YYSYMBOL_do_body: /* do_body  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9928 "parse.c"
        break;

    case YYSYMBOL_case_args: /* case_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9941 "parse.c"
        break;

    case YYSYMBOL_case_body: /* case_body  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9954 "parse.c"
        break;

    case YYSYMBOL_cases: /* cases  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9967 "parse.c"
        break;

    case YYSYMBOL_p_case_body: /* p_case_body  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9980 "parse.c"
        break;

    case YYSYMBOL_p_cases: /* p_cases  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 9993 "parse.c"
        break;

    case YYSYMBOL_p_top_expr: /* p_top_expr  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10006 "parse.c"
        break;

    case YYSYMBOL_p_top_expr_body: /* p_top_expr_body  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10019 "parse.c"
        break;

    case YYSYMBOL_p_expr: /* p_expr  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10032 "parse.c"
        break;

    case YYSYMBOL_p_as: /* p_as  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10045 "parse.c"
        break;

    case YYSYMBOL_p_alt: /* p_alt  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10058 "parse.c"
        break;

    case YYSYMBOL_p_expr_basic: /* p_expr_basic  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10071 "parse.c"
        break;

    case YYSYMBOL_p_args: /* p_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10084 "parse.c"
        break;

    case YYSYMBOL_p_args_head: /* p_args_head  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10097 "parse.c"
        break;

    case YYSYMBOL_p_args_tail: /* p_args_tail  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10110 "parse.c"
        break;

    case YYSYMBOL_p_find: /* p_find  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10123 "parse.c"
        break;

    case YYSYMBOL_p_rest: /* p_rest  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10136 "parse.c"
        break;

    case YYSYMBOL_p_args_post: /* p_args_post  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10149 "parse.c"
        break;

    case YYSYMBOL_p_arg: /* p_arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10162 "parse.c"
        break;

    case YYSYMBOL_p_kwargs: /* p_kwargs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10175 "parse.c"
        break;

    case YYSYMBOL_p_kwarg: /* p_kwarg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10188 "parse.c"
        break;

    case YYSYMBOL_p_kw: /* p_kw  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10201 "parse.c"
        break;

    case YYSYMBOL_p_kw_label: /* p_kw_label  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10209 "parse.c"
        break;

    case YYSYMBOL_p_kwrest: /* p_kwrest  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10217 "parse.c"
        break;

    case YYSYMBOL_p_kwnorest: /* p_kwnorest  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10225 "parse.c"
        break;

    case YYSYMBOL_p_any_kwrest: /* p_any_kwrest  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10233 "parse.c"
        break;

    case YYSYMBOL_p_value: /* p_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10246 "parse.c"
        break;

    case YYSYMBOL_range_expr_p_primitive: /* range_expr_p_primitive  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10259 "parse.c"
        break;

    case YYSYMBOL_p_primitive: /* p_primitive  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10272 "parse.c"
        break;

    case YYSYMBOL_p_variable: /* p_variable  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10285 "parse.c"
        break;

    case YYSYMBOL_p_var_ref: /* p_var_ref  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10298 "parse.c"
        break;

    case YYSYMBOL_p_expr_ref: /* p_expr_ref  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10311 "parse.c"
        break;

    case YYSYMBOL_p_const: /* p_const  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10324 "parse.c"
        break;

    case YYSYMBOL_opt_rescue: /* opt_rescue  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10337 "parse.c"
        break;

    case YYSYMBOL_exc_list: /* exc_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10350 "parse.c"
        break;

    case YYSYMBOL_exc_var: /* exc_var  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10363 "parse.c"
        break;

    case YYSYMBOL_opt_ensure: /* opt_ensure  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10376 "parse.c"
        break;

    case YYSYMBOL_literal: /* literal  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10389 "parse.c"
        break;

    case YYSYMBOL_strings: /* strings  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10402 "parse.c"
        break;

    case YYSYMBOL_string: /* string  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10415 "parse.c"
        break;

    case YYSYMBOL_string1: /* string1  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10428 "parse.c"
        break;

    case YYSYMBOL_xstring: /* xstring  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10441 "parse.c"
        break;

    case YYSYMBOL_regexp: /* regexp  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10454 "parse.c"
        break;

    case YYSYMBOL_words_tWORDS_BEG_word_list: /* words_tWORDS_BEG_word_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10467 "parse.c"
        break;

    case YYSYMBOL_words: /* words  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10480 "parse.c"
        break;

    case YYSYMBOL_word_list: /* word_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10493 "parse.c"
        break;

    case YYSYMBOL_word: /* word  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10506 "parse.c"
        break;

    case YYSYMBOL_words_tSYMBOLS_BEG_symbol_list: /* words_tSYMBOLS_BEG_symbol_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10519 "parse.c"
        break;

    case YYSYMBOL_symbols: /* symbols  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10532 "parse.c"
        break;

    case YYSYMBOL_symbol_list: /* symbol_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10545 "parse.c"
        break;

    case YYSYMBOL_words_tQWORDS_BEG_qword_list: /* words_tQWORDS_BEG_qword_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10558 "parse.c"
        break;

    case YYSYMBOL_qwords: /* qwords  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10571 "parse.c"
        break;

    case YYSYMBOL_words_tQSYMBOLS_BEG_qsym_list: /* words_tQSYMBOLS_BEG_qsym_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10584 "parse.c"
        break;

    case YYSYMBOL_qsymbols: /* qsymbols  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10597 "parse.c"
        break;

    case YYSYMBOL_qword_list: /* qword_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10610 "parse.c"
        break;

    case YYSYMBOL_qsym_list: /* qsym_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10623 "parse.c"
        break;

    case YYSYMBOL_string_contents: /* string_contents  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10636 "parse.c"
        break;

    case YYSYMBOL_xstring_contents: /* xstring_contents  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10649 "parse.c"
        break;

    case YYSYMBOL_regexp_contents: /* regexp_contents  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10662 "parse.c"
        break;

    case YYSYMBOL_string_content: /* string_content  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10675 "parse.c"
        break;

    case YYSYMBOL_string_dvar: /* string_dvar  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10688 "parse.c"
        break;

    case YYSYMBOL_symbol: /* symbol  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10701 "parse.c"
        break;

    case YYSYMBOL_ssym: /* ssym  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10714 "parse.c"
        break;

    case YYSYMBOL_sym: /* sym  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10722 "parse.c"
        break;

    case YYSYMBOL_dsym: /* dsym  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10735 "parse.c"
        break;

    case YYSYMBOL_numeric: /* numeric  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10748 "parse.c"
        break;

    case YYSYMBOL_simple_numeric: /* simple_numeric  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10761 "parse.c"
        break;

    case YYSYMBOL_nonlocal_var: /* nonlocal_var  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10769 "parse.c"
        break;

    case YYSYMBOL_user_variable: /* user_variable  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10777 "parse.c"
        break;

    case YYSYMBOL_keyword_variable: /* keyword_variable  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10785 "parse.c"
        break;

    case YYSYMBOL_var_ref: /* var_ref  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10798 "parse.c"
        break;

    case YYSYMBOL_var_lhs: /* var_lhs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10811 "parse.c"
        break;

    case YYSYMBOL_backref: /* backref  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10824 "parse.c"
        break;

    case YYSYMBOL_superclass: /* superclass  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 10837 "parse.c"
        break;

    case YYSYMBOL_f_opt_paren_args: /* f_opt_paren_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10850 "parse.c"
        break;

    case YYSYMBOL_f_paren_args: /* f_paren_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10863 "parse.c"
        break;

    case YYSYMBOL_f_arglist: /* f_arglist  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10876 "parse.c"
        break;

    case YYSYMBOL_f_kw_arg_value: /* f_kw_arg_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_kw_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_kw_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_kw_arg)))));
    }
}
#line 10889 "parse.c"
        break;

    case YYSYMBOL_f_kwarg_arg_value: /* f_kwarg_arg_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_kw_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_kw_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_kw_arg)))));
    }
}
#line 10902 "parse.c"
        break;

    case YYSYMBOL_args_tail_basic_arg_value: /* args_tail_basic_arg_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10915 "parse.c"
        break;

    case YYSYMBOL_args_tail: /* args_tail  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10928 "parse.c"
        break;

    case YYSYMBOL_f_opt_arg_value: /* f_opt_arg_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_opt_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_opt_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_opt_arg)))));
    }
}
#line 10941 "parse.c"
        break;

    case YYSYMBOL_f_opt_arg_arg_value: /* f_opt_arg_arg_value  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_opt_arg) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_opt_arg)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_opt_arg)))));
    }
}
#line 10954 "parse.c"
        break;

    case YYSYMBOL_opt_args_tail_args_tail: /* opt_args_tail_args_tail  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10967 "parse.c"
        break;

    case YYSYMBOL_f_args: /* f_args  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args)))));
    }
}
#line 10980 "parse.c"
        break;

    case YYSYMBOL_args_forward: /* args_forward  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10988 "parse.c"
        break;

    case YYSYMBOL_f_bad_arg: /* f_bad_arg  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 10996 "parse.c"
        break;

    case YYSYMBOL_f_norm_arg: /* f_norm_arg  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11004 "parse.c"
        break;

    case YYSYMBOL_f_arg_asgn: /* f_arg_asgn  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11012 "parse.c"
        break;

    case YYSYMBOL_f_arg_item: /* f_arg_item  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args_aux) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args_aux)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args_aux)))));
    }
}
#line 11025 "parse.c"
        break;

    case YYSYMBOL_f_arg: /* f_arg  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node_args_aux) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node_args_aux)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node_args_aux)))));
    }
}
#line 11038 "parse.c"
        break;

    case YYSYMBOL_f_label: /* f_label  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11046 "parse.c"
        break;

    case YYSYMBOL_f_no_kwarg: /* f_no_kwarg  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11054 "parse.c"
        break;

    case YYSYMBOL_f_kwrest: /* f_kwrest  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11062 "parse.c"
        break;

    case YYSYMBOL_f_rest_arg: /* f_rest_arg  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11070 "parse.c"
        break;

    case YYSYMBOL_f_block_arg: /* f_block_arg  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11078 "parse.c"
        break;

    case YYSYMBOL_opt_f_block_arg: /* opt_f_block_arg  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11086 "parse.c"
        break;

    case YYSYMBOL_value_expr_singleton_expr: /* value_expr_singleton_expr  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 11099 "parse.c"
        break;

    case YYSYMBOL_singleton: /* singleton  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 11112 "parse.c"
        break;

    case YYSYMBOL_singleton_expr: /* singleton_expr  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 11125 "parse.c"
        break;

    case YYSYMBOL_assoc_list: /* assoc_list  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 11138 "parse.c"
        break;

    case YYSYMBOL_assocs: /* assocs  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 11151 "parse.c"
        break;

    case YYSYMBOL_assoc: /* assoc  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 11164 "parse.c"
        break;

    case YYSYMBOL_operation2: /* operation2  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11172 "parse.c"
        break;

    case YYSYMBOL_operation3: /* operation3  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11180 "parse.c"
        break;

    case YYSYMBOL_dot_or_colon: /* dot_or_colon  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11188 "parse.c"
        break;

    case YYSYMBOL_call_op: /* call_op  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11196 "parse.c"
        break;

    case YYSYMBOL_call_op2: /* call_op2  */
#line 2626 "parse.y"
         {
    rb_parser_printf(p, "%"PRIsVALUE, rb_id2str(((*yyvaluep).id)));
}
#line 11204 "parse.c"
        break;

    case YYSYMBOL_none: /* none  */
#line 2617 "parse.y"
         {
    if ((NODE *)((*yyvaluep).node) == (NODE *)-1) {
        rb_parser_printf(p, "NODE_SPECIAL");
    }
    else if (((*yyvaluep).node)) {
        rb_parser_printf(p, "%s", parser_node_name(nd_type(RNODE(((*yyvaluep).node)))));
    }
}
#line 11217 "parse.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct parser_params *p)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp, p);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, p);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop, struct parser_params *p)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top, p)     \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top), p);    \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, struct parser_params *p)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), p);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule, p) \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, p); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
#ifndef yydebug
int yydebug;
#endif
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location, p)
# define YY_STACK_PRINT(Bottom, Top, p)
# define YY_REDUCE_PRINT(Rule, p)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx, struct parser_params *p)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, struct parser_params *p)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (p);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp, p);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_258_16: /* @16  */
#line 2654 "parse.y"
         {
    if (CASE_LABELS_ENABLED_P(((*yyvaluep).labels))) st_free_table(((*yyvaluep).labels));
}
#line 11624 "parse.c"
        break;

    case YYSYMBOL_259_17: /* @17  */
#line 2654 "parse.y"
         {
    if (CASE_LABELS_ENABLED_P(((*yyvaluep).labels))) st_free_table(((*yyvaluep).labels));
}
#line 11632 "parse.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct parser_params *p)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
#ifdef __cplusplus
static const YYSTYPE yyval_default = {};
(void) yyval_default;
#else
YY_INITIAL_VALUE (static const YYSTYPE yyval_default;)
#endif
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static const YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;
    YY_USE (yynerrs); /* Silence compiler warning.  */

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */


        /* User initialization code.  */
#line 2661 "parse.y"
        {
    RUBY_SET_YYLLOC_OF_NONE(yylloc);
}

#line 11740 "parse.c"

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp, p);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, p);
    }

  if (yychar <= END_OF_INPUT)
    {
      yychar = END_OF_INPUT;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc, p);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc, p);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;
        /* %after-shift code. */
#line 2664 "parse.y"
        {after_shift(p);}
#line 11914 "parse.c"


  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];
        /* %before-reduce function. */
#line 2665 "parse.y"
        {before_reduce(yylen, p);}
#line 11951 "parse.c"


  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn, p);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 3160 "parse.y"
            {
                        SET_LEX_STATE(EXPR_BEG);
                        local_push(p, ifndef_ripper(1)+0);
                        /* jumps are possible in the top-level loop. */
                        if (!ifndef_ripper(p->do_loop) + 0) init_block_exit(p);
                    }
#line 11968 "parse.c"
    break;

  case 5: /* compstmt_top_stmts: top_stmts option_terms  */
#line 2975 "parse.y"
                        {
                            void_stmts(p, (yyval.node) = (yyvsp[-1].node));
                        }
#line 11976 "parse.c"
    break;

  case 6: /* program: $@1 compstmt_top_stmts  */
#line 3167 "parse.y"
                    {
                        if ((yyvsp[0].node) && !compile_for_eval) {
                            NODE *node = (yyvsp[0].node);
                            /* last expression should not be void */
                            if (nd_type_p(node, NODE_BLOCK)) {
                                while (RNODE_BLOCK(node)->nd_next) {
                                    node = RNODE_BLOCK(node)->nd_next;
                                }
                                node = RNODE_BLOCK(node)->nd_head;
                            }
                            node = remove_begin(node);
                            void_expr(p, node);
                        }
                        p->eval_tree = NEW_SCOPE(0, block_append(p, p->eval_tree, (yyvsp[0].node)), NULL, &(yyloc));
                    /*% ripper[final]: program!($:2) %*/
                        local_pop(p);
                    }
#line 11998 "parse.c"
    break;

  case 7: /* top_stmts: none  */
#line 3187 "parse.y"
                    {
                        (yyval.node) = NEW_BEGIN(0, &(yyloc));
                    /*% ripper: stmts_add!(stmts_new!, void_stmt!) %*/
                    }
#line 12007 "parse.c"
    break;

  case 8: /* top_stmts: top_stmt  */
#line 3192 "parse.y"
                    {
                        (yyval.node) = newline_node((yyvsp[0].node));
                    /*% ripper: stmts_add!(stmts_new!, $:1) %*/
                    }
#line 12016 "parse.c"
    break;

  case 9: /* top_stmts: top_stmts terms top_stmt  */
#line 3197 "parse.y"
                    {
                        (yyval.node) = block_append(p, (yyvsp[-2].node), newline_node((yyvsp[0].node)));
                    /*% ripper: stmts_add!($:1, $:3) %*/
                    }
#line 12025 "parse.c"
    break;

  case 10: /* top_stmt: stmt  */
#line 3204 "parse.y"
                    {
                        clear_block_exit(p, true);
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 12034 "parse.c"
    break;

  case 11: /* top_stmt: "'BEGIN'" begin_block  */
#line 3209 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: $:2 %*/
                    }
#line 12043 "parse.c"
    break;

  case 12: /* block_open: '{'  */
#line 3215 "parse.y"
                 {(yyval.node_exits) = init_block_exit(p);}
#line 12049 "parse.c"
    break;

  case 13: /* begin_block: block_open compstmt_top_stmts '}'  */
#line 3218 "parse.y"
                    {
                        restore_block_exit(p, (yyvsp[-2].node_exits));
                        p->eval_tree_begin = block_append(p, p->eval_tree_begin,
                                                          NEW_BEGIN((yyvsp[-1].node), &(yyloc)));
                        (yyval.node) = NEW_BEGIN(0, &(yyloc));
                    /*% ripper: BEGIN!($:2) %*/
                    }
#line 12061 "parse.c"
    break;

  case 14: /* compstmt_stmts: stmts option_terms  */
#line 2975 "parse.y"
                        {
                            void_stmts(p, (yyval.node) = (yyvsp[-1].node));
                        }
#line 12069 "parse.c"
    break;

  case 15: /* $@2: %empty  */
#line 3231 "parse.y"
                    {
                        if (!(yyvsp[-1].node)) yyerror1(&(yylsp[0]), "else without rescue is useless");
                        next_rescue_context(&p->ctxt, &(yyvsp[-2].ctxt), after_else);
                    }
#line 12078 "parse.c"
    break;

  case 16: /* $@3: %empty  */
#line 3236 "parse.y"
                    {
                        next_rescue_context(&p->ctxt, &(yyvsp[-4].ctxt), after_ensure);
                    }
#line 12086 "parse.c"
    break;

  case 17: /* bodystmt: compstmt_stmts lex_ctxt opt_rescue k_else $@2 compstmt_stmts $@3 opt_ensure  */
#line 3240 "parse.y"
                    {
                        (yyval.node) = new_bodystmt(p, (yyvsp[-7].node), (yyvsp[-5].node), (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: bodystmt!($:body, $:opt_rescue, $:elsebody, $:opt_ensure) %*/
                    }
#line 12095 "parse.c"
    break;

  case 18: /* $@4: %empty  */
#line 3247 "parse.y"
                    {
                        next_rescue_context(&p->ctxt, &(yyvsp[-1].ctxt), after_ensure);
                    }
#line 12103 "parse.c"
    break;

  case 19: /* bodystmt: compstmt_stmts lex_ctxt opt_rescue $@4 opt_ensure  */
#line 3251 "parse.y"
                    {
                        (yyval.node) = new_bodystmt(p, (yyvsp[-4].node), (yyvsp[-2].node), 0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: bodystmt!($:body, $:opt_rescue, Qnil, $:opt_ensure) %*/
                    }
#line 12112 "parse.c"
    break;

  case 20: /* stmts: none  */
#line 3258 "parse.y"
                    {
                        (yyval.node) = NEW_BEGIN(0, &(yyloc));
                    /*% ripper: stmts_add!(stmts_new!, void_stmt!) %*/
                    }
#line 12121 "parse.c"
    break;

  case 21: /* stmts: stmt_or_begin  */
#line 3263 "parse.y"
                    {
                        (yyval.node) = newline_node((yyvsp[0].node));
                    /*% ripper: stmts_add!(stmts_new!, $:1) %*/
                    }
#line 12130 "parse.c"
    break;

  case 22: /* stmts: stmts terms stmt_or_begin  */
#line 3268 "parse.y"
                    {
                        (yyval.node) = block_append(p, (yyvsp[-2].node), newline_node((yyvsp[0].node)));
                    /*% ripper: stmts_add!($:1, $:3) %*/
                    }
#line 12139 "parse.c"
    break;

  case 24: /* $@5: %empty  */
#line 3276 "parse.y"
                    {
                        yyerror1(&(yylsp[0]), "BEGIN is permitted only at toplevel");
                    }
#line 12147 "parse.c"
    break;

  case 25: /* stmt_or_begin: "'BEGIN'" $@5 begin_block  */
#line 3280 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 12155 "parse.c"
    break;

  case 26: /* allow_exits: %empty  */
#line 3285 "parse.y"
              {(yyval.node_exits) = allow_block_exit(p);}
#line 12161 "parse.c"
    break;

  case 27: /* k_END: "'END'" lex_ctxt  */
#line 3288 "parse.y"
                    {
                        (yyval.ctxt) = (yyvsp[0].ctxt);
                        p->ctxt.in_rescue = before_rescue;
                    /*% ripper: $:2 %*/
                    }
#line 12171 "parse.c"
    break;

  case 28: /* $@6: %empty  */
#line 3294 "parse.y"
                            {SET_LEX_STATE(EXPR_FNAME|EXPR_FITEM);}
#line 12177 "parse.c"
    break;

  case 29: /* stmt: "'alias'" fitem $@6 fitem  */
#line 3295 "parse.y"
                    {
                        (yyval.node) = NEW_ALIAS((yyvsp[-2].node), (yyvsp[0].node), &(yyloc), &(yylsp[-3]));
                    /*% ripper: alias!($:2, $:4) %*/
                    }
#line 12186 "parse.c"
    break;

  case 30: /* stmt: "'alias'" "global variable" "global variable"  */
#line 3300 "parse.y"
                    {
                        (yyval.node) = NEW_VALIAS((yyvsp[-1].id), (yyvsp[0].id), &(yyloc), &(yylsp[-2]));
                    /*% ripper: var_alias!($:2, $:3) %*/
                    }
#line 12195 "parse.c"
    break;

  case 31: /* stmt: "'alias'" "global variable" "back reference"  */
#line 3305 "parse.y"
                    {
                        char buf[2];
                        buf[0] = '$';
                        buf[1] = (char)RNODE_BACK_REF((yyvsp[0].node))->nd_nth;
                        (yyval.node) = NEW_VALIAS((yyvsp[-1].id), rb_intern2(buf, 2), &(yyloc), &(yylsp[-2]));
                    /*% ripper: var_alias!($:2, $:3) %*/
                    }
#line 12207 "parse.c"
    break;

  case 32: /* stmt: "'alias'" "global variable" "numbered reference"  */
#line 3313 "parse.y"
                    {
                        static const char mesg[] = "can't make alias for the number variables";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: alias_error!(ERR_MESG(), $:3) %*/
                    }
#line 12220 "parse.c"
    break;

  case 33: /* stmt: "'undef'" undef_list  */
#line 3322 "parse.y"
                    {
                        nd_set_first_loc((yyvsp[0].node), (yylsp[-1]).beg_pos);
                        RNODE_UNDEF((yyvsp[0].node))->keyword_loc = (yylsp[-1]);
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: undef!($:2) %*/
                    }
#line 12231 "parse.c"
    break;

  case 34: /* stmt: stmt "'if' modifier" expr_value  */
#line 3329 "parse.y"
                    {
                        (yyval.node) = new_if(p, (yyvsp[0].node), remove_begin((yyvsp[-2].node)), 0, &(yyloc), &(yylsp[-1]), &NULL_LOC, &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: if_mod!($:3, $:1) %*/
                    }
#line 12241 "parse.c"
    break;

  case 35: /* stmt: stmt "'unless' modifier" expr_value  */
#line 3335 "parse.y"
                    {
                        (yyval.node) = new_unless(p, (yyvsp[0].node), remove_begin((yyvsp[-2].node)), 0, &(yyloc), &(yylsp[-1]), &NULL_LOC, &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: unless_mod!($:3, $:1) %*/
                    }
#line 12251 "parse.c"
    break;

  case 36: /* stmt: stmt "'while' modifier" expr_value  */
#line 3341 "parse.y"
                    {
                        clear_block_exit(p, false);
                        if ((yyvsp[-2].node) && nd_type_p((yyvsp[-2].node), NODE_BEGIN)) {
                            (yyval.node) = NEW_WHILE(cond(p, (yyvsp[0].node), &(yylsp[0])), RNODE_BEGIN((yyvsp[-2].node))->nd_body, 0, &(yyloc), &(yylsp[-1]), &NULL_LOC);
                        }
                        else {
                            (yyval.node) = NEW_WHILE(cond(p, (yyvsp[0].node), &(yylsp[0])), (yyvsp[-2].node), 1, &(yyloc), &(yylsp[-1]), &NULL_LOC);
                        }
                    /*% ripper: while_mod!($:3, $:1) %*/
                    }
#line 12266 "parse.c"
    break;

  case 37: /* stmt: stmt "'until' modifier" expr_value  */
#line 3352 "parse.y"
                    {
                        clear_block_exit(p, false);
                        if ((yyvsp[-2].node) && nd_type_p((yyvsp[-2].node), NODE_BEGIN)) {
                            (yyval.node) = NEW_UNTIL(cond(p, (yyvsp[0].node), &(yylsp[0])), RNODE_BEGIN((yyvsp[-2].node))->nd_body, 0, &(yyloc), &(yylsp[-1]), &NULL_LOC);
                        }
                        else {
                            (yyval.node) = NEW_UNTIL(cond(p, (yyvsp[0].node), &(yylsp[0])), (yyvsp[-2].node), 1, &(yyloc), &(yylsp[-1]), &NULL_LOC);
                        }
                    /*% ripper: until_mod!($:3, $:1) %*/
                    }
#line 12281 "parse.c"
    break;

  case 38: /* stmt: stmt "'rescue' modifier" after_rescue stmt  */
#line 3363 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        NODE *resq;
                        YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                        resq = NEW_RESBODY(0, 0, remove_begin((yyvsp[0].node)), 0, &loc);
                        (yyval.node) = NEW_RESCUE(remove_begin((yyvsp[-3].node)), resq, 0, &(yyloc));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 12294 "parse.c"
    break;

  case 39: /* stmt: k_END allow_exits '{' compstmt_stmts '}'  */
#line 3372 "parse.y"
                    {
                        if (p->ctxt.in_def) {
                            rb_warn0("END in method; use at_exit");
                        }
                        restore_block_exit(p, (yyvsp[-3].node_exits));
                        p->ctxt = (yyvsp[-4].ctxt);
                        {
                            NODE *scope = NEW_SCOPE2(0 /* tbl */, 0 /* args */, (yyvsp[-1].node) /* body */, NULL /* parent */, &(yyloc));
                            (yyval.node) = NEW_POSTEXE(scope, &(yyloc), &(yylsp[-4]), &(yylsp[-2]), &(yylsp[0]));
                            RNODE_SCOPE(scope)->nd_parent = (yyval.node);
                        }
                    /*% ripper: END!($:compstmt) %*/
                    }
#line 12312 "parse.c"
    break;

  case 41: /* stmt: mlhs '=' lex_ctxt command_call_value  */
#line 3387 "parse.y"
                    {
                        (yyval.node) = node_assign(p, (NODE *)(yyvsp[-3].node_masgn), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: massign!($:1, $:4) %*/
                    }
#line 12321 "parse.c"
    break;

  case 42: /* asgn_mrhs: lhs '=' lex_ctxt mrhs  */
#line 2919 "parse.y"
                    {
                        (yyval.node) = node_assign(p, (NODE *)(yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: assign!($:1, $:4) %*/
                    }
#line 12330 "parse.c"
    break;

  case 44: /* stmt: mlhs '=' lex_ctxt mrhs_arg "'rescue' modifier" after_rescue stmt  */
#line 3394 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-4].ctxt).in_rescue;
                        YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                        (yyvsp[0].node) = NEW_RESBODY(0, 0, remove_begin((yyvsp[0].node)), 0, &loc);
                        loc.beg_pos = (yylsp[-3]).beg_pos;
                        (yyvsp[-3].node) = NEW_RESCUE((yyvsp[-3].node), (yyvsp[0].node), 0, &loc);
                        (yyval.node) = node_assign(p, (NODE *)(yyvsp[-6].node_masgn), (yyvsp[-3].node), (yyvsp[-4].ctxt), &(yyloc));
                    /*% ripper: massign!($:1, rescue_mod!($:4, $:7)) %*/
                    }
#line 12344 "parse.c"
    break;

  case 45: /* stmt: mlhs '=' lex_ctxt mrhs_arg  */
#line 3404 "parse.y"
                    {
                        (yyval.node) = node_assign(p, (NODE *)(yyvsp[-3].node_masgn), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: massign!($:1, $:4) %*/
                    }
#line 12353 "parse.c"
    break;

  case 47: /* stmt: error  */
#line 3410 "parse.y"
                    {
                        (void)yynerrs;
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    }
#line 12362 "parse.c"
    break;

  case 48: /* asgn_command_rhs: lhs '=' lex_ctxt command_rhs  */
#line 2919 "parse.y"
                    {
                        (yyval.node) = node_assign(p, (NODE *)(yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: assign!($:1, $:4) %*/
                    }
#line 12371 "parse.c"
    break;

  case 50: /* op_asgn_command_rhs: var_lhs "operator-assignment" lex_ctxt command_rhs  */
#line 3045 "parse.y"
                    {
                        (yyval.node) = new_op_assign(p, (yyvsp[-3].node), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!($:1, $:2, $:4) %*/
                    }
#line 12380 "parse.c"
    break;

  case 51: /* op_asgn_command_rhs: primary_value '[' opt_call_args rbracket "operator-assignment" lex_ctxt command_rhs  */
#line 3050 "parse.y"
                    {
                        (yyval.node) = new_ary_op_assign(p, (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[0].node), &(yylsp[-4]), &(yyloc), &NULL_LOC, &(yylsp[-5]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(aref_field!($:1, $:3), $:5, $:7) %*/
                    }
#line 12389 "parse.c"
    break;

  case 52: /* op_asgn_command_rhs: primary_value call_op "local variable or method" "operator-assignment" lex_ctxt command_rhs  */
#line 3055 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), (yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 12398 "parse.c"
    break;

  case 53: /* op_asgn_command_rhs: primary_value call_op "constant" "operator-assignment" lex_ctxt command_rhs  */
#line 3060 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), (yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 12407 "parse.c"
    break;

  case 54: /* op_asgn_command_rhs: primary_value "::" "local variable or method" "operator-assignment" lex_ctxt command_rhs  */
#line 3065 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), idCOLON2, (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 12416 "parse.c"
    break;

  case 55: /* op_asgn_command_rhs: primary_value "::" "constant" "operator-assignment" lex_ctxt command_rhs  */
#line 3070 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-5]), &(yylsp[-3]));
                        (yyval.node) = new_const_op_assign(p, NEW_COLON2((yyvsp[-5].node), (yyvsp[-3].id), &loc, &(yylsp[-4]), &(yylsp[-3])), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!(const_path_field!($:1, $:3), $:4, $:6) %*/
                    }
#line 12426 "parse.c"
    break;

  case 56: /* op_asgn_command_rhs: ":: at EXPR_BEG" "constant" "operator-assignment" lex_ctxt command_rhs  */
#line 3076 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-4]), &(yylsp[-3]));
                        (yyval.node) = new_const_op_assign(p, NEW_COLON3((yyvsp[-3].id), &loc, &(yylsp[-4]), &(yylsp[-3])), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!(top_const_field!($:2), $:3, $:5) %*/
                    }
#line 12436 "parse.c"
    break;

  case 57: /* op_asgn_command_rhs: backref "operator-assignment" lex_ctxt command_rhs  */
#line 3082 "parse.y"
                    {
                        VALUE MAYBE_UNUSED(e) = rb_backref_error(p, (yyvsp[-3].node));
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: assign_error!(?e, opassign!(var_field!($:1), $:2, $:4)) %*/
                    }
#line 12446 "parse.c"
    break;

  case 59: /* def_endless_method_endless_command: defn_head f_opt_paren_args '=' endless_command  */
#line 2950 "parse.y"
                    {
                        endless_method_name(p, (yyvsp[-3].node_def_temp)->nd_mid, &(yylsp[-3]));
                        restore_defun(p, (yyvsp[-3].node_def_temp));
                        ((yyval.node) = (yyvsp[-3].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        (yyvsp[0].node) = new_scope_body(p, (yyvsp[-2].node_args), (yyvsp[0].node), (yyval.node), &(yyloc));
                        RNODE_DEFN((yyval.node))->nd_defn = (yyvsp[0].node);
                    /*% ripper: bodystmt!($:bodystmt, Qnil, Qnil, Qnil) %*/
                    /*% ripper: def!($:head, $:args, $:$) %*/
                        local_pop(p);
                    }
#line 12461 "parse.c"
    break;

  case 60: /* def_endless_method_endless_command: defs_head f_opt_paren_args '=' endless_command  */
#line 2961 "parse.y"
                    {
                        endless_method_name(p, (yyvsp[-3].node_def_temp)->nd_mid, &(yylsp[-3]));
                        restore_defun(p, (yyvsp[-3].node_def_temp));
                        ((yyval.node) = (yyvsp[-3].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        (yyvsp[0].node) = new_scope_body(p, (yyvsp[-2].node_args), (yyvsp[0].node), (yyval.node), &(yyloc));
                        RNODE_DEFS((yyval.node))->nd_defn = (yyvsp[0].node);
                    /*% ripper: bodystmt!($:bodystmt, Qnil, Qnil, Qnil) %*/
                    /*% ripper: defs!(*$:head[0..2], $:args, $:$) %*/
                        local_pop(p);
                    }
#line 12476 "parse.c"
    break;

  case 63: /* endless_command: endless_command "'rescue' modifier" after_rescue arg  */
#line 3423 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        (yyval.node) = rescued_expr(p, (yyvsp[-3].node), (yyvsp[0].node), &(yylsp[-3]), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 12486 "parse.c"
    break;

  case 66: /* endless_command: "'not'" option_'\n' endless_command  */
#line 3429 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), METHOD_NOT, &(yylsp[-2]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idNOT), $:3) %*/
                    }
#line 12495 "parse.c"
    break;

  case 68: /* command_rhs: command_call_value "'rescue' modifier" after_rescue stmt  */
#line 3437 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                        (yyval.node) = NEW_RESCUE((yyvsp[-3].node), NEW_RESBODY(0, 0, remove_begin((yyvsp[0].node)), 0, &loc), 0, &(yyloc));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 12506 "parse.c"
    break;

  case 71: /* expr: expr "'and'" expr  */
#line 3448 "parse.y"
                    {
                        (yyval.node) = logop(p, idAND, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idAND), $:3) %*/
                    }
#line 12515 "parse.c"
    break;

  case 72: /* expr: expr "'or'" expr  */
#line 3453 "parse.y"
                    {
                        (yyval.node) = logop(p, idOR, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idOR), $:3) %*/
                    }
#line 12524 "parse.c"
    break;

  case 73: /* expr: "'not'" option_'\n' expr  */
#line 3458 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), METHOD_NOT, &(yylsp[-2]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idNOT), $:3) %*/
                    }
#line 12533 "parse.c"
    break;

  case 74: /* expr: '!' command_call  */
#line 3463 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), '!', &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL('\'!\''), $:2) %*/
                    }
#line 12542 "parse.c"
    break;

  case 75: /* $@7: %empty  */
#line 3468 "parse.y"
                    {
                        value_expr(p, (yyvsp[-1].node));
                    }
#line 12550 "parse.c"
    break;

  case 76: /* expr: arg "=>" $@7 p_in_kwarg p_pvtbl p_pktbl p_top_expr_body  */
#line 3473 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-1].tbl));
                        pop_pvtbl(p, (yyvsp[-2].tbl));
                        p->ctxt.in_kwarg = (yyvsp[-3].ctxt).in_kwarg;
                        p->ctxt.in_alt_pattern = (yyvsp[-3].ctxt).in_alt_pattern;
                        p->ctxt.capture_in_pattern = (yyvsp[-3].ctxt).capture_in_pattern;
                        (yyval.node) = NEW_CASE3((yyvsp[-6].node), NEW_IN((yyvsp[0].node), 0, 0, &(yylsp[0]), &NULL_LOC, &NULL_LOC, &(yylsp[-5])), &(yyloc), &NULL_LOC, &NULL_LOC);
                    /*% ripper: case!($:arg, in!($:body, Qnil, Qnil)) %*/
                    }
#line 12564 "parse.c"
    break;

  case 77: /* $@8: %empty  */
#line 3483 "parse.y"
                    {
                        value_expr(p, (yyvsp[-1].node));
                    }
#line 12572 "parse.c"
    break;

  case 78: /* expr: arg "'in'" $@8 p_in_kwarg p_pvtbl p_pktbl p_top_expr_body  */
#line 3488 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-1].tbl));
                        pop_pvtbl(p, (yyvsp[-2].tbl));
                        p->ctxt.in_kwarg = (yyvsp[-3].ctxt).in_kwarg;
                        p->ctxt.in_alt_pattern = (yyvsp[-3].ctxt).in_alt_pattern;
                        p->ctxt.capture_in_pattern = (yyvsp[-3].ctxt).capture_in_pattern;
                        (yyval.node) = NEW_CASE3((yyvsp[-6].node), NEW_IN((yyvsp[0].node), NEW_TRUE(&(yylsp[0])), NEW_FALSE(&(yylsp[0])), &(yylsp[0]), &(yylsp[-5]), &NULL_LOC, &NULL_LOC), &(yyloc), &NULL_LOC, &NULL_LOC);
                    /*% ripper: case!($:arg, in!($:body, Qnil, Qnil)) %*/
                    }
#line 12586 "parse.c"
    break;

  case 80: /* def_name: fname  */
#line 3501 "parse.y"
                    {
                        numparam_name(p, (yyvsp[0].id));
                        local_push(p, 0);
                        p->ctxt.in_def = 1;
                        p->ctxt.in_rescue = before_rescue;
                        p->ctxt.cant_return = 0;
                        (yyval.id) = (yyvsp[0].id);
                    }
#line 12599 "parse.c"
    break;

  case 81: /* defn_head: k_def def_name  */
#line 3512 "parse.y"
                    {
                        (yyval.node_def_temp) = def_head_save(p, (yyvsp[-1].node_def_temp));
                        (yyval.node_def_temp)->nd_mid = (yyvsp[0].id);
                        (yyval.node_def_temp)->nd_def = NEW_DEFN((yyvsp[0].id), 0, &(yyloc));
                    /*% ripper: $:def_name %*/
                    }
#line 12610 "parse.c"
    break;

  case 82: /* $@9: %empty  */
#line 3521 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_FNAME);
                    }
#line 12618 "parse.c"
    break;

  case 83: /* defs_head: k_def singleton dot_or_colon $@9 def_name  */
#line 3525 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_ENDFN|EXPR_LABEL); /* force for args */
                        (yyval.node_def_temp) = def_head_save(p, (yyvsp[-4].node_def_temp));
                        (yyval.node_def_temp)->nd_mid = (yyvsp[0].id);
                        (yyval.node_def_temp)->nd_def = NEW_DEFS((yyvsp[-3].node), (yyvsp[0].id), 0, &(yyloc));
                    /*% ripper: [$:singleton, $:dot_or_colon, $:def_name] %*/
                    }
#line 12630 "parse.c"
    break;

  case 84: /* value_expr_expr: expr  */
#line 3145 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 12639 "parse.c"
    break;

  case 86: /* expr_value: error  */
#line 3536 "parse.y"
                    {
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    }
#line 12647 "parse.c"
    break;

  case 87: /* $@10: %empty  */
#line 3541 "parse.y"
                {COND_PUSH(1);}
#line 12653 "parse.c"
    break;

  case 88: /* $@11: %empty  */
#line 3541 "parse.y"
                                              {COND_POP();}
#line 12659 "parse.c"
    break;

  case 89: /* expr_value_do: $@10 expr_value do $@11  */
#line 3542 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-2].node);
                    /*% ripper: $:2 %*/
                    }
#line 12668 "parse.c"
    break;

  case 92: /* value_expr_command_call: command_call  */
#line 3145 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 12677 "parse.c"
    break;

  case 95: /* block_command: block_call call_op2 operation2 command_args  */
#line 3557 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, (yyvsp[-2].id), (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: method_add_arg!(call!($:1, $:2, $:3), $:4) %*/
                    }
#line 12686 "parse.c"
    break;

  case 96: /* cmd_brace_block: "{ arg" brace_body '}'  */
#line 3564 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                        set_embraced_location((yyval.node), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: $:2 %*/
                    }
#line 12696 "parse.c"
    break;

  case 97: /* fcall: "local variable or method"  */
#line 3572 "parse.y"
                    {
                        (yyval.node_fcall) = NEW_FCALL((yyvsp[0].id), 0, &(yyloc));
                    /*% ripper: $:1 %*/
                    }
#line 12705 "parse.c"
    break;

  case 98: /* fcall: "constant"  */
#line 3572 "parse.y"
                    {
                        (yyval.node_fcall) = NEW_FCALL((yyvsp[0].id), 0, &(yyloc));
                    /*% ripper: $:1 %*/
                    }
#line 12714 "parse.c"
    break;

  case 99: /* fcall: "method"  */
#line 3572 "parse.y"
                    {
                        (yyval.node_fcall) = NEW_FCALL((yyvsp[0].id), 0, &(yyloc));
                    /*% ripper: $:1 %*/
                    }
#line 12723 "parse.c"
    break;

  case 100: /* command: fcall command_args  */
#line 3579 "parse.y"
                    {
                        (yyvsp[-1].node_fcall)->nd_args = (yyvsp[0].node);
                        nd_set_last_loc((yyvsp[-1].node_fcall), (yylsp[0]).end_pos);
                        (yyval.node) = (NODE *)(yyvsp[-1].node_fcall);
                    /*% ripper: command!($:1, $:2) %*/
                    }
#line 12734 "parse.c"
    break;

  case 101: /* command: fcall command_args cmd_brace_block  */
#line 3586 "parse.y"
                    {
                        block_dup_check(p, (yyvsp[-1].node), (yyvsp[0].node));
                        (yyvsp[-2].node_fcall)->nd_args = (yyvsp[-1].node);
                        (yyval.node) = method_add_block(p, (NODE *)(yyvsp[-2].node_fcall), (yyvsp[0].node), &(yyloc));
                        fixpos((yyval.node), RNODE((yyvsp[-2].node_fcall)));
                        nd_set_last_loc((yyvsp[-2].node_fcall), (yylsp[-1]).end_pos);
                    /*% ripper: method_add_block!(command!($:1, $:2), $:3) %*/
                    }
#line 12747 "parse.c"
    break;

  case 102: /* command: primary_value call_op operation2 command_args  */
#line 3595 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, (yyvsp[-2].id), (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), 0, &(yylsp[-1]), &(yyloc));
                    /*% ripper: command_call!($:1, $:2, $:3, $:4) %*/
                    }
#line 12756 "parse.c"
    break;

  case 103: /* command: primary_value call_op operation2 command_args cmd_brace_block  */
#line 3600 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, (yyvsp[-3].id), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[-1].node), (yyvsp[0].node), &(yylsp[-2]), &(yyloc));
                    /*% ripper: method_add_block!(command_call!($:1, $:2, $:3, $:4), $:5) %*/
                    }
#line 12765 "parse.c"
    break;

  case 104: /* command: primary_value "::" operation2 command_args  */
#line 3605 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, idCOLON2, (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), 0, &(yylsp[-1]), &(yyloc));
                    /*% ripper: command_call!($:1, $:2, $:3, $:4) %*/
                    }
#line 12774 "parse.c"
    break;

  case 105: /* command: primary_value "::" operation2 command_args cmd_brace_block  */
#line 3610 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, idCOLON2, (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[-1].node), (yyvsp[0].node), &(yylsp[-2]), &(yyloc));
                    /*% ripper: method_add_block!(command_call!($:1, $:2, $:3, $:4), $:5) %*/
                   }
#line 12783 "parse.c"
    break;

  case 106: /* command: primary_value "::" "constant" '{' brace_body '}'  */
#line 3615 "parse.y"
                    {
                        set_embraced_location((yyvsp[-1].node), &(yylsp[-2]), &(yylsp[0]));
                        (yyval.node) = new_command_qcall(p, idCOLON2, (yyvsp[-5].node), (yyvsp[-3].id), 0, (yyvsp[-1].node), &(yylsp[-3]), &(yyloc));
                    /*% ripper: method_add_block!(command_call!($:1, $:2, $:3, Qnil), $:5) %*/
                   }
#line 12793 "parse.c"
    break;

  case 107: /* command: "'super'" command_args  */
#line 3621 "parse.y"
                    {
                        (yyval.node) = NEW_SUPER((yyvsp[0].node), &(yyloc), &(yylsp[-1]), &NULL_LOC, &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: super!($:2) %*/
                    }
#line 12803 "parse.c"
    break;

  case 108: /* command: k_yield command_args  */
#line 3627 "parse.y"
                    {
                        (yyval.node) = NEW_YIELD((yyvsp[0].node), &(yyloc), &(yylsp[-1]), &NULL_LOC, &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: yield!($:2) %*/
                    }
#line 12813 "parse.c"
    break;

  case 109: /* command: k_return call_args  */
#line 3633 "parse.y"
                    {
                        (yyval.node) = NEW_RETURN(ret_args(p, (yyvsp[0].node)), &(yyloc), &(yylsp[-1]));
                    /*% ripper: return!($:2) %*/
                    }
#line 12822 "parse.c"
    break;

  case 110: /* command: "'break'" call_args  */
#line 3638 "parse.y"
                    {
                        NODE *args = 0;
                        args = ret_args(p, (yyvsp[0].node));
                        (yyval.node) = add_block_exit(p, NEW_BREAK(args, &(yyloc), &(yylsp[-1])));
                    /*% ripper: break!($:2) %*/
                    }
#line 12833 "parse.c"
    break;

  case 111: /* command: "'next'" call_args  */
#line 3645 "parse.y"
                    {
                        NODE *args = 0;
                        args = ret_args(p, (yyvsp[0].node));
                        (yyval.node) = add_block_exit(p, NEW_NEXT(args, &(yyloc), &(yylsp[-1])));
                    /*% ripper: next!($:2) %*/
                    }
#line 12844 "parse.c"
    break;

  case 113: /* mlhs: "(" mlhs_inner rparen  */
#line 3655 "parse.y"
                    {
                        (yyval.node_masgn) = (yyvsp[-1].node_masgn);
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 12853 "parse.c"
    break;

  case 115: /* mlhs_inner: "(" mlhs_inner rparen  */
#line 3663 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(NEW_LIST((NODE *)(yyvsp[-1].node_masgn), &(yyloc)), 0, &(yyloc));
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 12862 "parse.c"
    break;

  case 116: /* mlhs_basic: mlhs_head  */
#line 3670 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[0].node), 0, &(yyloc));
                    /*% ripper: $:1 %*/
                    }
#line 12871 "parse.c"
    break;

  case 117: /* mlhs_basic: mlhs_head mlhs_item  */
#line 3675 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(list_append(p, (yyvsp[-1].node), (yyvsp[0].node)), 0, &(yyloc));
                    /*% ripper: mlhs_add!($:1, $:2) %*/
                    }
#line 12880 "parse.c"
    break;

  case 118: /* mlhs_basic: mlhs_head "*" mlhs_node  */
#line 3680 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add_star!($:1, $:3) %*/
                    }
#line 12889 "parse.c"
    break;

  case 119: /* mlhs_items_mlhs_item: mlhs_item  */
#line 3032 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add!(mlhs_new!, $:1) %*/
                    }
#line 12898 "parse.c"
    break;

  case 120: /* mlhs_items_mlhs_item: mlhs_items_mlhs_item ',' mlhs_item  */
#line 3037 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), (yyvsp[0].node));
                    /*% ripper: mlhs_add!($:1, $:3) %*/
                    }
#line 12907 "parse.c"
    break;

  case 121: /* mlhs_basic: mlhs_head "*" mlhs_node ',' mlhs_items_mlhs_item  */
#line 3685 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-4].node), NEW_POSTARG((yyvsp[-2].node),(yyvsp[0].node),&(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!($:1, $:3), $:5) %*/
                    }
#line 12916 "parse.c"
    break;

  case 122: /* mlhs_basic: mlhs_head "*"  */
#line 3690 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-1].node), NODE_SPECIAL_NO_NAME_REST, &(yyloc));
                    /*% ripper: mlhs_add_star!($:1, Qnil) %*/
                    }
#line 12925 "parse.c"
    break;

  case 123: /* mlhs_basic: mlhs_head "*" ',' mlhs_items_mlhs_item  */
#line 3695 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-3].node), NEW_POSTARG(NODE_SPECIAL_NO_NAME_REST, (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!($:1, Qnil), $:4) %*/
                    }
#line 12934 "parse.c"
    break;

  case 124: /* mlhs_basic: "*" mlhs_node  */
#line 3700 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add_star!(mlhs_new!, $:2) %*/
                    }
#line 12943 "parse.c"
    break;

  case 125: /* mlhs_basic: "*" mlhs_node ',' mlhs_items_mlhs_item  */
#line 3705 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, NEW_POSTARG((yyvsp[-2].node),(yyvsp[0].node),&(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!(mlhs_new!, $:2), $:4) %*/
                    }
#line 12952 "parse.c"
    break;

  case 126: /* mlhs_basic: "*"  */
#line 3710 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, NODE_SPECIAL_NO_NAME_REST, &(yyloc));
                    /*% ripper: mlhs_add_star!(mlhs_new!, Qnil) %*/
                    }
#line 12961 "parse.c"
    break;

  case 127: /* mlhs_basic: "*" ',' mlhs_items_mlhs_item  */
#line 3715 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, NEW_POSTARG(NODE_SPECIAL_NO_NAME_REST, (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!(mlhs_new!, Qnil), $:3) %*/
                    }
#line 12970 "parse.c"
    break;

  case 129: /* mlhs_item: "(" mlhs_inner rparen  */
#line 3723 "parse.y"
                    {
                        (yyval.node) = (NODE *)(yyvsp[-1].node_masgn);
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 12979 "parse.c"
    break;

  case 130: /* mlhs_head: mlhs_item ','  */
#line 3730 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[-1].node), &(yylsp[-1]));
                    /*% ripper: mlhs_add!(mlhs_new!, $:1) %*/
                    }
#line 12988 "parse.c"
    break;

  case 131: /* mlhs_head: mlhs_head mlhs_item ','  */
#line 3735 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), (yyvsp[-1].node));
                    /*% ripper: mlhs_add!($:1, $:2) %*/
                    }
#line 12997 "parse.c"
    break;

  case 132: /* mlhs_node: user_variable  */
#line 3743 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 13006 "parse.c"
    break;

  case 133: /* mlhs_node: keyword_variable  */
#line 3743 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 13015 "parse.c"
    break;

  case 134: /* mlhs_node: primary_value '[' opt_call_args rbracket  */
#line 3748 "parse.y"
                    {
                        (yyval.node) = aryset(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                    /*% ripper: aref_field!($:1, $:3) %*/
                    }
#line 13024 "parse.c"
    break;

  case 135: /* mlhs_node: primary_value call_op "local variable or method"  */
#line 3753 "parse.y"
                    {
                        anddot_multiple_assignment_check(p, &(yylsp[-1]), (yyvsp[-1].id));
                        (yyval.node) = attrset(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 13034 "parse.c"
    break;

  case 136: /* mlhs_node: primary_value call_op "constant"  */
#line 3753 "parse.y"
                    {
                        anddot_multiple_assignment_check(p, &(yylsp[-1]), (yyvsp[-1].id));
                        (yyval.node) = attrset(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 13044 "parse.c"
    break;

  case 137: /* mlhs_node: primary_value "::" "local variable or method"  */
#line 3759 "parse.y"
                    {
                        (yyval.node) = attrset(p, (yyvsp[-2].node), idCOLON2, (yyvsp[0].id), &(yyloc));
                    /*% ripper: const_path_field!($:1, $:3) %*/
                    }
#line 13053 "parse.c"
    break;

  case 138: /* mlhs_node: primary_value "::" "constant"  */
#line 3764 "parse.y"
                    {
                    /*% ripper: const_path_field!($:1, $:3) %*/
                        (yyval.node) = const_decl(p, NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0])), &(yyloc));
                    }
#line 13062 "parse.c"
    break;

  case 139: /* mlhs_node: ":: at EXPR_BEG" "constant"  */
#line 3769 "parse.y"
                    {
                    /*% ripper: top_const_field!($:2) %*/
                        (yyval.node) = const_decl(p, NEW_COLON3((yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0])), &(yyloc));
                    }
#line 13071 "parse.c"
    break;

  case 140: /* mlhs_node: backref  */
#line 3774 "parse.y"
                    {
                        VALUE MAYBE_UNUSED(e) = rb_backref_error(p, (yyvsp[0].node));
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: assign_error!(?e, var_field!($:1)) %*/
                    }
#line 13081 "parse.c"
    break;

  case 141: /* lhs: user_variable  */
#line 3782 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 13090 "parse.c"
    break;

  case 142: /* lhs: keyword_variable  */
#line 3782 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 13099 "parse.c"
    break;

  case 143: /* lhs: primary_value '[' opt_call_args rbracket  */
#line 3787 "parse.y"
                    {
                        (yyval.node) = aryset(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                    /*% ripper: aref_field!($:1, $:3) %*/
                    }
#line 13108 "parse.c"
    break;

  case 144: /* lhs: primary_value call_op "local variable or method"  */
#line 3792 "parse.y"
                    {
                        (yyval.node) = attrset(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 13117 "parse.c"
    break;

  case 145: /* lhs: primary_value call_op "constant"  */
#line 3792 "parse.y"
                    {
                        (yyval.node) = attrset(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 13126 "parse.c"
    break;

  case 146: /* lhs: primary_value "::" "local variable or method"  */
#line 3797 "parse.y"
                    {
                        (yyval.node) = attrset(p, (yyvsp[-2].node), idCOLON2, (yyvsp[0].id), &(yyloc));
                    /*% ripper: field!($:1, $:2, $:3) %*/
                    }
#line 13135 "parse.c"
    break;

  case 147: /* lhs: primary_value "::" "constant"  */
#line 3802 "parse.y"
                    {
                    /*% ripper: const_path_field!($:1, $:3) %*/
                        (yyval.node) = const_decl(p, NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0])), &(yyloc));
                    }
#line 13144 "parse.c"
    break;

  case 148: /* lhs: ":: at EXPR_BEG" "constant"  */
#line 3807 "parse.y"
                    {
                    /*% ripper: top_const_field!($:2) %*/
                        (yyval.node) = const_decl(p, NEW_COLON3((yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0])), &(yyloc));
                    }
#line 13153 "parse.c"
    break;

  case 149: /* lhs: backref  */
#line 3812 "parse.y"
                    {
                        VALUE MAYBE_UNUSED(e) = rb_backref_error(p, (yyvsp[0].node));
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: assign_error!(?e, var_field!($:1)) %*/
                    }
#line 13163 "parse.c"
    break;

  case 150: /* cname: "local variable or method"  */
#line 3820 "parse.y"
                    {
                        static const char mesg[] = "class/module name must be CONSTANT";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                    /*% ripper[error]: class_name_error!(ERR_MESG(), $:1) %*/
                    }
#line 13175 "parse.c"
    break;

  case 152: /* cpath: ":: at EXPR_BEG" cname  */
#line 3831 "parse.y"
                    {
                        (yyval.node) = NEW_COLON3((yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0]));
                    /*% ripper: top_const_ref!($:2) %*/
                    }
#line 13184 "parse.c"
    break;

  case 153: /* cpath: cname  */
#line 3836 "parse.y"
                    {
                        (yyval.node) = NEW_COLON2(0, (yyvsp[0].id), &(yyloc), &NULL_LOC, &(yylsp[0]));
                    /*% ripper: const_ref!($:1) %*/
                    }
#line 13193 "parse.c"
    break;

  case 154: /* cpath: primary_value "::" cname  */
#line 3841 "parse.y"
                    {
                        (yyval.node) = NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0]));
                    /*% ripper: const_path_ref!($:1, $:3) %*/
                    }
#line 13202 "parse.c"
    break;

  case 158: /* fname: op  */
#line 3849 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_ENDFN);
                        (yyval.id) = (yyvsp[0].id);
                    }
#line 13211 "parse.c"
    break;

  case 160: /* fitem: fname  */
#line 3857 "parse.y"
                    {
                        (yyval.node) = NEW_SYM(rb_id2str((yyvsp[0].id)), &(yyloc));
                    /*% ripper: symbol_literal!($:1) %*/
                    }
#line 13220 "parse.c"
    break;

  case 162: /* undef_list: fitem  */
#line 3865 "parse.y"
                    {
                        (yyval.node) = NEW_UNDEF((yyvsp[0].node), &(yyloc));
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 13229 "parse.c"
    break;

  case 163: /* $@12: %empty  */
#line 3869 "parse.y"
                                 {SET_LEX_STATE(EXPR_FNAME|EXPR_FITEM);}
#line 13235 "parse.c"
    break;

  case 164: /* undef_list: undef_list ',' $@12 fitem  */
#line 3870 "parse.y"
                    {
                        nd_set_last_loc((yyvsp[-3].node), (yylsp[0]).end_pos);
                        rb_parser_ary_push_node(p, RNODE_UNDEF((yyvsp[-3].node))->nd_undefs, (yyvsp[0].node));
                    /*% ripper: rb_ary_push($:1, $:4) %*/
                    }
#line 13245 "parse.c"
    break;

  case 165: /* op: '|'  */
#line 3877 "parse.y"
           { (yyval.id) = '|'; }
#line 13251 "parse.c"
    break;

  case 166: /* op: '^'  */
#line 3878 "parse.y"
                       { (yyval.id) = '^'; }
#line 13257 "parse.c"
    break;

  case 167: /* op: '&'  */
#line 3879 "parse.y"
                       { (yyval.id) = '&'; }
#line 13263 "parse.c"
    break;

  case 168: /* op: "<=>"  */
#line 3880 "parse.y"
                        { (yyval.id) = tCMP; }
#line 13269 "parse.c"
    break;

  case 169: /* op: "=="  */
#line 3881 "parse.y"
                       { (yyval.id) = tEQ; }
#line 13275 "parse.c"
    break;

  case 170: /* op: "==="  */
#line 3882 "parse.y"
                        { (yyval.id) = tEQQ; }
#line 13281 "parse.c"
    break;

  case 171: /* op: "=~"  */
#line 3883 "parse.y"
                         { (yyval.id) = tMATCH; }
#line 13287 "parse.c"
    break;

  case 172: /* op: "!~"  */
#line 3884 "parse.y"
                          { (yyval.id) = tNMATCH; }
#line 13293 "parse.c"
    break;

  case 173: /* op: '>'  */
#line 3885 "parse.y"
                       { (yyval.id) = '>'; }
#line 13299 "parse.c"
    break;

  case 174: /* op: ">="  */
#line 3886 "parse.y"
                        { (yyval.id) = tGEQ; }
#line 13305 "parse.c"
    break;

  case 175: /* op: '<'  */
#line 3887 "parse.y"
                       { (yyval.id) = '<'; }
#line 13311 "parse.c"
    break;

  case 176: /* op: "<="  */
#line 3888 "parse.y"
                        { (yyval.id) = tLEQ; }
#line 13317 "parse.c"
    break;

  case 177: /* op: "!="  */
#line 3889 "parse.y"
                        { (yyval.id) = tNEQ; }
#line 13323 "parse.c"
    break;

  case 178: /* op: "<<"  */
#line 3890 "parse.y"
                         { (yyval.id) = tLSHFT; }
#line 13329 "parse.c"
    break;

  case 179: /* op: ">>"  */
#line 3891 "parse.y"
                         { (yyval.id) = tRSHFT; }
#line 13335 "parse.c"
    break;

  case 180: /* op: '+'  */
#line 3892 "parse.y"
                       { (yyval.id) = '+'; }
#line 13341 "parse.c"
    break;

  case 181: /* op: '-'  */
#line 3893 "parse.y"
                       { (yyval.id) = '-'; }
#line 13347 "parse.c"
    break;

  case 182: /* op: '*'  */
#line 3894 "parse.y"
                       { (yyval.id) = '*'; }
#line 13353 "parse.c"
    break;

  case 183: /* op: "*"  */
#line 3895 "parse.y"
                         { (yyval.id) = '*'; }
#line 13359 "parse.c"
    break;

  case 184: /* op: '/'  */
#line 3896 "parse.y"
                       { (yyval.id) = '/'; }
#line 13365 "parse.c"
    break;

  case 185: /* op: '%'  */
#line 3897 "parse.y"
                       { (yyval.id) = '%'; }
#line 13371 "parse.c"
    break;

  case 186: /* op: "**"  */
#line 3898 "parse.y"
                        { (yyval.id) = tPOW; }
#line 13377 "parse.c"
    break;

  case 187: /* op: "**arg"  */
#line 3899 "parse.y"
                         { (yyval.id) = tDSTAR; }
#line 13383 "parse.c"
    break;

  case 188: /* op: '!'  */
#line 3900 "parse.y"
                       { (yyval.id) = '!'; }
#line 13389 "parse.c"
    break;

  case 189: /* op: '~'  */
#line 3901 "parse.y"
                       { (yyval.id) = '~'; }
#line 13395 "parse.c"
    break;

  case 190: /* op: "unary+"  */
#line 3902 "parse.y"
                         { (yyval.id) = tUPLUS; }
#line 13401 "parse.c"
    break;

  case 191: /* op: "unary-"  */
#line 3903 "parse.y"
                          { (yyval.id) = tUMINUS; }
#line 13407 "parse.c"
    break;

  case 192: /* op: "[]"  */
#line 3904 "parse.y"
                         { (yyval.id) = tAREF; }
#line 13413 "parse.c"
    break;

  case 193: /* op: "[]="  */
#line 3905 "parse.y"
                         { (yyval.id) = tASET; }
#line 13419 "parse.c"
    break;

  case 194: /* op: '`'  */
#line 3906 "parse.y"
                       { (yyval.id) = '`'; }
#line 13425 "parse.c"
    break;

  case 236: /* asgn_arg_rhs: lhs '=' lex_ctxt arg_rhs  */
#line 2919 "parse.y"
                    {
                        (yyval.node) = node_assign(p, (NODE *)(yyvsp[-3].node), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: assign!($:1, $:4) %*/
                    }
#line 13434 "parse.c"
    break;

  case 238: /* op_asgn_arg_rhs: var_lhs "operator-assignment" lex_ctxt arg_rhs  */
#line 3045 "parse.y"
                    {
                        (yyval.node) = new_op_assign(p, (yyvsp[-3].node), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!($:1, $:2, $:4) %*/
                    }
#line 13443 "parse.c"
    break;

  case 239: /* op_asgn_arg_rhs: primary_value '[' opt_call_args rbracket "operator-assignment" lex_ctxt arg_rhs  */
#line 3050 "parse.y"
                    {
                        (yyval.node) = new_ary_op_assign(p, (yyvsp[-6].node), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[0].node), &(yylsp[-4]), &(yyloc), &NULL_LOC, &(yylsp[-5]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(aref_field!($:1, $:3), $:5, $:7) %*/
                    }
#line 13452 "parse.c"
    break;

  case 240: /* op_asgn_arg_rhs: primary_value call_op "local variable or method" "operator-assignment" lex_ctxt arg_rhs  */
#line 3055 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), (yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 13461 "parse.c"
    break;

  case 241: /* op_asgn_arg_rhs: primary_value call_op "constant" "operator-assignment" lex_ctxt arg_rhs  */
#line 3060 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), (yyvsp[-4].id), (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 13470 "parse.c"
    break;

  case 242: /* op_asgn_arg_rhs: primary_value "::" "local variable or method" "operator-assignment" lex_ctxt arg_rhs  */
#line 3065 "parse.y"
                    {
                        (yyval.node) = new_attr_op_assign(p, (yyvsp[-5].node), idCOLON2, (yyvsp[-3].id), (yyvsp[-2].id), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-3]), &(yylsp[-2]));
                    /*% ripper: opassign!(field!($:1, $:2, $:3), $:4, $:6) %*/
                    }
#line 13479 "parse.c"
    break;

  case 243: /* op_asgn_arg_rhs: primary_value "::" "constant" "operator-assignment" lex_ctxt arg_rhs  */
#line 3070 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-5]), &(yylsp[-3]));
                        (yyval.node) = new_const_op_assign(p, NEW_COLON2((yyvsp[-5].node), (yyvsp[-3].id), &loc, &(yylsp[-4]), &(yylsp[-3])), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!(const_path_field!($:1, $:3), $:4, $:6) %*/
                    }
#line 13489 "parse.c"
    break;

  case 244: /* op_asgn_arg_rhs: ":: at EXPR_BEG" "constant" "operator-assignment" lex_ctxt arg_rhs  */
#line 3076 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-4]), &(yylsp[-3]));
                        (yyval.node) = new_const_op_assign(p, NEW_COLON3((yyvsp[-3].id), &loc, &(yylsp[-4]), &(yylsp[-3])), (yyvsp[-2].id), (yyvsp[0].node), (yyvsp[-1].ctxt), &(yyloc));
                    /*% ripper: opassign!(top_const_field!($:2), $:3, $:5) %*/
                    }
#line 13499 "parse.c"
    break;

  case 245: /* op_asgn_arg_rhs: backref "operator-assignment" lex_ctxt arg_rhs  */
#line 3082 "parse.y"
                    {
                        VALUE MAYBE_UNUSED(e) = rb_backref_error(p, (yyvsp[-3].node));
                        (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper[error]: assign_error!(?e, opassign!(var_field!($:1), $:2, $:4)) %*/
                    }
#line 13509 "parse.c"
    break;

  case 247: /* range_expr_arg: arg ".." arg  */
#line 3104 "parse.y"
                    {
                        value_expr(p, (yyvsp[-2].node));
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = NEW_DOT2((yyvsp[-2].node), (yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: dot2!($:1, $:3) %*/
                    }
#line 13520 "parse.c"
    break;

  case 248: /* range_expr_arg: arg "..." arg  */
#line 3111 "parse.y"
                    {
                        value_expr(p, (yyvsp[-2].node));
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = NEW_DOT3((yyvsp[-2].node), (yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: dot3!($:1, $:3) %*/
                    }
#line 13531 "parse.c"
    break;

  case 249: /* range_expr_arg: arg ".."  */
#line 3118 "parse.y"
                    {
                        value_expr(p, (yyvsp[-1].node));
                        (yyval.node) = NEW_DOT2((yyvsp[-1].node), new_nil_at(p, &(yylsp[0]).end_pos), &(yyloc), &(yylsp[0]));
                    /*% ripper: dot2!($:1, Qnil) %*/
                    }
#line 13541 "parse.c"
    break;

  case 250: /* range_expr_arg: arg "..."  */
#line 3124 "parse.y"
                    {
                        value_expr(p, (yyvsp[-1].node));
                        (yyval.node) = NEW_DOT3((yyvsp[-1].node), new_nil_at(p, &(yylsp[0]).end_pos), &(yyloc), &(yylsp[0]));
                    /*% ripper: dot3!($:1, Qnil) %*/
                    }
#line 13551 "parse.c"
    break;

  case 251: /* range_expr_arg: "(.." arg  */
#line 3130 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = NEW_DOT2(new_nil_at(p, &(yylsp[-1]).beg_pos), (yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: dot2!(Qnil, $:2) %*/
                    }
#line 13561 "parse.c"
    break;

  case 252: /* range_expr_arg: "(..." arg  */
#line 3136 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = NEW_DOT3(new_nil_at(p, &(yylsp[-1]).beg_pos), (yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: dot3!(Qnil, $:2) %*/
                    }
#line 13571 "parse.c"
    break;

  case 254: /* arg: arg '+' arg  */
#line 3927 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '+', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'+\''), $:3) %*/
                    }
#line 13580 "parse.c"
    break;

  case 255: /* arg: arg '-' arg  */
#line 3932 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '-', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'-\''), $:3) %*/
                    }
#line 13589 "parse.c"
    break;

  case 256: /* arg: arg '*' arg  */
#line 3937 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '*', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'*\''), $:3) %*/
                    }
#line 13598 "parse.c"
    break;

  case 257: /* arg: arg '/' arg  */
#line 3942 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '/', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'/\''), $:3) %*/
                    }
#line 13607 "parse.c"
    break;

  case 258: /* arg: arg '%' arg  */
#line 3947 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '%', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'%\''), $:3) %*/
                    }
#line 13616 "parse.c"
    break;

  case 259: /* arg: arg "**" arg  */
#line 3952 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idPow, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idPow), $:3) %*/
                    }
#line 13625 "parse.c"
    break;

  case 260: /* arg: tUMINUS_NUM simple_numeric "**" arg  */
#line 3957 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, call_bin_op(p, (yyvsp[-2].node), idPow, (yyvsp[0].node), &(yylsp[-2]), &(yyloc)), idUMinus, &(yylsp[-3]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idUMinus), binary!($:2, ID2VAL(idPow), $:4)) %*/
                    }
#line 13634 "parse.c"
    break;

  case 261: /* arg: "unary+" arg  */
#line 3962 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, (yyvsp[0].node), idUPlus, &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idUPlus), $:2) %*/
                    }
#line 13643 "parse.c"
    break;

  case 262: /* arg: "unary-" arg  */
#line 3967 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, (yyvsp[0].node), idUMinus, &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idUMinus), $:2) %*/
                    }
#line 13652 "parse.c"
    break;

  case 263: /* arg: arg '|' arg  */
#line 3972 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '|', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'|\''), $:3) %*/
                    }
#line 13661 "parse.c"
    break;

  case 264: /* arg: arg '^' arg  */
#line 3977 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '^', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'^\''), $:3) %*/
                    }
#line 13670 "parse.c"
    break;

  case 265: /* arg: arg '&' arg  */
#line 3982 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), '&', (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL('\'&\''), $:3) %*/
                    }
#line 13679 "parse.c"
    break;

  case 266: /* arg: arg "<=>" arg  */
#line 3987 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idCmp, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idCmp), $:3) %*/
                    }
#line 13688 "parse.c"
    break;

  case 268: /* arg: arg "==" arg  */
#line 3993 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idEq, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idEq), $:3) %*/
                    }
#line 13697 "parse.c"
    break;

  case 269: /* arg: arg "===" arg  */
#line 3998 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idEqq, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idEqq), $:3) %*/
                    }
#line 13706 "parse.c"
    break;

  case 270: /* arg: arg "!=" arg  */
#line 4003 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idNeq, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idNeq), $:3) %*/
                    }
#line 13715 "parse.c"
    break;

  case 271: /* arg: arg "=~" arg  */
#line 4008 "parse.y"
                    {
                        (yyval.node) = match_op(p, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idEqTilde), $:3) %*/
                    }
#line 13724 "parse.c"
    break;

  case 272: /* arg: arg "!~" arg  */
#line 4013 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idNeqTilde, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idNeqTilde), $:3) %*/
                    }
#line 13733 "parse.c"
    break;

  case 273: /* arg: '!' arg  */
#line 4018 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), '!', &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL('\'!\''), $:2) %*/
                    }
#line 13742 "parse.c"
    break;

  case 274: /* arg: '~' arg  */
#line 4023 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, (yyvsp[0].node), '~', &(yylsp[-1]), &(yyloc));
                    /*% ripper: unary!(ID2VAL('\'~\''), $:2) %*/
                    }
#line 13751 "parse.c"
    break;

  case 275: /* arg: arg "<<" arg  */
#line 4028 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idLTLT, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idLTLT), $:3) %*/
                    }
#line 13760 "parse.c"
    break;

  case 276: /* arg: arg ">>" arg  */
#line 4033 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), idGTGT, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idGTGT), $:3) %*/
                    }
#line 13769 "parse.c"
    break;

  case 277: /* arg: arg "&&" arg  */
#line 4038 "parse.y"
                    {
                        (yyval.node) = logop(p, idANDOP, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idANDOP), $:3) %*/
                    }
#line 13778 "parse.c"
    break;

  case 278: /* arg: arg "||" arg  */
#line 4043 "parse.y"
                    {
                        (yyval.node) = logop(p, idOROP, (yyvsp[-2].node), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL(idOROP), $:3) %*/
                    }
#line 13787 "parse.c"
    break;

  case 279: /* arg: "'defined?'" option_'\n' begin_defined arg  */
#line 4048 "parse.y"
                    {
                        p->ctxt.in_defined = (yyvsp[-1].ctxt).in_defined;
                        (yyval.node) = new_defined(p, (yyvsp[0].node), &(yyloc), &(yylsp[-3]));
                        p->ctxt.has_trailing_semicolon = (yyvsp[-1].ctxt).has_trailing_semicolon;
                    /*% ripper: defined!($:4) %*/
                    }
#line 13798 "parse.c"
    break;

  case 280: /* def_endless_method_endless_arg: defn_head f_opt_paren_args '=' endless_arg  */
#line 2950 "parse.y"
                    {
                        endless_method_name(p, (yyvsp[-3].node_def_temp)->nd_mid, &(yylsp[-3]));
                        restore_defun(p, (yyvsp[-3].node_def_temp));
                        ((yyval.node) = (yyvsp[-3].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        (yyvsp[0].node) = new_scope_body(p, (yyvsp[-2].node_args), (yyvsp[0].node), (yyval.node), &(yyloc));
                        RNODE_DEFN((yyval.node))->nd_defn = (yyvsp[0].node);
                    /*% ripper: bodystmt!($:bodystmt, Qnil, Qnil, Qnil) %*/
                    /*% ripper: def!($:head, $:args, $:$) %*/
                        local_pop(p);
                    }
#line 13813 "parse.c"
    break;

  case 281: /* def_endless_method_endless_arg: defs_head f_opt_paren_args '=' endless_arg  */
#line 2961 "parse.y"
                    {
                        endless_method_name(p, (yyvsp[-3].node_def_temp)->nd_mid, &(yylsp[-3]));
                        restore_defun(p, (yyvsp[-3].node_def_temp));
                        ((yyval.node) = (yyvsp[-3].node_def_temp)->nd_def)->nd_loc = (yyloc);
                        (yyvsp[0].node) = new_scope_body(p, (yyvsp[-2].node_args), (yyvsp[0].node), (yyval.node), &(yyloc));
                        RNODE_DEFS((yyval.node))->nd_defn = (yyvsp[0].node);
                    /*% ripper: bodystmt!($:bodystmt, Qnil, Qnil, Qnil) %*/
                    /*% ripper: defs!(*$:head[0..2], $:args, $:$) %*/
                        local_pop(p);
                    }
#line 13828 "parse.c"
    break;

  case 285: /* ternary: arg '?' arg option_'\n' ':' arg  */
#line 4060 "parse.y"
                    {
                        value_expr(p, (yyvsp[-5].node));
                        (yyval.node) = new_if(p, (yyvsp[-5].node), (yyvsp[-3].node), (yyvsp[0].node), &(yyloc), &NULL_LOC, &(yylsp[-1]), &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[-5].node));
                    /*% ripper: ifop!($:1, $:3, $:6) %*/
                    }
#line 13839 "parse.c"
    break;

  case 287: /* endless_arg: endless_arg "'rescue' modifier" after_rescue arg  */
#line 4070 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        (yyval.node) = rescued_expr(p, (yyvsp[-3].node), (yyvsp[0].node), &(yylsp[-3]), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 13849 "parse.c"
    break;

  case 288: /* endless_arg: "'not'" option_'\n' endless_arg  */
#line 4076 "parse.y"
                    {
                        (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[0].node), &(yylsp[0])), METHOD_NOT, &(yylsp[-2]), &(yyloc));
                    /*% ripper: unary!(ID2VAL(idNOT), $:3) %*/
                    }
#line 13858 "parse.c"
    break;

  case 289: /* relop: '>'  */
#line 4082 "parse.y"
              {(yyval.id) = '>';}
#line 13864 "parse.c"
    break;

  case 290: /* relop: '<'  */
#line 4083 "parse.y"
                       {(yyval.id) = '<';}
#line 13870 "parse.c"
    break;

  case 291: /* relop: ">="  */
#line 4084 "parse.y"
                       {(yyval.id) = idGE;}
#line 13876 "parse.c"
    break;

  case 292: /* relop: "<="  */
#line 4085 "parse.y"
                       {(yyval.id) = idLE;}
#line 13882 "parse.c"
    break;

  case 293: /* rel_expr: arg relop arg  */
#line 4089 "parse.y"
                    {
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL($2), $:3) %*/
                    }
#line 13891 "parse.c"
    break;

  case 294: /* rel_expr: rel_expr relop arg  */
#line 4094 "parse.y"
                    {
                        rb_warning1("comparison '%s' after comparison", WARN_ID((yyvsp[-1].id)));
                        (yyval.node) = call_bin_op(p, (yyvsp[-2].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL($2), $:3) %*/
                    }
#line 13901 "parse.c"
    break;

  case 295: /* lex_ctxt: none  */
#line 4102 "parse.y"
                    {
                        (yyval.ctxt) = p->ctxt;
                    }
#line 13909 "parse.c"
    break;

  case 296: /* begin_defined: lex_ctxt  */
#line 4108 "parse.y"
                    {
                        p->ctxt.in_defined = 1;
                        (yyval.ctxt) = (yyvsp[0].ctxt);
                    }
#line 13918 "parse.c"
    break;

  case 297: /* after_rescue: lex_ctxt  */
#line 4115 "parse.y"
                    {
                        p->ctxt.in_rescue = after_rescue;
                        (yyval.ctxt) = (yyvsp[0].ctxt);
                    }
#line 13927 "parse.c"
    break;

  case 298: /* value_expr_arg: arg  */
#line 3145 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 13936 "parse.c"
    break;

  case 302: /* aref_args: args ',' assocs trailer  */
#line 4127 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? arg_append(p, (yyvsp[-3].node), new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yyloc)) : (yyvsp[-3].node);
                    /*% ripper: args_add!($:1, bare_assoc_hash!($:3)) %*/
                    }
#line 13945 "parse.c"
    break;

  case 303: /* aref_args: assocs trailer  */
#line 4132 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? NEW_LIST(new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yyloc)) : 0;
                    /*% ripper: args_add!(args_new!, bare_assoc_hash!($:1)) %*/
                    }
#line 13954 "parse.c"
    break;

  case 304: /* arg_rhs: arg  */
#line 4139 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 13963 "parse.c"
    break;

  case 305: /* arg_rhs: arg "'rescue' modifier" after_rescue arg  */
#line 4144 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-1].ctxt).in_rescue;
                        value_expr(p, (yyvsp[-3].node));
                        (yyval.node) = rescued_expr(p, (yyvsp[-3].node), (yyvsp[0].node), &(yylsp[-3]), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: rescue_mod!($:1, $:4) %*/
                    }
#line 13974 "parse.c"
    break;

  case 306: /* paren_args: '(' opt_call_args rparen  */
#line 4153 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: arg_paren!($:2) %*/
                    }
#line 13983 "parse.c"
    break;

  case 307: /* paren_args: '(' args ',' args_forward rparen  */
#line 4158 "parse.y"
                    {
                        if (!check_forwarding_args(p)) {
                            (yyval.node) = 0;
                        }
                        else {
                            (yyval.node) = new_args_forward_call(p, (yyvsp[-3].node), &(yylsp[-1]), &(yyloc));
                        /*% ripper: arg_paren!(args_add!($:2, $:4)) %*/
                        }
                    }
#line 13997 "parse.c"
    break;

  case 308: /* paren_args: '(' args_forward rparen  */
#line 4168 "parse.y"
                    {
                        if (!check_forwarding_args(p)) {
                            (yyval.node) = 0;
                        }
                        else {
                            (yyval.node) = new_args_forward_call(p, 0, &(yylsp[-1]), &(yyloc));
                        /*% ripper: arg_paren!($:2) %*/
                        }
                    }
#line 14011 "parse.c"
    break;

  case 310: /* opt_paren_args: paren_args  */
#line 4181 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node) ? (yyvsp[0].node) : NODE_SPECIAL_EMPTY_ARGS;
                    }
#line 14019 "parse.c"
    break;

  case 314: /* opt_call_args: args ',' assocs ','  */
#line 4190 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? arg_append(p, (yyvsp[-3].node), new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yyloc)) : (yyvsp[-3].node);
                    /*% ripper: args_add!($:1, bare_assoc_hash!($:3)) %*/
                    }
#line 14028 "parse.c"
    break;

  case 315: /* opt_call_args: assocs ','  */
#line 4195 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? NEW_LIST(new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yylsp[-1])) : 0;
                    /*% ripper: args_add!(args_new!, bare_assoc_hash!($:1)) %*/
                    }
#line 14037 "parse.c"
    break;

  case 316: /* value_expr_command: command  */
#line 3145 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 14046 "parse.c"
    break;

  case 317: /* call_args: value_expr_command  */
#line 4202 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!(args_new!, $:1) %*/
                    }
#line 14055 "parse.c"
    break;

  case 318: /* call_args: def_endless_method_endless_command  */
#line 4207 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!(args_new!, $:1) %*/
                    }
#line 14064 "parse.c"
    break;

  case 319: /* call_args: args opt_block_arg  */
#line 4212 "parse.y"
                    {
                        (yyval.node) = arg_blk_pass((yyvsp[-1].node), (yyvsp[0].node_block_pass));
                    /*% ripper: args_add_block!($:1, $:2) %*/
                    }
#line 14073 "parse.c"
    break;

  case 320: /* call_args: assocs opt_block_arg  */
#line 4217 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? NEW_LIST(new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yylsp[-1])) : 0;
                        (yyval.node) = arg_blk_pass((yyval.node), (yyvsp[0].node_block_pass));
                    /*% ripper: args_add_block!(args_add!(args_new!, bare_assoc_hash!($:1)), $:2) %*/
                    }
#line 14083 "parse.c"
    break;

  case 321: /* call_args: args ',' assocs opt_block_arg  */
#line 4223 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node) ? arg_append(p, (yyvsp[-3].node), new_hash(p, (yyvsp[-1].node), &(yylsp[-1])), &(yyloc)) : (yyvsp[-3].node);
                        (yyval.node) = arg_blk_pass((yyval.node), (yyvsp[0].node_block_pass));
                    /*% ripper: args_add_block!(args_add!($:1, bare_assoc_hash!($:3)), $:4) %*/
                    }
#line 14093 "parse.c"
    break;

  case 323: /* $@13: %empty  */
#line 4232 "parse.y"
                 {
                        /* If call_args starts with a open paren '(' or '[',
                         * look-ahead reading of the letters calls CMDARG_PUSH(0),
                         * but the push must be done after CMDARG_PUSH(1).
                         * So this code makes them consistent by first cancelling
                         * the premature CMDARG_PUSH(0), doing CMDARG_PUSH(1),
                         * and finally redoing CMDARG_PUSH(0).
                         */
                        int lookahead = 0;
                        switch (yychar) {
                          case '(': case tLPAREN: case tLPAREN_ARG: case '[': case tLBRACK:
                            lookahead = 1;
                        }
                        if (lookahead) CMDARG_POP();
                        CMDARG_PUSH(1);
                        if (lookahead) CMDARG_PUSH(0);
                    }
#line 14115 "parse.c"
    break;

  case 324: /* command_args: $@13 call_args  */
#line 4250 "parse.y"
                    {
                        /* call_args can be followed by tLBRACE_ARG (that does CMDARG_PUSH(0) in the lexer)
                         * but the push must be done after CMDARG_POP() in the parser.
                         * So this code does CMDARG_POP() to pop 0 pushed by tLBRACE_ARG,
                         * CMDARG_POP() to pop 1 pushed by command_args,
                         * and CMDARG_PUSH(0) to restore back the flag set by tLBRACE_ARG.
                         */
                        int lookahead = 0;
                        switch (yychar) {
                          case tLBRACE_ARG:
                            lookahead = 1;
                        }
                        if (lookahead) CMDARG_POP();
                        CMDARG_POP();
                        if (lookahead) CMDARG_PUSH(0);
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: $:2 %*/
                    }
#line 14138 "parse.c"
    break;

  case 325: /* block_arg: "&" arg_value  */
#line 4271 "parse.y"
                    {
                        (yyval.node_block_pass) = NEW_BLOCK_PASS((yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: $:2 %*/
                    }
#line 14147 "parse.c"
    break;

  case 326: /* block_arg: "&"  */
#line 4276 "parse.y"
                    {
                        forwarding_arg_check(p, idFWD_BLOCK, idFWD_ALL, "block");
                        (yyval.node_block_pass) = NEW_BLOCK_PASS(NEW_LVAR(idFWD_BLOCK, &(yylsp[0])), &(yyloc), &(yylsp[0]));
                    /*% ripper: Qnil %*/
                    }
#line 14157 "parse.c"
    break;

  case 327: /* opt_block_arg: ',' block_arg  */
#line 4284 "parse.y"
                    {
                        (yyval.node_block_pass) = (yyvsp[0].node_block_pass);
                    /*% ripper: $:2 %*/
                    }
#line 14166 "parse.c"
    break;

  case 328: /* opt_block_arg: none  */
#line 4289 "parse.y"
                    {
                        (yyval.node_block_pass) = 0;
                    /*% ripper: Qfalse %*/
                    }
#line 14175 "parse.c"
    break;

  case 329: /* args: arg_value  */
#line 4297 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!(args_new!, $:arg_value) %*/
                    }
#line 14184 "parse.c"
    break;

  case 330: /* args: arg_splat  */
#line 4302 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: args_add_star!(args_new!, $:arg_splat) %*/
                    }
#line 14193 "parse.c"
    break;

  case 331: /* args: args ',' arg_value  */
#line 4307 "parse.y"
                    {
                        (yyval.node) = last_arg_append(p, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!($:non_last_args, $:arg_value) %*/
                    }
#line 14202 "parse.c"
    break;

  case 332: /* args: args ',' arg_splat  */
#line 4312 "parse.y"
                    {
                        (yyval.node) = rest_arg_append(p, (yyvsp[-2].node), RNODE_SPLAT((yyvsp[0].node))->nd_head, &(yyloc));
                    /*% ripper: args_add_star!($:non_last_args, $:arg_splat) %*/
                    }
#line 14211 "parse.c"
    break;

  case 333: /* arg_splat: "*" arg_value  */
#line 4320 "parse.y"
                    {
                        (yyval.node) = NEW_SPLAT((yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: $:arg_value %*/
                    }
#line 14220 "parse.c"
    break;

  case 334: /* arg_splat: "*"  */
#line 4325 "parse.y"
                    {
                        forwarding_arg_check(p, idFWD_REST, idFWD_ALL, "rest");
                        (yyval.node) = NEW_SPLAT(NEW_LVAR(idFWD_REST, &(yylsp[0])), &(yyloc), &(yylsp[0]));
                    /*% ripper: Qnil %*/
                    }
#line 14230 "parse.c"
    break;

  case 337: /* mrhs: args ',' arg_value  */
#line 4339 "parse.y"
                    {
                        (yyval.node) = last_arg_append(p, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: mrhs_add!(mrhs_new_from_args!($:args), $:arg_value) %*/
                    }
#line 14239 "parse.c"
    break;

  case 338: /* mrhs: args ',' "*" arg_value  */
#line 4344 "parse.y"
                    {
                        (yyval.node) = rest_arg_append(p, (yyvsp[-3].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: mrhs_add_star!(mrhs_new_from_args!($:args), $:arg_value) %*/
                    }
#line 14248 "parse.c"
    break;

  case 339: /* mrhs: "*" arg_value  */
#line 4349 "parse.y"
                    {
                        (yyval.node) = NEW_SPLAT((yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: mrhs_add_star!(mrhs_new!, $:arg_value) %*/
                    }
#line 14257 "parse.c"
    break;

  case 350: /* primary: "method"  */
#line 4370 "parse.y"
                {
                    (yyval.node) = (NODE *)NEW_FCALL((yyvsp[0].id), 0, &(yyloc));
                /*% ripper: method_add_arg!(fcall!($:1), args_new!) %*/
                }
#line 14266 "parse.c"
    break;

  case 351: /* $@14: %empty  */
#line 4375 "parse.y"
                {
                    CMDARG_PUSH(0);
                }
#line 14274 "parse.c"
    break;

  case 352: /* primary: k_begin $@14 bodystmt k_end  */
#line 4380 "parse.y"
                {
                    CMDARG_POP();
                    set_line_body((yyvsp[-1].node), (yylsp[-3]).end_pos.lineno);
                    (yyval.node) = NEW_BEGIN((yyvsp[-1].node), &(yyloc));
                    nd_set_line((yyval.node), (yylsp[-3]).end_pos.lineno);
                /*% ripper: begin!($:3) %*/
                }
#line 14286 "parse.c"
    break;

  case 353: /* $@15: %empty  */
#line 4387 "parse.y"
                                          {SET_LEX_STATE(EXPR_ENDARG);}
#line 14292 "parse.c"
    break;

  case 354: /* primary: "( arg" compstmt_stmts $@15 ')'  */
#line 4388 "parse.y"
                {
                    if (nd_type_p((yyvsp[-2].node), NODE_SELF)) RNODE_SELF((yyvsp[-2].node))->nd_state = 0;
                    (yyval.node) = (yyvsp[-2].node);
                /*% ripper: paren!($:2) %*/
                }
#line 14302 "parse.c"
    break;

  case 355: /* primary: "(" compstmt_stmts ')'  */
#line 4394 "parse.y"
                {
                    if (nd_type_p((yyvsp[-1].node), NODE_SELF)) RNODE_SELF((yyvsp[-1].node))->nd_state = 0;
                    (yyval.node) = NEW_BLOCK((yyvsp[-1].node), &(yyloc));
                /*% ripper: paren!($:2) %*/
                }
#line 14312 "parse.c"
    break;

  case 356: /* primary: primary_value "::" "constant"  */
#line 4400 "parse.y"
                {
                    (yyval.node) = NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0]));
                /*% ripper: const_path_ref!($:1, $:3) %*/
                }
#line 14321 "parse.c"
    break;

  case 357: /* primary: ":: at EXPR_BEG" "constant"  */
#line 4405 "parse.y"
                {
                    (yyval.node) = NEW_COLON3((yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0]));
                /*% ripper: top_const_ref!($:2) %*/
                }
#line 14330 "parse.c"
    break;

  case 358: /* primary: "[" aref_args ']'  */
#line 4410 "parse.y"
                {
                    (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                /*% ripper: array!($:2) %*/
                }
#line 14339 "parse.c"
    break;

  case 359: /* primary: "{" assoc_list '}'  */
#line 4415 "parse.y"
                {
                    (yyval.node) = new_hash(p, (yyvsp[-1].node), &(yyloc));
                    RNODE_HASH((yyval.node))->nd_brace = TRUE;
                /*% ripper: hash!($:2) %*/
                }
#line 14349 "parse.c"
    break;

  case 360: /* primary: k_return  */
#line 4421 "parse.y"
                {
                    (yyval.node) = NEW_RETURN(0, &(yyloc), &(yylsp[0]));
                /*% ripper: return0! %*/
                }
#line 14358 "parse.c"
    break;

  case 361: /* primary: k_yield '(' call_args rparen  */
#line 4426 "parse.y"
                {
                    (yyval.node) = NEW_YIELD((yyvsp[-1].node), &(yyloc), &(yylsp[-3]), &(yylsp[-2]), &(yylsp[0]));
                /*% ripper: yield!(paren!($:3)) %*/
                }
#line 14367 "parse.c"
    break;

  case 362: /* primary: k_yield '(' rparen  */
#line 4431 "parse.y"
                {
                    (yyval.node) = NEW_YIELD(0, &(yyloc), &(yylsp[-2]), &(yylsp[-1]), &(yylsp[0]));
                /*% ripper: yield!(paren!(args_new!)) %*/
                }
#line 14376 "parse.c"
    break;

  case 363: /* primary: k_yield  */
#line 4436 "parse.y"
                {
                    (yyval.node) = NEW_YIELD(0, &(yyloc), &(yylsp[0]), &NULL_LOC, &NULL_LOC);
                /*% ripper: yield0! %*/
                }
#line 14385 "parse.c"
    break;

  case 364: /* primary: "'defined?'" option_'\n' '(' begin_defined expr rparen  */
#line 4441 "parse.y"
                {
                    p->ctxt.in_defined = (yyvsp[-2].ctxt).in_defined;
                    (yyval.node) = new_defined(p, (yyvsp[-1].node), &(yyloc), &(yylsp[-5]));
                    p->ctxt.has_trailing_semicolon = (yyvsp[-2].ctxt).has_trailing_semicolon;
                /*% ripper: defined!($:5) %*/
                }
#line 14396 "parse.c"
    break;

  case 365: /* primary: "'not'" '(' expr rparen  */
#line 4448 "parse.y"
                {
                    (yyval.node) = call_uni_op(p, method_cond(p, (yyvsp[-1].node), &(yylsp[-1])), METHOD_NOT, &(yylsp[-3]), &(yyloc));
                /*% ripper: unary!(ID2VAL(idNOT), $:3) %*/
                }
#line 14405 "parse.c"
    break;

  case 366: /* primary: "'not'" '(' rparen  */
#line 4453 "parse.y"
                {
                    (yyval.node) = call_uni_op(p, method_cond(p, NEW_NIL(&(yylsp[-1])), &(yylsp[-1])), METHOD_NOT, &(yylsp[-2]), &(yyloc));
                /*% ripper: unary!(ID2VAL(idNOT), Qnil) %*/
                }
#line 14414 "parse.c"
    break;

  case 367: /* primary: fcall brace_block  */
#line 4458 "parse.y"
                {
                    (yyval.node) = method_add_block(p, (NODE *)(yyvsp[-1].node_fcall), (yyvsp[0].node), &(yyloc));
                /*% ripper: method_add_block!(method_add_arg!(fcall!($:1), args_new!), $:2) %*/
                }
#line 14423 "parse.c"
    break;

  case 369: /* primary: method_call brace_block  */
#line 4464 "parse.y"
                {
                    block_dup_check(p, get_nd_args(p, (yyvsp[-1].node)), (yyvsp[0].node));
                    (yyval.node) = method_add_block(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                /*% ripper: method_add_block!($:1, $:2) %*/
                }
#line 14433 "parse.c"
    break;

  case 371: /* primary: k_if expr_value then compstmt_stmts if_tail k_end  */
#line 4474 "parse.y"
                {
                    if ((yyvsp[-1].node) && nd_type_p((yyvsp[-1].node), NODE_IF))
                        RNODE_IF((yyvsp[-1].node))->end_keyword_loc = (yylsp[0]);

                    (yyval.node) = new_if(p, (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), &(yyloc), &(yylsp[-5]), &(yylsp[-3]), &(yylsp[0]));
                    fixpos((yyval.node), (yyvsp[-4].node));
                /*% ripper: if!($:2, $:4, $:5) %*/
                }
#line 14446 "parse.c"
    break;

  case 372: /* primary: k_unless expr_value then compstmt_stmts opt_else k_end  */
#line 4486 "parse.y"
                {
                    (yyval.node) = new_unless(p, (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[-1].node), &(yyloc), &(yylsp[-5]), &(yylsp[-3]), &(yylsp[0]));
                    fixpos((yyval.node), (yyvsp[-4].node));
                /*% ripper: unless!($:2, $:4, $:5) %*/
                }
#line 14456 "parse.c"
    break;

  case 373: /* primary: k_while expr_value_do compstmt_stmts k_end  */
#line 4494 "parse.y"
                {
                    restore_block_exit(p, (yyvsp[-3].node_exits));
                    (yyval.node) = NEW_WHILE(cond(p, (yyvsp[-2].node), &(yylsp[-2])), (yyvsp[-1].node), 1, &(yyloc), &(yylsp[-3]), &(yylsp[0]));
                    fixpos((yyval.node), (yyvsp[-2].node));
                /*% ripper: while!($:2, $:3) %*/
                }
#line 14467 "parse.c"
    break;

  case 374: /* primary: k_until expr_value_do compstmt_stmts k_end  */
#line 4503 "parse.y"
                {
                    restore_block_exit(p, (yyvsp[-3].node_exits));
                    (yyval.node) = NEW_UNTIL(cond(p, (yyvsp[-2].node), &(yylsp[-2])), (yyvsp[-1].node), 1, &(yyloc), &(yylsp[-3]), &(yylsp[0]));
                    fixpos((yyval.node), (yyvsp[-2].node));
                /*% ripper: until!($:2, $:3) %*/
                }
#line 14478 "parse.c"
    break;

  case 375: /* @16: %empty  */
#line 4510 "parse.y"
                {
                    (yyval.labels) = p->case_labels;
                    p->case_labels = CHECK_LITERAL_WHEN;
                }
#line 14487 "parse.c"
    break;

  case 376: /* primary: k_case expr_value option_terms @16 case_body k_end  */
#line 4516 "parse.y"
                {
                    if (CASE_LABELS_ENABLED_P(p->case_labels)) st_free_table(p->case_labels);
                    p->case_labels = (yyvsp[-2].labels);
                    (yyval.node) = NEW_CASE((yyvsp[-4].node), (yyvsp[-1].node), &(yyloc), &(yylsp[-5]), &(yylsp[0]));
                    fixpos((yyval.node), (yyvsp[-4].node));
                /*% ripper: case!($:2, $:5) %*/
                }
#line 14499 "parse.c"
    break;

  case 377: /* @17: %empty  */
#line 4524 "parse.y"
                {
                    (yyval.labels) = p->case_labels;
                    p->case_labels = 0;
                }
#line 14508 "parse.c"
    break;

  case 378: /* primary: k_case option_terms @17 case_body k_end  */
#line 4530 "parse.y"
                {
                    if (p->case_labels) st_free_table(p->case_labels);
                    p->case_labels = (yyvsp[-2].labels);
                    (yyval.node) = NEW_CASE2((yyvsp[-1].node), &(yyloc), &(yylsp[-4]), &(yylsp[0]));
                /*% ripper: case!(Qnil, $:4) %*/
                }
#line 14519 "parse.c"
    break;

  case 379: /* primary: k_case expr_value option_terms p_case_body k_end  */
#line 4539 "parse.y"
                {
                    (yyval.node) = NEW_CASE3((yyvsp[-3].node), (yyvsp[-1].node), &(yyloc), &(yylsp[-4]), &(yylsp[0]));
                /*% ripper: case!($:2, $:4) %*/
                }
#line 14528 "parse.c"
    break;

  case 380: /* $@18: %empty  */
#line 4544 "parse.y"
              {COND_PUSH(1);}
#line 14534 "parse.c"
    break;

  case 381: /* $@19: %empty  */
#line 4544 "parse.y"
                                            {COND_POP();}
#line 14540 "parse.c"
    break;

  case 382: /* primary: k_for for_var "'in'" $@18 expr_value do $@19 compstmt_stmts k_end  */
#line 4547 "parse.y"
                {
                    restore_block_exit(p, (yyvsp[-8].node_exits));
                    /*
                     *  for a, b, c in e
                     *  #=>
                     *  e.each{|*x| a, b, c = x}
                     *
                     *  for a in e
                     *  #=>
                     *  e.each{|x| a, = x}
                     */
                    ID id = internal_id(p);
                    rb_node_args_aux_t *m = NEW_ARGS_AUX(0, 0, &NULL_LOC);
                    rb_node_args_t *args;
                    NODE *scope, *internal_var = NEW_DVAR(id, &(yylsp[-7]));
                    rb_ast_id_table_t *tbl = rb_ast_new_local_table(p->ast, 1);
                    tbl->ids[0] = id; /* internal id */

                    switch (nd_type((yyvsp[-7].node))) {
                      case NODE_LASGN:
                      case NODE_DASGN: /* e.each {|internal_var| a = internal_var; ... } */
                        set_nd_value(p, (yyvsp[-7].node), internal_var);
                        id = 0;
                        m->nd_plen = 1;
                        m->nd_next = (yyvsp[-7].node);
                        break;
                      case NODE_MASGN: /* e.each {|*internal_var| a, b, c = (internal_var.length == 1 && Array === (tmp = internal_var[0]) ? tmp : internal_var); ... } */
                        m->nd_next = node_assign(p, (yyvsp[-7].node), NEW_FOR_MASGN(internal_var, &(yylsp[-7])), NO_LEX_CTXT, &(yylsp[-7]));
                        break;
                      default: /* e.each {|*internal_var| @a, B, c[1], d.attr = internal_val; ... } */
                        m->nd_next = node_assign(p, (NODE *)NEW_MASGN(NEW_LIST((yyvsp[-7].node), &(yylsp[-7])), 0, &(yylsp[-7])), internal_var, NO_LEX_CTXT, &(yylsp[-7]));
                    }
                    /* {|*internal_id| <m> = internal_id; ... } */
                    args = new_args(p, m, 0, id, 0, new_args_tail(p, 0, 0, 0, &(yylsp[-7])), &(yylsp[-7]));
                    scope = NEW_SCOPE2(tbl, args, (yyvsp[-1].node), NULL, &(yyloc));
                    YYLTYPE do_keyword_loc = (yyvsp[-3].id) == keyword_do_cond ? (yylsp[-3]) : NULL_LOC;
                    (yyval.node) = NEW_FOR((yyvsp[-4].node), scope, &(yyloc), &(yylsp[-8]), &(yylsp[-6]), &do_keyword_loc, &(yylsp[0]));
                    RNODE_SCOPE(scope)->nd_parent = (yyval.node);
                    fixpos((yyval.node), (yyvsp[-7].node));
                /*% ripper: for!($:for_var, $:expr_value, $:compstmt) %*/
                }
#line 14586 "parse.c"
    break;

  case 383: /* $@20: %empty  */
#line 4589 "parse.y"
                {
                    begin_definition("class", &(yylsp[-2]), &(yylsp[-1]));
                }
#line 14594 "parse.c"
    break;

  case 384: /* primary: k_class cpath superclass $@20 bodystmt k_end  */
#line 4594 "parse.y"
                {
                    YYLTYPE inheritance_operator_loc = NULL_LOC;
                    if ((yyvsp[-3].node)) {
                        inheritance_operator_loc = (yylsp[-3]);
                        inheritance_operator_loc.end_pos.column = inheritance_operator_loc.beg_pos.column + 1;
                    }
                    (yyval.node) = NEW_CLASS((yyvsp[-4].node), (yyvsp[-1].node), (yyvsp[-3].node), &(yyloc), &(yylsp[-5]), &inheritance_operator_loc, &(yylsp[0]));
                    nd_set_line(RNODE_CLASS((yyval.node))->nd_body, (yylsp[0]).end_pos.lineno);
                    set_line_body((yyvsp[-1].node), (yylsp[-3]).end_pos.lineno);
                    nd_set_line((yyval.node), (yylsp[-3]).end_pos.lineno);
                /*% ripper: class!($:cpath, $:superclass, $:bodystmt) %*/
                    local_pop(p);
                    p->ctxt.in_class = (yyvsp[-5].ctxt).in_class;
                    p->ctxt.cant_return = (yyvsp[-5].ctxt).cant_return;
                    p->ctxt.shareable_constant_value = (yyvsp[-5].ctxt).shareable_constant_value;
                }
#line 14615 "parse.c"
    break;

  case 385: /* $@21: %empty  */
#line 4611 "parse.y"
                {
                    begin_definition("", &(yylsp[-2]), &(yylsp[-1]));
                }
#line 14623 "parse.c"
    break;

  case 386: /* primary: k_class "<<" expr_value $@21 term bodystmt k_end  */
#line 4617 "parse.y"
                {
                    (yyval.node) = NEW_SCLASS((yyvsp[-4].node), (yyvsp[-1].node), &(yyloc), &(yylsp[-6]), &(yylsp[-5]), &(yylsp[0]));
                    nd_set_line(RNODE_SCLASS((yyval.node))->nd_body, (yylsp[0]).end_pos.lineno);
                    set_line_body((yyvsp[-1].node), nd_line((yyvsp[-4].node)));
                    fixpos((yyval.node), (yyvsp[-4].node));
                /*% ripper: sclass!($:expr_value, $:bodystmt) %*/
                    local_pop(p);
                    p->ctxt.in_def = (yyvsp[-6].ctxt).in_def;
                    p->ctxt.in_class = (yyvsp[-6].ctxt).in_class;
                    p->ctxt.cant_return = (yyvsp[-6].ctxt).cant_return;
                    p->ctxt.shareable_constant_value = (yyvsp[-6].ctxt).shareable_constant_value;
                }
#line 14640 "parse.c"
    break;

  case 387: /* $@22: %empty  */
#line 4630 "parse.y"
                {
                    begin_definition("module", &(yylsp[-1]), &(yylsp[0]));
                }
#line 14648 "parse.c"
    break;

  case 388: /* primary: k_module cpath $@22 bodystmt k_end  */
#line 4635 "parse.y"
                {
                    (yyval.node) = NEW_MODULE((yyvsp[-3].node), (yyvsp[-1].node), &(yyloc), &(yylsp[-4]), &(yylsp[0]));
                    nd_set_line(RNODE_MODULE((yyval.node))->nd_body, (yylsp[0]).end_pos.lineno);
                    set_line_body((yyvsp[-1].node), (yylsp[-3]).end_pos.lineno);
                    nd_set_line((yyval.node), (yylsp[-3]).end_pos.lineno);
                /*% ripper: module!($:cpath, $:bodystmt) %*/
                    local_pop(p);
                    p->ctxt.in_class = (yyvsp[-4].ctxt).in_class;
                    p->ctxt.cant_return = (yyvsp[-4].ctxt).cant_return;
                    p->ctxt.shareable_constant_value = (yyvsp[-4].ctxt).shareable_constant_value;
                }
#line 14664 "parse.c"
    break;

  case 389: /* $@23: %empty  */
#line 4648 "parse.y"
                {
                    push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                }
#line 14672 "parse.c"
    break;

  case 390: /* primary: defn_head f_arglist $@23 bodystmt k_end  */
#line 4653 "parse.y"
                {
                    restore_defun(p, (yyvsp[-4].node_def_temp));
                    ((yyval.node) = (yyvsp[-4].node_def_temp)->nd_def)->nd_loc = (yyloc);
                    (yyvsp[-1].node) = new_scope_body(p, (yyvsp[-3].node_args), (yyvsp[-1].node), (yyval.node), &(yyloc));
                    RNODE_DEFN((yyval.node))->nd_defn = (yyvsp[-1].node);
                /*% ripper: def!($:head, $:args, $:bodystmt) %*/
                    local_pop(p);
                }
#line 14685 "parse.c"
    break;

  case 391: /* $@24: %empty  */
#line 4663 "parse.y"
                {
                    push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                }
#line 14693 "parse.c"
    break;

  case 392: /* primary: defs_head f_arglist $@24 bodystmt k_end  */
#line 4668 "parse.y"
                {
                    restore_defun(p, (yyvsp[-4].node_def_temp));
                    ((yyval.node) = (yyvsp[-4].node_def_temp)->nd_def)->nd_loc = (yyloc);
                    (yyvsp[-1].node) = new_scope_body(p, (yyvsp[-3].node_args), (yyvsp[-1].node), (yyval.node), &(yyloc));
                    RNODE_DEFS((yyval.node))->nd_defn = (yyvsp[-1].node);
                /*% ripper: defs!(*$:head[0..2], $:args, $:bodystmt) %*/
                    local_pop(p);
                }
#line 14706 "parse.c"
    break;

  case 393: /* primary: "'break'"  */
#line 4677 "parse.y"
                {
                    (yyval.node) = add_block_exit(p, NEW_BREAK(0, &(yyloc), &(yylsp[0])));
                /*% ripper: break!(args_new!) %*/
                }
#line 14715 "parse.c"
    break;

  case 394: /* primary: "'next'"  */
#line 4682 "parse.y"
                {
                    (yyval.node) = add_block_exit(p, NEW_NEXT(0, &(yyloc), &(yylsp[0])));
                /*% ripper: next!(args_new!) %*/
                }
#line 14724 "parse.c"
    break;

  case 395: /* primary: "'redo'"  */
#line 4687 "parse.y"
                {
                    (yyval.node) = add_block_exit(p, NEW_REDO(&(yyloc), &(yylsp[0])));
                /*% ripper: redo! %*/
                }
#line 14733 "parse.c"
    break;

  case 396: /* primary: "'retry'"  */
#line 4692 "parse.y"
                {
                    if (!p->ctxt.in_defined) {
                        switch (p->ctxt.in_rescue) {
                          case before_rescue: yyerror1(&(yylsp[0]), "Invalid retry without rescue"); break;
                          case after_rescue: /* ok */ break;
                          case after_else: yyerror1(&(yylsp[0]), "Invalid retry after else"); break;
                          case after_ensure: yyerror1(&(yylsp[0]), "Invalid retry after ensure"); break;
                        }
                    }
                    (yyval.node) = NEW_RETRY(&(yyloc));
                /*% ripper: retry! %*/
                }
#line 14750 "parse.c"
    break;

  case 397: /* value_expr_primary: primary  */
#line 3145 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 14759 "parse.c"
    break;

  case 399: /* k_begin: "'begin'"  */
#line 4710 "parse.y"
                    {
                        token_info_push(p, "begin", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14768 "parse.c"
    break;

  case 400: /* k_if: "'if'"  */
#line 4717 "parse.y"
                    {
                        WARN_EOL("if");
                        token_info_push(p, "if", &(yyloc));
                        if (p->token_info && p->token_info->nonspc &&
                            p->token_info->next && !strcmp(p->token_info->next->token, "else")) {
                            const char *tok = p->lex.ptok - rb_strlen_lit("if");
                            const char *beg = p->lex.pbeg + p->token_info->next->beg.column;
                            beg += rb_strlen_lit("else");
                            while (beg < tok && ISSPACE(*beg)) beg++;
                            if (beg == tok) {
                                p->token_info->nonspc = 0;
                            }
                        }
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14788 "parse.c"
    break;

  case 401: /* k_unless: "'unless'"  */
#line 4735 "parse.y"
                    {
                        token_info_push(p, "unless", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14797 "parse.c"
    break;

  case 402: /* k_while: "'while'" allow_exits  */
#line 4742 "parse.y"
                    {
                        (yyval.node_exits) = (yyvsp[0].node_exits);
                        token_info_push(p, "while", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                    }
#line 14807 "parse.c"
    break;

  case 403: /* k_until: "'until'" allow_exits  */
#line 4750 "parse.y"
                    {
                        (yyval.node_exits) = (yyvsp[0].node_exits);
                        token_info_push(p, "until", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                    }
#line 14817 "parse.c"
    break;

  case 404: /* k_case: "'case'"  */
#line 4758 "parse.y"
                    {
                        token_info_push(p, "case", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14826 "parse.c"
    break;

  case 405: /* k_for: "'for'" allow_exits  */
#line 4765 "parse.y"
                    {
                        (yyval.node_exits) = (yyvsp[0].node_exits);
                        token_info_push(p, "for", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[-1]).beg_pos);
                    }
#line 14836 "parse.c"
    break;

  case 406: /* k_class: "'class'"  */
#line 4773 "parse.y"
                    {
                        token_info_push(p, "class", &(yyloc));
                        (yyval.ctxt) = p->ctxt;
                        p->ctxt.in_rescue = before_rescue;
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14847 "parse.c"
    break;

  case 407: /* k_module: "'module'"  */
#line 4782 "parse.y"
                    {
                        token_info_push(p, "module", &(yyloc));
                        (yyval.ctxt) = p->ctxt;
                        p->ctxt.in_rescue = before_rescue;
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14858 "parse.c"
    break;

  case 408: /* k_def: "'def'"  */
#line 4791 "parse.y"
                    {
                        token_info_push(p, "def", &(yyloc));
                        (yyval.node_def_temp) = NEW_DEF_TEMP(&(yyloc));
                        p->ctxt.in_argdef = 1;
                    }
#line 14868 "parse.c"
    break;

  case 409: /* k_do: "'do'"  */
#line 4799 "parse.y"
                    {
                        token_info_push(p, "do", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14877 "parse.c"
    break;

  case 410: /* k_do_block: "'do' for block"  */
#line 4806 "parse.y"
                    {
                        token_info_push(p, "do", &(yyloc));
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 14886 "parse.c"
    break;

  case 411: /* k_rescue: "'rescue'"  */
#line 4813 "parse.y"
                    {
                        token_info_warn(p, "rescue", p->token_info, 1, &(yyloc));
                        (yyval.ctxt) = p->ctxt;
                        p->ctxt.in_rescue = after_rescue;
                    }
#line 14896 "parse.c"
    break;

  case 412: /* k_ensure: "'ensure'"  */
#line 4821 "parse.y"
                    {
                        token_info_warn(p, "ensure", p->token_info, 1, &(yyloc));
                        (yyval.ctxt) = p->ctxt;
                    }
#line 14905 "parse.c"
    break;

  case 413: /* k_when: "'when'"  */
#line 4828 "parse.y"
                    {
                        token_info_warn(p, "when", p->token_info, 0, &(yyloc));
                    }
#line 14913 "parse.c"
    break;

  case 414: /* k_else: "'else'"  */
#line 4834 "parse.y"
                    {
                        token_info *ptinfo_beg = p->token_info;
                        int same = ptinfo_beg && strcmp(ptinfo_beg->token, "case") != 0;
                        token_info_warn(p, "else", p->token_info, same, &(yyloc));
                        if (same) {
                            token_info e;
                            e.next = ptinfo_beg->next;
                            e.token = "else";
                            token_info_setup(&e, p->lex.pbeg, &(yyloc));
                            if (!e.nonspc) *ptinfo_beg = e;
                        }
                    }
#line 14930 "parse.c"
    break;

  case 415: /* k_elsif: "'elsif'"  */
#line 4849 "parse.y"
                    {
                        WARN_EOL("elsif");
                        token_info_warn(p, "elsif", p->token_info, 1, &(yyloc));
                    }
#line 14939 "parse.c"
    break;

  case 416: /* k_end: "'end'"  */
#line 4856 "parse.y"
                    {
                        token_info_pop(p, "end", &(yyloc));
                        pop_end_expect_token_locations(p);
                    }
#line 14948 "parse.c"
    break;

  case 417: /* k_end: "dummy end"  */
#line 4861 "parse.y"
                    {
                        compile_error(p, "syntax error, unexpected end-of-input");
                    }
#line 14956 "parse.c"
    break;

  case 418: /* k_return: "'return'"  */
#line 4867 "parse.y"
                    {
                        if (p->ctxt.cant_return && !dyna_in_block(p))
                            yyerror1(&(yylsp[0]), "Invalid return in class/module body");
                    }
#line 14965 "parse.c"
    break;

  case 419: /* k_yield: "'yield'"  */
#line 4874 "parse.y"
                    {
                        if (!p->ctxt.in_defined && !p->ctxt.in_def && !compile_for_eval)
                            yyerror1(&(yylsp[0]), "Invalid yield");
                    }
#line 14974 "parse.c"
    break;

  case 424: /* do: "'do' for condition"  */
#line 4886 "parse.y"
                                  { (yyval.id) = keyword_do_cond; }
#line 14980 "parse.c"
    break;

  case 426: /* if_tail: k_elsif expr_value then compstmt_stmts if_tail  */
#line 4893 "parse.y"
                    {
                        (yyval.node) = new_if(p, (yyvsp[-3].node), (yyvsp[-1].node), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-2]), &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[-3].node));
                    /*% ripper: elsif!($:2, $:4, $:5) %*/
                    }
#line 14990 "parse.c"
    break;

  case 428: /* opt_else: k_else compstmt_stmts  */
#line 4902 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: else!($:2) %*/
                    }
#line 14999 "parse.c"
    break;

  case 431: /* f_marg: f_norm_arg  */
#line 4913 "parse.y"
                    {
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                        mark_lvar_used(p, (yyval.node));
                    }
#line 15008 "parse.c"
    break;

  case 432: /* f_marg: "(" f_margs rparen  */
#line 4918 "parse.y"
                    {
                        (yyval.node) = (NODE *)(yyvsp[-1].node_masgn);
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 15017 "parse.c"
    break;

  case 433: /* mlhs_items_f_marg: f_marg  */
#line 3032 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add!(mlhs_new!, $:1) %*/
                    }
#line 15026 "parse.c"
    break;

  case 434: /* mlhs_items_f_marg: mlhs_items_f_marg ',' f_marg  */
#line 3037 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), (yyvsp[0].node));
                    /*% ripper: mlhs_add!($:1, $:3) %*/
                    }
#line 15035 "parse.c"
    break;

  case 435: /* f_margs: mlhs_items_f_marg  */
#line 4926 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[0].node), 0, &(yyloc));
                    /*% ripper: $:1 %*/
                    }
#line 15044 "parse.c"
    break;

  case 436: /* f_margs: mlhs_items_f_marg ',' f_rest_marg  */
#line 4931 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add_star!($:1, $:3) %*/
                    }
#line 15053 "parse.c"
    break;

  case 437: /* f_margs: mlhs_items_f_marg ',' f_rest_marg ',' mlhs_items_f_marg  */
#line 4936 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN((yyvsp[-4].node), NEW_POSTARG((yyvsp[-2].node), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!($:1, $:3), $:5) %*/
                    }
#line 15062 "parse.c"
    break;

  case 438: /* f_margs: f_rest_marg  */
#line 4941 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: mlhs_add_star!(mlhs_new!, $:1) %*/
                    }
#line 15071 "parse.c"
    break;

  case 439: /* f_margs: f_rest_marg ',' mlhs_items_f_marg  */
#line 4946 "parse.y"
                    {
                        (yyval.node_masgn) = NEW_MASGN(0, NEW_POSTARG((yyvsp[-2].node), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: mlhs_add_post!(mlhs_add_star!(mlhs_new!, $:1), $:3) %*/
                    }
#line 15080 "parse.c"
    break;

  case 440: /* f_rest_marg: "*" f_norm_arg  */
#line 4953 "parse.y"
                    {
                    /*% ripper: $:2 %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                        mark_lvar_used(p, (yyval.node));
                    }
#line 15090 "parse.c"
    break;

  case 441: /* f_rest_marg: "*"  */
#line 4959 "parse.y"
                    {
                        (yyval.node) = NODE_SPECIAL_NO_NAME_REST;
                    /*% ripper: Qnil %*/
                    }
#line 15099 "parse.c"
    break;

  case 443: /* f_any_kwrest: f_no_kwarg  */
#line 4967 "parse.y"
                    {
                        (yyval.id) = idNil;
                    /*% ripper: ID2VAL(idNil) %*/
                    }
#line 15108 "parse.c"
    break;

  case 444: /* $@25: %empty  */
#line 4973 "parse.y"
        {p->ctxt.in_argdef = 0;}
#line 15114 "parse.c"
    break;

  case 446: /* f_kw_primary_value: f_label primary_value  */
#line 3004 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_kw_arg) = new_kw_arg(p, assignable(p, (yyvsp[-1].id), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, $:value] %*/
                    }
#line 15124 "parse.c"
    break;

  case 447: /* f_kw_primary_value: f_label  */
#line 3010 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_kw_arg) = new_kw_arg(p, assignable(p, (yyvsp[0].id), NODE_SPECIAL_REQUIRED_KEYWORD, &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, 0] %*/
                    }
#line 15134 "parse.c"
    break;

  case 448: /* f_kwarg_primary_value: f_kw_primary_value  */
#line 3019 "parse.y"
                    {
                        (yyval.node_kw_arg) = (yyvsp[0].node_kw_arg);
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 15143 "parse.c"
    break;

  case 449: /* f_kwarg_primary_value: f_kwarg_primary_value ',' f_kw_primary_value  */
#line 3024 "parse.y"
                    {
                        (yyval.node_kw_arg) = kwd_append((yyvsp[-2].node_kw_arg), (yyvsp[0].node_kw_arg));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 15152 "parse.c"
    break;

  case 450: /* args_tail_basic_primary_value: f_kwarg_primary_value ',' f_kwrest opt_f_block_arg  */
#line 2927 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, (yyvsp[-3].node_kw_arg), (yyvsp[-1].id), (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [$:1, $:3, $:4] %*/
                    }
#line 15161 "parse.c"
    break;

  case 451: /* args_tail_basic_primary_value: f_kwarg_primary_value opt_f_block_arg  */
#line 2932 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, (yyvsp[-1].node_kw_arg), 0, (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [$:1, Qnil, $:2] %*/
                    }
#line 15170 "parse.c"
    break;

  case 452: /* args_tail_basic_primary_value: f_any_kwrest opt_f_block_arg  */
#line 2937 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, (yyvsp[-1].id), (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [Qnil, $:1, $:2] %*/
                    }
#line 15179 "parse.c"
    break;

  case 453: /* args_tail_basic_primary_value: f_block_arg  */
#line 2942 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, (yyvsp[0].id), &(yylsp[0]));
                    /*% ripper: [Qnil, Qnil, $:1] %*/
                    }
#line 15188 "parse.c"
    break;

  case 455: /* excessed_comma: ','  */
#line 4979 "parse.y"
                    {
                        /* magic number for rest_id in iseq_set_arguments() */
                        (yyval.id) = NODE_SPECIAL_EXCESSIVE_COMMA;
                    /*% ripper: excessed_comma! %*/
                    }
#line 15198 "parse.c"
    break;

  case 456: /* f_opt_primary_value: f_arg_asgn f_eq primary_value  */
#line 2982 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_opt_arg) = NEW_OPT_ARG(assignable(p, (yyvsp[-2].id), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, $:3] %*/
                    }
#line 15208 "parse.c"
    break;

  case 457: /* f_opt_arg_primary_value: f_opt_primary_value  */
#line 2991 "parse.y"
                    {
                        (yyval.node_opt_arg) = (yyvsp[0].node_opt_arg);
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 15217 "parse.c"
    break;

  case 458: /* f_opt_arg_primary_value: f_opt_arg_primary_value ',' f_opt_primary_value  */
#line 2996 "parse.y"
                    {
                        (yyval.node_opt_arg) = opt_arg_append((yyvsp[-2].node_opt_arg), (yyvsp[0].node_opt_arg));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 15226 "parse.c"
    break;

  case 459: /* opt_args_tail_block_args_tail: ',' block_args_tail  */
#line 3091 "parse.y"
                    {
                        (yyval.node_args) = (yyvsp[0].node_args);
                    /*% ripper: $:2 %*/
                    }
#line 15235 "parse.c"
    break;

  case 460: /* opt_args_tail_block_args_tail: %empty  */
#line 3096 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[0]));
                    /*% ripper: [Qnil, Qnil, Qnil] %*/
                    }
#line 15244 "parse.c"
    break;

  case 461: /* block_param: f_arg ',' f_opt_arg_primary_value ',' f_rest_arg opt_args_tail_block_args_tail  */
#line 4987 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), (yyvsp[-3].node_opt_arg), (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, $:5, Qnil, *$:6[0..2]) %*/
                    }
#line 15253 "parse.c"
    break;

  case 462: /* block_param: f_arg ',' f_opt_arg_primary_value ',' f_rest_arg ',' f_arg opt_args_tail_block_args_tail  */
#line 4992 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-7].node_args_aux), (yyvsp[-5].node_opt_arg), (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, $:5, $:7, *$:8[0..2]) %*/
                    }
#line 15262 "parse.c"
    break;

  case 463: /* block_param: f_arg ',' f_opt_arg_primary_value opt_args_tail_block_args_tail  */
#line 4997 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-3].node_args_aux), (yyvsp[-1].node_opt_arg), 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, Qnil, Qnil, *$:4[0..2]) %*/
                    }
#line 15271 "parse.c"
    break;

  case 464: /* block_param: f_arg ',' f_opt_arg_primary_value ',' f_arg opt_args_tail_block_args_tail  */
#line 5002 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), (yyvsp[-3].node_opt_arg), 0, (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, Qnil, $:5, *$:6[0..2]) %*/
                    }
#line 15280 "parse.c"
    break;

  case 465: /* block_param: f_arg ',' f_rest_arg opt_args_tail_block_args_tail  */
#line 5007 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-3].node_args_aux), 0, (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:3, Qnil, *$:4[0..2]) %*/
                    }
#line 15289 "parse.c"
    break;

  case 466: /* block_param: f_arg excessed_comma  */
#line 5012 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[0]));
                        (yyval.node_args) = new_args(p, (yyvsp[-1].node_args_aux), 0, (yyvsp[0].id), 0, (yyval.node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:2, Qnil, Qnil, Qnil, Qnil) %*/
                    }
#line 15299 "parse.c"
    break;

  case 467: /* block_param: f_arg ',' f_rest_arg ',' f_arg opt_args_tail_block_args_tail  */
#line 5018 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), 0, (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:3, $:5, *$:6[0..2]) %*/
                    }
#line 15308 "parse.c"
    break;

  case 468: /* block_param: f_arg opt_args_tail_block_args_tail  */
#line 5023 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-1].node_args_aux), 0, 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, Qnil, Qnil, *$:2[0..2]) %*/
                    }
#line 15317 "parse.c"
    break;

  case 469: /* block_param: f_opt_arg_primary_value ',' f_rest_arg opt_args_tail_block_args_tail  */
#line 5028 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-3].node_opt_arg), (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, $:3, Qnil, *$:4[0..2]) %*/
                    }
#line 15326 "parse.c"
    break;

  case 470: /* block_param: f_opt_arg_primary_value ',' f_rest_arg ',' f_arg opt_args_tail_block_args_tail  */
#line 5033 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-5].node_opt_arg), (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, $:3, $:5, *$:6[0..2]) %*/
                    }
#line 15335 "parse.c"
    break;

  case 471: /* block_param: f_opt_arg_primary_value opt_args_tail_block_args_tail  */
#line 5038 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-1].node_opt_arg), 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, Qnil, Qnil, *$:2[0..2]) %*/
                    }
#line 15344 "parse.c"
    break;

  case 472: /* block_param: f_opt_arg_primary_value ',' f_arg opt_args_tail_block_args_tail  */
#line 5043 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-3].node_opt_arg), 0, (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, Qnil, $:3, *$:4[0..2]) %*/
                    }
#line 15353 "parse.c"
    break;

  case 473: /* block_param: f_rest_arg opt_args_tail_block_args_tail  */
#line 5048 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, $:1, Qnil, *$:2[0..2]) %*/
                    }
#line 15362 "parse.c"
    break;

  case 474: /* block_param: f_rest_arg ',' f_arg opt_args_tail_block_args_tail  */
#line 5053 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, $:1, $:3, *$:4[0..2]) %*/
                    }
#line 15371 "parse.c"
    break;

  case 475: /* block_param: block_args_tail  */
#line 5058 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, Qnil, Qnil, *$:1[0..2]) %*/
                    }
#line 15380 "parse.c"
    break;

  case 477: /* opt_block_param_def: block_param_def  */
#line 5066 "parse.y"
                        {
                            p->command_start = TRUE;
                        }
#line 15388 "parse.c"
    break;

  case 478: /* block_param_def: '|' opt_block_param opt_bv_decl '|'  */
#line 5072 "parse.y"
                    {
                        p->max_numparam = ORDINAL_PARAM;
                        p->ctxt.in_argdef = 0;
                        (yyval.node_args) = (yyvsp[-2].node_args);
                    /*% ripper: block_var!($:2, $:3) %*/
                    }
#line 15399 "parse.c"
    break;

  case 479: /* opt_block_param: %empty  */
#line 5081 "parse.y"
                    {
                        (yyval.node_args) = 0;
                    /*% ripper: params!(Qnil,Qnil,Qnil,Qnil,Qnil,Qnil,Qnil) %*/
                    }
#line 15408 "parse.c"
    break;

  case 481: /* opt_bv_decl: option_'\n'  */
#line 5089 "parse.y"
                    {
                        (yyval.id) = 0;
                    /*% ripper: Qfalse %*/
                    }
#line 15417 "parse.c"
    break;

  case 482: /* opt_bv_decl: option_'\n' ';' bv_decls option_'\n'  */
#line 5094 "parse.y"
                    {
                        (yyval.id) = 0;
                    /*% ripper: $:3 %*/
                    }
#line 15426 "parse.c"
    break;

  case 485: /* bvar: "local variable or method"  */
#line 5107 "parse.y"
                    {
                        new_bv(p, (yyvsp[0].id));
                    /*% ripper: $:1 %*/
                    }
#line 15435 "parse.c"
    break;

  case 487: /* max_numparam: %empty  */
#line 5114 "parse.y"
                 {
                        (yyval.num) = p->max_numparam;
                        p->max_numparam = 0;
                    }
#line 15444 "parse.c"
    break;

  case 488: /* numparam: %empty  */
#line 5120 "parse.y"
             {
                        (yyval.node) = numparam_push(p);
                    }
#line 15452 "parse.c"
    break;

  case 489: /* it_id: %empty  */
#line 5125 "parse.y"
           {
                        (yyval.id) = p->it_id;
                        p->it_id = 0;
                    }
#line 15461 "parse.c"
    break;

  case 490: /* @26: %empty  */
#line 5132 "parse.y"
                    {
                        token_info_push(p, "->", &(yylsp[0]));
                        (yyval.vars) = dyna_push(p);
                    }
#line 15470 "parse.c"
    break;

  case 491: /* $@27: %empty  */
#line 5138 "parse.y"
                    {
                        CMDARG_PUSH(0);
                    }
#line 15478 "parse.c"
    break;

  case 492: /* lambda: "->" @26 max_numparam numparam it_id allow_exits f_larglist $@27 lambda_body  */
#line 5142 "parse.y"
                    {
                        int max_numparam = p->max_numparam;
                        ID it_id = p->it_id;
                        p->lex.lpar_beg = (yyvsp[-8].num);
                        p->max_numparam = (yyvsp[-6].num);
                        p->it_id = (yyvsp[-4].id);
                        restore_block_exit(p, (yyvsp[-3].node_exits));
                        CMDARG_POP();
                        (yyvsp[-2].node_args) = args_with_numbered(p, (yyvsp[-2].node_args), max_numparam, it_id);
                        {
                            YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                            (yyval.node) = NEW_LAMBDA((yyvsp[-2].node_args), (yyvsp[0].locations_lambda_body)->node, &loc, &(yylsp[-8]), &(yyvsp[0].locations_lambda_body)->opening_loc, &(yyvsp[0].locations_lambda_body)->closing_loc);
                            nd_set_line(RNODE_LAMBDA((yyval.node))->nd_body, (yylsp[0]).end_pos.lineno);
                            nd_set_line((yyval.node), (yylsp[-2]).end_pos.lineno);
                            nd_set_first_loc((yyval.node), (yylsp[-8]).beg_pos);
                            xfree((yyvsp[0].locations_lambda_body));
                        }
                    /*% ripper: lambda!($:args, $:body) %*/
                        numparam_pop(p, (yyvsp[-5].node));
                        dyna_pop(p, (yyvsp[-7].vars));
                    }
#line 15504 "parse.c"
    break;

  case 493: /* f_larglist: '(' f_args opt_bv_decl ')'  */
#line 5166 "parse.y"
                    {
                        p->ctxt.in_argdef = 0;
                        (yyval.node_args) = (yyvsp[-2].node_args);
                        p->max_numparam = ORDINAL_PARAM;
                    /*% ripper: paren!($:2) %*/
                    }
#line 15515 "parse.c"
    break;

  case 494: /* f_larglist: f_args  */
#line 5173 "parse.y"
                    {
                        p->ctxt.in_argdef = 0;
                        if (!args_info_empty_p(&(yyvsp[0].node_args)->nd_ainfo))
                            p->max_numparam = ORDINAL_PARAM;
                        (yyval.node_args) = (yyvsp[0].node_args);
                    }
#line 15526 "parse.c"
    break;

  case 495: /* lambda_body: tLAMBEG compstmt_stmts '}'  */
#line 5182 "parse.y"
                    {
                        token_info_pop(p, "}", &(yylsp[0]));
                        (yyval.locations_lambda_body) = new_locations_lambda_body(p, (yyvsp[-1].node), &(yylsp[-1]), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: $:2 %*/
                    }
#line 15536 "parse.c"
    break;

  case 496: /* $@28: %empty  */
#line 5188 "parse.y"
                    {
                        push_end_expect_token_locations(p, &(yylsp[0]).beg_pos);
                    }
#line 15544 "parse.c"
    break;

  case 497: /* lambda_body: "'do' for lambda" $@28 bodystmt k_end  */
#line 5192 "parse.y"
                    {
                        (yyval.locations_lambda_body) = new_locations_lambda_body(p, (yyvsp[-1].node), &(yylsp[-1]), &(yylsp[-3]), &(yylsp[0]));
                    /*% ripper: $:3 %*/
                    }
#line 15553 "parse.c"
    break;

  case 498: /* do_block: k_do_block do_body k_end  */
#line 5199 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                        set_embraced_location((yyval.node), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: $:2 %*/
                    }
#line 15563 "parse.c"
    break;

  case 499: /* block_call: command do_block  */
#line 5207 "parse.y"
                    {
                        if (nd_type_p((yyvsp[-1].node), NODE_YIELD)) {
                            compile_error(p, "block given to yield");
                        }
                        else {
                            block_dup_check(p, get_nd_args(p, (yyvsp[-1].node)), (yyvsp[0].node));
                        }
                        (yyval.node) = method_add_block(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                        fixpos((yyval.node), (yyvsp[-1].node));
                    /*% ripper: method_add_block!($:1, $:2) %*/
                    }
#line 15579 "parse.c"
    break;

  case 500: /* block_call: block_call call_op2 operation2 opt_paren_args  */
#line 5219 "parse.y"
                    {
                        bool has_args = (yyvsp[0].node) != 0;
                        if (NODE_EMPTY_ARGS_P((yyvsp[0].node))) (yyvsp[0].node) = 0;
                        (yyval.node) = new_qcall(p, (yyvsp[-2].id), (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                    /*% ripper: call!($:1, $:2, $:3) %*/
                        if (has_args) {
                        /*% ripper: method_add_arg!($:$, $:4) %*/
                        }
                    }
#line 15593 "parse.c"
    break;

  case 501: /* block_call: block_call call_op2 operation2 opt_paren_args brace_block  */
#line 5229 "parse.y"
                    {
                        if (NODE_EMPTY_ARGS_P((yyvsp[-1].node))) (yyvsp[-1].node) = 0;
                        (yyval.node) = new_command_qcall(p, (yyvsp[-3].id), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[-1].node), (yyvsp[0].node), &(yylsp[-2]), &(yyloc));
                    /*% ripper: method_add_block!(command_call!($:1, $:2, $:3, $:4), $:5) %*/
                    }
#line 15603 "parse.c"
    break;

  case 502: /* block_call: block_call call_op2 operation2 command_args do_block  */
#line 5235 "parse.y"
                    {
                        (yyval.node) = new_command_qcall(p, (yyvsp[-3].id), (yyvsp[-4].node), (yyvsp[-2].id), (yyvsp[-1].node), (yyvsp[0].node), &(yylsp[-2]), &(yyloc));
                    /*% ripper: method_add_block!(command_call!($:1, $:2, $:3, $:4), $:5) %*/
                    }
#line 15612 "parse.c"
    break;

  case 503: /* block_call: block_call call_op2 paren_args  */
#line 5240 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, (yyvsp[-1].id), (yyvsp[-2].node), idCall, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[-1]).end_pos.lineno);
                    /*% ripper: method_add_arg!(call!($:1, $:2, ID2VAL(idCall)), $:3) %*/
                    }
#line 15622 "parse.c"
    break;

  case 504: /* method_call: fcall paren_args  */
#line 5248 "parse.y"
                    {
                        (yyvsp[-1].node_fcall)->nd_args = (yyvsp[0].node);
                        (yyval.node) = (NODE *)(yyvsp[-1].node_fcall);
                        nd_set_last_loc((yyvsp[-1].node_fcall), (yylsp[0]).end_pos);
                    /*% ripper: method_add_arg!(fcall!($:1), $:2) %*/
                    }
#line 15633 "parse.c"
    break;

  case 505: /* method_call: primary_value call_op operation2 opt_paren_args  */
#line 5255 "parse.y"
                    {
                        bool has_args = (yyvsp[0].node) != 0;
                        if (NODE_EMPTY_ARGS_P((yyvsp[0].node))) (yyvsp[0].node) = 0;
                        (yyval.node) = new_qcall(p, (yyvsp[-2].id), (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[-1]).end_pos.lineno);
                    /*% ripper: call!($:1, $:2, $:3) %*/
                        if (has_args) {
                        /*% ripper: method_add_arg!($:$, $:4) %*/
                        }
                    }
#line 15648 "parse.c"
    break;

  case 506: /* method_call: primary_value "::" operation2 paren_args  */
#line 5266 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, idCOLON2, (yyvsp[-3].node), (yyvsp[-1].id), (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[-1]).end_pos.lineno);
                    /*% ripper: method_add_arg!(call!($:1, $:2, $:3), $:4) %*/
                    }
#line 15658 "parse.c"
    break;

  case 507: /* method_call: primary_value "::" operation3  */
#line 5272 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, idCOLON2, (yyvsp[-2].node), (yyvsp[0].id), 0, &(yylsp[0]), &(yyloc));
                    /*% ripper: call!($:1, $:2, $:3) %*/
                    }
#line 15667 "parse.c"
    break;

  case 508: /* method_call: primary_value call_op2 paren_args  */
#line 5277 "parse.y"
                    {
                        (yyval.node) = new_qcall(p, (yyvsp[-1].id), (yyvsp[-2].node), idCall, (yyvsp[0].node), &(yylsp[-1]), &(yyloc));
                        nd_set_line((yyval.node), (yylsp[-1]).end_pos.lineno);
                    /*% ripper: method_add_arg!(call!($:1, $:2, ID2VAL(idCall)), $:3) %*/
                    }
#line 15677 "parse.c"
    break;

  case 509: /* method_call: "'super'" paren_args  */
#line 5283 "parse.y"
                    {
                        rb_code_location_t lparen_loc = (yylsp[0]);
                        rb_code_location_t rparen_loc = (yylsp[0]);
                        lparen_loc.end_pos.column = lparen_loc.beg_pos.column + 1;
                        rparen_loc.beg_pos.column = rparen_loc.end_pos.column - 1;

                        (yyval.node) = NEW_SUPER((yyvsp[0].node), &(yyloc), &(yylsp[-1]), &lparen_loc, &rparen_loc);
                    /*% ripper: super!($:2) %*/
                    }
#line 15691 "parse.c"
    break;

  case 510: /* method_call: "'super'"  */
#line 5293 "parse.y"
                    {
                        (yyval.node) = NEW_ZSUPER(&(yyloc));
                    /*% ripper: zsuper! %*/
                    }
#line 15700 "parse.c"
    break;

  case 511: /* method_call: primary_value '[' opt_call_args rbracket  */
#line 5298 "parse.y"
                    {
                        (yyval.node) = NEW_CALL((yyvsp[-3].node), tAREF, (yyvsp[-1].node), &(yyloc));
                        fixpos((yyval.node), (yyvsp[-3].node));
                    /*% ripper: aref!($:1, $:3) %*/
                    }
#line 15710 "parse.c"
    break;

  case 512: /* brace_block: '{' brace_body '}'  */
#line 5306 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                        set_embraced_location((yyval.node), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: $:2 %*/
                    }
#line 15720 "parse.c"
    break;

  case 513: /* brace_block: k_do do_body k_end  */
#line 5312 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                        set_embraced_location((yyval.node), &(yylsp[-2]), &(yylsp[0]));
                    /*% ripper: $:2 %*/
                    }
#line 15730 "parse.c"
    break;

  case 514: /* @29: %empty  */
#line 5319 "parse.y"
             {(yyval.vars) = dyna_push(p);}
#line 15736 "parse.c"
    break;

  case 515: /* brace_body: @29 max_numparam numparam it_id allow_exits opt_block_param_def compstmt_stmts  */
#line 5322 "parse.y"
                    {
                        int max_numparam = p->max_numparam;
                        ID it_id = p->it_id;
                        p->max_numparam = (yyvsp[-5].num);
                        p->it_id = (yyvsp[-3].id);
                        (yyvsp[-1].node_args) = args_with_numbered(p, (yyvsp[-1].node_args), max_numparam, it_id);
                        (yyval.node) = NEW_ITER((yyvsp[-1].node_args), (yyvsp[0].node), &(yyloc));
                    /*% ripper: brace_block!($:args, $:compstmt) %*/
                        restore_block_exit(p, (yyvsp[-2].node_exits));
                        numparam_pop(p, (yyvsp[-4].node));
                        dyna_pop(p, (yyvsp[-6].vars));
                    }
#line 15753 "parse.c"
    break;

  case 516: /* @30: %empty  */
#line 5336 "parse.y"
             {
                        (yyval.vars) = dyna_push(p);
                        CMDARG_PUSH(0);
                    }
#line 15762 "parse.c"
    break;

  case 517: /* do_body: @30 max_numparam numparam it_id allow_exits opt_block_param_def bodystmt  */
#line 5342 "parse.y"
                    {
                        int max_numparam = p->max_numparam;
                        ID it_id = p->it_id;
                        p->max_numparam = (yyvsp[-5].num);
                        p->it_id = (yyvsp[-3].id);
                        (yyvsp[-1].node_args) = args_with_numbered(p, (yyvsp[-1].node_args), max_numparam, it_id);
                        (yyval.node) = NEW_ITER((yyvsp[-1].node_args), (yyvsp[0].node), &(yyloc));
                    /*% ripper: do_block!($:args, $:bodystmt) %*/
                        CMDARG_POP();
                        restore_block_exit(p, (yyvsp[-2].node_exits));
                        numparam_pop(p, (yyvsp[-4].node));
                        dyna_pop(p, (yyvsp[-6].vars));
                    }
#line 15780 "parse.c"
    break;

  case 518: /* case_args: arg_value  */
#line 5358 "parse.y"
                    {
                        check_literal_when(p, (yyvsp[0].node), &(yylsp[0]));
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!(args_new!, $:arg_value) %*/
                    }
#line 15790 "parse.c"
    break;

  case 519: /* case_args: "*" arg_value  */
#line 5364 "parse.y"
                    {
                        (yyval.node) = NEW_SPLAT((yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: args_add_star!(args_new!, $:arg_value) %*/
                    }
#line 15799 "parse.c"
    break;

  case 520: /* case_args: case_args ',' arg_value  */
#line 5369 "parse.y"
                    {
                        check_literal_when(p, (yyvsp[0].node), &(yylsp[0]));
                        (yyval.node) = last_arg_append(p, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add!($:non_last_args, $:arg_value) %*/
                    }
#line 15809 "parse.c"
    break;

  case 521: /* case_args: case_args ',' "*" arg_value  */
#line 5375 "parse.y"
                    {
                        (yyval.node) = rest_arg_append(p, (yyvsp[-3].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: args_add_star!($:non_last_args, $:arg_value) %*/
                    }
#line 15818 "parse.c"
    break;

  case 522: /* case_body: k_when case_args then compstmt_stmts cases  */
#line 5384 "parse.y"
                    {
                        (yyval.node) = NEW_WHEN((yyvsp[-3].node), (yyvsp[-1].node), (yyvsp[0].node), &(yyloc), &(yylsp[-4]), &(yylsp[-2]));
                        fixpos((yyval.node), (yyvsp[-3].node));
                    /*% ripper: when!($:2, $:4, $:5) %*/
                    }
#line 15828 "parse.c"
    break;

  case 525: /* p_pvtbl: %empty  */
#line 5395 "parse.y"
           {(yyval.tbl) = p->pvtbl; p->pvtbl = st_init_numtable();}
#line 15834 "parse.c"
    break;

  case 526: /* p_pktbl: %empty  */
#line 5396 "parse.y"
           {(yyval.tbl) = p->pktbl; p->pktbl = 0;}
#line 15840 "parse.c"
    break;

  case 527: /* p_in_kwarg: %empty  */
#line 5398 "parse.y"
               {
                        (yyval.ctxt) = p->ctxt;
                        SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
                        p->command_start = FALSE;
                        p->ctxt.in_kwarg = 1;
                        p->ctxt.in_alt_pattern = 0;
                        p->ctxt.capture_in_pattern = 0;
                    }
#line 15853 "parse.c"
    break;

  case 528: /* $@31: %empty  */
#line 5411 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        pop_pvtbl(p, (yyvsp[-3].tbl));
                        p->ctxt.in_kwarg = (yyvsp[-4].ctxt).in_kwarg;
                        p->ctxt.in_alt_pattern = (yyvsp[-4].ctxt).in_alt_pattern;
                        p->ctxt.capture_in_pattern = (yyvsp[-4].ctxt).capture_in_pattern;
                    }
#line 15865 "parse.c"
    break;

  case 529: /* p_case_body: "'in'" p_in_kwarg p_pvtbl p_pktbl p_top_expr then $@31 compstmt_stmts p_cases  */
#line 5420 "parse.y"
                    {
                        (yyval.node) = NEW_IN((yyvsp[-4].node), (yyvsp[-1].node), (yyvsp[0].node), &(yyloc), &(yylsp[-8]), &(yylsp[-3]), &NULL_LOC);
                    /*% ripper: in!($:expr, $:compstmt, $:cases) %*/
                    }
#line 15874 "parse.c"
    break;

  case 533: /* p_top_expr: p_top_expr_body "'if' modifier" expr_value  */
#line 5432 "parse.y"
                    {
                        (yyval.node) = new_if(p, (yyvsp[0].node), (yyvsp[-2].node), 0, &(yyloc), &(yylsp[-1]), &NULL_LOC, &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: if_mod!($:3, $:1) %*/
                    }
#line 15884 "parse.c"
    break;

  case 534: /* p_top_expr: p_top_expr_body "'unless' modifier" expr_value  */
#line 5438 "parse.y"
                    {
                        (yyval.node) = new_unless(p, (yyvsp[0].node), (yyvsp[-2].node), 0, &(yyloc), &(yylsp[-1]), &NULL_LOC, &NULL_LOC);
                        fixpos((yyval.node), (yyvsp[0].node));
                    /*% ripper: unless_mod!($:3, $:1) %*/
                    }
#line 15894 "parse.c"
    break;

  case 536: /* p_top_expr_body: p_expr ','  */
#line 5447 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 1, 0, 0, &(yyloc));
                        (yyval.node) = new_array_pattern(p, 0, (yyvsp[-1].node), (yyval.node), &(yyloc));
                    /*% ripper: aryptn!(Qnil, [$:1], Qnil, Qnil) %*/
                    }
#line 15904 "parse.c"
    break;

  case 537: /* p_top_expr_body: p_expr ',' p_args  */
#line 5453 "parse.y"
                    {
                        (yyval.node) = new_array_pattern(p, 0, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-2]).beg_pos);
                    /*% ripper: aryptn!(Qnil, aryptn_pre_args(p, $:1, $:3[0]), *$:3[1..2]) %*/
                    }
#line 15914 "parse.c"
    break;

  case 538: /* p_top_expr_body: p_find  */
#line 5459 "parse.y"
                    {
                        (yyval.node) = new_find_pattern(p, 0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: fndptn!(Qnil, *$:1[0..2]) %*/
                    }
#line 15923 "parse.c"
    break;

  case 539: /* p_top_expr_body: p_args_tail  */
#line 5464 "parse.y"
                    {
                        (yyval.node) = new_array_pattern(p, 0, 0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: aryptn!(Qnil, *$:1[0..2]) %*/
                    }
#line 15932 "parse.c"
    break;

  case 540: /* p_top_expr_body: p_kwargs  */
#line 5469 "parse.y"
                    {
                        (yyval.node) = new_hash_pattern(p, 0, (yyvsp[0].node), &(yyloc));
                    /*% ripper: hshptn!(Qnil, *$:1[0..1]) %*/
                    }
#line 15941 "parse.c"
    break;

  case 542: /* p_as: p_expr "=>" p_variable  */
#line 5479 "parse.y"
                    {
                        NODE *n = NEW_LIST((yyvsp[-2].node), &(yyloc));
                        n = list_append(p, n, (yyvsp[0].node));
                        (yyval.node) = new_hash(p, n, &(yyloc));
                    /*% ripper: binary!($:1, ID2VAL((id_assoc)), $:3) %*/
                    }
#line 15952 "parse.c"
    break;

  case 544: /* $@32: %empty  */
#line 5489 "parse.y"
                    {
                        p->ctxt.in_alt_pattern = 1;
                    }
#line 15960 "parse.c"
    break;

  case 545: /* p_alt: p_alt '|' $@32 p_expr_basic  */
#line 5493 "parse.y"
                    {
                        if (p->ctxt.capture_in_pattern) {
                            yyerror1(&(yylsp[-2]), "alternative pattern after variable capture");
                        }
                        p->ctxt.in_alt_pattern = 0;
                        (yyval.node) = NEW_OR((yyvsp[-3].node), (yyvsp[0].node), &(yyloc), &(yylsp[-2]));
                    /*% ripper: binary!($:left, ID2VAL(idOr), $:right) %*/
                    }
#line 15973 "parse.c"
    break;

  case 547: /* p_lparen: '(' p_pktbl  */
#line 5505 "parse.y"
                    {
                        (yyval.tbl) = (yyvsp[0].tbl);
                    /*% ripper: $:2 %*/
                    }
#line 15982 "parse.c"
    break;

  case 548: /* p_lbracket: '[' p_pktbl  */
#line 5512 "parse.y"
                    {
                        (yyval.tbl) = (yyvsp[0].tbl);
                    /*% ripper: $:2 %*/
                    }
#line 15991 "parse.c"
    break;

  case 551: /* p_expr_basic: p_const p_lparen p_args rparen  */
#line 5521 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_array_pattern(p, (yyvsp[-3].node), 0, (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: aryptn!($:p_const, *$:p_args[0..2]) %*/
                    }
#line 16002 "parse.c"
    break;

  case 552: /* p_expr_basic: p_const p_lparen p_find rparen  */
#line 5528 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_find_pattern(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: fndptn!($:p_const, *$:p_find[0..2]) %*/
                    }
#line 16013 "parse.c"
    break;

  case 553: /* p_expr_basic: p_const p_lparen p_kwargs rparen  */
#line 5535 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_hash_pattern(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: hshptn!($:p_const, *$:p_kwargs[0..1]) %*/
                    }
#line 16024 "parse.c"
    break;

  case 554: /* p_expr_basic: p_const '(' rparen  */
#line 5542 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 0, 0, 0, &(yyloc));
                        (yyval.node) = new_array_pattern(p, (yyvsp[-2].node), 0, (yyval.node), &(yyloc));
                        /*% ripper: aryptn!($:p_const, Qnil, Qnil, Qnil) %*/
                    }
#line 16034 "parse.c"
    break;

  case 555: /* p_expr_basic: p_const p_lbracket p_args rbracket  */
#line 5548 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_array_pattern(p, (yyvsp[-3].node), 0, (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: aryptn!($:p_const, *$:p_args[0..2]) %*/
                    }
#line 16045 "parse.c"
    break;

  case 556: /* p_expr_basic: p_const p_lbracket p_find rbracket  */
#line 5555 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_find_pattern(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: fndptn!($:p_const, *$:p_find[0..2]) %*/
                    }
#line 16056 "parse.c"
    break;

  case 557: /* p_expr_basic: p_const p_lbracket p_kwargs rbracket  */
#line 5562 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = new_hash_pattern(p, (yyvsp[-3].node), (yyvsp[-1].node), &(yyloc));
                        nd_set_first_loc((yyval.node), (yylsp[-3]).beg_pos);
                    /*% ripper: hshptn!($:p_const, *$:p_kwargs[0..1]) %*/
                    }
#line 16067 "parse.c"
    break;

  case 558: /* p_expr_basic: p_const '[' rbracket  */
#line 5569 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 0, 0, 0, &(yyloc));
                        (yyval.node) = new_array_pattern(p, (yyvsp[-2].node), 0, (yyval.node), &(yyloc));
                    /*% ripper: aryptn!($:1, Qnil, Qnil, Qnil) %*/
                    }
#line 16077 "parse.c"
    break;

  case 559: /* p_expr_basic: "[" p_args rbracket  */
#line 5575 "parse.y"
                    {
                        (yyval.node) = new_array_pattern(p, 0, 0, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: aryptn!(Qnil, *$:p_args[0..2]) %*/
                    }
#line 16086 "parse.c"
    break;

  case 560: /* p_expr_basic: "[" p_find rbracket  */
#line 5580 "parse.y"
                    {
                        (yyval.node) = new_find_pattern(p, 0, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: fndptn!(Qnil, *$:p_find[0..2]) %*/
                    }
#line 16095 "parse.c"
    break;

  case 561: /* p_expr_basic: "[" rbracket  */
#line 5585 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 0, 0, 0, &(yyloc));
                        (yyval.node) = new_array_pattern(p, 0, 0, (yyval.node), &(yyloc));
                    /*% ripper: aryptn!(Qnil, Qnil, Qnil, Qnil) %*/
                    }
#line 16105 "parse.c"
    break;

  case 562: /* $@33: %empty  */
#line 5591 "parse.y"
                    {
                        p->ctxt.in_kwarg = 0;
                    }
#line 16113 "parse.c"
    break;

  case 563: /* p_expr_basic: "{" p_pktbl lex_ctxt $@33 p_kwargs rbrace  */
#line 5595 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-4].tbl));
                        p->ctxt.in_kwarg = (yyvsp[-3].ctxt).in_kwarg;
                        (yyval.node) = new_hash_pattern(p, 0, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: hshptn!(Qnil, *$:p_kwargs[0..1]) %*/
                    }
#line 16124 "parse.c"
    break;

  case 564: /* p_expr_basic: "{" rbrace  */
#line 5602 "parse.y"
                    {
                        (yyval.node) = new_hash_pattern_tail(p, 0, 0, &(yyloc));
                        (yyval.node) = new_hash_pattern(p, 0, (yyval.node), &(yyloc));
                    /*% ripper: hshptn!(Qnil, Qnil, Qnil) %*/
                    }
#line 16134 "parse.c"
    break;

  case 565: /* p_expr_basic: "(" p_pktbl p_expr rparen  */
#line 5608 "parse.y"
                    {
                        pop_pktbl(p, (yyvsp[-2].tbl));
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: $:p_expr %*/
                    }
#line 16144 "parse.c"
    break;

  case 566: /* p_args: p_expr  */
#line 5616 "parse.y"
                    {
                        NODE *pre_args = NEW_LIST((yyvsp[0].node), &(yyloc));
                        (yyval.node) = new_array_pattern_tail(p, pre_args, 0, 0, 0, &(yyloc));
                    /*% ripper: [[$:1], Qnil, Qnil] %*/
                    }
#line 16154 "parse.c"
    break;

  case 567: /* p_args: p_args_head  */
#line 5622 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, (yyvsp[0].node), 1, 0, 0, &(yyloc));
                    /*% ripper: [$:1, Qnil, Qnil] %*/
                    }
#line 16163 "parse.c"
    break;

  case 568: /* p_args: p_args_head p_arg  */
#line 5627 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, list_concat((yyvsp[-1].node), (yyvsp[0].node)), 0, 0, 0, &(yyloc));
                    /*% ripper: [rb_ary_concat($:1, $:2), Qnil, Qnil] %*/
                    }
#line 16172 "parse.c"
    break;

  case 569: /* p_args: p_args_head p_rest  */
#line 5632 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, (yyvsp[-1].node), 1, (yyvsp[0].node), 0, &(yyloc));
                    /*% ripper: [$:1, $:2, Qnil] %*/
                    }
#line 16181 "parse.c"
    break;

  case 570: /* p_args: p_args_head p_rest ',' p_args_post  */
#line 5637 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, (yyvsp[-3].node), 1, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: [$:1, $:2, $:4] %*/
                    }
#line 16190 "parse.c"
    break;

  case 573: /* p_args_head: p_args_head p_arg ','  */
#line 5646 "parse.y"
                    {
                        (yyval.node) = list_concat((yyvsp[-2].node), (yyvsp[-1].node));
                    /*% ripper: rb_ary_concat($:1, $:2) %*/
                    }
#line 16199 "parse.c"
    break;

  case 574: /* p_args_tail: p_rest  */
#line 5653 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 1, (yyvsp[0].node), 0, &(yyloc));
                    /*% ripper: [Qnil, $:1, Qnil] %*/
                    }
#line 16208 "parse.c"
    break;

  case 575: /* p_args_tail: p_rest ',' p_args_post  */
#line 5658 "parse.y"
                    {
                        (yyval.node) = new_array_pattern_tail(p, 0, 1, (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: [Qnil, $:1, $:3] %*/
                    }
#line 16217 "parse.c"
    break;

  case 576: /* p_find: p_rest ',' p_args_post ',' p_rest  */
#line 5665 "parse.y"
                    {
                        (yyval.node) = new_find_pattern_tail(p, (yyvsp[-4].node), (yyvsp[-2].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: [$:1, $:3, $:5] %*/
                    }
#line 16226 "parse.c"
    break;

  case 577: /* p_rest: "*" "local variable or method"  */
#line 5673 "parse.y"
                    {
                        error_duplicate_pattern_variable(p, (yyvsp[0].id), &(yylsp[0]));
                    /*% ripper: var_field!($:2) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 16236 "parse.c"
    break;

  case 578: /* p_rest: "*"  */
#line 5679 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: var_field!(Qnil) %*/
                    }
#line 16245 "parse.c"
    break;

  case 580: /* p_args_post: p_args_post ',' p_arg  */
#line 5687 "parse.y"
                    {
                        (yyval.node) = list_concat((yyvsp[-2].node), (yyvsp[0].node));
                    /*% ripper: rb_ary_concat($:1, $:3) %*/
                    }
#line 16254 "parse.c"
    break;

  case 581: /* p_arg: p_expr  */
#line 5694 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: [$:1] %*/
                    }
#line 16263 "parse.c"
    break;

  case 582: /* p_kwargs: p_kwarg ',' p_any_kwrest  */
#line 5701 "parse.y"
                    {
                        (yyval.node) =  new_hash_pattern_tail(p, new_unique_key_hash(p, (yyvsp[-2].node), &(yyloc)), (yyvsp[0].id), &(yyloc));
                    /*% ripper: [$:1, $:3] %*/
                    }
#line 16272 "parse.c"
    break;

  case 583: /* p_kwargs: p_kwarg  */
#line 5706 "parse.y"
                    {
                        (yyval.node) =  new_hash_pattern_tail(p, new_unique_key_hash(p, (yyvsp[0].node), &(yyloc)), 0, &(yyloc));
                    /*% ripper: [$:1, Qnil] %*/
                    }
#line 16281 "parse.c"
    break;

  case 584: /* p_kwargs: p_kwarg ','  */
#line 5711 "parse.y"
                    {
                        (yyval.node) =  new_hash_pattern_tail(p, new_unique_key_hash(p, (yyvsp[-1].node), &(yyloc)), 0, &(yyloc));
                    /*% ripper: [$:1, Qnil] %*/
                    }
#line 16290 "parse.c"
    break;

  case 585: /* p_kwargs: p_any_kwrest  */
#line 5716 "parse.y"
                    {
                        (yyval.node) =  new_hash_pattern_tail(p, new_hash(p, 0, &(yyloc)), (yyvsp[0].id), &(yyloc));
                    /*% ripper: [[], $:1] %*/
                    }
#line 16299 "parse.c"
    break;

  case 587: /* p_kwarg: p_kwarg ',' p_kw  */
#line 5725 "parse.y"
                    {
                        (yyval.node) = list_concat((yyvsp[-2].node), (yyvsp[0].node));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 16308 "parse.c"
    break;

  case 588: /* p_kw: p_kw_label p_expr  */
#line 5732 "parse.y"
                    {
                        error_duplicate_pattern_key(p, (yyvsp[-1].id), &(yylsp[-1]));
                        (yyval.node) = list_append(p, NEW_LIST(NEW_SYM(rb_id2str((yyvsp[-1].id)), &(yylsp[-1])), &(yyloc)), (yyvsp[0].node));
                    /*% ripper: [$:1, $:2] %*/
                    }
#line 16318 "parse.c"
    break;

  case 589: /* p_kw: p_kw_label  */
#line 5738 "parse.y"
                    {
                        error_duplicate_pattern_key(p, (yyvsp[0].id), &(yylsp[0]));
                        if ((yyvsp[0].id) && !is_local_id((yyvsp[0].id))) {
                            yyerror1(&(yylsp[0]), "key must be valid as local variables");
                        }
                        error_duplicate_pattern_variable(p, (yyvsp[0].id), &(yylsp[0]));
                        (yyval.node) = list_append(p, NEW_LIST(NEW_SYM(rb_id2str((yyvsp[0].id)), &(yyloc)), &(yyloc)), assignable(p, (yyvsp[0].id), 0, &(yyloc)));
                    /*% ripper: [$:1, Qnil] %*/
                    }
#line 16332 "parse.c"
    break;

  case 591: /* p_kw_label: "string literal" string_contents tLABEL_END  */
#line 5751 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-2]), &(yylsp[0]));
                        if (!(yyvsp[-1].node) || nd_type_p((yyvsp[-1].node), NODE_STR)) {
                            NODE *node = dsym_node(p, (yyvsp[-1].node), &loc);
                            (yyval.id) = rb_sym2id(rb_node_sym_string_val(node));
                        }
                        else {
                            yyerror1(&loc, "symbol literal with interpolation is not allowed");
                            (yyval.id) = rb_intern_str(STR_NEW0());
                        }
                    /*% ripper: $:2 %*/
                    }
#line 16349 "parse.c"
    break;

  case 592: /* p_kwrest: kwrest_mark "local variable or method"  */
#line 5766 "parse.y"
                    {
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: var_field!($:2) %*/
                    }
#line 16358 "parse.c"
    break;

  case 593: /* p_kwrest: kwrest_mark  */
#line 5771 "parse.y"
                    {
                        (yyval.id) = 0;
                    /*% ripper: Qnil %*/
                    }
#line 16367 "parse.c"
    break;

  case 594: /* p_kwnorest: kwrest_mark "'nil'"  */
#line 5778 "parse.y"
                    {
                        (yyval.id) = 0;
                    }
#line 16375 "parse.c"
    break;

  case 596: /* p_any_kwrest: p_kwnorest  */
#line 5785 "parse.y"
                    {
                        (yyval.id) = idNil;
                    /*% ripper: var_field!(ID2VAL(idNil)) %*/
                    }
#line 16384 "parse.c"
    break;

  case 598: /* range_expr_p_primitive: p_primitive ".." p_primitive  */
#line 3104 "parse.y"
                    {
                        value_expr(p, (yyvsp[-2].node));
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = NEW_DOT2((yyvsp[-2].node), (yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: dot2!($:1, $:3) %*/
                    }
#line 16395 "parse.c"
    break;

  case 599: /* range_expr_p_primitive: p_primitive "..." p_primitive  */
#line 3111 "parse.y"
                    {
                        value_expr(p, (yyvsp[-2].node));
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = NEW_DOT3((yyvsp[-2].node), (yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: dot3!($:1, $:3) %*/
                    }
#line 16406 "parse.c"
    break;

  case 600: /* range_expr_p_primitive: p_primitive ".."  */
#line 3118 "parse.y"
                    {
                        value_expr(p, (yyvsp[-1].node));
                        (yyval.node) = NEW_DOT2((yyvsp[-1].node), new_nil_at(p, &(yylsp[0]).end_pos), &(yyloc), &(yylsp[0]));
                    /*% ripper: dot2!($:1, Qnil) %*/
                    }
#line 16416 "parse.c"
    break;

  case 601: /* range_expr_p_primitive: p_primitive "..."  */
#line 3124 "parse.y"
                    {
                        value_expr(p, (yyvsp[-1].node));
                        (yyval.node) = NEW_DOT3((yyvsp[-1].node), new_nil_at(p, &(yylsp[0]).end_pos), &(yyloc), &(yylsp[0]));
                    /*% ripper: dot3!($:1, Qnil) %*/
                    }
#line 16426 "parse.c"
    break;

  case 602: /* range_expr_p_primitive: "(.." p_primitive  */
#line 3130 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = NEW_DOT2(new_nil_at(p, &(yylsp[-1]).beg_pos), (yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: dot2!(Qnil, $:2) %*/
                    }
#line 16436 "parse.c"
    break;

  case 603: /* range_expr_p_primitive: "(..." p_primitive  */
#line 3136 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = NEW_DOT3(new_nil_at(p, &(yylsp[-1]).beg_pos), (yyvsp[0].node), &(yyloc), &(yylsp[-1]));
                    /*% ripper: dot3!(Qnil, $:2) %*/
                    }
#line 16446 "parse.c"
    break;

  case 616: /* p_primitive: keyword_variable  */
#line 5800 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper: var_ref!($:1) %*/
                    }
#line 16455 "parse.c"
    break;

  case 618: /* p_variable: "local variable or method"  */
#line 5808 "parse.y"
                    {
                        error_duplicate_pattern_variable(p, (yyvsp[0].id), &(yylsp[0]));
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 16465 "parse.c"
    break;

  case 619: /* p_var_ref: '^' "local variable or method"  */
#line 5816 "parse.y"
                    {
                        NODE *n = gettable(p, (yyvsp[0].id), &(yyloc));
                        if (!n) {
                            n = NEW_ERROR(&(yyloc));
                        }
                        else if (!(nd_type_p(n, NODE_LVAR) || nd_type_p(n, NODE_DVAR))) {
                            compile_error(p, "%"PRIsVALUE": no such local variable", rb_id2str((yyvsp[0].id)));
                        }
                        (yyval.node) = n;
                    /*% ripper: var_ref!($:2) %*/
                    }
#line 16481 "parse.c"
    break;

  case 620: /* p_var_ref: '^' nonlocal_var  */
#line 5828 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper: var_ref!($:2) %*/
                    }
#line 16490 "parse.c"
    break;

  case 621: /* p_expr_ref: '^' "(" expr_value rparen  */
#line 5835 "parse.y"
                    {
                        (yyval.node) = NEW_BLOCK((yyvsp[-1].node), &(yyloc));
                    /*% ripper: begin!($:3) %*/
                    }
#line 16499 "parse.c"
    break;

  case 622: /* p_const: ":: at EXPR_BEG" cname  */
#line 5842 "parse.y"
                    {
                        (yyval.node) = NEW_COLON3((yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0]));
                    /*% ripper: top_const_ref!($:2) %*/
                    }
#line 16508 "parse.c"
    break;

  case 623: /* p_const: p_const "::" cname  */
#line 5847 "parse.y"
                    {
                        (yyval.node) = NEW_COLON2((yyvsp[-2].node), (yyvsp[0].id), &(yyloc), &(yylsp[-1]), &(yylsp[0]));
                    /*% ripper: const_path_ref!($:1, $:3) %*/
                    }
#line 16517 "parse.c"
    break;

  case 624: /* p_const: "constant"  */
#line 5852 "parse.y"
                   {
                        (yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc));
                    /*% ripper: var_ref!($:1) %*/
                   }
#line 16526 "parse.c"
    break;

  case 625: /* opt_rescue: k_rescue exc_list exc_var then compstmt_stmts opt_rescue  */
#line 5861 "parse.y"
                    {
                        NODE *err = (yyvsp[-3].node);
                        if ((yyvsp[-3].node)) {
                            err = NEW_ERRINFO(&(yylsp[-3]));
                            err = node_assign(p, (yyvsp[-3].node), err, NO_LEX_CTXT, &(yylsp[-3]));
                        }
                        (yyval.node) = NEW_RESBODY((yyvsp[-4].node), (yyvsp[-3].node), (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                        if ((yyvsp[-4].node)) {
                            fixpos((yyval.node), (yyvsp[-4].node));
                        }
                        else if ((yyvsp[-3].node)) {
                            fixpos((yyval.node), (yyvsp[-3].node));
                        }
                        else {
                            fixpos((yyval.node), (yyvsp[-1].node));
                        }
                    /*% ripper: rescue!($:2, $:3, $:5, $:6) %*/
                    }
#line 16549 "parse.c"
    break;

  case 627: /* exc_list: arg_value  */
#line 5883 "parse.y"
                    {
                        (yyval.node) = NEW_LIST((yyvsp[0].node), &(yyloc));
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 16558 "parse.c"
    break;

  case 628: /* exc_list: mrhs  */
#line 5888 "parse.y"
                    {
                        if (!((yyval.node) = splat_array((yyvsp[0].node)))) (yyval.node) = (yyvsp[0].node);
                    }
#line 16566 "parse.c"
    break;

  case 630: /* exc_var: "=>" lhs  */
#line 5895 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                    /*% ripper: $:2 %*/
                    }
#line 16575 "parse.c"
    break;

  case 632: /* opt_ensure: k_ensure stmts option_terms  */
#line 5903 "parse.y"
                    {
                        p->ctxt.in_rescue = (yyvsp[-2].ctxt).in_rescue;
                        (yyval.node) = (yyvsp[-1].node);
                        void_expr(p, void_stmts(p, (yyval.node)));
                    /*% ripper: ensure!($:2) %*/
                    }
#line 16586 "parse.c"
    break;

  case 636: /* strings: string  */
#line 5917 "parse.y"
                    {
                        if (!(yyvsp[0].node)) {
                            (yyval.node) = NEW_STR(STRING_NEW0(), &(yyloc));
                        }
                        else {
                            (yyval.node) = evstr2dstr(p, (yyvsp[0].node));
                        }
                    /*% ripper: $:1 %*/
                    }
#line 16600 "parse.c"
    break;

  case 639: /* string: string string1  */
#line 5931 "parse.y"
                    {
                        (yyval.node) = literal_concat(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: string_concat!($:1, $:2) %*/
                    }
#line 16609 "parse.c"
    break;

  case 640: /* string1: "string literal" string_contents "terminator"  */
#line 5938 "parse.y"
                    {
                        (yyval.node) = heredoc_dedent(p, (yyvsp[-1].node));
                        if ((yyval.node)) nd_set_loc((yyval.node), &(yyloc));
                    /*% ripper: $:2 %*/
                        if (p->heredoc_indent > 0) {
                        /*% ripper: heredoc_dedent!($:$, INT2NUM(%{p->heredoc_indent})) %*/
                            p->heredoc_indent = 0;
                        }
                    /*% ripper: string_literal!($:$) %*/
                    }
#line 16624 "parse.c"
    break;

  case 641: /* xstring: "backtick literal" xstring_contents "terminator"  */
#line 5951 "parse.y"
                    {
                        (yyval.node) = new_xstring(p, heredoc_dedent(p, (yyvsp[-1].node)), &(yyloc));
                    /*% ripper: $:2 %*/
                        if (p->heredoc_indent > 0) {
                        /*% ripper: heredoc_dedent!($:$, INT2NUM(%{p->heredoc_indent})) %*/
                            p->heredoc_indent = 0;
                        }
                    /*% ripper: xstring_literal!($:$) %*/
                    }
#line 16638 "parse.c"
    break;

  case 642: /* regexp: "regexp literal" regexp_contents tREGEXP_END  */
#line 5963 "parse.y"
                    {
                        (yyval.node) = new_regexp(p, (yyvsp[-1].node), (yyvsp[0].num), &(yyloc), &(yylsp[-2]), &(yylsp[-1]), &(yylsp[0]));
                    /*% ripper: regexp_literal!($:2, $:3) %*/
                    }
#line 16647 "parse.c"
    break;

  case 645: /* words_tWORDS_BEG_word_list: "word list" nonempty_list_' ' word_list "terminator"  */
#line 3153 "parse.y"
                    {
                        (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                    /*% ripper: array!($:3) %*/
                    }
#line 16656 "parse.c"
    break;

  case 647: /* word_list: %empty  */
#line 5973 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: words_new! %*/
                    }
#line 16665 "parse.c"
    break;

  case 648: /* word_list: word_list word nonempty_list_' '  */
#line 5978 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), evstr2dstr(p, (yyvsp[-1].node)));
                    /*% ripper: words_add!($:1, $:2) %*/
                    }
#line 16674 "parse.c"
    break;

  case 650: /* word: word string_content  */
#line 5987 "parse.y"
                    {
                        (yyval.node) = literal_concat(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: word_add!($:1, $:2) %*/
                    }
#line 16683 "parse.c"
    break;

  case 651: /* words_tSYMBOLS_BEG_symbol_list: "symbol list" nonempty_list_' ' symbol_list "terminator"  */
#line 3153 "parse.y"
                    {
                        (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                    /*% ripper: array!($:3) %*/
                    }
#line 16692 "parse.c"
    break;

  case 653: /* symbol_list: %empty  */
#line 5997 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: symbols_new! %*/
                    }
#line 16701 "parse.c"
    break;

  case 654: /* symbol_list: symbol_list word nonempty_list_' '  */
#line 6002 "parse.y"
                    {
                        (yyval.node) = symbol_append(p, (yyvsp[-2].node), evstr2dstr(p, (yyvsp[-1].node)));
                    /*% ripper: symbols_add!($:1, $:2) %*/
                    }
#line 16710 "parse.c"
    break;

  case 655: /* words_tQWORDS_BEG_qword_list: "verbatim word list" nonempty_list_' ' qword_list "terminator"  */
#line 3153 "parse.y"
                    {
                        (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                    /*% ripper: array!($:3) %*/
                    }
#line 16719 "parse.c"
    break;

  case 657: /* words_tQSYMBOLS_BEG_qsym_list: "verbatim symbol list" nonempty_list_' ' qsym_list "terminator"  */
#line 3153 "parse.y"
                    {
                        (yyval.node) = make_list((yyvsp[-1].node), &(yyloc));
                    /*% ripper: array!($:3) %*/
                    }
#line 16728 "parse.c"
    break;

  case 659: /* qword_list: %empty  */
#line 6015 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: qwords_new! %*/
                    }
#line 16737 "parse.c"
    break;

  case 660: /* qword_list: qword_list "literal content" nonempty_list_' '  */
#line 6020 "parse.y"
                    {
                        (yyval.node) = list_append(p, (yyvsp[-2].node), (yyvsp[-1].node));
                    /*% ripper: qwords_add!($:1, $:2) %*/
                    }
#line 16746 "parse.c"
    break;

  case 661: /* qsym_list: %empty  */
#line 6027 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: qsymbols_new! %*/
                    }
#line 16755 "parse.c"
    break;

  case 662: /* qsym_list: qsym_list "literal content" nonempty_list_' '  */
#line 6032 "parse.y"
                    {
                        (yyval.node) = symbol_append(p, (yyvsp[-2].node), (yyvsp[-1].node));
                    /*% ripper: qsymbols_add!($:1, $:2) %*/
                    }
#line 16764 "parse.c"
    break;

  case 663: /* string_contents: %empty  */
#line 6039 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: string_content! %*/
                    }
#line 16773 "parse.c"
    break;

  case 664: /* string_contents: string_contents string_content  */
#line 6044 "parse.y"
                    {
                        (yyval.node) = literal_concat(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: string_add!($:1, $:2) %*/
                    }
#line 16782 "parse.c"
    break;

  case 665: /* xstring_contents: %empty  */
#line 6051 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: xstring_new! %*/
                    }
#line 16791 "parse.c"
    break;

  case 666: /* xstring_contents: xstring_contents string_content  */
#line 6056 "parse.y"
                    {
                        (yyval.node) = literal_concat(p, (yyvsp[-1].node), (yyvsp[0].node), &(yyloc));
                    /*% ripper: xstring_add!($:1, $:2) %*/
                    }
#line 16800 "parse.c"
    break;

  case 667: /* regexp_contents: %empty  */
#line 6063 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: regexp_new! %*/
                    }
#line 16809 "parse.c"
    break;

  case 668: /* regexp_contents: regexp_contents string_content  */
#line 6068 "parse.y"
                    {
                        NODE *head = (yyvsp[-1].node), *tail = (yyvsp[0].node);
                        if (!head) {
                            (yyval.node) = tail;
                        }
                        else if (!tail) {
                            (yyval.node) = head;
                        }
                        else {
                            switch (nd_type(head)) {
                              case NODE_STR:
                                head = str2dstr(p, head);
                                break;
                              case NODE_DSTR:
                                break;
                              default:
                                head = list_append(p, NEW_DSTR(0, &(yyloc)), head);
                                break;
                            }
                            (yyval.node) = list_append(p, head, tail);
                        }
                    /*% ripper: regexp_add!($:1, $:2) %*/
                    }
#line 16837 "parse.c"
    break;

  case 670: /* @34: %empty  */
#line 6096 "parse.y"
                    {
                        /* need to backup p->lex.strterm so that a string literal `%&foo,#$&,bar&` can be parsed */
                        (yyval.strterm) = p->lex.strterm;
                        p->lex.strterm = 0;
                        SET_LEX_STATE(EXPR_BEG);
                    }
#line 16848 "parse.c"
    break;

  case 671: /* string_content: tSTRING_DVAR @34 string_dvar  */
#line 6103 "parse.y"
                    {
                        p->lex.strterm = (yyvsp[-1].strterm);
                        (yyval.node) = NEW_EVSTR((yyvsp[0].node), &(yyloc), &(yylsp[-2]), &NULL_LOC);
                        nd_set_line((yyval.node), (yylsp[0]).end_pos.lineno);
                    /*% ripper: string_dvar!($:3) %*/
                    }
#line 16859 "parse.c"
    break;

  case 672: /* @35: %empty  */
#line 6110 "parse.y"
                    {
                        CMDARG_PUSH(0);
                        COND_PUSH(0);
                        /* need to backup p->lex.strterm so that a string literal `%!foo,#{ !0 },bar!` can be parsed */
                        (yyval.strterm) = p->lex.strterm;
                        p->lex.strterm = 0;
                        SET_LEX_STATE(EXPR_BEG);
                    }
#line 16872 "parse.c"
    break;

  case 673: /* @36: %empty  */
#line 6118 "parse.y"
                    {
                        (yyval.num) = p->lex.brace_nest;
                        p->lex.brace_nest = 0;
                    }
#line 16881 "parse.c"
    break;

  case 674: /* @37: %empty  */
#line 6122 "parse.y"
                    {
                        (yyval.num) = p->heredoc_indent;
                        p->heredoc_indent = 0;
                    }
#line 16890 "parse.c"
    break;

  case 675: /* string_content: "'#{'" @35 @36 @37 compstmt_stmts string_dend  */
#line 6127 "parse.y"
                    {
                        COND_POP();
                        CMDARG_POP();
                        p->lex.strterm = (yyvsp[-4].strterm);
                        SET_LEX_STATE((yyvsp[-5].state));
                        p->lex.brace_nest = (yyvsp[-3].num);
                        p->heredoc_indent = (yyvsp[-2].num);
                        p->heredoc_line_indent = -1;
                        if ((yyvsp[-1].node)) nd_unset_fl_newline((yyvsp[-1].node));
                        (yyval.node) = new_evstr(p, (yyvsp[-1].node), &(yyloc), &(yylsp[-5]), &(yylsp[0]));
                    /*% ripper: string_embexpr!($:compstmt) %*/
                    }
#line 16907 "parse.c"
    break;

  case 678: /* string_dvar: nonlocal_var  */
#line 6146 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper: var_ref!($:1) %*/
                    }
#line 16916 "parse.c"
    break;

  case 682: /* ssym: "symbol literal" sym  */
#line 6158 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_END);
                        VALUE str = rb_id2str((yyvsp[0].id));
                        /*
                         * TODO:
                         *   set_yylval_noname sets invalid id to yylval.
                         *   This branch can be removed once yylval is changed to
                         *   hold lexed string.
                         */
                        if (!str) str = STR_NEW0();
                        (yyval.node) = NEW_SYM(str, &(yyloc));
                    /*% ripper: symbol_literal!(symbol!($:2)) %*/
                    }
#line 16934 "parse.c"
    break;

  case 685: /* dsym: "symbol literal" string_contents "terminator"  */
#line 6178 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_END);
                        (yyval.node) = dsym_node(p, (yyvsp[-1].node), &(yyloc));
                    /*% ripper: dyna_symbol!($:2) %*/
                    }
#line 16944 "parse.c"
    break;

  case 687: /* numeric: tUMINUS_NUM simple_numeric  */
#line 6187 "parse.y"
                    {
                        (yyval.node) = (yyvsp[0].node);
                        negate_lit(p, (yyval.node));
                    /*% ripper: unary!(ID2VAL(idUMinus), $:2) %*/
                    }
#line 16954 "parse.c"
    break;

  case 698: /* keyword_variable: "'nil'"  */
#line 6209 "parse.y"
                              {(yyval.id) = KWD2EID(nil, (yyvsp[0].id));}
#line 16960 "parse.c"
    break;

  case 699: /* keyword_variable: "'self'"  */
#line 6210 "parse.y"
                               {(yyval.id) = KWD2EID(self, (yyvsp[0].id));}
#line 16966 "parse.c"
    break;

  case 700: /* keyword_variable: "'true'"  */
#line 6211 "parse.y"
                               {(yyval.id) = KWD2EID(true, (yyvsp[0].id));}
#line 16972 "parse.c"
    break;

  case 701: /* keyword_variable: "'false'"  */
#line 6212 "parse.y"
                                {(yyval.id) = KWD2EID(false, (yyvsp[0].id));}
#line 16978 "parse.c"
    break;

  case 702: /* keyword_variable: "'__FILE__'"  */
#line 6213 "parse.y"
                                  {(yyval.id) = KWD2EID(_FILE__, (yyvsp[0].id));}
#line 16984 "parse.c"
    break;

  case 703: /* keyword_variable: "'__LINE__'"  */
#line 6214 "parse.y"
                                  {(yyval.id) = KWD2EID(_LINE__, (yyvsp[0].id));}
#line 16990 "parse.c"
    break;

  case 704: /* keyword_variable: "'__ENCODING__'"  */
#line 6215 "parse.y"
                                      {(yyval.id) = KWD2EID(_ENCODING__, (yyvsp[0].id));}
#line 16996 "parse.c"
    break;

  case 705: /* var_ref: user_variable  */
#line 6219 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                        if (ifdef_ripper(id_is_var(p, (yyvsp[0].id)), false)) {
                        /*% ripper: var_ref!($:1) %*/
                        }
                        else {
                        /*% ripper: vcall!($:1) %*/
                        }
                    }
#line 17010 "parse.c"
    break;

  case 706: /* var_ref: keyword_variable  */
#line 6229 "parse.y"
                    {
                        if (!((yyval.node) = gettable(p, (yyvsp[0].id), &(yyloc)))) (yyval.node) = NEW_ERROR(&(yyloc));
                    /*% ripper: var_ref!($:1) %*/
                    }
#line 17019 "parse.c"
    break;

  case 707: /* var_lhs: user_variable  */
#line 6236 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 17028 "parse.c"
    break;

  case 708: /* var_lhs: keyword_variable  */
#line 6236 "parse.y"
                    {
                    /*% ripper: var_field!($:1) %*/
                        (yyval.node) = assignable(p, (yyvsp[0].id), 0, &(yyloc));
                    }
#line 17037 "parse.c"
    break;

  case 711: /* $@38: %empty  */
#line 6247 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_BEG);
                        p->command_start = TRUE;
                    }
#line 17046 "parse.c"
    break;

  case 712: /* superclass: '<' $@38 expr_value term  */
#line 6252 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: $:3 %*/
                    }
#line 17055 "parse.c"
    break;

  case 715: /* f_opt_paren_args: none  */
#line 6261 "parse.y"
                    {
                        p->ctxt.in_argdef = 0;
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[-1]));
                        (yyval.node_args) = new_args(p, 0, 0, 0, 0, (yyval.node_args), &(yylsp[-1]));
                    /*% ripper: params!(Qnil, Qnil, Qnil, Qnil, Qnil, Qnil, Qnil) %*/
                    }
#line 17066 "parse.c"
    break;

  case 716: /* f_paren_args: '(' f_args rparen  */
#line 6270 "parse.y"
                    {
                        (yyval.node_args) = (yyvsp[-1].node_args);
                    /*% ripper: paren!($:2) %*/
                        SET_LEX_STATE(EXPR_BEG);
                        p->command_start = TRUE;
                        p->ctxt.in_argdef = 0;
                    }
#line 17078 "parse.c"
    break;

  case 718: /* @39: %empty  */
#line 6280 "parse.y"
                    {
                        (yyval.ctxt) = p->ctxt;
                        p->ctxt.in_kwarg = 1;
                        p->ctxt.in_argdef = 1;
                        SET_LEX_STATE(p->lex.state|EXPR_LABEL); /* force for args */
                    }
#line 17089 "parse.c"
    break;

  case 719: /* f_arglist: @39 f_args term  */
#line 6287 "parse.y"
                    {
                        p->ctxt.in_kwarg = (yyvsp[-2].ctxt).in_kwarg;
                        p->ctxt.in_argdef = 0;
                        (yyval.node_args) = (yyvsp[-1].node_args);
                        SET_LEX_STATE(EXPR_BEG);
                        p->command_start = TRUE;
                    /*% ripper: $:2 %*/
                    }
#line 17102 "parse.c"
    break;

  case 720: /* f_kw_arg_value: f_label arg_value  */
#line 3004 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_kw_arg) = new_kw_arg(p, assignable(p, (yyvsp[-1].id), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, $:value] %*/
                    }
#line 17112 "parse.c"
    break;

  case 721: /* f_kw_arg_value: f_label  */
#line 3010 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_kw_arg) = new_kw_arg(p, assignable(p, (yyvsp[0].id), NODE_SPECIAL_REQUIRED_KEYWORD, &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, 0] %*/
                    }
#line 17122 "parse.c"
    break;

  case 722: /* f_kwarg_arg_value: f_kw_arg_value  */
#line 3019 "parse.y"
                    {
                        (yyval.node_kw_arg) = (yyvsp[0].node_kw_arg);
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 17131 "parse.c"
    break;

  case 723: /* f_kwarg_arg_value: f_kwarg_arg_value ',' f_kw_arg_value  */
#line 3024 "parse.y"
                    {
                        (yyval.node_kw_arg) = kwd_append((yyvsp[-2].node_kw_arg), (yyvsp[0].node_kw_arg));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 17140 "parse.c"
    break;

  case 724: /* args_tail_basic_arg_value: f_kwarg_arg_value ',' f_kwrest opt_f_block_arg  */
#line 2927 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, (yyvsp[-3].node_kw_arg), (yyvsp[-1].id), (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [$:1, $:3, $:4] %*/
                    }
#line 17149 "parse.c"
    break;

  case 725: /* args_tail_basic_arg_value: f_kwarg_arg_value opt_f_block_arg  */
#line 2932 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, (yyvsp[-1].node_kw_arg), 0, (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [$:1, Qnil, $:2] %*/
                    }
#line 17158 "parse.c"
    break;

  case 726: /* args_tail_basic_arg_value: f_any_kwrest opt_f_block_arg  */
#line 2937 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, (yyvsp[-1].id), (yyvsp[0].id), &(yylsp[-1]));
                    /*% ripper: [Qnil, $:1, $:2] %*/
                    }
#line 17167 "parse.c"
    break;

  case 727: /* args_tail_basic_arg_value: f_block_arg  */
#line 2942 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, (yyvsp[0].id), &(yylsp[0]));
                    /*% ripper: [Qnil, Qnil, $:1] %*/
                    }
#line 17176 "parse.c"
    break;

  case 729: /* args_tail: args_forward  */
#line 6299 "parse.y"
                    {
                        ID fwd = (yyvsp[0].id);
                        if (lambda_beginning_p() ||
                            (p->lex.lpar_beg >= 0 && p->lex.lpar_beg+1 == p->lex.paren_nest)) {
                            yyerror0("unexpected ... in lambda argument");
                            fwd = 0;
                        }
                        else {
                            add_forwarding_args(p);
                        }
                        (yyval.node_args) = new_args_tail(p, 0, fwd, arg_FWD_BLOCK, &(yylsp[0]));
                        (yyval.node_args)->nd_ainfo.forwarding = 1;
                    /*% ripper: [Qnil, $:1, Qnil] %*/
                    }
#line 17195 "parse.c"
    break;

  case 730: /* f_opt_arg_value: f_arg_asgn f_eq arg_value  */
#line 2982 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node_opt_arg) = NEW_OPT_ARG(assignable(p, (yyvsp[-2].id), (yyvsp[0].node), &(yyloc)), &(yyloc));
                    /*% ripper: [$:$, $:3] %*/
                    }
#line 17205 "parse.c"
    break;

  case 731: /* f_opt_arg_arg_value: f_opt_arg_value  */
#line 2991 "parse.y"
                    {
                        (yyval.node_opt_arg) = (yyvsp[0].node_opt_arg);
                    /*% ripper: rb_ary_new3(1, $:1) %*/
                    }
#line 17214 "parse.c"
    break;

  case 732: /* f_opt_arg_arg_value: f_opt_arg_arg_value ',' f_opt_arg_value  */
#line 2996 "parse.y"
                    {
                        (yyval.node_opt_arg) = opt_arg_append((yyvsp[-2].node_opt_arg), (yyvsp[0].node_opt_arg));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 17223 "parse.c"
    break;

  case 733: /* opt_args_tail_args_tail: ',' args_tail  */
#line 3091 "parse.y"
                    {
                        (yyval.node_args) = (yyvsp[0].node_args);
                    /*% ripper: $:2 %*/
                    }
#line 17232 "parse.c"
    break;

  case 734: /* opt_args_tail_args_tail: %empty  */
#line 3096 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[0]));
                    /*% ripper: [Qnil, Qnil, Qnil] %*/
                    }
#line 17241 "parse.c"
    break;

  case 735: /* f_args: f_arg ',' f_opt_arg_arg_value ',' f_rest_arg opt_args_tail_args_tail  */
#line 6316 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), (yyvsp[-3].node_opt_arg), (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, $:5, Qnil, *$:6[0..2]) %*/
                    }
#line 17250 "parse.c"
    break;

  case 736: /* f_args: f_arg ',' f_opt_arg_arg_value ',' f_rest_arg ',' f_arg opt_args_tail_args_tail  */
#line 6321 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-7].node_args_aux), (yyvsp[-5].node_opt_arg), (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, $:5, $:7, *$:8[0..2]) %*/
                    }
#line 17259 "parse.c"
    break;

  case 737: /* f_args: f_arg ',' f_opt_arg_arg_value opt_args_tail_args_tail  */
#line 6326 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-3].node_args_aux), (yyvsp[-1].node_opt_arg), 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, Qnil, Qnil, *$:4[0..2]) %*/
                    }
#line 17268 "parse.c"
    break;

  case 738: /* f_args: f_arg ',' f_opt_arg_arg_value ',' f_arg opt_args_tail_args_tail  */
#line 6331 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), (yyvsp[-3].node_opt_arg), 0, (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, $:3, Qnil, $:5, *$:6[0..2]) %*/
                    }
#line 17277 "parse.c"
    break;

  case 739: /* f_args: f_arg ',' f_rest_arg opt_args_tail_args_tail  */
#line 6336 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-3].node_args_aux), 0, (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:3, Qnil, *$:4[0..2]) %*/
                    }
#line 17286 "parse.c"
    break;

  case 740: /* f_args: f_arg ',' f_rest_arg ',' f_arg opt_args_tail_args_tail  */
#line 6341 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-5].node_args_aux), 0, (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, $:3, $:5, *$:6[0..2]) %*/
                    }
#line 17295 "parse.c"
    break;

  case 741: /* f_args: f_arg opt_args_tail_args_tail  */
#line 6346 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, (yyvsp[-1].node_args_aux), 0, 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!($:1, Qnil, Qnil, Qnil, *$:2[0..2]) %*/
                    }
#line 17304 "parse.c"
    break;

  case 742: /* f_args: f_opt_arg_arg_value ',' f_rest_arg opt_args_tail_args_tail  */
#line 6351 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-3].node_opt_arg), (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, $:3, Qnil, *$:4[0..2]) %*/
                    }
#line 17313 "parse.c"
    break;

  case 743: /* f_args: f_opt_arg_arg_value ',' f_rest_arg ',' f_arg opt_args_tail_args_tail  */
#line 6356 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-5].node_opt_arg), (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, $:3, $:5, *$:6[0..2]) %*/
                    }
#line 17322 "parse.c"
    break;

  case 744: /* f_args: f_opt_arg_arg_value opt_args_tail_args_tail  */
#line 6361 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-1].node_opt_arg), 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, Qnil, Qnil, *$:2[0..2]) %*/
                    }
#line 17331 "parse.c"
    break;

  case 745: /* f_args: f_opt_arg_arg_value ',' f_arg opt_args_tail_args_tail  */
#line 6366 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, (yyvsp[-3].node_opt_arg), 0, (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, $:1, Qnil, $:3, *$:4[0..2]) %*/
                    }
#line 17340 "parse.c"
    break;

  case 746: /* f_args: f_rest_arg opt_args_tail_args_tail  */
#line 6371 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, (yyvsp[-1].id), 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, $:1, Qnil, *$:2[0..2]) %*/
                    }
#line 17349 "parse.c"
    break;

  case 747: /* f_args: f_rest_arg ',' f_arg opt_args_tail_args_tail  */
#line 6376 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, (yyvsp[-3].id), (yyvsp[-1].node_args_aux), (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, $:1, $:3, *$:4[0..2]) %*/
                    }
#line 17358 "parse.c"
    break;

  case 748: /* f_args: args_tail  */
#line 6381 "parse.y"
                    {
                        (yyval.node_args) = new_args(p, 0, 0, 0, 0, (yyvsp[0].node_args), &(yyloc));
                    /*% ripper: params!(Qnil, Qnil, Qnil, Qnil, *$:1[0..2]) %*/
                    }
#line 17367 "parse.c"
    break;

  case 749: /* f_args: %empty  */
#line 6386 "parse.y"
                    {
                        (yyval.node_args) = new_args_tail(p, 0, 0, 0, &(yylsp[0]));
                        (yyval.node_args) = new_args(p, 0, 0, 0, 0, (yyval.node_args), &(yylsp[0]));
                    /*% ripper: params!(Qnil, Qnil, Qnil, Qnil, Qnil, Qnil, Qnil) %*/
                    }
#line 17377 "parse.c"
    break;

  case 750: /* args_forward: "(..."  */
#line 6394 "parse.y"
                    {
                        (yyval.id) = idFWD_KWREST;
                    /*% ripper: args_forward! %*/
                    }
#line 17386 "parse.c"
    break;

  case 751: /* f_bad_arg: "constant"  */
#line 6401 "parse.y"
                    {
                        static const char mesg[] = "formal argument cannot be a constant";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.id) = 0;
                    /*% ripper[error]: param_error!(ERR_MESG(), $:1) %*/
                    }
#line 17399 "parse.c"
    break;

  case 752: /* f_bad_arg: "instance variable"  */
#line 6410 "parse.y"
                    {
                        static const char mesg[] = "formal argument cannot be an instance variable";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.id) = 0;
                    /*% ripper[error]: param_error!(ERR_MESG(), $:1) %*/
                    }
#line 17412 "parse.c"
    break;

  case 753: /* f_bad_arg: "global variable"  */
#line 6419 "parse.y"
                    {
                        static const char mesg[] = "formal argument cannot be a global variable";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.id) = 0;
                    /*% ripper[error]: param_error!(ERR_MESG(), $:1) %*/
                    }
#line 17425 "parse.c"
    break;

  case 754: /* f_bad_arg: "class variable"  */
#line 6428 "parse.y"
                    {
                        static const char mesg[] = "formal argument cannot be a class variable";
                    /*%%%*/
                        yyerror1(&(yylsp[0]), mesg);
                    /*% %*/
                        (yyval.id) = 0;
                    /*% ripper[error]: param_error!(ERR_MESG(), $:1) %*/
                    }
#line 17438 "parse.c"
    break;

  case 756: /* f_norm_arg: "local variable or method"  */
#line 6440 "parse.y"
                    {
                        VALUE e = formal_argument_error(p, (yyval.id) = (yyvsp[0].id));
                        if (e) {
                            /*% ripper[error]: param_error!(?e, $:1) %*/
                        }
                        p->max_numparam = ORDINAL_PARAM;
                    }
#line 17450 "parse.c"
    break;

  case 757: /* f_arg_asgn: f_norm_arg  */
#line 6450 "parse.y"
                    {
                        arg_var(p, (yyvsp[0].id));
                        (yyval.id) = (yyvsp[0].id);
                    }
#line 17459 "parse.c"
    break;

  case 758: /* f_arg_item: f_arg_asgn  */
#line 6457 "parse.y"
                    {
                        (yyval.node_args_aux) = NEW_ARGS_AUX((yyvsp[0].id), 1, &NULL_LOC);
                    /*% ripper: $:1 %*/
                    }
#line 17468 "parse.c"
    break;

  case 759: /* f_arg_item: "(" f_margs rparen  */
#line 6462 "parse.y"
                    {
                        ID tid = internal_id(p);
                        YYLTYPE loc;
                        loc.beg_pos = (yylsp[-1]).beg_pos;
                        loc.end_pos = (yylsp[-1]).beg_pos;
                        arg_var(p, tid);
                        if (dyna_in_block(p)) {
                            (yyvsp[-1].node_masgn)->nd_value = NEW_DVAR(tid, &loc);
                        }
                        else {
                            (yyvsp[-1].node_masgn)->nd_value = NEW_LVAR(tid, &loc);
                        }
                        (yyval.node_args_aux) = NEW_ARGS_AUX(tid, 1, &NULL_LOC);
                        (yyval.node_args_aux)->nd_next = (NODE *)(yyvsp[-1].node_masgn);
                    /*% ripper: mlhs_paren!($:2) %*/
                    }
#line 17489 "parse.c"
    break;

  case 761: /* f_arg: f_arg ',' f_arg_item  */
#line 6483 "parse.y"
                    {
                        (yyval.node_args_aux) = (yyvsp[-2].node_args_aux);
                        (yyval.node_args_aux)->nd_plen++;
                        (yyval.node_args_aux)->nd_next = block_append(p, (yyval.node_args_aux)->nd_next, (yyvsp[0].node_args_aux)->nd_next);
                        rb_discard_node(p, (NODE *)(yyvsp[0].node_args_aux));
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 17501 "parse.c"
    break;

  case 762: /* f_label: "label"  */
#line 6494 "parse.y"
                    {
                        VALUE e = formal_argument_error(p, (yyval.id) = (yyvsp[0].id));
                        if (e) {
                            (yyval.id) = 0;
                            /*% ripper[error]: param_error!(?e, $:1) %*/
                        }
                        /*
                         * Workaround for Prism::ParseTest#test_filepath for
                         * "unparser/corpus/literal/def.txt"
                         *
                         * See the discussion on https://github.com/ruby/ruby/pull/9923
                         */
                        arg_var(p, ifdef_ripper(0, (yyvsp[0].id)));
                        /*% ripper: $:1 %*/
                        p->max_numparam = ORDINAL_PARAM;
                        p->ctxt.in_argdef = 0;
                    }
#line 17523 "parse.c"
    break;

  case 765: /* f_no_kwarg: p_kwnorest  */
#line 6518 "parse.y"
                    {
                    /*% ripper: nokw_param!(Qnil) %*/
                    }
#line 17531 "parse.c"
    break;

  case 766: /* f_kwrest: kwrest_mark "local variable or method"  */
#line 6524 "parse.y"
                    {
                        arg_var(p, shadowing_lvar(p, (yyvsp[0].id)));
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: kwrest_param!($:2) %*/
                    }
#line 17541 "parse.c"
    break;

  case 767: /* f_kwrest: kwrest_mark  */
#line 6530 "parse.y"
                    {
                        arg_var(p, idFWD_KWREST);
                        (yyval.id) = idFWD_KWREST;
                    /*% ripper: kwrest_param!(Qnil) %*/
                    }
#line 17551 "parse.c"
    break;

  case 770: /* f_rest_arg: restarg_mark "local variable or method"  */
#line 6542 "parse.y"
                    {
                        arg_var(p, shadowing_lvar(p, (yyvsp[0].id)));
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: rest_param!($:2) %*/
                    }
#line 17561 "parse.c"
    break;

  case 771: /* f_rest_arg: restarg_mark  */
#line 6548 "parse.y"
                    {
                        arg_var(p, idFWD_REST);
                        (yyval.id) = idFWD_REST;
                    /*% ripper: rest_param!(Qnil) %*/
                    }
#line 17571 "parse.c"
    break;

  case 774: /* f_block_arg: blkarg_mark "local variable or method"  */
#line 6560 "parse.y"
                    {
                        arg_var(p, shadowing_lvar(p, (yyvsp[0].id)));
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: blockarg!($:2) %*/
                    }
#line 17581 "parse.c"
    break;

  case 775: /* f_block_arg: blkarg_mark  */
#line 6566 "parse.y"
                    {
                        arg_var(p, idFWD_BLOCK);
                        (yyval.id) = idFWD_BLOCK;
                    /*% ripper: blockarg!(Qnil) %*/
                    }
#line 17591 "parse.c"
    break;

  case 776: /* opt_f_block_arg: ',' f_block_arg  */
#line 6574 "parse.y"
                    {
                        (yyval.id) = (yyvsp[0].id);
                    /*% ripper: $:2 %*/
                    }
#line 17600 "parse.c"
    break;

  case 778: /* value_expr_singleton_expr: singleton_expr  */
#line 3145 "parse.y"
                    {
                        value_expr(p, (yyvsp[0].node));
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 17609 "parse.c"
    break;

  case 779: /* singleton: value_expr_singleton_expr  */
#line 6583 "parse.y"
                    {
                        NODE *expr = last_expr_node((yyvsp[0].node));
                        switch (nd_type(expr)) {
                          case NODE_STR:
                          case NODE_DSTR:
                          case NODE_XSTR:
                          case NODE_DXSTR:
                          case NODE_REGX:
                          case NODE_DREGX:
                          case NODE_SYM:
                          case NODE_LINE:
                          case NODE_FILE:
                          case NODE_ENCODING:
                          case NODE_INTEGER:
                          case NODE_FLOAT:
                          case NODE_RATIONAL:
                          case NODE_IMAGINARY:
                          case NODE_DSYM:
                          case NODE_LIST:
                          case NODE_ZLIST:
                            yyerror1(&expr->nd_loc, "can't define singleton method for literals");
                            break;
                          default:
                            break;
                        }
                        (yyval.node) = (yyvsp[0].node);
                    }
#line 17641 "parse.c"
    break;

  case 781: /* $@40: %empty  */
#line 6614 "parse.y"
                    {
                        SET_LEX_STATE(EXPR_BEG);
                        p->ctxt.in_argdef = 0;
                    }
#line 17650 "parse.c"
    break;

  case 782: /* singleton_expr: '(' $@40 expr rparen  */
#line 6619 "parse.y"
                    {
                        p->ctxt.in_argdef = 1;
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: paren!($:3) %*/
                    }
#line 17660 "parse.c"
    break;

  case 784: /* assoc_list: assocs trailer  */
#line 6628 "parse.y"
                    {
                        (yyval.node) = (yyvsp[-1].node);
                    /*% ripper: assoclist_from_args!($:1) %*/
                    }
#line 17669 "parse.c"
    break;

  case 786: /* assocs: assocs ',' assoc  */
#line 6637 "parse.y"
                    {
                        NODE *assocs = (yyvsp[-2].node);
                        NODE *tail = (yyvsp[0].node);
                        if (!assocs) {
                            assocs = tail;
                        }
                        else if (tail) {
                            if (RNODE_LIST(assocs)->nd_head) {
                                NODE *n = RNODE_LIST(tail)->nd_next;
                                if (!RNODE_LIST(tail)->nd_head && nd_type_p(n, NODE_LIST) &&
                                    nd_type_p((n = RNODE_LIST(n)->nd_head), NODE_HASH)) {
                                    /* DSTAR */
                                    tail = RNODE_HASH(n)->nd_head;
                                }
                            }
                            if (tail) {
                                assocs = list_concat(assocs, tail);
                            }
                        }
                        (yyval.node) = assocs;
                    /*% ripper: rb_ary_push($:1, $:3) %*/
                    }
#line 17696 "parse.c"
    break;

  case 787: /* assoc: arg_value "=>" arg_value  */
#line 6662 "parse.y"
                    {
                        (yyval.node) = list_append(p, NEW_LIST((yyvsp[-2].node), &(yyloc)), (yyvsp[0].node));
                    /*% ripper: assoc_new!($:1, $:3) %*/
                    }
#line 17705 "parse.c"
    break;

  case 788: /* assoc: "label" arg_value  */
#line 6667 "parse.y"
                    {
                        (yyval.node) = list_append(p, NEW_LIST(NEW_SYM(rb_id2str((yyvsp[-1].id)), &(yylsp[-1])), &(yyloc)), (yyvsp[0].node));
                    /*% ripper: assoc_new!($:1, $:2) %*/
                    }
#line 17714 "parse.c"
    break;

  case 789: /* assoc: "label"  */
#line 6672 "parse.y"
                    {
                        NODE *val = gettable(p, (yyvsp[0].id), &(yyloc));
                        if (!val) val = NEW_ERROR(&(yyloc));
                        (yyval.node) = list_append(p, NEW_LIST(NEW_SYM(rb_id2str((yyvsp[0].id)), &(yylsp[0])), &(yyloc)), val);
                    /*% ripper: assoc_new!($:1, Qnil) %*/
                    }
#line 17725 "parse.c"
    break;

  case 790: /* assoc: "string literal" string_contents tLABEL_END arg_value  */
#line 6679 "parse.y"
                    {
                        YYLTYPE loc = code_loc_gen(&(yylsp[-3]), &(yylsp[-1]));
                        (yyval.node) = list_append(p, NEW_LIST(dsym_node(p, (yyvsp[-2].node), &loc), &loc), (yyvsp[0].node));
                    /*% ripper: assoc_new!(dyna_symbol!($:2), $:4) %*/
                    }
#line 17735 "parse.c"
    break;

  case 791: /* assoc: "**arg" arg_value  */
#line 6685 "parse.y"
                    {
                        (yyval.node) = list_append(p, NEW_LIST(0, &(yyloc)), (yyvsp[0].node));
                    /*% ripper: assoc_splat!($:2) %*/
                    }
#line 17744 "parse.c"
    break;

  case 792: /* assoc: "**arg"  */
#line 6690 "parse.y"
                    {
                        forwarding_arg_check(p, idFWD_KWREST, idFWD_ALL, "keyword rest");
                        (yyval.node) = list_append(p, NEW_LIST(0, &(yyloc)),
                                         NEW_LVAR(idFWD_KWREST, &(yyloc)));
                    /*% ripper: assoc_splat!(Qnil) %*/
                    }
#line 17755 "parse.c"
    break;

  case 811: /* term: ';'  */
#line 6737 "parse.y"
                    {
                        yyerrok;
                        token_flush(p);
                        if (p->ctxt.in_defined) {
                            p->ctxt.has_trailing_semicolon = 1;
                        }
                    }
#line 17767 "parse.c"
    break;

  case 812: /* term: '\n'  */
#line 6745 "parse.y"
                    {
                        (yyloc).end_pos = (yyloc).beg_pos;
                        token_flush(p);
                    }
#line 17776 "parse.c"
    break;

  case 814: /* terms: terms ';'  */
#line 6752 "parse.y"
                            {yyerrok;}
#line 17782 "parse.c"
    break;

  case 815: /* none: %empty  */
#line 6756 "parse.y"
                    {
                        (yyval.node) = 0;
                    /*% ripper: Qnil %*/
                    }
#line 17791 "parse.c"
    break;


#line 17795 "parse.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc, p);

  YYPOPSTACK (yylen);
        /* %after-reduce function. */
#line 2666 "parse.y"
        {after_reduce(yylen, p);}
#line 17816 "parse.c"

  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken, &yylloc};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx, p);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx, p);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (&yylloc, p, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= END_OF_INPUT)
        {
          /* Return failure if at end of input.  */
          if (yychar == END_OF_INPUT)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, p);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
        /* %after-pop-stack function. */
#line 2668 "parse.y"
        {after_pop_stack(yylen, p);}
#line 17922 "parse.c"

  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp, p);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, p);
      YYPOPSTACK (1);
        /* %after-pop-stack function. */
#line 2668 "parse.y"
        {after_pop_stack(1, p);}
#line 17962 "parse.c"

      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp, p);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp, p);
        /* %after-shift-error-token code. */
#line 2667 "parse.y"
        {after_shift_error_token(p);}
#line 17981 "parse.c"


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, p, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, p);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp, p);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, p);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 6761 "parse.y"

# undef p
# undef yylex
# undef yylval
# define yylval  (*p->lval)

static int regx_options(struct parser_params*);
static int tokadd_string(struct parser_params*,int,int,int,long*,rb_encoding**,rb_encoding**);
static void tokaddmbc(struct parser_params *p, int c, rb_encoding *enc);
static enum yytokentype parse_string(struct parser_params*,rb_strterm_literal_t*);
static enum yytokentype here_document(struct parser_params*,rb_strterm_heredoc_t*);

#define set_parser_s_value(x) (ifdef_ripper(p->s_value = (x), (void)0))

# define set_yylval_node(x) {				\
  YYLTYPE _cur_loc;					\
  rb_parser_set_location(p, &_cur_loc);			\
  yylval.node = (x);					\
  set_parser_s_value(STR_NEW(p->lex.ptok, p->lex.pcur-p->lex.ptok)); \
}
# define set_yylval_str(x) \
do { \
  set_yylval_node(NEW_STR(x, &_cur_loc)); \
  set_parser_s_value(rb_str_new_mutable_parser_string(x)); \
} while(0)
# define set_yylval_num(x) { \
  yylval.num = (x); \
  set_parser_s_value(x); \
}
# define set_yylval_id(x) (yylval.id = (x))
# define set_yylval_name(x) { \
  (yylval.id = (x)); \
  set_parser_s_value(ID2SYM(x)); \
}
# define yylval_id() (yylval.id)

#define set_yylval_noname() set_yylval_id(keyword_nil)
#define has_delayed_token(p) (p->delayed.token != NULL)

#ifndef RIPPER
#define literal_flush(p, ptr) ((p)->lex.ptok = (ptr))
#define dispatch_scan_event(p, t) parser_dispatch_scan_event(p, t, __LINE__)

static bool
parser_has_token(struct parser_params *p)
{
    const char *const pcur = p->lex.pcur;
    const char *const ptok = p->lex.ptok;
    if (p->keep_tokens && (pcur < ptok)) {
        rb_bug("lex.pcur < lex.ptok. (line: %d) %"PRIdPTRDIFF"|%"PRIdPTRDIFF"|%"PRIdPTRDIFF"",
               p->ruby_sourceline, ptok - p->lex.pbeg, pcur - ptok, p->lex.pend - pcur);
    }
    return pcur > ptok;
}

static const char *
escaped_char(int c)
{
    switch (c) {
      case '"': return "\\\"";
      case '\\': return "\\\\";
      case '\0': return "\\0";
      case '\n': return "\\n";
      case '\r': return "\\r";
      case '\t': return "\\t";
      case '\f': return "\\f";
      case '\013': return "\\v";
      case '\010': return "\\b";
      case '\007': return "\\a";
      case '\033': return "\\e";
      case '\x7f': return "\\c?";
    }
    return NULL;
}

static rb_parser_string_t *
rb_parser_str_escape(struct parser_params *p, rb_parser_string_t *str)
{
    rb_encoding *enc = p->enc;
    const char *ptr = str->ptr;
    const char *pend = ptr + str->len;
    const char *prev = ptr;
    char charbuf[5] = {'\\', 'x', 0, 0, 0};
    rb_parser_string_t * result = rb_parser_string_new(p, 0, 0);

    while (ptr < pend) {
        unsigned int c;
        const char *cc;
        int n = rb_enc_precise_mbclen(ptr, pend, enc);
        if (!MBCLEN_CHARFOUND_P(n)) {
            if (ptr > prev) parser_str_cat(result, prev, ptr - prev);
            n = rb_enc_mbminlen(enc);
            if (pend < ptr + n)
                n = (int)(pend - ptr);
            while (n--) {
                c = *ptr & 0xf0 >> 4;
                charbuf[2] = (c < 10) ? '0' + c : 'A' + c - 10;
                c = *ptr & 0x0f;
                charbuf[3] = (c < 10) ? '0' + c : 'A' + c - 10;
                parser_str_cat(result, charbuf, 4);
                prev = ++ptr;
            }
            continue;
        }
        n = MBCLEN_CHARFOUND_LEN(n);
        c = rb_enc_mbc_to_codepoint(ptr, pend, enc);
        ptr += n;
        cc = escaped_char(c);
        if (cc) {
            if (ptr - n > prev) parser_str_cat(result, prev, ptr - n - prev);
            parser_str_cat_cstr(result, cc);
            prev = ptr;
        }
        else if (rb_enc_isascii(c, enc) && ISPRINT(c)) {
        }
        else {
            if (ptr - n > prev) {
                parser_str_cat(result, prev, ptr - n - prev);
                prev = ptr - n;
            }
            parser_str_cat(result, prev, ptr - prev);
            prev = ptr;
        }
    }
    if (ptr > prev) parser_str_cat(result, prev, ptr - prev);

    return result;
}

static void
parser_append_tokens(struct parser_params *p, rb_parser_string_t *str, enum yytokentype t, int line)
{
    rb_parser_ast_token_t *token = xcalloc(1, sizeof(rb_parser_ast_token_t));
    token->id = p->token_id;
    token->type_name = parser_token2char(p, t);
    token->str = str;
    token->loc.beg_pos = p->yylloc->beg_pos;
    token->loc.end_pos = p->yylloc->end_pos;
    rb_parser_ary_push_ast_token(p, p->tokens, token);
    p->token_id++;

    if (p->debug) {
        rb_parser_string_t *str_escaped = rb_parser_str_escape(p, str);
        rb_parser_printf(p, "Append tokens (line: %d) [%d, :%s, \"%s\", [%d, %d, %d, %d]]\n",
                            line, token->id, token->type_name, str_escaped->ptr,
                            token->loc.beg_pos.lineno, token->loc.beg_pos.column,
                            token->loc.end_pos.lineno, token->loc.end_pos.column);
        rb_parser_string_free(p, str_escaped);
    }
}

static void
parser_dispatch_scan_event(struct parser_params *p, enum yytokentype t, int line)
{
    debug_token_line(p, "parser_dispatch_scan_event", line);

    if (!parser_has_token(p)) return;

    RUBY_SET_YYLLOC(*p->yylloc);

    if (p->keep_tokens) {
        rb_parser_string_t *str = rb_parser_encoding_string_new(p, p->lex.ptok, p->lex.pcur - p->lex.ptok, p->enc);
        parser_append_tokens(p, str, t, line);
    }

    token_flush(p);
}

#define dispatch_delayed_token(p, t) parser_dispatch_delayed_token(p, t, __LINE__)
static void
parser_dispatch_delayed_token(struct parser_params *p, enum yytokentype t, int line)
{
    debug_token_line(p, "parser_dispatch_delayed_token", line);

    if (!has_delayed_token(p)) return;

    RUBY_SET_YYLLOC_OF_DELAYED_TOKEN(*p->yylloc);

    if (p->keep_tokens) {
        /* p->delayed.token is freed by rb_parser_tokens_free */
        parser_append_tokens(p, p->delayed.token, t, line);
    }
    else {
        rb_parser_string_free(p, p->delayed.token);
    }

    p->delayed.token = NULL;
}
#else
#define literal_flush(p, ptr) ((void)(ptr))

static int
ripper_has_scan_event(struct parser_params *p)
{
    if (p->lex.pcur < p->lex.ptok) rb_raise(rb_eRuntimeError, "lex.pcur < lex.ptok");
    return p->lex.pcur > p->lex.ptok;
}

static VALUE
ripper_scan_event_val(struct parser_params *p, enum yytokentype t)
{
    VALUE str = STR_NEW(p->lex.ptok, p->lex.pcur - p->lex.ptok);
    VALUE rval = ripper_dispatch1(p, ripper_token2eventid(t), str);
    RUBY_SET_YYLLOC(*p->yylloc);
    token_flush(p);
    return rval;
}

static void
ripper_dispatch_scan_event(struct parser_params *p, enum yytokentype t)
{
    if (!ripper_has_scan_event(p)) return;

    set_parser_s_value(ripper_scan_event_val(p, t));
}
#define dispatch_scan_event(p, t) ripper_dispatch_scan_event(p, t)

static void
ripper_dispatch_delayed_token(struct parser_params *p, enum yytokentype t)
{
    /* save and adjust the location to delayed token for callbacks */
    int saved_line = p->ruby_sourceline;
    const char *saved_tokp = p->lex.ptok;
    VALUE s_value, str;

    if (!has_delayed_token(p)) return;
    p->ruby_sourceline = p->delayed.beg_line;
    p->lex.ptok = p->lex.pbeg + p->delayed.beg_col;
    str = rb_str_new_mutable_parser_string(p->delayed.token);
    rb_parser_string_free(p, p->delayed.token);
    s_value = ripper_dispatch1(p, ripper_token2eventid(t), str);
    set_parser_s_value(s_value);
    p->delayed.token = NULL;
    p->ruby_sourceline = saved_line;
    p->lex.ptok = saved_tokp;
}
#define dispatch_delayed_token(p, t) ripper_dispatch_delayed_token(p, t)
#endif /* RIPPER */

static inline int
is_identchar(struct parser_params *p, const char *ptr, const char *MAYBE_UNUSED(ptr_end), rb_encoding *enc)
{
    return rb_enc_isalnum((unsigned char)*ptr, enc) || *ptr == '_' || !ISASCII(*ptr);
}

static inline bool
peek_word_at(struct parser_params *p, const char *str, size_t len, int at)
{
    const char *ptr = p->lex.pcur + at;
    if (lex_eol_ptr_n_p(p, ptr, len-1)) return false;
    if (memcmp(ptr, str, len)) return false;
    if (lex_eol_ptr_n_p(p, ptr, len)) return true;
    return !is_identchar(p, ptr+len, p->lex.pend, p->enc);
}

static inline int
parser_is_identchar(struct parser_params *p)
{
    return !(p)->eofp && is_identchar(p, p->lex.pcur-1, p->lex.pend, p->enc);
}

static inline int
parser_isascii(struct parser_params *p)
{
    return ISASCII(*(p->lex.pcur-1));
}

static void
token_info_setup(token_info *ptinfo, const char *ptr, const rb_code_location_t *loc)
{
    int column = 1, nonspc = 0, i;
    for (i = 0; i < loc->beg_pos.column; i++, ptr++) {
        if (*ptr == '\t') {
            column = (((column - 1) / TAB_WIDTH) + 1) * TAB_WIDTH;
        }
        column++;
        if (*ptr != ' ' && *ptr != '\t') {
            nonspc = 1;
        }
    }

    ptinfo->beg = loc->beg_pos;
    ptinfo->indent = column;
    ptinfo->nonspc = nonspc;
}

static void
token_info_push(struct parser_params *p, const char *token, const rb_code_location_t *loc)
{
    token_info *ptinfo;

    if (!p->token_info_enabled) return;
    ptinfo = ALLOC(token_info);
    ptinfo->token = token;
    ptinfo->next = p->token_info;
    token_info_setup(ptinfo, p->lex.pbeg, loc);

    p->token_info = ptinfo;
}

static void
token_info_pop(struct parser_params *p, const char *token, const rb_code_location_t *loc)
{
    token_info *ptinfo_beg = p->token_info;

    if (!ptinfo_beg) return;

    /* indentation check of matched keywords (begin..end, if..end, etc.) */
    token_info_warn(p, token, ptinfo_beg, 1, loc);

    p->token_info = ptinfo_beg->next;
    ruby_sized_xfree(ptinfo_beg, sizeof(*ptinfo_beg));
}

static void
token_info_drop(struct parser_params *p, const char *token, rb_code_position_t beg_pos)
{
    token_info *ptinfo_beg = p->token_info;

    if (!ptinfo_beg) return;
    p->token_info = ptinfo_beg->next;

    if (ptinfo_beg->beg.lineno != beg_pos.lineno ||
        ptinfo_beg->beg.column != beg_pos.column ||
        strcmp(ptinfo_beg->token, token)) {
        compile_error(p, "token position mismatch: %d:%d:%s expected but %d:%d:%s",
                      beg_pos.lineno, beg_pos.column, token,
                      ptinfo_beg->beg.lineno, ptinfo_beg->beg.column,
                      ptinfo_beg->token);
    }

    ruby_sized_xfree(ptinfo_beg, sizeof(*ptinfo_beg));
}

static void
token_info_warn(struct parser_params *p, const char *token, token_info *ptinfo_beg, int same, const rb_code_location_t *loc)
{
    token_info ptinfo_end_body, *ptinfo_end = &ptinfo_end_body;
    if (!p->token_info_enabled) return;
    if (!ptinfo_beg) return;
    token_info_setup(ptinfo_end, p->lex.pbeg, loc);
    if (ptinfo_beg->beg.lineno == ptinfo_end->beg.lineno) return; /* ignore one-line block */
    if (ptinfo_beg->nonspc || ptinfo_end->nonspc) return; /* ignore keyword in the middle of a line */
    if (ptinfo_beg->indent == ptinfo_end->indent) return; /* the indents are matched */
    if (!same && ptinfo_beg->indent < ptinfo_end->indent) return;
    rb_warn3L(ptinfo_end->beg.lineno,
              "mismatched indentations at '%s' with '%s' at %d",
              WARN_S(token), WARN_S(ptinfo_beg->token), WARN_I(ptinfo_beg->beg.lineno));
}

static int
parser_precise_mbclen(struct parser_params *p, const char *ptr)
{
    int len = rb_enc_precise_mbclen(ptr, p->lex.pend, p->enc);
    if (!MBCLEN_CHARFOUND_P(len)) {
        compile_error(p, "invalid multibyte char (%s)", rb_enc_name(p->enc));
        return -1;
    }
    return len;
}

#ifndef RIPPER
static inline void
parser_show_error_line(struct parser_params *p, const YYLTYPE *yylloc)
{
    rb_parser_string_t *str;
    int lineno = p->ruby_sourceline;
    if (!yylloc) {
        return;
    }
    else if (yylloc->beg_pos.lineno == lineno) {
        str = p->lex.lastline;
    }
    else {
        return;
    }
    ruby_show_error_line(p, p->error_buffer, yylloc, lineno, str);
}

static int
parser_yyerror(struct parser_params *p, const rb_code_location_t *yylloc, const char *msg)
{
#if 0
    YYLTYPE current;

    if (!yylloc) {
        yylloc = RUBY_SET_YYLLOC(current);
    }
    else if ((p->ruby_sourceline != yylloc->beg_pos.lineno &&
              p->ruby_sourceline != yylloc->end_pos.lineno)) {
        yylloc = 0;
    }
#endif
    parser_compile_error(p, yylloc, "%s", msg);
    parser_show_error_line(p, yylloc);
    return 0;
}

static int
parser_yyerror0(struct parser_params *p, const char *msg)
{
    YYLTYPE current;
    return parser_yyerror(p, RUBY_SET_YYLLOC(current), msg);
}

void
ruby_show_error_line(struct parser_params *p, VALUE errbuf, const YYLTYPE *yylloc, int lineno, rb_parser_string_t *str)
{
    VALUE mesg;
    const int max_line_margin = 30;
    const char *ptr, *ptr_end, *pt, *pb;
    const char *pre = "", *post = "", *pend;
    const char *code = "", *caret = "";
    const char *lim;
    const char *const pbeg = PARSER_STRING_PTR(str);
    char *buf;
    long len;
    int i;

    if (!yylloc) return;
    pend = rb_parser_string_end(str);
    if (pend > pbeg && pend[-1] == '\n') {
        if (--pend > pbeg && pend[-1] == '\r') --pend;
    }

    pt = pend;
    if (lineno == yylloc->end_pos.lineno &&
        (pend - pbeg) > yylloc->end_pos.column) {
        pt = pbeg + yylloc->end_pos.column;
    }

    ptr = ptr_end = pt;
    lim = ptr - pbeg > max_line_margin ? ptr - max_line_margin : pbeg;
    while ((lim < ptr) && (*(ptr-1) != '\n')) ptr--;

    lim = pend - ptr_end > max_line_margin ? ptr_end + max_line_margin : pend;
    while ((ptr_end < lim) && (*ptr_end != '\n') && (*ptr_end != '\r')) ptr_end++;

    len = ptr_end - ptr;
    if (len > 4) {
        if (ptr > pbeg) {
            ptr = rb_enc_prev_char(pbeg, ptr, pt, rb_parser_str_get_encoding(str));
            if (ptr > pbeg) pre = "...";
        }
        if (ptr_end < pend) {
            ptr_end = rb_enc_prev_char(pt, ptr_end, pend, rb_parser_str_get_encoding(str));
            if (ptr_end < pend) post = "...";
        }
    }
    pb = pbeg;
    if (lineno == yylloc->beg_pos.lineno) {
        pb += yylloc->beg_pos.column;
        if (pb > pt) pb = pt;
    }
    if (pb < ptr) pb = ptr;
    if (len <= 4 && yylloc->beg_pos.lineno == yylloc->end_pos.lineno) {
        return;
    }
    if (RTEST(errbuf)) {
        mesg = rb_attr_get(errbuf, idMesg);
        if (char_at_end(p, mesg, '\n') != '\n')
            rb_str_cat_cstr(mesg, "\n");
    }
    else {
        mesg = rb_enc_str_new(0, 0, rb_parser_str_get_encoding(str));
    }
    if (!errbuf && rb_stderr_tty_p()) {
#define CSI_BEGIN "\033["
#define CSI_SGR "m"
        rb_str_catf(mesg,
                    CSI_BEGIN""CSI_SGR"%s" /* pre */
                    CSI_BEGIN"1"CSI_SGR"%.*s"
                    CSI_BEGIN"1;4"CSI_SGR"%.*s"
                    CSI_BEGIN";1"CSI_SGR"%.*s"
                    CSI_BEGIN""CSI_SGR"%s" /* post */
                    "\n",
                    pre,
                    (int)(pb - ptr), ptr,
                    (int)(pt - pb), pb,
                    (int)(ptr_end - pt), pt,
                    post);
    }
    else {
        char *p2;

        len = ptr_end - ptr;
        lim = pt < pend ? pt : pend;
        i = (int)(lim - ptr);
        buf = ALLOCA_N(char, i+2);
        code = ptr;
        caret = p2 = buf;
        if (ptr <= pb) {
            while (ptr < pb) {
                *p2++ = *ptr++ == '\t' ? '\t' : ' ';
            }
            *p2++ = '^';
            ptr++;
        }
        if (lim > ptr) {
            memset(p2, '~', (lim - ptr));
            p2 += (lim - ptr);
        }
        *p2 = '\0';
        rb_str_catf(mesg, "%s%.*s%s\n""%s%s\n",
                    pre, (int)len, code, post,
                    pre, caret);
    }
    if (!errbuf) rb_write_error_str(mesg);
}
#else

static int
parser_yyerror(struct parser_params *p, const YYLTYPE *yylloc, const char *msg)
{
    const char *pcur = 0, *ptok = 0;
    if (p->ruby_sourceline == yylloc->beg_pos.lineno &&
        p->ruby_sourceline == yylloc->end_pos.lineno) {
        pcur = p->lex.pcur;
        ptok = p->lex.ptok;
        p->lex.ptok = p->lex.pbeg + yylloc->beg_pos.column;
        p->lex.pcur = p->lex.pbeg + yylloc->end_pos.column;
    }
    parser_yyerror0(p, msg);
    if (pcur) {
        p->lex.ptok = ptok;
        p->lex.pcur = pcur;
    }
    return 0;
}

static int
parser_yyerror0(struct parser_params *p, const char *msg)
{
    dispatch1(parse_error, STR_NEW2(msg));
    ripper_error(p);
    return 0;
}

static inline void
parser_show_error_line(struct parser_params *p, const YYLTYPE *yylloc)
{
}
#endif /* !RIPPER */

static int
vtable_size(const struct vtable *tbl)
{
    if (!DVARS_TERMINAL_P(tbl)) {
        return tbl->pos;
    }
    else {
        return 0;
    }
}

static struct vtable *
vtable_alloc_gen(struct parser_params *p, int line, struct vtable *prev)
{
    struct vtable *tbl = ALLOC(struct vtable);
    tbl->pos = 0;
    tbl->capa = 8;
    tbl->tbl = ALLOC_N(ID, tbl->capa);
    tbl->prev = prev;
#ifndef RIPPER
    if (p->debug) {
        rb_parser_printf(p, "vtable_alloc:%d: %p\n", line, (void *)tbl);
    }
#endif
    return tbl;
}
#define vtable_alloc(prev) vtable_alloc_gen(p, __LINE__, prev)

static void
vtable_free_gen(struct parser_params *p, int line, const char *name,
                struct vtable *tbl)
{
#ifndef RIPPER
    if (p->debug) {
        rb_parser_printf(p, "vtable_free:%d: %s(%p)\n", line, name, (void *)tbl);
    }
#endif
    if (!DVARS_TERMINAL_P(tbl)) {
        if (tbl->tbl) {
            ruby_sized_xfree(tbl->tbl, tbl->capa * sizeof(ID));
        }
        ruby_sized_xfree(tbl, sizeof(*tbl));
    }
}
#define vtable_free(tbl) vtable_free_gen(p, __LINE__, #tbl, tbl)

static void
vtable_add_gen(struct parser_params *p, int line, const char *name,
               struct vtable *tbl, ID id)
{
#ifndef RIPPER
    if (p->debug) {
        rb_parser_printf(p, "vtable_add:%d: %s(%p), %s\n",
                         line, name, (void *)tbl, rb_id2name(id));
    }
#endif
    if (DVARS_TERMINAL_P(tbl)) {
        rb_parser_fatal(p, "vtable_add: vtable is not allocated (%p)", (void *)tbl);
        return;
    }
    if (tbl->pos == tbl->capa) {
        tbl->capa = tbl->capa * 2;
        SIZED_REALLOC_N(tbl->tbl, ID, tbl->capa, tbl->pos);
    }
    tbl->tbl[tbl->pos++] = id;
}
#define vtable_add(tbl, id) vtable_add_gen(p, __LINE__, #tbl, tbl, id)

static void
vtable_pop_gen(struct parser_params *p, int line, const char *name,
               struct vtable *tbl, int n)
{
    if (p->debug) {
        rb_parser_printf(p, "vtable_pop:%d: %s(%p), %d\n",
                         line, name, (void *)tbl, n);
    }
    if (tbl->pos < n) {
        rb_parser_fatal(p, "vtable_pop: unreachable (%d < %d)", tbl->pos, n);
        return;
    }
    tbl->pos -= n;
}
#define vtable_pop(tbl, n) vtable_pop_gen(p, __LINE__, #tbl, tbl, n)

static int
vtable_included(const struct vtable * tbl, ID id)
{
    int i;

    if (!DVARS_TERMINAL_P(tbl)) {
        for (i = 0; i < tbl->pos; i++) {
            if (tbl->tbl[i] == id) {
                return i+1;
            }
        }
    }
    return 0;
}

static void parser_prepare(struct parser_params *p);

static int
e_option_supplied(struct parser_params *p)
{
    return strcmp(p->ruby_sourcefile, "-e") == 0;
}

#ifndef RIPPER
static NODE *parser_append_options(struct parser_params *p, NODE *node);

static VALUE
yycompile0(VALUE arg)
{
    int n;
    NODE *tree;
    struct parser_params *p = (struct parser_params *)arg;
    int cov = FALSE;

    if (!compile_for_eval && !NIL_P(p->ruby_sourcefile_string) && !e_option_supplied(p)) {
        cov = TRUE;
    }

    if (p->debug_lines) {
        p->ast->body.script_lines = p->debug_lines;
    }

    parser_prepare(p);
#define RUBY_DTRACE_PARSE_HOOK(name) \
    if (RUBY_DTRACE_PARSE_##name##_ENABLED()) { \
        RUBY_DTRACE_PARSE_##name(p->ruby_sourcefile, p->ruby_sourceline); \
    }
    RUBY_DTRACE_PARSE_HOOK(BEGIN);
    n = yyparse(p);
    RUBY_DTRACE_PARSE_HOOK(END);

    p->debug_lines = 0;

    xfree(p->lex.strterm);
    p->lex.strterm = 0;
    p->lex.pcur = p->lex.pbeg = p->lex.pend = 0;
    if (n || p->error_p) {
        VALUE mesg = p->error_buffer;
        if (!mesg) {
            mesg = syntax_error_new();
        }
        if (!p->error_tolerant) {
            rb_set_errinfo(mesg);
            return FALSE;
        }
    }
    tree = p->eval_tree;
    if (!tree) {
        tree = NEW_NIL(&NULL_LOC);
    }
    else {
        rb_parser_ary_t *tokens = p->tokens;
        NODE *prelude;
        NODE *body = parser_append_options(p, RNODE_SCOPE(tree)->nd_body);
        prelude = block_append(p, p->eval_tree_begin, body);
        RNODE_SCOPE(tree)->nd_body = prelude;
        p->ast->body.frozen_string_literal = p->frozen_string_literal;
        p->ast->body.coverage_enabled = cov;
        if (p->keep_tokens) {
            p->ast->node_buffer->tokens = tokens;
            p->tokens = NULL;
        }
    }
    p->ast->body.root = tree;
    p->ast->body.line_count = p->line_count;
    return TRUE;
}

static rb_ast_t *
yycompile(struct parser_params *p, VALUE fname, int line)
{
    rb_ast_t *ast;
    if (NIL_P(fname)) {
        p->ruby_sourcefile_string = Qnil;
        p->ruby_sourcefile = "(none)";
    }
    else {
        p->ruby_sourcefile_string = rb_str_to_interned_str(fname);
        p->ruby_sourcefile = StringValueCStr(fname);
    }
    p->ruby_sourceline = line - 1;

    p->lvtbl = NULL;

    p->ast = ast = rb_ast_new();
    compile_callback(yycompile0, (VALUE)p);
    p->ast = 0;

    while (p->lvtbl) {
        local_pop(p);
    }

    return ast;
}
#endif /* !RIPPER */

static rb_encoding *
must_be_ascii_compatible(struct parser_params *p, rb_parser_string_t *s)
{
    rb_encoding *enc = rb_parser_str_get_encoding(s);
    if (!rb_enc_asciicompat(enc)) {
        rb_raise(rb_eArgError, "invalid source encoding");
    }
    return enc;
}

static rb_parser_string_t *
lex_getline(struct parser_params *p)
{
    rb_parser_string_t *line = (*p->lex.gets)(p, p->lex.input, p->line_count);
    if (!line) return 0;
    p->line_count++;
    string_buffer_append(p, line);
    must_be_ascii_compatible(p, line);
    return line;
}

#ifndef RIPPER
rb_ast_t*
rb_parser_compile(rb_parser_t *p, rb_parser_lex_gets_func *gets, VALUE fname, rb_parser_input_data input, int line)
{
    p->lex.gets = gets;
    p->lex.input = input;
    p->lex.pbeg = p->lex.pcur = p->lex.pend = 0;

    return yycompile(p, fname, line);
}
#endif  /* !RIPPER */

#define STR_FUNC_ESCAPE 0x01
#define STR_FUNC_EXPAND 0x02
#define STR_FUNC_REGEXP 0x04
#define STR_FUNC_QWORDS 0x08
#define STR_FUNC_SYMBOL 0x10
#define STR_FUNC_INDENT 0x20
#define STR_FUNC_LABEL  0x40
#define STR_FUNC_LIST   0x4000
#define STR_FUNC_TERM   0x8000

enum string_type {
    str_label  = STR_FUNC_LABEL,
    str_squote = (0),
    str_dquote = (STR_FUNC_EXPAND),
    str_xquote = (STR_FUNC_EXPAND),
    str_regexp = (STR_FUNC_REGEXP|STR_FUNC_ESCAPE|STR_FUNC_EXPAND),
    str_sword  = (STR_FUNC_QWORDS|STR_FUNC_LIST),
    str_dword  = (STR_FUNC_QWORDS|STR_FUNC_EXPAND|STR_FUNC_LIST),
    str_ssym   = (STR_FUNC_SYMBOL),
    str_dsym   = (STR_FUNC_SYMBOL|STR_FUNC_EXPAND)
};

static rb_parser_string_t *
parser_str_new(struct parser_params *p, const char *ptr, long len, rb_encoding *enc, int func, rb_encoding *enc0)
{
    rb_parser_string_t *pstr;

    pstr = rb_parser_encoding_string_new(p, ptr, len, enc);

    if (!(func & STR_FUNC_REGEXP)) {
        if (rb_parser_is_ascii_string(p, pstr)) {
        }
        else if (rb_is_usascii_enc((void *)enc0) && enc != rb_utf8_encoding()) {
            /* everything is valid in ASCII-8BIT */
            enc = rb_ascii8bit_encoding();
            PARSER_ENCODING_CODERANGE_SET(pstr, enc, RB_PARSER_ENC_CODERANGE_VALID);
        }
    }

    return pstr;
}

static int
strterm_is_heredoc(rb_strterm_t *strterm)
{
    return strterm->heredoc;
}

static rb_strterm_t *
new_strterm(struct parser_params *p, int func, int term, int paren)
{
    rb_strterm_t *strterm = ZALLOC(rb_strterm_t);
    strterm->u.literal.func = func;
    strterm->u.literal.term = term;
    strterm->u.literal.paren = paren;
    return strterm;
}

static rb_strterm_t *
new_heredoc(struct parser_params *p)
{
    rb_strterm_t *strterm = ZALLOC(rb_strterm_t);
    strterm->heredoc = true;
    return strterm;
}

#define peek(p,c) peek_n(p, (c), 0)
#define peek_n(p,c,n) (!lex_eol_n_p(p, n) && (c) == (unsigned char)(p)->lex.pcur[n])
#define peekc(p) peekc_n(p, 0)
#define peekc_n(p,n) (lex_eol_n_p(p, n) ? -1 : (unsigned char)(p)->lex.pcur[n])

#define add_delayed_token(p, tok, end) parser_add_delayed_token(p, tok, end, __LINE__)
static void
parser_add_delayed_token(struct parser_params *p, const char *tok, const char *end, int line)
{
    debug_token_line(p, "add_delayed_token", line);

    if (tok < end) {
        if (has_delayed_token(p)) {
            bool next_line = parser_string_char_at_end(p, p->delayed.token, 0) == '\n';
            int end_line = (next_line ? 1 : 0) + p->delayed.end_line;
            int end_col = (next_line ? 0 : p->delayed.end_col);
            if (end_line != p->ruby_sourceline || end_col != tok - p->lex.pbeg) {
                dispatch_delayed_token(p, tSTRING_CONTENT);
            }
        }
        if (!has_delayed_token(p)) {
            p->delayed.token = rb_parser_string_new(p, 0, 0);
            rb_parser_enc_associate(p, p->delayed.token, p->enc);
            p->delayed.beg_line = p->ruby_sourceline;
            p->delayed.beg_col = rb_long2int(tok - p->lex.pbeg);
        }
        parser_str_cat(p->delayed.token, tok, end - tok);
        p->delayed.end_line = p->ruby_sourceline;
        p->delayed.end_col = rb_long2int(end - p->lex.pbeg);
        p->lex.ptok = end;
    }
}

static void
set_lastline(struct parser_params *p, rb_parser_string_t *str)
{
    p->lex.pbeg = p->lex.pcur = PARSER_STRING_PTR(str);
    p->lex.pend = p->lex.pcur + PARSER_STRING_LEN(str);
    p->lex.lastline = str;
}

static int
nextline(struct parser_params *p, int set_encoding)
{
    rb_parser_string_t *str = p->lex.nextline;
    p->lex.nextline = 0;
    if (!str) {
        if (p->eofp)
            return -1;

        if (!lex_eol_ptr_p(p, p->lex.pbeg) && *(p->lex.pend-1) != '\n') {
            goto end_of_input;
        }

        if (!p->lex.input || !(str = lex_getline(p))) {
          end_of_input:
            p->eofp = 1;
            lex_goto_eol(p);
            return -1;
        }
#ifndef RIPPER
        if (p->debug_lines) {
            if (set_encoding) rb_parser_enc_associate(p, str, p->enc);
            rb_parser_string_t *copy = rb_parser_string_deep_copy(p, str);
            rb_parser_ary_push_script_line(p, p->debug_lines, copy);
        }
#endif
        p->cr_seen = FALSE;
    }
    else if (str == AFTER_HEREDOC_WITHOUT_TERMINATOR) {
        /* after here-document without terminator */
        goto end_of_input;
    }
    add_delayed_token(p, p->lex.ptok, p->lex.pend);
    if (p->heredoc_end > 0) {
        p->ruby_sourceline = p->heredoc_end;
        p->heredoc_end = 0;
    }
    p->ruby_sourceline++;
    set_lastline(p, str);
    token_flush(p);
    return 0;
}

static int
parser_cr(struct parser_params *p, int c)
{
    if (peek(p, '\n')) {
        p->lex.pcur++;
        c = '\n';
    }
    return c;
}

static inline int
nextc0(struct parser_params *p, int set_encoding)
{
    int c;

    if (UNLIKELY(lex_eol_p(p) || p->eofp || p->lex.nextline > AFTER_HEREDOC_WITHOUT_TERMINATOR)) {
        if (nextline(p, set_encoding)) return -1;
    }
    c = (unsigned char)*p->lex.pcur++;
    if (UNLIKELY(c == '\r')) {
        c = parser_cr(p, c);
    }

    return c;
}
#define nextc(p) nextc0(p, TRUE)

static void
pushback(struct parser_params *p, int c)
{
    if (c == -1) return;
    p->eofp = 0;
    p->lex.pcur--;
    if (p->lex.pcur > p->lex.pbeg && p->lex.pcur[0] == '\n' && p->lex.pcur[-1] == '\r') {
        p->lex.pcur--;
    }
}

#define was_bol(p) ((p)->lex.pcur == (p)->lex.pbeg + 1)

#define tokfix(p) ((p)->tokenbuf[(p)->tokidx]='\0')
#define tok(p) (p)->tokenbuf
#define toklen(p) (p)->tokidx

static int
looking_at_eol_p(struct parser_params *p)
{
    const char *ptr = p->lex.pcur;
    while (!lex_eol_ptr_p(p, ptr)) {
        int c = (unsigned char)*ptr++;
        int eol = (c == '\n' || c == '#');
        if (eol || !ISSPACE(c)) {
            return eol;
        }
    }
    return TRUE;
}

static char*
newtok(struct parser_params *p)
{
    p->tokidx = 0;
    if (!p->tokenbuf) {
        p->toksiz = 60;
        p->tokenbuf = ALLOC_N(char, 60);
    }
    if (p->toksiz > 4096) {
        p->toksiz = 60;
        REALLOC_N(p->tokenbuf, char, 60);
    }
    return p->tokenbuf;
}

static char *
tokspace(struct parser_params *p, int n)
{
    p->tokidx += n;

    if (p->tokidx >= p->toksiz) {
        do {p->toksiz *= 2;} while (p->toksiz < p->tokidx);
        REALLOC_N(p->tokenbuf, char, p->toksiz);
    }
    return &p->tokenbuf[p->tokidx-n];
}

static void
tokadd(struct parser_params *p, int c)
{
    p->tokenbuf[p->tokidx++] = (char)c;
    if (p->tokidx >= p->toksiz) {
        p->toksiz *= 2;
        REALLOC_N(p->tokenbuf, char, p->toksiz);
    }
}

static int
tok_hex(struct parser_params *p, size_t *numlen)
{
    int c;

    c = (int)ruby_scan_hex(p->lex.pcur, 2, numlen);
    if (!*numlen) {
        flush_string_content(p, p->enc, rb_strlen_lit("\\x"));
        yyerror0("invalid hex escape");
        dispatch_scan_event(p, tSTRING_CONTENT);
        return 0;
    }
    p->lex.pcur += *numlen;
    return c;
}

#define tokcopy(p, n) memcpy(tokspace(p, n), (p)->lex.pcur - (n), (n))

static int
escaped_control_code(int c)
{
    int c2 = 0;
    switch (c) {
      case ' ':
        c2 = 's';
        break;
      case '\n':
        c2 = 'n';
        break;
      case '\t':
        c2 = 't';
        break;
      case '\v':
        c2 = 'v';
        break;
      case '\r':
        c2 = 'r';
        break;
      case '\f':
        c2 = 'f';
        break;
    }
    return c2;
}

#define WARN_SPACE_CHAR(c, prefix) \
    rb_warn1("invalid character syntax; use "prefix"\\%c", WARN_I(c))

static int
tokadd_codepoint(struct parser_params *p, rb_encoding **encp,
                 int regexp_literal, const char *begin)
{
    const int wide = !begin;
    size_t numlen;
    int codepoint = (int)ruby_scan_hex(p->lex.pcur, wide ? p->lex.pend - p->lex.pcur : 4, &numlen);

    p->lex.pcur += numlen;
    if (p->lex.strterm == NULL ||
        strterm_is_heredoc(p->lex.strterm) ||
        (p->lex.strterm->u.literal.func != str_regexp)) {
        if (!begin) begin = p->lex.pcur;
        if (wide ? (numlen == 0 || numlen > 6) : (numlen < 4))  {
            flush_string_content(p, rb_utf8_encoding(), p->lex.pcur - begin);
            yyerror0("invalid Unicode escape");
            dispatch_scan_event(p, tSTRING_CONTENT);
            return wide && numlen > 0;
        }
        if (codepoint > 0x10ffff) {
            flush_string_content(p, rb_utf8_encoding(), p->lex.pcur - begin);
            yyerror0("invalid Unicode codepoint (too large)");
            dispatch_scan_event(p, tSTRING_CONTENT);
            return wide;
        }
        if ((codepoint & 0xfffff800) == 0xd800) {
            flush_string_content(p, rb_utf8_encoding(), p->lex.pcur - begin);
            yyerror0("invalid Unicode codepoint");
            dispatch_scan_event(p, tSTRING_CONTENT);
            return wide;
        }
    }
    if (regexp_literal) {
        tokcopy(p, (int)numlen);
    }
    else if (codepoint >= 0x80) {
        rb_encoding *utf8 = rb_utf8_encoding();
        if (*encp && utf8 != *encp) {
            YYLTYPE loc = RUBY_INIT_YYLLOC();
            compile_error(p, "UTF-8 mixed within %s source", rb_enc_name(*encp));
            parser_show_error_line(p, &loc);
            return wide;
        }
        *encp = utf8;
        tokaddmbc(p, codepoint, *encp);
    }
    else {
        tokadd(p, codepoint);
    }
    return TRUE;
}

static int tokadd_mbchar(struct parser_params *p, int c);

static int
tokskip_mbchar(struct parser_params *p)
{
    int len = parser_precise_mbclen(p, p->lex.pcur-1);
    if (len > 0) {
        p->lex.pcur += len - 1;
    }
    return len;
}

/* return value is for ?\u3042 */
static void
tokadd_utf8(struct parser_params *p, rb_encoding **encp,
            int term, int symbol_literal, int regexp_literal)
{
    /*
     * If `term` is not -1, then we allow multiple codepoints in \u{}
     * upto `term` byte, otherwise we're parsing a character literal.
     * And then add the codepoints to the current token.
     */
    static const char multiple_codepoints[] = "Multiple codepoints at single character literal";

    const int open_brace = '{', close_brace = '}';

    if (regexp_literal) { tokadd(p, '\\'); tokadd(p, 'u'); }

    if (peek(p, open_brace)) {  /* handle \u{...} form */
        if (regexp_literal && p->lex.strterm->u.literal.func == str_regexp) {
            /*
             * Skip parsing validation code and copy bytes as-is until term or
             * closing brace, in order to correctly handle extended regexps where
             * invalid unicode escapes are allowed in comments. The regexp parser
             * does its own validation and will catch any issues.
             */
            tokadd(p, open_brace);
            while (!lex_eol_ptr_p(p, ++p->lex.pcur)) {
                int c = peekc(p);
                if (c == close_brace) {
                    tokadd(p, c);
                    ++p->lex.pcur;
                    break;
                }
                else if (c == term) {
                    break;
                }
                if (c == '\\' && !lex_eol_n_p(p, 1)) {
                    tokadd(p, c);
                    c = *++p->lex.pcur;
                }
                tokadd_mbchar(p, c);
            }
        }
        else {
            const char *second = NULL;
            int c, last = nextc(p);
            if (lex_eol_p(p)) goto unterminated;
            while (ISSPACE(c = peekc(p)) && !lex_eol_ptr_p(p, ++p->lex.pcur));
            while (c != close_brace) {
                if (c == term) goto unterminated;
                if (second == multiple_codepoints)
                    second = p->lex.pcur;
                if (regexp_literal) tokadd(p, last);
                if (!tokadd_codepoint(p, encp, regexp_literal, NULL)) {
                    break;
                }
                while (ISSPACE(c = peekc(p))) {
                    if (lex_eol_ptr_p(p, ++p->lex.pcur)) goto unterminated;
                    last = c;
                }
                if (term == -1 && !second)
                    second = multiple_codepoints;
            }

            if (c != close_brace) {
              unterminated:
                flush_string_content(p, rb_utf8_encoding(), 0);
                yyerror0("unterminated Unicode escape");
                dispatch_scan_event(p, tSTRING_CONTENT);
                return;
            }
            if (second && second != multiple_codepoints) {
                const char *pcur = p->lex.pcur;
                p->lex.pcur = second;
                dispatch_scan_event(p, tSTRING_CONTENT);
                token_flush(p);
                p->lex.pcur = pcur;
                yyerror0(multiple_codepoints);
                token_flush(p);
            }

            if (regexp_literal) tokadd(p, close_brace);
            nextc(p);
        }
    }
    else {			/* handle \uxxxx form */
        if (!tokadd_codepoint(p, encp, regexp_literal, p->lex.pcur - rb_strlen_lit("\\u"))) {
            token_flush(p);
            return;
        }
    }
}

#define ESCAPE_CONTROL 1
#define ESCAPE_META    2

static int
read_escape(struct parser_params *p, int flags, const char *begin)
{
    int c;
    size_t numlen;

    switch (c = nextc(p)) {
      case '\\':	/* Backslash */
        return c;

      case 'n':	/* newline */
        return '\n';

      case 't':	/* horizontal tab */
        return '\t';

      case 'r':	/* carriage-return */
        return '\r';

      case 'f':	/* form-feed */
        return '\f';

      case 'v':	/* vertical tab */
        return '\13';

      case 'a':	/* alarm(bell) */
        return '\007';

      case 'e':	/* escape */
        return 033;

      case '0': case '1': case '2': case '3': /* octal constant */
      case '4': case '5': case '6': case '7':
        pushback(p, c);
        c = (int)ruby_scan_oct(p->lex.pcur, 3, &numlen);
        p->lex.pcur += numlen;
        return c;

      case 'x':	/* hex constant */
        c = tok_hex(p, &numlen);
        if (numlen == 0) return 0;
        return c;

      case 'b':	/* backspace */
        return '\010';

      case 's':	/* space */
        return ' ';

      case 'M':
        if (flags & ESCAPE_META) goto eof;
        if ((c = nextc(p)) != '-') {
            goto eof;
        }
        if ((c = nextc(p)) == '\\') {
            switch (peekc(p)) {
              case 'u': case 'U':
                nextc(p);
                goto eof;
            }
            return read_escape(p, flags|ESCAPE_META, begin) | 0x80;
        }
        else if (c == -1) goto eof;
        else if (!ISASCII(c)) {
            tokskip_mbchar(p);
            goto eof;
        }
        else {
            int c2 = escaped_control_code(c);
            if (c2) {
                if (ISCNTRL(c) || !(flags & ESCAPE_CONTROL)) {
                    WARN_SPACE_CHAR(c2, "\\M-");
                }
                else {
                    WARN_SPACE_CHAR(c2, "\\C-\\M-");
                }
            }
            else if (ISCNTRL(c)) goto eof;
            return ((c & 0xff) | 0x80);
        }

      case 'C':
        if ((c = nextc(p)) != '-') {
            goto eof;
        }
      case 'c':
        if (flags & ESCAPE_CONTROL) goto eof;
        if ((c = nextc(p))== '\\') {
            switch (peekc(p)) {
              case 'u': case 'U':
                nextc(p);
                goto eof;
            }
            c = read_escape(p, flags|ESCAPE_CONTROL, begin);
        }
        else if (c == '?')
            return 0177;
        else if (c == -1) goto eof;
        else if (!ISASCII(c)) {
            tokskip_mbchar(p);
            goto eof;
        }
        else {
            int c2 = escaped_control_code(c);
            if (c2) {
                if (ISCNTRL(c)) {
                    if (flags & ESCAPE_META) {
                        WARN_SPACE_CHAR(c2, "\\M-");
                    }
                    else {
                        WARN_SPACE_CHAR(c2, "");
                    }
                }
                else {
                    if (flags & ESCAPE_META) {
                        WARN_SPACE_CHAR(c2, "\\M-\\C-");
                    }
                    else {
                        WARN_SPACE_CHAR(c2, "\\C-");
                    }
                }
            }
            else if (ISCNTRL(c)) goto eof;
        }
        return c & 0x9f;

      eof:
      case -1:
        flush_string_content(p, p->enc, p->lex.pcur - begin);
        yyerror0("Invalid escape character syntax");
        dispatch_scan_event(p, tSTRING_CONTENT);
        return '\0';

      default:
        if (!ISASCII(c)) {
            tokskip_mbchar(p);
            goto eof;
        }
        return c;
    }
}

static void
tokaddmbc(struct parser_params *p, int c, rb_encoding *enc)
{
    int len = rb_enc_codelen(c, enc);
    rb_enc_mbcput(c, tokspace(p, len), enc);
}

static int
tokadd_escape(struct parser_params *p)
{
    int c;
    size_t numlen;
    const char *begin = p->lex.pcur;

    switch (c = nextc(p)) {
      case '\n':
        return 0;		/* just ignore */

      case '0': case '1': case '2': case '3': /* octal constant */
      case '4': case '5': case '6': case '7':
        {
            ruby_scan_oct(--p->lex.pcur, 3, &numlen);
            if (numlen == 0) goto eof;
            p->lex.pcur += numlen;
            tokcopy(p, (int)numlen + 1);
        }
        return 0;

      case 'x':	/* hex constant */
        {
            tok_hex(p, &numlen);
            if (numlen == 0) return -1;
            tokcopy(p, (int)numlen + 2);
        }
        return 0;

      eof:
      case -1:
        flush_string_content(p, p->enc, p->lex.pcur - begin);
        yyerror0("Invalid escape character syntax");
        token_flush(p);
        return -1;

      default:
        tokadd(p, '\\');
        tokadd(p, c);
    }
    return 0;
}

static int
char_to_option(int c)
{
    int val;

    switch (c) {
      case 'i':
        val = RE_ONIG_OPTION_IGNORECASE;
        break;
      case 'x':
        val = RE_ONIG_OPTION_EXTEND;
        break;
      case 'm':
        val = RE_ONIG_OPTION_MULTILINE;
        break;
      default:
        val = 0;
        break;
    }
    return val;
}

#define ARG_ENCODING_FIXED   16
#define ARG_ENCODING_NONE    32
#define ENC_ASCII8BIT   1
#define ENC_EUC_JP      2
#define ENC_Windows_31J 3
#define ENC_UTF8        4

static int
char_to_option_kcode(int c, int *option, int *kcode)
{
    *option = 0;

    switch (c) {
      case 'n':
        *kcode = ENC_ASCII8BIT;
        return (*option = ARG_ENCODING_NONE);
      case 'e':
        *kcode = ENC_EUC_JP;
        break;
      case 's':
        *kcode = ENC_Windows_31J;
        break;
      case 'u':
        *kcode = ENC_UTF8;
        break;
      default:
        *kcode = -1;
        return (*option = char_to_option(c));
    }
    *option = ARG_ENCODING_FIXED;
    return 1;
}

static int
regx_options(struct parser_params *p)
{
    int kcode = 0;
    int kopt = 0;
    int options = 0;
    int c, opt, kc;

    newtok(p);
    while (c = nextc(p), ISALPHA(c)) {
        if (c == 'o') {
            options |= RE_OPTION_ONCE;
        }
        else if (char_to_option_kcode(c, &opt, &kc)) {
            if (kc >= 0) {
                if (kc != ENC_ASCII8BIT) kcode = c;
                kopt = opt;
            }
            else {
                options |= opt;
            }
        }
        else {
            tokadd(p, c);
        }
    }
    options |= kopt;
    pushback(p, c);
    if (toklen(p)) {
        YYLTYPE loc = RUBY_INIT_YYLLOC();
        tokfix(p);
        compile_error(p, "unknown regexp option%s - %*s",
                      toklen(p) > 1 ? "s" : "", toklen(p), tok(p));
        parser_show_error_line(p, &loc);
    }
    return options | RE_OPTION_ENCODING(kcode);
}

static int
tokadd_mbchar(struct parser_params *p, int c)
{
    int len = parser_precise_mbclen(p, p->lex.pcur-1);
    if (len < 0) return -1;
    tokadd(p, c);
    p->lex.pcur += --len;
    if (len > 0) tokcopy(p, len);
    return c;
}

static inline int
simple_re_meta(int c)
{
    switch (c) {
      case '$': case '*': case '+': case '.':
      case '?': case '^': case '|':
      case ')': case ']': case '}': case '>':
        return TRUE;
      default:
        return FALSE;
    }
}

static int
parser_update_heredoc_indent(struct parser_params *p, int c)
{
    if (p->heredoc_line_indent == -1) {
        if (c == '\n') p->heredoc_line_indent = 0;
    }
    else {
        if (c == ' ') {
            p->heredoc_line_indent++;
            return TRUE;
        }
        else if (c == '\t') {
            int w = (p->heredoc_line_indent / TAB_WIDTH) + 1;
            p->heredoc_line_indent = w * TAB_WIDTH;
            return TRUE;
        }
        else if (c != '\n') {
            if (p->heredoc_indent > p->heredoc_line_indent) {
                p->heredoc_indent = p->heredoc_line_indent;
            }
            p->heredoc_line_indent = -1;
        }
        else {
            /* Whitespace only line has no indentation */
            p->heredoc_line_indent = 0;
        }
    }
    return FALSE;
}

static void
parser_mixed_error(struct parser_params *p, rb_encoding *enc1, rb_encoding *enc2)
{
    YYLTYPE loc = RUBY_INIT_YYLLOC();
    const char *n1 = rb_enc_name(enc1), *n2 = rb_enc_name(enc2);
    compile_error(p, "%s mixed within %s source", n1, n2);
    parser_show_error_line(p, &loc);
}

static void
parser_mixed_escape(struct parser_params *p, const char *beg, rb_encoding *enc1, rb_encoding *enc2)
{
    const char *pos = p->lex.pcur;
    p->lex.pcur = beg;
    parser_mixed_error(p, enc1, enc2);
    p->lex.pcur = pos;
}

static inline char
nibble_char_upper(unsigned int c)
{
    c &= 0xf;
    return c + (c < 10 ? '0' : 'A' - 10);
}

static int
tokadd_string(struct parser_params *p,
              int func, int term, int paren, long *nest,
              rb_encoding **encp, rb_encoding **enc)
{
    int c;
    bool erred = false;
#ifdef RIPPER
    const int heredoc_end = (p->heredoc_end ? p->heredoc_end + 1 : 0);
    int top_of_line = FALSE;
#endif

#define mixed_error(enc1, enc2) \
    (void)(erred || (parser_mixed_error(p, enc1, enc2), erred = true))
#define mixed_escape(beg, enc1, enc2) \
    (void)(erred || (parser_mixed_escape(p, beg, enc1, enc2), erred = true))

    while ((c = nextc(p)) != -1) {
        if (p->heredoc_indent > 0) {
            parser_update_heredoc_indent(p, c);
        }
#ifdef RIPPER
        if (top_of_line && heredoc_end == p->ruby_sourceline) {
            pushback(p, c);
            break;
        }
#endif

        if (paren && c == paren) {
            ++*nest;
        }
        else if (c == term) {
            if (!nest || !*nest) {
                pushback(p, c);
                break;
            }
            --*nest;
        }
        else if ((func & STR_FUNC_EXPAND) && c == '#' && !lex_eol_p(p)) {
            unsigned char c2 = *p->lex.pcur;
            if (c2 == '$' || c2 == '@' || c2 == '{') {
                pushback(p, c);
                break;
            }
        }
        else if (c == '\\') {
            c = nextc(p);
            switch (c) {
              case '\n':
                if (func & STR_FUNC_QWORDS) break;
                if (func & STR_FUNC_EXPAND) {
                    if (!(func & STR_FUNC_INDENT) || (p->heredoc_indent < 0))
                        continue;
                    if (c == term) {
                        c = '\\';
                        goto terminate;
                    }
                }
                tokadd(p, '\\');
                break;

              case '\\':
                if (func & STR_FUNC_ESCAPE) tokadd(p, c);
                break;

              case 'u':
                if ((func & STR_FUNC_EXPAND) == 0) {
                    tokadd(p, '\\');
                    break;
                }
                tokadd_utf8(p, enc, term,
                            func & STR_FUNC_SYMBOL,
                            func & STR_FUNC_REGEXP);
                continue;

              default:
                if (c == -1) return -1;
                if (!ISASCII(c)) {
                    if ((func & STR_FUNC_EXPAND) == 0) tokadd(p, '\\');
                    goto non_ascii;
                }
                if (func & STR_FUNC_REGEXP) {
                    switch (c) {
                      case 'c':
                      case 'C':
                      case 'M': {
                        pushback(p, c);
                        c = read_escape(p, 0, p->lex.pcur - 1);

                        char *t = tokspace(p, rb_strlen_lit("\\x00"));
                        *t++ = '\\';
                        *t++ = 'x';
                        *t++ = nibble_char_upper(c >> 4);
                        *t++ = nibble_char_upper(c);
                        continue;
                      }
                    }

                    if (c == term && !simple_re_meta(c)) {
                        tokadd(p, c);
                        continue;
                    }
                    pushback(p, c);
                    if ((c = tokadd_escape(p)) < 0)
                        return -1;
                    if (*enc && *enc != *encp) {
                        mixed_escape(p->lex.ptok+2, *enc, *encp);
                    }
                    continue;
                }
                else if (func & STR_FUNC_EXPAND) {
                    pushback(p, c);
                    if (func & STR_FUNC_ESCAPE) tokadd(p, '\\');
                    c = read_escape(p, 0, p->lex.pcur - 1);
                }
                else if ((func & STR_FUNC_QWORDS) && ISSPACE(c)) {
                    /* ignore backslashed spaces in %w */
                }
                else if (c != term && !(paren && c == paren)) {
                    tokadd(p, '\\');
                    pushback(p, c);
                    continue;
                }
            }
        }
        else if (!parser_isascii(p)) {
          non_ascii:
            if (!*enc) {
                *enc = *encp;
            }
            else if (*enc != *encp) {
                mixed_error(*enc, *encp);
                continue;
            }
            if (tokadd_mbchar(p, c) == -1) return -1;
            continue;
        }
        else if ((func & STR_FUNC_QWORDS) && ISSPACE(c)) {
            pushback(p, c);
            break;
        }
        if (c & 0x80) {
            if (!*enc) {
                *enc = *encp;
            }
            else if (*enc != *encp) {
                mixed_error(*enc, *encp);
                continue;
            }
        }
        tokadd(p, c);
#ifdef RIPPER
        top_of_line = (c == '\n');
#endif
    }
  terminate:
    if (*enc) *encp = *enc;
    return c;
}

#define NEW_STRTERM(func, term, paren) new_strterm(p, func, term, paren)

static void
flush_string_content(struct parser_params *p, rb_encoding *enc, size_t back)
{
    p->lex.pcur -= back;
    if (has_delayed_token(p)) {
        ptrdiff_t len = p->lex.pcur - p->lex.ptok;
        if (len > 0) {
            rb_parser_enc_str_buf_cat(p, p->delayed.token, p->lex.ptok, len, enc);
            p->delayed.end_line = p->ruby_sourceline;
            p->delayed.end_col = rb_long2int(p->lex.pcur - p->lex.pbeg);
        }
        dispatch_delayed_token(p, tSTRING_CONTENT);
        p->lex.ptok = p->lex.pcur;
    }
    dispatch_scan_event(p, tSTRING_CONTENT);
    p->lex.pcur += back;
}

/* this can be shared with ripper, since it's independent from struct
 * parser_params. */
#ifndef RIPPER
#define BIT(c, idx) (((c) / 32 - 1 == idx) ? (1U << ((c) % 32)) : 0)
#define SPECIAL_PUNCT(idx) ( \
        BIT('~', idx) | BIT('*', idx) | BIT('$', idx) | BIT('?', idx) | \
        BIT('!', idx) | BIT('@', idx) | BIT('/', idx) | BIT('\\', idx) | \
        BIT(';', idx) | BIT(',', idx) | BIT('.', idx) | BIT('=', idx) | \
        BIT(':', idx) | BIT('<', idx) | BIT('>', idx) | BIT('\"', idx) | \
        BIT('&', idx) | BIT('`', idx) | BIT('\'', idx) | BIT('+', idx) | \
        BIT('0', idx))
const uint_least32_t ruby_global_name_punct_bits[] = {
    SPECIAL_PUNCT(0),
    SPECIAL_PUNCT(1),
    SPECIAL_PUNCT(2),
};
#undef BIT
#undef SPECIAL_PUNCT
#endif

static enum yytokentype
parser_peek_variable_name(struct parser_params *p)
{
    int c;
    const char *ptr = p->lex.pcur;

    if (lex_eol_ptr_n_p(p, ptr, 1)) return 0;
    c = *ptr++;
    switch (c) {
      case '$':
        if ((c = *ptr) == '-') {
            if (lex_eol_ptr_p(p, ++ptr)) return 0;
            c = *ptr;
        }
        else if (is_global_name_punct(c) || ISDIGIT(c)) {
            return tSTRING_DVAR;
        }
        break;
      case '@':
        if ((c = *ptr) == '@') {
            if (lex_eol_ptr_p(p, ++ptr)) return 0;
            c = *ptr;
        }
        break;
      case '{':
        p->lex.pcur = ptr;
        p->command_start = TRUE;
        yylval.state = p->lex.state;
        return tSTRING_DBEG;
      default:
        return 0;
    }
    if (!ISASCII(c) || c == '_' || ISALPHA(c))
        return tSTRING_DVAR;
    return 0;
}

#define IS_ARG() IS_lex_state(EXPR_ARG_ANY)
#define IS_END() IS_lex_state(EXPR_END_ANY)
#define IS_BEG() (IS_lex_state(EXPR_BEG_ANY) || IS_lex_state_all(EXPR_ARG|EXPR_LABELED))
#define IS_SPCARG(c) (IS_ARG() && space_seen && !ISSPACE(c))
#define IS_LABEL_POSSIBLE() (\
        (IS_lex_state(EXPR_LABEL|EXPR_ENDFN) && !cmd_state) || \
        IS_ARG())
#define IS_LABEL_SUFFIX(n) (peek_n(p, ':',(n)) && !peek_n(p, ':', (n)+1))
#define IS_AFTER_OPERATOR() IS_lex_state(EXPR_FNAME | EXPR_DOT)

static inline enum yytokentype
parser_string_term(struct parser_params *p, int func)
{
    xfree(p->lex.strterm);
    p->lex.strterm = 0;
    if (func & STR_FUNC_REGEXP) {
        set_yylval_num(regx_options(p));
        dispatch_scan_event(p, tREGEXP_END);
        SET_LEX_STATE(EXPR_END);
        return tREGEXP_END;
    }
    if ((func & STR_FUNC_LABEL) && IS_LABEL_SUFFIX(0)) {
        nextc(p);
        SET_LEX_STATE(EXPR_ARG|EXPR_LABELED);
        return tLABEL_END;
    }
    SET_LEX_STATE(EXPR_END);
    return tSTRING_END;
}

static enum yytokentype
parse_string(struct parser_params *p, rb_strterm_literal_t *quote)
{
    int func = quote->func;
    int term = quote->term;
    int paren = quote->paren;
    int c, space = 0;
    rb_encoding *enc = p->enc;
    rb_encoding *base_enc = 0;
    rb_parser_string_t *lit;

    if (func & STR_FUNC_TERM) {
        if (func & STR_FUNC_QWORDS) nextc(p); /* delayed term */
        SET_LEX_STATE(EXPR_END);
        xfree(p->lex.strterm);
        p->lex.strterm = 0;
        return func & STR_FUNC_REGEXP ? tREGEXP_END : tSTRING_END;
    }
    c = nextc(p);
    if ((func & STR_FUNC_QWORDS) && ISSPACE(c)) {
        while (c != '\n' && ISSPACE(c = nextc(p)));
        space = 1;
    }
    if (func & STR_FUNC_LIST) {
        quote->func &= ~STR_FUNC_LIST;
        space = 1;
    }
    if (c == term && !quote->nest) {
        if (func & STR_FUNC_QWORDS) {
            quote->func |= STR_FUNC_TERM;
            pushback(p, c); /* dispatch the term at tSTRING_END */
            add_delayed_token(p, p->lex.ptok, p->lex.pcur);
            return ' ';
        }
        return parser_string_term(p, func);
    }
    if (space) {
        if (!ISSPACE(c)) pushback(p, c);
        add_delayed_token(p, p->lex.ptok, p->lex.pcur);
        return ' ';
    }
    newtok(p);
    if ((func & STR_FUNC_EXPAND) && c == '#') {
        enum yytokentype t = parser_peek_variable_name(p);
        if (t) return t;
        tokadd(p, '#');
        c = nextc(p);
    }
    pushback(p, c);
    if (tokadd_string(p, func, term, paren, &quote->nest,
                      &enc, &base_enc) == -1) {
        if (p->eofp) {
#ifndef RIPPER
# define unterminated_literal(mesg) yyerror0(mesg)
#else
# define unterminated_literal(mesg) compile_error(p, mesg)
#endif
            literal_flush(p, p->lex.pcur);
            if (func & STR_FUNC_QWORDS) {
                /* no content to add, bailing out here */
                unterminated_literal("unterminated list meets end of file");
                xfree(p->lex.strterm);
                p->lex.strterm = 0;
                return tSTRING_END;
            }
            if (func & STR_FUNC_REGEXP) {
                unterminated_literal("unterminated regexp meets end of file");
            }
            else {
                unterminated_literal("unterminated string meets end of file");
            }
            quote->func |= STR_FUNC_TERM;
        }
    }

    tokfix(p);
    lit = STR_NEW3(tok(p), toklen(p), enc, func);
    set_yylval_str(lit);
    flush_string_content(p, enc, 0);

    return tSTRING_CONTENT;
}

static enum yytokentype
heredoc_identifier(struct parser_params *p)
{
    /*
     * term_len is length of `<<"END"` except `END`,
     * in this case term_len is 4 (<, <, " and ").
     */
    long len, offset = p->lex.pcur - p->lex.pbeg;
    int c = nextc(p), term, func = 0, quote = 0;
    enum yytokentype token = tSTRING_BEG;
    int indent = 0;

    if (c == '-') {
        c = nextc(p);
        func = STR_FUNC_INDENT;
        offset++;
    }
    else if (c == '~') {
        c = nextc(p);
        func = STR_FUNC_INDENT;
        offset++;
        indent = INT_MAX;
    }
    switch (c) {
      case '\'':
        func |= str_squote; goto quoted;
      case '"':
        func |= str_dquote; goto quoted;
      case '`':
        token = tXSTRING_BEG;
        func |= str_xquote; goto quoted;

      quoted:
        quote++;
        offset++;
        term = c;
        len = 0;
        while ((c = nextc(p)) != term) {
            if (c == -1 || c == '\r' || c == '\n') {
                yyerror0("unterminated here document identifier");
                return -1;
            }
        }
        break;

      default:
        if (!parser_is_identchar(p)) {
            pushback(p, c);
            if (func & STR_FUNC_INDENT) {
                pushback(p, indent > 0 ? '~' : '-');
            }
            return 0;
        }
        func |= str_dquote;
        do {
            int n = parser_precise_mbclen(p, p->lex.pcur-1);
            if (n < 0) return 0;
            p->lex.pcur += --n;
        } while ((c = nextc(p)) != -1 && parser_is_identchar(p));
        pushback(p, c);
        break;
    }

    len = p->lex.pcur - (p->lex.pbeg + offset) - quote;
    if ((unsigned long)len >= HERETERM_LENGTH_MAX)
        yyerror0("too long here document identifier");
    dispatch_scan_event(p, tHEREDOC_BEG);
    lex_goto_eol(p);

    p->lex.strterm = new_heredoc(p);
    rb_strterm_heredoc_t *here = &p->lex.strterm->u.heredoc;
    here->offset = offset;
    here->sourceline = p->ruby_sourceline;
    here->length = (unsigned)len;
    here->quote = quote;
    here->func = func;
    here->lastline = p->lex.lastline;

    token_flush(p);
    p->heredoc_indent = indent;
    p->heredoc_line_indent = 0;
    return token;
}

static void
heredoc_restore(struct parser_params *p, rb_strterm_heredoc_t *here)
{
    rb_parser_string_t *line;
    rb_strterm_t *term = p->lex.strterm;

    p->lex.strterm = 0;
    line = here->lastline;
    p->lex.lastline = line;
    p->lex.pbeg = PARSER_STRING_PTR(line);
    p->lex.pend = p->lex.pbeg + PARSER_STRING_LEN(line);
    p->lex.pcur = p->lex.pbeg + here->offset + here->length + here->quote;
    p->lex.ptok = p->lex.pbeg + here->offset - here->quote;
    p->heredoc_end = p->ruby_sourceline;
    p->ruby_sourceline = (int)here->sourceline;
    if (p->eofp) p->lex.nextline = AFTER_HEREDOC_WITHOUT_TERMINATOR;
    p->eofp = 0;
    xfree(term);
}

static int
dedent_string_column(const char *str, long len, int width)
{
    int i, col = 0;

    for (i = 0; i < len && col < width; i++) {
        if (str[i] == ' ') {
            col++;
        }
        else if (str[i] == '\t') {
            int n = TAB_WIDTH * (col / TAB_WIDTH + 1);
            if (n > width) break;
            col = n;
        }
        else {
            break;
        }
    }

    return i;
}

static int
dedent_string(struct parser_params *p, rb_parser_string_t *string, int width)
{
    char *str;
    long len;
    int i;

    len = PARSER_STRING_LEN(string);
    str = PARSER_STRING_PTR(string);

    i = dedent_string_column(str, len, width);
    if (!i) return 0;

    rb_parser_str_modify(string);
    str = PARSER_STRING_PTR(string);
    if (PARSER_STRING_LEN(string) != len)
        rb_fatal("literal string changed: %s", PARSER_STRING_PTR(string));
    MEMMOVE(str, str + i, char, len - i);
    rb_parser_str_set_len(p, string, len - i);
    return i;
}

static NODE *
heredoc_dedent(struct parser_params *p, NODE *root)
{
    NODE *node, *str_node, *prev_node;
    int indent = p->heredoc_indent;
    rb_parser_string_t *prev_lit = 0;

    if (indent <= 0) return root;
    if (!root) return root;

    prev_node = node = str_node = root;
    if (nd_type_p(root, NODE_LIST)) str_node = RNODE_LIST(root)->nd_head;

    while (str_node) {
        rb_parser_string_t *lit = RNODE_STR(str_node)->string;
        if (nd_fl_newline(str_node)) {
            dedent_string(p, lit, indent);
        }
        if (!prev_lit) {
            prev_lit = lit;
        }
        else if (!literal_concat0(p, prev_lit, lit)) {
            return 0;
        }
        else {
            NODE *end = RNODE_LIST(node)->as.nd_end;
            node = RNODE_LIST(prev_node)->nd_next = RNODE_LIST(node)->nd_next;
            if (!node) {
                if (nd_type_p(prev_node, NODE_DSTR))
                    nd_set_type(prev_node, NODE_STR);
                break;
            }
            RNODE_LIST(node)->as.nd_end = end;
            goto next_str;
        }

        str_node = 0;
        while ((nd_type_p(node, NODE_LIST) || nd_type_p(node, NODE_DSTR)) && (node = RNODE_LIST(prev_node = node)->nd_next) != 0) {
          next_str:
            if (!nd_type_p(node, NODE_LIST)) break;
            if ((str_node = RNODE_LIST(node)->nd_head) != 0) {
                enum node_type type = nd_type(str_node);
                if (type == NODE_STR || type == NODE_DSTR) break;
                prev_lit = 0;
                str_node = 0;
            }
        }
    }
    return root;
}

static int
whole_match_p(struct parser_params *p, const char *eos, long len, int indent)
{
    const char *beg = p->lex.pbeg;
    const char *ptr = p->lex.pend;

    if (ptr - beg < len) return FALSE;
    if (ptr > beg && ptr[-1] == '\n') {
        if (--ptr > beg && ptr[-1] == '\r') --ptr;
        if (ptr - beg < len) return FALSE;
    }
    if (strncmp(eos, ptr -= len, len)) return FALSE;
    if (indent) {
        while (beg < ptr && ISSPACE(*beg)) beg++;
    }
    return beg == ptr;
}

static int
word_match_p(struct parser_params *p, const char *word, long len)
{
    if (strncmp(p->lex.pcur, word, len)) return 0;
    if (lex_eol_n_p(p, len)) return 1;
    int c = (unsigned char)p->lex.pcur[len];
    if (ISSPACE(c)) return 1;
    switch (c) {
      case '\0': case '\004': case '\032': return 1;
    }
    return 0;
}

#define NUM_SUFFIX_R   (1<<0)
#define NUM_SUFFIX_I   (1<<1)
#define NUM_SUFFIX_ALL 3

static int
number_literal_suffix(struct parser_params *p, int mask)
{
    int c, result = 0;
    const char *lastp = p->lex.pcur;

    while ((c = nextc(p)) != -1) {
        if ((mask & NUM_SUFFIX_I) && c == 'i') {
            result |= (mask & NUM_SUFFIX_I);
            mask &= ~NUM_SUFFIX_I;
            /* r after i, rational of complex is disallowed */
            mask &= ~NUM_SUFFIX_R;
            continue;
        }
        if ((mask & NUM_SUFFIX_R) && c == 'r') {
            result |= (mask & NUM_SUFFIX_R);
            mask &= ~NUM_SUFFIX_R;
            continue;
        }
        if (!ISASCII(c) || ISALPHA(c) || c == '_') {
            p->lex.pcur = lastp;
            literal_flush(p, p->lex.pcur);
            return 0;
        }
        pushback(p, c);
        break;
    }
    return result;
}

static enum yytokentype
set_number_literal(struct parser_params *p, enum yytokentype type, int suffix, int base, int seen_point)
{
    enum rb_numeric_type numeric_type = integer_literal;

    if (type == tFLOAT) {
        numeric_type = float_literal;
    }

    if (suffix & NUM_SUFFIX_R) {
        type = tRATIONAL;
        numeric_type = rational_literal;
    }
    if (suffix & NUM_SUFFIX_I) {
        type = tIMAGINARY;
    }

    switch (type) {
      case tINTEGER:
        set_yylval_node(NEW_INTEGER(strdup(tok(p)), base, &_cur_loc));
        break;
      case tFLOAT:
        set_yylval_node(NEW_FLOAT(strdup(tok(p)), &_cur_loc));
        break;
      case tRATIONAL:
        set_yylval_node(NEW_RATIONAL(strdup(tok(p)), base, seen_point, &_cur_loc));
        break;
      case tIMAGINARY:
        set_yylval_node(NEW_IMAGINARY(strdup(tok(p)), base, seen_point, numeric_type, &_cur_loc));
        (void)numeric_type;     /* for ripper */
        break;
      default:
        rb_bug("unexpected token: %d", type);
    }
    SET_LEX_STATE(EXPR_END);
    return type;
}

#define dispatch_heredoc_end(p) parser_dispatch_heredoc_end(p, __LINE__)
static void
parser_dispatch_heredoc_end(struct parser_params *p, int line)
{
    if (has_delayed_token(p))
        dispatch_delayed_token(p, tSTRING_CONTENT);

#ifdef RIPPER
    VALUE str = STR_NEW(p->lex.ptok, p->lex.pend - p->lex.ptok);
    ripper_dispatch1(p, ripper_token2eventid(tHEREDOC_END), str);
#else
    if (p->keep_tokens) {
        rb_parser_string_t *str = rb_parser_encoding_string_new(p, p->lex.ptok, p->lex.pend - p->lex.ptok, p->enc);
        RUBY_SET_YYLLOC_OF_HEREDOC_END(*p->yylloc);
        parser_append_tokens(p, str, tHEREDOC_END, line);
    }
#endif

    RUBY_SET_YYLLOC_FROM_STRTERM_HEREDOC(*p->yylloc);
    lex_goto_eol(p);
    token_flush(p);
}

static enum yytokentype
here_document(struct parser_params *p, rb_strterm_heredoc_t *here)
{
    int c, func, indent = 0;
    const char *eos, *ptr, *ptr_end;
    long len;
    rb_parser_string_t *str = 0;
    rb_encoding *enc = p->enc;
    rb_encoding *base_enc = 0;
    int bol;
#ifdef RIPPER
    VALUE s_value;
#endif

    eos = PARSER_STRING_PTR(here->lastline) + here->offset;
    len = here->length;
    indent = (func = here->func) & STR_FUNC_INDENT;

    if ((c = nextc(p)) == -1) {
      error:
#ifdef RIPPER
        if (!has_delayed_token(p)) {
            dispatch_scan_event(p, tSTRING_CONTENT);
        }
        else if (p->delayed.end_line + 1 == p->ruby_sourceline) {
            if ((len = p->lex.pcur - p->lex.ptok) > 0) {
                if (!(func & STR_FUNC_REGEXP)) {
                    int cr = ENC_CODERANGE_UNKNOWN;
                    rb_str_coderange_scan_restartable(p->lex.ptok, p->lex.pcur, enc, &cr);
                    if (cr != ENC_CODERANGE_7BIT &&
                        rb_is_usascii_enc(p->enc) &&
                        enc != rb_utf8_encoding()) {
                        enc = rb_ascii8bit_encoding();
                    }
                }
                rb_parser_enc_str_buf_cat(p, p->delayed.token, p->lex.ptok, len, enc);
            }
            dispatch_delayed_token(p, tSTRING_CONTENT);
        }
        else {
            dispatch_delayed_token(p, tSTRING_CONTENT);
            dispatch_scan_event(p, tSTRING_CONTENT);
        }
        lex_goto_eol(p);
#endif
        heredoc_restore(p, &p->lex.strterm->u.heredoc);
        compile_error(p, "can't find string \"%.*s\" anywhere before EOF",
                      (int)len, eos);
        token_flush(p);
        SET_LEX_STATE(EXPR_END);
        return tSTRING_END;
    }
    bol = was_bol(p);
    if (!bol) {
        /* not beginning of line, cannot be the terminator */
    }
    else if (p->heredoc_line_indent == -1) {
        /* `heredoc_line_indent == -1` means
         * - "after an interpolation in the same line", or
         * - "in a continuing line"
         */
        p->heredoc_line_indent = 0;
    }
    else if (whole_match_p(p, eos, len, indent)) {
        dispatch_heredoc_end(p);
      restore:
        heredoc_restore(p, &p->lex.strterm->u.heredoc);
        token_flush(p);
        SET_LEX_STATE(EXPR_END);
        return tSTRING_END;
    }

    if (!(func & STR_FUNC_EXPAND)) {
        do {
            ptr = PARSER_STRING_PTR(p->lex.lastline);
            ptr_end = p->lex.pend;
            if (ptr_end > ptr) {
                switch (ptr_end[-1]) {
                  case '\n':
                    if (--ptr_end == ptr || ptr_end[-1] != '\r') {
                        ptr_end++;
                        break;
                    }
                  case '\r':
                    --ptr_end;
                }
            }

            if (p->heredoc_indent > 0) {
                long i = 0;
                while (ptr + i < ptr_end && parser_update_heredoc_indent(p, ptr[i]))
                    i++;
                p->heredoc_line_indent = 0;
            }

            if (str)
                parser_str_cat(str, ptr, ptr_end - ptr);
            else
                str = rb_parser_encoding_string_new(p, ptr, ptr_end - ptr, enc);
            if (!lex_eol_ptr_p(p, ptr_end)) parser_str_cat_cstr(str, "\n");
            lex_goto_eol(p);
            if (p->heredoc_indent > 0) {
                goto flush_str;
            }
            if (nextc(p) == -1) {
                if (str) {
                    rb_parser_string_free(p, str);
                    str = 0;
                }
                goto error;
            }
        } while (!whole_match_p(p, eos, len, indent));
    }
    else {
        /*	int mb = ENC_CODERANGE_7BIT, *mbp = &mb;*/
        newtok(p);
        if (c == '#') {
            enum yytokentype t = parser_peek_variable_name(p);
            if (p->heredoc_line_indent != -1) {
                if (p->heredoc_indent > p->heredoc_line_indent) {
                    p->heredoc_indent = p->heredoc_line_indent;
                }
                p->heredoc_line_indent = -1;
            }
            if (t) return t;
            tokadd(p, '#');
            c = nextc(p);
        }
        do {
            pushback(p, c);
            enc = p->enc;
            if ((c = tokadd_string(p, func, '\n', 0, NULL, &enc, &base_enc)) == -1) {
                if (p->eofp) goto error;
                goto restore;
            }
            if (c != '\n') {
                if (c == '\\') p->heredoc_line_indent = -1;
              flush:
                str = STR_NEW3(tok(p), toklen(p), enc, func);
              flush_str:
                set_yylval_str(str);
#ifndef RIPPER
                if (bol) nd_set_fl_newline(yylval.node);
#endif
                flush_string_content(p, enc, 0);
                return tSTRING_CONTENT;
            }
            tokadd(p, nextc(p));
            if (p->heredoc_indent > 0) {
                lex_goto_eol(p);
                goto flush;
            }
            /*	    if (mbp && mb == ENC_CODERANGE_UNKNOWN) mbp = 0;*/
            if ((c = nextc(p)) == -1) goto error;
        } while (!whole_match_p(p, eos, len, indent));
        str = STR_NEW3(tok(p), toklen(p), enc, func);
    }
    dispatch_heredoc_end(p);
    heredoc_restore(p, &p->lex.strterm->u.heredoc);
    token_flush(p);
    p->lex.strterm = NEW_STRTERM(func | STR_FUNC_TERM, 0, 0);
#ifdef RIPPER
    /* Preserve s_value for set_yylval_str */
    s_value = p->s_value;
#endif
    set_yylval_str(str);
#ifdef RIPPER
    set_parser_s_value(s_value);
#endif

#ifndef RIPPER
    if (bol) nd_set_fl_newline(yylval.node);
#endif
    return tSTRING_CONTENT;
}

#include "lex.c"

static int
arg_ambiguous(struct parser_params *p, char c)
{
#ifndef RIPPER
    if (c == '/') {
        rb_warning1("ambiguity between regexp and two divisions: wrap regexp in parentheses or add a space after '%c' operator", WARN_I(c));
    }
    else {
        rb_warning1("ambiguous first argument; put parentheses or a space even after '%c' operator", WARN_I(c));
    }
#else
    dispatch1(arg_ambiguous, rb_usascii_str_new(&c, 1));
#endif
    return TRUE;
}

/* returns true value if formal argument error;
 * Qtrue, or error message if ripper */
static VALUE
formal_argument_error(struct parser_params *p, ID id)
{
    switch (id_type(id)) {
      case ID_LOCAL:
        break;
#ifndef RIPPER
# define ERR(mesg) (yyerror0(mesg), Qtrue)
#else
# define ERR(mesg) WARN_S(mesg)
#endif
      case ID_CONST:
        return ERR("formal argument cannot be a constant");
      case ID_INSTANCE:
        return ERR("formal argument cannot be an instance variable");
      case ID_GLOBAL:
        return ERR("formal argument cannot be a global variable");
      case ID_CLASS:
        return ERR("formal argument cannot be a class variable");
      default:
        return ERR("formal argument must be local variable");
#undef ERR
    }
    shadowing_lvar(p, id);

    return Qfalse;
}

static int
lvar_defined(struct parser_params *p, ID id)
{
    return (dyna_in_block(p) && dvar_defined(p, id)) || local_id(p, id);
}

/* emacsen -*- hack */
static long
parser_encode_length(struct parser_params *p, const char *name, long len)
{
    long nlen;

    if (len > 5 && name[nlen = len - 5] == '-') {
        if (rb_memcicmp(name + nlen + 1, "unix", 4) == 0)
            return nlen;
    }
    if (len > 4 && name[nlen = len - 4] == '-') {
        if (rb_memcicmp(name + nlen + 1, "dos", 3) == 0)
            return nlen;
        if (rb_memcicmp(name + nlen + 1, "mac", 3) == 0 &&
            !(len == 8 && rb_memcicmp(name, "utf8-mac", len) == 0))
            /* exclude UTF8-MAC because the encoding named "UTF8" doesn't exist in Ruby */
            return nlen;
    }
    return len;
}

static void
parser_set_encode(struct parser_params *p, const char *name)
{
    rb_encoding *enc;
    VALUE excargs[3];
    int idx = 0;

    const char *wrong = 0;
    switch (*name) {
      case 'e': case 'E': wrong = "external"; break;
      case 'i': case 'I': wrong = "internal"; break;
      case 'f': case 'F': wrong = "filesystem"; break;
      case 'l': case 'L': wrong = "locale"; break;
    }
    if (wrong && STRCASECMP(name, wrong) == 0) goto unknown;
    idx = rb_enc_find_index(name);
    if (idx < 0) {
      unknown:
        excargs[1] = rb_sprintf("unknown encoding name: %s", name);
      error:
        excargs[0] = rb_eArgError;
        excargs[2] = rb_make_backtrace();
        rb_ary_unshift(excargs[2], rb_sprintf("%"PRIsVALUE":%d", p->ruby_sourcefile_string, p->ruby_sourceline));
        VALUE exc = rb_make_exception(3, excargs);
        ruby_show_error_line(p, exc, &(YYLTYPE)RUBY_INIT_YYLLOC(), p->ruby_sourceline, p->lex.lastline);

        rb_ast_free(p->ast);
        p->ast = NULL;

        rb_exc_raise(exc);
    }
    enc = rb_enc_from_index(idx);
    if (!rb_enc_asciicompat(enc)) {
        excargs[1] = rb_sprintf("%s is not ASCII compatible", rb_enc_name(enc));
        goto error;
    }
    p->enc = enc;
#ifndef RIPPER
    if (p->debug_lines) {
        long i;
        for (i = 0; i < p->debug_lines->len; i++) {
            rb_parser_enc_associate(p, p->debug_lines->data[i], enc);
        }
    }
#endif
}

static bool
comment_at_top(struct parser_params *p)
{
    if (p->token_seen) return false;
    return (p->line_count == (p->has_shebang ? 2 : 1));
}

typedef long (*rb_magic_comment_length_t)(struct parser_params *p, const char *name, long len);
typedef void (*rb_magic_comment_setter_t)(struct parser_params *p, const char *name, const char *val);

static int parser_invalid_pragma_value(struct parser_params *p, const char *name, const char *val);

static void
magic_comment_encoding(struct parser_params *p, const char *name, const char *val)
{
    if (!comment_at_top(p)) {
        return;
    }
    parser_set_encode(p, val);
}

static int
parser_get_bool(struct parser_params *p, const char *name, const char *val)
{
    switch (*val) {
      case 't': case 'T':
        if (STRCASECMP(val, "true") == 0) {
            return TRUE;
        }
        break;
      case 'f': case 'F':
        if (STRCASECMP(val, "false") == 0) {
            return FALSE;
        }
        break;
    }
    return parser_invalid_pragma_value(p, name, val);
}

static int
parser_invalid_pragma_value(struct parser_params *p, const char *name, const char *val)
{
    rb_warning2("invalid value for %s: %s", WARN_S(name), WARN_S(val));
    return -1;
}

static void
parser_set_token_info(struct parser_params *p, const char *name, const char *val)
{
    int b = parser_get_bool(p, name, val);
    if (b >= 0) p->token_info_enabled = b;
}

static void
parser_set_frozen_string_literal(struct parser_params *p, const char *name, const char *val)
{
    int b;

    if (p->token_seen) {
        rb_warning1("'%s' is ignored after any tokens", WARN_S(name));
        return;
    }

    b = parser_get_bool(p, name, val);
    if (b < 0) return;

    p->frozen_string_literal = b;
}

static void
parser_set_shareable_constant_value(struct parser_params *p, const char *name, const char *val)
{
    for (const char *s = p->lex.pbeg, *e = p->lex.pcur; s < e; ++s) {
        if (*s == ' ' || *s == '\t') continue;
        if (*s == '#') break;
        rb_warning1("'%s' is ignored unless in comment-only line", WARN_S(name));
        return;
    }

    switch (*val) {
      case 'n': case 'N':
        if (STRCASECMP(val, "none") == 0) {
            p->ctxt.shareable_constant_value = rb_parser_shareable_none;
            return;
        }
        break;
      case 'l': case 'L':
        if (STRCASECMP(val, "literal") == 0) {
            p->ctxt.shareable_constant_value = rb_parser_shareable_literal;
            return;
        }
        break;
      case 'e': case 'E':
        if (STRCASECMP(val, "experimental_copy") == 0) {
            p->ctxt.shareable_constant_value = rb_parser_shareable_copy;
            return;
        }
        if (STRCASECMP(val, "experimental_everything") == 0) {
            p->ctxt.shareable_constant_value = rb_parser_shareable_everything;
            return;
        }
        break;
    }
    parser_invalid_pragma_value(p, name, val);
}

# if WARN_PAST_SCOPE
static void
parser_set_past_scope(struct parser_params *p, const char *name, const char *val)
{
    int b = parser_get_bool(p, name, val);
    if (b >= 0) p->past_scope_enabled = b;
}
# endif

struct magic_comment {
    const char *name;
    rb_magic_comment_setter_t func;
    rb_magic_comment_length_t length;
};

static const struct magic_comment magic_comments[] = {
    {"coding", magic_comment_encoding, parser_encode_length},
    {"encoding", magic_comment_encoding, parser_encode_length},
    {"frozen_string_literal", parser_set_frozen_string_literal},
    {"shareable_constant_value", parser_set_shareable_constant_value},
    {"warn_indent", parser_set_token_info},
# if WARN_PAST_SCOPE
    {"warn_past_scope", parser_set_past_scope},
# endif
};

static const char *
magic_comment_marker(const char *str, long len)
{
    long i = 2;

    while (i < len) {
        switch (str[i]) {
          case '-':
            if (str[i-1] == '*' && str[i-2] == '-') {
                return str + i + 1;
            }
            i += 2;
            break;
          case '*':
            if (i + 1 >= len) return 0;
            if (str[i+1] != '-') {
                i += 4;
            }
            else if (str[i-1] != '-') {
                i += 2;
            }
            else {
                return str + i + 2;
            }
            break;
          default:
            i += 3;
            break;
        }
    }
    return 0;
}

static int
parser_magic_comment(struct parser_params *p, const char *str, long len)
{
    int indicator = 0;
    VALUE name = 0, val = 0;
    const char *beg, *end, *vbeg, *vend;
#define str_copy(_s, _p, _n) ((_s) \
        ? (void)(rb_str_resize((_s), (_n)), \
           MEMCPY(RSTRING_PTR(_s), (_p), char, (_n)), (_s)) \
        : (void)((_s) = STR_NEW((_p), (_n))))

    if (len <= 7) return FALSE;
    if (!!(beg = magic_comment_marker(str, len))) {
        if (!(end = magic_comment_marker(beg, str + len - beg)))
            return FALSE;
        indicator = TRUE;
        str = beg;
        len = end - beg - 3;
    }

    /* %r"([^\\s\'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*" */
    while (len > 0) {
        const struct magic_comment *mc = magic_comments;
        char *s;
        int i;
        long n = 0;

        for (; len > 0 && *str; str++, --len) {
            switch (*str) {
              case '\'': case '"': case ':': case ';':
                continue;
            }
            if (!ISSPACE(*str)) break;
        }
        for (beg = str; len > 0; str++, --len) {
            switch (*str) {
              case '\'': case '"': case ':': case ';':
                break;
              default:
                if (ISSPACE(*str)) break;
                continue;
            }
            break;
        }
        for (end = str; len > 0 && ISSPACE(*str); str++, --len);
        if (!len) break;
        if (*str != ':') {
            if (!indicator) return FALSE;
            continue;
        }

        do str++; while (--len > 0 && ISSPACE(*str));
        if (!len) break;
        const char *tok_beg = str;
        if (*str == '"') {
            for (vbeg = ++str; --len > 0 && *str != '"'; str++) {
                if (*str == '\\') {
                    --len;
                    ++str;
                }
            }
            vend = str;
            if (len) {
                --len;
                ++str;
            }
        }
        else {
            for (vbeg = str; len > 0 && *str != '"' && *str != ';' && !ISSPACE(*str); --len, str++);
            vend = str;
        }
        const char *tok_end = str;
        if (indicator) {
            while (len > 0 && (*str == ';' || ISSPACE(*str))) --len, str++;
        }
        else {
            while (len > 0 && (ISSPACE(*str))) --len, str++;
            if (len) return FALSE;
        }

        n = end - beg;
        str_copy(name, beg, n);
        s = RSTRING_PTR(name);
        for (i = 0; i < n; ++i) {
            if (s[i] == '-') s[i] = '_';
        }
        do {
            if (STRNCASECMP(mc->name, s, n) == 0 && !mc->name[n]) {
                n = vend - vbeg;
                if (mc->length) {
                    n = (*mc->length)(p, vbeg, n);
                }
                str_copy(val, vbeg, n);
                p->lex.ptok = tok_beg;
                p->lex.pcur = tok_end;
                (*mc->func)(p, mc->name, RSTRING_PTR(val));
                break;
            }
        } while (++mc < magic_comments + numberof(magic_comments));
#ifdef RIPPER
        str_copy(val, vbeg, vend - vbeg);
        dispatch2(magic_comment, name, val);
#endif
    }

    return TRUE;
}

static void
set_file_encoding(struct parser_params *p, const char *str, const char *send)
{
    int sep = 0;
    const char *beg = str;
    VALUE s;

    for (;;) {
        if (send - str <= 6) return;
        switch (str[6]) {
          case 'C': case 'c': str += 6; continue;
          case 'O': case 'o': str += 5; continue;
          case 'D': case 'd': str += 4; continue;
          case 'I': case 'i': str += 3; continue;
          case 'N': case 'n': str += 2; continue;
          case 'G': case 'g': str += 1; continue;
          case '=': case ':':
            sep = 1;
            str += 6;
            break;
          default:
            str += 6;
            if (ISSPACE(*str)) break;
            continue;
        }
        if (STRNCASECMP(str-6, "coding", 6) == 0) break;
        sep = 0;
    }
    for (;;) {
        do {
            if (++str >= send) return;
        } while (ISSPACE(*str));
        if (sep) break;
        if (*str != '=' && *str != ':') return;
        sep = 1;
        str++;
    }
    beg = str;
    while ((*str == '-' || *str == '_' || ISALNUM(*str)) && ++str < send);
    s = rb_str_new(beg, parser_encode_length(p, beg, str - beg));
    p->lex.ptok = beg;
    p->lex.pcur = str;
    parser_set_encode(p, RSTRING_PTR(s));
    rb_str_resize(s, 0);
}

static void
parser_prepare(struct parser_params *p)
{
    int c = nextc0(p, FALSE);
    p->token_info_enabled = !compile_for_eval && RTEST(ruby_verbose);
    switch (c) {
      case '#':
        if (peek(p, '!')) p->has_shebang = 1;
        break;
      case 0xef:		/* UTF-8 BOM marker */
        if (!lex_eol_n_p(p, 2) &&
            (unsigned char)p->lex.pcur[0] == 0xbb &&
            (unsigned char)p->lex.pcur[1] == 0xbf) {
            p->enc = rb_utf8_encoding();
            p->lex.pcur += 2;
#ifndef RIPPER
            if (p->debug_lines) {
                rb_parser_string_set_encoding(p->lex.lastline, p->enc);
            }
#endif
            p->lex.pbeg = p->lex.pcur;
            token_flush(p);
            return;
        }
        break;
      case -1:   /* end of script. */
        return;
    }
    pushback(p, c);
    p->enc = rb_parser_str_get_encoding(p->lex.lastline);
}

#ifndef RIPPER
#define ambiguous_operator(tok, op, syn) ( \
    rb_warning0("'"op"' after local variable or literal is interpreted as binary operator"), \
    rb_warning0("even though it seems like "syn""))
#else
#define ambiguous_operator(tok, op, syn) \
    dispatch2(operator_ambiguous, TOKEN2VAL(tok), rb_str_new_cstr(syn))
#endif
#define warn_balanced(tok, op, syn) ((void) \
    (!IS_lex_state_for(last_state, EXPR_CLASS|EXPR_DOT|EXPR_FNAME|EXPR_ENDFN) && \
     space_seen && !ISSPACE(c) && \
     (ambiguous_operator(tok, op, syn), 0)), \
     (enum yytokentype)(tok))

static enum yytokentype
no_digits(struct parser_params *p)
{
    yyerror0("numeric literal without digits");
    if (peek(p, '_')) nextc(p);
    /* dummy 0, for tUMINUS_NUM at numeric */
    return set_number_literal(p, tINTEGER, 0, 10, 0);
}

static enum yytokentype
parse_numeric(struct parser_params *p, int c)
{
    int is_float, seen_point, seen_e, nondigit;
    int suffix;

    is_float = seen_point = seen_e = nondigit = 0;
    SET_LEX_STATE(EXPR_END);
    newtok(p);
    if (c == '-' || c == '+') {
        tokadd(p, c);
        c = nextc(p);
    }
    if (c == '0') {
        int start = toklen(p);
        c = nextc(p);
        if (c == 'x' || c == 'X') {
            /* hexadecimal */
            c = nextc(p);
            if (c != -1 && ISXDIGIT(c)) {
                do {
                    if (c == '_') {
                        if (nondigit) break;
                        nondigit = c;
                        continue;
                    }
                    if (!ISXDIGIT(c)) break;
                    nondigit = 0;
                    tokadd(p, c);
                } while ((c = nextc(p)) != -1);
            }
            pushback(p, c);
            tokfix(p);
            if (toklen(p) == start) {
                return no_digits(p);
            }
            else if (nondigit) goto trailing_uc;
            suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
            return set_number_literal(p, tINTEGER, suffix, 16, 0);
        }
        if (c == 'b' || c == 'B') {
            /* binary */
            c = nextc(p);
            if (c == '0' || c == '1') {
                do {
                    if (c == '_') {
                        if (nondigit) break;
                        nondigit = c;
                        continue;
                    }
                    if (c != '0' && c != '1') break;
                    nondigit = 0;
                    tokadd(p, c);
                } while ((c = nextc(p)) != -1);
            }
            pushback(p, c);
            tokfix(p);
            if (toklen(p) == start) {
                return no_digits(p);
            }
            else if (nondigit) goto trailing_uc;
            suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
            return set_number_literal(p, tINTEGER, suffix, 2, 0);
        }
        if (c == 'd' || c == 'D') {
            /* decimal */
            c = nextc(p);
            if (c != -1 && ISDIGIT(c)) {
                do {
                    if (c == '_') {
                        if (nondigit) break;
                        nondigit = c;
                        continue;
                    }
                    if (!ISDIGIT(c)) break;
                    nondigit = 0;
                    tokadd(p, c);
                } while ((c = nextc(p)) != -1);
            }
            pushback(p, c);
            tokfix(p);
            if (toklen(p) == start) {
                return no_digits(p);
            }
            else if (nondigit) goto trailing_uc;
            suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
            return set_number_literal(p, tINTEGER, suffix, 10, 0);
        }
        if (c == '_') {
            /* 0_0 */
            goto octal_number;
        }
        if (c == 'o' || c == 'O') {
            /* prefixed octal */
            c = nextc(p);
            if (c == -1 || c == '_' || !ISDIGIT(c)) {
                tokfix(p);
                return no_digits(p);
            }
        }
        if (c >= '0' && c <= '7') {
            /* octal */
          octal_number:
            do {
                if (c == '_') {
                    if (nondigit) break;
                    nondigit = c;
                    continue;
                }
                if (c < '0' || c > '9') break;
                if (c > '7') goto invalid_octal;
                nondigit = 0;
                tokadd(p, c);
            } while ((c = nextc(p)) != -1);
            if (toklen(p) > start) {
                pushback(p, c);
                tokfix(p);
                if (nondigit) goto trailing_uc;
                suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
                return set_number_literal(p, tINTEGER, suffix, 8, 0);
            }
            if (nondigit) {
                pushback(p, c);
                goto trailing_uc;
            }
        }
        if (c > '7' && c <= '9') {
          invalid_octal:
            yyerror0("Invalid octal digit");
        }
        else if (c == '.' || c == 'e' || c == 'E') {
            tokadd(p, '0');
        }
        else {
            pushback(p, c);
            tokfix(p);
            suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
            return set_number_literal(p, tINTEGER, suffix, 10, 0);
        }
    }

    for (;;) {
        switch (c) {
          case '0': case '1': case '2': case '3': case '4':
          case '5': case '6': case '7': case '8': case '9':
            nondigit = 0;
            tokadd(p, c);
            break;

          case '.':
            if (nondigit) goto trailing_uc;
            if (seen_point || seen_e) {
                goto decode_num;
            }
            else {
                int c0 = nextc(p);
                if (c0 == -1 || !ISDIGIT(c0)) {
                    pushback(p, c0);
                    goto decode_num;
                }
                c = c0;
            }
            seen_point = toklen(p);
            tokadd(p, '.');
            tokadd(p, c);
            is_float++;
            nondigit = 0;
            break;

          case 'e':
          case 'E':
            if (nondigit) {
                pushback(p, c);
                c = nondigit;
                goto decode_num;
            }
            if (seen_e) {
                goto decode_num;
            }
            nondigit = c;
            c = nextc(p);
            if (c != '-' && c != '+' && !ISDIGIT(c)) {
                pushback(p, c);
                c = nondigit;
                nondigit = 0;
                goto decode_num;
            }
            tokadd(p, nondigit);
            seen_e++;
            is_float++;
            tokadd(p, c);
            nondigit = (c == '-' || c == '+') ? c : 0;
            break;

          case '_':	/* `_' in number just ignored */
            if (nondigit) goto decode_num;
            nondigit = c;
            break;

          default:
            goto decode_num;
        }
        c = nextc(p);
    }

  decode_num:
    pushback(p, c);
    if (nondigit) {
      trailing_uc:
        literal_flush(p, p->lex.pcur - 1);
        YYLTYPE loc = RUBY_INIT_YYLLOC();
        compile_error(p, "trailing '%c' in number", nondigit);
        parser_show_error_line(p, &loc);
    }
    tokfix(p);
    if (is_float) {
        enum yytokentype type = tFLOAT;

        suffix = number_literal_suffix(p, seen_e ? NUM_SUFFIX_I : NUM_SUFFIX_ALL);
        if (suffix & NUM_SUFFIX_R) {
            type = tRATIONAL;
        }
        else {
            strtod(tok(p), 0);
            if (errno == ERANGE) {
                rb_warning1("Float %s out of range", WARN_S(tok(p)));
                errno = 0;
            }
        }
        return set_number_literal(p, type, suffix, 0, seen_point);
    }
    suffix = number_literal_suffix(p, NUM_SUFFIX_ALL);
    return set_number_literal(p, tINTEGER, suffix, 10, 0);
}

static enum yytokentype
parse_qmark(struct parser_params *p, int space_seen)
{
    rb_encoding *enc;
    register int c;
    rb_parser_string_t *lit;
    const char *start = p->lex.pcur;

    if (IS_END()) {
        SET_LEX_STATE(EXPR_VALUE);
        return '?';
    }
    c = nextc(p);
    if (c == -1) {
        compile_error(p, "incomplete character syntax");
        return 0;
    }
    if (rb_enc_isspace(c, p->enc)) {
        if (!IS_ARG()) {
            int c2 = escaped_control_code(c);
            if (c2) {
                WARN_SPACE_CHAR(c2, "?");
            }
        }
      ternary:
        pushback(p, c);
        SET_LEX_STATE(EXPR_VALUE);
        return '?';
    }
    newtok(p);
    enc = p->enc;
    int w = parser_precise_mbclen(p, start);
    if (is_identchar(p, start, p->lex.pend, p->enc) &&
        !(lex_eol_ptr_n_p(p, start, w) || !is_identchar(p, start + w, p->lex.pend, p->enc))) {
        if (space_seen) {
            const char *ptr = start;
            do {
                int n = parser_precise_mbclen(p, ptr);
                if (n < 0) return -1;
                ptr += n;
            } while (!lex_eol_ptr_p(p, ptr) && is_identchar(p, ptr, p->lex.pend, p->enc));
            rb_warn2("'?' just followed by '%.*s' is interpreted as" \
                     " a conditional operator, put a space after '?'",
                     WARN_I((int)(ptr - start)), WARN_S_L(start, (ptr - start)));
        }
        goto ternary;
    }
    else if (c == '\\') {
        if (peek(p, 'u')) {
            nextc(p);
            enc = rb_utf8_encoding();
            tokadd_utf8(p, &enc, -1, 0, 0);
        }
        else if (!ISASCII(c = peekc(p)) && c != -1) {
            nextc(p);
            if (tokadd_mbchar(p, c) == -1) return 0;
        }
        else {
            c = read_escape(p, 0, p->lex.pcur - rb_strlen_lit("?\\"));
            tokadd(p, c);
        }
    }
    else {
        if (tokadd_mbchar(p, c) == -1) return 0;
    }
    tokfix(p);
    lit = STR_NEW3(tok(p), toklen(p), enc, 0);
    set_yylval_str(lit);
    SET_LEX_STATE(EXPR_END);
    return tCHAR;
}

static enum yytokentype
parse_percent(struct parser_params *p, const int space_seen, const enum lex_state_e last_state)
{
    register int c;
    const char *ptok = p->lex.pcur;

    if (IS_BEG()) {
        int term;
        int paren;

        c = nextc(p);
      quotation:
        if (c == -1) goto unterminated;
        if (!ISALNUM(c)) {
            term = c;
            if (!ISASCII(c)) goto unknown;
            c = 'Q';
        }
        else {
            term = nextc(p);
            if (rb_enc_isalnum(term, p->enc) || !parser_isascii(p)) {
              unknown:
                pushback(p, term);
                c = parser_precise_mbclen(p, p->lex.pcur);
                if (c < 0) return 0;
                p->lex.pcur += c;
                yyerror0("unknown type of %string");
                return 0;
            }
        }
        if (term == -1) {
          unterminated:
            compile_error(p, "unterminated quoted string meets end of file");
            return 0;
        }
        paren = term;
        if (term == '(') term = ')';
        else if (term == '[') term = ']';
        else if (term == '{') term = '}';
        else if (term == '<') term = '>';
        else paren = 0;

        p->lex.ptok = ptok-1;
        switch (c) {
          case 'Q':
            p->lex.strterm = NEW_STRTERM(str_dquote, term, paren);
            return tSTRING_BEG;

          case 'q':
            p->lex.strterm = NEW_STRTERM(str_squote, term, paren);
            return tSTRING_BEG;

          case 'W':
            p->lex.strterm = NEW_STRTERM(str_dword, term, paren);
            return tWORDS_BEG;

          case 'w':
            p->lex.strterm = NEW_STRTERM(str_sword, term, paren);
            return tQWORDS_BEG;

          case 'I':
            p->lex.strterm = NEW_STRTERM(str_dword, term, paren);
            return tSYMBOLS_BEG;

          case 'i':
            p->lex.strterm = NEW_STRTERM(str_sword, term, paren);
            return tQSYMBOLS_BEG;

          case 'x':
            p->lex.strterm = NEW_STRTERM(str_xquote, term, paren);
            return tXSTRING_BEG;

          case 'r':
            p->lex.strterm = NEW_STRTERM(str_regexp, term, paren);
            return tREGEXP_BEG;

          case 's':
            p->lex.strterm = NEW_STRTERM(str_ssym, term, paren);
            SET_LEX_STATE(EXPR_FNAME|EXPR_FITEM);
            return tSYMBEG;

          default:
            yyerror0("unknown type of %string");
            return 0;
        }
    }
    if ((c = nextc(p)) == '=') {
        set_yylval_id('%');
        SET_LEX_STATE(EXPR_BEG);
        return tOP_ASGN;
    }
    if (IS_SPCARG(c) || (IS_lex_state(EXPR_FITEM) && c == 's')) {
        goto quotation;
    }
    SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
    pushback(p, c);
    return warn_balanced('%', "%%", "string literal");
}

static int
tokadd_ident(struct parser_params *p, int c)
{
    do {
        if (tokadd_mbchar(p, c) == -1) return -1;
        c = nextc(p);
    } while (parser_is_identchar(p));
    pushback(p, c);
    return 0;
}

static ID
tokenize_ident(struct parser_params *p)
{
    ID ident = TOK_INTERN();

    set_yylval_name(ident);

    return ident;
}

static int
parse_numvar(struct parser_params *p)
{
    size_t len;
    int overflow;
    unsigned long n = ruby_scan_digits(tok(p)+1, toklen(p)-1, 10, &len, &overflow);
    const unsigned long nth_ref_max =
        ((FIXNUM_MAX < INT_MAX) ? FIXNUM_MAX : INT_MAX) >> 1;
    /* NTH_REF is left-shifted to be ORed with back-ref flag and
     * turned into a Fixnum, in compile.c */

    if (overflow || n > nth_ref_max) {
        /* compile_error()? */
        rb_warn1("'%s' is too big for a number variable, always nil", WARN_S(tok(p)));
        return 0;		/* $0 is $PROGRAM_NAME, not NTH_REF */
    }
    else {
        return (int)n;
    }
}

static enum yytokentype
parse_gvar(struct parser_params *p, const enum lex_state_e last_state)
{
    const char *ptr = p->lex.pcur;
    register int c;

    SET_LEX_STATE(EXPR_END);
    p->lex.ptok = ptr - 1; /* from '$' */
    newtok(p);
    c = nextc(p);
    switch (c) {
      case '_':		/* $_: last read line string */
        c = nextc(p);
        if (parser_is_identchar(p)) {
            tokadd(p, '$');
            tokadd(p, '_');
            break;
        }
        pushback(p, c);
        c = '_';
        /* fall through */
      case '~': 	/* $~: match-data */
      case '*': 	/* $*: argv */
      case '$': 	/* $$: pid */
      case '?': 	/* $?: last status */
      case '!': 	/* $!: error string */
      case '@': 	/* $@: error position */
      case '/': 	/* $/: input record separator */
      case '\\':	/* $\: output record separator */
      case ';': 	/* $;: field separator */
      case ',': 	/* $,: output field separator */
      case '.': 	/* $.: last read line number */
      case '=': 	/* $=: ignorecase */
      case ':': 	/* $:: load path */
      case '<': 	/* $<: default input handle */
      case '>': 	/* $>: default output handle */
      case '\"':	/* $": already loaded files */
        tokadd(p, '$');
        tokadd(p, c);
        goto gvar;

      case '-':
        tokadd(p, '$');
        tokadd(p, c);
        c = nextc(p);
        if (parser_is_identchar(p)) {
            if (tokadd_mbchar(p, c) == -1) return 0;
        }
        else {
            pushback(p, c);
            pushback(p, '-');
            return '$';
        }
      gvar:
        tokenize_ident(p);
        return tGVAR;

      case '&': 	/* $&: last match */
      case '`': 	/* $`: string before last match */
      case '\'':	/* $': string after last match */
      case '+': 	/* $+: string matches last paren. */
        if (IS_lex_state_for(last_state, EXPR_FNAME)) {
            tokadd(p, '$');
            tokadd(p, c);
            goto gvar;
        }
        set_yylval_node(NEW_BACK_REF(c, &_cur_loc));
        return tBACK_REF;

      case '1': case '2': case '3':
      case '4': case '5': case '6':
      case '7': case '8': case '9':
        tokadd(p, '$');
        do {
            tokadd(p, c);
            c = nextc(p);
        } while (c != -1 && ISDIGIT(c));
        pushback(p, c);
        if (IS_lex_state_for(last_state, EXPR_FNAME)) goto gvar;
        tokfix(p);
        c = parse_numvar(p);
        set_yylval_node(NEW_NTH_REF(c, &_cur_loc));
        return tNTH_REF;

      default:
        if (!parser_is_identchar(p)) {
            YYLTYPE loc = RUBY_INIT_YYLLOC();
            if (c == -1 || ISSPACE(c)) {
                compile_error(p, "'$' without identifiers is not allowed as a global variable name");
            }
            else {
                pushback(p, c);
                compile_error(p, "'$%c' is not allowed as a global variable name", c);
            }
            parser_show_error_line(p, &loc);
            set_yylval_noname();
            return tGVAR;
        }
        /* fall through */
      case '0':
        tokadd(p, '$');
    }

    if (tokadd_ident(p, c)) return 0;
    SET_LEX_STATE(EXPR_END);
    if (VALID_SYMNAME_P(tok(p), toklen(p), p->enc, ID_GLOBAL)) {
        tokenize_ident(p);
    }
    else {
        compile_error(p, "'%.*s' is not allowed as a global variable name", toklen(p), tok(p));
        set_yylval_noname();
    }
    return tGVAR;
}

static bool
parser_numbered_param(struct parser_params *p, int n)
{
    if (n < 0) return false;

    if (DVARS_TERMINAL_P(p->lvtbl->args) || DVARS_TERMINAL_P(p->lvtbl->args->prev)) {
        return false;
    }
    if (p->max_numparam == ORDINAL_PARAM) {
        compile_error(p, "ordinary parameter is defined");
        return false;
    }
    struct vtable *args = p->lvtbl->args;
    if (p->max_numparam < n) {
        p->max_numparam = n;
    }
    while (n > args->pos) {
        vtable_add(args, NUMPARAM_IDX_TO_ID(args->pos+1));
    }
    return true;
}

static enum yytokentype
parse_atmark(struct parser_params *p, const enum lex_state_e last_state)
{
    const char *ptr = p->lex.pcur;
    enum yytokentype result = tIVAR;
    register int c = nextc(p);
    YYLTYPE loc;

    p->lex.ptok = ptr - 1; /* from '@' */
    newtok(p);
    tokadd(p, '@');
    if (c == '@') {
        result = tCVAR;
        tokadd(p, '@');
        c = nextc(p);
    }
    SET_LEX_STATE(IS_lex_state_for(last_state, EXPR_FNAME) ? EXPR_ENDFN : EXPR_END);
    if (c == -1 || !parser_is_identchar(p)) {
        pushback(p, c);
        RUBY_SET_YYLLOC(loc);
        if (result == tIVAR) {
            compile_error(p, "'@' without identifiers is not allowed as an instance variable name");
        }
        else {
            compile_error(p, "'@@' without identifiers is not allowed as a class variable name");
        }
        parser_show_error_line(p, &loc);
        set_yylval_noname();
        SET_LEX_STATE(EXPR_END);
        return result;
    }
    else if (ISDIGIT(c)) {
        pushback(p, c);
        RUBY_SET_YYLLOC(loc);
        if (result == tIVAR) {
            compile_error(p, "'@%c' is not allowed as an instance variable name", c);
        }
        else {
            compile_error(p, "'@@%c' is not allowed as a class variable name", c);
        }
        parser_show_error_line(p, &loc);
        set_yylval_noname();
        SET_LEX_STATE(EXPR_END);
        return result;
    }

    if (tokadd_ident(p, c)) return 0;
    tokenize_ident(p);
    return result;
}

static enum yytokentype
parse_ident(struct parser_params *p, int c, int cmd_state)
{
    enum yytokentype result;
    bool is_ascii = true;
    const enum lex_state_e last_state = p->lex.state;
    ID ident;
    int enforce_keyword_end = 0;

    do {
        if (!ISASCII(c)) is_ascii = false;
        if (tokadd_mbchar(p, c) == -1) return 0;
        c = nextc(p);
    } while (parser_is_identchar(p));
    if ((c == '!' || c == '?') && !peek(p, '=')) {
        result = tFID;
        tokadd(p, c);
    }
    else if (c == '=' && IS_lex_state(EXPR_FNAME) &&
             (!peek(p, '~') && !peek(p, '>') && (!peek(p, '=') || (peek_n(p, '>', 1))))) {
        result = tIDENTIFIER;
        tokadd(p, c);
    }
    else {
        result = tCONSTANT;	/* assume provisionally */
        pushback(p, c);
    }
    tokfix(p);

    if (IS_LABEL_POSSIBLE()) {
        if (IS_LABEL_SUFFIX(0)) {
            SET_LEX_STATE(EXPR_ARG|EXPR_LABELED);
            nextc(p);
            tokenize_ident(p);
            return tLABEL;
        }
    }

#ifndef RIPPER
    if (peek_end_expect_token_locations(p)) {
        const rb_code_position_t *end_pos;
        int lineno, column;
        int beg_pos = (int)(p->lex.ptok - p->lex.pbeg);

        end_pos = peek_end_expect_token_locations(p)->pos;
        lineno = end_pos->lineno;
        column = end_pos->column;

        if (p->debug) {
            rb_parser_printf(p, "enforce_keyword_end check. current: (%d, %d), peek: (%d, %d)\n",
                                p->ruby_sourceline, beg_pos, lineno, column);
        }

        if ((p->ruby_sourceline > lineno) && (beg_pos <= column)) {
            const struct kwtable *kw;

            if ((IS_lex_state(EXPR_DOT)) && (kw = rb_reserved_word(tok(p), toklen(p))) && (kw && kw->id[0] == keyword_end)) {
                if (p->debug) rb_parser_printf(p, "enforce_keyword_end is enabled\n");
                enforce_keyword_end = 1;
            }
        }
    }
#endif

    if (is_ascii && (!IS_lex_state(EXPR_DOT) || enforce_keyword_end)) {
        const struct kwtable *kw;

        /* See if it is a reserved word.  */
        kw = rb_reserved_word(tok(p), toklen(p));
        if (kw) {
            enum lex_state_e state = p->lex.state;
            if (IS_lex_state_for(state, EXPR_FNAME)) {
                SET_LEX_STATE(EXPR_ENDFN);
                set_yylval_name(rb_intern2(tok(p), toklen(p)));
                return kw->id[0];
            }
            SET_LEX_STATE(kw->state);
            if (IS_lex_state(EXPR_BEG)) {
                p->command_start = TRUE;
            }
            if (kw->id[0] == keyword_do) {
                if (lambda_beginning_p()) {
                    p->lex.lpar_beg = -1; /* make lambda_beginning_p() == FALSE in the body of "-> do ... end" */
                    return keyword_do_LAMBDA;
                }
                if (COND_P()) return keyword_do_cond;
                if (CMDARG_P() && !IS_lex_state_for(state, EXPR_CMDARG))
                    return keyword_do_block;
                return keyword_do;
            }
            if (IS_lex_state_for(state, (EXPR_BEG | EXPR_LABELED | EXPR_CLASS)))
                return kw->id[0];
            else {
                if (kw->id[0] != kw->id[1])
                    SET_LEX_STATE(EXPR_BEG | EXPR_LABEL);
                return kw->id[1];
            }
        }
    }

    if (IS_lex_state(EXPR_BEG_ANY | EXPR_ARG_ANY | EXPR_DOT)) {
        if (cmd_state) {
            SET_LEX_STATE(EXPR_CMDARG);
        }
        else {
            SET_LEX_STATE(EXPR_ARG);
        }
    }
    else if (p->lex.state == EXPR_FNAME) {
        SET_LEX_STATE(EXPR_ENDFN);
    }
    else {
        SET_LEX_STATE(EXPR_END);
    }

    ident = tokenize_ident(p);
    if (result == tCONSTANT && is_local_id(ident)) result = tIDENTIFIER;
    if (!IS_lex_state_for(last_state, EXPR_DOT|EXPR_FNAME) &&
        (result == tIDENTIFIER) && /* not EXPR_FNAME, not attrasgn */
        (lvar_defined(p, ident) || NUMPARAM_ID_P(ident))) {
        SET_LEX_STATE(EXPR_END|EXPR_LABEL);
    }
    return result;
}

static void
warn_cr(struct parser_params *p)
{
    if (!p->cr_seen) {
        p->cr_seen = TRUE;
        /* carried over with p->lex.nextline for nextc() */
        rb_warn0("encountered \\r in middle of line, treated as a mere space");
    }
}

static enum yytokentype
parser_yylex(struct parser_params *p)
{
    register int c;
    int space_seen = 0;
    int cmd_state;
    int label;
    enum lex_state_e last_state;
    int fallthru = FALSE;
    int token_seen = p->token_seen;

    if (p->lex.strterm) {
        if (strterm_is_heredoc(p->lex.strterm)) {
            token_flush(p);
            return here_document(p, &p->lex.strterm->u.heredoc);
        }
        else {
            token_flush(p);
            return parse_string(p, &p->lex.strterm->u.literal);
        }
    }
    cmd_state = p->command_start;
    p->command_start = FALSE;
    p->token_seen = TRUE;
#ifndef RIPPER
    token_flush(p);
#endif
  retry:
    last_state = p->lex.state;
    switch (c = nextc(p)) {
      case '\0':		/* NUL */
      case '\004':		/* ^D */
      case '\032':		/* ^Z */
      case -1:			/* end of script. */
        p->eofp = 1;
#ifndef RIPPER
        if (p->end_expect_token_locations) {
            pop_end_expect_token_locations(p);
            RUBY_SET_YYLLOC_OF_DUMMY_END(*p->yylloc);
            return tDUMNY_END;
        }
#endif
        /* Set location for end-of-input because dispatch_scan_event is not called. */
        RUBY_SET_YYLLOC(*p->yylloc);
        return END_OF_INPUT;

        /* white spaces */
      case '\r':
        warn_cr(p);
        /* fall through */
      case ' ': case '\t': case '\f':
      case '\13': /* '\v' */
        space_seen = 1;
        while ((c = nextc(p))) {
            switch (c) {
              case '\r':
                warn_cr(p);
                /* fall through */
              case ' ': case '\t': case '\f':
              case '\13': /* '\v' */
                break;
              default:
                goto outofloop;
            }
        }
      outofloop:
        pushback(p, c);
        dispatch_scan_event(p, tSP);
#ifndef RIPPER
        token_flush(p);
#endif
        goto retry;

      case '#':		/* it's a comment */
        p->token_seen = token_seen;
        const char *const pcur = p->lex.pcur, *const ptok = p->lex.ptok;
        /* no magic_comment in shebang line */
        if (!parser_magic_comment(p, p->lex.pcur, p->lex.pend - p->lex.pcur)) {
            if (comment_at_top(p)) {
                set_file_encoding(p, p->lex.pcur, p->lex.pend);
            }
        }
        p->lex.pcur = pcur, p->lex.ptok = ptok;
        lex_goto_eol(p);
        dispatch_scan_event(p, tCOMMENT);
        fallthru = TRUE;
        /* fall through */
      case '\n':
        p->token_seen = token_seen;
        rb_parser_string_t *prevline = p->lex.lastline;
        c = (IS_lex_state(EXPR_BEG|EXPR_CLASS|EXPR_FNAME|EXPR_DOT) &&
             !IS_lex_state(EXPR_LABELED));
        if (c || IS_lex_state_all(EXPR_ARG|EXPR_LABELED)) {
            if (!fallthru) {
                dispatch_scan_event(p, tIGNORED_NL);
            }
            fallthru = FALSE;
            if (!c && p->ctxt.in_kwarg) {
                goto normal_newline;
            }
            goto retry;
        }
        while (1) {
            switch (c = nextc(p)) {
              case ' ': case '\t': case '\f': case '\r':
              case '\13': /* '\v' */
                space_seen = 1;
                break;
              case '#':
                pushback(p, c);
                if (space_seen) {
                    dispatch_scan_event(p, tSP);
                    token_flush(p);
                }
                goto retry;
              case 'a':
                if (peek_word_at(p, "nd", 2, 0)) goto leading_logical;
                goto bol;
              case 'o':
                if (peek_word_at(p, "r", 1, 0)) goto leading_logical;
                goto bol;
              case '|':
                if (peek(p, '|')) goto leading_logical;
                goto bol;
              case '&':
                if (peek(p, '&')) {
                  leading_logical:
                    pushback(p, c);
                    dispatch_delayed_token(p, tIGNORED_NL);
                    cmd_state = FALSE;
                    goto retry;
                }
                /* fall through */
              case '.': {
                dispatch_delayed_token(p, tIGNORED_NL);
                if (peek(p, '.') == (c == '&')) {
                    pushback(p, c);
                    dispatch_scan_event(p, tSP);
                    goto retry;
                }
              }
              bol:
              default:
                p->ruby_sourceline--;
                p->lex.nextline = p->lex.lastline;
                set_lastline(p, prevline);
              case -1:		/* EOF no decrement*/
                if (c == -1 && space_seen) {
                    dispatch_scan_event(p, tSP);
                }
                lex_goto_eol(p);
                if (c != -1) {
                    token_flush(p);
                    RUBY_SET_YYLLOC(*p->yylloc);
                }
                goto normal_newline;
            }
        }
      normal_newline:
        p->command_start = TRUE;
        SET_LEX_STATE(EXPR_BEG);
        return '\n';

      case '*':
        if ((c = nextc(p)) == '*') {
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idPow);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            if (IS_SPCARG(c)) {
                rb_warning0("'**' interpreted as argument prefix");
                c = tDSTAR;
            }
            else if (IS_BEG()) {
                c = tDSTAR;
            }
            else {
                c = warn_balanced((enum ruby_method_ids)tPOW, "**", "argument prefix");
            }
        }
        else {
            if (c == '=') {
                set_yylval_id('*');
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            if (IS_SPCARG(c)) {
                rb_warning0("'*' interpreted as argument prefix");
                c = tSTAR;
            }
            else if (IS_BEG()) {
                c = tSTAR;
            }
            else {
                c = warn_balanced('*', "*", "argument prefix");
            }
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        return c;

      case '!':
        c = nextc(p);
        if (IS_AFTER_OPERATOR()) {
            SET_LEX_STATE(EXPR_ARG);
            if (c == '@') {
                return '!';
            }
        }
        else {
            SET_LEX_STATE(EXPR_BEG);
        }
        if (c == '=') {
            return tNEQ;
        }
        if (c == '~') {
            return tNMATCH;
        }
        pushback(p, c);
        return '!';

      case '=':
        if (was_bol(p)) {
            /* skip embedded rd document */
            if (word_match_p(p, "begin", 5)) {
                int first_p = TRUE;

                lex_goto_eol(p);
                dispatch_scan_event(p, tEMBDOC_BEG);
                for (;;) {
                    lex_goto_eol(p);
                    if (!first_p) {
                        dispatch_scan_event(p, tEMBDOC);
                    }
                    first_p = FALSE;
                    c = nextc(p);
                    if (c == -1) {
                        compile_error(p, "embedded document meets end of file");
                        return END_OF_INPUT;
                    }
                    if (c == '=' && word_match_p(p, "end", 3)) {
                        break;
                    }
                    pushback(p, c);
                }
                lex_goto_eol(p);
                dispatch_scan_event(p, tEMBDOC_END);
                goto retry;
            }
        }

        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        if ((c = nextc(p)) == '=') {
            if ((c = nextc(p)) == '=') {
                return tEQQ;
            }
            pushback(p, c);
            return tEQ;
        }
        if (c == '~') {
            return tMATCH;
        }
        else if (c == '>') {
            return tASSOC;
        }
        pushback(p, c);
        return '=';

      case '<':
        c = nextc(p);
        if (c == '<' &&
            !IS_lex_state(EXPR_DOT | EXPR_CLASS) &&
            !IS_END() &&
            (!IS_ARG() || IS_lex_state(EXPR_LABELED) || space_seen)) {
            enum  yytokentype token = heredoc_identifier(p);
            if (token) return token < 0 ? 0 : token;
        }
        if (IS_AFTER_OPERATOR()) {
            SET_LEX_STATE(EXPR_ARG);
        }
        else {
            if (IS_lex_state(EXPR_CLASS))
                p->command_start = TRUE;
            SET_LEX_STATE(EXPR_BEG);
        }
        if (c == '=') {
            if ((c = nextc(p)) == '>') {
                return tCMP;
            }
            pushback(p, c);
            return tLEQ;
        }
        if (c == '<') {
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idLTLT);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            return warn_balanced((enum ruby_method_ids)tLSHFT, "<<", "here document");
        }
        pushback(p, c);
        return '<';

      case '>':
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        if ((c = nextc(p)) == '=') {
            return tGEQ;
        }
        if (c == '>') {
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idGTGT);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            return tRSHFT;
        }
        pushback(p, c);
        return '>';

      case '"':
        label = (IS_LABEL_POSSIBLE() ? str_label : 0);
        p->lex.strterm = NEW_STRTERM(str_dquote | label, '"', 0);
        p->lex.ptok = p->lex.pcur-1;
        return tSTRING_BEG;

      case '`':
        if (IS_lex_state(EXPR_FNAME)) {
            SET_LEX_STATE(EXPR_ENDFN);
            return c;
        }
        if (IS_lex_state(EXPR_DOT)) {
            if (cmd_state)
                SET_LEX_STATE(EXPR_CMDARG);
            else
                SET_LEX_STATE(EXPR_ARG);
            return c;
        }
        p->lex.strterm = NEW_STRTERM(str_xquote, '`', 0);
        return tXSTRING_BEG;

      case '\'':
        label = (IS_LABEL_POSSIBLE() ? str_label : 0);
        p->lex.strterm = NEW_STRTERM(str_squote | label, '\'', 0);
        p->lex.ptok = p->lex.pcur-1;
        return tSTRING_BEG;

      case '?':
        return parse_qmark(p, space_seen);

      case '&':
        if ((c = nextc(p)) == '&') {
            SET_LEX_STATE(EXPR_BEG);
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idANDOP);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            return tANDOP;
        }
        else if (c == '=') {
            set_yylval_id('&');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        else if (c == '.') {
            set_yylval_id(idANDDOT);
            SET_LEX_STATE(EXPR_DOT);
            return tANDDOT;
        }
        pushback(p, c);
        if (IS_SPCARG(c)) {
            if ((c != ':') ||
                (c = peekc_n(p, 1)) == -1 ||
                !(c == '\'' || c == '"' ||
                  is_identchar(p, (p->lex.pcur+1), p->lex.pend, p->enc))) {
                rb_warning0("'&' interpreted as argument prefix");
            }
            c = tAMPER;
        }
        else if (IS_BEG()) {
            c = tAMPER;
        }
        else {
            c = warn_balanced('&', "&", "argument prefix");
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        return c;

      case '|':
        if ((c = nextc(p)) == '|') {
            SET_LEX_STATE(EXPR_BEG);
            if ((c = nextc(p)) == '=') {
                set_yylval_id(idOROP);
                SET_LEX_STATE(EXPR_BEG);
                return tOP_ASGN;
            }
            pushback(p, c);
            if (IS_lex_state_for(last_state, EXPR_BEG)) {
                c = '|';
                pushback(p, '|');
                return c;
            }
            return tOROP;
        }
        if (c == '=') {
            set_yylval_id('|');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG|EXPR_LABEL);
        pushback(p, c);
        return '|';

      case '+':
        c = nextc(p);
        if (IS_AFTER_OPERATOR()) {
            SET_LEX_STATE(EXPR_ARG);
            if (c == '@') {
                return tUPLUS;
            }
            pushback(p, c);
            return '+';
        }
        if (c == '=') {
            set_yylval_id('+');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        if (IS_BEG() || (IS_SPCARG(c) && arg_ambiguous(p, '+'))) {
            SET_LEX_STATE(EXPR_BEG);
            pushback(p, c);
            if (c != -1 && ISDIGIT(c)) {
                return parse_numeric(p, '+');
            }
            return tUPLUS;
        }
        SET_LEX_STATE(EXPR_BEG);
        pushback(p, c);
        return warn_balanced('+', "+", "unary operator");

      case '-':
        c = nextc(p);
        if (IS_AFTER_OPERATOR()) {
            SET_LEX_STATE(EXPR_ARG);
            if (c == '@') {
                return tUMINUS;
            }
            pushback(p, c);
            return '-';
        }
        if (c == '=') {
            set_yylval_id('-');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        if (c == '>') {
            SET_LEX_STATE(EXPR_ENDFN);
            yylval.num = p->lex.lpar_beg;
            p->lex.lpar_beg = p->lex.paren_nest;
            return tLAMBDA;
        }
        if (IS_BEG() || (IS_SPCARG(c) && arg_ambiguous(p, '-'))) {
            SET_LEX_STATE(EXPR_BEG);
            pushback(p, c);
            if (c != -1 && ISDIGIT(c)) {
                return tUMINUS_NUM;
            }
            return tUMINUS;
        }
        SET_LEX_STATE(EXPR_BEG);
        pushback(p, c);
        return warn_balanced('-', "-", "unary operator");

      case '.': {
        int is_beg = IS_BEG();
        SET_LEX_STATE(EXPR_BEG);
        if ((c = nextc(p)) == '.') {
            if ((c = nextc(p)) == '.') {
                if (p->ctxt.in_argdef || IS_LABEL_POSSIBLE()) {
                    SET_LEX_STATE(EXPR_ENDARG);
                    return tBDOT3;
                }
                if (p->lex.paren_nest == 0 && looking_at_eol_p(p)) {
                    rb_warn0("... at EOL, should be parenthesized?");
                }
                return is_beg ? tBDOT3 : tDOT3;
            }
            pushback(p, c);
            return is_beg ? tBDOT2 : tDOT2;
        }
        pushback(p, c);
        if (c != -1 && ISDIGIT(c)) {
            char prev = p->lex.pcur-1 > p->lex.pbeg ? *(p->lex.pcur-2) : 0;
            parse_numeric(p, '.');
            if (ISDIGIT(prev)) {
                yyerror0("unexpected fraction part after numeric literal");
            }
            else {
                yyerror0("no .<digit> floating literal anymore; put 0 before dot");
            }
            SET_LEX_STATE(EXPR_END);
            p->lex.ptok = p->lex.pcur;
            goto retry;
        }
        set_yylval_id('.');
        SET_LEX_STATE(EXPR_DOT);
        return '.';
      }

      case '0': case '1': case '2': case '3': case '4':
      case '5': case '6': case '7': case '8': case '9':
        return parse_numeric(p, c);

      case ')':
        COND_POP();
        CMDARG_POP();
        SET_LEX_STATE(EXPR_ENDFN);
        p->lex.paren_nest--;
        return c;

      case ']':
        COND_POP();
        CMDARG_POP();
        SET_LEX_STATE(EXPR_END);
        p->lex.paren_nest--;
        return c;

      case '}':
        /* tSTRING_DEND does COND_POP and CMDARG_POP in the yacc's rule */
        if (!p->lex.brace_nest--) return tSTRING_DEND;
        COND_POP();
        CMDARG_POP();
        SET_LEX_STATE(EXPR_END);
        p->lex.paren_nest--;
        return c;

      case ':':
        c = nextc(p);
        if (c == ':') {
            if (IS_BEG() || IS_lex_state(EXPR_CLASS) || IS_SPCARG(-1)) {
                SET_LEX_STATE(EXPR_BEG);
                return tCOLON3;
            }
            set_yylval_id(idCOLON2);
            SET_LEX_STATE(EXPR_DOT);
            return tCOLON2;
        }
        if (IS_END() || ISSPACE(c) || c == '#') {
            pushback(p, c);
            c = warn_balanced(':', ":", "symbol literal");
            SET_LEX_STATE(EXPR_BEG);
            return c;
        }
        switch (c) {
          case '\'':
            p->lex.strterm = NEW_STRTERM(str_ssym, c, 0);
            break;
          case '"':
            p->lex.strterm = NEW_STRTERM(str_dsym, c, 0);
            break;
          default:
            pushback(p, c);
            break;
        }
        SET_LEX_STATE(EXPR_FNAME);
        return tSYMBEG;

      case '/':
        if (IS_BEG()) {
            p->lex.strterm = NEW_STRTERM(str_regexp, '/', 0);
            return tREGEXP_BEG;
        }
        if ((c = nextc(p)) == '=') {
            set_yylval_id('/');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        pushback(p, c);
        if (IS_SPCARG(c)) {
            arg_ambiguous(p, '/');
            p->lex.strterm = NEW_STRTERM(str_regexp, '/', 0);
            return tREGEXP_BEG;
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        return warn_balanced('/', "/", "regexp literal");

      case '^':
        if ((c = nextc(p)) == '=') {
            set_yylval_id('^');
            SET_LEX_STATE(EXPR_BEG);
            return tOP_ASGN;
        }
        SET_LEX_STATE(IS_AFTER_OPERATOR() ? EXPR_ARG : EXPR_BEG);
        pushback(p, c);
        return '^';

      case ';':
        SET_LEX_STATE(EXPR_BEG);
        p->command_start = TRUE;
        return ';';

      case ',':
        SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
        return ',';

      case '~':
        if (IS_AFTER_OPERATOR()) {
            if ((c = nextc(p)) != '@') {
                pushback(p, c);
            }
            SET_LEX_STATE(EXPR_ARG);
        }
        else {
            SET_LEX_STATE(EXPR_BEG);
        }
        return '~';

      case '(':
        if (IS_BEG()) {
            c = tLPAREN;
        }
        else if (!space_seen) {
            /* foo( ... ) => method call, no ambiguity */
        }
        else if (IS_ARG() || IS_lex_state_all(EXPR_END|EXPR_LABEL)) {
            c = tLPAREN_ARG;
        }
        else if (IS_lex_state(EXPR_ENDFN) && !lambda_beginning_p()) {
            rb_warning0("parentheses after method name is interpreted as "
                        "an argument list, not a decomposed argument");
        }
        p->lex.paren_nest++;
        COND_PUSH(0);
        CMDARG_PUSH(0);
        SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
        return c;

      case '[':
        p->lex.paren_nest++;
        if (IS_AFTER_OPERATOR()) {
            if ((c = nextc(p)) == ']') {
                p->lex.paren_nest--;
                SET_LEX_STATE(EXPR_ARG);
                if ((c = nextc(p)) == '=') {
                    return tASET;
                }
                pushback(p, c);
                return tAREF;
            }
            pushback(p, c);
            SET_LEX_STATE(EXPR_ARG|EXPR_LABEL);
            return '[';
        }
        else if (IS_BEG()) {
            c = tLBRACK;
        }
        else if (IS_ARG() && (space_seen || IS_lex_state(EXPR_LABELED))) {
            c = tLBRACK;
        }
        SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
        COND_PUSH(0);
        CMDARG_PUSH(0);
        return c;

      case '{':
        ++p->lex.brace_nest;
        if (lambda_beginning_p())
            c = tLAMBEG;
        else if (IS_lex_state(EXPR_LABELED))
            c = tLBRACE;      /* hash */
        else if (IS_lex_state(EXPR_ARG_ANY | EXPR_END | EXPR_ENDFN))
            c = '{';          /* block (primary) */
        else if (IS_lex_state(EXPR_ENDARG))
            c = tLBRACE_ARG;  /* block (expr) */
        else
            c = tLBRACE;      /* hash */
        if (c != tLBRACE) {
            p->command_start = TRUE;
            SET_LEX_STATE(EXPR_BEG);
        }
        else {
            SET_LEX_STATE(EXPR_BEG|EXPR_LABEL);
        }
        ++p->lex.paren_nest;  /* after lambda_beginning_p() */
        COND_PUSH(0);
        CMDARG_PUSH(0);
        return c;

      case '\\':
        c = nextc(p);
        if (c == '\n') {
            space_seen = 1;
            dispatch_scan_event(p, tSP);
            goto retry; /* skip \\n */
        }
        if (c == ' ') return tSP;
        if (ISSPACE(c)) return c;
        pushback(p, c);
        return '\\';

      case '%':
        return parse_percent(p, space_seen, last_state);

      case '$':
        return parse_gvar(p, last_state);

      case '@':
        return parse_atmark(p, last_state);

      case '_':
        if (was_bol(p) && whole_match_p(p, "__END__", 7, 0)) {
            p->ruby__end__seen = 1;
            p->eofp = 1;
#ifdef RIPPER
            lex_goto_eol(p);
            dispatch_scan_event(p, k__END__);
#endif
            return END_OF_INPUT;
        }
        newtok(p);
        break;

      default:
        if (!parser_is_identchar(p)) {
            compile_error(p, "Invalid char '\\x%02X' in expression", c);
            token_flush(p);
            goto retry;
        }

        newtok(p);
        break;
    }

    return parse_ident(p, c, cmd_state);
}

static enum yytokentype
yylex(YYSTYPE *lval, YYLTYPE *yylloc, struct parser_params *p)
{
    enum yytokentype t;

    p->lval = lval;
    lval->node = 0;
    p->yylloc = yylloc;

    t = parser_yylex(p);

    if (has_delayed_token(p))
        dispatch_delayed_token(p, t);
    else if (t != END_OF_INPUT)
        dispatch_scan_event(p, t);

    return t;
}

#define LVAR_USED ((ID)1 << (sizeof(ID) * CHAR_BIT - 1))

static NODE*
node_new_internal(struct parser_params *p, enum node_type type, size_t size, size_t alignment)
{
    NODE *n = rb_ast_newnode(p->ast, type, size, alignment);

    rb_node_init(n, type);
    return n;
}

static NODE *
nd_set_loc(NODE *nd, const YYLTYPE *loc)
{
    nd->nd_loc = *loc;
    nd_set_line(nd, loc->beg_pos.lineno);
    return nd;
}

static NODE*
node_newnode(struct parser_params *p, enum node_type type, size_t size, size_t alignment, const rb_code_location_t *loc)
{
    NODE *n = node_new_internal(p, type, size, alignment);

    nd_set_loc(n, loc);
    nd_set_node_id(n, parser_get_node_id(p));
    return n;
}

#define NODE_NEWNODE(node_type, type, loc) (type *)(node_newnode(p, node_type, sizeof(type), RUBY_ALIGNOF(type), loc))

static rb_node_scope_t *
rb_node_scope_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, NODE *nd_parent, const YYLTYPE *loc)
{
    rb_ast_id_table_t *nd_tbl;
    nd_tbl = local_tbl(p);
    rb_node_scope_t *n = NODE_NEWNODE(NODE_SCOPE, rb_node_scope_t, loc);
    n->nd_tbl = nd_tbl;
    n->nd_body = nd_body;
    n->nd_parent = nd_parent;
    n->nd_args = nd_args;

    return n;
}

static rb_node_scope_t *
rb_node_scope_new2(struct parser_params *p, rb_ast_id_table_t *nd_tbl, rb_node_args_t *nd_args, NODE *nd_body, NODE *nd_parent, const YYLTYPE *loc)
{
    rb_node_scope_t *n = NODE_NEWNODE(NODE_SCOPE, rb_node_scope_t, loc);
    n->nd_tbl = nd_tbl;
    n->nd_body = nd_body;
    n->nd_parent = nd_parent;
    n->nd_args = nd_args;

    return n;
}

static rb_node_defn_t *
rb_node_defn_new(struct parser_params *p, ID nd_mid, NODE *nd_defn, const YYLTYPE *loc)
{
    rb_node_defn_t *n = NODE_NEWNODE(NODE_DEFN, rb_node_defn_t, loc);
    n->nd_mid = nd_mid;
    n->nd_defn = nd_defn;

    return n;
}

static rb_node_defs_t *
rb_node_defs_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_defn, const YYLTYPE *loc)
{
    rb_node_defs_t *n = NODE_NEWNODE(NODE_DEFS, rb_node_defs_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_defn = nd_defn;

    return n;
}

static rb_node_block_t *
rb_node_block_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc)
{
    rb_node_block_t *n = NODE_NEWNODE(NODE_BLOCK, rb_node_block_t, loc);
    n->nd_head = nd_head;
    n->nd_end = (NODE *)n;
    n->nd_next = 0;

    return n;
}

static rb_node_for_t *
rb_node_for_new(struct parser_params *p, NODE *nd_iter, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *for_keyword_loc, const YYLTYPE *in_keyword_loc, const YYLTYPE *do_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    rb_node_for_t *n = NODE_NEWNODE(NODE_FOR, rb_node_for_t, loc);
    n->nd_body = nd_body;
    n->nd_iter = nd_iter;
    n->for_keyword_loc = *for_keyword_loc;
    n->in_keyword_loc = *in_keyword_loc;
    n->do_keyword_loc = *do_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_for_masgn_t *
rb_node_for_masgn_new(struct parser_params *p, NODE *nd_var, const YYLTYPE *loc)
{
    rb_node_for_masgn_t *n = NODE_NEWNODE(NODE_FOR_MASGN, rb_node_for_masgn_t, loc);
    n->nd_var = nd_var;

    return n;
}

static rb_node_retry_t *
rb_node_retry_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_retry_t *n = NODE_NEWNODE(NODE_RETRY, rb_node_retry_t, loc);

    return n;
}

static rb_node_begin_t *
rb_node_begin_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_begin_t *n = NODE_NEWNODE(NODE_BEGIN, rb_node_begin_t, loc);
    n->nd_body = nd_body;

    return n;
}

static rb_node_rescue_t *
rb_node_rescue_new(struct parser_params *p, NODE *nd_head, NODE *nd_resq, NODE *nd_else, const YYLTYPE *loc)
{
    rb_node_rescue_t *n = NODE_NEWNODE(NODE_RESCUE, rb_node_rescue_t, loc);
    n->nd_head = nd_head;
    n->nd_resq = nd_resq;
    n->nd_else = nd_else;

    return n;
}

static rb_node_resbody_t *
rb_node_resbody_new(struct parser_params *p, NODE *nd_args, NODE *nd_exc_var, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_resbody_t *n = NODE_NEWNODE(NODE_RESBODY, rb_node_resbody_t, loc);
    n->nd_args = nd_args;
    n->nd_exc_var = nd_exc_var;
    n->nd_body = nd_body;
    n->nd_next = nd_next;

    return n;
}

static rb_node_ensure_t *
rb_node_ensure_new(struct parser_params *p, NODE *nd_head, NODE *nd_ensr, const YYLTYPE *loc)
{
    rb_node_ensure_t *n = NODE_NEWNODE(NODE_ENSURE, rb_node_ensure_t, loc);
    n->nd_head = nd_head;
    n->nd_ensr = nd_ensr;

    return n;
}

static rb_node_and_t *
rb_node_and_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_and_t *n = NODE_NEWNODE(NODE_AND, rb_node_and_t, loc);
    n->nd_1st = nd_1st;
    n->nd_2nd = nd_2nd;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_or_t *
rb_node_or_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_or_t *n = NODE_NEWNODE(NODE_OR, rb_node_or_t, loc);
    n->nd_1st = nd_1st;
    n->nd_2nd = nd_2nd;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_return_t *
rb_node_return_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_return_t *n = NODE_NEWNODE(NODE_RETURN, rb_node_return_t, loc);
    n->nd_stts = nd_stts;
    n->keyword_loc = *keyword_loc;
    return n;
}

static rb_node_yield_t *
rb_node_yield_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *lparen_loc, const YYLTYPE *rparen_loc)
{
    if (nd_head) no_blockarg(p, nd_head);

    rb_node_yield_t *n = NODE_NEWNODE(NODE_YIELD, rb_node_yield_t, loc);
    n->nd_head = nd_head;
    n->keyword_loc = *keyword_loc;
    n->lparen_loc = *lparen_loc;
    n->rparen_loc = *rparen_loc;

    return n;
}

static rb_node_if_t *
rb_node_if_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, NODE *nd_else, const YYLTYPE *loc, const YYLTYPE* if_keyword_loc, const YYLTYPE* then_keyword_loc, const YYLTYPE* end_keyword_loc)
{
    rb_node_if_t *n = NODE_NEWNODE(NODE_IF, rb_node_if_t, loc);
    n->nd_cond = nd_cond;
    n->nd_body = nd_body;
    n->nd_else = nd_else;
    n->if_keyword_loc = *if_keyword_loc;
    n->then_keyword_loc = *then_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_unless_t *
rb_node_unless_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, NODE *nd_else, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *then_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    rb_node_unless_t *n = NODE_NEWNODE(NODE_UNLESS, rb_node_unless_t, loc);
    n->nd_cond = nd_cond;
    n->nd_body = nd_body;
    n->nd_else = nd_else;
    n->keyword_loc = *keyword_loc;
    n->then_keyword_loc = *then_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_class_t *
rb_node_class_new(struct parser_params *p, NODE *nd_cpath, NODE *nd_body, NODE *nd_super, const YYLTYPE *loc, const YYLTYPE *class_keyword_loc, const YYLTYPE *inheritance_operator_loc, const YYLTYPE *end_keyword_loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(0, nd_body, NULL, loc);
    rb_node_class_t *n = NODE_NEWNODE(NODE_CLASS, rb_node_class_t, loc);
    RNODE_SCOPE(scope)->nd_parent = &n->node;
    n->nd_cpath = nd_cpath;
    n->nd_body = scope;
    n->nd_super = nd_super;
    n->class_keyword_loc = *class_keyword_loc;
    n->inheritance_operator_loc = *inheritance_operator_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_sclass_t *
rb_node_sclass_new(struct parser_params *p, NODE *nd_recv, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *class_keyword_loc, const YYLTYPE *operator_loc, const YYLTYPE *end_keyword_loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(0, nd_body, NULL, loc);
    rb_node_sclass_t *n = NODE_NEWNODE(NODE_SCLASS, rb_node_sclass_t, loc);
    RNODE_SCOPE(scope)->nd_parent = &n->node;
    n->nd_recv = nd_recv;
    n->nd_body = scope;
    n->class_keyword_loc = *class_keyword_loc;
    n->operator_loc = *operator_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_module_t *
rb_node_module_new(struct parser_params *p, NODE *nd_cpath, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *module_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(0, nd_body, NULL, loc);
    rb_node_module_t *n = NODE_NEWNODE(NODE_MODULE, rb_node_module_t, loc);
    RNODE_SCOPE(scope)->nd_parent = &n->node;
    n->nd_cpath = nd_cpath;
    n->nd_body = scope;
    n->module_keyword_loc = *module_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_iter_t *
rb_node_iter_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(nd_args, nd_body, NULL, loc);
    rb_node_iter_t *n = NODE_NEWNODE(NODE_ITER, rb_node_iter_t, loc);
    RNODE_SCOPE(scope)->nd_parent = &n->node;
    n->nd_body = scope;
    n->nd_iter = 0;

    return n;
}

static rb_node_lambda_t *
rb_node_lambda_new(struct parser_params *p, rb_node_args_t *nd_args, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *operator_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc)
{
    /* Keep the order of node creation */
    NODE *scope = NEW_SCOPE(nd_args, nd_body, NULL, loc);
    YYLTYPE lambda_loc = code_loc_gen(operator_loc, closing_loc);
    rb_node_lambda_t *n = NODE_NEWNODE(NODE_LAMBDA, rb_node_lambda_t, &lambda_loc);
    RNODE_SCOPE(scope)->nd_parent = &n->node;
    n->nd_body = scope;
    n->operator_loc = *operator_loc;
    n->opening_loc = *opening_loc;
    n->closing_loc = *closing_loc;

    return n;
}

static rb_node_case_t *
rb_node_case_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    rb_node_case_t *n = NODE_NEWNODE(NODE_CASE, rb_node_case_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;
    n->case_keyword_loc = *case_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_case2_t *
rb_node_case2_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    rb_node_case2_t *n = NODE_NEWNODE(NODE_CASE2, rb_node_case2_t, loc);
    n->nd_head = 0;
    n->nd_body = nd_body;
    n->case_keyword_loc = *case_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_case3_t *
rb_node_case3_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *case_keyword_loc, const YYLTYPE *end_keyword_loc)
{
    rb_node_case3_t *n = NODE_NEWNODE(NODE_CASE3, rb_node_case3_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;
    n->case_keyword_loc = *case_keyword_loc;
    n->end_keyword_loc = *end_keyword_loc;

    return n;
}

static rb_node_when_t *
rb_node_when_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *then_keyword_loc)
{
    rb_node_when_t *n = NODE_NEWNODE(NODE_WHEN, rb_node_when_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;
    n->nd_next = nd_next;
    n->keyword_loc = *keyword_loc;
    n->then_keyword_loc = *then_keyword_loc;

    return n;
}

static rb_node_in_t *
rb_node_in_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, NODE *nd_next, const YYLTYPE *loc, const YYLTYPE *in_keyword_loc, const YYLTYPE *then_keyword_loc, const YYLTYPE *operator_loc)
{
    rb_node_in_t *n = NODE_NEWNODE(NODE_IN, rb_node_in_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;
    n->nd_next = nd_next;
    n->in_keyword_loc = *in_keyword_loc;
    n->then_keyword_loc = *then_keyword_loc;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_while_t *
rb_node_while_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, long nd_state, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *closing_loc)
{
    rb_node_while_t *n = NODE_NEWNODE(NODE_WHILE, rb_node_while_t, loc);
    n->nd_cond = nd_cond;
    n->nd_body = nd_body;
    n->nd_state = nd_state;
    n->keyword_loc = *keyword_loc;
    n->closing_loc = *closing_loc;

    return n;
}

static rb_node_until_t *
rb_node_until_new(struct parser_params *p, NODE *nd_cond, NODE *nd_body, long nd_state, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *closing_loc)
{
    rb_node_until_t *n = NODE_NEWNODE(NODE_UNTIL, rb_node_until_t, loc);
    n->nd_cond = nd_cond;
    n->nd_body = nd_body;
    n->nd_state = nd_state;
    n->keyword_loc = *keyword_loc;
    n->closing_loc = *closing_loc;

    return n;
}

static rb_node_colon2_t *
rb_node_colon2_new(struct parser_params *p, NODE *nd_head, ID nd_mid, const YYLTYPE *loc, const YYLTYPE *delimiter_loc, const YYLTYPE *name_loc)
{
    rb_node_colon2_t *n = NODE_NEWNODE(NODE_COLON2, rb_node_colon2_t, loc);
    n->nd_head = nd_head;
    n->nd_mid = nd_mid;
    n->delimiter_loc = *delimiter_loc;
    n->name_loc = *name_loc;

    return n;
}

static rb_node_colon3_t *
rb_node_colon3_new(struct parser_params *p, ID nd_mid, const YYLTYPE *loc, const YYLTYPE *delimiter_loc, const YYLTYPE *name_loc)
{
    rb_node_colon3_t *n = NODE_NEWNODE(NODE_COLON3, rb_node_colon3_t, loc);
    n->nd_mid = nd_mid;
    n->delimiter_loc = *delimiter_loc;
    n->name_loc = *name_loc;

    return n;
}

static rb_node_dot2_t *
rb_node_dot2_new(struct parser_params *p, NODE *nd_beg, NODE *nd_end, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_dot2_t *n = NODE_NEWNODE(NODE_DOT2, rb_node_dot2_t, loc);
    n->nd_beg = nd_beg;
    n->nd_end = nd_end;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_dot3_t *
rb_node_dot3_new(struct parser_params *p, NODE *nd_beg, NODE *nd_end, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_dot3_t *n = NODE_NEWNODE(NODE_DOT3, rb_node_dot3_t, loc);
    n->nd_beg = nd_beg;
    n->nd_end = nd_end;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_self_t *
rb_node_self_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_self_t *n = NODE_NEWNODE(NODE_SELF, rb_node_self_t, loc);
    n->nd_state = 1;

    return n;
}

static rb_node_nil_t *
rb_node_nil_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_nil_t *n = NODE_NEWNODE(NODE_NIL, rb_node_nil_t, loc);

    return n;
}

static rb_node_true_t *
rb_node_true_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_true_t *n = NODE_NEWNODE(NODE_TRUE, rb_node_true_t, loc);

    return n;
}

static rb_node_false_t *
rb_node_false_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_false_t *n = NODE_NEWNODE(NODE_FALSE, rb_node_false_t, loc);

    return n;
}

static rb_node_super_t *
rb_node_super_new(struct parser_params *p, NODE *nd_args, const YYLTYPE *loc,
                  const YYLTYPE *keyword_loc, const YYLTYPE *lparen_loc, const YYLTYPE *rparen_loc)
{
    rb_node_super_t *n = NODE_NEWNODE(NODE_SUPER, rb_node_super_t, loc);
    n->nd_args = nd_args;
    n->keyword_loc = *keyword_loc;
    n->lparen_loc = *lparen_loc;
    n->rparen_loc = *rparen_loc;

    return n;
}

static rb_node_zsuper_t *
rb_node_zsuper_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_zsuper_t *n = NODE_NEWNODE(NODE_ZSUPER, rb_node_zsuper_t, loc);

    return n;
}

static rb_node_match2_t *
rb_node_match2_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_match2_t *n = NODE_NEWNODE(NODE_MATCH2, rb_node_match2_t, loc);
    n->nd_recv = nd_recv;
    n->nd_value = nd_value;
    n->nd_args = 0;

    return n;
}

static rb_node_match3_t *
rb_node_match3_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_match3_t *n = NODE_NEWNODE(NODE_MATCH3, rb_node_match3_t, loc);
    n->nd_recv = nd_recv;
    n->nd_value = nd_value;

    return n;
}

/* TODO: Use union for NODE_LIST2 */
static rb_node_list_t *
rb_node_list_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc)
{
    rb_node_list_t *n = NODE_NEWNODE(NODE_LIST, rb_node_list_t, loc);
    n->nd_head = nd_head;
    n->as.nd_alen = 1;
    n->nd_next = 0;

    return n;
}

static rb_node_list_t *
rb_node_list_new2(struct parser_params *p, NODE *nd_head, long nd_alen, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_list_t *n = NODE_NEWNODE(NODE_LIST, rb_node_list_t, loc);
    n->nd_head = nd_head;
    n->as.nd_alen = nd_alen;
    n->nd_next = nd_next;

    return n;
}

static rb_node_zlist_t *
rb_node_zlist_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_zlist_t *n = NODE_NEWNODE(NODE_ZLIST, rb_node_zlist_t, loc);

    return n;
}

static rb_node_hash_t *
rb_node_hash_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc)
{
    rb_node_hash_t *n = NODE_NEWNODE(NODE_HASH, rb_node_hash_t, loc);
    n->nd_head = nd_head;
    n->nd_brace = 0;

    return n;
}

static rb_node_masgn_t *
rb_node_masgn_new(struct parser_params *p, NODE *nd_head, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_masgn_t *n = NODE_NEWNODE(NODE_MASGN, rb_node_masgn_t, loc);
    n->nd_head = nd_head;
    n->nd_value = 0;
    n->nd_args = nd_args;

    return n;
}

static rb_node_gasgn_t *
rb_node_gasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_gasgn_t *n = NODE_NEWNODE(NODE_GASGN, rb_node_gasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_lasgn_t *
rb_node_lasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_lasgn_t *n = NODE_NEWNODE(NODE_LASGN, rb_node_lasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_dasgn_t *
rb_node_dasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_dasgn_t *n = NODE_NEWNODE(NODE_DASGN, rb_node_dasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_iasgn_t *
rb_node_iasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_iasgn_t *n = NODE_NEWNODE(NODE_IASGN, rb_node_iasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_cvasgn_t *
rb_node_cvasgn_new(struct parser_params *p, ID nd_vid, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_cvasgn_t *n = NODE_NEWNODE(NODE_CVASGN, rb_node_cvasgn_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;

    return n;
}

static rb_node_op_asgn1_t *
rb_node_op_asgn1_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *index, NODE *rvalue, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc, const YYLTYPE *binary_operator_loc)
{
    rb_node_op_asgn1_t *n = NODE_NEWNODE(NODE_OP_ASGN1, rb_node_op_asgn1_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_index = index;
    n->nd_rvalue = rvalue;
    n->call_operator_loc = *call_operator_loc;
    n->opening_loc = *opening_loc;
    n->closing_loc = *closing_loc;
    n->binary_operator_loc = *binary_operator_loc;

    return n;
}

static rb_node_op_asgn2_t *
rb_node_op_asgn2_new(struct parser_params *p, NODE *nd_recv, NODE *nd_value, ID nd_vid, ID nd_mid, bool nd_aid, const YYLTYPE *loc, const YYLTYPE *call_operator_loc, const YYLTYPE *message_loc, const YYLTYPE *binary_operator_loc)
{
    rb_node_op_asgn2_t *n = NODE_NEWNODE(NODE_OP_ASGN2, rb_node_op_asgn2_t, loc);
    n->nd_recv = nd_recv;
    n->nd_value = nd_value;
    n->nd_vid = nd_vid;
    n->nd_mid = nd_mid;
    n->nd_aid = nd_aid;
    n->call_operator_loc = *call_operator_loc;
    n->message_loc = *message_loc;
    n->binary_operator_loc = *binary_operator_loc;

    return n;
}

static rb_node_op_asgn_or_t *
rb_node_op_asgn_or_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_op_asgn_or_t *n = NODE_NEWNODE(NODE_OP_ASGN_OR, rb_node_op_asgn_or_t, loc);
    n->nd_head = nd_head;
    n->nd_value = nd_value;

    return n;
}

static rb_node_op_asgn_and_t *
rb_node_op_asgn_and_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, const YYLTYPE *loc)
{
    rb_node_op_asgn_and_t *n = NODE_NEWNODE(NODE_OP_ASGN_AND, rb_node_op_asgn_and_t, loc);
    n->nd_head = nd_head;
    n->nd_value = nd_value;

    return n;
}

static rb_node_gvar_t *
rb_node_gvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_gvar_t *n = NODE_NEWNODE(NODE_GVAR, rb_node_gvar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_lvar_t *
rb_node_lvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_lvar_t *n = NODE_NEWNODE(NODE_LVAR, rb_node_lvar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_dvar_t *
rb_node_dvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_dvar_t *n = NODE_NEWNODE(NODE_DVAR, rb_node_dvar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_ivar_t *
rb_node_ivar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_ivar_t *n = NODE_NEWNODE(NODE_IVAR, rb_node_ivar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_const_t *
rb_node_const_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_const_t *n = NODE_NEWNODE(NODE_CONST, rb_node_const_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_cvar_t *
rb_node_cvar_new(struct parser_params *p, ID nd_vid, const YYLTYPE *loc)
{
    rb_node_cvar_t *n = NODE_NEWNODE(NODE_CVAR, rb_node_cvar_t, loc);
    n->nd_vid = nd_vid;

    return n;
}

static rb_node_nth_ref_t *
rb_node_nth_ref_new(struct parser_params *p, long nd_nth, const YYLTYPE *loc)
{
    rb_node_nth_ref_t *n = NODE_NEWNODE(NODE_NTH_REF, rb_node_nth_ref_t, loc);
    n->nd_nth = nd_nth;

    return n;
}

static rb_node_back_ref_t *
rb_node_back_ref_new(struct parser_params *p, long nd_nth, const YYLTYPE *loc)
{
    rb_node_back_ref_t *n = NODE_NEWNODE(NODE_BACK_REF, rb_node_back_ref_t, loc);
    n->nd_nth = nd_nth;

    return n;
}

static rb_node_integer_t *
rb_node_integer_new(struct parser_params *p, char* val, int base, const YYLTYPE *loc)
{
    rb_node_integer_t *n = NODE_NEWNODE(NODE_INTEGER, rb_node_integer_t, loc);
    n->val = val;
    n->minus = FALSE;
    n->base = base;

    return n;
}

static rb_node_float_t *
rb_node_float_new(struct parser_params *p, char* val, const YYLTYPE *loc)
{
    rb_node_float_t *n = NODE_NEWNODE(NODE_FLOAT, rb_node_float_t, loc);
    n->val = val;
    n->minus = FALSE;

    return n;
}

static rb_node_rational_t *
rb_node_rational_new(struct parser_params *p, char* val, int base, int seen_point, const YYLTYPE *loc)
{
    rb_node_rational_t *n = NODE_NEWNODE(NODE_RATIONAL, rb_node_rational_t, loc);
    n->val = val;
    n->minus = FALSE;
    n->base = base;
    n->seen_point = seen_point;

    return n;
}

static rb_node_imaginary_t *
rb_node_imaginary_new(struct parser_params *p, char* val, int base, int seen_point, enum rb_numeric_type numeric_type, const YYLTYPE *loc)
{
    rb_node_imaginary_t *n = NODE_NEWNODE(NODE_IMAGINARY, rb_node_imaginary_t, loc);
    n->val = val;
    n->minus = FALSE;
    n->base = base;
    n->seen_point = seen_point;
    n->type = numeric_type;

    return n;
}

static rb_node_str_t *
rb_node_str_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc)
{
    rb_node_str_t *n = NODE_NEWNODE(NODE_STR, rb_node_str_t, loc);
    n->string = string;

    return n;
}

/* TODO; Use union for NODE_DSTR2 */
static rb_node_dstr_t *
rb_node_dstr_new0(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_dstr_t *n = NODE_NEWNODE(NODE_DSTR, rb_node_dstr_t, loc);
    n->string = string;
    n->as.nd_alen = nd_alen;
    n->nd_next = (rb_node_list_t *)nd_next;

    return n;
}

static rb_node_dstr_t *
rb_node_dstr_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc)
{
    return rb_node_dstr_new0(p, string, 1, 0, loc);
}

static rb_node_xstr_t *
rb_node_xstr_new(struct parser_params *p, rb_parser_string_t *string, const YYLTYPE *loc)
{
    rb_node_xstr_t *n = NODE_NEWNODE(NODE_XSTR, rb_node_xstr_t, loc);
    n->string = string;

    return n;
}

static rb_node_dxstr_t *
rb_node_dxstr_new(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_dxstr_t *n = NODE_NEWNODE(NODE_DXSTR, rb_node_dxstr_t, loc);
    n->string = string;
    n->as.nd_alen = nd_alen;
    n->nd_next = (rb_node_list_t *)nd_next;

    return n;
}

static rb_node_sym_t *
rb_node_sym_new(struct parser_params *p, VALUE str, const YYLTYPE *loc)
{
    rb_node_sym_t *n = NODE_NEWNODE(NODE_SYM, rb_node_sym_t, loc);
    n->string = rb_str_to_parser_string(p, str);

    return n;
}

static rb_node_dsym_t *
rb_node_dsym_new(struct parser_params *p, rb_parser_string_t *string, long nd_alen, NODE *nd_next, const YYLTYPE *loc)
{
    rb_node_dsym_t *n = NODE_NEWNODE(NODE_DSYM, rb_node_dsym_t, loc);
    n->string = string;
    n->as.nd_alen = nd_alen;
    n->nd_next = (rb_node_list_t *)nd_next;

    return n;
}

static rb_node_evstr_t *
rb_node_evstr_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc)
{
    rb_node_evstr_t *n = NODE_NEWNODE(NODE_EVSTR, rb_node_evstr_t, loc);
    n->nd_body = nd_body;
    n->opening_loc = *opening_loc;
    n->closing_loc = *closing_loc;

    return n;
}

static rb_node_regx_t *
rb_node_regx_new(struct parser_params *p, rb_parser_string_t *string, int options, const YYLTYPE *loc, const YYLTYPE *opening_loc, const YYLTYPE *content_loc, const YYLTYPE *closing_loc)
{
    rb_node_regx_t *n = NODE_NEWNODE(NODE_REGX, rb_node_regx_t, loc);
    n->string = string;
    n->options = options & RE_OPTION_MASK;
    n->opening_loc = *opening_loc;
    n->content_loc = *content_loc;
    n->closing_loc = *closing_loc;

    return n;
}

static rb_node_call_t *
rb_node_call_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_call_t *n = NODE_NEWNODE(NODE_CALL, rb_node_call_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_opcall_t *
rb_node_opcall_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_opcall_t *n = NODE_NEWNODE(NODE_OPCALL, rb_node_opcall_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_fcall_t *
rb_node_fcall_new(struct parser_params *p, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_fcall_t *n = NODE_NEWNODE(NODE_FCALL, rb_node_fcall_t, loc);
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_qcall_t *
rb_node_qcall_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_qcall_t *n = NODE_NEWNODE(NODE_QCALL, rb_node_qcall_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_vcall_t *
rb_node_vcall_new(struct parser_params *p, ID nd_mid, const YYLTYPE *loc)
{
    rb_node_vcall_t *n = NODE_NEWNODE(NODE_VCALL, rb_node_vcall_t, loc);
    n->nd_mid = nd_mid;

    return n;
}

static rb_node_once_t *
rb_node_once_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_once_t *n = NODE_NEWNODE(NODE_ONCE, rb_node_once_t, loc);
    n->nd_body = nd_body;

    return n;
}

static rb_node_args_t *
rb_node_args_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_args_t *n = NODE_NEWNODE(NODE_ARGS, rb_node_args_t, loc);
    MEMZERO(&n->nd_ainfo, struct rb_args_info, 1);

    return n;
}

static rb_node_args_aux_t *
rb_node_args_aux_new(struct parser_params *p, ID nd_pid, int nd_plen, const YYLTYPE *loc)
{
    rb_node_args_aux_t *n = NODE_NEWNODE(NODE_ARGS_AUX, rb_node_args_aux_t, loc);
    n->nd_pid = nd_pid;
    n->nd_plen = nd_plen;
    n->nd_next = 0;

    return n;
}

static rb_node_opt_arg_t *
rb_node_opt_arg_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_opt_arg_t *n = NODE_NEWNODE(NODE_OPT_ARG, rb_node_opt_arg_t, loc);
    n->nd_body = nd_body;
    n->nd_next = 0;

    return n;
}

static rb_node_kw_arg_t *
rb_node_kw_arg_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_kw_arg_t *n = NODE_NEWNODE(NODE_KW_ARG, rb_node_kw_arg_t, loc);
    n->nd_body = nd_body;
    n->nd_next = 0;

    return n;
}

static rb_node_postarg_t *
rb_node_postarg_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc)
{
    rb_node_postarg_t *n = NODE_NEWNODE(NODE_POSTARG, rb_node_postarg_t, loc);
    n->nd_1st = nd_1st;
    n->nd_2nd = nd_2nd;

    return n;
}

static rb_node_argscat_t *
rb_node_argscat_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_argscat_t *n = NODE_NEWNODE(NODE_ARGSCAT, rb_node_argscat_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;

    return n;
}

static rb_node_argspush_t *
rb_node_argspush_new(struct parser_params *p, NODE *nd_head, NODE *nd_body, const YYLTYPE *loc)
{
    rb_node_argspush_t *n = NODE_NEWNODE(NODE_ARGSPUSH, rb_node_argspush_t, loc);
    n->nd_head = nd_head;
    n->nd_body = nd_body;

    return n;
}

static rb_node_splat_t *
rb_node_splat_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_splat_t *n = NODE_NEWNODE(NODE_SPLAT, rb_node_splat_t, loc);
    n->nd_head = nd_head;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_block_pass_t *
rb_node_block_pass_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *operator_loc)
{
    rb_node_block_pass_t *n = NODE_NEWNODE(NODE_BLOCK_PASS, rb_node_block_pass_t, loc);
    n->forwarding = 0;
    n->nd_head = 0;
    n->nd_body = nd_body;
    n->operator_loc = *operator_loc;

    return n;
}

static rb_node_alias_t *
rb_node_alias_new(struct parser_params *p, NODE *nd_1st, NODE *nd_2nd, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_alias_t *n = NODE_NEWNODE(NODE_ALIAS, rb_node_alias_t, loc);
    n->nd_1st = nd_1st;
    n->nd_2nd = nd_2nd;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_valias_t *
rb_node_valias_new(struct parser_params *p, ID nd_alias, ID nd_orig, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_valias_t *n = NODE_NEWNODE(NODE_VALIAS, rb_node_valias_t, loc);
    n->nd_alias = nd_alias;
    n->nd_orig = nd_orig;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_undef_t *
rb_node_undef_new(struct parser_params *p, NODE *nd_undef, const YYLTYPE *loc)
{
    rb_node_undef_t *n = NODE_NEWNODE(NODE_UNDEF, rb_node_undef_t, loc);
    n->nd_undefs = rb_parser_ary_new_capa_for_node(p, 1);
    n->keyword_loc = NULL_LOC;
    rb_parser_ary_push_node(p, n->nd_undefs, nd_undef);

    return n;
}

static rb_node_errinfo_t *
rb_node_errinfo_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_errinfo_t *n = NODE_NEWNODE(NODE_ERRINFO, rb_node_errinfo_t, loc);

    return n;
}

static rb_node_defined_t *
rb_node_defined_new(struct parser_params *p, NODE *nd_head, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_defined_t *n = NODE_NEWNODE(NODE_DEFINED, rb_node_defined_t, loc);
    n->nd_head = nd_head;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_postexe_t *
rb_node_postexe_new(struct parser_params *p, NODE *nd_body, const YYLTYPE *loc, const YYLTYPE *keyword_loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc)
{
    rb_node_postexe_t *n = NODE_NEWNODE(NODE_POSTEXE, rb_node_postexe_t, loc);
    n->nd_body = nd_body;
    n->keyword_loc = *keyword_loc;
    n->opening_loc = *opening_loc;
    n->closing_loc = *closing_loc;

    return n;
}

static rb_node_attrasgn_t *
rb_node_attrasgn_new(struct parser_params *p, NODE *nd_recv, ID nd_mid, NODE *nd_args, const YYLTYPE *loc)
{
    rb_node_attrasgn_t *n = NODE_NEWNODE(NODE_ATTRASGN, rb_node_attrasgn_t, loc);
    n->nd_recv = nd_recv;
    n->nd_mid = nd_mid;
    n->nd_args = nd_args;

    return n;
}

static rb_node_aryptn_t *
rb_node_aryptn_new(struct parser_params *p, NODE *pre_args, NODE *rest_arg, NODE *post_args, const YYLTYPE *loc)
{
    rb_node_aryptn_t *n = NODE_NEWNODE(NODE_ARYPTN, rb_node_aryptn_t, loc);
    n->nd_pconst = 0;
    n->pre_args = pre_args;
    n->rest_arg = rest_arg;
    n->post_args = post_args;

    return n;
}

static rb_node_hshptn_t *
rb_node_hshptn_new(struct parser_params *p, NODE *nd_pconst, NODE *nd_pkwargs, NODE *nd_pkwrestarg, const YYLTYPE *loc)
{
    rb_node_hshptn_t *n = NODE_NEWNODE(NODE_HSHPTN, rb_node_hshptn_t, loc);
    n->nd_pconst = nd_pconst;
    n->nd_pkwargs = nd_pkwargs;
    n->nd_pkwrestarg = nd_pkwrestarg;

    return n;
}

static rb_node_fndptn_t *
rb_node_fndptn_new(struct parser_params *p, NODE *pre_rest_arg, NODE *args, NODE *post_rest_arg, const YYLTYPE *loc)
{
    rb_node_fndptn_t *n = NODE_NEWNODE(NODE_FNDPTN, rb_node_fndptn_t, loc);
    n->nd_pconst = 0;
    n->pre_rest_arg = pre_rest_arg;
    n->args = args;
    n->post_rest_arg = post_rest_arg;

    return n;
}

static rb_node_line_t *
rb_node_line_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_line_t *n = NODE_NEWNODE(NODE_LINE, rb_node_line_t, loc);

    return n;
}

static rb_node_file_t *
rb_node_file_new(struct parser_params *p, VALUE str, const YYLTYPE *loc)
{
    rb_node_file_t *n = NODE_NEWNODE(NODE_FILE, rb_node_file_t, loc);
    n->path = rb_str_to_parser_string(p, str);

    return n;
}

static rb_node_encoding_t *
rb_node_encoding_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_encoding_t *n = NODE_NEWNODE(NODE_ENCODING, rb_node_encoding_t, loc);
    n->enc = p->enc;

    return n;
}

static rb_node_cdecl_t *
rb_node_cdecl_new(struct parser_params *p, ID nd_vid, NODE *nd_value, NODE *nd_else, enum rb_parser_shareability shareability, const YYLTYPE *loc)
{
    rb_node_cdecl_t *n = NODE_NEWNODE(NODE_CDECL, rb_node_cdecl_t, loc);
    n->nd_vid = nd_vid;
    n->nd_value = nd_value;
    n->nd_else = nd_else;
    n->shareability = shareability;

    return n;
}

static rb_node_op_cdecl_t *
rb_node_op_cdecl_new(struct parser_params *p, NODE *nd_head, NODE *nd_value, ID nd_aid, enum rb_parser_shareability shareability, const YYLTYPE *loc)
{
    rb_node_op_cdecl_t *n = NODE_NEWNODE(NODE_OP_CDECL, rb_node_op_cdecl_t, loc);
    n->nd_head = nd_head;
    n->nd_value = nd_value;
    n->nd_aid = nd_aid;
    n->shareability = shareability;

    return n;
}

static rb_node_error_t *
rb_node_error_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_error_t *n = NODE_NEWNODE(NODE_ERROR, rb_node_error_t, loc);

    return n;
}

static rb_node_break_t *
rb_node_break_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_break_t *n = NODE_NEWNODE(NODE_BREAK, rb_node_break_t, loc);
    n->nd_stts = nd_stts;
    n->nd_chain = 0;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_next_t *
rb_node_next_new(struct parser_params *p, NODE *nd_stts, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_next_t *n = NODE_NEWNODE(NODE_NEXT, rb_node_next_t, loc);
    n->nd_stts = nd_stts;
    n->nd_chain = 0;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_redo_t *
rb_node_redo_new(struct parser_params *p, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    rb_node_redo_t *n = NODE_NEWNODE(NODE_REDO, rb_node_redo_t, loc);
    n->nd_chain = 0;
    n->keyword_loc = *keyword_loc;

    return n;
}

static rb_node_def_temp_t *
rb_node_def_temp_new(struct parser_params *p, const YYLTYPE *loc)
{
    rb_node_def_temp_t *n = NODE_NEWNODE((enum node_type)NODE_DEF_TEMP, rb_node_def_temp_t, loc);
    n->save.numparam_save = 0;
    n->save.max_numparam = 0;
    n->save.ctxt = p->ctxt;
    n->nd_def = 0;
    n->nd_mid = 0;

    return n;
}

static rb_node_def_temp_t *
def_head_save(struct parser_params *p, rb_node_def_temp_t *n)
{
    n->save.numparam_save = numparam_push(p);
    n->save.max_numparam = p->max_numparam;
    return n;
}

#ifndef RIPPER
static enum node_type
nodetype(NODE *node)			/* for debug */
{
    return (enum node_type)nd_type(node);
}

static int
nodeline(NODE *node)
{
    return nd_line(node);
}
#endif

static NODE*
newline_node(NODE *node)
{
    if (node) {
        node = remove_begin(node);
        nd_set_fl_newline(node);
    }
    return node;
}

static void
fixpos(NODE *node, NODE *orig)
{
    if (!node) return;
    if (!orig) return;
    nd_set_line(node, nd_line(orig));
}

static NODE*
block_append(struct parser_params *p, NODE *head, NODE *tail)
{
    NODE *end, *h = head, *nd;

    if (tail == 0) return head;

    if (h == 0) return tail;
    switch (nd_type(h)) {
      default:
        h = end = NEW_BLOCK(head, &head->nd_loc);
        head = end;
        break;
      case NODE_BLOCK:
        end = RNODE_BLOCK(h)->nd_end;
        break;
    }

    nd = RNODE_BLOCK(end)->nd_head;
    switch (nd_type(nd)) {
      case NODE_RETURN:
      case NODE_BREAK:
      case NODE_NEXT:
      case NODE_REDO:
      case NODE_RETRY:
        rb_warning0L(nd_line(tail), "statement not reached");
        break;

      default:
        break;
    }

    if (!nd_type_p(tail, NODE_BLOCK)) {
        tail = NEW_BLOCK(tail, &tail->nd_loc);
    }
    RNODE_BLOCK(end)->nd_next = tail;
    RNODE_BLOCK(h)->nd_end = RNODE_BLOCK(tail)->nd_end;
    nd_set_last_loc(head, nd_last_loc(tail));
    return head;
}

/* append item to the list */
static NODE*
list_append(struct parser_params *p, NODE *list, NODE *item)
{
    NODE *last;

    if (list == 0) return NEW_LIST(item, &item->nd_loc);
    if (RNODE_LIST(list)->nd_next) {
        last = RNODE_LIST(RNODE_LIST(list)->nd_next)->as.nd_end;
    }
    else {
        last = list;
    }

    RNODE_LIST(list)->as.nd_alen += 1;
    RNODE_LIST(last)->nd_next = NEW_LIST(item, &item->nd_loc);
    RNODE_LIST(RNODE_LIST(list)->nd_next)->as.nd_end = RNODE_LIST(last)->nd_next;

    nd_set_last_loc(list, nd_last_loc(item));

    return list;
}

/* concat two lists */
static NODE*
list_concat(NODE *head, NODE *tail)
{
    NODE *last;

    if (RNODE_LIST(head)->nd_next) {
        last = RNODE_LIST(RNODE_LIST(head)->nd_next)->as.nd_end;
    }
    else {
        last = head;
    }

    RNODE_LIST(head)->as.nd_alen += RNODE_LIST(tail)->as.nd_alen;
    RNODE_LIST(last)->nd_next = tail;
    if (RNODE_LIST(tail)->nd_next) {
        RNODE_LIST(RNODE_LIST(head)->nd_next)->as.nd_end = RNODE_LIST(RNODE_LIST(tail)->nd_next)->as.nd_end;
    }
    else {
        RNODE_LIST(RNODE_LIST(head)->nd_next)->as.nd_end = tail;
    }

    nd_set_last_loc(head, nd_last_loc(tail));

    return head;
}

static int
literal_concat0(struct parser_params *p, rb_parser_string_t *head, rb_parser_string_t *tail)
{
    if (!tail) return 1;
    if (!rb_parser_enc_compatible(p, head, tail)) {
        compile_error(p, "string literal encodings differ (%s / %s)",
                      rb_enc_name(rb_parser_str_get_encoding(head)),
                      rb_enc_name(rb_parser_str_get_encoding(tail)));
        rb_parser_str_resize(p, head, 0);
        rb_parser_str_resize(p, tail, 0);
        return 0;
    }
    rb_parser_str_buf_append(p, head, tail);
    return 1;
}

static rb_parser_string_t *
string_literal_head(struct parser_params *p, enum node_type htype, NODE *head)
{
    if (htype != NODE_DSTR) return NULL;
    if (RNODE_DSTR(head)->nd_next) {
        head = RNODE_LIST(RNODE_LIST(RNODE_DSTR(head)->nd_next)->as.nd_end)->nd_head;
        if (!head || !nd_type_p(head, NODE_STR)) return NULL;
    }
    rb_parser_string_t *lit = RNODE_DSTR(head)->string;
    ASSUME(lit);
    return lit;
}

#ifndef RIPPER
static rb_parser_string_t *
rb_parser_string_deep_copy(struct parser_params *p, const rb_parser_string_t *orig)
{
    rb_parser_string_t *copy;
    if (!orig) return NULL;
    copy = rb_parser_string_new(p, PARSER_STRING_PTR(orig), PARSER_STRING_LEN(orig));
    copy->coderange = orig->coderange;
    copy->enc = orig->enc;
    return copy;
}
#endif

/* concat two string literals */
static NODE *
literal_concat(struct parser_params *p, NODE *head, NODE *tail, const YYLTYPE *loc)
{
    enum node_type htype;
    rb_parser_string_t *lit;

    if (!head) return tail;
    if (!tail) return head;

    htype = nd_type(head);
    if (htype == NODE_EVSTR) {
        head = new_dstr(p, head, loc);
        htype = NODE_DSTR;
    }
    if (p->heredoc_indent > 0) {
        switch (htype) {
          case NODE_STR:
            head = str2dstr(p, head);
          case NODE_DSTR:
            return list_append(p, head, tail);
          default:
            break;
        }
    }
    switch (nd_type(tail)) {
      case NODE_STR:
        if ((lit = string_literal_head(p, htype, head)) != false) {
            htype = NODE_STR;
        }
        else {
            lit = RNODE_DSTR(head)->string;
        }
        if (htype == NODE_STR) {
            if (!literal_concat0(p, lit, RNODE_STR(tail)->string)) {
              error:
                rb_discard_node(p, head);
                rb_discard_node(p, tail);
                return 0;
            }
            rb_discard_node(p, tail);
        }
        else {
            list_append(p, head, tail);
        }
        break;

      case NODE_DSTR:
        if (htype == NODE_STR) {
            if (!literal_concat0(p, RNODE_STR(head)->string, RNODE_DSTR(tail)->string))
                goto error;
            rb_parser_string_free(p, RNODE_DSTR(tail)->string);
            RNODE_DSTR(tail)->string = RNODE_STR(head)->string;
            RNODE_STR(head)->string = NULL;
            rb_discard_node(p, head);
            head = tail;
        }
        else if (!RNODE_DSTR(tail)->string) {
          append:
            RNODE_DSTR(head)->as.nd_alen += RNODE_DSTR(tail)->as.nd_alen - 1;
            if (!RNODE_DSTR(head)->nd_next) {
                RNODE_DSTR(head)->nd_next = RNODE_DSTR(tail)->nd_next;
            }
            else if (RNODE_DSTR(tail)->nd_next) {
                RNODE_DSTR(RNODE_DSTR(RNODE_DSTR(head)->nd_next)->as.nd_end)->nd_next = RNODE_DSTR(tail)->nd_next;
                RNODE_DSTR(RNODE_DSTR(head)->nd_next)->as.nd_end = RNODE_DSTR(RNODE_DSTR(tail)->nd_next)->as.nd_end;
            }
            rb_discard_node(p, tail);
        }
        else if ((lit = string_literal_head(p, htype, head)) != false) {
            if (!literal_concat0(p, lit, RNODE_DSTR(tail)->string))
                goto error;
            rb_parser_string_free(p, RNODE_DSTR(tail)->string);
            RNODE_DSTR(tail)->string = 0;
            goto append;
        }
        else {
            list_concat(head, NEW_LIST2(NEW_STR(RNODE_DSTR(tail)->string, loc), RNODE_DSTR(tail)->as.nd_alen, (NODE *)RNODE_DSTR(tail)->nd_next, loc));
            RNODE_DSTR(tail)->string = 0;
        }
        break;

      case NODE_EVSTR:
        if (htype == NODE_STR) {
            head = str2dstr(p, head);
            RNODE_DSTR(head)->as.nd_alen = 1;
        }
        list_append(p, head, tail);
        break;
    }
    return head;
}

static void
nd_copy_flag(NODE *new_node, NODE *old_node)
{
    if (nd_fl_newline(old_node)) nd_set_fl_newline(new_node);
    nd_set_line(new_node, nd_line(old_node));
    new_node->nd_loc = old_node->nd_loc;
    new_node->node_id = old_node->node_id;
}

static NODE *
str2dstr(struct parser_params *p, NODE *node)
{
    NODE *new_node = (NODE *)NODE_NEW_INTERNAL(NODE_DSTR, rb_node_dstr_t);
    nd_copy_flag(new_node, node);
    RNODE_DSTR(new_node)->string = RNODE_STR(node)->string;
    RNODE_DSTR(new_node)->as.nd_alen = 0;
    RNODE_DSTR(new_node)->nd_next = 0;
    RNODE_STR(node)->string = 0;

    return new_node;
}

static NODE *
str2regx(struct parser_params *p, NODE *node, int options, const YYLTYPE *loc, const YYLTYPE *opening_loc, const YYLTYPE *content_loc, const YYLTYPE *closing_loc)
{
    NODE *new_node = (NODE *)NODE_NEW_INTERNAL(NODE_REGX, rb_node_regx_t);
    nd_copy_flag(new_node, node);
    RNODE_REGX(new_node)->string = RNODE_STR(node)->string;
    RNODE_REGX(new_node)->options = options;
    nd_set_loc(new_node, loc);
    RNODE_REGX(new_node)->opening_loc = *opening_loc;
    RNODE_REGX(new_node)->content_loc = *content_loc;
    RNODE_REGX(new_node)->closing_loc = *closing_loc;
    RNODE_STR(node)->string = 0;

    return new_node;
}

static NODE *
evstr2dstr(struct parser_params *p, NODE *node)
{
    if (nd_type_p(node, NODE_EVSTR)) {
        node = new_dstr(p, node, &node->nd_loc);
    }
    return node;
}

static NODE *
new_evstr(struct parser_params *p, NODE *node, const YYLTYPE *loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc)
{
    NODE *head = node;

    if (node) {
        switch (nd_type(node)) {
          case NODE_STR:
            return str2dstr(p, node);
          case NODE_DSTR:
            break;
          case NODE_EVSTR:
            return node;
        }
    }
    return NEW_EVSTR(head, loc, opening_loc, closing_loc);
}

static NODE *
new_dstr(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    NODE *dstr = NEW_DSTR(STRING_NEW0(), loc);
    return list_append(p, dstr, node);
}

static NODE *
call_bin_op(struct parser_params *p, NODE *recv, ID id, NODE *arg1,
                const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *expr;
    value_expr(p, recv);
    value_expr(p, arg1);
    expr = NEW_OPCALL(recv, id, NEW_LIST(arg1, &arg1->nd_loc), loc);
    nd_set_line(expr, op_loc->beg_pos.lineno);
    return expr;
}

static NODE *
call_uni_op(struct parser_params *p, NODE *recv, ID id, const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *opcall;
    value_expr(p, recv);
    opcall = NEW_OPCALL(recv, id, 0, loc);
    nd_set_line(opcall, op_loc->beg_pos.lineno);
    return opcall;
}

static NODE *
new_qcall(struct parser_params* p, ID atype, NODE *recv, ID mid, NODE *args, const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *qcall = NEW_QCALL(atype, recv, mid, args, loc);
    nd_set_line(qcall, op_loc->beg_pos.lineno);
    return qcall;
}

static NODE*
new_command_qcall(struct parser_params* p, ID atype, NODE *recv, ID mid, NODE *args, NODE *block, const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *ret;
    if (block) block_dup_check(p, args, block);
    ret = new_qcall(p, atype, recv, mid, args, op_loc, loc);
    if (block) ret = method_add_block(p, ret, block, loc);
    fixpos(ret, recv);
    return ret;
}

static rb_locations_lambda_body_t*
new_locations_lambda_body(struct parser_params* p, NODE *node, const YYLTYPE *loc, const YYLTYPE *opening_loc, const YYLTYPE *closing_loc)
{
    rb_locations_lambda_body_t *body = xcalloc(1, sizeof(rb_locations_lambda_body_t));
    body->node = node;
    body->opening_loc = *opening_loc;
    body->closing_loc = *closing_loc;
    return body;
}

#define nd_once_body(node) (nd_type_p((node), NODE_ONCE) ? RNODE_ONCE(node)->nd_body : node)

static NODE*
last_expr_once_body(NODE *node)
{
    if (!node) return 0;
    return nd_once_body(node);
}

static NODE*
match_op(struct parser_params *p, NODE *node1, NODE *node2, const YYLTYPE *op_loc, const YYLTYPE *loc)
{
    NODE *n;
    int line = op_loc->beg_pos.lineno;

    value_expr(p, node1);
    value_expr(p, node2);

    if ((n = last_expr_once_body(node1)) != 0) {
        switch (nd_type(n)) {
          case NODE_DREGX:
            {
                NODE *match = NEW_MATCH2(node1, node2, loc);
                nd_set_line(match, line);
                return match;
            }

          case NODE_REGX:
            {
                const VALUE lit = rb_node_regx_string_val(n);
                if (!NIL_P(lit)) {
                    NODE *match = NEW_MATCH2(node1, node2, loc);
                    RNODE_MATCH2(match)->nd_args = reg_named_capture_assign(p, lit, loc, assignable);
                    nd_set_line(match, line);
                    return match;
                }
            }
        }
    }

    if ((n = last_expr_once_body(node2)) != 0) {
        NODE *match3;

        switch (nd_type(n)) {
          case NODE_DREGX:
            match3 = NEW_MATCH3(node2, node1, loc);
            return match3;
        }
    }

    n = NEW_CALL(node1, tMATCH, NEW_LIST(node2, &node2->nd_loc), loc);
    nd_set_line(n, line);
    return n;
}

# if WARN_PAST_SCOPE
static int
past_dvar_p(struct parser_params *p, ID id)
{
    struct vtable *past = p->lvtbl->past;
    while (past) {
        if (vtable_included(past, id)) return 1;
        past = past->prev;
    }
    return 0;
}
# endif

static int
numparam_nested_p(struct parser_params *p)
{
    struct local_vars *local = p->lvtbl;
    NODE *outer = local->numparam.outer;
    NODE *inner = local->numparam.inner;
    if (outer || inner) {
        NODE *used = outer ? outer : inner;
        compile_error(p, "numbered parameter is already used in %s block\n"
                      "%s:%d: numbered parameter is already used here",
                      outer ? "outer" : "inner",
                      p->ruby_sourcefile, nd_line(used));
        parser_show_error_line(p, &used->nd_loc);
        return 1;
    }
    return 0;
}

static int
numparam_used_p(struct parser_params *p)
{
    NODE *numparam = p->lvtbl->numparam.current;
    if (numparam) {
        compile_error(p, "'it' is not allowed when a numbered parameter is already used\n"
                      "%s:%d: numbered parameter is already used here",
                      p->ruby_sourcefile, nd_line(numparam));
        parser_show_error_line(p, &numparam->nd_loc);
        return 1;
    }
    return 0;
}

static int
it_used_p(struct parser_params *p)
{
    NODE *it = p->lvtbl->it;
    if (it) {
        compile_error(p, "numbered parameters are not allowed when 'it' is already used\n"
                      "%s:%d: 'it' is already used here",
                      p->ruby_sourcefile, nd_line(it));
        parser_show_error_line(p, &it->nd_loc);
        return 1;
    }
    return 0;
}

static NODE*
gettable(struct parser_params *p, ID id, const YYLTYPE *loc)
{
    ID *vidp = NULL;
    NODE *node;
    switch (id) {
      case keyword_self:
        return NEW_SELF(loc);
      case keyword_nil:
        return NEW_NIL(loc);
      case keyword_true:
        return NEW_TRUE(loc);
      case keyword_false:
        return NEW_FALSE(loc);
      case keyword__FILE__:
        {
            VALUE file = p->ruby_sourcefile_string;
            if (NIL_P(file))
                file = rb_str_new(0, 0);
            node = NEW_FILE(file, loc);
        }
        return node;
      case keyword__LINE__:
        return NEW_LINE(loc);
      case keyword__ENCODING__:
        return NEW_ENCODING(loc);

    }
    switch (id_type(id)) {
      case ID_LOCAL:
        if (dyna_in_block(p) && dvar_defined_ref(p, id, &vidp)) {
            if (NUMPARAM_ID_P(id) && (numparam_nested_p(p) || it_used_p(p))) return 0;
            if (vidp) *vidp |= LVAR_USED;
            node = NEW_DVAR(id, loc);
            return node;
        }
        if (local_id_ref(p, id, &vidp)) {
            if (vidp) *vidp |= LVAR_USED;
            node = NEW_LVAR(id, loc);
            return node;
        }
        if (dyna_in_block(p) && NUMPARAM_ID_P(id) &&
            parser_numbered_param(p, NUMPARAM_ID_TO_IDX(id))) {
            if (numparam_nested_p(p) || it_used_p(p)) return 0;
            node = NEW_DVAR(id, loc);
            struct local_vars *local = p->lvtbl;
            if (!local->numparam.current) local->numparam.current = node;
            return node;
        }
# if WARN_PAST_SCOPE
        if (!p->ctxt.in_defined && RTEST(ruby_verbose) && past_dvar_p(p, id)) {
            rb_warning1("possible reference to past scope - %"PRIsWARN, rb_id2str(id));
        }
# endif
        /* method call without arguments */
        if (dyna_in_block(p) && id == idIt && !(DVARS_TERMINAL_P(p->lvtbl->args) || DVARS_TERMINAL_P(p->lvtbl->args->prev))) {
            if (numparam_used_p(p)) return 0;
            if (p->max_numparam == ORDINAL_PARAM) {
                compile_error(p, "ordinary parameter is defined");
                return 0;
            }
            if (!p->it_id) {
                p->it_id = idItImplicit;
                vtable_add(p->lvtbl->args, p->it_id);
            }
            NODE *node = NEW_DVAR(p->it_id, loc);
            if (!p->lvtbl->it) p->lvtbl->it = node;
            return node;
        }
        return NEW_VCALL(id, loc);
      case ID_GLOBAL:
        return NEW_GVAR(id, loc);
      case ID_INSTANCE:
        return NEW_IVAR(id, loc);
      case ID_CONST:
        return NEW_CONST(id, loc);
      case ID_CLASS:
        return NEW_CVAR(id, loc);
    }
    compile_error(p, "identifier %"PRIsVALUE" is not valid to get", rb_id2str(id));
    return 0;
}

static rb_node_opt_arg_t *
opt_arg_append(rb_node_opt_arg_t *opt_list, rb_node_opt_arg_t *opt)
{
    rb_node_opt_arg_t *opts = opt_list;
    RNODE(opts)->nd_loc.end_pos = RNODE(opt)->nd_loc.end_pos;

    while (opts->nd_next) {
        opts = opts->nd_next;
        RNODE(opts)->nd_loc.end_pos = RNODE(opt)->nd_loc.end_pos;
    }
    opts->nd_next = opt;

    return opt_list;
}

static rb_node_kw_arg_t *
kwd_append(rb_node_kw_arg_t *kwlist, rb_node_kw_arg_t *kw)
{
    if (kwlist) {
        /* Assume rb_node_kw_arg_t and rb_node_opt_arg_t has same structure */
        opt_arg_append(RNODE_OPT_ARG(kwlist), RNODE_OPT_ARG(kw));
    }
    return kwlist;
}

static NODE *
new_defined(struct parser_params *p, NODE *expr, const YYLTYPE *loc, const YYLTYPE *keyword_loc)
{
    int had_trailing_semicolon = p->ctxt.has_trailing_semicolon;
    p->ctxt.has_trailing_semicolon = 0;

    NODE *n = expr;
    while (n) {
        if (nd_type_p(n, NODE_BEGIN)) {
            n = RNODE_BEGIN(n)->nd_body;
        }
        else if (nd_type_p(n, NODE_BLOCK) && RNODE_BLOCK(n)->nd_end == n) {
            n = RNODE_BLOCK(n)->nd_head;
        }
        else {
            break;
        }
    }

    if (had_trailing_semicolon && !nd_type_p(expr, NODE_BLOCK)) {
        NODE *block = NEW_BLOCK(expr, loc);
        return NEW_DEFINED(block, loc, keyword_loc);
    }

    return NEW_DEFINED(n, loc, keyword_loc);
}

static NODE*
str_to_sym_node(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    VALUE lit;
    rb_parser_string_t *str = RNODE_STR(node)->string;
    if (rb_parser_enc_str_coderange(p, str) == RB_PARSER_ENC_CODERANGE_BROKEN) {
        yyerror1(loc, "invalid symbol");
        lit = STR_NEW0();
    }
    else {
        lit = rb_str_new_parser_string(str);
    }
    return NEW_SYM(lit, loc);
}

static NODE*
symbol_append(struct parser_params *p, NODE *symbols, NODE *symbol)
{
    enum node_type type = nd_type(symbol);
    switch (type) {
      case NODE_DSTR:
        nd_set_type(symbol, NODE_DSYM);
        break;
      case NODE_STR:
        symbol = str_to_sym_node(p, symbol, &RNODE(symbol)->nd_loc);
        break;
      default:
        compile_error(p, "unexpected node as symbol: %s", parser_node_name(type));
    }
    return list_append(p, symbols, symbol);
}

static void
dregex_fragment_setenc(struct parser_params *p, rb_node_dregx_t *const dreg, int options)
{
    if (dreg->string) {
        reg_fragment_setenc(p, dreg->string, options);
    }
    for (struct RNode_LIST *list = dreg->nd_next; list; list = RNODE_LIST(list->nd_next)) {
        NODE *frag = list->nd_head;
        if (nd_type_p(frag, NODE_STR)) {
            reg_fragment_setenc(p, RNODE_STR(frag)->string, options);
        }
        else if (nd_type_p(frag, NODE_DSTR)) {
            dregex_fragment_setenc(p, RNODE_DSTR(frag), options);
        }
    }
}

static NODE *
new_regexp(struct parser_params *p, NODE *node, int options, const YYLTYPE *loc, const YYLTYPE *opening_loc, const YYLTYPE *content_loc, const YYLTYPE *closing_loc)
{
    if (!node) {
        /* Check string is valid regex */
        rb_parser_string_t *str = STRING_NEW0();
        reg_compile(p, str, options);
        node = NEW_REGX(str, options, loc, opening_loc, content_loc, closing_loc);
        return node;
    }
    switch (nd_type(node)) {
      case NODE_STR:
        {
            /* Check string is valid regex */
            reg_compile(p, RNODE_STR(node)->string, options);
            node = str2regx(p, node, options, loc, opening_loc, content_loc, closing_loc);
        }
        break;
      default:
        node = NEW_DSTR0(STRING_NEW0(), 1, NEW_LIST(node, loc), loc);
        /* fall through */
      case NODE_DSTR:
        nd_set_type(node, NODE_DREGX);
        nd_set_loc(node, loc);
        rb_node_dregx_t *const dreg = RNODE_DREGX(node);
        dreg->as.nd_cflag = options & RE_OPTION_MASK;
        if (dreg->nd_next) {
            dregex_fragment_setenc(p, dreg, options);
        }
        if (options & RE_OPTION_ONCE) {
            node = NEW_ONCE(node, loc);
        }
        break;
    }
    return node;
}

static rb_node_kw_arg_t *
new_kw_arg(struct parser_params *p, NODE *k, const YYLTYPE *loc)
{
    if (!k) return 0;
    return NEW_KW_ARG((k), loc);
}

static NODE *
new_xstring(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    if (!node) {
        NODE *xstr = NEW_XSTR(STRING_NEW0(), loc);
        return xstr;
    }
    switch (nd_type(node)) {
      case NODE_STR:
        nd_set_type(node, NODE_XSTR);
        nd_set_loc(node, loc);
        break;
      case NODE_DSTR:
        nd_set_type(node, NODE_DXSTR);
        nd_set_loc(node, loc);
        break;
      default:
        node = NEW_DXSTR(0, 1, NEW_LIST(node, loc), loc);
        break;
    }
    return node;
}

static const
struct st_hash_type literal_type = {
    literal_cmp,
    literal_hash,
};

static int nd_type_st_key_enable_p(NODE *node);

static void
check_literal_when(struct parser_params *p, NODE *arg, const YYLTYPE *loc)
{
    /* See https://bugs.ruby-lang.org/issues/20331 for discussion about what is warned. */
    if (!arg || !p->case_labels) return;
    if (!nd_type_st_key_enable_p(arg)) return;

    if (p->case_labels == CHECK_LITERAL_WHEN) {
        p->case_labels = st_init_table(&literal_type);
    }
    else {
        st_data_t line;
        if (st_lookup(p->case_labels, (st_data_t)arg, &line)) {
            rb_warning2("'when' clause on line %d duplicates 'when' clause on line %d and is ignored",
                        WARN_I((int)nd_line(arg)), WARN_I((int)line));
            return;
        }
    }
    st_insert(p->case_labels, (st_data_t)arg, (st_data_t)p->ruby_sourceline);
}

#ifdef RIPPER
static int
id_is_var(struct parser_params *p, ID id)
{
    if (is_notop_id(id)) {
        switch (id & ID_SCOPE_MASK) {
          case ID_GLOBAL: case ID_INSTANCE: case ID_CONST: case ID_CLASS:
            return 1;
          case ID_LOCAL:
            if (dyna_in_block(p)) {
                if (NUMPARAM_ID_P(id) || dvar_defined(p, id)) return 1;
            }
            if (local_id(p, id)) return 1;
            /* method call without arguments */
            return 0;
        }
    }
    compile_error(p, "identifier %"PRIsVALUE" is not valid to get", rb_id2str(id));
    return 0;
}
#endif

static inline enum lex_state_e
parser_set_lex_state(struct parser_params *p, enum lex_state_e ls, int line)
{
    if (p->debug) {
        ls = rb_parser_trace_lex_state(p, p->lex.state, ls, line);
    }
    return p->lex.state = ls;
}

#ifndef RIPPER
static void
flush_debug_buffer(struct parser_params *p, VALUE out, VALUE str)
{
    VALUE mesg = p->debug_buffer;

    if (!NIL_P(mesg) && RSTRING_LEN(mesg)) {
        p->debug_buffer = Qnil;
        rb_io_puts(1, &mesg, out);
    }
    if (!NIL_P(str) && RSTRING_LEN(str)) {
        rb_io_write(p->debug_output, str);
    }
}

static const char rb_parser_lex_state_names[][8] = {
    "BEG",    "END",    "ENDARG", "ENDFN",  "ARG",
    "CMDARG", "MID",    "FNAME",  "DOT",    "CLASS",
    "LABEL",  "LABELED","FITEM",
};

static VALUE
append_lex_state_name(struct parser_params *p, enum lex_state_e state, VALUE buf)
{
    int i, sep = 0;
    unsigned int mask = 1;
    static const char none[] = "NONE";

    for (i = 0; i < EXPR_MAX_STATE; ++i, mask <<= 1) {
        if ((unsigned)state & mask) {
            if (sep) {
                rb_str_cat(buf, "|", 1);
            }
            sep = 1;
            rb_str_cat_cstr(buf, rb_parser_lex_state_names[i]);
        }
    }
    if (!sep) {
        rb_str_cat(buf, none, sizeof(none)-1);
    }
    return buf;
}

enum lex_state_e
rb_parser_trace_lex_state(struct parser_params *p, enum lex_state_e from,
                          enum lex_state_e to, int line)
{
    VALUE mesg;
    mesg = rb_str_new_cstr("lex_state: ");
    append_lex_state_name(p, from, mesg);
    rb_str_cat_cstr(mesg, " -> ");
    append_lex_state_name(p, to, mesg);
    rb_str_catf(mesg, " at line %d\n", line);
    flush_debug_buffer(p, p->debug_output, mesg);
    return to;
}

VALUE
rb_parser_lex_state_name(struct parser_params *p, enum lex_state_e state)
{
    return rb_str_to_interned_str(append_lex_state_name(p, state, rb_str_new(0, 0)));
}

static void
append_bitstack_value(struct parser_params *p, stack_type stack, VALUE mesg)
{
    if (stack == 0) {
        rb_str_cat_cstr(mesg, "0");
    }
    else {
        stack_type mask = (stack_type)1U << (CHAR_BIT * sizeof(stack_type) - 1);
        for (; mask && !(stack & mask); mask >>= 1) continue;
        for (; mask; mask >>= 1) rb_str_cat(mesg, stack & mask ? "1" : "0", 1);
    }
}

void
rb_parser_show_bitstack(struct parser_params *p, stack_type stack,
                        const char *name, int line)
{
    VALUE mesg = rb_sprintf("%s: ", name);
    append_bitstack_value(p, stack, mesg);
    rb_str_catf(mesg, " at line %d\n", line);
    flush_debug_buffer(p, p->debug_output, mesg);
}

void
rb_parser_fatal(struct parser_params *p, const char *fmt, ...)
{
    va_list ap;
    VALUE mesg = rb_str_new_cstr("internal parser error: ");

    va_start(ap, fmt);
    rb_str_vcatf(mesg, fmt, ap);
    va_end(ap);
    yyerror0(RSTRING_PTR(mesg));
    RB_GC_GUARD(mesg);

    mesg = rb_str_new(0, 0);
    append_lex_state_name(p, p->lex.state, mesg);
    compile_error(p, "lex.state: %"PRIsVALUE, mesg);
    rb_str_resize(mesg, 0);
    append_bitstack_value(p, p->cond_stack, mesg);
    compile_error(p, "cond_stack: %"PRIsVALUE, mesg);
    rb_str_resize(mesg, 0);
    append_bitstack_value(p, p->cmdarg_stack, mesg);
    compile_error(p, "cmdarg_stack: %"PRIsVALUE, mesg);
    if (p->debug_output == rb_ractor_stdout())
        p->debug_output = rb_ractor_stderr();
    p->debug = TRUE;
}

static YYLTYPE *
rb_parser_set_pos(YYLTYPE *yylloc, int sourceline, int beg_pos, int end_pos)
{
    yylloc->beg_pos.lineno = sourceline;
    yylloc->beg_pos.column = beg_pos;
    yylloc->end_pos.lineno = sourceline;
    yylloc->end_pos.column = end_pos;
    return yylloc;
}

YYLTYPE *
rb_parser_set_location_from_strterm_heredoc(struct parser_params *p, rb_strterm_heredoc_t *here, YYLTYPE *yylloc)
{
    int sourceline = here->sourceline;
    int beg_pos = (int)here->offset - here->quote
        - (rb_strlen_lit("<<-") - !(here->func & STR_FUNC_INDENT));
    int end_pos = (int)here->offset + here->length + here->quote;

    return rb_parser_set_pos(yylloc, sourceline, beg_pos, end_pos);
}

YYLTYPE *
rb_parser_set_location_of_delayed_token(struct parser_params *p, YYLTYPE *yylloc)
{
    yylloc->beg_pos.lineno = p->delayed.beg_line;
    yylloc->beg_pos.column = p->delayed.beg_col;
    yylloc->end_pos.lineno = p->delayed.end_line;
    yylloc->end_pos.column = p->delayed.end_col;

    return yylloc;
}

YYLTYPE *
rb_parser_set_location_of_heredoc_end(struct parser_params *p, YYLTYPE *yylloc)
{
    int sourceline = p->ruby_sourceline;
    int beg_pos = (int)(p->lex.ptok - p->lex.pbeg);
    int end_pos = (int)(p->lex.pend - p->lex.pbeg);
    return rb_parser_set_pos(yylloc, sourceline, beg_pos, end_pos);
}

YYLTYPE *
rb_parser_set_location_of_dummy_end(struct parser_params *p, YYLTYPE *yylloc)
{
    yylloc->end_pos = yylloc->beg_pos;

    return yylloc;
}

YYLTYPE *
rb_parser_set_location_of_none(struct parser_params *p, YYLTYPE *yylloc)
{
    int sourceline = p->ruby_sourceline;
    int beg_pos = (int)(p->lex.ptok - p->lex.pbeg);
    int end_pos = (int)(p->lex.ptok - p->lex.pbeg);
    return rb_parser_set_pos(yylloc, sourceline, beg_pos, end_pos);
}

YYLTYPE *
rb_parser_set_location(struct parser_params *p, YYLTYPE *yylloc)
{
    int sourceline = p->ruby_sourceline;
    int beg_pos = (int)(p->lex.ptok - p->lex.pbeg);
    int end_pos = (int)(p->lex.pcur - p->lex.pbeg);
    return rb_parser_set_pos(yylloc, sourceline, beg_pos, end_pos);
}
#endif /* !RIPPER */

static int
assignable0(struct parser_params *p, ID id, const char **err)
{
    if (!id) return -1;
    switch (id) {
      case keyword_self:
        *err = "Can't change the value of self";
        return -1;
      case keyword_nil:
        *err = "Can't assign to nil";
        return -1;
      case keyword_true:
        *err = "Can't assign to true";
        return -1;
      case keyword_false:
        *err = "Can't assign to false";
        return -1;
      case keyword__FILE__:
        *err = "Can't assign to __FILE__";
        return -1;
      case keyword__LINE__:
        *err = "Can't assign to __LINE__";
        return -1;
      case keyword__ENCODING__:
        *err = "Can't assign to __ENCODING__";
        return -1;
    }
    switch (id_type(id)) {
      case ID_LOCAL:
        if (dyna_in_block(p)) {
            if (p->max_numparam > NO_PARAM && NUMPARAM_ID_P(id)) {
                compile_error(p, "Can't assign to numbered parameter _%d",
                              NUMPARAM_ID_TO_IDX(id));
                return -1;
            }
            if (dvar_curr(p, id)) return NODE_DASGN;
            if (dvar_defined(p, id)) return NODE_DASGN;
            if (local_id(p, id)) return NODE_LASGN;
            dyna_var(p, id);
            return NODE_DASGN;
        }
        else {
            if (!local_id(p, id)) local_var(p, id);
            return NODE_LASGN;
        }
        break;
      case ID_GLOBAL: return NODE_GASGN;
      case ID_INSTANCE: return NODE_IASGN;
      case ID_CONST:
        if (!p->ctxt.in_def) return NODE_CDECL;
        *err = "dynamic constant assignment";
        return -1;
      case ID_CLASS: return NODE_CVASGN;
      default:
        compile_error(p, "identifier %"PRIsVALUE" is not valid to set", rb_id2str(id));
    }
    return -1;
}

static NODE*
assignable(struct parser_params *p, ID id, NODE *val, const YYLTYPE *loc)
{
    const char *err = 0;
    int node_type = assignable0(p, id, &err);
    switch (node_type) {
      case NODE_DASGN: return NEW_DASGN(id, val, loc);
      case NODE_LASGN: return NEW_LASGN(id, val, loc);
      case NODE_GASGN: return NEW_GASGN(id, val, loc);
      case NODE_IASGN: return NEW_IASGN(id, val, loc);
      case NODE_CDECL: return NEW_CDECL(id, val, 0, p->ctxt.shareable_constant_value, loc);
      case NODE_CVASGN: return NEW_CVASGN(id, val, loc);
    }
/* TODO: FIXME */
#ifndef RIPPER
    if (err) yyerror1(loc, err);
#else
    if (err) set_value(assign_error(p, err, p->s_lvalue));
#endif
    return NEW_ERROR(loc);
}

static int
is_private_local_id(struct parser_params *p, ID name)
{
    VALUE s;
    if (name == idUScore) return 1;
    if (!is_local_id(name)) return 0;
    s = rb_id2str(name);
    if (!s) return 0;
    return RSTRING_PTR(s)[0] == '_';
}

static int
shadowing_lvar_0(struct parser_params *p, ID name)
{
    if (dyna_in_block(p)) {
        if (dvar_curr(p, name)) {
            if (is_private_local_id(p, name)) return 1;
            yyerror0("duplicated argument name");
        }
        else if (dvar_defined(p, name) || local_id(p, name)) {
            vtable_add(p->lvtbl->vars, name);
            if (p->lvtbl->used) {
                vtable_add(p->lvtbl->used, (ID)p->ruby_sourceline | LVAR_USED);
            }
            return 0;
        }
    }
    else {
        if (local_id(p, name)) {
            if (is_private_local_id(p, name)) return 1;
            yyerror0("duplicated argument name");
        }
    }
    return 1;
}

static ID
shadowing_lvar(struct parser_params *p, ID name)
{
    shadowing_lvar_0(p, name);
    return name;
}

static void
new_bv(struct parser_params *p, ID name)
{
    if (!name) return;
    if (!is_local_id(name)) {
        compile_error(p, "invalid local variable - %"PRIsVALUE,
                      rb_id2str(name));
        return;
    }
    if (!shadowing_lvar_0(p, name)) return;
    dyna_var(p, name);
    ID *vidp = 0;
    if (dvar_defined_ref(p, name, &vidp)) {
        if (vidp) *vidp |= LVAR_USED;
    }
}

static void
aryset_check(struct parser_params *p, NODE *args)
{
    NODE *block = 0, *kwds = 0;
    if (args && nd_type_p(args, NODE_BLOCK_PASS)) {
        block = RNODE_BLOCK_PASS(args)->nd_body;
        args = RNODE_BLOCK_PASS(args)->nd_head;
    }
    if (args && nd_type_p(args, NODE_ARGSCAT)) {
        args = RNODE_ARGSCAT(args)->nd_body;
    }
    if (args && nd_type_p(args, NODE_ARGSPUSH)) {
        kwds = RNODE_ARGSPUSH(args)->nd_body;
    }
    else {
        for (NODE *next = args; next && nd_type_p(next, NODE_LIST);
             next = RNODE_LIST(next)->nd_next) {
            kwds = RNODE_LIST(next)->nd_head;
        }
    }
    if (kwds && nd_type_p(kwds, NODE_HASH) && !RNODE_HASH(kwds)->nd_brace) {
        yyerror1(&kwds->nd_loc, "keyword arg given in index assignment");
    }
    if (block) {
        yyerror1(&block->nd_loc, "block arg given in index assignment");
    }
}

static NODE *
aryset(struct parser_params *p, NODE *recv, NODE *idx, const YYLTYPE *loc)
{
    aryset_check(p, idx);
    return NEW_ATTRASGN(recv, tASET, idx, loc);
}

static void
block_dup_check(struct parser_params *p, NODE *node1, NODE *node2)
{
    if (node2 && node1 && nd_type_p(node1, NODE_BLOCK_PASS)) {
        compile_error(p, "both block arg and actual block given");
    }
}

static NODE *
attrset(struct parser_params *p, NODE *recv, ID atype, ID id, const YYLTYPE *loc)
{
    if (!CALL_Q_P(atype)) id = rb_id_attrset(id);
    return NEW_ATTRASGN(recv, id, 0, loc);
}

static VALUE
rb_backref_error(struct parser_params *p, NODE *node)
{
#ifndef RIPPER
# define ERR(...) (compile_error(p, __VA_ARGS__), Qtrue)
#else
# define ERR(...) rb_sprintf(__VA_ARGS__)
#endif
    switch (nd_type(node)) {
      case NODE_NTH_REF:
        return ERR("Can't set variable $%ld", RNODE_NTH_REF(node)->nd_nth);
      case NODE_BACK_REF:
        return ERR("Can't set variable $%c", (int)RNODE_BACK_REF(node)->nd_nth);
    }
#undef ERR
    UNREACHABLE_RETURN(Qfalse); /* only called on syntax error */
}

static NODE *
arg_append(struct parser_params *p, NODE *node1, NODE *node2, const YYLTYPE *loc)
{
    if (!node1) return NEW_LIST(node2, &node2->nd_loc);
    switch (nd_type(node1))  {
      case NODE_LIST:
        return list_append(p, node1, node2);
      case NODE_BLOCK_PASS:
        RNODE_BLOCK_PASS(node1)->nd_head = arg_append(p, RNODE_BLOCK_PASS(node1)->nd_head, node2, loc);
        node1->nd_loc.end_pos = RNODE_BLOCK_PASS(node1)->nd_head->nd_loc.end_pos;
        return node1;
      case NODE_ARGSPUSH:
        RNODE_ARGSPUSH(node1)->nd_body = list_append(p, NEW_LIST(RNODE_ARGSPUSH(node1)->nd_body, &RNODE_ARGSPUSH(node1)->nd_body->nd_loc), node2);
        node1->nd_loc.end_pos = RNODE_ARGSPUSH(node1)->nd_body->nd_loc.end_pos;
        nd_set_type(node1, NODE_ARGSCAT);
        return node1;
      case NODE_ARGSCAT:
        if (!nd_type_p(RNODE_ARGSCAT(node1)->nd_body, NODE_LIST)) break;
        RNODE_ARGSCAT(node1)->nd_body = list_append(p, RNODE_ARGSCAT(node1)->nd_body, node2);
        node1->nd_loc.end_pos = RNODE_ARGSCAT(node1)->nd_body->nd_loc.end_pos;
        return node1;
    }
    return NEW_ARGSPUSH(node1, node2, loc);
}

static NODE *
arg_concat(struct parser_params *p, NODE *node1, NODE *node2, const YYLTYPE *loc)
{
    if (!node2) return node1;
    switch (nd_type(node1)) {
      case NODE_BLOCK_PASS:
        if (RNODE_BLOCK_PASS(node1)->nd_head)
            RNODE_BLOCK_PASS(node1)->nd_head = arg_concat(p, RNODE_BLOCK_PASS(node1)->nd_head, node2, loc);
        else
            RNODE_LIST(node1)->nd_head = NEW_LIST(node2, loc);
        return node1;
      case NODE_ARGSPUSH:
        if (!nd_type_p(node2, NODE_LIST)) break;
        RNODE_ARGSPUSH(node1)->nd_body = list_concat(NEW_LIST(RNODE_ARGSPUSH(node1)->nd_body, loc), node2);
        nd_set_type(node1, NODE_ARGSCAT);
        return node1;
      case NODE_ARGSCAT:
        if (!nd_type_p(node2, NODE_LIST) ||
            !nd_type_p(RNODE_ARGSCAT(node1)->nd_body, NODE_LIST)) break;
        RNODE_ARGSCAT(node1)->nd_body = list_concat(RNODE_ARGSCAT(node1)->nd_body, node2);
        return node1;
    }
    return NEW_ARGSCAT(node1, node2, loc);
}

static NODE *
last_arg_append(struct parser_params *p, NODE *args, NODE *last_arg, const YYLTYPE *loc)
{
    NODE *n1;
    if ((n1 = splat_array(args)) != 0) {
        return list_append(p, n1, last_arg);
    }
    return arg_append(p, args, last_arg, loc);
}

static NODE *
rest_arg_append(struct parser_params *p, NODE *args, NODE *rest_arg, const YYLTYPE *loc)
{
    NODE *n1;
    if ((nd_type_p(rest_arg, NODE_LIST)) && (n1 = splat_array(args)) != 0) {
        return list_concat(n1, rest_arg);
    }
    return arg_concat(p, args, rest_arg, loc);
}

static NODE *
splat_array(NODE* node)
{
    if (nd_type_p(node, NODE_SPLAT)) node = RNODE_SPLAT(node)->nd_head;
    if (nd_type_p(node, NODE_LIST)) return node;
    return 0;
}

static void
mark_lvar_used(struct parser_params *p, NODE *rhs)
{
    ID *vidp = NULL;
    if (!rhs) return;
    switch (nd_type(rhs)) {
      case NODE_LASGN:
        if (local_id_ref(p, RNODE_LASGN(rhs)->nd_vid, &vidp)) {
            if (vidp) *vidp |= LVAR_USED;
        }
        break;
      case NODE_DASGN:
        if (dvar_defined_ref(p, RNODE_DASGN(rhs)->nd_vid, &vidp)) {
            if (vidp) *vidp |= LVAR_USED;
        }
        break;
#if 0
      case NODE_MASGN:
        for (rhs = rhs->nd_head; rhs; rhs = rhs->nd_next) {
            mark_lvar_used(p, rhs->nd_head);
        }
        break;
#endif
    }
}

static int is_static_content(NODE *node);

static NODE *
node_assign(struct parser_params *p, NODE *lhs, NODE *rhs, struct lex_context ctxt, const YYLTYPE *loc)
{
    if (!lhs) return 0;

    switch (nd_type(lhs)) {
      case NODE_CDECL:
      case NODE_GASGN:
      case NODE_IASGN:
      case NODE_LASGN:
      case NODE_DASGN:
      case NODE_MASGN:
      case NODE_CVASGN:
        set_nd_value(p, lhs, rhs);
        nd_set_loc(lhs, loc);
        break;

      case NODE_ATTRASGN:
        RNODE_ATTRASGN(lhs)->nd_args = arg_append(p, RNODE_ATTRASGN(lhs)->nd_args, rhs, loc);
        nd_set_loc(lhs, loc);
        break;

      default:
        /* should not happen */
        break;
    }

    return lhs;
}

static NODE *
value_expr_check(struct parser_params *p, NODE *node)
{
    NODE *void_node = 0, *vn;

    if (!node) {
        rb_warning0("empty expression");
    }
    while (node) {
        switch (nd_type(node)) {
          case NODE_ENSURE:
            vn = RNODE_ENSURE(node)->nd_head;
            node = RNODE_ENSURE(node)->nd_ensr;
            /* nd_ensr should not be NULL, check it out next */
            if (vn && (vn = value_expr_check(p, vn))) {
                goto found;
            }
            break;

          case NODE_RESCUE:
            /* void only if all children are void */
            vn = RNODE_RESCUE(node)->nd_head;
            if (!vn || !(vn = value_expr_check(p, vn))) return NULL;
            if (!void_node) void_node = vn;
            for (NODE *r = RNODE_RESCUE(node)->nd_resq; r; r = RNODE_RESBODY(r)->nd_next) {
                if (!nd_type_p(r, NODE_RESBODY)) {
                    compile_error(p, "unexpected node");
                    return NULL;
                }
                if (!(vn = value_expr_check(p, RNODE_RESBODY(r)->nd_body))) {
                    void_node = 0;
                    break;
                }
                if (!void_node) void_node = vn;
            }
            node = RNODE_RESCUE(node)->nd_else;
            if (!node) return void_node;
            break;

          case NODE_RETURN:
          case NODE_BREAK:
          case NODE_NEXT:
          case NODE_REDO:
          case NODE_RETRY:
            goto found;

          case NODE_CASE3:
            if (!RNODE_CASE3(node)->nd_body || !nd_type_p(RNODE_CASE3(node)->nd_body, NODE_IN)) {
                compile_error(p, "unexpected node");
                return NULL;
            }
            if (RNODE_IN(RNODE_CASE3(node)->nd_body)->nd_body) {
                return NULL;
            }
            /* single line pattern matching with "=>" operator */
            goto found;

          case NODE_BLOCK:
            while (RNODE_BLOCK(node)->nd_next) {
                node = RNODE_BLOCK(node)->nd_next;
            }
            node = RNODE_BLOCK(node)->nd_head;
            break;

          case NODE_BEGIN:
            node = RNODE_BEGIN(node)->nd_body;
            break;

          case NODE_IF:
          case NODE_UNLESS:
            if (!RNODE_IF(node)->nd_body) {
                return NULL;
            }
            else if (!RNODE_IF(node)->nd_else) {
                return NULL;
            }
            vn = value_expr_check(p, RNODE_IF(node)->nd_body);
            if (!vn) return NULL;
            if (!void_node) void_node = vn;
            node = RNODE_IF(node)->nd_else;
            break;

          case NODE_AND:
          case NODE_OR:
            node = RNODE_AND(node)->nd_1st;
            break;

          case NODE_LASGN:
          case NODE_DASGN:
          case NODE_MASGN:
            mark_lvar_used(p, node);
            return NULL;

          default:
            return NULL;
        }
    }

    return NULL;

  found:
    /* return the first found node */
    return void_node ? void_node : node;
}

static int
value_expr(struct parser_params *p, NODE *node)
{
    NODE *void_node = value_expr_check(p, node);
    if (void_node) {
        yyerror1(&void_node->nd_loc, "void value expression");
        /* or "control never reach"? */
        return FALSE;
    }
    return TRUE;
}

static void
void_expr(struct parser_params *p, NODE *node)
{
    const char *useless = 0;

    if (!RTEST(ruby_verbose)) return;

    if (!node || !(node = nd_once_body(node))) return;
    switch (nd_type(node)) {
      case NODE_OPCALL:
        switch (RNODE_OPCALL(node)->nd_mid) {
          case '+':
          case '-':
          case '*':
          case '/':
          case '%':
          case tPOW:
          case tUPLUS:
          case tUMINUS:
          case '|':
          case '^':
          case '&':
          case tCMP:
          case '>':
          case tGEQ:
          case '<':
          case tLEQ:
          case tEQ:
          case tNEQ:
            useless = rb_id2name(RNODE_OPCALL(node)->nd_mid);
            break;
        }
        break;

      case NODE_LVAR:
      case NODE_DVAR:
      case NODE_GVAR:
      case NODE_IVAR:
      case NODE_CVAR:
      case NODE_NTH_REF:
      case NODE_BACK_REF:
        useless = "a variable";
        break;
      case NODE_CONST:
        useless = "a constant";
        break;
      case NODE_SYM:
      case NODE_LINE:
      case NODE_FILE:
      case NODE_ENCODING:
      case NODE_INTEGER:
      case NODE_FLOAT:
      case NODE_RATIONAL:
      case NODE_IMAGINARY:
      case NODE_STR:
      case NODE_DSTR:
      case NODE_REGX:
      case NODE_DREGX:
        useless = "a literal";
        break;
      case NODE_COLON2:
      case NODE_COLON3:
        useless = "::";
        break;
      case NODE_DOT2:
        useless = "..";
        break;
      case NODE_DOT3:
        useless = "...";
        break;
      case NODE_SELF:
        useless = "self";
        break;
      case NODE_NIL:
        useless = "nil";
        break;
      case NODE_TRUE:
        useless = "true";
        break;
      case NODE_FALSE:
        useless = "false";
        break;
      case NODE_DEFINED:
        useless = "defined?";
        break;
    }

    if (useless) {
        rb_warn1L(nd_line(node), "possibly useless use of %s in void context", WARN_S(useless));
    }
}

/* warns useless use of block and returns the last statement node */
static NODE *
void_stmts(struct parser_params *p, NODE *node)
{
    NODE *const n = node;
    if (!RTEST(ruby_verbose)) return n;
    if (!node) return n;
    if (!nd_type_p(node, NODE_BLOCK)) return n;

    while (RNODE_BLOCK(node)->nd_next) {
        void_expr(p, RNODE_BLOCK(node)->nd_head);
        node = RNODE_BLOCK(node)->nd_next;
    }
    return RNODE_BLOCK(node)->nd_head;
}

static NODE *
remove_begin(NODE *node)
{
    NODE **n = &node, *n1 = node;
    while (n1 && nd_type_p(n1, NODE_BEGIN) && RNODE_BEGIN(n1)->nd_body) {
        *n = n1 = RNODE_BEGIN(n1)->nd_body;
    }
    return node;
}

static void
reduce_nodes(struct parser_params *p, NODE **body)
{
    NODE *node = *body;

    if (!node) {
        *body = NEW_NIL(&NULL_LOC);
        return;
    }
#define subnodes(type, n1, n2) \
    ((!type(node)->n1) ? (type(node)->n2 ? (body = &type(node)->n2, 1) : 0) : \
     (!type(node)->n2) ? (body = &type(node)->n1, 1) : \
     (reduce_nodes(p, &type(node)->n1), body = &type(node)->n2, 1))

    while (node) {
        int newline = (int)nd_fl_newline(node);
        switch (nd_type(node)) {
          end:
          case NODE_NIL:
            *body = 0;
            return;
          case NODE_BEGIN:
            *body = node = RNODE_BEGIN(node)->nd_body;
            if (newline && node) nd_set_fl_newline(node);
            continue;
          case NODE_BLOCK:
            body = &RNODE_BLOCK(RNODE_BLOCK(node)->nd_end)->nd_head;
            break;
          case NODE_IF:
          case NODE_UNLESS:
            if (subnodes(RNODE_IF, nd_body, nd_else)) break;
            return;
          case NODE_CASE:
            body = &RNODE_CASE(node)->nd_body;
            break;
          case NODE_WHEN:
            if (!subnodes(RNODE_WHEN, nd_body, nd_next)) goto end;
            break;
          case NODE_ENSURE:
            body = &RNODE_ENSURE(node)->nd_head;
            break;
          case NODE_RESCUE:
            newline = 0; // RESBODY should not be a NEWLINE
            if (RNODE_RESCUE(node)->nd_else) {
                body = &RNODE_RESCUE(node)->nd_resq;
                break;
            }
            if (!subnodes(RNODE_RESCUE, nd_head, nd_resq)) goto end;
            break;
          default:
            return;
        }
        node = *body;
        if (newline && node) nd_set_fl_newline(node);
    }

#undef subnodes
}

static int
is_static_content(NODE *node)
{
    if (!node) return 1;
    switch (nd_type(node)) {
      case NODE_HASH:
        if (!(node = RNODE_HASH(node)->nd_head)) break;
      case NODE_LIST:
        do {
            if (!is_static_content(RNODE_LIST(node)->nd_head)) return 0;
        } while ((node = RNODE_LIST(node)->nd_next) != 0);
      case NODE_SYM:
      case NODE_REGX:
      case NODE_LINE:
      case NODE_FILE:
      case NODE_ENCODING:
      case NODE_INTEGER:
      case NODE_FLOAT:
      case NODE_RATIONAL:
      case NODE_IMAGINARY:
      case NODE_STR:
      case NODE_NIL:
      case NODE_TRUE:
      case NODE_FALSE:
      case NODE_ZLIST:
        break;
      default:
        return 0;
    }
    return 1;
}

static int
assign_in_cond(struct parser_params *p, NODE *node)
{
    switch (nd_type(node)) {
      case NODE_MASGN:
      case NODE_LASGN:
      case NODE_DASGN:
      case NODE_GASGN:
      case NODE_IASGN:
      case NODE_CVASGN:
      case NODE_CDECL:
        break;

      default:
        return 0;
    }

    if (!get_nd_value(p, node)) return 1;
    if (is_static_content(get_nd_value(p, node))) {
        /* reports always */
        rb_warn0L(nd_line(get_nd_value(p, node)), "found '= literal' in conditional, should be ==");
    }
    return 1;
}

enum cond_type {
    COND_IN_OP,
    COND_IN_COND,
    COND_IN_FF
};

#define SWITCH_BY_COND_TYPE(t, w, arg) do { \
    switch (t) { \
      case COND_IN_OP: break; \
      case COND_IN_COND: rb_##w##0(arg "literal in condition"); break; \
      case COND_IN_FF: rb_##w##0(arg "literal in flip-flop"); break; \
    } \
} while (0)

static NODE *cond0(struct parser_params*,NODE*,enum cond_type,const YYLTYPE*,bool);

static NODE*
range_op(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    enum node_type type;

    if (node == 0) return 0;

    type = nd_type(node);
    value_expr(p, node);
    if (type == NODE_INTEGER) {
        if (!e_option_supplied(p)) rb_warn0L(nd_line(node), "integer literal in flip-flop");
        ID lineno = rb_intern("$.");
        return NEW_CALL(node, tEQ, NEW_LIST(NEW_GVAR(lineno, loc), loc), loc);
    }
    return cond0(p, node, COND_IN_FF, loc, true);
}

static NODE*
cond0(struct parser_params *p, NODE *node, enum cond_type type, const YYLTYPE *loc, bool top)
{
    if (node == 0) return 0;
    if (!(node = nd_once_body(node))) return 0;
    assign_in_cond(p, node);

    switch (nd_type(node)) {
      case NODE_BEGIN:
        RNODE_BEGIN(node)->nd_body = cond0(p, RNODE_BEGIN(node)->nd_body, type, loc, top);
        break;

      case NODE_DSTR:
      case NODE_EVSTR:
      case NODE_STR:
      case NODE_FILE:
        SWITCH_BY_COND_TYPE(type, warn, "string ");
        break;

      case NODE_REGX:
        if (!e_option_supplied(p)) SWITCH_BY_COND_TYPE(type, warn, "regex ");
        nd_set_type(node, NODE_MATCH);
        break;

      case NODE_DREGX:
        if (!e_option_supplied(p)) SWITCH_BY_COND_TYPE(type, warning, "regex ");

        return NEW_MATCH2(node, NEW_GVAR(idLASTLINE, loc), loc);

      case NODE_BLOCK:
        {
            NODE *end = RNODE_BLOCK(node)->nd_end;
            NODE **expr = &RNODE_BLOCK(end)->nd_head;
            if (top) top = node == end;
            *expr = cond0(p, *expr, type, loc, top);
        }
        break;

      case NODE_AND:
      case NODE_OR:
        RNODE_AND(node)->nd_1st = cond0(p, RNODE_AND(node)->nd_1st, COND_IN_COND, loc, true);
        RNODE_AND(node)->nd_2nd = cond0(p, RNODE_AND(node)->nd_2nd, COND_IN_COND, loc, true);
        break;

      case NODE_DOT2:
      case NODE_DOT3:
        if (!top) break;
        RNODE_DOT2(node)->nd_beg = range_op(p, RNODE_DOT2(node)->nd_beg, loc);
        RNODE_DOT2(node)->nd_end = range_op(p, RNODE_DOT2(node)->nd_end, loc);
        switch (nd_type(node)) {
          case NODE_DOT2:
            nd_set_type(node,NODE_FLIP2);
            rb_node_flip2_t *flip2 = RNODE_FLIP2(node); /* for debug info */
            (void)flip2;
            break;
          case NODE_DOT3:
            nd_set_type(node, NODE_FLIP3);
            rb_node_flip3_t *flip3 = RNODE_FLIP3(node); /* for debug info */
            (void)flip3;
            break;
        }
        break;

      case NODE_SYM:
      case NODE_DSYM:
        SWITCH_BY_COND_TYPE(type, warning, "symbol ");
        break;

      case NODE_LINE:
      case NODE_ENCODING:
      case NODE_INTEGER:
      case NODE_FLOAT:
      case NODE_RATIONAL:
      case NODE_IMAGINARY:
        SWITCH_BY_COND_TYPE(type, warning, "");
        break;

      default:
        break;
    }
    return node;
}

static NODE*
cond(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    if (node == 0) return 0;
    return cond0(p, node, COND_IN_COND, loc, true);
}

static NODE*
method_cond(struct parser_params *p, NODE *node, const YYLTYPE *loc)
{
    if (node == 0) return 0;
    return cond0(p, node, COND_IN_OP, loc, true);
}

static NODE*
new_nil_at(struct parser_params *p, const rb_code_position_t *pos)
{
    YYLTYPE loc = {*pos, *pos};
    return NEW_NIL(&loc);
}

static NODE*
new_if(struct parser_params *p, NODE *cc, NODE *left, NODE *right, const YYLTYPE *loc, const YYLTYPE* if_keyword_loc, cons