
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef XSLDBGSOURCESIMPL_H 
#define XSLDBGSOURCESIMPL_H 
 
/** 
  *@author Keith Isdale 
  */

#include "ui_xsldbgsources.h"
#include "xsldbgdialogbase.h"

class XsldbgDebugger;

class XsldbgSourcesImpl : public QWidget, Ui::XsldbgSources, public XsldbgDialogBase   {
  Q_OBJECT 
 
public:
	explicit XsldbgSourcesImpl(XsldbgDebugger *debugger, QWidget *parent=0); 
	~XsldbgSourcesImpl(); 
	// this must match the order of columns in tableWidget
	enum ColumnDataTypes {FileNameColumn, ParentFileNameColumn, ParentLineNumberColumn};
 
public slots:
	void itemSelectionChanged();	 
	
	/** Process request to add source to view, First parameter is QString() 
			to indicate start of source list notfication */ 
	void slotProcSourceItem(QString  fileName , QString  parentFileName , int lineNumber ); 
	 
	/** Called to resize the table widget contents after enough time has lapsed */
	void resizeContents();
	 
	/** refresh data from source */ 
	void refresh(); 
	 
private: 
	XsldbgDebugger *debugger; 
 
}; 

#endif
