
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2006 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef XSLDBGVARIABLESIMPL_H 
#define XSLDBGVARIABLESIMPL_H 

/**
 *@author Keith Isdale
 */

#include "ui_xsldbgvariables.h"
#include "xsldbgdialogbase.h"

#include <QWidget>
#include <QTimer>

class XsldbgDebugger;
class QTimer;

class XsldbgVariablesImpl : public QWidget, Ui::XsldbgVariables, XsldbgDialogBase  {
    Q_OBJECT

    public:
        explicit XsldbgVariablesImpl(XsldbgDebugger *debugger, QWidget *parent=0);
        ~XsldbgVariablesImpl();
        // this must match the order of columns in tableWidget
        enum ColumnDataTypes {NameColumn, TemplateColumn, TypeColumn, XPathColumn, FileNameColumn, LineNumberColumn};


    public slots:
        /** Process request to add local variable to view, First parameter is QString()
          to indicate start of local variable list notfication */

        void slotProcVariableItem(QString /*name */, QString /* templateContext*/,
                QString /* fileName */, int /*lineNumber */,
                QString /* select XPath */, bool /* is it a local variable */);

        void itemSelectionChanged();

        /** Called to resize the table widget contents after enough time has lapsed */
        void resizeContents();

        /** refresh data from source */
        void refresh();

        void slotEvaluate();

        void slotSetExpression();


    private: 
        XsldbgDebugger *debugger;
        bool showLocals;
        int insertPosition;

};

#endif
