/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIterationBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderIterator
extends CloseableIterationBase<BindingSet, QueryEvaluationException> {
    private CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private Comparator<BindingSet> comparator;
    private Iterator<BindingSet> ordered;

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator) {
        this.iter = iter;
        this.comparator = comparator;
    }

    private Iterator<BindingSet> getOrderedIterator() throws QueryEvaluationException {
        if (this.ordered == null) {
            ArrayList list = new ArrayList(1024);
            while (this.iter.hasNext()) {
                list.add(this.iter.next());
            }
            Collections.sort(list, this.comparator);
            this.ordered = list.iterator();
        }
        return this.ordered;
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        return this.getOrderedIterator().hasNext();
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        return this.getOrderedIterator().next();
    }

    @Override
    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }
}

