/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory;

import info.aduna.io.IOUtil;
import info.aduna.iteration.CloseableIteration;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;
import org.openrdf.sail.memory.model.MemResource;
import org.openrdf.sail.memory.model.MemStatement;
import org.openrdf.sail.memory.model.MemURI;
import org.openrdf.sail.memory.model.MemValue;
import org.openrdf.sail.memory.model.ReadMode;

class FileIO {
    private static final byte[] MAGIC_NUMBER = new byte[]{66, 77, 83, 70};
    private static final int BMSF_VERSION = 1;
    public static final int NAMESPACE_MARKER = 1;
    public static final int EXPL_TRIPLE_MARKER = 2;
    public static final int EXPL_QUAD_MARKER = 3;
    public static final int INF_TRIPLE_MARKER = 4;
    public static final int INF_QUAD_MARKER = 5;
    public static final int URI_MARKER = 6;
    public static final int BNODE_MARKER = 7;
    public static final int PLAIN_LITERAL_MARKER = 8;
    public static final int LANG_LITERAL_MARKER = 9;
    public static final int DATATYPE_LITERAL_MARKER = 10;
    public static final int EOF_MARKER = 127;

    FileIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(MemoryStore store, File dataFile) throws IOException, SailException {
        OutputStream out = new FileOutputStream(dataFile);
        try {
            out.write(MAGIC_NUMBER);
            out.write(1);
            DataOutputStream dataOut = new DataOutputStream(new GZIPOutputStream(out));
            out = dataOut;
            FileIO.writeNamespaces(store, dataOut);
            FileIO.writeStatements(store, dataOut);
            dataOut.writeByte(127);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(MemoryStore store, File dataFile) throws IOException {
        InputStream in = new FileInputStream(dataFile);
        try {
            byte recordTypeMarker;
            byte[] magicNumber = IOUtil.readBytes(in, MAGIC_NUMBER.length);
            if (!Arrays.equals(magicNumber, MAGIC_NUMBER)) {
                throw new IOException("File is not a binary MemoryStore file");
            }
            int version = in.read();
            if (version != 1) {
                throw new IOException("Incompatible format version: " + version);
            }
            DataInputStream dataIn = new DataInputStream(new GZIPInputStream(in));
            in = dataIn;
            block10: while ((recordTypeMarker = dataIn.readByte()) != 127) {
                switch (recordTypeMarker) {
                    case 1: {
                        FileIO.readNamespace(store, dataIn);
                        continue block10;
                    }
                    case 2: {
                        FileIO.readStatement(store, false, true, dataIn);
                        continue block10;
                    }
                    case 3: {
                        FileIO.readStatement(store, true, true, dataIn);
                        continue block10;
                    }
                    case 4: {
                        FileIO.readStatement(store, false, false, dataIn);
                        continue block10;
                    }
                    case 5: {
                        FileIO.readStatement(store, true, false, dataIn);
                        continue block10;
                    }
                }
                throw new IOException("Invalid record type marker: " + recordTypeMarker);
            }
        }
        finally {
            in.close();
        }
    }

    private static void writeNamespaces(MemoryStore store, DataOutputStream dataOut) throws IOException {
        for (NamespaceImpl ns : store.getNamespaceStore()) {
            dataOut.writeByte(1);
            dataOut.writeUTF(ns.getPrefix());
            dataOut.writeUTF(ns.getName());
            dataOut.writeBoolean(true);
        }
    }

    private static void readNamespace(MemoryStore store, DataInputStream dataIn) throws IOException {
        String prefix = dataIn.readUTF();
        String name = dataIn.readUTF();
        dataIn.readBoolean();
        store.getNamespaceStore().setNamespace(prefix, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStatements(MemoryStore store, DataOutputStream dataOut) throws IOException, SailException {
        CloseableIteration<MemStatement, SailException> stIter = store.createStatementIterator(SailException.class, null, null, null, false, store.getCurrentSnapshot(), ReadMode.COMMITTED, new Resource[0]);
        try {
            while (stIter.hasNext()) {
                MemStatement st = (MemStatement)stIter.next();
                MemResource context = st.getContext();
                if (st.isExplicit()) {
                    if (context == null) {
                        dataOut.writeByte(2);
                    } else {
                        dataOut.writeByte(3);
                    }
                } else if (context == null) {
                    dataOut.writeByte(4);
                } else {
                    dataOut.writeByte(5);
                }
                FileIO.writeValue(st.getSubject(), dataOut);
                FileIO.writeValue(st.getPredicate(), dataOut);
                FileIO.writeValue(st.getObject(), dataOut);
                if (context == null) continue;
                FileIO.writeValue(context, dataOut);
            }
        }
        finally {
            stIter.close();
        }
    }

    private static void readStatement(MemoryStore store, boolean hasContext, boolean isExplicit, DataInputStream dataIn) throws IOException, ClassCastException {
        MemResource memSubj = (MemResource)FileIO.readValue(store, dataIn);
        MemURI memPred = (MemURI)FileIO.readValue(store, dataIn);
        MemValue memObj = (MemValue)FileIO.readValue(store, dataIn);
        MemResource memContext = null;
        if (hasContext) {
            memContext = (MemResource)FileIO.readValue(store, dataIn);
        }
        MemStatement st = new MemStatement(memSubj, memPred, memObj, memContext, isExplicit, store.getCurrentSnapshot());
        store.getStatements().add(st);
        st.addToComponentLists();
    }

    private static void writeValue(Value value, DataOutputStream dataOut) throws IOException {
        if (value instanceof URI) {
            dataOut.writeByte(6);
            dataOut.writeUTF(((Object)((URI)value)).toString());
        } else if (value instanceof BNode) {
            dataOut.writeByte(7);
            dataOut.writeUTF(((BNode)value).getID());
        } else if (value instanceof Literal) {
            Literal lit = (Literal)value;
            String label = lit.getLabel();
            String language = lit.getLanguage();
            URI datatype = lit.getDatatype();
            if (datatype != null) {
                dataOut.writeByte(10);
                dataOut.writeUTF(label);
                FileIO.writeValue(datatype, dataOut);
            } else if (language != null) {
                dataOut.writeByte(9);
                dataOut.writeUTF(label);
                dataOut.writeUTF(language);
            } else {
                dataOut.writeByte(8);
                dataOut.writeUTF(label);
            }
        } else {
            throw new IllegalArgumentException("unexpected value type: " + value.getClass());
        }
    }

    private static Value readValue(MemoryStore store, DataInputStream dataIn) throws IOException, ClassCastException {
        byte valueTypeMarker = dataIn.readByte();
        if (valueTypeMarker == 6) {
            String uriString = dataIn.readUTF();
            return store.getValueFactory().createURI(uriString);
        }
        if (valueTypeMarker == 7) {
            String bnodeID = dataIn.readUTF();
            return store.getValueFactory().createBNode(bnodeID);
        }
        if (valueTypeMarker == 8) {
            String label = dataIn.readUTF();
            return store.getValueFactory().createLiteral(label);
        }
        if (valueTypeMarker == 9) {
            String label = dataIn.readUTF();
            String language = dataIn.readUTF();
            return store.getValueFactory().createLiteral(label, language);
        }
        if (valueTypeMarker == 10) {
            String label = dataIn.readUTF();
            URI datatype = (URI)FileIO.readValue(store, dataIn);
            return store.getValueFactory().createLiteral(label, datatype);
        }
        throw new IOException("Invalid value type marker: " + valueTypeMarker);
    }
}

