/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.IterationWrapper;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private E nextElement;

    public FilterIteration(Iteration<? extends E, ? extends X> iter) {
        super(iter);
    }

    @Override
    public boolean hasNext() throws X {
        this.findNextElement();
        return this.nextElement != null;
    }

    @Override
    public E next() throws X {
        this.findNextElement();
        E result = this.nextElement;
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNextElement() throws X {
        while (this.nextElement == null && super.hasNext()) {
            Object candidate = super.next();
            if (!this.accept(candidate)) continue;
            this.nextElement = candidate;
        }
    }

    protected abstract boolean accept(E var1) throws X;

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        this.nextElement = null;
    }
}

