/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiProjection
extends UnaryTupleOperator {
    private List<ProjectionElemList> projections = new ArrayList<ProjectionElemList>();

    public MultiProjection() {
    }

    public MultiProjection(TupleExpr arg) {
        super(arg);
    }

    public MultiProjection(TupleExpr arg, Iterable<ProjectionElemList> projections) {
        this(arg);
        this.addProjections(projections);
    }

    public List<ProjectionElemList> getProjections() {
        return Collections.unmodifiableList(this.projections);
    }

    public void setProjections(Iterable<ProjectionElemList> projections) {
        this.projections.clear();
        this.addProjections(projections);
    }

    public void addProjections(Iterable<ProjectionElemList> projections) {
        for (ProjectionElemList projection : projections) {
            this.addProjection(projection);
        }
    }

    public void addProjection(ProjectionElemList projection) {
        assert (projection != null) : "projection must not be null";
        this.projections.add(projection);
        projection.setParentNode(this);
    }

    @Override
    public Set<String> getBindingNames() {
        HashSet<String> bindingNames = new HashSet<String>();
        for (ProjectionElemList projElemList : this.projections) {
            bindingNames.addAll(projElemList.getTargetNames());
        }
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ProjectionElemList projElemList : this.projections) {
            projElemList.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        int index = this.projections.indexOf(current);
        if (index >= 0) {
            this.projections.set(index, (ProjectionElemList)replacement);
            replacement.setParentNode(this);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public MultiProjection clone() {
        MultiProjection clone = (MultiProjection)super.clone();
        clone.projections = new ArrayList<ProjectionElemList>(this.getProjections().size());
        for (ProjectionElemList pe : this.getProjections()) {
            clone.addProjection(pe.clone());
        }
        return clone;
    }
}

