/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.sail.nativerdf.NativeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeEvaluationStatistics
extends EvaluationStatistics {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NativeStore nativeStore;

    public NativeEvaluationStatistics(NativeStore nativeStore) {
        this.nativeStore = nativeStore;
    }

    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return new NativeCardinalityCalculator();
    }

    protected class NativeCardinalityCalculator
    extends EvaluationStatistics.CardinalityCalculator {
        protected NativeCardinalityCalculator() {
        }

        protected double getCardinality(StatementPattern sp) {
            Resource subj = (Resource)this.getConstantValue(sp.getSubjectVar());
            URI pred = (URI)this.getConstantValue(sp.getPredicateVar());
            Value obj = this.getConstantValue(sp.getObjectVar());
            Resource context = (Resource)this.getConstantValue(sp.getContextVar());
            try {
                return NativeEvaluationStatistics.this.nativeStore.cardinality(subj, pred, obj, context);
            }
            catch (IOException e) {
                NativeEvaluationStatistics.this.log.error("Failed to estimate statement pattern cardinality, falling back to generic implementation", (Throwable)e);
                return super.getCardinality(sp);
            }
        }

        protected Value getConstantValue(Var var) {
            return var != null ? var.getValue() : null;
        }
    }
}

