/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.evaluation;

import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.SqlExprBuilder;

public class SqlRegexBuilder {
    private SqlExprBuilder where;
    private SqlExprBuilder value;
    private SqlExprBuilder pattern;
    private SqlExprBuilder flags;

    public SqlRegexBuilder(SqlExprBuilder where, QueryBuilderFactory factory) {
        this.where = where;
        this.value = factory.createSqlExprBuilder();
        this.pattern = factory.createSqlExprBuilder();
        this.flags = factory.createSqlExprBuilder();
    }

    public SqlExprBuilder value() {
        return this.value;
    }

    public SqlExprBuilder pattern() {
        return this.pattern;
    }

    public SqlExprBuilder flags() {
        return this.flags;
    }

    public SqlExprBuilder close() {
        this.appendRegExp(this.where);
        return this.where;
    }

    protected void appendRegExp(SqlExprBuilder where) {
        where.append("REGEXP(");
        this.appendValue(where);
        where.append(", ");
        this.appendPattern(where);
        where.append(", ");
        this.appendFlags(where);
        where.append(")");
    }

    protected SqlExprBuilder appendValue(SqlExprBuilder where) {
        where.append(this.value.toSql());
        where.addParameters(this.value.getParameters());
        return where;
    }

    protected SqlExprBuilder appendPattern(SqlExprBuilder where) {
        where.append(this.pattern.toSql());
        where.addParameters(this.pattern.getParameters());
        return where;
    }

    protected SqlExprBuilder appendFlags(SqlExprBuilder where) {
        where.append(this.flags.toSql());
        where.addParameters(this.flags.getParameters());
        return where;
    }
}

