/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.model.Value;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.ValueType;

public class LongIdSequence
extends IdSequence {
    private long SPAN = 0xFFFFFFFFFFFFFFFL;
    private int SHIFT = Long.toBinaryString(this.SPAN).length();
    private Number[] minIds;
    private ConcurrentMap<ValueType, AtomicLong> seq = new ConcurrentHashMap<ValueType, AtomicLong>();

    public int getShift() {
        return this.SHIFT;
    }

    public int getJdbcIdType() {
        return -5;
    }

    public String getSqlType() {
        return "BIGINT";
    }

    public void init() throws SQLException {
        this.minIds = new Number[ValueType.values().length];
        for (int i = 0; i < this.minIds.length; ++i) {
            this.minIds[i] = (long)i * (this.SPAN + 1L);
        }
        if (this.getHashTable() != null) {
            for (Long max : this.getHashTable().maxIds(this.getShift(), this.getMod())) {
                ValueType code = this.valueOf(max);
                if (max <= this.minId(code).longValue() || this.seq.containsKey((Object)code) && ((AtomicLong)this.seq.get((Object)code)).longValue() >= max) continue;
                this.seq.put(code, new AtomicLong(max));
            }
        }
    }

    public Number idOf(Number number) {
        return number.longValue();
    }

    public Number maxId(ValueType type) {
        return this.minId(type).longValue() + this.SPAN;
    }

    public Number minId(ValueType type) {
        return this.minIds[type.index()];
    }

    public Number nextId(Value value) {
        ValueType code = this.valueOf(value);
        if (!this.seq.containsKey((Object)code)) {
            this.seq.putIfAbsent(code, new AtomicLong(this.minId(code).longValue()));
        }
        return ((AtomicLong)this.seq.get((Object)code)).incrementAndGet();
    }

    protected int shift(Number id) {
        return (int)(id.longValue() >>> this.SHIFT);
    }
}

