/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

const IOSERVICE_CTRID = "@mozilla.org/network/io-service;1";
const nsIIOService    = Components.interfaces.nsIIOService;
const SIS_CTRID       = "@mozilla.org/scriptableinputstream;1"
const nsIScriptableInputStream = Components.interfaces.nsIScriptableInputStream;
const nsIChannel      = Components.interfaces.nsIChannel;
const nsIInputStream  = Components.interfaces.nsIInputStream;
const nsIRequest      = Components.interfaces.nsIRequest;

function _getChannelForURL (url)
{
    var serv = Components.classes[IOSERVICE_CTRID].getService(nsIIOService);
    if (!serv)
        throw new BadMojo(ERR_FAILURE);

    return serv.newChannel(url, null, null);

}

function fixURL(url) {
    // Due to the patch for bug 418356, we possibly need to filter out the
    // right part of the url.
    return url.replace(/^file:.* -> (.*)/, "$1").replace(/^resource:.* -> (.*)/, "$1").replace(/^file:\/?([^\/])/, "file:///$1");
}

function loadURLNow (url)
{
    url = fixURL(url);

    var chan = _getChannelForURL (url);
    chan.loadFlags |= nsIRequest.LOAD_BYPASS_CACHE;
    var instream = 
        Components.classes[SIS_CTRID].createInstance(nsIScriptableInputStream);
    instream.init (chan.open());

    var result = "";
    var avail;

    while ((avail = instream.available()) > 0)
        result += instream.read(avail);

    return result;
}

function loadURLAsync (url, observer)
{
    url = fixURL(url);

    var chan = _getChannelForURL (url);
    chan.loadFlags |= nsIRequest.LOAD_BYPASS_CACHE;
    return chan.asyncOpen (new StreamListener (url, observer), null);
}
    
function StreamListener(url, observer)
{
    this.data = "";
    this.url = url;
    this.observer = observer;
}

StreamListener.prototype.onStartRequest =
function (request, context)
{
    //dd ("onStartRequest()");
}

StreamListener.prototype.onStopRequest =
function (request, context, status)
{
    //dd ("onStopRequest(): status: " + status /* + "\n"  + this.data*/);
    if (typeof this.observer.onComplete == "function")
        this.observer.onComplete (this.data, this.url, status);
}

StreamListener.prototype.onDataAvailable =
function (request, context, inStr, sourceOffset, count)
{
    //dd ("onDataAvailable(): " + count);
    // sometimes the inStr changes between onDataAvailable calls, so we
    // can't cache it.
    var sis = 
        Components.classes[SIS_CTRID].createInstance(nsIScriptableInputStream);
    sis.init(inStr);
    this.data += sis.read(count);
}
