// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
#include <arm_neon.h>

// RUN: %clang_cc1  -triple aarch64-none-linux-gnu -target-feature +neon -target-feature +lut -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -p mem2reg,sroa | FileCheck %s

// REQUIRES: aarch64-registered-target

// CHECK-LABEL: define dso_local <8 x i8> @test_vset_lane_mf8(
// CHECK-SAME: <1 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <1 x i8> [[A]] to i8
// CHECK-NEXT:    [[VSET_LANE:%.*]] = insertelement <8 x i8> [[B]], i8 [[TMP0]], i32 7
// CHECK-NEXT:    ret <8 x i8> [[VSET_LANE]]
//
mfloat8x8_t test_vset_lane_mf8(mfloat8_t a, mfloat8x8_t b) {
  return vset_lane_mf8(a, b, 7);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vsetq_lane_mf8(
// CHECK-SAME: <1 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <1 x i8> [[A]] to i8
// CHECK-NEXT:    [[VSET_LANE:%.*]] = insertelement <16 x i8> [[B]], i8 [[TMP0]], i32 15
// CHECK-NEXT:    ret <16 x i8> [[VSET_LANE]]
//
mfloat8x16_t test_vsetq_lane_mf8(mfloat8_t a, mfloat8x16_t b) {
  return vsetq_lane_mf8(a, b, 15);
}


// CHECK-LABEL: define dso_local <1 x i8> @test_vget_lane_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <8 x i8> [[A]], i32 7
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i8 [[VGET_LANE]] to <1 x i8>
// CHECK-NEXT:    ret <1 x i8> [[TMP0]]
//
mfloat8_t test_vget_lane_mf8(mfloat8x8_t a) {
  return vget_lane_mf8(a, 7);
}

// CHECK-LABEL: define dso_local <1 x i8> @test_vdupb_lane_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <8 x i8> [[A]], i32 7
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i8 [[VGET_LANE]] to <1 x i8>
// CHECK-NEXT:    ret <1 x i8> [[TMP0]]
//
mfloat8_t test_vdupb_lane_mf8(mfloat8x8_t a) {
  return vdupb_lane_mf8(a, 7);
}

// CHECK-LABEL: define dso_local <1 x i8> @test_vgetq_lane_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <16 x i8> [[A]], i32 15
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i8 [[VGET_LANE]] to <1 x i8>
// CHECK-NEXT:    ret <1 x i8> [[TMP0]]
//
mfloat8_t test_vgetq_lane_mf8(mfloat8x16_t a) {
  return vgetq_lane_mf8(a, 15);
}

// CHECK-LABEL: define dso_local <1 x i8> @test_vdupb_laneq_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <16 x i8> [[A]], i32 15
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i8 [[VGET_LANE]] to <1 x i8>
// CHECK-NEXT:    ret <1 x i8> [[TMP0]]
//
mfloat8_t test_vdupb_laneq_mf8(mfloat8x16_t a) {
  return vdupb_laneq_mf8(a, 15);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vcreate_mf8(
// CHECK-SAME: i64 noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i64 [[A]] to <8 x i8>
// CHECK-NEXT:    ret <8 x i8> [[TMP0]]
//
mfloat8x8_t test_vcreate_mf8(uint64_t a) {
  return vcreate_mf8(a);
}


// CHECK-LABEL: define dso_local <8 x i8> @test_vdup_n_mf8(
// CHECK-SAME: <1 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VEXT_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT_I:%.*]] = shufflevector <8 x i8> [[VEXT_I]], <8 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT1_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT2_I:%.*]] = shufflevector <8 x i8> [[VECINIT_I]], <8 x i8> [[VEXT1_I]], <8 x i32> <i32 0, i32 8, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT3_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT4_I:%.*]] = shufflevector <8 x i8> [[VECINIT2_I]], <8 x i8> [[VEXT3_I]], <8 x i32> <i32 0, i32 1, i32 8, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT5_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT6_I:%.*]] = shufflevector <8 x i8> [[VECINIT4_I]], <8 x i8> [[VEXT5_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 8, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT7_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT8_I:%.*]] = shufflevector <8 x i8> [[VECINIT6_I]], <8 x i8> [[VEXT7_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT9_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT10_I:%.*]] = shufflevector <8 x i8> [[VECINIT8_I]], <8 x i8> [[VEXT9_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 8, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT11_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT12_I:%.*]] = shufflevector <8 x i8> [[VECINIT10_I]], <8 x i8> [[VEXT11_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 poison>
// CHECK-NEXT:    [[VEXT13_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT14_I:%.*]] = shufflevector <8 x i8> [[VECINIT12_I]], <8 x i8> [[VEXT13_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 8>
// CHECK-NEXT:    ret <8 x i8> [[VECINIT14_I]]
//
mfloat8x8_t test_vdup_n_mf8(mfloat8_t a) {
  return vdup_n_mf8(a);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vdupq_n_mf8(
// CHECK-SAME: <1 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VEXT_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT_I:%.*]] = shufflevector <16 x i8> [[VEXT_I]], <16 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT1_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT2_I:%.*]] = shufflevector <16 x i8> [[VECINIT_I]], <16 x i8> [[VEXT1_I]], <16 x i32> <i32 0, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT3_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT4_I:%.*]] = shufflevector <16 x i8> [[VECINIT2_I]], <16 x i8> [[VEXT3_I]], <16 x i32> <i32 0, i32 1, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT5_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT6_I:%.*]] = shufflevector <16 x i8> [[VECINIT4_I]], <16 x i8> [[VEXT5_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT7_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT8_I:%.*]] = shufflevector <16 x i8> [[VECINIT6_I]], <16 x i8> [[VEXT7_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT9_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT10_I:%.*]] = shufflevector <16 x i8> [[VECINIT8_I]], <16 x i8> [[VEXT9_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT11_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT12_I:%.*]] = shufflevector <16 x i8> [[VECINIT10_I]], <16 x i8> [[VEXT11_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT13_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT14_I:%.*]] = shufflevector <16 x i8> [[VECINIT12_I]], <16 x i8> [[VEXT13_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT15_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT16_I:%.*]] = shufflevector <16 x i8> [[VECINIT14_I]], <16 x i8> [[VEXT15_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT17_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT18_I:%.*]] = shufflevector <16 x i8> [[VECINIT16_I]], <16 x i8> [[VEXT17_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT19_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT20_I:%.*]] = shufflevector <16 x i8> [[VECINIT18_I]], <16 x i8> [[VEXT19_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT21_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT22_I:%.*]] = shufflevector <16 x i8> [[VECINIT20_I]], <16 x i8> [[VEXT21_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 16, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT23_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT24_I:%.*]] = shufflevector <16 x i8> [[VECINIT22_I]], <16 x i8> [[VEXT23_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT25_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT26_I:%.*]] = shufflevector <16 x i8> [[VECINIT24_I]], <16 x i8> [[VEXT25_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 16, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT27_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT28_I:%.*]] = shufflevector <16 x i8> [[VECINIT26_I]], <16 x i8> [[VEXT27_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 16, i32 poison>
// CHECK-NEXT:    [[VEXT29_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT30_I:%.*]] = shufflevector <16 x i8> [[VECINIT28_I]], <16 x i8> [[VEXT29_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 16>
// CHECK-NEXT:    ret <16 x i8> [[VECINIT30_I]]
//
mfloat8x16_t test_vdupq_n_mf8(mfloat8_t a) {
  return vdupq_n_mf8(a);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vmov_n_mf8(
// CHECK-SAME: <1 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VEXT_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT_I:%.*]] = shufflevector <8 x i8> [[VEXT_I]], <8 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT1_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT2_I:%.*]] = shufflevector <8 x i8> [[VECINIT_I]], <8 x i8> [[VEXT1_I]], <8 x i32> <i32 0, i32 8, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT3_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT4_I:%.*]] = shufflevector <8 x i8> [[VECINIT2_I]], <8 x i8> [[VEXT3_I]], <8 x i32> <i32 0, i32 1, i32 8, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT5_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT6_I:%.*]] = shufflevector <8 x i8> [[VECINIT4_I]], <8 x i8> [[VEXT5_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 8, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT7_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT8_I:%.*]] = shufflevector <8 x i8> [[VECINIT6_I]], <8 x i8> [[VEXT7_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 8, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT9_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT10_I:%.*]] = shufflevector <8 x i8> [[VECINIT8_I]], <8 x i8> [[VEXT9_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 8, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT11_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT12_I:%.*]] = shufflevector <8 x i8> [[VECINIT10_I]], <8 x i8> [[VEXT11_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 8, i32 poison>
// CHECK-NEXT:    [[VEXT13_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <8 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT14_I:%.*]] = shufflevector <8 x i8> [[VECINIT12_I]], <8 x i8> [[VEXT13_I]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 8>
// CHECK-NEXT:    ret <8 x i8> [[VECINIT14_I]]
//
mfloat8x8_t test_vmov_n_mf8(mfloat8_t a) {
  return vmov_n_mf8(a);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vmovq_n_mf8(
// CHECK-SAME: <1 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VEXT_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT_I:%.*]] = shufflevector <16 x i8> [[VEXT_I]], <16 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT1_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT2_I:%.*]] = shufflevector <16 x i8> [[VECINIT_I]], <16 x i8> [[VEXT1_I]], <16 x i32> <i32 0, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT3_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT4_I:%.*]] = shufflevector <16 x i8> [[VECINIT2_I]], <16 x i8> [[VEXT3_I]], <16 x i32> <i32 0, i32 1, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT5_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT6_I:%.*]] = shufflevector <16 x i8> [[VECINIT4_I]], <16 x i8> [[VEXT5_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT7_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT8_I:%.*]] = shufflevector <16 x i8> [[VECINIT6_I]], <16 x i8> [[VEXT7_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT9_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT10_I:%.*]] = shufflevector <16 x i8> [[VECINIT8_I]], <16 x i8> [[VEXT9_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT11_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT12_I:%.*]] = shufflevector <16 x i8> [[VECINIT10_I]], <16 x i8> [[VEXT11_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT13_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT14_I:%.*]] = shufflevector <16 x i8> [[VECINIT12_I]], <16 x i8> [[VEXT13_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT15_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT16_I:%.*]] = shufflevector <16 x i8> [[VECINIT14_I]], <16 x i8> [[VEXT15_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT17_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT18_I:%.*]] = shufflevector <16 x i8> [[VECINIT16_I]], <16 x i8> [[VEXT17_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT19_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT20_I:%.*]] = shufflevector <16 x i8> [[VECINIT18_I]], <16 x i8> [[VEXT19_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 16, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT21_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT22_I:%.*]] = shufflevector <16 x i8> [[VECINIT20_I]], <16 x i8> [[VEXT21_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 16, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT23_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT24_I:%.*]] = shufflevector <16 x i8> [[VECINIT22_I]], <16 x i8> [[VEXT23_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 16, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT25_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT26_I:%.*]] = shufflevector <16 x i8> [[VECINIT24_I]], <16 x i8> [[VEXT25_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 16, i32 poison, i32 poison>
// CHECK-NEXT:    [[VEXT27_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT28_I:%.*]] = shufflevector <16 x i8> [[VECINIT26_I]], <16 x i8> [[VEXT27_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 16, i32 poison>
// CHECK-NEXT:    [[VEXT29_I:%.*]] = shufflevector <1 x i8> [[A]], <1 x i8> poison, <16 x i32> <i32 0, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
// CHECK-NEXT:    [[VECINIT30_I:%.*]] = shufflevector <16 x i8> [[VECINIT28_I]], <16 x i8> [[VEXT29_I]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 16>
// CHECK-NEXT:    ret <16 x i8> [[VECINIT30_I]]
//
mfloat8x16_t test_vmovq_n_mf8(mfloat8_t a) {
  return vmovq_n_mf8(a);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vcombine_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vcombine_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vcombine_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vget_high_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[A]], <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vget_high_mf8(mfloat8x16_t a) {
  return vget_high_mf8(a);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vget_low_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[A]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vget_low_mf8(mfloat8x16_t a) {
  return vget_low_mf8(a);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtbl1_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> noundef [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VTBL1_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBL11_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl1.v8i8(<16 x i8> [[VTBL1_I]], <8 x i8> [[B]])
// CHECK-NEXT:    ret <8 x i8> [[VTBL11_I]]
//
mfloat8x8_t test_vtbl1_mf8(mfloat8x8_t a, uint8x8_t b) {
  return vtbl1_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtbl2_mf8(
// CHECK-SAME: [2 x <8 x i8>] alignstack(8) [[A_COERCE:%.*]], <8 x i8> noundef [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[A_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[A_COERCE]], 0
// CHECK-NEXT:    [[A_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[A_COERCE]], 1
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [2 x <8 x i8>] poison, <8 x i8> [[A_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [2 x <8 x i8>] [[DOTFCA_0_INSERT]], <8 x i8> [[A_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[DOTFCA_1_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[DOTFCA_1_INSERT]], 1
// CHECK-NEXT:    [[VTBL1_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_1_INSERT_FCA_0_EXTRACT]], <8 x i8> [[DOTFCA_1_INSERT_FCA_1_EXTRACT]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBL13_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl1.v8i8(<16 x i8> [[VTBL1_I]], <8 x i8> [[B]])
// CHECK-NEXT:    ret <8 x i8> [[VTBL13_I]]
//
mfloat8x8_t test_vtbl2_mf8(mfloat8x8x2_t a, uint8x8_t b) {
  return vtbl2_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtbl3_mf8(
// CHECK-SAME: [3 x <8 x i8>] alignstack(8) [[A_COERCE:%.*]], <8 x i8> noundef [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[A_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[A_COERCE]], 0
// CHECK-NEXT:    [[A_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[A_COERCE]], 1
// CHECK-NEXT:    [[A_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[A_COERCE]], 2
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [3 x <8 x i8>] poison, <8 x i8> [[A_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [3 x <8 x i8>] [[DOTFCA_0_INSERT]], <8 x i8> [[A_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [3 x <8 x i8>] [[DOTFCA_1_INSERT]], <8 x i8> [[A_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[DOTFCA_2_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[DOTFCA_2_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[DOTFCA_2_INSERT]], 2
// CHECK-NEXT:    [[VTBL2_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_2_INSERT_FCA_0_EXTRACT]], <8 x i8> [[DOTFCA_2_INSERT_FCA_1_EXTRACT]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBL25_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_2_INSERT_FCA_2_EXTRACT]], <8 x i8> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBL26_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl2.v8i8(<16 x i8> [[VTBL2_I]], <16 x i8> [[VTBL25_I]], <8 x i8> [[B]])
// CHECK-NEXT:    ret <8 x i8> [[VTBL26_I]]
//
mfloat8x8_t test_vtbl3_mf8(mfloat8x8x3_t a, uint8x8_t b) {
  return vtbl3_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtbl4_mf8(
// CHECK-SAME: [4 x <8 x i8>] alignstack(8) [[A_COERCE:%.*]], <8 x i8> noundef [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[A_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[A_COERCE]], 0
// CHECK-NEXT:    [[A_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[A_COERCE]], 1
// CHECK-NEXT:    [[A_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[A_COERCE]], 2
// CHECK-NEXT:    [[A_COERCE_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[A_COERCE]], 3
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [4 x <8 x i8>] poison, <8 x i8> [[A_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [4 x <8 x i8>] [[DOTFCA_0_INSERT]], <8 x i8> [[A_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [4 x <8 x i8>] [[DOTFCA_1_INSERT]], <8 x i8> [[A_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT:%.*]] = insertvalue [4 x <8 x i8>] [[DOTFCA_2_INSERT]], <8 x i8> [[A_COERCE_FCA_3_EXTRACT]], 3
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[DOTFCA_3_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[DOTFCA_3_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[DOTFCA_3_INSERT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[DOTFCA_3_INSERT]], 3
// CHECK-NEXT:    [[VTBL2_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_3_INSERT_FCA_0_EXTRACT]], <8 x i8> [[DOTFCA_3_INSERT_FCA_1_EXTRACT]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBL27_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_3_INSERT_FCA_2_EXTRACT]], <8 x i8> [[DOTFCA_3_INSERT_FCA_3_EXTRACT]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBL28_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl2.v8i8(<16 x i8> [[VTBL2_I]], <16 x i8> [[VTBL27_I]], <8 x i8> [[B]])
// CHECK-NEXT:    ret <8 x i8> [[VTBL28_I]]
//
mfloat8x8_t test_vtbl4_mf8(mfloat8x8x4_t a, uint8x8_t b) {
  return vtbl4_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtbx1_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]], <8 x i8> noundef [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VTBL1_I:%.*]] = shufflevector <8 x i8> [[B]], <8 x i8> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBL11_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl1.v8i8(<16 x i8> [[VTBL1_I]], <8 x i8> [[C]])
// CHECK-NEXT:    [[TMP0:%.*]] = icmp uge <8 x i8> [[C]], splat (i8 8)
// CHECK-NEXT:    [[TMP1:%.*]] = sext <8 x i1> [[TMP0]] to <8 x i8>
// CHECK-NEXT:    [[TMP2:%.*]] = and <8 x i8> [[TMP1]], [[A]]
// CHECK-NEXT:    [[TMP3:%.*]] = xor <8 x i8> [[TMP1]], splat (i8 -1)
// CHECK-NEXT:    [[TMP4:%.*]] = and <8 x i8> [[TMP3]], [[VTBL11_I]]
// CHECK-NEXT:    [[VTBX_I:%.*]] = or <8 x i8> [[TMP2]], [[TMP4]]
// CHECK-NEXT:    ret <8 x i8> [[VTBX_I]]
//
mfloat8x8_t test_vtbx1_mf8(mfloat8x8_t a, mfloat8x8_t b, uint8x8_t c) {
  return vtbx1_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtbx2_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], [2 x <8 x i8>] alignstack(8) [[B_COERCE:%.*]], <8 x i8> noundef [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[B_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[B_COERCE]], 0
// CHECK-NEXT:    [[B_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[B_COERCE]], 1
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [2 x <8 x i8>] poison, <8 x i8> [[B_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [2 x <8 x i8>] [[DOTFCA_0_INSERT]], <8 x i8> [[B_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[DOTFCA_1_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[DOTFCA_1_INSERT]], 1
// CHECK-NEXT:    [[VTBX1_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_1_INSERT_FCA_0_EXTRACT]], <8 x i8> [[DOTFCA_1_INSERT_FCA_1_EXTRACT]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBX13_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbx1.v8i8(<8 x i8> [[A]], <16 x i8> [[VTBX1_I]], <8 x i8> [[C]])
// CHECK-NEXT:    ret <8 x i8> [[VTBX13_I]]
//
mfloat8x8_t test_vtbx2_mf8(mfloat8x8_t a, mfloat8x8x2_t b, uint8x8_t c) {
  return vtbx2_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtbx3_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], [3 x <8 x i8>] alignstack(8) [[B_COERCE:%.*]], <8 x i8> noundef [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[B_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[B_COERCE]], 0
// CHECK-NEXT:    [[B_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[B_COERCE]], 1
// CHECK-NEXT:    [[B_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[B_COERCE]], 2
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [3 x <8 x i8>] poison, <8 x i8> [[B_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [3 x <8 x i8>] [[DOTFCA_0_INSERT]], <8 x i8> [[B_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [3 x <8 x i8>] [[DOTFCA_1_INSERT]], <8 x i8> [[B_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[DOTFCA_2_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[DOTFCA_2_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <8 x i8>] [[DOTFCA_2_INSERT]], 2
// CHECK-NEXT:    [[VTBL2_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_2_INSERT_FCA_0_EXTRACT]], <8 x i8> [[DOTFCA_2_INSERT_FCA_1_EXTRACT]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBL25_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_2_INSERT_FCA_2_EXTRACT]], <8 x i8> zeroinitializer, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBL26_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl2.v8i8(<16 x i8> [[VTBL2_I]], <16 x i8> [[VTBL25_I]], <8 x i8> [[C]])
// CHECK-NEXT:    [[TMP0:%.*]] = icmp uge <8 x i8> [[C]], splat (i8 24)
// CHECK-NEXT:    [[TMP1:%.*]] = sext <8 x i1> [[TMP0]] to <8 x i8>
// CHECK-NEXT:    [[TMP2:%.*]] = and <8 x i8> [[TMP1]], [[A]]
// CHECK-NEXT:    [[TMP3:%.*]] = xor <8 x i8> [[TMP1]], splat (i8 -1)
// CHECK-NEXT:    [[TMP4:%.*]] = and <8 x i8> [[TMP3]], [[VTBL26_I]]
// CHECK-NEXT:    [[VTBX_I:%.*]] = or <8 x i8> [[TMP2]], [[TMP4]]
// CHECK-NEXT:    ret <8 x i8> [[VTBX_I]]
//
mfloat8x8_t test_vtbx3_mf8(mfloat8x8_t a, mfloat8x8x3_t b, uint8x8_t c) {
  return vtbx3_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtbx4_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], [4 x <8 x i8>] alignstack(8) [[B_COERCE:%.*]], <8 x i8> noundef [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[B_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[B_COERCE]], 0
// CHECK-NEXT:    [[B_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[B_COERCE]], 1
// CHECK-NEXT:    [[B_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[B_COERCE]], 2
// CHECK-NEXT:    [[B_COERCE_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[B_COERCE]], 3
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [4 x <8 x i8>] poison, <8 x i8> [[B_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [4 x <8 x i8>] [[DOTFCA_0_INSERT]], <8 x i8> [[B_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [4 x <8 x i8>] [[DOTFCA_1_INSERT]], <8 x i8> [[B_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT:%.*]] = insertvalue [4 x <8 x i8>] [[DOTFCA_2_INSERT]], <8 x i8> [[B_COERCE_FCA_3_EXTRACT]], 3
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[DOTFCA_3_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[DOTFCA_3_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[DOTFCA_3_INSERT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <8 x i8>] [[DOTFCA_3_INSERT]], 3
// CHECK-NEXT:    [[VTBX2_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_3_INSERT_FCA_0_EXTRACT]], <8 x i8> [[DOTFCA_3_INSERT_FCA_1_EXTRACT]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBX27_I:%.*]] = shufflevector <8 x i8> [[DOTFCA_3_INSERT_FCA_2_EXTRACT]], <8 x i8> [[DOTFCA_3_INSERT_FCA_3_EXTRACT]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
// CHECK-NEXT:    [[VTBX28_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbx2.v8i8(<8 x i8> [[A]], <16 x i8> [[VTBX2_I]], <16 x i8> [[VTBX27_I]], <8 x i8> [[C]])
// CHECK-NEXT:    ret <8 x i8> [[VTBX28_I]]
//
mfloat8x8_t test_vtbx4_mf8(mfloat8x8_t a, mfloat8x8x4_t b, uint8x8_t c) {
  return vtbx4_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vext_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VEXT:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14>
// CHECK-NEXT:    ret <8 x i8> [[VEXT]]
//
mfloat8x8_t test_vext_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vext_mf8(a, b, 7);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vextq_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VEXT:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22>
// CHECK-NEXT:    ret <16 x i8> [[VEXT]]
//
mfloat8x16_t test_vextq_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vextq_mf8(a, b, 7);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vrev64_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[A]], <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vrev64_mf8(mfloat8x8_t a) {
  return vrev64_mf8(a);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vrev64q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[A]], <16 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vrev64q_mf8(mfloat8x16_t a) {
  return vrev64q_mf8(a);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vrev32_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[A]], <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vrev32_mf8(mfloat8x8_t a) {
  return vrev32_mf8(a);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vrev32q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[A]], <16 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4, i32 11, i32 10, i32 9, i32 8, i32 15, i32 14, i32 13, i32 12>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vrev32q_mf8(mfloat8x16_t a) {
  return vrev32q_mf8(a);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vrev16_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[A]], <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vrev16_mf8(mfloat8x8_t a) {
  return vrev16_mf8(a);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vrev16q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[A]], <16 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6, i32 9, i32 8, i32 11, i32 10, i32 13, i32 12, i32 15, i32 14>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vrev16q_mf8(mfloat8x16_t a) {
  return vrev16q_mf8(a);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vbsl_mf8(
// CHECK-SAME: <8 x i8> noundef [[V1:%.*]], <8 x i8> [[V2:%.*]], <8 x i8> [[V3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VBSL_I:%.*]] = and <8 x i8> [[V1]], [[V2]]
// CHECK-NEXT:    [[TMP0:%.*]] = xor <8 x i8> [[V1]], splat (i8 -1)
// CHECK-NEXT:    [[VBSL1_I:%.*]] = and <8 x i8> [[TMP0]], [[V3]]
// CHECK-NEXT:    [[VBSL2_I:%.*]] = or <8 x i8> [[VBSL_I]], [[VBSL1_I]]
// CHECK-NEXT:    ret <8 x i8> [[VBSL2_I]]
//
mfloat8x8_t test_vbsl_mf8(uint8x8_t v1, mfloat8x8_t v2, mfloat8x8_t v3) {
  return vbsl_mf8(v1, v2, v3);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vbslq_mf8(
// CHECK-SAME: <16 x i8> noundef [[V1:%.*]], <16 x i8> [[V2:%.*]], <16 x i8> [[V3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VBSL_I:%.*]] = and <16 x i8> [[V1]], [[V2]]
// CHECK-NEXT:    [[TMP0:%.*]] = xor <16 x i8> [[V1]], splat (i8 -1)
// CHECK-NEXT:    [[VBSL1_I:%.*]] = and <16 x i8> [[TMP0]], [[V3]]
// CHECK-NEXT:    [[VBSL2_I:%.*]] = or <16 x i8> [[VBSL_I]], [[VBSL1_I]]
// CHECK-NEXT:    ret <16 x i8> [[VBSL2_I]]
//
mfloat8x16_t test_vbslq_mf8(uint8x16_t v1, mfloat8x16_t v2, mfloat8x16_t v3) {
  return vbslq_mf8(v1, v2, v3);
}

// CHECK-LABEL: define dso_local %struct.mfloat8x8x2_t @test_vtrn_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VTRN_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
// CHECK-NEXT:    [[VTRN1_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT1:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T:%.*]] poison, <8 x i8> [[VTRN_I]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT2:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_0_INSERT1]], <8 x i8> [[VTRN1_I]], 0, 1
// CHECK-NEXT:    [[TMP0:%.*]] = extractvalue [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_1_INSERT2]], 0
// CHECK-NEXT:    [[DOTFCA_0_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[TMP0]], 0
// CHECK-NEXT:    [[DOTFCA_1_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[TMP0]], 1
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T]] poison, <8 x i8> [[DOTFCA_0_EXTRACT]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_0_INSERT]], <8 x i8> [[DOTFCA_1_EXTRACT]], 0, 1
// CHECK-NEXT:    ret [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_1_INSERT]]
//
mfloat8x8x2_t test_vtrn_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vtrn_mf8(a, b);
}

// CHECK-LABEL: define dso_local %struct.mfloat8x16x2_t @test_vtrnq_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VTRN_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 0, i32 16, i32 2, i32 18, i32 4, i32 20, i32 6, i32 22, i32 8, i32 24, i32 10, i32 26, i32 12, i32 28, i32 14, i32 30>
// CHECK-NEXT:    [[VTRN1_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 1, i32 17, i32 3, i32 19, i32 5, i32 21, i32 7, i32 23, i32 9, i32 25, i32 11, i32 27, i32 13, i32 29, i32 15, i32 31>
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT1:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T:%.*]] poison, <16 x i8> [[VTRN_I]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT2:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_0_INSERT1]], <16 x i8> [[VTRN1_I]], 0, 1
// CHECK-NEXT:    [[TMP0:%.*]] = extractvalue [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_1_INSERT2]], 0
// CHECK-NEXT:    [[DOTFCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[TMP0]], 0
// CHECK-NEXT:    [[DOTFCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[TMP0]], 1
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T]] poison, <16 x i8> [[DOTFCA_0_EXTRACT]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_0_INSERT]], <16 x i8> [[DOTFCA_1_EXTRACT]], 0, 1
// CHECK-NEXT:    ret [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_1_INSERT]]
//
mfloat8x16x2_t test_vtrnq_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vtrnq_mf8(a, b);
}

// CHECK-LABEL: define dso_local %struct.mfloat8x8x2_t @test_vzip_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VZIP_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
// CHECK-NEXT:    [[VZIP1_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT1:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T:%.*]] poison, <8 x i8> [[VZIP_I]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT2:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_0_INSERT1]], <8 x i8> [[VZIP1_I]], 0, 1
// CHECK-NEXT:    [[TMP0:%.*]] = extractvalue [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_1_INSERT2]], 0
// CHECK-NEXT:    [[DOTFCA_0_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[TMP0]], 0
// CHECK-NEXT:    [[DOTFCA_1_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[TMP0]], 1
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T]] poison, <8 x i8> [[DOTFCA_0_EXTRACT]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_0_INSERT]], <8 x i8> [[DOTFCA_1_EXTRACT]], 0, 1
// CHECK-NEXT:    ret [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_1_INSERT]]
//
mfloat8x8x2_t test_vzip_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vzip_mf8(a, b);
}

// CHECK-LABEL: define dso_local %struct.mfloat8x16x2_t @test_vzipq_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VZIP_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
// CHECK-NEXT:    [[VZIP1_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT1:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T:%.*]] poison, <16 x i8> [[VZIP_I]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT2:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_0_INSERT1]], <16 x i8> [[VZIP1_I]], 0, 1
// CHECK-NEXT:    [[TMP0:%.*]] = extractvalue [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_1_INSERT2]], 0
// CHECK-NEXT:    [[DOTFCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[TMP0]], 0
// CHECK-NEXT:    [[DOTFCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[TMP0]], 1
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T]] poison, <16 x i8> [[DOTFCA_0_EXTRACT]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_0_INSERT]], <16 x i8> [[DOTFCA_1_EXTRACT]], 0, 1
// CHECK-NEXT:    ret [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_1_INSERT]]
//
mfloat8x16x2_t test_vzipq_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vzipq_mf8(a, b);
}

// CHECK-LABEL: define dso_local %struct.mfloat8x8x2_t @test_vuzp_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VUZP_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
// CHECK-NEXT:    [[VUZP1_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT1:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T:%.*]] poison, <8 x i8> [[VUZP_I]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT2:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_0_INSERT1]], <8 x i8> [[VUZP1_I]], 0, 1
// CHECK-NEXT:    [[TMP0:%.*]] = extractvalue [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_1_INSERT2]], 0
// CHECK-NEXT:    [[DOTFCA_0_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[TMP0]], 0
// CHECK-NEXT:    [[DOTFCA_1_EXTRACT:%.*]] = extractvalue [2 x <8 x i8>] [[TMP0]], 1
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T]] poison, <8 x i8> [[DOTFCA_0_EXTRACT]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_0_INSERT]], <8 x i8> [[DOTFCA_1_EXTRACT]], 0, 1
// CHECK-NEXT:    ret [[STRUCT_MFLOAT8X8X2_T]] [[DOTFCA_0_1_INSERT]]
//
mfloat8x8x2_t test_vuzp_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vuzp_mf8(a, b);
}

// CHECK-LABEL: define dso_local %struct.mfloat8x16x2_t @test_vuzpq_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VUZP_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
// CHECK-NEXT:    [[VUZP1_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT1:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T:%.*]] poison, <16 x i8> [[VUZP_I]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT2:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_0_INSERT1]], <16 x i8> [[VUZP1_I]], 0, 1
// CHECK-NEXT:    [[TMP0:%.*]] = extractvalue [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_1_INSERT2]], 0
// CHECK-NEXT:    [[DOTFCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[TMP0]], 0
// CHECK-NEXT:    [[DOTFCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[TMP0]], 1
// CHECK-NEXT:    [[DOTFCA_0_0_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T]] poison, <16 x i8> [[DOTFCA_0_EXTRACT]], 0, 0
// CHECK-NEXT:    [[DOTFCA_0_1_INSERT:%.*]] = insertvalue [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_0_INSERT]], <16 x i8> [[DOTFCA_1_EXTRACT]], 0, 1
// CHECK-NEXT:    ret [[STRUCT_MFLOAT8X16X2_T]] [[DOTFCA_0_1_INSERT]]
//
mfloat8x16x2_t test_vuzpq_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vuzpq_mf8(a, b);
}

// CHECK-LABEL: define dso_local void @test_vcopy_lane_mf8(
// CHECK-SAME: <8 x i8> [[ARG_I8X8:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <8 x i8> [[ARG_I8X8]], i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i8 [[VGET_LANE]] to <1 x i8>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <1 x i8> [[TMP0]] to i8
// CHECK-NEXT:    [[VSET_LANE:%.*]] = insertelement <8 x i8> [[ARG_I8X8]], i8 [[TMP1]], i32 0
// CHECK-NEXT:    ret void
//
void test_vcopy_lane_mf8(mfloat8x8_t arg_i8x8) {
	vcopy_lane_mf8(arg_i8x8, 0, arg_i8x8, 0);
}

// CHECK-LABEL: define dso_local void @test_vcopyq_lane_mf8(
// CHECK-SAME: <8 x i8> [[ARG_I8X8:%.*]], <16 x i8> [[ARG_I8X16:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <8 x i8> [[ARG_I8X8]], i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i8 [[VGET_LANE]] to <1 x i8>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <1 x i8> [[TMP0]] to i8
// CHECK-NEXT:    [[VSET_LANE:%.*]] = insertelement <16 x i8> [[ARG_I8X16]], i8 [[TMP1]], i32 0
// CHECK-NEXT:    ret void
//
void test_vcopyq_lane_mf8(mfloat8x8_t arg_i8x8, mfloat8x16_t arg_i8x16) {
	vcopyq_lane_mf8(arg_i8x16, 0, arg_i8x8, 0);
}

// CHECK-LABEL: define dso_local void @test_vcopy_laneq_mf8(
// CHECK-SAME: <8 x i8> [[ARG_I8X8:%.*]], <16 x i8> [[ARG_I8X16:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <16 x i8> [[ARG_I8X16]], i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i8 [[VGET_LANE]] to <1 x i8>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <1 x i8> [[TMP0]] to i8
// CHECK-NEXT:    [[VSET_LANE:%.*]] = insertelement <8 x i8> [[ARG_I8X8]], i8 [[TMP1]], i32 0
// CHECK-NEXT:    ret void
//
void test_vcopy_laneq_mf8(mfloat8x8_t arg_i8x8, mfloat8x16_t arg_i8x16) {
	vcopy_laneq_mf8(arg_i8x8, 0, arg_i8x16, 0);
}

// CHECK-LABEL: define dso_local void @test_vcopyq_laneq_mf8(
// CHECK-SAME: <16 x i8> [[ARG_I8X16:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VGET_LANE:%.*]] = extractelement <16 x i8> [[ARG_I8X16]], i32 0
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast i8 [[VGET_LANE]] to <1 x i8>
// CHECK-NEXT:    [[TMP1:%.*]] = bitcast <1 x i8> [[TMP0]] to i8
// CHECK-NEXT:    [[VSET_LANE:%.*]] = insertelement <16 x i8> [[ARG_I8X16]], i8 [[TMP1]], i32 0
// CHECK-NEXT:    ret void
//
void test_vcopyq_laneq_mf8(mfloat8x16_t arg_i8x16) {
	vcopyq_laneq_mf8(arg_i8x16, 0, arg_i8x16, 0);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vdup_lane_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[LANE:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[A]], <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
// CHECK-NEXT:    ret <8 x i8> [[LANE]]
//
mfloat8x8_t test_vdup_lane_mf8(mfloat8x8_t a) {
  return vdup_lane_mf8(a, 7);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vdupq_lane_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[LANE:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[A]], <16 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
// CHECK-NEXT:    ret <16 x i8> [[LANE]]
//
mfloat8x16_t test_vdupq_lane_mf8(mfloat8x8_t a) {
  return vdupq_lane_mf8(a, 7);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vdup_laneq_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[LANE:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[A]], <8 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
// CHECK-NEXT:    ret <8 x i8> [[LANE]]
//
mfloat8x8_t test_vdup_laneq_mf8(mfloat8x16_t a) {
  return vdup_laneq_mf8(a, 7);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vdupq_laneq_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[LANE:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[A]], <16 x i32> <i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7, i32 7>
// CHECK-NEXT:    ret <16 x i8> [[LANE]]
//
mfloat8x16_t test_vdupq_laneq_mf8(mfloat8x16_t a) {
  return vdupq_laneq_mf8(a, 7);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtrn1_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vtrn1_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vtrn1_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vtrn1q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 0, i32 16, i32 2, i32 18, i32 4, i32 20, i32 6, i32 22, i32 8, i32 24, i32 10, i32 26, i32 12, i32 28, i32 14, i32 30>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vtrn1q_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vtrn1q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vzip1_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vzip1_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vzip1_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vzip1q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vzip1q_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vzip1q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vuzp1_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vuzp1_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vuzp1_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vuzp1q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vuzp1q_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vuzp1q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vtrn2_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vtrn2_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vtrn2_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vtrn2q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 1, i32 17, i32 3, i32 19, i32 5, i32 21, i32 7, i32 23, i32 9, i32 25, i32 11, i32 27, i32 13, i32 29, i32 15, i32 31>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vtrn2q_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vtrn2q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vzip2_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vzip2_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vzip2_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vzip2q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vzip2q_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vzip2q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vuzp2_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <8 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <8 x i8> [[A]], <8 x i8> [[B]], <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
// CHECK-NEXT:    ret <8 x i8> [[SHUFFLE_I]]
//
mfloat8x8_t test_vuzp2_mf8(mfloat8x8_t a, mfloat8x8_t b) {
  return vuzp2_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vuzp2q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[SHUFFLE_I:%.*]] = shufflevector <16 x i8> [[A]], <16 x i8> [[B]], <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
// CHECK-NEXT:    ret <16 x i8> [[SHUFFLE_I]]
//
mfloat8x16_t test_vuzp2q_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vuzp2q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vqtbl1_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <8 x i8> noundef [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VTBL1_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl1.v8i8(<16 x i8> [[A]], <8 x i8> [[B]])
// CHECK-NEXT:    ret <8 x i8> [[VTBL1_I]]
//
mfloat8x8_t test_vqtbl1_mf8(mfloat8x16_t a, uint8x8_t b) {
  return vqtbl1_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vqtbl1q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VTBL1_I:%.*]] = call <16 x i8> @llvm.aarch64.neon.tbl1.v16i8(<16 x i8> [[A]], <16 x i8> [[B]])
// CHECK-NEXT:    ret <16 x i8> [[VTBL1_I]]
//
mfloat8x16_t test_vqtbl1q_mf8(mfloat8x16_t a, mfloat8x16_t b) {
  return vqtbl1q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vqtbl2_mf8(
// CHECK-SAME: [2 x <16 x i8>] alignstack(16) [[A_COERCE:%.*]], <8 x i8> noundef [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[A_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[A_COERCE]], 0
// CHECK-NEXT:    [[A_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[A_COERCE]], 1
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [2 x <16 x i8>] poison, <16 x i8> [[A_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [2 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[A_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[DOTFCA_1_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[DOTFCA_1_INSERT]], 1
// CHECK-NEXT:    [[VTBL2_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl2.v8i8(<16 x i8> [[DOTFCA_1_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_1_INSERT_FCA_1_EXTRACT]], <8 x i8> [[B]])
// CHECK-NEXT:    ret <8 x i8> [[VTBL2_I]]
//
mfloat8x8_t test_vqtbl2_mf8(mfloat8x16x2_t a, uint8x8_t b) {
  return vqtbl2_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vqtbl2q_mf8(
// CHECK-SAME: [2 x <16 x i8>] alignstack(16) [[A_COERCE:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[A_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[A_COERCE]], 0
// CHECK-NEXT:    [[A_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[A_COERCE]], 1
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [2 x <16 x i8>] poison, <16 x i8> [[A_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [2 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[A_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[DOTFCA_1_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[DOTFCA_1_INSERT]], 1
// CHECK-NEXT:    [[VTBL2_I:%.*]] = call <16 x i8> @llvm.aarch64.neon.tbl2.v16i8(<16 x i8> [[DOTFCA_1_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_1_INSERT_FCA_1_EXTRACT]], <16 x i8> [[B]])
// CHECK-NEXT:    ret <16 x i8> [[VTBL2_I]]
//
mfloat8x16_t test_vqtbl2q_mf8(mfloat8x16x2_t a, mfloat8x16_t b) {
  return vqtbl2q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vqtbl3q_mf8(
// CHECK-SAME: [3 x <16 x i8>] alignstack(16) [[A_COERCE:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[A_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[A_COERCE]], 0
// CHECK-NEXT:    [[A_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[A_COERCE]], 1
// CHECK-NEXT:    [[A_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[A_COERCE]], 2
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [3 x <16 x i8>] poison, <16 x i8> [[A_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [3 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[A_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [3 x <16 x i8>] [[DOTFCA_1_INSERT]], <16 x i8> [[A_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 2
// CHECK-NEXT:    [[VTBL3_I:%.*]] = call <16 x i8> @llvm.aarch64.neon.tbl3.v16i8(<16 x i8> [[DOTFCA_2_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_2_INSERT_FCA_1_EXTRACT]], <16 x i8> [[DOTFCA_2_INSERT_FCA_2_EXTRACT]], <16 x i8> [[B]])
// CHECK-NEXT:    ret <16 x i8> [[VTBL3_I]]
//
mfloat8x16_t test_vqtbl3q_mf8(mfloat8x16x3_t a, mfloat8x16_t b) {
  return vqtbl3q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vqtbl3_mf8(
// CHECK-SAME: [3 x <16 x i8>] alignstack(16) [[A_COERCE:%.*]], <8 x i8> noundef [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[A_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[A_COERCE]], 0
// CHECK-NEXT:    [[A_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[A_COERCE]], 1
// CHECK-NEXT:    [[A_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[A_COERCE]], 2
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [3 x <16 x i8>] poison, <16 x i8> [[A_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [3 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[A_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [3 x <16 x i8>] [[DOTFCA_1_INSERT]], <16 x i8> [[A_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 2
// CHECK-NEXT:    [[VTBL3_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl3.v8i8(<16 x i8> [[DOTFCA_2_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_2_INSERT_FCA_1_EXTRACT]], <16 x i8> [[DOTFCA_2_INSERT_FCA_2_EXTRACT]], <8 x i8> [[B]])
// CHECK-NEXT:    ret <8 x i8> [[VTBL3_I]]
//
mfloat8x8_t test_vqtbl3_mf8(mfloat8x16x3_t a, uint8x8_t b) {
  return vqtbl3_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vqtbl4_mf8(
// CHECK-SAME: [4 x <16 x i8>] alignstack(16) [[A_COERCE:%.*]], <8 x i8> noundef [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[A_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[A_COERCE]], 0
// CHECK-NEXT:    [[A_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[A_COERCE]], 1
// CHECK-NEXT:    [[A_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[A_COERCE]], 2
// CHECK-NEXT:    [[A_COERCE_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[A_COERCE]], 3
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [4 x <16 x i8>] poison, <16 x i8> [[A_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[A_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_1_INSERT]], <16 x i8> [[A_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_2_INSERT]], <16 x i8> [[A_COERCE_FCA_3_EXTRACT]], 3
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 3
// CHECK-NEXT:    [[VTBL4_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbl4.v8i8(<16 x i8> [[DOTFCA_3_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_1_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_2_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_3_EXTRACT]], <8 x i8> [[B]])
// CHECK-NEXT:    ret <8 x i8> [[VTBL4_I]]
//
mfloat8x8_t test_vqtbl4_mf8(mfloat8x16x4_t a, uint8x8_t b) {
  return vqtbl4_mf8(a, b);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vqtbl4q_mf8(
// CHECK-SAME: [4 x <16 x i8>] alignstack(16) [[A_COERCE:%.*]], <16 x i8> [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[A_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[A_COERCE]], 0
// CHECK-NEXT:    [[A_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[A_COERCE]], 1
// CHECK-NEXT:    [[A_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[A_COERCE]], 2
// CHECK-NEXT:    [[A_COERCE_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[A_COERCE]], 3
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [4 x <16 x i8>] poison, <16 x i8> [[A_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[A_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_1_INSERT]], <16 x i8> [[A_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_2_INSERT]], <16 x i8> [[A_COERCE_FCA_3_EXTRACT]], 3
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 3
// CHECK-NEXT:    [[VTBL4_I:%.*]] = call <16 x i8> @llvm.aarch64.neon.tbl4.v16i8(<16 x i8> [[DOTFCA_3_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_1_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_2_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_3_EXTRACT]], <16 x i8> [[B]])
// CHECK-NEXT:    ret <16 x i8> [[VTBL4_I]]
//
mfloat8x16_t test_vqtbl4q_mf8(mfloat8x16x4_t a, mfloat8x16_t b) {
  return vqtbl4q_mf8(a, b);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vqtbx1_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], <8 x i8> noundef [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VTBX1_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbx1.v8i8(<8 x i8> [[A]], <16 x i8> [[B]], <8 x i8> [[C]])
// CHECK-NEXT:    ret <8 x i8> [[VTBX1_I]]
//
mfloat8x8_t test_vqtbx1_mf8(mfloat8x8_t a, mfloat8x16_t b, uint8x8_t c) {
  return vqtbx1_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vqtbx1q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], <16 x i8> noundef [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VTBX1_I:%.*]] = call <16 x i8> @llvm.aarch64.neon.tbx1.v16i8(<16 x i8> [[A]], <16 x i8> [[B]], <16 x i8> [[C]])
// CHECK-NEXT:    ret <16 x i8> [[VTBX1_I]]
//
mfloat8x16_t test_vqtbx1q_mf8(mfloat8x16_t a, mfloat8x16_t b, uint8x16_t c) {
  return vqtbx1q_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vqtbx2_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], [2 x <16 x i8>] alignstack(16) [[B_COERCE:%.*]], <8 x i8> noundef [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[B_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[B_COERCE]], 0
// CHECK-NEXT:    [[B_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[B_COERCE]], 1
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [2 x <16 x i8>] poison, <16 x i8> [[B_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [2 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[B_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[DOTFCA_1_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[DOTFCA_1_INSERT]], 1
// CHECK-NEXT:    [[VTBX2_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbx2.v8i8(<8 x i8> [[A]], <16 x i8> [[DOTFCA_1_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_1_INSERT_FCA_1_EXTRACT]], <8 x i8> [[C]])
// CHECK-NEXT:    ret <8 x i8> [[VTBX2_I]]
//
mfloat8x8_t test_vqtbx2_mf8(mfloat8x8_t a, mfloat8x16x2_t b, uint8x8_t c) {
  return vqtbx2_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vqtbx2q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], [2 x <16 x i8>] alignstack(16) [[B_COERCE:%.*]], <16 x i8> [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[B_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[B_COERCE]], 0
// CHECK-NEXT:    [[B_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[B_COERCE]], 1
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [2 x <16 x i8>] poison, <16 x i8> [[B_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [2 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[B_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[DOTFCA_1_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [2 x <16 x i8>] [[DOTFCA_1_INSERT]], 1
// CHECK-NEXT:    [[VTBX2_I:%.*]] = call <16 x i8> @llvm.aarch64.neon.tbx2.v16i8(<16 x i8> [[A]], <16 x i8> [[DOTFCA_1_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_1_INSERT_FCA_1_EXTRACT]], <16 x i8> [[C]])
// CHECK-NEXT:    ret <16 x i8> [[VTBX2_I]]
//
mfloat8x16_t test_vqtbx2q_mf8(mfloat8x16_t a, mfloat8x16x2_t b, mfloat8x16_t c) {
  return vqtbx2q_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vqtbx3_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], [3 x <16 x i8>] alignstack(16) [[B_COERCE:%.*]], <8 x i8> noundef [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[B_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[B_COERCE]], 0
// CHECK-NEXT:    [[B_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[B_COERCE]], 1
// CHECK-NEXT:    [[B_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[B_COERCE]], 2
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [3 x <16 x i8>] poison, <16 x i8> [[B_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [3 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[B_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [3 x <16 x i8>] [[DOTFCA_1_INSERT]], <16 x i8> [[B_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 2
// CHECK-NEXT:    [[VTBX3_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbx3.v8i8(<8 x i8> [[A]], <16 x i8> [[DOTFCA_2_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_2_INSERT_FCA_1_EXTRACT]], <16 x i8> [[DOTFCA_2_INSERT_FCA_2_EXTRACT]], <8 x i8> [[C]])
// CHECK-NEXT:    ret <8 x i8> [[VTBX3_I]]
//
mfloat8x8_t test_vqtbx3_mf8(mfloat8x8_t a, mfloat8x16x3_t b, uint8x8_t c) {
  return vqtbx3_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vqtbx3q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], [3 x <16 x i8>] alignstack(16) [[B_COERCE:%.*]], <16 x i8> [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[B_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[B_COERCE]], 0
// CHECK-NEXT:    [[B_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[B_COERCE]], 1
// CHECK-NEXT:    [[B_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[B_COERCE]], 2
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [3 x <16 x i8>] poison, <16 x i8> [[B_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [3 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[B_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [3 x <16 x i8>] [[DOTFCA_1_INSERT]], <16 x i8> [[B_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [3 x <16 x i8>] [[DOTFCA_2_INSERT]], 2
// CHECK-NEXT:    [[VTBX3_I:%.*]] = call <16 x i8> @llvm.aarch64.neon.tbx3.v16i8(<16 x i8> [[A]], <16 x i8> [[DOTFCA_2_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_2_INSERT_FCA_1_EXTRACT]], <16 x i8> [[DOTFCA_2_INSERT_FCA_2_EXTRACT]], <16 x i8> [[C]])
// CHECK-NEXT:    ret <16 x i8> [[VTBX3_I]]
//
mfloat8x16_t test_vqtbx3q_mf8(mfloat8x16_t a, mfloat8x16x3_t b, mfloat8x16_t c) {
  return vqtbx3q_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <8 x i8> @test_vqtbx4_mf8(
// CHECK-SAME: <8 x i8> [[A:%.*]], [4 x <16 x i8>] alignstack(16) [[B_COERCE:%.*]], <8 x i8> noundef [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[B_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[B_COERCE]], 0
// CHECK-NEXT:    [[B_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[B_COERCE]], 1
// CHECK-NEXT:    [[B_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[B_COERCE]], 2
// CHECK-NEXT:    [[B_COERCE_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[B_COERCE]], 3
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [4 x <16 x i8>] poison, <16 x i8> [[B_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[B_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_1_INSERT]], <16 x i8> [[B_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_2_INSERT]], <16 x i8> [[B_COERCE_FCA_3_EXTRACT]], 3
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 3
// CHECK-NEXT:    [[VTBX4_I:%.*]] = call <8 x i8> @llvm.aarch64.neon.tbx4.v8i8(<8 x i8> [[A]], <16 x i8> [[DOTFCA_3_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_1_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_2_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_3_EXTRACT]], <8 x i8> [[C]])
// CHECK-NEXT:    ret <8 x i8> [[VTBX4_I]]
//
mfloat8x8_t test_vqtbx4_mf8(mfloat8x8_t a, mfloat8x16x4_t b, uint8x8_t c) {
  return vqtbx4_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vqtbx4q_mf8(
// CHECK-SAME: <16 x i8> [[A:%.*]], [4 x <16 x i8>] alignstack(16) [[B_COERCE:%.*]], <16 x i8> [[C:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[B_COERCE_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[B_COERCE]], 0
// CHECK-NEXT:    [[B_COERCE_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[B_COERCE]], 1
// CHECK-NEXT:    [[B_COERCE_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[B_COERCE]], 2
// CHECK-NEXT:    [[B_COERCE_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[B_COERCE]], 3
// CHECK-NEXT:    [[DOTFCA_0_INSERT:%.*]] = insertvalue [4 x <16 x i8>] poison, <16 x i8> [[B_COERCE_FCA_0_EXTRACT]], 0
// CHECK-NEXT:    [[DOTFCA_1_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_0_INSERT]], <16 x i8> [[B_COERCE_FCA_1_EXTRACT]], 1
// CHECK-NEXT:    [[DOTFCA_2_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_1_INSERT]], <16 x i8> [[B_COERCE_FCA_2_EXTRACT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT:%.*]] = insertvalue [4 x <16 x i8>] [[DOTFCA_2_INSERT]], <16 x i8> [[B_COERCE_FCA_3_EXTRACT]], 3
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_0_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 0
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_1_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 1
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_2_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 2
// CHECK-NEXT:    [[DOTFCA_3_INSERT_FCA_3_EXTRACT:%.*]] = extractvalue [4 x <16 x i8>] [[DOTFCA_3_INSERT]], 3
// CHECK-NEXT:    [[VTBX4_I:%.*]] = call <16 x i8> @llvm.aarch64.neon.tbx4.v16i8(<16 x i8> [[A]], <16 x i8> [[DOTFCA_3_INSERT_FCA_0_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_1_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_2_EXTRACT]], <16 x i8> [[DOTFCA_3_INSERT_FCA_3_EXTRACT]], <16 x i8> [[C]])
// CHECK-NEXT:    ret <16 x i8> [[VTBX4_I]]
//
mfloat8x16_t test_vqtbx4q_mf8(mfloat8x16_t a, mfloat8x16x4_t b, mfloat8x16_t c) {
  return vqtbx4q_mf8(a, b, c);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vluti2_lane_mf8(
// CHECK-SAME: <8 x i8> [[VN:%.*]], <8 x i8> noundef [[VM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VLUTI2_LANE:%.*]] = call <16 x i8> @llvm.aarch64.neon.vluti2.lane.v16i8.v8i8(<8 x i8> [[VN]], <8 x i8> [[VM]], i32 0)
// CHECK-NEXT:    ret <16 x i8> [[VLUTI2_LANE]]
//
mfloat8x16_t test_vluti2_lane_mf8(mfloat8x8_t vn, uint8x8_t vm) {
  return vluti2_lane_mf8(vn, vm, 0);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vluti2q_lane_mf8(
// CHECK-SAME: <16 x i8> [[VN:%.*]], <8 x i8> noundef [[VM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VLUTI2_LANE:%.*]] = call <16 x i8> @llvm.aarch64.neon.vluti2.lane.v16i8.v16i8(<16 x i8> [[VN]], <8 x i8> [[VM]], i32 1)
// CHECK-NEXT:    ret <16 x i8> [[VLUTI2_LANE]]
//
mfloat8x16_t test_vluti2q_lane_mf8(mfloat8x16_t vn, uint8x8_t vm) {
  return vluti2q_lane_mf8(vn, vm, 1);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vluti2_laneq_mf8(
// CHECK-SAME: <8 x i8> [[VN:%.*]], <16 x i8> noundef [[VM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VLUTI2_LANEQ:%.*]] = call <16 x i8> @llvm.aarch64.neon.vluti2.laneq.v16i8.v8i8(<8 x i8> [[VN]], <16 x i8> [[VM]], i32 0)
// CHECK-NEXT:    ret <16 x i8> [[VLUTI2_LANEQ]]
//
mfloat8x16_t test_vluti2_laneq_mf8(mfloat8x8_t vn, uint8x16_t vm) {
  return vluti2_laneq_mf8(vn, vm, 0);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vluti2q_laneq_mf8(
// CHECK-SAME: <16 x i8> [[VN:%.*]], <16 x i8> noundef [[VM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VLUTI2_LANEQ:%.*]] = call <16 x i8> @llvm.aarch64.neon.vluti2.laneq.v16i8.v16i8(<16 x i8> [[VN]], <16 x i8> [[VM]], i32 3)
// CHECK-NEXT:    ret <16 x i8> [[VLUTI2_LANEQ]]
//
mfloat8x16_t test_vluti2q_laneq_mf8(mfloat8x16_t vn, uint8x16_t vm) {
  return vluti2q_laneq_mf8(vn, vm, 3);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vluti4q_lane_mf8(
// CHECK-SAME: <16 x i8> [[VN:%.*]], <8 x i8> noundef [[VM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VLUTI4Q_LANE:%.*]] = call <16 x i8> @llvm.aarch64.neon.vluti4q.lane.v16i8(<16 x i8> [[VN]], <8 x i8> [[VM]], i32 0)
// CHECK-NEXT:    ret <16 x i8> [[VLUTI4Q_LANE]]
//
mfloat8x16_t test_vluti4q_lane_mf8(mfloat8x16_t vn, uint8x8_t vm) {
  return vluti4q_lane_mf8(vn, vm, 0);
}

// CHECK-LABEL: define dso_local <16 x i8> @test_vluti4q_laneq_mf8(
// CHECK-SAME: <16 x i8> [[VN:%.*]], <16 x i8> noundef [[VM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VLUTI4Q_LANEQ:%.*]] = call <16 x i8> @llvm.aarch64.neon.vluti4q.laneq.v16i8(<16 x i8> [[VN]], <16 x i8> [[VM]], i32 1)
// CHECK-NEXT:    ret <16 x i8> [[VLUTI4Q_LANEQ]]
//
mfloat8x16_t test_vluti4q_laneq_mf8(mfloat8x16_t vn, uint8x16_t vm) {
  return vluti4q_laneq_mf8(vn, vm, 1);
}
