#!/bin/sh

# $NetBSD: makeas.sh,v 1.8 2010/01/06 14:10:57 phx Exp $

# Copyright (c) 1999, 2000 Ignatios Souvatzis
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



REALCODE=fplsp_wrap.S
FILELIST=Makefile.list

dummy () {
while [ X$1 != X ]; do
/bin/cat > $1.S << EOM
/* \$NetBSD\$ */

/*
 * Dummy file. Real code is elsewhere.
 *
 * DO NOT EDIT - this file is automatically generated.
 *
 */
EOM
echo -n " " $1.S >> $FILELIST
shift
done
}

linebreak () {
	echo " \\" >> ${FILELIST}
	echo -n "	" >> ${FILELIST}
}

mk () {
NAME=$1
OFFS=$2
THESRC=$3.S
shift; shift; shift

echo -n " " ${THESRC} >> $FILELIST
/bin/cat > ${THESRC} << EOJ
/* \$NetBSD\$ */

/*
 * FPLSP wrapper for $NAME
 * DO NOT EDIT - this file is automatically generated.
 */

#include <machine/asm.h>

ENTRY($NAME)
#ifdef __SVR4_ABI__
	bral PIC_PLT(_C_LABEL(__fplsp060_$OFFS))
#else
	movel %sp@(8),%sp@-
	movel %sp@(8),%sp@-
	bsrl PIC_PLT(_C_LABEL(__fplsp060_$OFFS))
	fmoved %fp0,%sp@
	movel %sp@+,%d0
	movel %sp@+,%d1
	rts
#endif
EOJ
dummy $*
}

mks () {
NAME=$1
OFFS=$2
THESRC=$3.S
shift; shift; shift

echo -n " " ${THESRC} >> $FILELIST
/bin/cat > ${THESRC} << EOJ
/* \$NetBSD\$ */

/*
 * FPLSP wrapper for $NAME
 * DO NOT EDIT - this file is automatically generated.
 */

#include <machine/asm.h>

ENTRY($NAME)
#ifdef __SVR4_ABI__
	bral PIC_PLT(_C_LABEL(__fplsp060_$OFFS))
#else
	movel %sp@(4),%sp@-
	bsrl PIC_PLT(_C_LABEL(__fplsp060_$OFFS))
	fmoves %fp0,%sp@
	movel %sp@+,%d0
	rts
#endif
EOJ
dummy $*
}

/bin/cat > ${REALCODE} << EOJ
/* \$NetBSD\$ */

/*
 * FPLSP wrapper.
 *
 * DO NOT EDIT - this file is automatically generated!
 */

#include <machine/asm.h>

EOJ

/bin/cat > ${FILELIST} << EOJ
# \$NetBSD\$

#
# list of M68060 architecture dependent files for libm.
#
# Created by a script. Do not edit manually!
#

EOJ

echo -n ARCH_SRCS = >> $FILELIST

mks	__ieee754_acosf		0000	e_acosf
mk	__ieee754_acos		0008	e_acos
mks	__ieee754_asinf		0018	e_asinf
mk	__ieee754_asin		0020	e_asin
linebreak
mks	atanf			0030	s_atanf
mk	atan			0038	s_atan
mks	__ieee754_atanhf	0048	e_atanhf
mk	__ieee754_atanh		0050	e_atanh
linebreak
mks	cosf			0060	s_cosf
mk	cos			0068	s_cos
mks	__ieee754_coshf		0078	e_coshf
mk	__ieee754_cosh		0080	e_cosh
linebreak
mks	__ieee754_expf		0090	e_expf
mk	__ieee754_exp		0098	e_exp
mks	expm1f			00a8	s_expm1f
mk	expm1			00b0	s_expm1
linebreak
mks	__ieee754_log10f	00f0	e_log10f
mk	__ieee754_log10		00f8	e_log10
mks	logbf			0108	s_logbf
mk	logb			0110	s_logb
linebreak
mks	__ieee754_logf		0120	e_logf
mk	__ieee754_log		0128	e_log
mks	log1pf			0138	s_log1pf
mk	log1p			0140	s_log1p
linebreak
mks	sinf			0198	s_sinf
mk	sin			01a0	s_sin
mks	__ieee754_sinhf		01c8	e_sinhf
mk	__ieee754_sinh		01d0	e_sinh
linebreak
mks	tanf			01e0	s_tanf k_tanf
mk	tan			01e8	s_tan k_tan
mks	tanhf			01f8	s_tanhf
mk	tanh			0200	s_tanh
linebreak
mks	__ieee754_sqrtf		02e8	e_sqrtf
mk	__ieee754_sqrt		02f0	e_sqrt

/bin/cat >> ${REALCODE} << EOJ

L060FPLSP_BASE:
#include "fplsp.hex"
EOJ

echo ""	>> ${FILELIST}
echo ARCH_ADDS = ${REALCODE} >> ${FILELIST}
