/*	$NetBSD: compat_passwd.c,v 1.2 2009/01/11 02:57:18 christos Exp $	*/

/*-
 * Copyright (c) 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Christos Zoulas.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <sys/cdefs.h>
#if defined(LIBC_SCCS) && !defined(lint)
__RCSID("$NetBSD: compat_passwd.c,v 1.2 2009/01/11 02:57:18 christos Exp $");
#endif /* LIBC_SCCS and not lint */

#define __LIBC12_SOURCE__

#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <compat/include/pwd.h>
#include <util.h>
#include <compat/util.h>

__warn_references(pw_scan,
    "warning: reference to compatibility pw_scan(); "
    "include <pwd.h> to generate correct reference")
__warn_references(pw_copy,
    "warning: reference to compatibility pw_copy(); "
    "include <util.h> to generate correct reference")
__warn_references(pw_copyx,
    "warning: reference to compatibility pw_copyx(); "
    "include <util.h> to generate correct reference")
__warn_references(pw_getpwconf,
    "warning: reference to compatibility pw_getpwconf(); "
    "include <pwd.h> to generate correct reference")

int
pw_scan(char *buf, struct passwd50 *p, int *flags)
{
	struct passwd px;
	int rv = __pw_scan50(buf, &px, flags);
	passwd_to_passwd50(&px, p);
	return rv;
}

void
pw_copy(int ffd, int tfd, struct passwd50 *pw50, struct passwd50 *opw50)
{
	struct passwd pw, opw;
	passwd50_to_passwd(pw50, &pw);
	if (opw50)
		passwd50_to_passwd(opw50, &opw);
	__pw_copy50(ffd, tfd, &pw, opw50 ? &opw : NULL);
}

int
pw_copyx(int ffd, int tfd, struct passwd50 *pw50, struct passwd50 *opw50,
    char *errbuf, size_t errbufsiz)
{
	struct passwd pw, opw;
	passwd50_to_passwd(pw50, &pw);
	if (opw50)
		passwd50_to_passwd(opw50, &opw);
	return __pw_copyx50(ffd, tfd, &pw, opw50 ? &opw : NULL, errbuf,
	    errbufsiz);
}

void
pw_getpwconf(char *buf, size_t len, const struct passwd50 *p, const char *opt)
{
	struct passwd px;
	passwd50_to_passwd(p, &px);
	__pw_getpwconf50(buf, len, &px, opt);
}
