#!/usr/pkg/bin/perl
# Copyright 2009 The Go Authors. All rights reserved.
# Use of this source code is governed by a BSD-style
# license that can be found in the LICENSE file.
#
# Generate system call table for Darwin from sys/syscall.h

use strict;

if($ENV{'GOARCH'} eq "" || $ENV{'GOOS'} eq "") {
	print STDERR "GOARCH or GOOS not defined in environment\n";
	exit 1;
}

my $command = "mksysnum_darwin.pl " . join(' ', @ARGV);

print <<EOF;
// $command
// Code generated by the command above; see README.md. DO NOT EDIT.

// +build $ENV{'GOARCH'},$ENV{'GOOS'}

package unix

const (
EOF

while(<>){
	if(/^#define\s+SYS_(\w+)\s+([0-9]+)/){
		my $name = $1;
		my $num = $2;
		$name =~ y/a-z/A-Z/;
		print "	SYS_$name = $num;"
	}
}

print <<EOF;
)
EOF
