# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "typed-array"
  s.version = "0.1.2"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Ryan Biesemeyer"]
  s.date = "2011-08-03"
  s.description = "      All methods that alter the contents of an array that implements this Gem are first checked to\n      ensure that the added items are of the types allowed. All methods behave exactly as their Array\n      counterparts, including additional forms, block processing, etc.\n\n      Defining a TypedArray Class:\n\n      ```ruby\n      class ThingsArray < Array\n        extend TypedArray\n        restrict_types Thing1, Thing2\n      end\n\n      things = ThingsArray.new\n      ```\n\n      Generating a single TypedArray\n      \n      ```ruby\n      things = TypedArray(Thing1,Thing2).new\n\n      These classes can be extended, and their accepted-types appended to after their initial definition.\n"
  s.email = "ruby-dev@yaauie.com"
  s.extra_rdoc_files = ["LICENSE.txt", "README.rdoc"]
  s.files = ["LICENSE.txt", "README.rdoc"]
  s.homepage = "http://github.com/yaauie/typed-array"
  s.licenses = ["MIT"]
  s.require_paths = ["lib"]
  s.rubygems_version = "2.0.14"
  s.summary = "Provides methods for creating type-enforced Arrays"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_development_dependency(%q<rspec>, ["~> 2.3.0"])
      s.add_development_dependency(%q<bundler>, ["~> 1.0.0"])
      s.add_development_dependency(%q<jeweler>, ["~> 1.6.4"])
      s.add_development_dependency(%q<rcov>, [">= 0"])
    else
      s.add_dependency(%q<rspec>, ["~> 2.3.0"])
      s.add_dependency(%q<bundler>, ["~> 1.0.0"])
      s.add_dependency(%q<jeweler>, ["~> 1.6.4"])
      s.add_dependency(%q<rcov>, [">= 0"])
    end
  else
    s.add_dependency(%q<rspec>, ["~> 2.3.0"])
    s.add_dependency(%q<bundler>, ["~> 1.0.0"])
    s.add_dependency(%q<jeweler>, ["~> 1.6.4"])
    s.add_dependency(%q<rcov>, [">= 0"])
  end
end
