package Cairo::Install::Files;

$self = {
          'deps' => [],
          'inc' => '-I. -Ibuild -I/usr/pkg/include/cairo -I/usr/X11R7/include/pixman-1 -I/usr/X11R7/include -I/usr/X11R7/include/freetype2 -I/usr/pkg/include/libpng16 -D_REENTRANT  -I/usr/pkg/include/cairo -I/usr/X11R7/include/pixman-1 -I/usr/X11R7/include -I/usr/X11R7/include/freetype2 -I/usr/pkg/include/libpng16 -D_REENTRANT ',
          'libs' => '-Wl,-R/usr/pkg/lib -L/usr/pkg/lib -lcairo  -Wl,-R/usr/pkg/lib -L/usr/pkg/lib -lcairo -Wl,-rpath,/usr/X11R7/lib -L/usr/X11R7/lib -lfreetype -lz -lbz2 ',
          'typemaps' => [
                          'cairo-perl-auto.typemap',
                          'cairo-perl.typemap'
                        ]
        };

@deps = @{ $self->{deps} };
@typemaps = @{ $self->{typemaps} };
$libs = $self->{libs};
$inc = $self->{inc};

	$CORE = undef;
	foreach (@INC) {
		if ( -f $_ . "/Cairo/Install/Files.pm") {
			$CORE = $_ . "/Cairo/Install/";
			last;
		}
	}

	sub deps { @{ $self->{deps} }; }

	sub Inline {
		my ($class, $lang) = @_;
		if ($lang ne 'C') {
			warn "Warning: Inline hints not available for $lang language
";
			return;
		}
		+{ map { (uc($_) => $self->{$_}) } qw(inc libs typemaps) };
	}

1;
