# -*- coding: utf-8 -*-
info = {
    "name": "ca",
    "date_order": "DMY",
    "january": [
        "gener",
        "gen",
        "de gener",
        "de gen"
    ],
    "february": [
        "febrer",
        "febr",
        "de febrer",
        "de febr"
    ],
    "march": [
        "març",
        "de març"
    ],
    "april": [
        "abril",
        "abr",
        "d'abril",
        "d'abr"
    ],
    "may": [
        "maig",
        "de maig"
    ],
    "june": [
        "juny",
        "de juny"
    ],
    "july": [
        "juliol",
        "jul",
        "de juliol",
        "de jul"
    ],
    "august": [
        "agost",
        "ag",
        "d'agost",
        "d'ag"
    ],
    "september": [
        "setembre",
        "set",
        "de setembre",
        "de set"
    ],
    "october": [
        "octubre",
        "oct",
        "d'octubre",
        "d'oct"
    ],
    "november": [
        "novembre",
        "nov",
        "de novembre",
        "de nov"
    ],
    "december": [
        "desembre",
        "des",
        "de desembre",
        "de des"
    ],
    "monday": [
        "dilluns",
        "dl"
    ],
    "tuesday": [
        "dimarts",
        "dt"
    ],
    "wednesday": [
        "dimecres",
        "dc"
    ],
    "thursday": [
        "dijous",
        "dj"
    ],
    "friday": [
        "divendres",
        "dv"
    ],
    "saturday": [
        "dissabte",
        "ds"
    ],
    "sunday": [
        "diumenge",
        "dg"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "any"
    ],
    "month": [
        "mes"
    ],
    "week": [
        "setmana",
        "setm"
    ],
    "day": [
        "dia"
    ],
    "hour": [
        "hora",
        "h"
    ],
    "minute": [
        "minut",
        "min"
    ],
    "second": [
        "segon",
        "s"
    ],
    "relative-type": {
        "1 year ago": [
            "l'any passat"
        ],
        "0 year ago": [
            "enguany"
        ],
        "in 1 year": [
            "l'any que ve"
        ],
        "1 month ago": [
            "el mes passat",
            "mes passat"
        ],
        "0 month ago": [
            "aquest mes"
        ],
        "in 1 month": [
            "el mes que ve",
            "mes vinent"
        ],
        "1 week ago": [
            "la setmana passada",
            "la setm passada",
            "setm passada"
        ],
        "0 week ago": [
            "aquesta setmana",
            "aquesta setm"
        ],
        "in 1 week": [
            "la setmana que ve",
            "la setm que ve",
            "setm vinent"
        ],
        "1 day ago": [
            "ahir"
        ],
        "0 day ago": [
            "avui"
        ],
        "in 1 day": [
            "demà"
        ],
        "0 hour ago": [
            "aquesta hora"
        ],
        "0 minute ago": [
            "aquest minut"
        ],
        "0 second ago": [
            "ara"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "d'aquí a (\\d+) any",
            "d'aquí a (\\d+) anys"
        ],
        "\\1 year ago": [
            "fa (\\d+) any",
            "fa (\\d+) anys"
        ],
        "in \\1 month": [
            "d'aquí a (\\d+) mes",
            "d'aquí a (\\d+) mesos"
        ],
        "\\1 month ago": [
            "fa (\\d+) mes",
            "fa (\\d+) mesos"
        ],
        "in \\1 week": [
            "d'aquí a (\\d+) setmana",
            "d'aquí a (\\d+) setmanes",
            "d'aquí a (\\d+) setm"
        ],
        "\\1 week ago": [
            "fa (\\d+) setmana",
            "fa (\\d+) setmanes",
            "fa (\\d+) setm"
        ],
        "in \\1 day": [
            "d'aquí a (\\d+) dia",
            "d'aquí a (\\d+) dies"
        ],
        "\\1 day ago": [
            "fa (\\d+) dia",
            "fa (\\d+) dies"
        ],
        "in \\1 hour": [
            "d'aquí a (\\d+) hora",
            "d'aquí a (\\d+) hores",
            "d'aquí a (\\d+) h",
            "d‘aquí a (\\d+) h"
        ],
        "\\1 hour ago": [
            "fa (\\d+) hora",
            "fa (\\d+) hores",
            "fa (\\d+) h"
        ],
        "in \\1 minute": [
            "d'aquí a (\\d+) minut",
            "d'aquí a (\\d+) minuts",
            "d'aquí a (\\d+) min"
        ],
        "\\1 minute ago": [
            "fa (\\d+) minut",
            "fa (\\d+) minuts",
            "fa (\\d+) min"
        ],
        "in \\1 second": [
            "d'aquí a (\\d+) segon",
            "d'aquí a (\\d+) segons",
            "d'aquí a (\\d+) s"
        ],
        "\\1 second ago": [
            "fa (\\d+) segon",
            "fa (\\d+) segons",
            "fa (\\d+) s"
        ]
    },
    "locale_specific": {
        "ca-FR": {
            "name": "ca-FR"
        },
        "ca-IT": {
            "name": "ca-IT"
        },
        "ca-AD": {
            "name": "ca-AD"
        }
    },
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}