# -*- coding: utf-8 -*-
info = {
    "name": "chr",
    "date_order": "MDY",
    "january": [
        "ᎤᏃᎸᏔᏅ",
        "ᎤᏃ"
    ],
    "february": [
        "ᎧᎦᎵ",
        "ᎧᎦ"
    ],
    "march": [
        "ᎠᏅᏱ",
        "ᎠᏅ"
    ],
    "april": [
        "ᎧᏬᏂ",
        "ᎧᏬ"
    ],
    "may": [
        "ᎠᏂᏍᎬᏘ",
        "ᎠᏂ"
    ],
    "june": [
        "ᏕᎭᎷᏱ",
        "ᏕᎭ"
    ],
    "july": [
        "ᎫᏰᏉᏂ",
        "ᎫᏰ"
    ],
    "august": [
        "ᎦᎶᏂ",
        "ᎦᎶ"
    ],
    "september": [
        "ᏚᎵᏍᏗ",
        "ᏚᎵ"
    ],
    "october": [
        "ᏚᏂᏅᏗ",
        "ᏚᏂ"
    ],
    "november": [
        "ᏅᏓᏕᏆ",
        "ᏅᏓ"
    ],
    "december": [
        "ᎥᏍᎩᏱ",
        "ᎥᏍ"
    ],
    "monday": [
        "ᎤᎾᏙᏓᏉᏅᎯ",
        "ᏉᏅᎯ"
    ],
    "tuesday": [
        "ᏔᎵᏁᎢᎦ",
        "ᏔᎵᏁ"
    ],
    "wednesday": [
        "ᏦᎢᏁᎢᎦ",
        "ᏦᎢᏁ"
    ],
    "thursday": [
        "ᏅᎩᏁᎢᎦ",
        "ᏅᎩᏁ"
    ],
    "friday": [
        "ᏧᎾᎩᎶᏍᏗ",
        "ᏧᎾᎩ"
    ],
    "saturday": [
        "ᎤᎾᏙᏓᏈᏕᎾ",
        "ᏈᏕᎾ"
    ],
    "sunday": [
        "ᎤᎾᏙᏓᏆᏍᎬ",
        "ᏆᏍᎬ"
    ],
    "am": [
        "ᏌᎾᎴ"
    ],
    "pm": [
        "ᏒᎯᏱᎢᏗᏢ"
    ],
    "year": [
        "ᎤᏕᏘᏴᏌᏗᏒᎢ",
        "ᎤᏕ"
    ],
    "month": [
        "ᎧᎸᎢ",
        "ᎧᎸ"
    ],
    "week": [
        "ᏒᎾᏙᏓᏆᏍᏗ",
        "ᏒᎾ"
    ],
    "day": [
        "ᎢᎦ"
    ],
    "hour": [
        "ᏑᏟᎶᏓ",
        "ᏑᏟ"
    ],
    "minute": [
        "ᎢᏯᏔᏬᏍᏔᏅ",
        "ᎢᏯᏔ"
    ],
    "second": [
        "ᎠᏎᏢ"
    ],
    "relative-type": {
        "1 year ago": [
            "ᎡᏘ ᏥᎨᏒ"
        ],
        "0 year ago": [
            "ᎯᎠ ᏧᏕᏘᏴᏒᏘ"
        ],
        "in 1 year": [
            "ᎡᏘᏴᎢ"
        ],
        "1 month ago": [
            "ᎧᎸᎢ ᏥᎨᏒ"
        ],
        "0 month ago": [
            "ᎯᎠ ᎧᎸᎢ"
        ],
        "in 1 month": [
            "ᏔᎵᏁ ᎧᎸᎢ"
        ],
        "1 week ago": [
            "ᏥᏛᎵᏱᎵᏒᎢ"
        ],
        "0 week ago": [
            "ᎯᎠ ᎠᎵᎵᏌ"
        ],
        "in 1 week": [
            "ᏐᏆᎴᏅᎲ"
        ],
        "1 day ago": [
            "ᏒᎯ"
        ],
        "0 day ago": [
            "ᎪᎯ ᎢᎦ"
        ],
        "in 1 day": [
            "ᏌᎾᎴᎢ"
        ],
        "0 hour ago": [
            "ᎯᎠ ᏑᏟᎶᏓ"
        ],
        "0 minute ago": [
            "ᎯᎠ ᎢᏯᏔᏬᏍᏔᏅ"
        ],
        "0 second ago": [
            "ᏃᏊ"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "ᎾᎿ (\\d+) ᎤᏕᏘᏴᏌᏗᏒᎢ",
            "ᎾᎿ (\\d+) ᎢᏧᏕᏘᏴᏌᏗᏒᎢ",
            "ᎾᎿ (\\d+) ᎤᏕ"
        ],
        "\\1 year ago": [
            "(\\d+) ᎤᏕᏘᏴᏌᏗᏒᎢ ᏥᎨᏒ",
            "(\\d+) ᎢᏧᏕᏘᏴᏌᏗᏒᎢ ᏥᎨᏒ",
            "ᎾᎿ (\\d+) ᎤᏕ ᏥᎨᏒ"
        ],
        "in \\1 month": [
            "ᎾᎿ (\\d+) ᎧᎸᎢ",
            "ᎾᎿ (\\d+) ᏗᎧᎸᎢ",
            "ᎾᎿ (\\d+) ᎧᎸ"
        ],
        "\\1 month ago": [
            "ᎾᎿ (\\d+) ᎧᎸᎢ ᏥᎨᏒ",
            "ᎾᎿ (\\d+) ᏗᎧᎸᎢ ᏥᎨᏒ",
            "ᎾᎿ (\\d+) ᎧᎸ ᏥᎨᏒ"
        ],
        "in \\1 week": [
            "ᎾᎿ (\\d+) ᏒᎾᏙᏓᏆᏍᏗ",
            "ᎾᎿ (\\d+) ᎢᏳᎾᏙᏓᏆᏍᏗ",
            "ᎾᎿ (\\d+) ᏒᎾ"
        ],
        "\\1 week ago": [
            "ᎾᎿ (\\d+) ᏒᎾᏙᏓᏆᏍᏗ ᏥᎨᏒ",
            "ᎾᎿ (\\d+) ᎢᏳᎾᏙᏓᏆᏍᏗ ᏥᎨᏒ",
            "ᎾᎿ (\\d+) ᏒᎾ ᏥᎨᏒ"
        ],
        "in \\1 day": [
            "ᎾᎿ (\\d+) ᎢᎦ",
            "ᎾᎿ (\\d+) ᎯᎸᏍᎩ ᏧᏒᎯᏛ"
        ],
        "\\1 day ago": [
            "(\\d+) ᎢᎦ ᏥᎨᏒ",
            "(\\d+) ᎯᎸᏍᎩ ᏧᏒᎯᏛ ᏥᎨᏒ"
        ],
        "in \\1 hour": [
            "ᎾᎿ (\\d+) ᏑᏟᎶᏓ",
            "ᎾᎿ (\\d+) ᎢᏳᏟᎶᏓ",
            "ᎾᎿ (\\d+) ᏑᏟ"
        ],
        "\\1 hour ago": [
            "(\\d+) ᏑᏟᎶᏓ ᏥᎨᏒ",
            "(\\d+) ᎢᏳᏟᎶᏓ ᏥᎨᏒ",
            "ᎾᎿ (\\d+) ᏑᏟ ᏥᎨᏒ"
        ],
        "in \\1 minute": [
            "ᎾᎿ (\\d+) ᎢᏯᏔᏬᏍᏔᏅ",
            "ᎾᎿ (\\d+) ᎢᏯᏔ"
        ],
        "\\1 minute ago": [
            "ᎾᎿ (\\d+) ᎢᏯᏔᏬᏍᏔᏅ ᏥᎨᏒ",
            "ᎾᎿ (\\d+) ᎢᏯᏔ ᏥᎨᏒ"
        ],
        "in \\1 second": [
            "ᎾᎿ (\\d+) ᎠᏎᏢ",
            "ᎾᎿ (\\d+) ᏓᏓᎾᏩᏍᎬ ᏥᎨᏒ"
        ],
        "\\1 second ago": [
            "(\\d+) ᎠᏎᏢ ᏥᎨᏒ",
            "(\\d+) ᏓᏓᎾᏩᏍᎬ ᏥᎨᏒ"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}