GOOF----LE-8-2.0L      ]  4  h      ] g  guile	 	g  define-module*	 	 	g  logging	g  logger	 		g  filenameS	
f  logging/logger.scm	g  importsS	g  oop	
g  goops	
 	 	g  scheme	g  
documentation	 	 	 	g  exportsS	g  
<log-handler>	g  emit-log	g  
accept-log	g  <logger>	g  add-handler!	g  log-msg	g  set-default-logger!	g  register-logger!	g  
lookup-logger	g  enable-log-level!	 g  disable-log-level!	!g  	flush-log	"g  	open-log!	#g  
close-log!	$ !"# 	%g  set-current-module	&% 	'% 	(g  default-logger	)g  make-hash-table	*g  all-loggers	+g  string?	,g  hash-ref	-g  is-a?	.g  throw	/g  bad-type	0f  $expected a string, #f, or a <logger>	1f  *Expected a string for the log registration	2g  	hash-set!	3f  'Expected a string for the logger lookup	4g  defined?	54 	64 	7g  levels	8- 	9- 	:g  	<generic>	;: 	<: 	=g  toplevel-define!	>= 	?= 	@g  ensure-generic	A@ 	B@ 	Cg  handlers	Dg  
<accessor>	ED 	FD 	Gg  ensure-accessor	HG 	IG 	Jg  <class>	KJ 	LJ 	Mg  memq	Ng  <object>	ON 	PN 	Qg  class-precedence-list	RQ 	SQ 	Tg  class-redefinition	UT 	VT 	Wg  
make-class	Xg  	init-formS	Y)	 	Zg  
init-thunkS	[g  getterS	\g  log-handlers	]g  
init-valueS	^g  accessorS	_g  init-keywordS	`g  handlersS	ag  nameS	bg  set-object-property!	cf This is the class that aggregates and manages log handlers.  It also
maintains the global information about which levels of log messages 
are enabled, and which have been suppressed.  Keyword arguments accepted
on creation are:

@table @code
@item #:handlers
This optional parameter must be a list of objects derived from @code{<log-handler>}.
Handlers can always be added later via @code{add-handler!} calls.  
@end table	dg  level-enabled?	eg  current-time	fg  for-each	gg  string-null?	hg  string-split	ig  with-output-to-string	jg  display	kg  
log-helper	lg  make-generic	mf @code{log-msg [lgr] lvl arg1 arg2 ...}.  Send a log message
made up of the @code{display}'ed representation of the given
arguments.  The log is generated at level @var{lvl}, which should
be a symbol.  If the @var{lvl} is disabled, the log message is
not generated.  Generated log messages are sent through each of
@var{lgr}'s handlers.

If the @var{lgr} parameter is omitted, then the default logger
is used, if one is set.

As the args are @code{display}'ed, a large string is built up.  Then,
the string is split at newlines and sent through the log handlers as
independent log messages.  The reason for this behavior is to make 
output nicer for log handlers that prepend information like pid and
timestamps to log statements.

@lisp
;; logging to default logger, level of WARN
 (log-msg 'WARN "Warning! " x " is bigger than " y "!!!")

;; looking up a logger and logging to it
 (let ((l (lookup-logger "main")))
     (log-msg l 'CRITICAL "FAILURE TO COMMUNICATE!")
     (log-msg l 'CRITICAL "ABORTING NOW"))
@end lisp	ng  make	on 	pn 	qg  add-method!	rq 	sq 	tg  <method>	ut 	vt 	wg  specializersS	xg  <symbol>	yg  <top>	zy 	{y 	|g  formalsS	}g  lvl	~g  objs	}~ g  bodyS g  if k(}~  (    g  make-procedureS g  	procedureS g  lgr  k}~    g  strftime f  %F %H:%M:%S g  	localtime f   ( g  symbol->string f  ):  g  newline g  default-log-formatter g  
log-formatter g  	formatter g  	formatterS f This is the base class for all of the log handlers, and encompasses
the basic functionality that all handlers are expected to have.
Keyword arguments recognized by the @code{<log-handler>} at creation
time are:

@table @code
@item #:formatter
This optional parameter must be a function that takes three arguments:
the log level, the time (as from @code{current-time}), and the log string
itself.  The function must return a string representing the formatted log.

Here is an example invokation of the default formatter, and what it's
output looks like:
@lisp
 (default-log-formatter 'CRITICAL 
                       (current-time) 
                       "The servers are melting!")
==> "2003/12/29 14:53:02 (CRITICAL): The servers are melting!"
@end lisp
@end table f  @code{add-handler! lgr handler}.  Adds @var{handler} to @var{lgr}'s list of handlers.  All subsequent
logs will be sent through the new handler, as well as any previously
registered handlers. g  handler   g  set! C  g  cons       g  setter     f @code{accept-log handler lvl time str}.  If @var{lvl} is
enabled for @var{handler}, then @var{str} will be formatted and
sent to the log via the @code{emit-log} method.  Formatting is
done via the formatting function given at @var{handler}'s
creation time, or by the default if none was given.

This method should not normally need to be overridden by subclasses.
This method should not normally be called by users of the logging 
system.  It is only exported so that writers of log handlers can
override this behavior. g  self g  level g  time g  str   d            f  @code{emit-log handler str}.  This method should be implemented
for all the handlers.  This sends a string to their output media.
All level checking and formatting has already been done by
@code{accept-log}. f  @code{open-log! handler}.  Tells the @code{handler} to open its log.  Handlers for which
an open operation doesn't make sense can choose not to implement this method.
The default implementation just returns @code{#t}. g  lh     f  @code{open-log! handler}.  Tells the @code{handler} to close its
log.  Handlers for which a close operation doesn't make sense can
choose not to implement this method.  The default implementation
just returns @code{#t}. f  @code{flush-log handler}.  Tells the @code{handler} to output
any log statements it may have buffered up.  Handlers for which a
flush operation doesn't make sense can choose not to implement
this method.  The default implementation just returns
@code{#t}. !(  (      g  lambda   !    f    g  
flush-log! (  (    "    f    "(  (    #    f    #(  (    g  
hashq-set! g  	hashq-refC 5 hx,    ]4	
$5 4' >  "  G   (R4)i	5*R+,*(-./0 
     h@     ]4 5$  
4 5 C4 5$    C $  	6 C      g  lgr
		@  g  filenamef  logging/logger.scm
 
	 			
 		 		 			 			' 		+ 		3 		7 		9 		; 		> 	 		@  g  nameg  set-default-logger!g  
documentationf 	Sets the given logger, @var{lgr}, as the default for logging methods where
a logger is not given.  @var{lgr} can be an instance of @code{<logger>},
a string that has been registered via @code{register-logger!}, or @code{#f}
to remove the default logger.

With this mechanism, most applications will never need to worry about
logger registration or lookup.

@lisp
;; example 1
 (set-default-logger! "main")  ;; look up "main" logger and make it the default

;; example 2
 (define lgr (make  <logger>))
 (add-handler! lgr 
              (make <port-handler>
                    #:port (current-error-port)))
 (set-default-logger! lgr)
 (log-msg 'CRITICAL "This is a message to the default logger!!!")
 (log-msg lgr 'CRITICAL "This is a message to a specific logger!!!")
@end lisp CR+./12*   h0     ]4 5$  "  4>  "  G   6       g  str
		/ g  lgr		/  g  filenamef  logging/logger.scm
 
	 		
 		 		 	
	 		 		/ 	 			/	  g  nameg  register-logger!g  
documentationf Makes @var{lgr} accessible from other parts of the program by a name
given in @var{str}.  @var{str} should be a string, and @var{lgr}
should be an instance of class @code{<logger>}.
@lisp 
 (define main-log  (make <logger>))
 (define corba-log (make <logger>))
 (register-logger! "main" main-log)
 (register-logger! "corba" corba-log)

;; in a completely different part of the program....
 (log-msg (lookup-logger "corba") 'WARNING "This is a corba warning.")
@end lisp CR+./3,*      h0   i  ]4 5$  "  4>  "  G   6   a      g  str
		-  g  filenamef  logging/logger.scm
 
	 	
	
 	 		 	
	 		 		- 	 			-  g  nameg  
lookup-loggerg  
documentationf  Looks up an instance of class @code{<logger>} by the name given
in @var{str}.  The string should have already been registered via
a call to @code{register-logger!}. CR4675  $  "  497i<5 $  14?74B4675$  7i"  75>  "  G  "   46C5  $  "  49CiF5 $  14?C4I46C5$  Ci"  C5>  "  G  "   465$ #49iL5$ l4MiP4Si55$  4Vi4Wi  7XYZ)     h   G   ] 	6?       g  filenamef  logging/logger.scm	 	 		
   C[7i \]^Ci_`  a5>  "  G  "  4?4Wi  7XYZ) h   G   ] 	6?       g  filenamef  logging/logger.scm	 	 		
   C[7i \]^Ci_`  a5>  "  G  "  4?4Wi  7XYZ) h   G   ] 	6?       g  filenamef  logging/logger.scm	 	 		
   C[7i \]^Ci_`  a5>  "  G  "  4?4Wi  7XYZ) h   G   ] 	6?       g  filenamef  logging/logger.scm	 	 		
   C[7i \]^Ci_`  a5>  "  G  4biic>  "  G  defgf    h   e   ] LLL 6  ]       g  handler
		  g  filenamef  logging/logger.scm
 	"	 	$ 		   CC      h(   |   ]4 5$  C LL O 4L56   t       g  str
		%  g  filenamef  logging/logger.scm
 		 		
 		 	"	% 	 		%   Chifj       h   _   ] 6W       g  o
		  g  filenamef  logging/logger.scm
 	?	 	K 		   C      h   O   ] L 6      G       g  filenamef  logging/logger.scm
 	*	
 	5 		

   C      h@      ]4 5$  )45  O 44O 5
56C             g  lgr
		: g  level		: g  objs			: g  cur-time			8  g  filenamef  logging/logger.scm
 
	 		 		 		 		$ 		' 		6 		8 	 
		:	  g  nameg  
log-helper CkR4li5R4biim>  "  G  465  $  "  i $  !4?4p<a5>  "  G  "   4si4pvwxi{|(k  h    |   - 1 3 $  
 6C     t       g  lvl
			 g  objs			  g  filenamef  logging/logger.scm

				 			
   C5>  "  G  465  $  "  i $  !4?4p<a5>  "  G  "   4si4pvwi{{|k        h      - 1 3  6     ~       g  lgr
			 g  lvl			 g  objs				  g  filenamef  logging/logger.scm


		 				
	   C5>  "  G  ij 	   hx      ] 444L55>  "  G  4>  "  G  44L5>  "  G  4>  "  G  4L >  "  G  6               g  filenamef  logging/logger.scm
						
			'					!		%		*		3		6		A		J		N		S		\		q	 		q
   C      h      ] O 6              g  lvl
		 g  time		 g  str			  g  filenamef  logging/logger.scm

		 			  g  nameg  default-log-formatter CR465  $  "  49i<5 $  14?4B465$  i"  5>  "  G  "   4675  $  "  497i<5 $  14?74B4675$  7i"  75>  "  G  "   465$ 549iL5$ v4MiP4Si55$  4Vi4Wi  ]i[i_ 7XYZ)    h   G   ] 	6?       g  filenamef  logging/logger.scm	/	 		
   C[7i  a5>  "  G  "  4?4Wi  ]i[i_ 7XYZ)      h   G   ] 	6?       g  filenamef  logging/logger.scm	/	 		
   C[7i  a5>  "  G  "  4?4Wi  ]i[i_ 7XYZ)      h   G   ] 	6?       g  filenamef  logging/logger.scm	/	 		
   C[7i  a5>  "  G  "  4?4Wi  ]i[i_ 7XYZ)      h   G   ] 	6?       g  filenamef  logging/logger.scm	/	 		
   C[7i  a5>  "  G  4bii>  "  G  4li5R4bii>  "  G  465  $  "  i $  !4?4p<a5>  "  G  "   4si4pvwii |C  h      ]45 4 56        g  lgr
		 g  handler		  g  filenamef  logging/logger.scm
6
	8		8		7	 			   C5>  "  G  4li5R4bii>  "  G  465  $  "  i $  !4?4p<a5>  "  G  "   4si4pvwi{{{ |d        h(      ]4 5$   44 556C        g  self
		' g  level		' g  time			' g  str			'  g  filenamef  logging/logger.scm
H
	I		I		J		J		#J		%J	 		'	   C5>  "  G  4li5R4bii>  "  G  4li"5"R4bi"i>  "  G  46"5  $  "  "i $  !4?"4p<a"5>  "  G  "   4s"i4pvwi |   h   V   ]C    N       g  lh
		  g  filenamef  logging/logger.scm
Y
 		   C5>  "  G  4li#5#R4bi#i>  "  G  46#5  $  "  #i $  !4?#4p<a#5>  "  G  "   4s#i4pvwi |       h   V   ]C    N       g  lh
		  g  filenamef  logging/logger.scm
b
 		   C5>  "  G  4li!5!R4bi!i>  "  G  46!5  $  "  !i $  !4?!4p<a!5>  "  G  "   4s!i4pvwi |       h   V   ]C    N       g  lh
		  g  filenamef  logging/logger.scm
l
 		   C5>  "  G  46!5  $  "  !i $  !4?!4p<a!5>  "  G  "   4s!i4pvw|(!      h   W   ] $  6CO       g  filenamef  logging/logger.scm
p
	q		r	 		
   C5>  "  G  46!5  $  "  !i $  !4?!4p<a!5>  "  G  "   4s!i4pvwi |f!     h   e   ] 6]       g  handler
		  g  filenamef  logging/logger.scm
v		w	 		   CC      h   i   ]4 56 a       g  lgr
		  g  filenamef  logging/logger.scm
u
	x		v	 		   C5>  "  G  465  $  "  i $  !4?4p<a5>  "  G  "   4si4pvw|(   h   W   ] $  6CO       g  filenamef  logging/logger.scm
z
	{		|	 		
   C5>  "  G  46"5  $  "  "i $  !4?"4p<a"5>  "  G  "   4s"i4pvwi |f"     h   e   ] 6]       g  handler
		  g  filenamef  logging/logger.scm
			 		   CC      h   i   ]4 56 a       g  lgr
		  g  filenamef  logging/logger.scm
~
				 		   C5>  "  G  46"5  $  "  "i $  !4?"4p<a"5>  "  G  "   4s"i4pvw|("   h   W   ] $  6CO       g  filenamef  logging/logger.scm

				 		
   C5>  "  G  46#5  $  "  #i $  !4?#4p<a#5>  "  G  "   4s#i4pvwi |f#     h   e   ] 6]       g  handler
		  g  filenamef  logging/logger.scm
			 		   CC      h   i   ]4 56 a       g  lgr
		  g  filenamef  logging/logger.scm

				 		   C5>  "  G  46#5  $  "  #i $  !4?#4p<a#5>  "  G  "   4s#i4pvw|(#   h   W   ] $  6CO       g  filenamef  logging/logger.scm

				 		
   C5>  "  G  7  h   #  ]4 56      g  lgr
		 g  lvl		  g  filenamef  logging/logger.scm

				 			  g  nameg  enable-log-level!g  
documentationf uEnables a specific logging level given by the symbol @var{lvl},
such that messages at that level will be sent to the log
handlers.  @var{lgr} can be of type @code{<logger>} or
@code{<log-handler>}.

Note that any levels that are neither enabled or disabled are treated
as enabled by the logging system.  This is so that misspelt level
names do not cause a logging blackout. CR7  h     ]4 56      g  lgr
		 g  lvl		  g  filenamef  logging/logger.scm

				 			  g  nameg  disable-log-level!g  
documentationf \Disables a specific logging level, such that messages at that
level will not be sent to the log handlers.  @var{lgr} can be of
type @code{<logger>} or @code{<log-handler>}.

Note that any levels that are neither enabled or disabled are treated
as enabled by the logging system.  This is so that misspelt level
names do not cause a logging blackout. C R7  h      ]4 56       g  lgr
		 g  lvl		  g  filenamef  logging/logger.scm

		
		 			  g  nameg  level-enabled? CdRC            g  m
		, g  t
	d	 g  t
		 g  t
 g  t
 g  t
@\ g  t
 g  t
3 g  t
l g  t
7L g  t
;P g  t
CX g  t
%: g  t
  # g  t
!! g  t
"v" g  t
#$
 g  t
$$ g  t
&`&u  g  filenamef  logging/logger.scm		x
	0 
	1 		< 
 
 
	\ 
	] 

 	
 
m 	 
 	+ 
 	 
 
 
| 
 
 
 



8
9


1
	2	1
6
J:
W;
\:
eH
N
O
N
T
"U
'T
0Y
\
&]
+\
4b
!e
.f
3e
<l
p
 u
!z
"o~
#
$
&Y
)
+
,p
 >	,r
   C6 