GOOF----LE-8-2.0      ]  4     h
      ] g  guile	 	g  define-module*	 	 	g  logging	g  rotating-log	 		g  filenameS	
f  logging/rotating-log.scm	g  importsS	g  oop	
g  goops	
 	 	g  logger	 	 	g  scheme	g  
documentation	 	 	 	g  exportsS	g  <rotating-log>	 	g  set-current-module	 	 	g  defined?	 	  	!g  	num-files	"g  is-a?	#" 	$" 	%g  	<generic>	&% 	'% 	(g  toplevel-define!	)( 	*( 	+g  ensure-generic	,+ 	-+ 	.g  
size-limit	/g  	file-name	0g  port	1g  
<accessor>	21 	31 	4g  ensure-accessor	54 	64 	7g  fpos	8g  
make-class	9g  
<log-handler>	:g  
init-valueS	;g  getterS	<g  init-keywordS	=g  	num-filesS	>g  
size-limitS	?f  logfile	@g  	file-nameS	Ag  accessorS	Bg  nameS	Cg  <class>	DC 	EC 	Fg  memq	Gg  <object>	HG 	IG 	Jg  class-precedence-list	KJ 	LJ 	Mg  class-redefinition	NM 	OM 	Pg  set-object-property!	Qf This is a log handler which writes text logs that rotate when they reach
a configurable size limit.

Keywords recognized by @code{<rotating-log>} on creation are:
@table @code
@item #:num-files
This is the number of log files you want the logger to use.  Default is 4.

@item #:size-limit
This is the size, in bytes, a log file must get before the logs get
rotated.  Default is 1MB (104876 bytes).

@item #:file-name
This is the base of the log file name.   Default is ``logfile''.  Numbers will
be appended to the file name representing the log number.  The newest log
file is always ``@var{NAME}.1''.

@item #:formatter
Allows the user to provide a function to use as the log formatter for
this handler.  @xref{logging logger <log-handler>}, for details.
@end table

Example of creating a @code{<rotating-log>}:
@lisp
 (make <rotating-log>
      #:num-files 3
      #:size-limit 1024
      #:file-name "test-log-file"))
@end lisp	Rg  
log-file-name	Sg  make	TS 	US 	Vg  add-method!	WV 	XV 	Yg  <method>	ZY 	[Y 	\g  specializersS	]g  <top>	^] 	_] 	`g  formalsS	ag  self	bg  num	cab 	dg  bodyS	eg  
string-append	f/a 	gf  .	hg  number->string	ihb 	jefgi 	kj 	lg  make-procedureS	mg  	procedureS	ng  	open-log!	oa 	pg  set!	q0a 	rg  	open-file	sRa 	tf  a	urst 	vpqu 	w7a 	xg  ftell	yxq 	zpwy 	{vz 	|g  setter	}| 	~| 	g  
close-log! g  if g  
close-port q  q  pq    g  
rotate-log a  g  let g  loop g  - !a    b    g  <= b
  g  begin g  access? Rab  g  F_OK   g  rename-file g  + b  Ra      b          na    g  emit-log g  str a  g  display q  g  
string-length   w  pw  g  > .a  w  a      q    g  	flush-log g  force-output q  q   C 5     h  s  ]4	
5 4 >  "  G   4 !5  $  "  4$!i'5 $  14*!4-4 !5$  !i"  !5>  "  G  "   4 .5  $  "  4$.i'5 $  14*.4-4 .5$  .i"  .5>  "  G  "   4 /5  $  "  4$/i'5 $  14*/4-4 /5$  /i"  /5>  "  G  "   4 05  $  "  4$0i35 $  14*0464 05$  0i"  05>  "  G  "   4 75  $  "  4$7i35 $  14*7464 75$  7i"  75>  "  G  "   "  4*48i9i !:	;!i<= .:       ;.i<> /:?;/i<@ 0:A0i 7A7i  B5>  "  G  "  4 5$  4$iE5$  4FiI4Li55$  4Oi48i9i !:	;!i<= .:       ;.i<> /:?;/i<@ 0:A0i 7A7i  B5>  "  G  "  ""  ""  "4PiiQ>  "  G  4 R5  $  "  Ri $  !4*R4U'BR5>  "  G  "   4XRi4U[\i_ `cdklme/gh h      ]4 5456         g  self
		 g  num		  g  filenamef  logging/rotating-log.scm
	F
		G		
	G	"		G	&		G	 			   C5>  "  G  4 n5  $  "  ni $  !4*n4U'Bn5>  "  G  "   4Xni4U[\i `od{lm~0rRt7x     h@      ]445 44 55>  "  G  45 44 556        g  self
		?  g  filenamef  logging/rotating-log.scm
	I
		J		
	J			J			J	6		J		 	J		2	K		5	K		=	K		?	K	 		?   C5>  "  G  4 5  $  "  i $  !4*4U'B5>  "  G  "   4Xi4U[\i `odlm0~      h8      ]4 5$  44 5>  "  G  "   45 6           g  self
		4  g  filenamef  logging/rotating-log.scm
	M
		N		
	N			O			O			O		4	P	 		4   C5>  "  G  4 5  $  "  i $  !4*4U'B5>  "  G  "   4Xi4U[\i `odlmR!n      h     ]	4 >  "  G  "  P
$  "  R44 55$  '44 54 5>  "  G  "   "4 5" 6    
      g  self
		| g  num		h  g  filenamef  logging/rotating-log.scm
	R
		T			W			X		 	X		%	[		(	[		4	[		8	[	
	9	\		<	\		E	]		L	]	/	N	]		S	\		b	^		h	^	
	h	W		i	W		p	W		v	W		|	a	 		|   C5>  "  G  4 5  $  "  i $  !4*4U'B5>  "  G  "   4Xi4U[\i_ `dlm0~7.    hp      ]4 5$  Z44 5>  "  G  445 454 5>  "  G  4 54 5$   6CC              g  self
		i g  str		i  g  filenamef  logging/rotating-log.scm
	c
		d		
	d			f			f			f		'	g		1	g		8	h		?	g		D	g		M	i		T	j		[	i		_	i		e	k	 		i	   C5>  "  G  4 5  $  "  i $  !4*4U'B5>  "  G  "   Xi4U[\i `odlm0        h    }   ]4 5$  4 56C      u       g  self
		  g  filenamef  logging/rotating-log.scm
	m
		n		
	n			o			o	 		   C56       k      g  m
		, g  t
	4	P g  t
   g  t
  g  t
?[ g  t
 g  t
]r g  t
 g  t
! g  t
\q g  t
		 g  t
m  g  filenamef  logging/rotating-log.scm		
	-	"
1	B	`	"
	B		"
H	#
M	"
V	F
	I
	M
U	R
	}	c
f	m
 	
   C6 