GOOF----LE-8-2.0T      ] * 4    h      ] g  guile	 	g  define-module*	 	 	g  math	g  minima	 		g  filenameS	
f  math/minima.scm	g  importsS	g  scheme	
g  
documentation	
 	 	 	g  exportsS	g  golden-section-search	 	g  set-current-module	 	 	g  sqrt	g  
procedure?	g  number?	g  throw	g  
type-error	g  golden-section-search:	g  not	g  <	g  abs	 g  integer?	!g  warn	"g  min	#g  >	$g  found	%g  max	&g  
misc-error	'g  flat?	(g  set-object-property!	)f The Golden Section Search algorithm finds minima of functions
which are expensive to compute or for which derivatives are not
available.  Although optimum for the general case, convergence is
slow, requiring nearly 100 iterations for the example (x^3-2x-5).

If the derivative is available, Newton-Raphson is probably a better
choice.  If the function is inexpensive to compute, consider
approximating the derivative.

@var{x0} and @var{x1} are real numbers.  The (single argument)
procedure @var{func} is unimodal over the open interval (@var{x0},
@var{x1}).  That is, there is exactly one point in the interval for
which the derivative of @var{func} is zero.

It returns a pair (@var{x} . @var{func}(@var{x})) where @var{func}(@var{x})
is the minimum.  The @var{prec} parameter is the stop criterion.  If
@var{prec} is a positive number, then the iteration continues until
@var{x} is within @var{prec} from the true value.  If @var{prec} is
a negative integer, then the procedure will iterate @var{-prec}
times or until convergence.  If @var{prec} is a procedure of seven
arguments, @var{x0}, @var{x1}, @var{a}, @var{b}, @var{fa}, @var{fb},
and @var{count}, then the iterations will stop when the procedure
returns @code{#t}.

Analytically, the minimum of x^3-2x-5 is 0.816497.
@example
 (define func (lambda (x) (+ (* x (+ (* x x) -2)) -5)))
 (golden-section-search func 0 1 (/ 10000))
      ==> (816.4883855245578e-3 . -6.0886621077391165)
 (golden-section-search func 0 1 -5)
      ==> (819.6601125010515e-3 . -6.088637561916407)
 (golden-section-search func 0 1
                       (lambda (a b c d e f g ) (= g 500)))
      ==> (816.4965933140557e-3 . -6.088662107903635)
@end exampleC 5    hh     ]4	
5 4 >  "  G   4i	5	     h      ]4 5L C       g  x0
		 g  x1		 g  a			 g  b			 g  fa			 g  fb			 g  count			  g  filenamef  math/minima.scm
	O			O	7	
	O	<		O	7		O	3 			   C h      ]
L C             g  x0
		
 g  x1		
 g  a			
 g  b			
 g  fa			
 g  fb			
 g  count			
  g  filenamef  math/minima.scm
	Q			Q	A			Q	7 		
	   C !"#$%"&'       hX    ]|4 5$  {45$  T45$  -$   4>  "  G  "   "  4>  "  G  "  4>  "  G  "  4	 >  "  G  45$  "  R45$  :
$  
O "  #45$  O "  
4
5"  
4	5L L H	HH" "  rJ	$  #4J	 >  "  G  "   		$  7
$  "  $  4>  "  G  "   "   C$  45K45K	"  Y	$  C4J	5K	J$  )$  4J>  "  G  "   "   "  
4J	5K	4

5$  !$  "
"$  f


L "  -
K

4 5

"J$  J
$  "t""L "  -
K
4 5

"*J$  J
$  
"""4 54 5

"           g  f
	S g  x0	S g  x1		S g  prec		S g  stop?	S g  a0	S g  b0	S g  delta	S g  fmax	S g  fmin		S g  left	
.* g  right	.* g  a	.* g  b	
.* g  fa	.* g  fb	.* g  count	.* g  x	2 g  fx	2 g  a-next	m g  b-next	*  g  filenamef  math/minima.scm
	E			F		
	F			G			F			H		#	F		(	I	
	,	F		-	I		1	I		3	C	
	7	I	2	9	I	7	@	I		Q	H	 	U	H	'	W	C	
	Y	H	7	`	H	 	m	G	 	q	G	'	s	C	
	u	G	7	|	G	  	F	" 	F	) 	C	
 	F	9 	F	" 	L	 	K	
 	M	 	K	
 	N	 	N	 	P	 	P	 	R	 	R	 	C	
 	R	/ 	R	 	S	 	S	 	C	
 	S	,	S	
	T		T	#	T		T		U		U		U		J	.	Y	2	a	7	b	;	b	<	b	@	C	
D	b	+F	b	0H	b	;M	b	5R	b	c	c	g	c	l	c	'p	c	#q	c	'z	c	6~	c		d		C	
	d		d	!	d	&	d		e		f	
	h		h	
	i		i	
	f	
	k		k	
	l		l	
	l		l	 	l	'	C	
	l	8	l	 	n		n	
 	o	6	o	
;	p	?	p	K	q	W	r	\	s	`	o	
g	t	*k	t	5l	t	'm	t	m	t	x	w	+z	w		x	5	y	%	x		u		u	.	u	%	u		v		{	'	{	$	{		{		~	+	~			9 	%			|		|	.	|	%	|	"	}	*	Y	3	]	:	^	S	Y	 	S	   C O  R4(ii
)>  "  G  C          g  m
		, g  r
	9F  g  filenamef  math/minima.scm		
	-	D		6	D		9	D		9	C	I	
V	 
[	
 		e
   C6 