GOOF----LE-8-2.0#      ] = 4 h      ] g  guile	 	g  define-module*	 	 	g  math	g  primes	 		g  filenameS	
f  math/primes.scm	g  importsS	g  scheme	
g  
documentation	
 	 	 	g  exportsS	g  prime:trials	g  prime?	g  prime>	g  primes>	g  prime<	g  primes<	g  factor	 	g  set-current-module	 	 	g  seed->random-state	f  repeatable seed for primes	g  prime:prngs	 g  odd?	!g  prime:jacobi-symbol	"g  set-object-property!	#f  This is the maximum number of iterations of Solovay-Strassen that will
be done to test a number for primality.  The chance of error (a composite 
being labelled prime) is @code{(expt 2 (- prime:trials))}.	$g  gcd	%g  modulo-expt	&g  random	'g  Solovay-Strassen-prime?	(g  primes-gcd?	)g  prime:prime-sqr	*	i 	+g  prime:products	,g  b
	
      j   	-g  prime:sieve	.g  most-positive-fixnum	/g  make-bitvector	0g  for-each	1g  bitvector-set!	2g  reverse	3		 	4g  abs	5g  bitvector-length	6g  
bitvector-ref	7g  even?	8g  max	9g  append	:g  prime:f	;g  prime:fo	<g  prime:feC 5     h    ]04	
5 4 >  "  G   4i5R !        h     ]
 
$  
C $  C4 5$  04 		5$  
4  5C  6	4	5$  
4 	5C 	6          g  p
	  g  q	  g  qq		V   g  filenamef  math/primes.scm
	B
		C			
	C			D				C			E			!	C		"	F	
	)	F	#	*	F	 	-	F	4	.	F		1	F		3	F	
	7	F			8	G	
	9	G		@	G	%	D	G		E	G	
	M	H	"	Q	H	
	V	J		V	J			Y	K		`	K	"	a	K		d	K		f	K		j	K		k	L		l	L		s	L	'	w	L		x	L	 	M	$ 	M	 &	 	  g  nameg  prime:jacobi-symbol C!R	R4"ii
#>  "  G  $!%&        hx   Z  ]"  W
$  M4 5$  <4 5 4 	 5$  	4 	5"CCC	4 	5"  R      g  n
		v g  i		] g  a			]  g  filenamef  math/primes.scm
	X
		Y				\			Y			]			]			\			^		)	^		*	_		1	_	-	4	_	#	8	_		9	^		=	\		@	Y		C	[		J	[		N	[		O	[	
	W	Y		b	Z		i	Z		m	Z		n	Z	
	v	Y	 		v  g  nameg  Solovay-Strassen-prime? C'R$     h@      ]
"  )(  "  &4 5$  	""  "πC              g  n
		9 g  comps		9 g  lst			/  g  filenamef  math/primes.scm
	d
		e			f			
	f	
		f	#		f	*		f	#		f		!	f		$	f	<	*	f	6	/	e		8	e	 		9	  g  nameg  primes-gcd? C(R	y)R*+R,-R" *.i$  +4 5"$  )i4/i5-i40i1- h   ^   ] 6     V       g  prime
		  g  filenamef  math/primes.scm
	s	 		t	" 		   C>  "  G  42i5+i" e4 5"2(   h@      ]
H4J5K"  4J5$  	"C	 "              g  nexp
		9 g  comps		9 g  nexp			.  g  filenamef  math/primes.scm
	{			|	#		|			}			~	!	 	}		%	}	-	+	}		3	}	"	9	}	 		9	  g  nameg  
next-prime C 	3	" 45-67(+)' 
hX     ] H 4J 5K J 45$  J 64J 5$  C4J 5$  CJ $  C	J 6            g  n
		R  g  filenamef  math/primes.scm
 
	 	
	 		 		 			 		% 	.	& 			0 		3 			? 		F 			J 		R 	 		R  g  nameg  prime?g  
documentationf  Returns @code{#f} if @var{n} is composite, and @code{t} if it is prime. 
There is a slight chance, @code{(expt 2 (- prime:trials))}, that a 
composite will return @code{#t}. CR  hH     ]"  5
$  "  45$  

$  CC" "          g  start
		D g  nbr		; g  t		
	!  g  filenamef  math/primes.scm
 
	 			 		
 		 		% 		( 		- 		5 		; 		> 		D 	 
		D  g  nameg  prime<g  
documentationf  Return the first prime number less than @var{start}.  It doesn't matter
if @var{start} is prime or composite.  If no primes are less than @var{start}, 
@code{#f} will be returned. CR   hX   '  ]"  ;$  
"  $  $  CC45"	4 5"      g  start
		X g  count		X g  cnt			A g  lst			A g  prime			A  g  filenamef  math/primes.scm
 
	 		 		 		 		 		 		$ 		+ 		0 		1 		A 		F 		G 		H 		X 	 		X	  g  nameg  primes<g  
documentationf  Returns a list of the first @var{count} prime numbers less than
@var{start}.  If there are fewer than @var{count} prime numbers
less than @var{start}, then the returned list will have fewer than
@var{start} elements. CR        h(   >  ]	"  45$  C" "  6      g  start
		& g  nbr		  g  filenamef  math/primes.scm
 
	 		 		 		 		 		  		& 	 			&  g  nameg  prime>g  
documentationf  pReturn the first prime number greater than @var{start}.  It doesn't matter
if @var{start} is prime or composite. CR82     hX     ] H 4
J 5K "  *
$  	645"	4J 5"         g  start
		U g  count		U g  cnt			> g  lst			> g  prime			>  g  filenamef  math/primes.scm
 
	 		 		 		 		 		# 		% 		( 		- 		. 		> 		C 		D 		E 		U 	 		U	  g  nameg  primes>g  
documentationf  OReturns a list of the first @var{count} prime numbers greater than @var{start}. CR9:7     h     ]
$  l
$  C $  C$  C4	 	5$  "    4		5$  "   645$  ?4 	5$  C  	64 	5$  C  	6          g  u
	  g  v	  g  b		  g  n		  g  t		9	O g  t		^	t g  t	   g  t	    g  filenamef  math/primes.scm
 
	 		
 		
 	
	 		 	
	 		" 	
	& 		+ 		4 	7	7 	-	9 		9 		L 		P 		Y 	7	\ 	-	^ 		^ 		q 		v 		w 	
  	  	  	  	#  	  	
  	  	  	'  	>  	9  	/  	  	  	  	!  	3  	)  	  	
  	  	!  	3  	)  	 1	 	  g  nameg  prime:f C:R$+:9 h     ]4 5 $   4	 	5$  C  C$  "  %4		5$  "   4		5$  "   6      g  m
	  g  s	  g  r		  g  t		,	= g  t		[	q g  t	    g  filenamef  math/primes.scm
 
	 		
 		 		 		 		 		 		 		 		' 	%	* 		, 		, 		< 	1	C 	
	G 			H 		M 		V 	*	Y 	 	[ 		[ 	
	n 	6	r 	
	{ 	&	~ 	  	
  		  	2  	  	   g  nameg  prime:fo C;R7<;  h0      ]4 5$  	4 	5C &  C 6             g  m
		*  g  filenamef  math/primes.scm
 
	 		
 		 		 		 		 		" 		# 	
	* 	
 		*  g  nameg  prime:fe C<R<       hH   m  ] 	$  "   
$  "   $    C 
$  
	4
 5C 6  e      g  k
		F  g  filenamef  math/primes.scm
 
	 		* 		. 		3 	
	6 		9 	!	> 		? 		F	 		F  g  nameg  factorg  
documentationf  Returns a list of the prime factors of @var{k}.  The order of the
factors is unspecified.  In order to obtain a sorted list do
@code{(sort! (factor @var{k}) <)}. CRC            g  m
		, g  comp% g  comps	% g  primes	% g  nexp	% g  ncomp	4 g  
next-prime
Si  g  filenamef  math/primes.scm		
	-	.		3	.		5	.		8	-
	B
	O
	P		O
	X
	d
	g
	h		h
	i		i
	j	
	k		k			k		l	#	l		n		o	#	o	-%	o	1	m	9	p	>	p	.?	p	C	k	H	q	,L	q	M	r	(Z	r	[	s		v	+	v	4	v	+	v		x	
	y		z		z	+	z	%	x	S	j
V		X		f		
 
 
" 
 
 
c 
 
 
 
 <	
   C6 