GOOF----LE-8-2.0ap      ] 4   h      ] g  guile	 	g  define-module*	 	 	g  os	g  process	 		g  filenameS	
f  os/process.scm	g  importsS	g  compat	
g  guile-2	
 	 	 	g  set-current-module	 	 	g  call-with-deferred-observers	 	 	g  module-export!	 	 	g  current-module	 	 	g  tail-call-program	g  run	g  run-concurrently	 g  
run-with-pipe	!  	"g  run-concurrently+	#g  run+	$g  tail-call-pipeline+	%g  tail-call-pipeline	&"#$% 	'g  #os:process:pipe-make-redir-commands	(g  os:process:pipe-make-commands	)g   os:process:setup-redirected-port	*g  os:process:new-comm-pipes	+'()* 	,g  os:process:pipe-fork-child	-, 	.g  current-input-port	/g  O_RDONLY	0g  catch	10 	20 	3g  fileno	4g  	open-fdes	5g  
*null-device*	6g  current-output-port	7g  O_WRONLY	8g  current-error-port	9g  	dup->fdes	:g  dup2	;g  stdports->stdio	<g  ensure-batch-mode!	=g  execlp	>g  pipe	?g  setvbuf	@g  _IONBF	Ag  unbuffered-pipe	Bg  append	Cg  setsid	DC 	Eg  cond	Fg  isatty?	G. 	HFG 	Ig  let	Jg  name	Kg  ttyname	LKG 	MJL 	Ng  mode	Og  	port-mode	POG 	QNP 	RMQ 	Sg  
close-port	TSG 	Ug  set-current-input-port	Vg  	open-file	WVJN 	XUW 	YIRTX 	ZHY 	[EZ 	\g  map	]g  lambda	^g  p	_^ 	`g  false-if-exception	ag  
close-fdes	b3^ 	cab 	d`c 	e]_d 	fg  loop	gg  pts	hg  list	i6 	j8 	khGij 	lg  fds	mh 	nlm 	on 	pg  if	qg  null?	rqg 	sg  
port-for-each	tg  f	u`b 	vtu 	wv 	xg  and	yg  not	zg  memv	{ztl 	|y{ 	}xt| 	~at 	`~  p}  Iw  ]_  s  g  cdr g  g  fd g  car g  3  `      g  cons l  pl  I  f  pr    g  slaveS g  
no-auto-closeS g  
foregroundS g  length g  set! g  number? g  newport U    g  set-current-output-port     g  set-current-error-port     g  duplicate-port g  primitive-move->fdes g  make-syntax-transformer     g  macro g  $sc-dispatch     g  _ g  any  g  
syntax->datum     g  
datum->syntax     g  gensym g  primitive-fork     m  g  = 
  <  B  B  g  primitive-exit     g  else g  syntax-violation     f  -source expression failed to match any pattern "  g  waitpid g  apply g  string=? g  	OPEN_READ g  
OPEN_WRITE g  	OPEN_BOTH g  error f  bad mode string:  g  pipe-split-components mm    g  quote g  	pipe-list   \S  ]  g  next-pid g  waiting-for g  result 
    g  > 
  g  let* g  report g  WAIT_ANY     g  pid     g  status g  exit-val g  status:exit-val       g  term-sig g  status:term-sig       g  or g  +      I      g  member g  -                 g  reversef  w0g  list-refg  remove-dup-connections!	
 
	 C 5 h^     ]4	
5 4 >  "  G   4!   h   @   ] 45 6   8       g  filenamef  os/process.scm
	3
 		
   C>  "  G  4&      h   @   ] 45 6   8       g  filenamef  os/process.scm
	4
 		
   C>  "  G  4+      h   @   ] 45 6   8       g  filenamef  os/process.scm
	9
 		
   C>  "  G  4-      h   @   ] 45 6   8       g  filenamef  os/process.scm
	;
 		
   C>  "  G  ./23      h   I   ] L 6A       g  filenamef  os/process.scm
	G			G	0 		
   C     h   V   -  1  3 C     N       g  args
			  g  filenamef  os/process.scm
	G	 			


   C45673    h   I   ] L 6A       g  filenamef  os/process.scm
	G			G	0 		
   C     h   V   -  1  3 C     N       g  args
			  g  filenamef  os/process.scm
	G	 			


   C83  h   I   ] L 6A       g  filenamef  os/process.scm
	G			G	0 		
   C     h   V   -  1  3 C     N       g  args
			  g  filenamef  os/process.scm
	G	 			


   C9:   h8    ](45  4 O 5$  "  	45  45 	4
O 5$  "  	45H45 	4
O 5$  "  	45H 
$  "  ;J
$  4
5K"   J
$  4
5K"   4 
>  "  G  J$  "  'J$  45K"   4J>  "  G  J	6~      g  port
			< g  mode			< g  t			6 g  
input-fdes
	<8 g  port	E	x g  mode		E	x g  t		X	r g  output-fdes	x8 g  port	   g  mode	   g  t	   g  
error-fdes	 8  g  filenamef  os/process.scm
	A
		J	"			J			G			G		+	H		<	F		?	K	#	E	K		J	G		X	G		g	H		x	F		{	L	" 	L	 	G	 	G	 	H	 	F	 	R	 	R	 	S	 	S	 	T	! 	T	 	U	 	U	 	V	  	V	 	W		Y		Y	
	Z		Z		[	 	[		\	8	^	 '	8
  g  nameg  stdports->stdio C;R<;=     h8     - 1 3 4>   "  G  4>   "  G    @           g  prog
			3 g  args			3  g  filenamef  os/process.scm
	g
	
 		 		3 	 			3
  g  nameg  tail-call-programg  
documentationf -Replace the current process image by executing @var{prog} with the
supplied list of arguments, @var{args}.

This procedure will reset the signal handlers and attempt to set up file
descriptors as follows:

@enumerate
@item File descriptor 0 is set from (current-input-port).
@item File descriptor 1 is set from (current-output-port).
@item File descriptor 2 is set from (current-error-port).
@end enumerate

If a port can not be used (e.g., because it's closed or it's a string
port) then the file descriptor is opened on the file specified by
@code{*null-device*} instead.

Note that this procedure does not close any ports or flush output
buffers.  Successfully executing @var{prog} will prevent the normal
flushing of buffers that occurs when Guile terminates.  Doing otherwise
would be incorrect after forking a child process, since the buffers
would be flushed in both parent and child.

Examples:
@example
 (tail-call-program "cat" "/etc/passwd")
@end example
@example
 (with-input-from-file "/etc/passwd"
  (lambda ()
    (tail-call-program "cat")))
@end example CR>?@ h(      ]45  4 >  "  G   C              g  result
		!  g  filenamef  os/process.scm
 
	 		 		
 		 	
	 	 		!
  g  nameg  unbuffered-pipe CARBD[\eIfgBko(  hh  f  ]B" J(  `$  4 5"$    6	
   6
&  "y&  "]&  "@45$  '  "45$  "  $  "  	44	55"   "     ^      g  connections
	c g  portvar	c g  conns		P g  insert		P g  slave		P g  
no-auto-close		P g  c		oP g  reversed	P g  in	P g  out		)P  
g  filenamef  os/process.scm
 		 		 		 	
	 		 	(	 	(	  	'	" 		1 		7 	
	= 		G 		I 		O 		j 		l 		o 		o 	
	y 		| 	!  	  	  	!  	  	  	!  	  	  	  	  	  	  	/  	  	  	  	'  	0 	' 	 	! 	% 	% 	 	"! 	&( 	&) 	. 	#/ 	#2 	$@ 	#P 	P 	U 	c 	 :	c	  g  nameg  #os:process:pipe-make-redir-commands C'RI) 	  h     ] 
$       C $       C 	$       C        C         g  fdes
	  g  port	  g  portvar		   g  filenamef  os/process.scm
 				
				)		-		/		M		Q		S		n
	 	 	  g  nameg  os:process:pipe-make-commands C(R3O     h@      ]
4 5$   C4 4 554>  "  G  C             g  port
		: g  fdes		: g  newport		!	:  g  filenamef  os/process.scm
											,	!		!		$	
 
		:	  g  nameg   os:process:setup-redirected-port C)R4"IE' 
      hX      - 1 3 45 45  4	4
5 5   C          g  proc
			U g  connections			U g  pid			U g  ports			U  g  filenamef  os/process.scm

	
F	
	G		F		H		6M		BH	 			U
   C     h   c   ]	4 5L 4?6[       g  args
		 g  v			  g  filenamef  os/process.scm	
 		   C      h(     ]	4 5$   O @ 6       g  y
		' g  tmp		'  g  filenamef  os/process.scm

 		'  g  
documentationf Evaluate an expression in a new background process.  If no connection
terms are specified, then all ports except @code{current-input-port},
@code{current-output-port} and  @code{current-error-port} will be
closed in the new process.  The file descriptors
underlying these ports will not be changed.

The value returned in the parent is the pid of the new process.

When the process terminates its exit status can be collected
using the @code{waitpid} procedure.

Keywords can be specified before the connection list:

@code{#:slave} causes the new process to be put into a new session.
If @code{current-input-port} (after redirections) is a tty it will
be assigned as the controlling terminal.  This option is used when
controlling a process via a pty.

@code{#:no-auto-close} prevents the usual closing of ports which
occurs by default.

@code{#:foreground} makes the new process the foreground job of the
controlling terminal, if the current process is using job control.
 (not currently implemented).
The default is to place it into the background

The optional connection list can take several forms:

@code{(port)} usually specifies that a given port not be closed.
However if @code{#:no-auto-close} is present it specifies instead
a port which should be closed.

@code{(port 0)}
specifies that a port be moved to a given file descriptor
 (e.g., 0) in the new process.  The order of the two components
is not significant,
but one must be a number and the other must evaluate to a port.
If the file descriptor is one of the standard set @code{(0, 1, 2)}
then the corresponding standard port (e.g., @code{current-input-port})
will be set to
the specified port.

Example:
@example
 (let ((p (open-input-file "/etc/passwd")))
   (run-concurrently+ (tail-call-program "cat") (p 0)))
@end exampleg  
macro-typeg  defmacrog  
defmacro-argsg  args  C5"R4     h   A   ] 45 6   9       g  filenamef  os/process.scm

 		
   C>  "  G  4#"     h    w   - 1 3    C o       g  expr
			 g  connections			  g  filenamef  os/process.scm
S
	g	 			
   C      h   c   ]	4 5L 4?6[       g  args
		 g  v			  g  filenamef  os/process.scm	S
 		   C      h(     ]	4 5$   O @ 6       g  y
		' g  tmp		'  g  filenamef  os/process.scm
S
 		'  g  
documentationf Evaluate an expression in a new foreground process and wait for its
completion.  If no connection terms are specified, then all ports except
@code{current-input-port}, @code{current-output-port} and
@code{current-error-port} will be closed in the new process.
The file descriptors underlying these ports will not be changed.

The value returned is the exit status from the new process as returned
by the @code{waitpid} procedure.

The @var{keywords} and @var{connections} arguments are optional: see
@code{run-concurrently+}, which is documented below.
The @code{#:foreground} keyword is implied.

@example
 (run+ (begin (write (+ 2 2)) (newline) (quit 0)))
@end example
@example
 (run+ (tail-call-program "cat" "/etc/passwd"))
@end exampleg  
macro-typeg  defmacrog  
defmacro-argsg  args  C5#R<s23       h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   Cza  h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   C       h8   7   ]	4 O 5$  4L 5$  CO 6C/       g  p
		8 g  f		8  		8   C23 h      ] L 6              			
   C     h   .   -  1  3 C     &       g  args
			  			


   CB.68 h     - 1 3 445   
$  4>   "  G  "  Q(  4O >  "  [G  "  T4O 5$  	"  "4	4
5 45 45  5  "4
 >  "  G  45"  5C         g  prog
		  g  args		  g   g407		  g   g408		  g  pts		4  g  fds		4  g  fd		g	}  g  filenamef  os/process.scm
i
 r	 r	 		 
  g  nameg  rung  
documentationf  Execute @var{prog} in a new foreground process
and wait for its completion.  The value returned is the exit status 
of the new process as returned by the @code{waitpid} procedure.

Example:
@example
 (run "cat" "/etc/passwd")
@end example CR<s23       h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   Cza  h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   C       h8   7   ]	4 O 5$  4L 5$  CO 6C/       g  p
		8 g  f		8  		8   C23 h      ] L 6              			
   C     h   .   -  1  3 C     &       g  args
			  			


   CB.68 h   
  -  1  3 45   
$  4>   "  G  "  Q(  4O >  "  [G  "  T4O 5$  	"  "44	5 4
5 45  5  "4
 >  "  G  6C            g  args
		  g   g409	  g   g410		  g  pts		1  g  fds		1  g  fd		d	z  g  filenamef  os/process.scm
t
		 	 		 


  g  nameg  run-concurrentlyg  
documentationf Start a program running in a new background process.  The value returned
is the pid of the new process.

When the process terminates its exit status can be collected
using the @code{waitpid} procedure.

Example:
@example
 (run-concurrently "cat" "/etc/passwd")
@end example CRA<)s23 h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   Cza  h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   C       h8   7   ]	4 O 5$  4L 5$  CO 6C/       g  p
		8 g  f		8  		8   C23 h      ] L 6              			
   C     h   .   -  1  3 C     &       g  args
			  			


   CB.68SU23     h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   Cza  h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   C       h8   7   ]	4 O 5$  4L 5$  CO 6C/       g  p
		8 g  f		8  		8   C3   h      ] L 6              			
   C     h   .   -  1  3 C     &       g  args
			  			


   C23       h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   Cza  h      ] L 6       		
   C     h   .   -  1  3 C     &       g  args
			  			


   C       h8   7   ]	4 O 5$  4L 5$  CO 6C/       g  p
		8 g  f		8  		8   C3   h      ] L 6              			
   C     h   .   -  1  3 C     &       g  args
			  			


   C    h  g  - 1 3 
4 5$ 45 45   
$  4>   "  G  454>  "  G  "  Q(  4	O >  "  [G  "  T4
O 5$  	"  "4
45 45 45  5  "4>  "  G  45"  4>  "  G  C4 5$ 45 45   
$  4>   "  G  4
54>  "  G  "  Q(  4O >  "  [G  "  T4
O 5$  	"  "4
45 45 45  5  "4>  "  G  45"  4>  "  G  C4 5$ F45 45 45   
$  4>   "  G  454>  "  G  4
54>  "  G  "  Q(  4O >  "  [G  "  T4
O 5		$  		"  	"4
45 45 45  5  "4>  "  G  45"  4>  "  G  4>  "  G  C 6  _      g  mode
		 g  prog		 g  args			 g  upipe		 g   g411		% g   g412		% g  newport		J	a g  pts		e  g  fds		e  g  fd	   g  pid	 g  upipe	03 g   g413	: g   g414	: g  newport	_v g  pts	z g  fds	z g  fd	 g  pid	3 g  upipe-r	E g  upipe-w	L g   g415	VS g   g416	VS g  newport	{ g  newport	 g  pts	 g  fds	 g  fd		 g  pid	S  g  filenamef  os/process.scm

	
										%		G	+ 	(			
						+	,	0		:	\	+	(				$	1	2	4		@	A	E		H	L		V	x	+	+,	(S		V	[	`	i	n	s			)					 3			
	  g  nameg  
run-with-pipeg  
documentationf Start @var{prog} running in a new background process.
The value returned is a pair: the CAR is the pid of the new process
and the CDR is either a port or a pair of ports (with the CAR containing
the input port and the CDR the output port).  The port(s) can
be used to read from the standard output of the process
and/or write to its standard input, depending on the @var{mode}
setting.  The value of @var{mode} should be one of "r", "w" or "r+".

When the process terminates its exit status can be collected using the
@code{waitpid} procedure.

Example:
@example
 (use-modules (ice-9 rdelim)) ; needed by read-line
 (define catport (cdr (run-with-pipe "r" "cat" "/etc/passwd")))
 (read-line catport)
@end example C R4$IB*,\Ep  h    -  1  3 	45 4 545  4"  j(  "  o4	
      
   5"  "          5C           g  args
		 g  pipes	 g  split-comps		 g  expressions		 g  connections		! g  pids		( g  rem-exps		@  g  	rem-conns		@  g  insert		@   	g  filenamef  os/process.scm

	
												!		!		$		(		,		@			F		O		R		S		Y		d	+	h		y	E	|	:		: 	 	 	 		 	 		 	 		


   C h   c   ]	4 5L 4?6[       g  args
		 g  v			  g  filenamef  os/process.scm	
 		   C      h(     ]	4 5$   O @ 6       g  y
		' g  tmp		'  g  filenamef  os/process.scm

 		'  g  
documentationf Replace the current process image with a pipeline of connected processes.

Each process is specified by an expression and each pair of processes
has a connection list with pairs of file descriptors.  E.g.,
@code{((1 0) (2 0))} specifies that file descriptors 1 and 2 are to be
connected to file descriptor 0.  This may also be written
as @code{((1 2 0))}.

The expressions in the pipeline are run in new background processes.
The foreground process waits for them all to terminate.  The exit
status is derived from the status of the process at the tail of the
pipeline: its exit status if it terminates normally, otherwise 128
plus the number of the signal that caused it to terminate.

The signal handlers will be reset and file descriptors set up as for
@code{tail-call-program}.  Like @code{tail-call-program} it does not
close open ports or flush buffers.

Example:
@example
 (tail-call-pipeline+ (tail-call-program "ls" "/etc") ((1 0))
                      (tail-call-program "grep" "passwd"))
@end exampleg  
macro-typeg  defmacrog  
defmacro-argsg  args  C5$R\A      hP   G  ]45 "  &
$  645" 4 5	"  ?      g  conn
		N g  rw-pair		N g  	new-pipes		
	3 g  count		
	3  g  filenamef  os/process.scm
	
	 		 		
									'	!	7	#	G	%	'	(	!	+	!	3		3		6	1	9	?	<	+	=	*	F	'	N	 		N   C      h      ] 45C       g  	old-pipes
		 g  	out-conns		  g  filenamef  os/process.scm

						 			  g  nameg  os:process:new-comm-pipes C*R4,"B 
 h    ], 4"  
$  "  445"  ]
$  .4   45  5"  <    "45	  "5"^45  "K"  
$  "  45"  ^
$  &4	     5"  E	   45 "45	  ""b45  "O5C       g  expr
	 g  in-conns	 g  	out-conns		 g  pipes		 g  count		  g  redirs		  g  	this-conn		,  g  dcount		2  g  lines		2  g  count	 f g  redirs	 f g  	this-conn	 ^ g  dcount	 F g  lines	 F  g  filenamef  os/process.scm

												 		!		$	-	,		2		6	$	:	 	;	$	A	%	S	.	Z	)	]	%	d	$	k!	%	m$	&	~&	3 $	& "	%  	$ 	 	2 	/ 	5 	 	 	 	 	$ 	! 	" 	 (	 *	 *	 ,	 .	, .	 /	 2	# 2	 3	# 5	+3	#:	$=	%,?	)/=	%0@	(;=	%>;	$F9	#F/	G0	1P0	.S1	4[/	f,	f(	g(	$n(	!q)	"y(	{	|	 G		   C      h   c   ]	4 5L 4?6[       g  args
		 g  v			  g  filenamef  os/process.scm	
 		   C      h(   a   ]	4 5$   O @ 6 Y       g  y
		' g  tmp		'  g  filenamef  os/process.scm

 		'   C5,R        hx     ]!"  Y(  45  4  5C$  "45"     "          g  ppe
		t g  	remaining		_ g  do-expr?			_ g  exprs			_ g  connections			_  g  filenamef  os/process.scm
D
	E		I		
J		M		M		M	-	M	'	!M		"M		#J		*I		-N		1P	 	4P		BN		ER		IU		NU	5	PU		SU		_R		_E		eG		hH		tE	 		t  g  nameg  pipe-split-components CR\B    h     ]!4 5"  m(  "  $  6"  F(  	"$  45""""        g  connections
	  g  
r-connections	  g  left			~ g  right-1		0	v g  right		3	v  g  filenamef  os/process.scm
Z
	[		[		\		]	
	]		]	"	 ]		$]		,^	
	0_	
	3`		3`		;a		>b		Db		Gc		Kc	(	Mc		Qc		Td	(	Yd	0	\d	;	_d	(	`d		ee	+	fe		nf		ph	%	vh		v_	
	~\	 !	   g  nameg  remove-dup-connections! CR4%$
        h`   7  -  1  3 "  <(  45"  8(  "  "   "C      /      g  args
			Z g  rem		K g  result			K g  temp		,	C  g  filenamef  os/process.scm
j
	{		|		~				#		%	+	(	/	)	+	,	%	,		1	&	5		=	%	@		K		K|		P}		X|		Y{	 			Z


   C      h   c   ]	4 5L 4?6[       g  args
		 g  v			  g  filenamef  os/process.scm	j
 		   C      h(   E  ]	4 5$   O @ 6 =      g  y
		' g  tmp		'  g  filenamef  os/process.scm
j
 		'  g  
documentationf Replace the current process image with a pipeline of connected processes.

The expressions in the pipeline are run in new background processes.
The foreground process waits for them all to terminate.  The exit
status is derived from the status of the process at the tail of the
pipeline: its exit status if it terminates normally, otherwise 128
plus the number of the signal that caused it to terminate.

The signal handlers will be reset and file descriptors set up as for
@code{tail-call-program}.  Like @code{tail-call-program} it does not
close open ports or flush buffers.

Example:
@example
 (tail-call-pipeline ("ls" "/etc") ("grep" "passwd"))
@end exampleg  
macro-typeg  defmacrog  
defmacro-argsg  args  C5%RC           g  m
		(  g  filenamef  os/process.scm		0
	)	3
 	4
	9
	;
q	A

	g
 
 	G 		 o
+i
0t
AZ
L
VD
XZ
 	^
   C6 