GOOF----LE-8-2.0,      ]  4 h      ] g  guile	 	g  define-module*	 	 	g  string	g  
completion	 		g  filenameS	
f  string/completion.scm	g  importsS	g  search	
g  basic	
 	 	g  srfi	g  srfi-13	 	 	g  scheme	g  
documentation	 	 	g  oop	g  goops	 	 	 	g  exportsS	g  <string-completer>	g  case-sensitive-completion?	 g  add-strings!	!g  all-completions	"g  complete	# !" 	$g  set-current-module	%$ 	&$ 	'g  make-generic	(g  set-object-property!	)f  }@code{case-sensitive-completion? completer}.  Returns @code{#t} if the 
completer is case-sensitive, and @code{#f} otherwise.	*g  defined?	+* 	,* 	-g  completer-strings	.g  is-a?	/. 	0. 	1g  
<accessor>	21 	31 	4g  toplevel-define!	54 	64 	7g  ensure-accessor	87 	97 	:g  	<generic>	;: 	<: 	=g  ensure-generic	>= 	?= 	@g  <class>	A@ 	B@ 	Cg  memq	Dg  <object>	ED 	FD 	Gg  class-precedence-list	HG 	IG 	Jg  class-redefinition	KJ 	LJ 	Mg  
make-class	Ng  strings	Og  
init-valueS	P  	Qg  accessorS	Rg  init-keywordS	Sg  stringsS	Tg  case-sensitive?	Ug  getterS	Vg  case-sensitive?S	Wg  nameS	Xf This is the class that knows what the possible expansions are, and 
can determine the completions of given partial strings.  The following
are the recognized keywords on the call to @code{make}:

@table @code
@item #:strings
This gives the completer an initial set of strings.  It is optional, and
the @code{add-strings!} method can add strings to the completer later,
whether these initial strings were given or not.  The strings that 
follow this keyword can take any form that the @code{add-strings!} 
method can take (see below).

@item #:case-sensitive?
This is a boolean that directs the completer to do its comparisons in 
a case sensiteve way or not.  The default value is @code{#t}, for
case-sensitive behavior.
@end table	Yg  
initialize	Zg  make	[Z 	\Z 	]g  add-method!	^] 	_] 	`g  <method>	a` 	b` 	cg  specializersS	dg  <top>	ed 	fd 	gg  formalsS	hg  sc	ig  initargs	jhi 	kg  bodyS	lg  next-method	ml 	ng  if	og  not	pg  vector?	q-h 	rpq 	sor 	t hq 	unst 	vmuh 	wg  make-procedureS	xg  	procedureS	yf 
@code{add-strings! completer strings}.  Adds the given strings
to the set of possible comletions known to @var{completer}.
@var{strings} can either be a list of strings, or a single string
of words separated by spaces.  The order of the words given is
not important.	zhN 	{g  let	|g  comparison-func	}h 	~g  string<?	g  string-ci<? n}~  |    g  cond g  string? N  g  set! g  list->vector g  sort g  append g  vector->list q  g  string-split N     |    q    g  list? N  N  |    q    g  else g  throw g  quote g  bad-type   f  expecting string or list       {    g  setter     g  
string-length g  string>? g  	substring g  case-sensitive-partial-compare g  string-ci>? g   case-insensitive-partial-compare g  string-null? g  binary-search-sorted-vector g  
vector-length g  reverse! f @code{complete completer str}.  Accepts a string, @var{str}, and
returns four values via a @code{values} call.  These are:
@table @var
@item completions
This is the same list that would be returned from a call to
@code{all-completions}.

@item expansion
This is the longest string that would have returned identical results.
In other words, this is what most programs replace your string with
when you press TAB once.  This value will be equal to @var{str} if
there were no known completionss.

@example
 ("wonders" "wonderment" "wondering") 
completed against "won" yields an expansion 
of "wonder"
@end example

@item exact?
This will be @code{#t} if the returned @var{expansion} is an exact
match of one of the possible completions.

@item unique?
This will be #t if there is only one possible completion. Note that
when @var{unique?}  is @code{#t}, then @var{exact?} will also be
@code{#t}.
@end table g  str h  g  longest-substring   g  exact-match?   g  unique?   g  completions !h    g  s-p-l g  string-prefix-length g  string-prefix-length-ci n}    g  s=? g  string=? g  string-ci=? n}      g  null?   o  g  begin g  car     g  cdr       g  for-each g  lambda g  s     
              n  g  values   {   C 5   h  }  ]4	
#5 4& >  "  G   4'i5R4(ii)>  "  G  4,-5  $  "  40-i35 $  146-494,-5$  -i"  -5>  "  G  "   4,5  $  "  40i<5 $  1464?4,5$  i"  5>  "  G  "   4,5$ 40iB5$  4CiF4Ii55$  N4Li4Mi  NOPQ-iRS TOUiRV  W5>  "  G  "  H464Mi  NOPQ-iRS TOUiRV  W5>  "  G  "  H464Mi  NOPQ-iRS TOUiRV  W5>  "  G  "  H464Mi  NOPQ-iRS TOUiRV  W5>  "  G  4(iiX>  "  G  4,Y5  $  "  Yi $  !46Y4\<WY5>  "  G  "   4_Yi4\bcif gjkvw-         hH      ]4L  >  "  G  4 5$  "  4 4 5>  "  G   C             g  sc
		B g  initargs		B  g  filenamef  string/completion.scm
	U
		W			W		"	W		'	X		,	X		7	X	 		B	   C       h   f   ] O C      ^       g  real-next-method
		
  g  filenamef  string/completion.scm
	U
 		
   Cx5>  "  G  4'i 5 R4(i iy>  "  G  4, 5  $  "   i $  !46 4\<W 5>  "  G  "   4_ i4\bcif gzkwx~-    h     ]
4 5$  "  45$  A445 444	4
4 554 5555>  "  G  "  U$  :445 444	4
4 55555>  "  G  "  4
>  "  G  C            g  sc
	  g  strings	  g  comparison-func		   g  filenamef  string/completion.scm
	b
		c		
	c			c			f		"	f		#	g		-	h		0	h		3	h	%	6	h	-	9	h	;	A	h	-	B	i	-	L	h	%	P	h		R	h		W	g		f	l		j	f		k	m		u	n		x	n		{	n	%	~	n	- 	n	; 	n	- 	n	% 	n	 	n	 	m	 	r	 	r	 	r	! 	r	 $	 	   C5>  "  G  ~     h   x  ]4 545$  !4 5$  	C4 5$  C
C$  4 5$  	CC4
54 5$  	C4 5$  C
C  p      g  partial
	  g  str2	  g  len1		  g  len2		  g  newstr2		c   g  filenamef  string/completion.scm
	v
		w		
	x			w			y			y			y	!	*	y		.	z	!	:	y		C	~		G	y		H	~		T	~		Z 	)	c 		f 	#	r 		v 	#  	 	 	  g  nameg  case-sensitive-partial-compare CR h     ]4 545$  !4 5$  	C4 5$  C
C$  4 5$  	CC4
54 5$  	C4 5$  C
C        g  partial
	  g  str2	  g  len1		  g  len2		  g  newstr2		c   g  filenamef  string/completion.scm
 
	 		
 		 		 		 		 	!	* 		. 	!	: 		C 		G 		H 		T 		Z 	)	c 		f 	#	r 		v 	#  	 	 	  g  nameg   case-insensitive-partial-compare CR- 
      h     ]245$  4 564 54 5$  "  45$  "  4
$  C45
$  "C"  M45$  4	5"  @45
$  "4	5"  ""^C       	      g  	completer
	  g  str	  g  vec		  g  compare		4  g  found		A  g  index		M  g  ans		M  g  cur		]  g  index	   g  ans	   g  cur	    g  filenamef  string/completion.scm
 
	 		
 		 		 		 		 		" 		, 		4 		7 		A 		I 		M 		Q 		U 		] 		] 		` 		j 		n 		q 		v 	*	~ 	  	  	  	"  	"  	1  	(  	$  	(  	3  	(  	1  	.  	*  	9  	E  	.  	.  	"  	9  	7  	"  	  	  	 1	 	  g  nameg  all-completionsg  
documentationf  Returns a list of all possible completions for the given string
@var{str}.  The returned list will be in alphabetical order.

Note that users wanting to customize the completion algorithm 
can subclass @code{<string-completer>} and override this method. C!R4'i"5"R4(i"i>  "  G  4,"5  $  "  "i $  !46"4\<W"5>  "  G  "   _"i4\bcif gkwx!    h   }   ]4M
4L M 55NC u       g  s
		  g  filenamef  string/completion.scm
 		 			 	=	 		 	 		   C 	       h     ]24 54 5$  "  4 5$  "  HHH(  "  2KK4O >  "  G  4J5KJJJD       g  sc
	  g  str	  g  longest-substring		5  g  exact-match?		5  g  unique?		5  g  completions		5  g  s-p-l		5  g  s=?		5   g  filenamef  string/completion.scm
 
	 		 		 		# 		- 		5 		G 		N 	"	P 	
	S 		T 		V 	
	W 	
	r 		w 	"	{ 		} 	
  	 	 	   C56   u      g  m
		, g  t
	Z	v g  t
   g  t
 g  t
 g  t
J_  g  filenamef  string/completion.scm		0
	8	<
	E	=
	J	<
	S	@
I	R	q	@
	R		@
	R			@
-	R	U	@
o	A
t	@
}	U
	[
	\
	[
	b
		v
 
 
( 
5 
: 
C 
 	
   C6 