GOOF----LE-8-2.0(      ] 6 4        h      ] g  guile	 	g  define-module*	 	 	g  string	g  	transform	 		g  filenameS	
f  string/transform.scm	g  importsS	g  ice-9	
g  optargs	
 	 	g  srfi	g  srfi-13	 	 	 	g  exportsS	g  escape-special-chars	g  transform-string	g  expand-tabs	g  
center-string	g  left-justify-string	g  right-justify-string	g  collapse-repeated-chars	 	g  set-current-module	 	  	!g  open-output-string	"g  char?	#g  char=?	$g  
procedure?	%g  string?	&g  string-index	'g  boolean?	(g  throw	)g  bad-type	*f  'expected #t, char, string, or procedure	+g  display	,g  
string-length	-g  	substring	.g  string-for-each	/g  
write-char	0g  get-output-string	1g  make-string	2g  max	3g  
string-append	4g  odd?	5f   C 5     h#     ]4	
5 4  >  "  G   !"# h   _   ]L  6      W       g  c
		
  g  filenamef  string/transform.scm
	L		
	L	% 		
   C$%&       h   _   ]L  6      W       g  c
		
  g  filenamef  string/transform.scm
	P		
	P	% 		
   C'     h   W   ]L C   O       g  c
		  g  filenamef  string/transform.scm
	R	 		   C()*+     h   g   ]4L 5L 6 _       g  c
		  g  filenamef  string/transform.scm
	U			U	,		U	# 		   C+   h   _   ]LL 6      W       g  c
		
  g  filenamef  string/transform.scm
	V		
	V	# 		
   C,+-./   h    w   ]4L 5$  L 6 L 6     o       g  c
		  g  filenamef  string/transform.scm
	^			_		
	_			a			d	 		   C0    hX  )	  - . , 3 #  #  45 45$  O "  F45$  "  545$  O "  45$  O "  	4	
545$  
O "  	
O $  24 5$   44 
5>  "  G  "   "   4O  $  "  
$  "  4 5>  "  G  $  14 5$  44 5>  "  G  "   "   6!	      g  str
	X g  match?	X g  replace		X g  start		X g  end		X g  os		#X g  matcher	 X g  replacer	 X  g  filenamef  string/transform.scm
	$
		J	
	#	J		&	K		0	K		<	M		F	K		M	O		W	K		c	Q		m	K		y	S		}	S	%		S	/ 	S	 	J	 	T	 	T	 	J	 	Y	 	Y	 	Y	 	Y	 	Z	 	Z	 	Z	 	]	 	f		g		g	
	]	!	j	$	j	+	j	/	j	0	k	3	k	B	k	X	m	 (	X		  g  nameg  transform-stringg  
documentationf Uses @var{match?} against each character in @var{str}, and performs a
replacement on each character for which matches are found.

@var{match?} may either be a function, a character, a string, or
@code{#t}.  If @var{match?}  is a function, then it takes a single
character as input, and should return @samp{#t} for matches.
@var{match?} is a character, it is compared to each string character
using @code{char=?}.  If @var{match?} is a string, then any character
in that string will be considered a match.  @code{#t} will cause 
every character to be a match.

If @var{replace} is a function, it is called with the matched
character as an argument, and the returned value is sent to the output
string via @samp{display}.  If @var{replace} is anything else, it is
sent through the output string via @samp{display}.

Note that te replacement for the matched characters does not need to
be a single character.  That is what differentiates this function from
@samp{string-map}, and what makes it useful for applications such as
converting @samp{#\&} to @samp{"&amp;"} in web page text.  Some other
functions in this module are just wrappers around common uses of
@samp{transform-string}.  Transformations not possible with this
function should probably be done with regular expressions.

If @var{start} and @var{end} are given, they control which portion
of the string undergoes transformation.  The entire input string
is still output, though.  So, if @var{start} is @samp{5}, then the
first five characters of @var{str} will still appear in the returned
string.

@lisp
; these two are equivalent...
 (transform-string str #\space #\-) ; change all spaces to -'s
 (transform-string str (lambda (c) (char=? #\space c)) #\-)
@end lisp CR1    h(   q  - . , 3 #  	 	4 56 i      g  str
		' g  tab-size		'  g  filenamef  string/transform.scm
	o
		w		'	u	 		'  g  nameg  expand-tabsg  
documentationf  Returns a copy of @var{str} with all tabs expanded to spaces.  @var{tab-size} defaults to 8.

Assuming tab size of 8, this is equivalent to: @lisp
 (transform-string str #\tab "        ")
@end lisp CR"# h   a   ] L 6      Y       g  c
		
  g  filenamef  string/transform.scm
 		
 	$ 		
   C& h   a   ]L  6      Y       g  c
		
  g  filenamef  string/transform.scm
 		
 	$ 		
   C h   a   ]L  6      Y       g  c
		
  g  filenamef  string/transform.scm
 		
 	  		
   C    h0   %  ] 45$  O "  O O 6          g  str
		, g  
special-chars		, g  escape-char			,  g  filenamef  string/transform.scm
	y
	 		 		, 	 		,	  g  nameg  escape-special-charsg  
documentationf GReturns a copy of @var{str} with all given special characters preceded
by the given @var{escape-char}.

@var{special-chars} can either be a single character, or a string consisting
of all the special characters.

@lisp
;; make a string regexp-safe...
 (escape-special-chars "***(Example String)***"  
                      "[]()/*." 
                      #\\)
=> "\\*\\*\\*\\(Example String\\)\\*\\*\\*"

;; also can escape a singe char...
 (escape-special-chars "richardt@@vzavenue.net"
                      #\@@
                      #\@@)
=> "richardt@@@@vzavenue.net"
@end lisp CR,12#345 	   h     - . , 3 #  	P#   #  4 544	
554$  "  5$  "  !44	
5$  "  5$   C 45$  4$  "  5"  6      g  str
	  g  width	  g  chr		  g  rchr		  g  len		0  g  lpad		G  g  rpad	    g  filenamef  string/transform.scm
 
	* 		0 		3 		6 		= 	+	@ 	!	C 		G 		G 		J 		R 		^ 		b 		i 		l 	 	s 	/	v 	%	y 	 	 	  	  	  	  	  	)  	/  	)  	%  	>  	  	>  	Q  	 "	 	  g  nameg  
center-stringg  
documentationf Returns a copy of @var{str} centered in a field of @var{width}
characters.  Any needed padding is done by character @var{chr}, which
defaults to @samp{#\space}.  If @var{rchr} is provided, then the
padding to the right will use it instead.  See the examples below.
left and @var{rchr} on the right.  The default @var{width} is 80.  The
default @var{lchr} and @var{rchr} is @samp{#\space}.  The string is
never truncated.
@lisp
 (center-string "Richard Todd" 24)
=> "      Richard Todd      "

 (center-string " Richard Todd " 24 #\=)
=> "===== Richard Todd ====="

 (center-string " Richard Todd " 24 #\< #\>)
=> "<<<<< Richard Todd >>>>>"
@end lisp CR,123     hX   D  - . , 3 #  	P#   4 544
55$   C 6       <      g  str
		Q g  width		Q g  chr			Q g  len		'	Q g  pad		;	Q  g  filenamef  string/transform.scm
 
	! 		' 		* 		- 		4 	 	7 		; 		; 		B 		F 		Q 	 
		Q	  g  nameg  left-justify-stringg  
documentationf @code{left-justify-string str [width chr]}.  
Returns a copy of @var{str} padded with @var{chr} such that it is left
justified in a field of @var{width} characters.  The default
@var{width} is 80.  Unlike @samp{string-pad} from srfi-13, the string
is never truncated. CR,123     hX   B  - . , 3 #  	P#   4 544
55$   C 6       :      g  str
		Q g  width		Q g  chr			Q g  len		'	Q g  pad		;	Q  g  filenamef  string/transform.scm
 
	! 		' 		* 		- 		4 	 	7 		; 		; 		B 		F 		Q 	 
		Q	  g  nameg  right-justify-stringg  
documentationf Returns a copy of @var{str} padded with @var{chr} such that it is
right justified in a field of @var{width} characters.  The default
@var{width} is 80.  The default @var{chr} is @samp{#\space}.  Unlike
@samp{string-pad} from srfi-13, the string is never truncated. CR##  h@      ]"  	
N NC4 M5$  4ML 5$  MNMLC""           g  c
		<  g  filenamef  string/transform.scm
 			 		
 		 		 		 		 		) 		, 	&	. 		3 	 		<   C5       hX     - . , 3 #   #  4 5$  A"   
HHO  6      g  str
		X g  chr		X g  num			X g  prev-chr		5	L g  match-count		5	L g  repeat-locator		L	X  g  filenamef  string/transform.scm
 	  		, 		5 	
	L 		V 	*	X 	 		X	  g  nameg  collapse-repeated-charsg  
documentationf Returns a copy of @var{str} with all repeated instances of 
@var{chr} collapsed down to at most @var{num} instances.
The default value for @var{chr} is @samp{#\space}, and 
the default value for @var{num} is 1.

@lisp
 (collapse-repeated-chars "H  e  l  l  o")
=> "H e l l o"
 (collapse-repeated-chars "H--e--l--l--o" #\-)
=> "H-e-l-l-o"
 (collapse-repeated-chars "H-e--l---l----o" #\- 2)
=> "H-e--l--l--o"
@end lisp CRC           g  m
		,  g  filenamef  string/transform.scm		

	$
	o
	y
7 
 
 
#  		#
   C6 