GOOF----LE-8-2.0*      ]  4    hB      ] g  guile	 	g  define-module*	 	 	g  string	g  wrap	 		g  filenameS	
f  string/wrap.scm	g  importsS	g  srfi	
g  srfi-13	
 	 	g  srfi-14	 	 	g  	transform	 	 	g  scheme	g  
documentation	 	 	g  oop	g  goops	 	 	 	g  exportsS	 g  <text-wrapper>	!g  fill-string	"g  string->wrapped-lines	# !" 	$g  set-current-module	%$ 	&$ 	'g  defined?	(' 	)' 	*g  
line-width	+g  is-a?	,+ 	-+ 	.g  	<generic>	/. 	0. 	1g  toplevel-define!	21 	31 	4g  ensure-generic	54 	64 	7g  expand-tabs?	8g  	tab-width	9g  collapse-whitespace?	:g  subsequent-indent	;g  initial-indent	<g  break-long-words?	=g  
make-class	>g  width	?g  
init-valueS	@g  getterS	Ag  init-keywordS	Bg  
line-widthS	Cg  expand-tabs	Dg  expand-tabs?S	Eg  	tab-widthS	Fg  collapse-whitespace	Gg  collapse-whitespace?S	Hf   	Ig  subsequent-indentS	Jg  initial-indentS	Kg  break-long-words?S	Lg  nameS	Mg  <class>	NM 	OM 	Pg  memq	Qg  <object>	RQ 	SQ 	Tg  class-precedence-list	UT 	VT 	Wg  class-redefinition	XW 	YW 	Zg  set-object-property!	[f This class encapsulates the parameters needing to be fed to the text wrapping
algorithm.  The following are the recognized keywords on the call to @code{make}:

@table @code
@item #:line-width
This is the target length used when deciding where to wrap lines.  Default is 80.

@item #:expand-tabs?
Boolean describing whether tabs in the input should be expanded.  Default is #t.

@item #:tab-width
If tabs are expanded, this will be the number of spaces to which they expand.
Default is 8.

@item #:collapse-whitespace?
Boolean describing whether the whitespace inside the existing text
should be removed or not.  Default is #t.

If text is already well-formatted, and is just being wrapped to fit in a different width,
then setting this to @samp{#f}.  This way, many common text conventions (such as
two spaces between sentences) can be preserved if in the original text.  If the input
text spacing cannot be trusted, then leave this setting at the default, and all repeated
whitespace will be collapsed down to a single space.

@item #:initial-indent
Defines a string that will be put in front of the first line of wrapped text.  
Default is the empty string, ``''.

@item #:subsequent-indent
Defines a string that will be put in front of all lines of wrapped
text, except the first one.  Default is the empty string, ``''.

@item #:break-long-words?
If a single word is too big to fit on a line, this setting tells the
wrapper what to do.  Defaults to #t, which will break up long words.
When set to #f, the line will be allowed, even though it is longer
than the defined @code{#:line-width}.
@end table

Here's an example of creating a @code{<text-wrapper>}:
@lisp
 (make <text-wrapper> #:line-width 48 #:break-long-words? #f)
@end lisp	\g  make-generic	]f @code{fill-string str keywds ...}. 
Wraps the text given in string @var{str} according to the parameters
provided in @var{keywds}, or the default setting if they are not
given.  Returns a single string with the wrapped text.  Valid keyword
arguments are discussed with the @code{<text-wrapper>} class.

@code{fill-string tw str}.  fills @var{str} using the instance
of @code{<text-wrapper>} given as @var{tw}.	^g  make	_^ 	`^ 	ag  add-method!	ba 	ca 	dg  <method>	ed 	fd 	gg  specializersS	hg  <top>	ih 	jh 	kg  formalsS	lg  str	mg  keywds	nlm	og  bodyS	pg  string-join	qg  apply	rg  cons	srlm 	tq"s 	uf  
	vg  quote	wg  infix	xvw 	yptux 	zy 	{g  make-procedureS	|g  	procedureS	}g  tw	~}l 	"}l  pux    f U@code{string->wrapped-lines str keywds ...}.  
Wraps the text given in string @var{str} according to the parameters
provided in @var{keywds}, or the default setting if they are not
given.  Returns a list of strings representing the formatted lines.
Valid keyword arguments are discussed with the @code{<text-wrapper>}
class.

@code{string->wrapped-lines tw str}. 
Wraps the text given in string @var{str} according to the given
@code{<text-wrapper>} @var{tw}.  Returns a list of strings representing
the formatted lines.  Valid keyword arguments are discussed with the
@code{<text-wrapper>} class. r m  q^  "l    g  char-set-complement g  char-set:whitespace g  string-index g  	substring g  reverse g  split-by-single-words g  set! g  transform-string g  lambda g  c   g  char=? 
    l   l  g  if 7}  8}  Cl  l    9}  g  collapse-repeated-chars l  l    g  string-trim l  l  g  let g  loop g  ans v    g  words l    g  line ;}    g  count 
    g  null?   g  > 
  r      g  length-left g  - *}  g  
string-length       g  	next-word g  = 
  g  car           g  cond g  <=     g  cdr   g  
string-append   g  +       :}  
    <}  
    r    r  
    g  else r  
             C 5 h    ]4	
#5 4& >  "  G   4)*5  $  "  4-*i05 $  143*464)*5$  *i"  *5>  "  G  "   4)75  $  "  4-7i05 $  1437464)75$  7i"  75>  "  G  "   4)85  $  "  4-8i05 $  1438464)85$  8i"  85>  "  G  "   4)95  $  "  4-9i05 $  1439464)95$  9i"  95>  "  G  "   4):5  $  "  4-:i05 $  143:464):5$  :i"  :5>  "  G  "   4);5  $  "  4-;i05 $  143;464);5$  ;i"  ;5>  "  G  "   4)<5  $  "  4-<i05 $  143<464)<5$  <i"  <5>  "  G  "   "  43 4=i  >?	P@*iAB C?@7iAD 8?	@8iAE F?@9iAG :?H@:iAI ;?H@;iAJ <?@<iAK  L 5>  "  G  "  4) 5$  4- iO5$  4PiS4V i55$  4Y i4=i  >?	P@*iAB C?@7iAD 8?	@8iAE F?@9iAG :?H@:iAI ;?H@;iAJ <?@<iAK  L 5>  "  G  "  "x"  "p"  "h4Zi i[>  "  G  4\i!5!R4Zi!i]>  "  G  4)!5  $  "  !i $  !43!4`0L!5>  "  G  "   4c!i4`fgjjknoz{|p"uw   h       - 1 3 4 ?6             g  str
			 g  keywds			  g  filenamef  string/wrap.scm
	b
		c			d			e			c	 			
   C5>  "  G  4)!5  $  "  !i $  !43!4`0L!5>  "  G  "   4c!i4`fg ij k~o{|p"uw       h      ]4 56     {       g  tw
		 g  str		  g  filenamef  string/wrap.scm
	g
		h			i			j			h	 			   C5>  "  G  4\i"5"R4Zi"i>  "  G  4)"5  $  "  "i $  !43"4`0L"5>  "  G  "   4c"i4`fgjjkno{|"^     h   x   - 1 3 4? 6p       g  str
			 g  keywds			  g  filenamef  string/wrap.scm
	y
		z			z	 			
   C5>  "  G     hp     ])45"  T4 5$  ;4 5$  4 5"4 566
"         g  str
		m g  non-wschars			m g  ans			c g  index			c g  next-non-ws			c g  next-ws		-	]  g  filenamef  string/wrap.scm
	~
								 		 		 		" 		# 		- 	
	5 		6 		C 		M 		P 		[ 		] 		c 	
	c 		d 		m 	 		m  g  nameg  split-by-single-words CR4)"5  $  "  "i $  !43"4`0L"5>  "  G  "   c"i4`fg ij k~o{|       h   \   ] 
6      T       g  c
		
  g  filenamef  string/wrap.scm
 	"	
 	. 		
   C7C89*:<;   hp  H  ]2H4J 5K4 5$  4J4 55K"   4 5$  
4J5K"   4J5K"  (  	
$  	"  64
 545
$  45"  45$  45"
$  4
 5
"k4 5$  544
55454
 5
"+454
 5
"4J54 5
"     @      g  tw
	k g  str	k g  ans		WO g  words		WO g  line		WO g  count		WO g  length-left	 O g  	next-word	 O  g  filenamef  string/wrap.scm
 
	 		 		 		 		 		$ 	!	, 		. 		3 		= 		> 		F 		K 	
	S 		W 		] 		c 		g 		l 		t 		u 		| 	  	  	  	  	  	*  	  	  	  	  	  	
  	  	  	  	  	  	
  	  	  	  	  	
  	  	, 	 	 	 	 	 	, 	- 	8 	; 	< 	O 	O 	P 	Q 	X 	k 	 A	k	   C56          g  m
		, g  t
	4	P g  t
   g  t
  g  t
?[ g  t
 g  t

 g  t
Jf g  t
 g  t
 g  t
  g  t

+
@  g  filenamef  string/wrap.scm		
	-	%
	U	"	V	7	%
	U	"	V		%
D	&
I	%
]	Y
j	Z
o	Y
x	b
	g
	l
	m
	l
	y

#	~

$ 
 	
   C6 